<?php
/**
 * ProductRentalDetails
 *
 * @author    Roja45
 * @copyright 2016 Roja45
 * @license   license.txt
 * @category  ProductRentalDetails
 *
 * 2016 ROJA45 - All rights reserved.
 *
 * DISCLAIMER
 * Changing this file will render any support provided by us null and void.
 */

/**
 * ProductRentalDetails
 *
 * @author    Roja45
 * @copyright 2016 Roja45
 * @license   license.txt
 * @category  Class
 *
 * 2016 ROJA45 - All rights reserved.
 *
 * DISCLAIMER
 * Changing this file will render any support provided by us null and void.
 */

class ProductRentalDetails extends ObjectModel
{
    public $id_roja45_product;
    public $id_shop;
    public $id_shop_default;
    public $id_product;
    public $address;
    public $address_2;
    public $city;
    public $area;
    public $country;
    public $state;
    public $postal_code;
    public $telephone_1;
    public $telephone_2;
    public $url;
    public $email;
    public $lat;
    public $lon;
    public $collection_time;
    public $return_time;
    public $instant_rental;
    public $id_paymentprofile;
    public $id_roja45_product_damagedeposit;
    public $id_roja45_product_overdueaction;
    public $overdue_fine;
    public $minimum_duration;
    public $maximum_duration;
    public $enabled;

    /**
     * @see ObjectModel::$definition
     */
    public static $definition = array(
        'table' => 'roja45_productrental_details',
        'primary' => 'id_roja45_product',
        'multilang' => false,
        'multishop' => true,
        'fields' => array(
            'id_shop_default' => array('type' => self::TYPE_INT, 'validate' => 'isUnsignedId'),
            'id_product' => array('type' => self::TYPE_INT, 'validate' => 'isUnsignedId', 'required' => true),
            'id_paymentprofile' => array('type' => self::TYPE_INT, 'validate' => 'isUnsignedId'),
            'id_roja45_product_damagedeposit' => array('type' => self::TYPE_INT, 'validate' => 'isUnsignedId'),
            'id_roja45_product_overdueaction' => array('type' => self::TYPE_INT, 'validate' => 'isUnsignedId'),
            'address' => array('type' => self::TYPE_STRING, 'validate' => 'isGenericName'),
            'address_2' => array('type' => self::TYPE_STRING, 'validate' => 'isGenericName'),
            'area' => array('type' => self::TYPE_INT, 'validate' => 'isUnsignedId'),
            'city' => array('type' => self::TYPE_STRING, 'validate' => 'isGenericName'),
            'country' => array('type' => self::TYPE_STRING, 'validate' => 'isGenericName'),
            'state' => array('type' => self::TYPE_STRING, 'validate' => 'isGenericName'),
            'postal_code' => array('type' => self::TYPE_STRING, 'validate' => 'isGenericName'),
            'telephone_1' => array('type' => self::TYPE_STRING, 'validate' => 'isGenericName'),
            'telephone_2' => array('type' => self::TYPE_STRING, 'validate' => 'isGenericName'),
            'email' => array('type' => self::TYPE_STRING),
            'url' => array('type' => self::TYPE_STRING),
            'lat' => array('type' => self::TYPE_STRING),
            'lon' => array('type' => self::TYPE_STRING),
            'collection_time' => array('type' => self::TYPE_STRING),
            'return_time' => array('type' => self::TYPE_STRING),
            'instant_rental' => array('type' => self::TYPE_BOOL),
            'overdue_fine' => array('type' => self::TYPE_FLOAT),
            'minimum_duration' => array('type' => self::TYPE_INT, 'validate' => 'isUnsignedId'),
            'maximum_duration' => array('type' => self::TYPE_INT, 'validate' => 'isUnsignedId'),
            'enabled' => array('type' => self::TYPE_BOOL, 'shop'=>true, 'required' => true),
        ),
    );

    public function __construct($id = null, $id_lang = null, $id_shop = null)
    {
        parent::__construct($id, $id_lang, $id_shop);
    }

    public function save($null_values = false, $auto_date = true)
    {
        Shop::addTableAssociation('roja45_productrental_details', array('type' => 'shop'));
        return parent::save($null_values, $auto_date);
    }

    public function delete()
    {
        Shop::addTableAssociation('roja45_productrental_details', array('type' => 'shop'));
        $return = true;
        $models = ProductRentalModel::getModels($this->id);
        foreach ($models as $model) {
            $model = new ProductRentalModel($model['id_roja45_product_model']);
            $return &= $model->delete();
        }
        $return &= parent::delete();
        return $return;
    }

    public function getName($id_lang)
    {
        $product = new Product($this->id_product, false, $id_lang);
        return $product->name;
    }

    public static function isRentable($id_product, $id_shop = null)
    {
        if (!$id_shop) {
            $id_shop = (int) Configuration::get('PS_SHOP_DEFAULT');
        }
        $sql = new DbQuery();
        $sql->select('prd.id_roja45_product');
        $sql->from('roja45_productrental_details', 'prd');
        $sql->leftJoin('roja45_productrental_details_shop', 'prds', 'prd.id_roja45_product=prds.id_roja45_product');
        $sql->where('prd.`id_product`='. (int) $id_product);
        $sql->where('prds.`id_shop`='. (int) $id_shop);
        $sql->where('prds.`enabled`=1');
        return Db::getInstance()->getValue($sql);
    }

    public static function getEnabledProducts($id_shop = null)
    {
        if (!$id_shop) {
            $id_shop = (int) Configuration::get('PS_SHOP_DEFAULT');
        }
        $product_ids = array();
        $sql = new DbQuery();
        $sql->select('id_product');
        $sql->from('roja45_productrental_details', 'prd');
        $sql->leftJoin('roja45_productrental_details_shop', 'prds', 'prd.id_roja45_product = prds.id_roja45_product');
        $sql->where('prds.`enabled` = 1');
        $sql->where('prds.`id_shop` = ' . (int) $id_shop);
        if ($results = Db::getInstance()->executeS($sql)) {
            foreach ($results as $row) {
                $product_ids[$row['id_product']] = $row['id_product'];
            }
        }
        return $product_ids;
    }

    public static function getEnabledRentalProducts($id_shop = null)
    {
        if (!$id_shop) {
            $id_shop = (int) Configuration::get('PS_SHOP_DEFAULT');
        }
        $sql = new DbQuery();
        $sql->select('prd.id_roja45_product');
        $sql->from('roja45_productrental_details', 'prd');
        $sql->leftJoin('roja45_productrental_details_shop', 'prds', 'prd.id_roja45_product = prds.id_roja45_product');
        $sql->where('prds.`enabled` = 1');
        $sql->where('prds.`id_shop` = ' . (int) $id_shop);
        return Db::getInstance()->executeS($sql);
    }

    public static function getRentalProducts($id_lang)
    {
        $sql = new DbQuery();
        $sql->select('prd.id_roja45_product, p.id_product, pl.name');
        $sql->from('roja45_productrental_details', 'prd');
        $sql->leftJoin('product', 'p', '(p.id_product = prd.id_product)');
        $sql->leftJoin('product_lang', 'pl', '(p.id_product = pl.id_product) AND (pl.id_shop = prd.id_shop_default)');
        $sql->orderBy('prd.id_roja45_product ASC');
        $sql->where('pl.`id_lang` = '.(int) $id_lang);
        return Db::getInstance()->executeS($sql);
    }

    public function getRentalProductDetails(
        $collection_date,
        $collection_time = '00:00',
        $return_date,
        $return_time = '00:00',
        $id_lang = null,
        $id_roja45_product_rateduration
    ) {
        $context = Context::getContext();
        $product = new Product($this->id_product, true, (int) $context->language->id);
        $id_main_image = Product::getCover($this->id_product);

        $rental_product_details = array();
        $rates_available = false;

        $rental_product_details['id_roja45_product'] = $this->id_roja45_product;
        $rental_product_details['product'] = $product;
        $rental_product_details['rental_product'] = $this;
        $rental_product_details['id_main_image'] = $id_main_image['id_image'];

        if (Configuration::get('PS_TAX_ADDRESS_TYPE') == 'id_address_invoice') {
            $address_id = (int)$context->cart->id_address_invoice;
        } else {
            $address_id = (int)$context->cart->id_address_delivery;
        }
        if (!Address::addressExists($address_id)) {
            $address_id = null;
        }
        $address = Address::initialize($address_id, true);
        $rental_product_details['address'] = $address;

        $tax_enabled = Configuration::get('PS_TAX');
        $usetax = true;
        if (Tax::excludeTaxeOption()) {
            $usetax = false;
        }

        $tax_calculator = null;
        if ($tax_enabled && $usetax) {
            $id_tax_rules_group = Product::getIdTaxRulesGroupByIdProduct((int) $this->id_product, $context);
            $tax_calculator = TaxManagerFactory::getManager($address, $id_tax_rules_group)->getTaxCalculator();
        }

        $rental_product_details['tax_enabled'] = $tax_enabled;
        $rental_product_details['tax_calculator'] = $tax_calculator;
        $rental_product_details['total_availability'] = 0;

        $collection_datetime = DateTime::createFromFormat(
            $context->language->date_format_lite . ' H:i',
            $collection_date . ' ' . $collection_time
        );
        $collection_date_db = $collection_datetime->format('Y-m-d H:i:s');
        $return_datetime = DateTime::createFromFormat(
            $context->language->date_format_lite . ' H:i',
            $return_date . ' ' . $return_time
        );
        $return_date_db = $return_datetime->format('Y-m-d H:i:s');

        $rate_duration = new ProductRentalRateDuration(
            $id_roja45_product_rateduration,
            (int) $context->language->id
        );

        $duration_type = preg_replace('/\s*/', '', $rate_duration->name);
        $paymentprofile = new ProductRentalPaymentProfile(
            $this->id_paymentprofile,
            (int) $context->language->id
        );

        $rental_product_details['paymentprofile'] = $paymentprofile;
        $image = array();
        $id_image = Product::getCover($this->id_product)['id_image'];
        $imageObj = new Image($id_image, (int)$context->language->id);

        $image_size = Image::getSize(ImageType::getFormatedName('home'));
        $image['title'] = $imageObj->legend;
        $image['width'] = $image_size['width'];
        $image['height'] = $image_size['height'];
        $image['src'] = $context->link->getImageLink(
            $product->link_rewrite,
            $id_image,
            ImageType::getFormatedName('home')
        );
        $product->cover_image = $image;
        $models = ProductRentalModel::getModels(
            $this->id_roja45_product,
            (int) $context->language->id
        );
        $deposit_percentages = array();
        foreach ($models as &$model) {
            $modelObj = new ProductRentalModel(
                $model['id_roja45_product_model'],
                (int)$context->language->id
            );

            $model['collection_date'] = $collection_date;
            $model['collection_time'] = $collection_time;
            $model['collection_db'] = $collection_date_db;
            $model['return_date'] = $return_date;
            $model['return_time'] = $return_time;
            $model['return_db'] = $return_date_db;
            $model['model_name'] = $modelObj->getModelName(
                $context->language->id
            );

            $deposit_percentage = $paymentprofile->getDepositPercentage($collection_date_db);
            $deposit_percentages[] = $deposit_percentage;

            $availability = ProductRentalRental::getAllRentalsForModel(
                $this->id_roja45_product,
                $model['id_roja45_product_model'],
                $collection_date_db,
                $return_date_db
            );

            $model['availability'] = $availability['availability'];
            $rental_product_details['total_availability'] += $availability['availability'];
            $image = array();
            $id_image = Product::getCover($this->id_product)['id_image'];
            if ($model['id_product_attribute']) {
                $combination_image = $product->getCombinationImageById(
                    $model['id_product_attribute'],
                    (int)$context->language->id
                );
                if ($combination_image) {
                    $id_image = $combination_image['id_image'];
                }
            }
            $imageObj = new Image($id_image, (int)$context->language->id);

            $images = array();
            foreach (ImageType::getImagesTypes() as $image_type) {
                $image_size = Image::getSize($image_type['name']);
                $image['title'] = $imageObj->legend;
                $image['width'] = $image_size['width'];
                $image['height'] = $image_size['height'];
                $image['src'] = $context->link->getImageLink(
                    $product->link_rewrite,
                    $id_image,
                    $image_type['name']
                );
                $images[$image_type['name']] = $image;
            }

            if (version_compare(_PS_VERSION_, '1.7', '>=') == true) {
                $model['image'] = $images[ImageType::getFormatedName('cart')];
            } else {
                $model['image'] = $images[ImageType::getFormatedName('medium')];
            }

            $model['images'] = $images;
            $model['has_seasonal_rates'] = 0;

            $groups = null;
            if (isset($context->customer)) {
                $groups = Customer::getGroupsStatic((int)$context->customer->id);
            }
            $rates = ProductRentalRate::getRates(
                $this->id_roja45_product,
                $model['id_roja45_product_model'],
                (int)$context->language->id,
                $groups,
                $id_roja45_product_rateduration
            );
            foreach ($rates as &$rate) {
                $tag = '';
                $rate['rate_name'] = $rate['name'];
                $rate['totals'] = array();
                $rate['total_deposits'] = array();
                $rate['periods'] = $rate_duration->getPeriods(
                    $collection_date . ' ' . $collection_time,
                    $return_date . ' ' . $return_time,
                    $context->language->date_format_lite . ' H:i'
                );

                $rate['periods'] = ProductRentalPriceRule::processPriceRules(
                    $this->id_roja45_product,
                    $rate['periods']
                );

                $rate['rate_formatted'] = Tools::displayPrice(
                    Tools::convertPrice($rate['rate'])
                );
                $rate['duration_type'] = Tools::strtolower($duration_type);
                $current_date = DateTime::createFromFormat(
                    $context->language->date_format_lite,
                    $collection_date
                );
                $total_discount = 0;
                $total_original_rate = 0;
                $total_rate = 0;
                $total_rate_inc = 0;
                foreach ($rate['periods'] as $offset => &$period) {
                    $unit_price = (float)($rate['rate']);
                    $current_discount = ProductRentalDiscount::getDiscount(
                        $this->id_roja45_product,
                        $period->period,
                        true,
                        $offset
                    );
                    $rate['special_rate'] = false;
                    //$period->period_name = $current_date->format('D');
                    $period->special_rate = 0;
                    if ((int) Configuration::get('ROJA45_PRODUCTRENTAL_USEPERIODPRICING')) {
                        if ($special_rate = ProductRentalPeriodRate::getPricePeriodForDate(
                            $this->id_roja45_product,
                            $rate['id_parent'],
                            $rate['id_roja45_product_ratetype'],
                            $context->language->id,
                            $period->period
                        )) {
                            $unit_price = (float)($special_rate[0]['rate']);
                            $tag = $special_rate[0]['name'];
                            $rate['special_rate'] = true;
                            $model['has_seasonal_rates'] = 1;
                            $period->special_rate = 1;
                        }
                    } else {
                        if ($id_roja45_product_daterate = ProductRentalDateRate::exists(
                            $this->id_roja45_product,
                            $rate['id_parent'],
                            $rate['id_roja45_product_rate'],
                            $period->period
                        )) {
                            $date_rate = new ProductRentalDateRate($id_roja45_product_daterate);
                            $unit_price = (float) $date_rate->rate;
                            $tag = '';
                            $rate['special_rate'] = true;
                            $model['has_seasonal_rates'] = 1;
                            $period->special_rate = 1;
                        }
                    }
                    $period->rate = $unit_price;
                    $period->original_rate = $unit_price;
                    $period->original_rate_formatted = Tools::displayPrice(
                        Tools::convertPrice($period->original_rate)
                    );
                    $total_original_rate += $unit_price;

                    // Special rules.
                    $period->modified_rate = $unit_price;
                    $period->rule_discount = 0;
                    if (isset($period->rule_modifier) && $period->rule_modifier) {
                        $period->rule_discount = $period->rate * ($period->rule_modifier/100);
                        $period->modified_rate = $period->rate - $period->rule_discount;
                    }

                    $discount_for_rate = 0;
                    $discount_rate_value = $unit_price;
                    if ($current_discount) {
                        $discount_for_rate = $unit_price * ($current_discount/100);
                        $discount_rate_value = $unit_price - $discount_for_rate;
                    }

                    if ($discount_rate_value <= $period->modified_rate) {
                        $discount_for_rate = $discount_for_rate;
                        $period->rate = $discount_rate_value;
                    } else {
                        $discount_for_rate = $period->rule_discount;
                        $period->rate = $period->modified_rate;
                    }

                    $total_discount += $discount_for_rate;

                    $period->discount = $discount_for_rate;
                    $period->discount_formatted = Tools::displayPrice(
                        Tools::convertPrice($period->discount)
                    );
                    if ($tax_enabled && $usetax) {
                        $period->rate_inc = $tax_calculator->addTaxes($period->rate);
                        $period->rate_inc_formatted = Tools::displayPrice(
                            Tools::convertPrice($period->rate_inc)
                        );
                        $total_rate_inc += $period->rate_inc;
                    }
                    $period->rate_formatted = Tools::displayPrice(
                        Tools::convertPrice($period->rate)
                    );
                    $total_rate += $period->rate;
                    $period->tag = $tag;
                }

                $rate['total_original_rate'] = $total_original_rate;
                $rate['total_rate'] = $total_rate;
                $rate['total_rate_inc'] = $total_rate_inc;
                $rate['total_discount'] = $total_discount;

                $rate['total_original_rate_formatted'] = Tools::displayPrice(
                    Tools::convertPrice($rate['total_original_rate'])
                );
                $rate['total_rate_formatted'] = Tools::displayPrice(
                    Tools::convertPrice($rate['total_rate'])
                );
                $rate['total_rate_inc_formatted'] = Tools::displayPrice(
                    Tools::convertPrice($rate['total_rate_inc'])
                );
                $rate['total_discount_formatted'] = Tools::displayPrice(
                    Tools::convertPrice($rate['total_discount'])
                );
                if (count($rates) > 0) {
                    $rates_available = true;
                }
            }
            $model['rates'] = $rates;

            if ($rates_available) {
                usort(
                    $model['rates'],
                    array($this, 'sortByRateValue')
                );
            }

            $extras = ProductRentalModelExtra::getExtrasForModel(
                $model['id_roja45_product_model'],
                $context->language->id
            );
            if (count($extras) > 0) {
                foreach ($extras as &$extra) {
                    $extra['deposit'] = ($extra['rate'] * ($deposit_percentage / 100));
                    if ($tax_enabled && $usetax) {
                        $extra['tax'] = $tax_calculator->addTaxes($extra['rate']) - $extra['rate'];
                        $extra['deposit_tax'] = $tax_calculator->addTaxes($extra['deposit']) - $extra['deposit'];
                    } else {
                        $extra['tax'] = 0;
                        $extra['deposit_tax'] = 0;
                    }
                    $extra['rate_formatted'] = Tools::displayPrice(Tools::convertPrice($extra['rate']));
                    if ($tax_enabled && $usetax) {
                        $extra['rate_inc'] = $tax_calculator->addTaxes($extra['rate']);
                        $extra['rate_inc_formatted'] = Tools::displayPrice(
                            Tools::convertPrice($extra['rate_inc'])
                        );
                    } else {
                        $extra['rate_inc'] = $extra['rate'];
                        $extra['rate_inc_formatted'] = Tools::displayPrice(
                            Tools::convertPrice($extra['rate_inc'])
                        );
                    }
                    $extra['deposit_formatted'] = Tools::displayPrice(Tools::convertPrice($extra['deposit']));
                    if (!empty($extra['image'])) {
                        $image_url = _PS_MODULE_DIR_.'roja45productrental/views/img/'.$extra['image'];
                    } else {
                        $image_url = _PS_MODULE_DIR_.'roja45productrental/views/img/en.jpg';
                    }
                    $image_url = ImageManager::thumbnail(
                        $image_url,
                        $this->table.'_'.(int) $extra['id_roja45_product_extra'].'.jpg',
                        350,
                        'jpg',
                        true,
                        true
                    );
                    $extra['image_url'] = $image_url;
                }
                $model['addons'] = $extras;
            }
        }
        $deposit_percentage = 0;
        if (count($deposit_percentages)) {
            foreach ($deposit_percentages as $percentage) {
                $deposit_percentage += $percentage;
            }
            $rental_product_details['deposit_percentage'] = $deposit_percentage/count($deposit_percentages);
        }

        $rental_product_details['rates_available'] = $rates_available;
        $rental_product_details['models'] = $models;

        return $rental_product_details;
    }

    public static function getStockOnHand($id_roja45_product, $id_roja45_product_model = null)
    {
        $stock_on_hand = 0;
        $rental_product = new ProductRentalDetails($id_roja45_product);
        $product = new Product($rental_product->id_product);
        foreach (ProductRentalModel::getModels($rental_product->id_roja45_product) as &$model) {
            if (!$id_roja45_product_model || ($id_roja45_product_model && $model['id_roja45_product_model'] == $id_roja45_product_model)) {
                if (!$model['is_linked']) {
                    $stock_on_hand += $model['qty_available'];
                } else {
                    if (Configuration::get('PS_ADVANCED_STOCK_MANAGEMENT') &&
                        (int)$product->advanced_stock_management == 1) {
                        $warehouse_list = Warehouse::getProductWarehouseList(
                            $rental_product->id_product,
                            $model['id_product_attribute'],
                            Context::getContext()->shop->id_shop
                        );
                        if (count($warehouse_list) == 0) {
                            $warehouse_list = Warehouse::getProductWarehouseList(
                                $rental_product->id_product,
                                $model['id_product_attribute']
                            );
                        }
                        $warehouse_in_stock = array();
                        $manager = StockManagerFactory::getManager();

                        foreach ($warehouse_list as $warehouse) {
                            $product_real_quantities = $manager->getProductRealQuantities(
                                $rental_product->id_product,
                                $model['id_product_attribute'],
                                array($warehouse['id_warehouse']),
                                true
                            );

                            if ($product_real_quantities > 0 || Pack::isPack((int)$rental_product->id_product)) {
                                $warehouse_in_stock[] = $warehouse;
                            }
                            $stock_on_hand += $product_real_quantities;
                        }
                    } else {
                        $stock_on_hand += StockAvailable::getQuantityAvailableByProduct(
                            $rental_product->id_product,
                            $model['id_product_attribute'],
                            (int)Context::getContext()->shop->id
                        );
                    }
                }
            }
        }
        return $stock_on_hand;
    }

    public function getCombinationStockOnHand()
    {
        $stock_on_hand = array();
        $product = new Product($this->id_product);
        foreach (ProductRentalModel::getModels($this->id_roja45_product) as &$model) {
            if (Configuration::get('PS_ADVANCED_STOCK_MANAGEMENT') &&
                (int)$product->advanced_stock_management == 1) {
                $warehouse_list = Warehouse::getProductWarehouseList(
                    $this->id_product,
                    $model['id_product_attribute'],
                    Context::getContext()->shop->id_shop
                );
                if (count($warehouse_list) == 0) {
                    $warehouse_list = Warehouse::getProductWarehouseList(
                        $this->id_product,
                        $model['id_product_attribute']
                    );
                }
                $warehouse_in_stock = array();
                $manager = StockManagerFactory::getManager();

                foreach ($warehouse_list as $warehouse) {
                    $product_real_quantities = $manager->getProductRealQuantities(
                        $this->id_product,
                        $model['id_product_attribute'],
                        array($warehouse['id_warehouse']),
                        true
                    );

                    if ($product_real_quantities > 0 || Pack::isPack((int)$this->id_product)) {
                        $warehouse_in_stock[] = $warehouse;
                    }
                    $stock_on_hand += $product_real_quantities;
                }
            } else {
                $stock_on_hand += StockAvailable::getQuantityAvailableByProduct(
                    $this->id_product,
                    $model['id_product_attribute'],
                    (int)Context::getContext()->shop->id
                );
            }
            $stock_on_hand[$model['id_product_attribute']] = $stock_on_hand;
        }
        return $stock_on_hand;
    }

    public function initialiseRental($id_product)
    {
        $product = new Product($id_product, false);
        if ($product->reference == 'product_rental_deposit') {
            return true;
        }
        if ($product->reference == 'product_rental_payment') {
            return true;
        }

        $context = Context::getContext();
        $this->id_product = $id_product;
        $this->enabled = 1;
        $this->id_paymentprofile = 1;
        $this->instant_rental = 1;
        $this->minimum_duration = Configuration::get('ROJA45_PRODUCTRENTAL_MINIMUM_DURATION');
        $this->maximum_duration = Configuration::get('ROJA45_PRODUCTRENTAL_MAXIMUM_DURATION');
        $this->collection_time = Configuration::get('ROJA45_PRODUCTRENTAL_COLLECTIONTIME');
        $this->return_time = Configuration::get('ROJA45_PRODUCTRENTAL_RETURNTIME');
        $this->id_roja45_product_overdueaction = Configuration::get('ROJA45_PRODUCTRENTAL_DEFAULTOVERDUERENTALACTION');
        $this->id_shop = Shop::isFeatureActive() && Shop::getContext() == Shop::CONTEXT_SHOP ? (int)$context->shop->id : Configuration::get('PS_SHOP_DEFAULT');
        $this->id_shop_default = Configuration::get('PS_SHOP_DEFAULT');

        if ($return = $this->save()) {
            $combinations = $product->getAttributeCombinations($context->language->id);
            if (count($combinations)>0) {
                $models = array();
                foreach ($combinations as $combination) {
                    if (!isset($models[$combination['id_product_attribute']])) {
                        $models[$combination['id_product_attribute']]['id_product_attribute'] =
                            $combination['id_product_attribute'];
                        $models[$combination['id_product_attribute']]['quantity'] = $combination['quantity'];
                        $models[$combination['id_product_attribute']]['price'] = $combination['price'];
                    }
                }
                foreach ($models as $model) {
                    $modelObj = new ProductRentalModel();
                    $modelObj->id_roja45_product = $this->id;
                    $modelObj->id_product_attribute = $model['id_product_attribute'];
                    $modelObj->is_linked = 1;
                    $modelObj->enabled = 1;
                    if ($return &= $modelObj->save()) {
                        $sql = new DbQuery();
                        $sql->select('rt.id_roja45_product_ratetype');
                        $sql->from('roja45_productrental_ratetype', 'rt');
                        $sql->orderBy('rt.id_roja45_product_ratetype ASC');
                        $id_roja45_product_ratetype = Db::getInstance()->getValue($sql);
                        $combination_price = (float)$product->price + (float) $model['price'];
                        $rate = new ProductRentalRate();
                        $rate->id_roja45_product = $this->id;
                        $rate->id_parent = $modelObj->id;
                        $rate->rate = (float)$combination_price;
                        $rate->id_type = $id_roja45_product_ratetype;
                        $rate_type = new ProductRentalRateType(1);
                        $rate->name = $rate_type->name;
                        $rate->description = $rate_type->description;
                        $return &= $rate->save();
                    }
                }
            } else {
                $modelObj = new ProductRentalModel();
                $modelObj->id_roja45_product = $this->id;
                //$modelObj->rate_type = ProductRentalRateType::DAILY;
                $modelObj->is_linked = 1;
                $modelObj->enabled = 1;
                if ($modelObj->save()) {
                    $rate = new ProductRentalRate();
                    $rate->id_roja45_product = $this->id;
                    $rate->id_parent = $modelObj->id;
                    $rate->rate = (float)$product->price;
                    $rate->id_type = 1;
                    $rate_type = new ProductRentalRateType(1);
                    $rate->name = $rate_type->name;
                    $rate->description = $rate_type->description;
                    $return &= $rate->save();
                }
            }

            $extras = ProductRentalExtra::getExtras();
            $models = ProductRentalModel::getModels($this->id);
            foreach ($models as $model) {
                foreach ($extras as $extra) {
                    $id_roja45_product_extralink = ProductRentalModelExtra::getModelExtra(
                        $extra['id_roja45_product_extra'],
                        $model['id_roja45_product_model']
                    );

                    $product_model_extra = new ProductRentalModelExtra($id_roja45_product_extralink);
                    if ((int) $extra['enabled']) {
                        $product_model_extra->id_roja45_product_extra = $extra['id_roja45_product_extra'];
                        $product_model_extra->id_roja45_product_model = $model['id_roja45_product_model'];
                        $product_model_extra->rate = $extra['rate'];
                        $product_model_extra->enabled = (int) $extra['enabled'];
                        $product_model_extra->save();
                    } else if (Validate::isLoadedObject($product_model_extra)) {
                        $product_model_extra->delete();
                    }
                }
            }
            Roja45ProductRental::clearAllCached();
        }
        return $return;
    }

    public function getLocalTaxes()
    {
        $taxes = array();
        $postcode = 0;

        $type = Product::getIdTaxRulesGroupByIdProduct((int)$this->id_product);

        $rows = Db::getInstance()->executeS('
            SELECT tr.*
            FROM `' . _DB_PREFIX_ . 'tax_rule` tr
            JOIN `' . _DB_PREFIX_ . 'tax_rules_group` trg ON (tr.`id_tax_rules_group` = trg.`id_tax_rules_group`)
            WHERE trg.`active` = 1
            AND tr.`id_country` = ' . (int)$this->property_country . '
            AND tr.`id_tax_rules_group` = ' . (int)$type . '
            AND tr.`id_state` IN (0, ' . (int)$this->property_state . ')
            AND (\'' . pSQL($postcode) . '\' BETWEEN tr.`zipcode_from` AND tr.`zipcode_to`
                OR (tr.`zipcode_to` = 0 AND tr.`zipcode_from` IN(0, \'' . pSQL($postcode) . '\')))
            ORDER BY tr.`zipcode_from` DESC, tr.`zipcode_to` DESC, tr.`id_state` DESC, tr.`id_country` DESC');

        $behavior = 0;
        $first_row = true;

        foreach ($rows as $row) {
            $tax = new Tax((int)$row['id_tax']);
            $taxes[] = $tax;

            // the applied behavior correspond to the most specific rules
            if ($first_row) {
                $behavior = $row['behavior'];
                $first_row = false;
            }

            if ($row['behavior'] == 0) {
                break;
            }
        }
        $result = new TaxCalculator($taxes, $behavior);

        return $result;
    }

    public static function search(
        $id_lang,
        $expr,
        $page_number = 1,
        $page_size = 1,
        $order_by = 'position',
        $order_way = 'desc',
        $ajax = false,
        $remove_filtered = true
    ) {

        if ($page_number < 1) {
            $page_number = 1;
        }
        if ($page_size < 1) {
            $page_size = 1;
        }
        if ($ajax) {
        }

        if (!Validate::isOrderBy($order_by) || !Validate::isOrderWay($order_way)) {
            return false;
        }

        if ($order_by == 'position') {
            $order_by = 'id_product';
        }

        $rental_products = Product::getProducts(
            $id_lang,
            0,
            0,
            $order_by,
            $order_way,
            false,
            true
        );

        $categories = null;
        if (isset($expr['id_category']) && $expr['id_category']) {
            //$categories = Property::getSubCategories($expr['id_category']);
        }

        $requested_qty = $expr['ROJA45_PRODUCTRENTAL_REQUESTED_QTY'];
        $total_rental_products = 0;
        $eligible_rental_products = 0;
        $ineligible_rental_products = array();
        foreach ($rental_products as $key => &$rental_product) {
            if ($id_roja45_product = ProductRentalDetails::isRentable($rental_product['id_product'])) {
                $rejected = false;
                $rentalObj = new ProductRentalDetails($id_roja45_product);
                $rental_product['id_roja45_product'] = $id_roja45_product;
                $productObj = new Product($rental_product['id_product'], true, $id_lang);

                if (isset($categories)) {
                    $product_categories = $productObj->getCategories();
                    if (count($product_categories)) {
                        $result = array_intersect($categories, $product_categories);
                    } else {
                        $result = $categories;
                    }

                    if (!count($result)) {
                        unset($rental_products[$key]);
                        continue;
                    }
                }

                $image = Product::getCover($rental_product['id_product']);
                $rental_product['id_image'] = $image['id_image'];

                $total_rental_products++;
                $eligible_rental_products++;

                $productObj->getAccessories($id_lang, true);
                $rental_product = $productObj->getProductsProperties($id_lang, array($rental_product))[0];

                $rental_product['filtered'] = 0;
                $rental_product['filtered_reason'] = array();

                if (isset($expr['ROJA45_PRODUCTRENTAL_COLLECTION_DATE']) &&
                    isset($expr['ROJA45_PRODUCTRENTAL_RETURN_DATE'])
                ) {
                    $availability = ProductRentalRental::getAvailability(
                        $id_roja45_product
                    );

                    $start_date = DateTime::createFromFormat(
                        'Y-m-d',
                        $expr['ROJA45_PRODUCTRENTAL_COLLECTION_DATE']
                    );
                    $end_date = DateTime::createFromFormat(
                        'Y-m-d',
                        $expr['ROJA45_PRODUCTRENTAL_RETURN_DATE']
                    );
                    $period = new DatePeriod(
                        $start_date,
                        new DateInterval('P1D'),
                        $end_date
                    );
                    $periods = iterator_to_array($period);
                    $rental_product['available'] = ProductRentalDetails::getStockOnHand(
                        $rental_product['id_roja45_product']
                    );
                    $number_of_days = count($periods);

                    if ($rental_product['available'] == 0) {
                        $rental_product['filtered'] = 1;
                        $rental_product['filtered_reason'][] = 'AVAILABILITY';
                        $rejected = true;
                    } elseif ($rental_product['available'] < $requested_qty) {
                        $rental_product['filtered'] = 1;
                        $rental_product['filtered_reason'][] = 'INSUFFICIENT_QTY';
                        $rejected = true;
                    }

                    foreach ($availability as $rental) {
                        $dates_available = 1;
                        foreach ($periods as $date) {
                            $date = $date->format('Y-m-d');
                            if (isset($rental['dates']) && array_key_exists($date, $rental['dates'])) {
                                if (isset($rental['dates'][$date]['total_rented']) &&
                                    $rental['dates'][$date]['type'] != 3 &&
                                    (int) $rental['dates'][$date]['total_rented'] >= (int)$rental['total_available']) {
                                    $dates_available = 0;
                                    break;
                                }
                            }
                        }
                    }
                    if (!$dates_available) {
                        $rental_product['filtered'] = 1;
                        $rental_product['filtered_reason'][] = 'DATES_UNAVAILABLE';
                        $rejected = true;
                    }

                    if ($rentalObj->minimum_duration && $number_of_days < $rentalObj->minimum_duration) {
                        $rental_product['filtered'] = 1;
                        $rental_product['filtered_reason'][] = 'MINIMUM_DURATION';
                        $rejected = true;
                    }

                    if ($rentalObj->maximum_duration && $number_of_days > $rentalObj->maximum_duration) {
                        $rental_product['filtered'] = 1;
                        $rental_product['filtered_reason'][] = 'MAXIMUM_DURATION';
                        $rejected = true;
                    }
                }

                if ($rejected) {
                    $ineligible_rental_products[] = $rental_product;
                    unset($rental_products[$key]);
                }
            } else {
                unset($rental_products[$key]);
            }
        }

        if (!$remove_filtered) {
            $results = array_merge($rental_products, $ineligible_rental_products);
        } else {
            $results = $rental_products;
            $eligible_rental_products -= count($ineligible_rental_products);
        }
        $rental_products = array_slice($results, ($page_number - 1) * $page_size, $page_size);
        if ($total_rental_products) {
            return array(
                'total' => $total_rental_products,
                'eligible' => $eligible_rental_products,
                'result' => $rental_products,
                'all' => $results,
                'filtered' => $ineligible_rental_products
            );
        } else {
            return array(
                'total' => 0,
                'eligible' => 0,
                'result' => array(),
                'all' => array(),
                'filtered' => array()
            );
        }
    }
    
    private function sortByRateValue($x, $y)
    {
        return $x['rate'] - $y['rate'];
    }
}
