<?php
/**
 * PropertyDiscount
 *
 * @author    Roja45
 * @copyright 2016 Roja45
 * @license   license.txt
 * @category  PropertyDiscount
 *
 * 2016 ROJA45 - All rights reserved.
 *
 * DISCLAIMER
 * Changing this file will render any support provided by us null and void.
 */

/**
 * PropertyDiscount
 *
 * @author    Roja45
 * @copyright 2016 Roja45
 * @license   license.txt
 * @category  Class
 *
 * 2016 ROJA45 - All rights reserved.
 *
 * DISCLAIMER
 * Changing this file will render any support provided by us null and void.
 */
class ProductRentalDiscount extends ObjectModel
{
    public $id_roja45_product_discount;
    public $name;
    public $reduction_type;
    public $start_date;
    public $end_date;
    public $enabled;
    public $date_add;
    public $date_upd;
    const TYPE_PERCENTAGE = 'TYPE_PERCENTAGE';
    const TYPE_AMOUNT = 'TYPE_AMOUNT';

    /**
     * @see ObjectModel::$definition
     */
    public static $definition = array(
        'table' => 'roja45_productrental_discount',
        'primary' => 'id_roja45_product_discount',
        'fields' => array(
            'name' => array('type' => self::TYPE_STRING, 'validate' => 'isGenericName', 'required' => true),
            'reduction_type' => array('type' => self::TYPE_STRING, 'validate' => 'isGenericName', 'required' => true),
            'start_date' => array('type' => self::TYPE_DATE, 'validate' => 'isDateFormat', 'required' => false),
            'end_date' => array('type' => self::TYPE_DATE, 'validate' => 'isDateFormat', 'required' => false),
            'enabled' => array('type' => self::TYPE_BOOL),
            'date_add' => array('type' => self::TYPE_DATE, 'validate' => 'isDateFormat', 'required' => false),
            'date_upd' => array('type' => self::TYPE_DATE, 'validate' => 'isDateFormat', 'required' => false),
        ),
    );

    public function delete()
    {
        $this->deleteConditions();
        Db::getInstance()->execute('
            DELETE FROM ' . _DB_PREFIX_ . 'roja45_productrental_discount
            WHERE id_roja45_product_discount=' . (int)$this->id);

        return parent::delete();
    }

    public function duplicate()
    {
        $discount = $this->duplicateObject();
        $this->duplicateDiscounts($discount->id);
    }

    public function apply($products = false)
    {
        $this->resetDiscounts($products);
        $products = $this->getAffectedProducts($products);
        foreach ($products as $product) {
            ProductRentalDiscount::applyRuleToProduct((int)$this->id, (int)$product['id_roja45_product']);
        }
    }

    public function resetDiscounts($products = false)
    {
        $where = '';
        if ($products && count($products)) {
            $where .= ' AND id_roja45_product IN (' . implode(', ', array_map('intval', $products)) . ')';
        }

        return Db::getInstance()->execute(
            'DELETE FROM ' . _DB_PREFIX_ . 'roja45_productrental_productdiscount 
            WHERE id_roja45_product_discount=' . (int)$this->id . $where
        );
    }

    public function addConditions($conditions)
    {
        $result = Db::getInstance()->insert(
            'roja45_productrental_discountconditiongroup',
            array(
                'id_roja45_product_discount' => (int)$this->id
            )
        );
        if (!$result) {
            return false;
        }
        $id_roja45_prodcuct_discountconditiongroup = (int)Db::getInstance()->Insert_ID();
        foreach ($conditions as $condition) {
            $new_condition = new ProductRentalDiscountCondition();
            $new_condition->id_roja45_product_discountconditiongroup = (int)$id_roja45_prodcuct_discountconditiongroup;
            $new_condition->type = pSQL($condition['type']);
            $new_condition->value = (float)$condition['value'];
            if (!$new_condition->save()) {
                return false;
            }
        }
        return true;
    }

    public function addDiscountProfile($discount_profile)
    {
        if ($discount_profile['id'] > 0) {
            $new_discount = new ProductRentalDiscountProfile($discount_profile['id']);
        } else {
            $new_discount = new ProductRentalDiscountProfile();
        }

        $new_discount->id_roja45_product_discount = $this->id;
        //$new_discount->days = $discount_profile['days'];
        $new_discount->period_start = $discount_profile['period_start'];
        $new_discount->period_end = $discount_profile['period_end'];
        $new_discount->position = $discount_profile['position'];
        $new_discount->value = $discount_profile['value'];
        $new_discount->save();
        return true;
    }

    public function deleteDiscountProfile($id_discount)
    {
        $discount = new ProductRentalDiscountProfile($id_discount);
        $discount->delete();
    }

    public function deleteConditions()
    {
        ProductRentalDiscountCondition::deleteConditions((int)$this->id);
    }

    public function getConditions()
    {
        $conditions = ProductRentalDiscountCondition::getConditions((int)$this->id);
        $conditions_group = array();
        if ($conditions) {
            foreach ($conditions as &$condition) {
                $conditions_group[(int)$condition['id_roja45_product_discountconditiongroup']][] = $condition;
            }
        }
        return $conditions_group;
    }

    public function getDiscounts()
    {
        $discounts = ProductRentalDiscountProfile::getDiscounts((int)$this->id);
        if ($discounts && count($discounts)) {
            return $discounts;
        } else {
            return false;
        }
    }

    public function duplicateDiscounts($id_roja45_product_discount)
    {
        if ($discounts = ProductRentalDiscountProfile::getDiscounts((int)$this->id)) {
            foreach ($discounts as $discount) {
                $discount = new ProductRentalDiscountProfile($discount['id_roja45_product_discountprofile']);
                $discount->id = null;
                $discount->id_roja45_product_discount = $id_roja45_product_discount;
                $discount->add();
            }
        }
    }

    public function getAffectedProducts()
    {
        $conditions_group = $this->getConditions();

        $result = array();
        if ($conditions_group) {
            foreach ($conditions_group as $condition_group) {
                $query = new DbQuery();
                $query->select('rp.`id_roja45_product`');
                $query->from('roja45_productrental_details', 'rp');

                $joined = false;
                foreach ($condition_group as $id_condition => $condition) {
                    if ($condition['type'] == 'roja45product') {
                        $query->where('rp.`id_roja45_product` = ' . (int)$condition['value']);
                    } elseif ($condition['type'] == 'category') {
                        /*
                        if (!$joined) {
                            $query->leftJoin('product', 'p', 'rp.id_product = p.id_product');
                            $query->leftJoin('category_product', 'p', 'rp.id_product = p.id_product');
                            $joined = true;
                        }*/
                        $query->leftJoin('product', 'p', 'rp.id_product = p.id_product');
                        $query->leftJoin(
                            'category_product',
                            'cp' . (int) $id_condition,
                            'p.`id_product` = cp' . (int) $id_condition . '.`id_product`'
                        )->where('cp' . (int) $id_condition . '.id_category = ' . (int) $condition['value']);
                        //$query->where('p.`id_category_default` = ' . (int)$condition['value']);
                    }
                }
                $result = array_merge($result, Db::getInstance()->executeS($query));
            }
        }

        return $result;
    }

    public function dateValid($date_to_check, $include_time)
    {
        $date_to_check = strtotime($date_to_check);
        $from = strtotime($this->start_date);
        $until = strtotime($this->end_date);
        if (!$include_time) {
            $date = new DateTime($this->start_date);
            $date->setTime(0, 0, 0);
            $from = strtotime($date->format('Y-m-d'));
            $date = new DateTime($this->end_date);
            $date->setTime(0, 0, 0);
            $until = strtotime($date->format('Y-m-d'));
        }

        return (($date_to_check >= $from) && ($date_to_check <= $until));
    }

    public static function applyRuleToProduct($id_roja45_product_discount, $id_roja45_product)
    {
        $sql = new DbQuery();
        $sql->select('pd.`id_roja45_product_productdiscount`');
        $sql->from('roja45_productrental_productdiscount', 'pd');
        $sql->where('pd.`id_roja45_product` = ' . (int)$id_roja45_product);
        $sql->where('pd.`id_roja45_product_discount` = ' . (int)$id_roja45_product_discount);
        if (Db::getInstance()->getValue($sql)) {
            return false;
        }

        return Db::getInstance()->insert(
            'roja45_productrental_productdiscount',
            array(
                'id_roja45_product' => (int)$id_roja45_product,
                'id_roja45_product_discount' => (int)$id_roja45_product_discount
            )
        );
    }

    public static function getDiscount(
        $id_roja45_product,
        $date,
        $enabled = true,
        $offset = null
    ) {
        //dump("day number: " . $offset);
        $sql = new DbQuery();
        $sql->select('pd.`id_roja45_product_discount`');
        $sql->from('roja45_productrental_productdiscount', 'pd');
        $sql->leftJoin(
            'roja45_productrental_discount',
            'd',
            'pd.id_roja45_product_discount = d.id_roja45_product_discount'
        );
        $sql->where('pd.`id_roja45_product` = ' . (int)$id_roja45_product);
        $sql->where('d.`enabled` = ' . (int)$enabled);

        if ($id_roja45_product_discount = Db::getInstance()->getValue($sql)) {
            $discount = new ProductRentalDiscount($id_roja45_product_discount);
            $d1 = new DateTime($date . ' 00:00:00');
            if ($discount->start_date != '0000-00-00 00:00:00') {
                $d2 = new DateTime($discount->start_date);
                if ($d1 < $d2) {
                    return false;
                }
            }
            if ($discount->end_date != '0000-00-00 00:00:00') {
                $d2 = new DateTime($discount->end_date);
                if ($d1 > $d2) {
                    return false;
                }
            }
            $sql = new DbQuery();
            $sql->select('dp.value');
            $sql->from('roja45_productrental_discountprofile', 'dp');
            $sql->where('dp.`id_roja45_product_discount` = ' . (int)$id_roja45_product_discount);
            $sql->where((int) ($offset+1) . ' >= dp.`period_start`');
            $sql->where((int) ($offset+1) . ' <= dp.`period_end`');
            //dump($sql);
            if ($result = Db::getInstance()->getValue($sql)) {
                return $result;
            } else {
                return false;
            }
        } else {
            return false;
        }
    }
}
