<?php
/**
 * PropertyDiscountCondition
 *
 * @author    Roja45
 * @copyright 2016 Roja45
 * @license   license.txt
 * @category  PropertyDiscountCondition
 *
 * 2016 ROJA45 - All rights reserved.
 *
 * DISCLAIMER
 * Changing this file will render any support provided by us null and void.
 */

/**
 * PropertyDiscountCondition
 *
 * @author    Roja45
 * @copyright 2016 Roja45
 * @license   license.txt
 * @category  Class
 *
 * 2016 ROJA45 - All rights reserved.
 *
 * DISCLAIMER
 * Changing this file will render any support provided by us null and void.
 */
class ProductRentalDiscountCondition extends ObjectModel
{
    public $id_roja45_product_discountconditiongroup;
    public $type;
    public $value;

    /**
     * @see ObjectModel::$definition
     */
    public static $definition = array(
        'table' => 'roja45_productrental_discountcondition',
        'primary' => 'id_roja45_product_discount_condition',
        'fields' => array(
            'id_roja45_product_discountconditiongroup' => array('type' => self::TYPE_INT, 'required' => true),
            'type' => array('type' => self::TYPE_STRING, 'validate' => 'isGenericName', 'required' => true),
            'value' => array('type' => self::TYPE_STRING, 'validate' => 'isGenericName', 'required' => true),
        ),
    );

    public static function getConditions($id_roja45_product_discount)
    {
        $sql = new DbQuery();
        $sql->select('dg.*, dc.*');
        $sql->from('roja45_productrental_discountconditiongroup', 'dg');
        $sql->leftJoin(
            'roja45_productrental_discountcondition',
            'dc',
            'dc.id_roja45_product_discountconditiongroup = dg.id_roja45_product_discountconditiongroup'
        );
        $sql->where('id_roja45_product_discount=' . (int)$id_roja45_product_discount);
        return Db::getInstance()->executeS($sql);
    }

    public static function deleteConditions($id_roja45_product_discount)
    {
        $sql = new DbQuery();
        $sql->select('dg.id_roja45_product_discountconditiongroup');
        $sql->from('roja45_productrental_discountconditiongroup', 'dg');
        $sql->where('id_roja45_product_discount=' . (int)$id_roja45_product_discount);
        $ids_discount_condition_group = Db::getInstance()->executeS($sql);

        if ($ids_discount_condition_group) {
            foreach ($ids_discount_condition_group as $row) {
                Db::getInstance()->delete(
                    'roja45_productrental_discountconditiongroup',
                    'id_roja45_product_discountconditiongroup=' .
                    (int)$row['id_roja45_product_discountconditiongroup']
                );
                Db::getInstance()->delete(
                    'roja45_productrental_discountcondition',
                    'id_roja45_product_discountconditiongroup=' .
                    (int)$row['id_roja45_product_discountconditiongroup']
                );
            }
        }
        return true;
    }
}
