<?php
/**
 * ProductRentalDiscountProfile
 *
 * @author    Roja45
 * @copyright 2016 Roja45
 * @license   license.txt
 * @category  ProductRentalDiscountProfile
 *
 * 2016 ROJA45 - All rights reserved.
 *
 * DISCLAIMER
 * Changing this file will render any support provided by us null and void.
 */

/**
 * ProductRentalDiscountProfile
 *
 * @author    Roja45
 * @copyright 2016 Roja45
 * @license   license.txt
 * @category  Class
 *
 * 2016 ROJA45 - All rights reserved.
 *
 * DISCLAIMER
 * Changing this file will render any support provided by us null and void.
 */
class ProductRentalDiscountProfile extends ObjectModel
{
    public $id_roja45_product_discountprofile;
    public $id_roja45_product_discount;
    public $days;
    public $position;
    public $period_start;
    public $period_end;
    public $value;

    /**
     * @see ObjectModel::$definition
     */
    public static $definition = array(
        'table' => 'roja45_productrental_discountprofile',
        'primary' => 'id_roja45_product_discountprofile',
        'fields' => array(
            'id_roja45_product_discount' => array('type' => self::TYPE_INT, 'required' => true),
            'position' => array('type' => self::TYPE_INT, 'required' => true),
            'period_start' => array('type' => self::TYPE_INT, 'required' => true),
            'period_end' => array('type' => self::TYPE_INT, 'required' => true),
            'days' => array('type' => self::TYPE_INT, 'required' => false),
            'value' => array('type' => self::TYPE_FLOAT, 'required' => true),
        ),
    );

    public static function getDiscounts($id_roja45_product_discount)
    {
        $sql = new DbQuery();
        $sql->select('*');
        $sql->from('roja45_productrental_discountprofile', 'dp');
        $sql->where('id_roja45_product_discount=' . (int)$id_roja45_product_discount);
        return Db::getInstance()->executeS($sql);
    }

    public static function deleteDiscount($id_roja45_product_discountprofile)
    {
        $sql = new DbQuery();
        $sql->select('dg.id_roja45_product_discountprofile');
        $sql->from('roja45_productrental_discountprofile', 'dp');
        $sql->where('id_roja45_product_discountprofile=' . (int)$id_roja45_product_discountprofile);
        return Db::getInstance()->executeS($sql);
    }
}
