<?php
/**
 * ProductRentalExtra
 *
 * @author    Roja45
 * @copyright 2016 Roja45
 * @license   license.txt
 * @category  ProductRentalExtra
 *
 * 2016 ROJA45 - All rights reserved.
 *
 * DISCLAIMER
 * Changing this file will render any support provided by us null and void.
 */

/**
 * ProductRentalExtra
 *
 * @author    Roja45
 * @copyright 2016 Roja45
 * @license   license.txt
 * @category  Class
 *
 * 2016 ROJA45 - All rights reserved.
 *
 * DISCLAIMER
 * Changing this file will render any support provided by us null and void.
 */
class ProductRentalExtra extends ObjectModel
{
    public $id_roja45_product_extra;
    public $id_roja45_productrental_extra_type;
    public $rate;
    public $image;
    public $name;
    public $description;
    public $deselect_warning_text;
    public $is_free;
    public $default_selected;
    public $deselect_warning;
    public $enabled;
    public $required;

    /**
     * @see ObjectModel::$definition
     */
    public static $definition = array(
        'table' => 'roja45_productrental_extra',
        'primary' => 'id_roja45_product_extra',
        'multilang' => true,
        'fields' => array(
            'id_roja45_productrental_extra_type' => array('type' => self::TYPE_INT, 'required' => true, 'lang' => false),
            'rate' => array('type' => self::TYPE_FLOAT, 'required' => true, 'lang' => false),
            'default_selected' => array('type' => self::TYPE_BOOL, 'required' => true, 'lang' => false),
            'enabled' => array('type' => self::TYPE_BOOL, 'required' => true, 'lang' => false),
            'required' => array('type' => self::TYPE_BOOL, 'required' => true, 'lang' => false),
            'deselect_warning' => array('type' => self::TYPE_BOOL, 'required' => true, 'lang' => false),
            'image' => array('type' => self::TYPE_STRING, 'required' => false, 'lang' => false),
            'name' => array(
                'type' => self::TYPE_STRING,
                'validate' => 'isGenericName',
                'required' => true,
                'lang' => true
            ),
            'description' => array(
                'type' => self::TYPE_STRING,
                'required' => true,
                'lang' => true
            ),
            'deselect_warning_text' => array(
                'type' => self::TYPE_STRING,
                'required' => false,
                'lang' => true
            ),
        ),
    );

    public function __construct($id = null, $id_lang = null)
    {
        parent::__construct($id, $id_lang);
    }

    public static function getExtras($id_lang = null)
    {
        $sql = new DbQuery();
        $sql->select('*');
        $sql->from('roja45_productrental_extra', 'pre');
        if (isset($id_lang)) {
            $sql->join('LEFT JOIN `'._DB_PREFIX_.'roja45_productrental_extra_lang` prel ON (pre.id_roja45_product_extra = prel.id_roja45_product_extra)');
            $sql->where('prel.`id_lang` = ' . (int) $id_lang);
        }

        if ($results = Db::getInstance()->executeS($sql)) {
            return $results;
        } else {
            return array();
        }
    }

    public function calculateTotal($rate, $rental)
    {
        switch ($this->id_roja45_productrental_extra_type) {
            case ProductRentalExtraType::PER_PERIOD:
                return $rate * (int)($rental->periods);
            case ProductRentalExtraType::PER_RENTAL:
                return $rate;
            case ProductRentalExtraType::PER_RENTAL_ITEM:
                return $rate * (int)($rental->qty);
            case ProductRentalExtraType::PER_RENTAL_ITEM_PER_PERIOD:
                return $rate * (int) ($rental->periods) * (int) ($rental->qty);
        }
    }

    public function calculateExtraCost(
        $rate,
        $collection_date,
        $return_date,
        $number_models,
        $qty
    ) {
        $collection = DateTime::createFromFormat('Y-m-d', $collection_date);
        $return = DateTime::createFromFormat('Y-m-d', $return_date);
        $periods = $collection->diff($return)->format("%a");
        switch ($this->id_roja45_productrental_extra_type) {
            case ProductRentalExtraType::PER_PERIOD:
                return $rate * (int) $periods;
            case ProductRentalExtraType::PER_RENTAL:
                return $rate;
            case ProductRentalExtraType::PER_RENTAL_ITEM:
                return $rate * (int) $number_models;
            case ProductRentalExtraType::PER_RENTAL_ITEM_PER_PERIOD:
                return $rate * (int) $periods * (int) $number_models;
            default:
                break;
        }
    }
}
