<?php
/**
 * ProductRentalExtraType
 *
 * @author    Roja45
 * @copyright 2016 Roja45
 * @license   license.txt
 * @category  ProductRentalExtraType
 *
 * 2016 ROJA45 - All rights reserved.
 *
 * DISCLAIMER
 * Changing this file will render any support provided by us null and void.
 */

/**
 * ProductRentalExtraType
 *
 * @author    Roja45
 * @copyright 2016 Roja45
 * @license   license.txt
 * @category  Class
 *
 * 2016 ROJA45 - All rights reserved.
 *
 * DISCLAIMER
 * Changing this file will render any support provided by us null and void.
 */

class ProductRentalExtraType extends ObjectModel
{
    public $id_roja45_product_extratype;
    public $code;
    public $name;
    public $description;

    const PER_PERIOD = 1;
    const PER_RENTAL = 2;
    const PER_RENTAL_ITEM = 3;
    const PER_RENTAL_ITEM_PER_PERIOD = 4;

    /**
     * @see ObjectModel::$definition
     */
    public static $definition = array(
        'table' => 'roja45_productrental_extra_type',
        'primary' => 'id_roja45_productrental_extra_type',
        'multilang' => true,
        'code' => array('type' => self::TYPE_STRING, 'lang' => false),
        'fields' => array(
            'name' => array(
                'type' => self::TYPE_STRING,
                'validate' => 'isGenericName',
                'required' => true,
                'lang' => true
            ),
            'description' => array(
                'type' => self::TYPE_STRING,
                'validate' => 'isGenericName',
                'required' => true,
                'lang' => true
            ),
        ),
    );

    public function __construct($id = null, $id_lang = null)
    {
        parent::__construct($id, $id_lang);
    }

    public static function getExtraTypes($id_lang = null)
    {
        $sql = new DbQuery();
        $sql->select(
            '*'
        );
        $sql->from('roja45_productrental_extra_type', 'et');
        if ($id_lang) {
            $sql->leftJoin(
                'roja45_productrental_extra_type_lang',
                'etl',
                'et.id_roja45_productrental_extra_type = etl.id_roja45_productrental_extra_type'
            );
            $sql->where('etl.id_lang='.(int) $id_lang);
        }
        return Db::getInstance()->executeS($sql);
    }
}
