<?php
/**
 * ProductRentalModel
 *
 * @author    Roja45
 * @copyright 2016 Roja45
 * @license   license.txt
 * @category  ProductRentalModel
 *
 * 2016 ROJA45 - All rights reserved.
 *
 * DISCLAIMER
 * Changing this file will render any support provided by us null and void.
 */

/**
 * ProductRentalModel
 *
 * @author    Roja45
 * @copyright 2016 Roja45
 * @license   license.txt
 * @category  Class
 *
 * 2016 ROJA45 - All rights reserved.
 *
 * DISCLAIMER
 * Changing this file will render any support provided by us null and void.
 */

class ProductRentalModel extends ObjectModel
{
    const INSTANT_BOOK = '1';

    public $id_roja45_product_model;
    public $id_roja45_product;
    public $id_product_attribute;
    public $is_linked;
    public $payment_profile_enabled;
    public $qty_available;
    public $minimum_duration;
    public $service_charge;
    public $service_charge_type;
    public $minimum_rate;
    public $minimum_rate_type;
    public $minimum_rate_enabled;
    public $name;
    public $description;
    public $reference;
    public $enabled;

    /**
     * @see ObjectModel::$definition
     */
    public static $definition = array(
        'table' => 'roja45_productrental_model',
        'primary' => 'id_roja45_product_model',
        'multilang' => true,
        'fields' => array(
            'id_roja45_product' => array(
                'type' => self::TYPE_INT,
                'validate' => 'isUnsignedId',
                'required' => true
            ),
            'id_product_attribute' => array(
                'type' => self::TYPE_INT,
                'validate' => 'isUnsignedId'
            ),
            'payment_profile_enabled' => array(
                'type' => self::TYPE_BOOL
            ),
            'service_charge_type' => array(
                'type' => self::TYPE_INT,
                'validate' => 'isUnsignedId'
            ),
            'service_charge' => array(
                'type' => self::TYPE_FLOAT,
                'validate' => 'isPrice'
            ),
            'is_linked' => array(
                'type' => self::TYPE_BOOL,
                'validate' => 'isUnsignedId'
            ),
            'qty_available' => array(
                'type' => self::TYPE_INT,
                'validate' => 'isUnsignedId'
            ),
            'minimum_duration' => array(
                'type' => self::TYPE_INT,
                'validate' => 'isUnsignedId'
            ),
            'minimum_rate' => array(
                'type' => self::TYPE_FLOAT,
                'validate' => 'isPrice'
            ),
            'minimum_rate_type' => array(
                'type' => self::TYPE_STRING
            ),
            'minimum_rate_enabled' => array(
                'type' => self::TYPE_BOOL
            ),
            'name' => array(
                'type' => self::TYPE_STRING
            ),
            'reference' => array(
                'type' => self::TYPE_STRING
            ),
            'description' => array(
                'type' => self::TYPE_HTML,
                'validate' => 'isCleanHtml',
                'lang' => true
            ),
            'enabled' => array(
                'type' => self::TYPE_BOOL,
                'validate' => 'isUnsignedId'
            )
        ),
    );

    public function __construct($id = null, $id_lang = null)
    {
        parent::__construct($id, $id_lang);
    }

    public function delete()
    {
        $return = true;
        if ((int) Configuration::get('ROJA45_PRODUCTRENTAL_USEPERIODPRICING')) {
            $periodrates = ProductRentalPeriodRate::getPricePeriodsForModel($this->id, $this->id);
            foreach ($periodrates as $periodrate) {
                $periodObj = new ProductRentalPeriodRate($periodrate['id_roja45_product_priceperiod']);
                $return &= $periodObj->delete();
            }
        } else {
            $daterates = ProductRentalDateRate::getRates($this->id_roja45_product, $this->id_roja45_product_model);
            foreach ($daterates as $daterate) {
                $daterate = new ProductRentalDateRate($daterate['id_roja45_product_daterate']);
                $return &= $daterate->delete();
            }
        }

        $rates = ProductRentalRate::getRates($this->id_roja45_product, $this->id);
        foreach ($rates as $rate) {
            $rate = new ProductRentalRate($rate['id_roja45_product_rate']);
            $return &= $rate->delete();
        }

        $return &= Db::getInstance()->delete(
            'roja45_productrental_model_image',
            'id_roja45_product_model='.(int) $this->id_roja45_product_model
        );

        $return &= ProductRentalModelExtra::deleteModelExtras($this->id);

        $return &= parent::delete();
        return $return;
    }

    public static function getModelForAttributeId($id_roja45_product, $id_product_attribute)
    {
        $sql = new DbQuery();
        $sql->select('id_roja45_product_model');
        $sql->from('roja45_productrental_model', 'prm');
        $sql->where('prm.`id_roja45_product` = ' . (int) $id_roja45_product);
        $sql->where('prm.`id_product_attribute` = ' . (int) $id_product_attribute);
        return Db::getInstance()->getValue($sql);
    }

    public static function getProductModel($id_roja45_product, $id_product_attribute)
    {
        $sql = new DbQuery();
        $sql->select('id_roja45_product_model');
        $sql->from('roja45_productrental_model', 'prm');
        $sql->where('prm.`id_roja45_product` = ' . (int) $id_roja45_product);
        $sql->where('prm.`id_product_attribute` = ' . (int) $id_product_attribute);
        return Db::getInstance()->getValue($sql);
    }

    public static function getProductModelIds($id_roja45_product)
    {
        $sql = new DbQuery();
        $sql->select('id_roja45_product_model');
        $sql->from('roja45_productrental_model', 'prm');
        $sql->where('prm.`id_roja45_product` = ' . (int) $id_roja45_product);
        $return = Db::getInstance()->executeS($sql);
        return $return;
    }

    public static function getModel($id_roja45_product, $id_roja45_product_model, $id_lang = null)
    {
        $sql = new DbQuery();
        $sql->select('*');
        $sql->from('roja45_productrental_model', 'prm');

        if ($id_lang) {
            $sql->leftJoin(
                'roja45_productrental_model_lang',
                'prml',
                'prm.id_roja45_product_model = prml.id_roja45_product_model'
            );
            $sql->where('prml.`id_lang` = ' . (int) $id_lang);
        }
        $sql->where('prm.`id_roja45_product` = ' . (int) $id_roja45_product);
        $sql->where('prm.`id_roja45_product_model` = ' . (int) $id_roja45_product_model);
        return Db::getInstance()->executeS($sql);
    }

    public static function getModels($id_roja45_product, $id_lang = null)
    {
        $sql = new DbQuery();
        $sql->select('*');
        $sql->from('roja45_productrental_model', 'prm');

        if ($id_lang) {
            $sql->leftJoin(
                'roja45_productrental_model_lang',
                'prml',
                'prm.id_roja45_product_model = prml.id_roja45_product_model'
            );
            $sql->where('prml.`id_lang` = ' . (int) $id_lang);
        }
        $sql->where('prm.`id_roja45_product` = ' . (int) $id_roja45_product);

        $id_lang_default = (int) Configuration::get('PS_LANG_DEFAULT');
        $models = Db::getInstance()->executeS($sql);
        if (!count($models) && ($id_lang_default != $id_lang)) {
            $models = self::getModels($id_roja45_product, $id_lang_default);
        }
        return $models;
    }

    public function getModelName($id_lang = null)
    {
        if (!$id_lang) {
            $id_lang = Context::getContext()->language->id;
        }
        if (!empty($this->name)) {
            return $this->name;
        } elseif ($this->id_product_attribute) {
            $combination = new Combination($this->id_product_attribute);
            if (!Validate::isLoadedObject($combination)) {
                return Module::getInstanceByName('roja45productrental')->l('Product Combination Deleted');
            }
            $attributes = $combination->getAttributesName($id_lang);
            $name = '';
            foreach ($attributes as $attribute) {
                $attributeObj = new Attribute($attribute['id_attribute'], $id_lang);
                $attributeGroupObj = new AttributeGroup($attributeObj->id_attribute_group, $id_lang);
                $name = $name . $attributeGroupObj->name . ' - ' . $attributeObj->name . ', ';
            }
            return Tools::substr($name, 0, Tools::strlen($name)-2);
        } else {
            $rentalproduct = new ProductRentalDetails($this->id_roja45_product);
            $product = new Product($rentalproduct->id_product, false, $id_lang);
            return $product->name;
        }
    }

    public static function getModelNameStatic($id_roja45_product_model, $id_lang)
    {
        if (!$id_lang) {
            $id_lang = Context::getContext()->language->id;
        }
        $model = new ProductRentalModel($id_roja45_product_model);
        if ($model->id_product_attribute) {
            $combination = new Combination($model->id_product_attribute);
            $attributes = $combination->getAttributesName($id_lang);
            $name = '';
            foreach ($attributes as $attribute) {
                $attributeObj = new Attribute($attribute['id_attribute'], $id_lang);
                $attributeGroupObj = new AttributeGroup($attributeObj->id_attribute_group, $id_lang);
                $name = $name . $attributeGroupObj->name . ' - ' . $attributeObj->name . ', ';
            }
            return Tools::substr($name, 0, Tools::strlen($name)-2);
        } else {
            $rentalproduct = new ProductRentalDetails($model->id_roja45_product);
            $product = new Product($rentalproduct->id_product, false, $id_lang);
            return $product->name;
        }
    }

    public function getAvailableQuantity()
    {
        $rentalproduct = new ProductRentalDetails($this->id_roja45_product);
        $qty = StockAvailable::getQuantityAvailableByProduct($rentalproduct->id_product, $this->id_product_attribute);
        return $qty;
    }

    public function getAvailableQuantityForDates()
    {
        // TODO - Return max available over all the dates
        $rentalproduct = new ProductRentalDetails($this->id_roja45_product);
        $qty = StockAvailable::getQuantityAvailableByProduct($rentalproduct->id_product, $this->id_product_attribute);
        return $qty;
    }

    public function getCustomRates($id_lang)
    {
        // TODO - Return max available over all the dates
        $sql = new DbQuery();
        $sql->select(
            'dr.id_roja45_product_daterate, dr.id_roja45_product, dr.id_roja45_product_model,
            dr.id_roja45_product_rate, dr.date, r.rate as original_rate, dr.rate, rl.name'
        );
        $sql->from('roja45_productrental_daterate', 'dr');
        $sql->where('dr.id_roja45_product=' . (int) $this->id_roja45_product);
        $sql->where('rl.id_lang=' . (int) $id_lang);
        $sql->where('dr.id_roja45_product_model=' . (int) $this->id_roja45_product_model);
        $sql->leftJoin('roja45_productrental_rate', 'r', 'r.id_roja45_product_rate=dr.id_roja45_product_rate');
        $sql->leftJoin('roja45_productrental_rate_lang', 'rl', 'r.id_roja45_product_rate=rl.id_roja45_product_rate');
        $rates = array();
        foreach (Db::getInstance()->executeS($sql) as &$rate) {
            $rate['original_rate_formatted'] = Tools::displayPrice(Tools::convertPrice($rate['original_rate']));
            $rate['rate_formatted'] = Tools::displayPrice(Tools::convertPrice($rate['rate']));
            $rates[$rate['date']][$rate['id_roja45_product_rate']] = $rate;
        }
        return $rates;
    }

    public function addModelImage($image)
    {
        return Db::getInstance()->insert('roja45_productrental_model_image', array(
            'id_roja45_product_model' => (int) $this->id,
            'id_image' => (int) $image['id_image'],
            'id_roja45_product' => (int) $this->id_roja45_product,
            'position' => (int) $image['position'],
            'cover' => (int) $image['cover'],
        ));
    }

    public function deleteModelImage($id_image)
    {
        return Db::getInstance()->delete(
            'roja45_productrental_model_image',
            'id_roja45_product_model='.(int) $this->id_roja45_product_model.' AND id_image='.(int) $id_image
        );
    }

    public function getImages($id_lang)
    {
        $rentalproduct = new ProductRentalDetails($this->id_roja45_product);
        $product = new Product($rentalproduct->id_product, false);
        if ($this->id_product_attribute) {
            $images = $product->getCombinationImages($id_lang);
            if (isset($images[$this->id_product_attribute])) {
                return $images[$this->id_product_attribute];
            } else {
                return array();
            }
        } else {
            return $product->getImages($id_lang);
        }
    }

    public function getCoverImage($id_lang)
    {
        $rentalproduct = new ProductRentalDetails($this->id_roja45_product);
        if ($this->id_product_attribute) {
            return Product::getCombinationImageById($this->id_product_attribute, $id_lang);
        } else {
            return Product::getCover($rentalproduct->id_product);
        }
    }

    public function deleteImages()
    {
        return Db::getInstance()->delete(
            'roja45_productrental_model_image',
            'id_roja45_product_model='.(int) $this->id_roja45_product_model
        );
    }

    public function copySpace($name)
    {
        $return = true;
        $new_model = new self();
        $new_model->id_roja45_product = $this->id_roja45_product;
        $new_model->name = $name;
        $new_model->payment_profile_enabled = $this->payment_profile_enabled;
        //$new_model->id_paymentprofile = $this->id_paymentprofile;
        //$new_model->minimum_duration = $this->minimum_stay;

        foreach (Language::getLanguages(true) as $lang) {
            $new_model->description[$lang['id_lang']] = $this->description[$lang['id_lang']];
        }

        $return &= (bool) $new_model->save();

        $rates = ProductRentalRate::getRatesByParent(
            $this->id_roja45_product,
            $this->id_roja45_product_model,
            null
        );

        foreach ($rates as $rate) {
            $rateObj = new ProductRentalRate($rate['id_roja45_product_rate']);
            $rateObj->id = 0;
            $rateObj->id_parent = $new_model->id;
            $return &= (bool) $rateObj->save();
        }

        $periodrates = ProductRentalPeriodRate::getPeriodRatesForLang(
            $this->id_roja45_product,
            $this->id_roja45_product_model,
            null
        );
        foreach ($periodrates as $periodrate) {
            $periorateObj = new ProductRentalPeriodRate($periodrate['id_roja45_product_periodrate']);
            $periorateObj->id = 0;
            $periorateObj->id_parent = $new_model->id;
            $return &= (bool) $periorateObj->save();
        }
        if ($return) {
            return $new_model;
        } else {
            return false;
        }
    }

    public static function getRates($id_roja45_product_model, $id_lang)
    {
        $modelObj = new ProductRentalModel($id_roja45_product_model);
        $rates = array();

        $model_rates = ProductRentalRate::getRates(
            $modelObj->id_roja45_product,
            $id_roja45_product_model,
            (int)$id_lang
        );

        $rate_details = array();
        foreach ($model_rates as $rate) {
            $rate_details[$rate['id_roja45_product_rate']]['standard'][] = $rate;
        }
        $rates['rates'] = $rate_details;
        return $rates;
    }
}
