<?php
/**
 * PropertyExtra
 *
 * @author    Roja45
 * @copyright 2016 Roja45
 * @license   license.txt
 * @category  PropertyExtra
 *
 * 2016 ROJA45 - All rights reserved.
 *
 * DISCLAIMER
 * Changing this file will render any support provided by us null and void.
 */

/**
 * PropertyExtra
 *
 * @author    Roja45
 * @copyright 2016 Roja45
 * @license   license.txt
 * @category  Class
 *
 * 2016 ROJA45 - All rights reserved.
 *
 * DISCLAIMER
 * Changing this file will render any support provided by us null and void.
 */
class ProductRentalModelExtra extends ObjectModel
{
    public $id_roja45_product_extralink;
    public $id_roja45_product_extra;
    public $id_roja45_product_model;
    public $rate;
    public $enabled;

    /**
     * @see ObjectModel::$definition
     */
    public static $definition = array(
        'table' => 'roja45_productrental_model_extra',
        'primary' => 'id_roja45_product_extralink',
        'multilang' => false,
        'fields' => array(
            'id_roja45_product_extra' => array('type' => self::TYPE_INT),
            'id_roja45_product_model' => array('type' => self::TYPE_INT),
            'rate' => array('type' => self::TYPE_FLOAT),
            'enabled' => array('type' => self::TYPE_BOOL),
        ),
    );

    public function __construct($id = null, $id_lang = null)
    {
        parent::__construct($id, $id_lang);
    }

    public static function getExtrasForModel($id_roja45_product_model, $id_lang = null)
    {
        $sql = new DbQuery();
        $sql->select(
            'prme.id_roja45_product_extralink,
            prme.id_roja45_product_extra,
            prme.id_roja45_product_model,
            prme.rate,
            prme.enabled,
            pre.id_roja45_productrental_extra_type,
            pre.default_selected,
            pre.image,
            pre.deselect_warning,
            pre.required'
        );
        $sql->from('roja45_productrental_model_extra', 'prme');
        $sql->join('LEFT JOIN `'._DB_PREFIX_.'roja45_productrental_extra` pre ON (prme.id_roja45_product_extra = pre.id_roja45_product_extra)');
        $sql->where('prme.`id_roja45_product_model` = ' . (int) $id_roja45_product_model);

        if ($id_lang) {
            $sql->select(
                'prel.name,
                prel.description,
                prel.deselect_warning_text'
            );
            $sql->join('LEFT JOIN `'._DB_PREFIX_.'roja45_productrental_extra_lang` prel ON (pre.id_roja45_product_extra = prel.id_roja45_product_extra)');
            $sql->where('prel.`id_lang` = ' . (int) $id_lang);
        }
        $extras = Db::getInstance()->executeS($sql);
        $id_lang_default = (int) Configuration::get('PS_LANG_DEFAULT');
        if (!count($extras) && ($id_lang_default != $id_lang)) {
            $extras = self::getExtrasForModel($id_roja45_product_model, Configuration::get('PS_LANG_DEFAULT'));
        }

        return $extras;
    }

    public static function getExtraIdsFormodel($id_roja45_product_model)
    {
        $sql = new DbQuery();
        $sql->select(
            'id_roja45_property_extra'
        );
        $sql->from('roja45_productrental_model_extra', 'prme');
        $sql->join(
            'LEFT JOIN `'._DB_PREFIX_.'roja45_productrental_extra` pre 
            ON (prme.id_roja45_product_extra = pre.id_roja45_product_extra)'
        );
        $sql->where('prme.`id_roja45_product_model` = ' . (int) $id_roja45_product_model);
        if ($results = Db::getInstance()->executeS($sql)) {
            return $results;
        } else {
            return array();
        }
    }

    public static function getModelExtra($id_roja45_product_extra, $id_roja45_product_model = null)
    {
        $sql = new DbQuery();
        $sql->select(
            'me.id_roja45_product_extralink'
        );
        $sql->from('roja45_productrental_model_extra', 'me');
        $sql->where('me.id_roja45_product_extra='.(int) $id_roja45_product_extra);

        if ($id_roja45_product_model) {
            $sql->where('me.id_roja45_product_model='.(int) $id_roja45_product_model);
        }

        if ($id_roja45_product_extralink = Db::getInstance()->getValue($sql)) {
            return $id_roja45_product_extralink;
        } else {
            return false;
        }
    }


    public static function deleteModelExtras($id_roja45_product_model)
    {
        $sql = '
            DELETE FROM '._DB_PREFIX_.'roja45_productrental_model_extra 
            WHERE id_roja45_product_model='.(int) $id_roja45_product_model;
        return Db::getInstance()->execute($sql);
    }
}
