<?php
/**
 * ProductRentalPaymentProfile
 *
 * @author    Roja45
 * @copyright 2016 Roja45
 * @license   license.txt
 * @category  ProductRentalPaymentProfile
 *
 * 2016 ROJA45 - All rights reserved.
 *
 * DISCLAIMER
 * Changing this file will render any support provided by us null and void.
 */

/**
 * ProductRentalPaymentProfile
 *
 * @author    Roja45
 * @copyright 2016 Roja45
 * @license   license.txt
 * @category  Class
 *
 * 2016 ROJA45 - All rights reserved.
 *
 * DISCLAIMER
 * Changing this file will render any support provided by us null and void.
 */

class ProductRentalPaymentProfile extends ObjectModel
{
    public $id_roja45_product_paymentprofile;
    public $id_group;
    public $name;
    public $description;
    public $type;
    public $position;
    public $number_payments;
    public $deposit_amount;
    public $deposit_type;
    public $days_until_reservation;
    public $payment_request_days;
    public $enabled;

    const FULL = '1';
    const DEPOSIT_FINAL = '2';
    const COD_FINAL = '3';
    //const DEPOSIT_N_PAYMENTS = '3';

    const PERCENTAGE = '10';
    const FIXED = '11';

    /**
     * @see ObjectModel::$definition
     */
    public static $definition = array(
        'table' => 'roja45_productrental_paymentprofile',
        'primary' => 'id_roja45_product_paymentprofile',
        'multilang' => true,
        'fields' => array(
            'id_group' => array('type' => self::TYPE_INT),
            'name' => array('type' => self::TYPE_STRING, 'lang' => true),
            'description' => array('type' => self::TYPE_HTML, 'lang' => true),
            'type' => array('type' => self::TYPE_INT),
            'position' => array('type' => self::TYPE_INT),
            'number_payments' => array('type' => self::TYPE_INT),
            'deposit_amount' => array('type' => self::TYPE_FLOAT),
            'deposit_type' => array('type' => self::TYPE_INT),
            'days_until_reservation' => array('type' => self::TYPE_INT),
            'payment_request_days' => array('type' => self::TYPE_INT),
            'enabled' => array('type' => self::TYPE_BOOL),
        ),
    );

    public function __construct($id = null, $id_lang = null)
    {
        parent::__construct($id, $id_lang);
    }
    public function add($auto_date = true, $null_values = false)
    {
        $this->position = Db::getInstance(_PS_USE_SQL_SLAVE_)->getValue(
            'SELECT MAX(e.`position`) as position
            FROM `' . _DB_PREFIX_ . 'roja45_productrental_paymentprofile` e'
        );
        if (is_null($this->position) || $this->position<0) {
            $this->position = 0;
        } else {
            (int)$this->position++;
        }
        return parent::add($auto_date, $null_values);
    }

    public function isRemovable()
    {
        if ($this->id == (int) Configuration::get('ROJA45_PRODUCTRENTAL_COD_PAYMENT')) {
            return false;
        }
        return true;
    }

    public static function getPaymentProfile($groups, $arrival_date, $id_lang)
    {
        $days_until_arrival = floor((strtotime(str_replace('/', '-', $arrival_date)) - time()) /60/60/24);
        $group_ids = implode(", ", $groups);
        if (Tools::substr($group_ids, -1) == ',') {
            $group_ids = Tools::substr($group_ids, 0, Tools::strlen($group_ids)-1);
        }

        $sql = '
            SELECT id_roja45_product_paymentprofile
            FROM `'._DB_PREFIX_.'roja45_productrental_paymentprofile`
            WHERE id_group IN (0, '.pSQL($group_ids).')
            AND (days_until_reservation=0 OR days_until_reservation<='.$days_until_arrival .')
            AND enabled=1
            ORDER BY position ASC';

        $id_roja45_product_paymentprofile = Db::getInstance()->getValue($sql);
        $profile = new ProductRentalPaymentProfile($id_roja45_product_paymentprofile, $id_lang);
        return $profile;
    }

    public function hasDeposit()
    {
        switch ($this->type) {
            case self::FULL:
                return false;
            case self::DEPOSIT_FINAL:
                return true;
        }
    }

    public function createPayments($id_roja45_product_rental, $iniital_payment, $total_due)
    {
        switch ($this->type) {
            case self::FULL:
                // 1 payment required
                $payment = new ProductRentalRentalPayment();
                $payment->id_roja45_product_rental = $id_roja45_product_rental;
                $payment->position = 0;
                $payment->completed = 0;
                $payment->total = $total_due;
                $payment->save();
                return $payment;
            case self::DEPOSIT_FINAL:
                if ($this->deposit_type == self::PERCENTAGE) {
                    $initial_payment = new ProductRentalRentalPayment();
                    $initial_payment->id_roja45_product_rental = $id_roja45_product_rental;
                    $initial_payment->position = 0;
                    $initial_payment->completed = 0;
                    $initial_payment->total = $iniital_payment;
                    $initial_payment->save();

                    $final_payment = new ProductRentalRentalPayment();
                    $final_payment->id_roja45_product_rental = $id_roja45_product_rental;
                    $final_payment->position = 1;
                    $final_payment->completed = 0;
                    $final_payment->total = $total_due-$iniital_payment;
                    $final_payment->save();

                    return $initial_payment;
                } else {
                    $initial_payment = new ProductRentalRentalPayment();
                    $initial_payment->id_roja45_product_rental = $id_roja45_product_rental;
                    $initial_payment->position = 0;
                    $initial_payment->completed = 0;
                    $initial_payment->total = $this->deposit_amount;
                    $initial_payment->save();

                    $final_payment = new ProductRentalRentalPayment();
                    $final_payment->id_roja45_product_rental = $id_roja45_product_rental;
                    $final_payment->position = 1;
                    $final_payment->completed = 0;
                    $final_payment->total = $total_due-$this->deposit_amount;
                    $final_payment->save();

                    return $initial_payment;
                }
        }
    }

    public function getNextDepositPercentage()
    {
        switch ($this->type) {
            case self::FULL:
                // 1 payment required
                return 100;
            case self::DEPOSIT_FINAL:
                if ($this->deposit_type == self::PERCENTAGE) {
                    return 100-$this->deposit_amount;
                }
        }
    }

    public function getDepositPercentage($collection_date)
    {
        switch ($this->type) {
            case self::FULL:
                return 100;
            case self::DEPOSIT_FINAL:
                $datetime1 = new DateTime($collection_date);
                $datetime2 = new DateTime('now');
                $interval = $datetime1->diff($datetime2);
                if ($interval->days >= $this->days_until_reservation) {
                    return $this->deposit_amount;
                }
                return 100;
            case self::COD_FINAL:
                return $this->deposit_amount;
        }
    }

    public function getTotalToPay($total)
    {
        $deposit_amount = (float)($this->getPaymentPercentage());
        $total -= $total * ((100 - $deposit_amount) / 100);

        return $total;
    }

    public static function getPaymentProfiles($id_lang = null)
    {
        $sql = new DbQuery();
        $sql->select('*');
        $sql->from('roja45_productrental_paymentprofile', 'pp');
        if (isset($id_lang)) {
            $sql->leftJoin(
                'roja45_productrental_paymentprofile_lang',
                'ppl',
                'pp.id_roja45_product_paymentprofile=ppl.id_roja45_product_paymentprofile'
            );
            $sql->where('ppl.id_lang = '.(int)$id_lang);
        }
        return Db::getInstance()->executeS($sql);
    }

    public static function getPaymentProfilesForLang($id_lang)
    {
        $sql = '
            SELECT * FROM `'._DB_PREFIX_.'roja45_productrental_paymentprofile` pp
            LEFT JOIN `'._DB_PREFIX_.'roja45_productrental_paymentprofile_lang` ppl
            ON pp.id_roja45_product_paymentprofile=ppl.id_roja45_product_paymentprofile
            WHERE ppl.id_lang = '.(int)$id_lang;

        return Db::getInstance()->executeS($sql);
    }

    public function updatePosition($way, $position)
    {
        if (!$res = Db::getInstance()->executeS(
            'SELECT `id_roja45_product_paymentprofile`, `position`
            FROM `' . _DB_PREFIX_ . 'roja45_productrental_paymentprofile`
            ORDER BY `position` ASC'
        )
        ) {
            return false;
        }

        foreach ($res as $profile) {
            if ((int)$profile['id_roja45_product_paymentprofile'] == (int)$this->id) {
                $moved_profile = $profile;
            }
        }

        if (!isset($moved_profile) || !isset($position)) {
            return false;
        }

        // < and > statements rather than BETWEEN operator
        // since BETWEEN is treated differently according to databases
        return (
            Db::getInstance()->execute(
                'UPDATE `' . _DB_PREFIX_ . 'roja45_productrental_paymentprofile`
                SET `position`= `position` ' . ($way ? '- 1' : '+ 1') . '
                WHERE `position`' . ($way ? '> ' . (int)$moved_profile['position'] . '
                AND `position` <= ' . (int)$position : '< ' . (int)$moved_profile['position'] . '
                AND `position` >= ' . (int)$position)
            ) && Db::getInstance()->execute(
                'UPDATE `' . _DB_PREFIX_ . 'roja45_productrental_paymentprofile`
                SET `position` = ' . (int)$position . '
                WHERE `id_roja45_product_paymentprofile` = ' . (int)$moved_profile['id_roja45_product_paymentprofile']
            )
        );
    }
}
