<?php
/**
 * PropertyArea
 *
 * @author    Roja45
 * @copyright 2016 Roja45
 * @license   license.txt
 * @category  PropertyArea
 *
 * 2016 ROJA45 - All rights reserved.
 *
 * DISCLAIMER
 * Changing this file will render any support provided by us null and void.
 */

/**
 * PropertyArea
 *
 * @author    Roja45
 * @copyright 2016 Roja45
 * @license   license.txt
 * @category  Class
 *
 * 2016 ROJA45 - All rights reserved.
 *
 * DISCLAIMER
 * Changing this file will render any support provided by us null and void.
 */

class ProductRentalPaymentType extends ObjectModel
{
    const DEPOSIT = 1;
    const BALANCE = 2;
    const OTHER = 3;

    public $id_roja45_product_payment_type;
    public $enabled;
    public $include;
    public $name;

    /**
     * @see ObjectModel::$definition
     */
    public static $definition = array(
        'table' => 'roja45_productrental_paymenttype',
        'primary' => 'id_roja45_product_payment_type',
        'multilang' => true,
        'fields' => array(
            'enabled' => array('type' => self::TYPE_BOOL, 'lang' => false),
            'include' => array('type' => self::TYPE_BOOL, 'lang' => false),
            'name' => array('type' => self::TYPE_STRING, 'lang' => true),
        ),
    );

    public function __construct($id = null, $id_lang = null)
    {
        parent::__construct($id, $id_lang);
    }

    public function isRemovable()
    {
        return true;
    }

    public static function getPaymentTypes($id_lang = null)
    {
        $sql = new DbQuery();
        $sql->select('*');
        $sql->from('roja45_productrental_paymenttype', 'pt');
        if ($id_lang) {
            $sql->leftJoin(
                'roja45_productrental_paymenttype_lang',
                'ptl',
                'pt.id_roja45_product_payment_type=ptl.id_roja45_product_payment_type'
            );
            $sql->where('ptl.id_lang='.(int) $id_lang);
        }
        return Db::getInstance()->executeS($sql);
    }
}
