<?php
/**
 * ProductRentalPeriod
 *
 * @author    Roja45
 * @copyright 2016 Roja45
 * @license   license.txt
 * @category  ProductRentalPeriod
 *
 * 2016 ROJA45 - All rights reserved.
 *
 * DISCLAIMER
 * Changing this file will render any support provided by us null and void.
 */

/**
 * ProductRentalPeriod
 *
 * @author    Roja45
 * @copyright 2016 Roja45
 * @license   license.txt
 * @category  Class
 *
 * 2016 ROJA45 - All rights reserved.
 *
 * DISCLAIMER
 * Changing this file will render any support provided by us null and void.
 */

class ProductRentalPeriod extends ObjectModel
{
    public $id_roja45_product_period;
    public $name;
    public $is_recurring;
    public $start_date;
    public $end_date;

    /**
     * @see ObjectModel::$definition
     */
    public static $definition = array(
        'table' => 'roja45_productrental_period',
        'primary' => 'id_roja45_product_period',
        'multilang' => true,
        'fields' => array(
            'start_date' => array('type' => self::TYPE_DATE),
            'end_date' => array('type' => self::TYPE_DATE),
            'is_recurring' => array('type' => self::TYPE_BOOL),
            'name' => array('type' => self::TYPE_STRING, 'lang' => true),
        ),
    );

    public function __construct($id = null, $id_lang = null)
    {
        parent::__construct($id, $id_lang);
    }

    public function update($null_values = false)
    {
        $return = parent::update($null_values);
        // need to update all existing rates
        if (!$this->is_recurring) {
            $sql = '
                UPDATE `'._DB_PREFIX_.'roja45_productrental_periodrate`
                SET start_date="'.pSQL($this->start_date).'", end_date="'.pSQL($this->end_date) . '"
                WHERE `id_roja45_product_period` = '.(int) $this->id_roja45_product_period;
            $return &= Db::getInstance()->execute($sql);
        }
        return $return;
    }

    public function isRemovable()
    {
        return true;
    }

    public static function getPeriodsForLang($id_lang)
    {
        $sql = '
            SELECT *
            FROM `'._DB_PREFIX_.'roja45_productrental_period` pp
            LEFT JOIN `'._DB_PREFIX_.'roja45_productrental_period_lang` ppl
            ON (pp.id_roja45_product_period = ppl.id_roja45_product_period)
            WHERE ppl.id_lang='.(int) $id_lang;

        return Db::getInstance()->executeS($sql);
    }
}
