<?php
/**
 * ProductRentalPeriodRate
 *
 * @author    Roja45
 * @copyright 2016 Roja45
 * @license   license.txt
 * @category  ProductRentalPeriodRate
 *
 * 2016 ROJA45 - All rights reserved.
 *
 * DISCLAIMER
 * Changing this file will render any support provided by us null and void.
 */

/**
 * ProductRentalPeriodRate
 *
 * @author    Roja45
 * @copyright 2016 Roja45
 * @license   license.txt
 * @category  Class
 *
 * 2016 ROJA45 - All rights reserved.
 *
 * DISCLAIMER
 * Changing this file will render any support provided by us null and void.
 */

class ProductRentalPeriodRate extends ObjectModel
{
    public $id_roja45_product_periodrate;
    public $id_roja45_product;
    public $id_parent;
    public $id_roja45_product_period;
    public $name;
    public $id_rate;
    public $start_date;
    public $end_date;
    public $rate;

    /**
     * @see ObjectModel::$definition
     */
    public static $definition = array(
        'table' => 'roja45_productrental_periodrate',
        'primary' => 'id_roja45_product_periodrate',
        'multilang' => true,
        'fields' => array(
            'id_roja45_product' => array('type' => self::TYPE_INT, 'validate' => 'isUnsignedId', 'required' => true),
            'id_parent' => array('type' => self::TYPE_INT, 'validate' => 'isUnsignedId', 'required' => true),
            'id_rate' => array('type' => self::TYPE_INT,      'validate' => 'isUnsignedId'),
            'id_roja45_product_period' => array('type' => self::TYPE_INT,      'validate' => 'isUnsignedId'),
            'start_date' => array('type' => self::TYPE_DATE),
            'end_date' => array('type' => self::TYPE_DATE),
            'rate' => array('type' => self::TYPE_STRING, 'validate' => 'isGenericName'),
            'name' => array('type' => self::TYPE_STRING, 'validate' => 'isGenericName', 'lang' => true),
        ),
    );

    public function __construct($id = null, $id_lang = null)
    {
        parent::__construct($id, $id_lang);
    }

    public static function getPricePeriods($id_roja45_product)
    {
        $sql = '
            SELECT * 
            FROM `'._DB_PREFIX_.'roja45_productrental_periodrate` WHERE `id_roja45_product`='.(int) $id_roja45_product;
        return Db::getInstance()->executeS($sql);
    }

    public static function getPricePeriodsForModel($id_roja45_product, $id_roja45_product_model)
    {
        $sql = '
            SELECT *
            FROM `'._DB_PREFIX_.'roja45_productrental_periodrate`
            WHERE `id_roja45_product` = '.(int) $id_roja45_product . '
            AND `id_parent` = '.(int) $id_roja45_product_model;

        return Db::getInstance()->executeS($sql);
    }

    public static function getPeriodRatesForLang($id_roja45_product, $id_parent, $id_lang = null)
    {
        if ($id_lang) {
            $sql = '
                SELECT DISTINCT p.id_roja45_product_period,
                                pp.start_date, pp.end_date, pl.name, pp.id_roja45_product_periodrate,
                                pp.id_roja45_product, pp.id_parent as id_roja45_product_model, pp.id_rate,
                                pp.rate, prtl.name as ratetype_name, prtl.description
                FROM `'._DB_PREFIX_.'roja45_productrental_periodrate` pp
                LEFT JOIN `'._DB_PREFIX_.'roja45_productrental_period` p
                ON (p.id_roja45_product_period = pp.id_roja45_product_period)
                LEFT JOIN `'._DB_PREFIX_.'roja45_productrental_period_lang` pl
                ON (p.id_roja45_product_period = pl.id_roja45_product_period)
                LEFT JOIN `'._DB_PREFIX_.'roja45_productrental_ratetype` prt
                ON (pp.id_rate = prt.id_roja45_product_ratetype)
                LEFT JOIN `'._DB_PREFIX_.'roja45_productrental_ratetype_lang` prtl
                ON (prtl.id_roja45_product_ratetype = prt.id_roja45_product_ratetype)
                WHERE pp.id_roja45_product = '.(int) $id_roja45_product.'
                AND pp.id_parent='.(int) $id_parent.'
                AND pl.id_lang='.(int) $id_lang.'
                AND prtl.id_lang='.(int) $id_lang;
            $periods = Db::getInstance()->executeS($sql);

            // todo - now get custom periods and combine array
            $sql = '
                SELECT  pp.id_roja45_product_periodrate,pp.start_date,pp.end_date, ppl.name, pp.id_roja45_product,
                        pp.id_parent as id_roja45_product_model, pp.id_rate, pp.rate, prtl.name as ratetype_name,
                        prtl.description
                FROM `'._DB_PREFIX_.'roja45_productrental_periodrate` pp
                LEFT JOIN `'._DB_PREFIX_.'roja45_productrental_periodrate_lang` ppl
                ON (pp.id_roja45_product_periodrate = ppl.id_roja45_product_periodrate)
                LEFT JOIN `'._DB_PREFIX_.'roja45_productrental_ratetype` prt
                ON (pp.id_rate = prt.id_roja45_product_ratetype)
                LEFT JOIN `'._DB_PREFIX_.'roja45_productrental_ratetype_lang` prtl
                ON (prtl.id_roja45_product_ratetype = prt.id_roja45_product_ratetype)
                WHERE `id_roja45_product` = '.(int) $id_roja45_product.'
                AND pp.id_parent='.(int) $id_parent.'
                AND pp.id_roja45_product_period=0
                AND ppl.id_lang='.(int) $id_lang.'
                AND prtl.id_lang='.(int) $id_lang;
            $custom = Db::getInstance()->executeS($sql);

            return array_merge($periods, $custom);
        } else {
            $sql = '
                SELECT *
                FROM `'._DB_PREFIX_.'roja45_productrental_periodrate` pp
                WHERE `id_roja45_product` = '.(int) $id_roja45_product.'
                AND id_parent='.(int) $id_parent;
            return Db::getInstance()->executeS($sql);
        }
    }

    public static function getPeriodRates($id_roja45_product, $id_parent, $id_rate, $id_lang)
    {
        $sql = '
            SELECT id_roja45_product_period
            FROM `'._DB_PREFIX_.'roja45_productrental_periodrate`
            WHERE id_rate='.(int) $id_rate;
        $id_roja45_product_period = Db::getInstance()->getValue($sql);

        $sql = '';
        if ($id_roja45_product_period > 0) {
            $sql .= '
                SELECT 
                    p.id_roja45_product_period, p.start_date, p.end_date, pl.name, pp.id_roja45_product_periodrate,
                    pp.id_roja45_product, pp.id_parent as id_roja45_product_model, pp.id_rate, pp.rate,
                    prtl.name as ratetype_name, prtl.description
                FROM `'._DB_PREFIX_.'roja45_productrental_periodrate` pp
                LEFT JOIN `'._DB_PREFIX_.'roja45_productrental_model` s
                ON (s.id_roja45_product_model = pp.id_parent)
                LEFT JOIN `'._DB_PREFIX_.'roja45_productrental_periodrate_lang` ppl
                ON (pp.id_roja45_product_periodrate = ppl.id_roja45_product_periodrate)
                LEFT JOIN `'._DB_PREFIX_.'roja45_productrental_period` p
                ON (p.id_roja45_product_period = pp.id_roja45_product_period)
                LEFT JOIN `'._DB_PREFIX_.'roja45_productrental_period_lang` pl
                ON (p.id_roja45_product_period = pl.id_roja45_product_period)';
        } else {
            $sql .= '
                SELECT 
                    pp.start_date,pp.end_date, ppl.name, pp.id_roja45_product_periodrate, pp.id_roja45_product,
                    pp.id_parent as id_roja45_product_model, pp.id_rate, pp.rate, prtl.name as ratetype_name,
                    prtl.description
                FROM `'._DB_PREFIX_.'roja45_productrental_periodrate` pp
                LEFT JOIN `'._DB_PREFIX_.'roja45_productrental_model` s
                ON (s.id_roja45_product_model = pp.id_parent)
                LEFT JOIN `'._DB_PREFIX_.'roja45_productrental_period` p
                ON (p.id_roja45_product_period = pp.id_roja45_product_period)
                LEFT JOIN `'._DB_PREFIX_.'roja45_productrental_periodrate_lang` ppl
                ON (pp.id_roja45_product_periodrate = ppl.id_roja45_product_periodrate)';
        }
        $sql .= ' LEFT JOIN `'._DB_PREFIX_.'roja45_productrental_ratetype` prt
                  ON (pp.id_rate = prt.id_roja45_product_ratetype)
                  LEFT JOIN `'._DB_PREFIX_.'roja45_productrental_ratetype_lang` prtl
                  ON (prtl.id_roja45_product_ratetype = prt.id_roja45_product_ratetype)';

        $sql .= ' WHERE pp.`id_roja45_product` = '.(int) $id_roja45_product.'
                  AND pp.id_parent='.(int) $id_parent.'
                  AND pp.id_rate='.(int) $id_rate.'
                  AND prtl.id_lang='.(int) $id_lang;
        if ($id_roja45_product_period == 0) {
            $sql .= ' AND ppl.id_lang='.(int) $id_lang.' AND pp.id_roja45_product_period=0';
        } else {
            $sql .= ' AND pl.id_lang='.(int) $id_lang.' AND ppl.id_lang='.(int) $id_lang;
        }
        return Db::getInstance()->executeS($sql);
    }

    public static function deletePeriodRates($id_roja45_product, $id_rate)
    {
        $sql = '
            DELETE FROM `'._DB_PREFIX_.'roja45_productrental_periodrate`
            WHERE `id_roja45_product` = '.(int) $id_roja45_product.'
            AND id_rate='.(int) $id_rate;
        return Db::getInstance()->execute($sql);
    }

    public static function getPricePeriodForDate($id_roja45_product, $id_parent, $id_rate, $id_lang, $date)
    {
        $sql = '
            SELECT *
            FROM `'._DB_PREFIX_.'roja45_productrental_periodrate` pp
            LEFT JOIN `'._DB_PREFIX_.'roja45_productrental_periodrate_lang` ppl
            ON (pp.id_roja45_product_periodrate = ppl.id_roja45_product_periodrate)
            WHERE `id_roja45_product` = '.(int) $id_roja45_product.'
            AND id_parent = '.(int) $id_parent.'
            AND "'.pSQL($date).'" between start_date and end_date
            AND id_rate = '.(int) $id_rate.'
            AND ppl.id_lang='.(int) $id_lang;

        $results = Db::getInstance()->executeS($sql);

        if (count($results)) {
            return $results;
        } else {
            $exploded = explode('-', $date);
            $date = '1004-'.$exploded[1].'-'.$exploded[2];
            $sql = '
            SELECT *
            FROM `'._DB_PREFIX_.'roja45_productrental_periodrate` pp
            LEFT JOIN `'._DB_PREFIX_.'roja45_productrental_periodrate_lang` ppl
            ON (pp.id_roja45_product_periodrate = ppl.id_roja45_product_periodrate)
            LEFT JOIN `'._DB_PREFIX_.'roja45_productrental_period` p
            ON (p.id_roja45_product_period = pp.id_roja45_product_period)
            WHERE pp.id_roja45_product = '.(int) $id_roja45_product.'
            AND pp.id_parent = '.(int) $id_parent.'
            AND p.is_recurring=1
            AND "'.pSQL($date).'" between p.start_date and p.end_date
            AND pp.id_rate = '.(int) $id_rate.'
            AND ppl.id_lang='.(int) $id_lang;

            $results = Db::getInstance()->executeS($sql);

            if (!count($results)) {
                $exploded = explode('-', $date);
                $date = '1004-'.$exploded[1].'-'.$exploded[2];
                $sql = '
                    SELECT *
                    FROM `'._DB_PREFIX_.'roja45_productrental_periodrate` pp
                    LEFT JOIN `'._DB_PREFIX_.'roja45_productrental_periodrate_lang` ppl
                    ON (pp.id_roja45_product_periodrate = ppl.id_roja45_product_periodrate)
                    LEFT JOIN `'._DB_PREFIX_.'roja45_productrental_period` p
                    ON (p.id_roja45_product_period = pp.id_roja45_product_period)
                    WHERE pp.id_roja45_product = '.(int) $id_roja45_product.'
                    AND pp.id_parent = '.(int) $id_parent.'
                    AND p.is_recurring=1
                    AND "'.pSQL($date).'" between p.start_date and "1004-12-31"
                    AND pp.id_rate = '.(int) $id_rate.'
                    AND ppl.id_lang='.(int) $id_lang;
                $results = Db::getInstance()->executeS($sql);

                if (!count($results)) {
                    $date = '1005-'.$exploded[1].'-'.$exploded[2];
                    $sql = '
                    SELECT *
                    FROM `'._DB_PREFIX_.'roja45_productrental_periodrate` pp
                    LEFT JOIN `'._DB_PREFIX_.'roja45_productrental_periodrate_lang` ppl
                    ON (pp.id_roja45_product_periodrate = ppl.id_roja45_product_periodrate)
                    LEFT JOIN `'._DB_PREFIX_.'roja45_productrental_period` p
                    ON (p.id_roja45_product_period = pp.id_roja45_product_period)
                    WHERE pp.id_roja45_product = '.(int) $id_roja45_product.'
                    AND pp.id_parent = '.(int) $id_parent.'
                    AND p.is_recurring=1
                    AND "'.pSQL($date).'" between "1005-01-01" and p.end_date
                    AND pp.id_rate = '.(int) $id_rate.'
                    AND ppl.id_lang='.(int) $id_lang;

                    $results = Db::getInstance()->executeS($sql);
                }
            }
            return $results;
        }
    }
}
