<?php
/**
 * PropertyDiscount
 *
 * @author    Roja45
 * @copyright 2016 Roja45
 * @license   license.txt
 * @category  PropertyDiscount
 *
 * 2016 ROJA45 - All rights reserved.
 *
 * DISCLAIMER
 * Changing this file will render any support provided by us null and void.
 */

/**
 * PropertyDiscount
 *
 * @author    Roja45
 * @copyright 2016 Roja45
 * @license   license.txt
 * @category  Class
 *
 * 2016 ROJA45 - All rights reserved.
 *
 * DISCLAIMER
 * Changing this file will render any support provided by us null and void.
 */
class ProductRentalPriceRule extends ObjectModel
{
    public $id_roja45_product_pricerule;
    public $name;
    public $enabled;
    public $date_add;
    public $date_upd;

    /**
     * @see ObjectModel::$definition
     */
    public static $definition = array(
        'table' => 'roja45_productrental_pricerule',
        'primary' => 'id_roja45_product_pricerule',
        'fields' => array(
            'name' => array('type' => self::TYPE_STRING, 'validate' => 'isGenericName', 'required' => true),
            'enabled' => array('type' => self::TYPE_BOOL),
            'date_add' => array('type' => self::TYPE_DATE, 'validate' => 'isDateFormat', 'required' => false),
            'date_upd' => array('type' => self::TYPE_DATE, 'validate' => 'isDateFormat', 'required' => false),
        ),
    );

    public function delete()
    {
        $this->deleteConditions();
        Db::getInstance()->execute('
            DELETE FROM ' . _DB_PREFIX_ . 'roja45_productrentalpricerule
            WHERE id_roja45_product_pricerule=' . (int)$this->id);

        return parent::delete();
    }

    public function apply($products = false)
    {
        $this->resetPriceRules($products);
        $products = $this->getAffectedProducts($products);
        foreach ($products as $product) {
            ProductRentalPriceRule::applyRuleToProduct((int)$this->id, (int)$product['id_roja45_product']);
        }
    }

    public function resetPriceRules($products = false)
    {
        $where = '';
        if ($products && count($products)) {
            $where .= ' AND id_roja45_product IN (' . implode(', ', array_map('intval', $products)) . ')';
        }

        return Db::getInstance()->execute(
            'DELETE FROM ' . _DB_PREFIX_ . 'roja45_productrental_productpricerule
            WHERE id_roja45_product_pricerule=' . (int)$this->id . $where
        );
    }

    public function addConditions($conditions)
    {
        $result = Db::getInstance()->insert(
            'roja45_productrental_priceruleconditiongroup',
            array(
                'id_roja45_product_pricerule' => (int)$this->id
            )
        );
        if (!$result) {
            return false;
        }
        $id_roja45_prodcuct_priceruleconditiongroup = (int)Db::getInstance()->Insert_ID();
        foreach ($conditions as $condition) {
            $new_condition = new ProductRentalPriceRuleCondition();
            $new_condition->id_roja45_product_priceruleconditiongroup = (int)$id_roja45_prodcuct_priceruleconditiongroup;
            $new_condition->type = pSQL($condition['type']);
            $new_condition->value = (float)$condition['value'];
            if (!$new_condition->save()) {
                return false;
            }
        }
        return true;
    }

    public function addPriceRuleProfile($pricerule_profile)
    {
        if ($pricerule_profile['id'] > 0) {
            $new_pricerule = new ProductRentalPriceRuleProfile($pricerule_profile['id']);
        } else {
            $new_pricerule = new ProductRentalPriceRuleProfile();
        }

        $new_pricerule->id_roja45_product_pricerule = $this->id;
        $new_pricerule->position = $pricerule_profile['position'];
        // TODO - process the profile, add day records.
        $new_pricerule->save();

        Db::getInstance()->execute(
            'DELETE FROM ' . _DB_PREFIX_ . 'roja45_productrental_priceruleprofileday
            WHERE id_roja45_product_priceruleprofile=' . (int) $new_pricerule->id
        );
        $days = explode("#", $pricerule_profile['profile']);
        foreach ($days as $day) {
            $day = explode("-", $day);
            Db::getInstance()->insert(
                'roja45_productrental_priceruleprofileday',
                array(
                    'id_roja45_product_priceruleprofile' => (int) $new_pricerule->id,
                    'day' => (int) $day[0],
                    'value' => (int) $day[1]
                )
            );
        }

        return true;
    }

    public function deletePriceRuleProfile($id_pricerule)
    {
        $pricerule = new ProductRentalPriceRuleProfile($id_pricerule);
        Db::getInstance()->execute(
            'DELETE FROM ' . _DB_PREFIX_ . 'roja45_productrental_priceruleprofileday
            WHERE id_roja45_product_priceruleprofile=' . (int) $pricerule->id_roja45_product_priceruleprofile
        );
        $pricerule->delete();
    }

    public function deleteConditions()
    {
        ProductRentalPriceRuleCondition::deleteConditions((int)$this->id);
    }

    public function getConditions()
    {
        $conditions = ProductRentalPriceRuleCondition::getConditions((int)$this->id);
        $conditions_group = array();
        if ($conditions) {
            foreach ($conditions as &$condition) {
                $conditions_group[(int)$condition['id_roja45_product_priceruleconditiongroup']][] = $condition;
            }
        }
        return $conditions_group;
    }

    public function getProfiles()
    {
        $sql = new DbQuery();
        $sql->select('prp.`id_roja45_product_priceruleprofile`');
        $sql->from('roja45_productrental_priceruleprofile', 'prp');
        $sql->where('prp.`id_roja45_product_pricerule` = ' . (int) $this->id);
        $sql->orderBy('prp.`position`');
        return Db::getInstance()->executeS($sql);
    }

    public function getPriceRules()
    {
        $pricerules = ProductRentalPriceRuleProfile::getPriceRules((int)$this->id);
        if ($pricerules && count($pricerules)) {
            return $pricerules;
        } else {
            return array();
        }
    }

    public function getAffectedProducts()
    {
        $conditions_group = $this->getConditions();

        $result = array();
        if ($conditions_group) {
            foreach ($conditions_group as $condition_group) {
                $query = new DbQuery();
                $query->select('rp.`id_roja45_product`');
                $query->from('roja45_productrental_details', 'rp');

                $joined = false;
                foreach ($condition_group as $id_condition => $condition) {
                    if ($condition['type'] == 'roja45product') {
                        $query->where('rp.`id_roja45_product` = ' . (int)$condition['value']);
                    } elseif ($condition['type'] == 'category') {
                        $query->leftJoin('product', 'p', 'rp.id_product = p.id_product');
                        $query->leftJoin(
                            'category_product',
                            'cp' . (int) $id_condition,
                            'p.`id_product` = cp' . (int) $id_condition . '.`id_product`'
                        )->where('cp' . (int) $id_condition . '.id_category = ' . (int) $condition['value']);
                    }
                }
                $result = array_merge($result, Db::getInstance()->executeS($query));
            }
        }

        return $result;
    }

    public function dateValid($date_to_check, $include_time)
    {
        $date_to_check = strtotime($date_to_check);
        $from = strtotime($this->start_date);
        $until = strtotime($this->end_date);
        if (!$include_time) {
            $date = new DateTime($this->start_date);
            $date->setTime(0, 0, 0);
            $from = strtotime($date->format('Y-m-d'));
            $date = new DateTime($this->end_date);
            $date->setTime(0, 0, 0);
            $until = strtotime($date->format('Y-m-d'));
        }

        return (($date_to_check >= $from) && ($date_to_check <= $until));
    }

    public static function applyRuleToProduct($id_roja45_product_pricerule, $id_roja45_product)
    {
        $sql = new DbQuery();
        $sql->select('pd.`id_roja45_product_productpricerule`');
        $sql->from('roja45_productrental_productpricerule', 'pd');
        $sql->where('pd.`id_roja45_product` = ' . (int)$id_roja45_product);
        $sql->where('pd.`id_roja45_product_pricerule` = ' . (int)$id_roja45_product_pricerule);
        if (Db::getInstance()->getValue($sql)) {
            return false;
        }

        return Db::getInstance()->insert(
            'roja45_productrental_productpricerule',
            array(
                'id_roja45_product' => (int)$id_roja45_product,
                'id_roja45_product_pricerule' => (int)$id_roja45_product_pricerule
            )
        );
    }

    public static function processPriceRules(
        $id_roja45_product,
        $periods
    ) {
        $sql = new DbQuery();
        $sql->select('pd.`id_roja45_product_pricerule`');
        $sql->from('roja45_productrental_productpricerule', 'pd');
        $sql->leftJoin(
            'roja45_productrental_pricerule',
            'd',
            'pd.id_roja45_product_pricerule = d.id_roja45_product_pricerule'
        );
        $sql->where('pd.`id_roja45_product` = ' . (int)$id_roja45_product);
        $sql->where('d.`enabled` = 1');
        if ($id_roja45_product_pricerule = Db::getInstance()->getValue($sql)) {
            $period_map = implode('', array_column($periods, 'period_weekday'));
            $price_rule = new ProductRentalPriceRule($id_roja45_product_pricerule);

            $profiles = $price_rule->getProfiles();
            foreach ($profiles as $profile) {
                $profile = new ProductRentalPriceRuleProfile($profile['id_roja45_product_priceruleprofile']);
                $days = $profile->getDays();
                //dump($days);
                $profile_days_map = implode('', array_column($days, 'day'));

                if ($occurances = substr_count($period_map, $profile_days_map)) {

                    for ($i = 1; $i <= $occurances; $i++) {
                        $position = strpos($period_map, $profile_days_map);
                        $length = Tools::strlen($profile_days_map);
                        $period_map = str_pad(
                            Tools::substr($period_map, 0, $position),
                            $position+Tools::strlen($profile_days_map),
                            "-"
                        ) . Tools::substr($period_map, $position+Tools::strlen($profile_days_map), Tools::strlen($period_map));
                        for ($j = 0; $j < $length; $j++) {
                            if ($j==0) {
                                $periods[$j+$position]->apply_discount = $days[$j]['value'];
                            }
                            $periods[$j+$position]->rule_modifier = $days[$j]['value'];
                        }
                    }
                }
            }
        }
        return $periods;
    }
}
