<?php
/**
 * ProductRentalPriceRuleCondition
 *
 * @author    Roja45
 * @copyright 2016 Roja45
 * @license   license.txt
 * @category  ProductRentalPriceRuleCondition
 *
 * 2016 ROJA45 - All rights reserved.
 *
 * DISCLAIMER
 * Changing this file will render any support provided by us null and void.
 */

/**
 * ProductRentalPriceRuleCondition
 *
 * @author    Roja45
 * @copyright 2016 Roja45
 * @license   license.txt
 * @category  Class
 *
 * 2016 ROJA45 - All rights reserved.
 *
 * DISCLAIMER
 * Changing this file will render any support provided by us null and void.
 */
class ProductRentalPriceRuleCondition extends ObjectModel
{
    public $id_roja45_product_priceruleconditiongroup;
    public $type;
    public $value;

    /**
     * @see ObjectModel::$definition
     */
    public static $definition = array(
        'table' => 'roja45_productrental_pricerulecondition',
        'primary' => 'id_roja45_product_pricerule_condition',
        'fields' => array(
            'id_roja45_product_priceruleconditiongroup' => array('type' => self::TYPE_INT, 'required' => true),
            'type' => array('type' => self::TYPE_STRING, 'validate' => 'isGenericName', 'required' => true),
            'value' => array('type' => self::TYPE_STRING, 'validate' => 'isGenericName', 'required' => true),
        ),
    );

    public static function getConditions($id_roja45_product_pricerule)
    {
        $sql = new DbQuery();
        $sql->select('dg.*, dc.*');
        $sql->from('roja45_productrental_priceruleconditiongroup', 'dg');
        $sql->leftJoin(
            'roja45_productrental_pricerulecondition',
            'dc',
            'dc.id_roja45_product_priceruleconditiongroup = dg.id_roja45_product_priceruleconditiongroup'
        );
        $sql->where('id_roja45_product_pricerule=' . (int)$id_roja45_product_pricerule);
        return Db::getInstance()->executeS($sql);
    }

    public static function deleteConditions($id_roja45_product_pricerule)
    {
        $sql = new DbQuery();
        $sql->select('dg.id_roja45_product_priceruleconditiongroup');
        $sql->from('roja45_productrental_priceruleconditiongroup', 'dg');
        $sql->where('id_roja45_product_pricerule=' . (int)$id_roja45_product_pricerule);
        $ids_pricerule_condition_group = Db::getInstance()->executeS($sql);

        if ($ids_pricerule_condition_group) {
            foreach ($ids_pricerule_condition_group as $row) {
                Db::getInstance()->delete(
                    'roja45_productrental_priceruleconditiongroup',
                    'id_roja45_product_priceruleconditiongroup=' .
                    (int)$row['id_roja45_product_priceruleconditiongroup']
                );
                Db::getInstance()->delete(
                    'roja45_productrental_pricerulecondition',
                    'id_roja45_product_priceruleconditiongroup=' .
                    (int)$row['id_roja45_product_priceruleconditiongroup']
                );
            }
        }
        return true;
    }
}
