<?php
/**
 * ProductRentalPriceRuleProfile
 *
 * @author    Roja45
 * @copyright 2016 Roja45
 * @license   license.txt
 * @category  ProductRentalPriceRuleProfile
 *
 * 2016 ROJA45 - All rights reserved.
 *
 * DISCLAIMER
 * Changing this file will render any support provided by us null and void.
 */

/**
 * ProductRentalPriceRuleProfile
 *
 * @author    Roja45
 * @copyright 2016 Roja45
 * @license   license.txt
 * @category  Class
 *
 * 2016 ROJA45 - All rights reserved.
 *
 * DISCLAIMER
 * Changing this file will render any support provided by us null and void.
 */
class ProductRentalPriceRuleProfile extends ObjectModel
{
    public $id_roja45_product_priceruleprofile;
    public $id_roja45_product_pricerule;
    public $position;

    /**
     * @see ObjectModel::$definition
     */
    public static $definition = array(
        'table' => 'roja45_productrental_priceruleprofile',
        'primary' => 'id_roja45_product_priceruleprofile',
        'fields' => array(
            'id_roja45_product_pricerule' => array('type' => self::TYPE_INT, 'required' => true),
            'position' => array('type' => self::TYPE_INT, 'required' => true),
        ),
    );

    public static function getPriceRules($id_roja45_product_pricerule)
    {
        $sql = new DbQuery();
        $sql->select('*');
        $sql->from('roja45_productrental_priceruleprofile', 'dp');
        $sql->where('id_roja45_product_pricerule=' . (int)$id_roja45_product_pricerule);
        $profiles = Db::getInstance()->executeS($sql);
        foreach ($profiles as &$profile) {
            $sql = new DbQuery();
            $sql->select('*');
            $sql->from('roja45_productrental_priceruleprofileday', 'prp');
            $sql->where('prp.id_roja45_product_priceruleprofile='.$profile['id_roja45_product_priceruleprofile']);
            $days = Db::getInstance()->executeS($sql);
            $profile_str = '';
            foreach ($days as $day) {
                $profile_str .= $day['day'] . '-' . $day['value'] . '#';
            }
            $profile_str = Tools::substr($profile_str, 0, Tools::strlen($profile_str)-1);
            $profile['profile'] = $profile_str;
            $profile['days'] = $days;
        }
        return $profiles;
    }

    public function getDays()
    {
        $sql = new DbQuery();
        $sql->select('*');
        $sql->from('roja45_productrental_priceruleprofileday', 'prpd');
        $sql->where('prpd.id_roja45_product_priceruleprofile=' . (int)$this->id_roja45_product_priceruleprofile);
        return Db::getInstance()->executeS($sql);
    }

    public static function deletePriceRule($id_roja45_product_priceruleprofile)
    {
        $sql = new DbQuery();
        $sql->select('dg.id_roja45_product_priceruleprofile');
        $sql->from('roja45_productrental_priceruleprofile', 'dp');
        $sql->where('id_roja45_product_priceruleprofile=' . (int)$id_roja45_product_priceruleprofile);
        return Db::getInstance()->executeS($sql);
    }
}
