<?php
/**
 * ProductRentalRate
 *
 * @author    Roja45
 * @copyright 2016 Roja45
 * @license   license.txt
 * @category  ProductRentalRate
 *
 * 2016 ROJA45 - All rights reserved.
 *
 * DISCLAIMER
 * Changing this file will render any support provided by us null and void.
 */

/**
 * ProductRentalRate
 *
 * @author    Roja45
 * @copyright 2016 Roja45
 * @license   license.txt
 * @category  Class
 *
 * 2016 ROJA45 - All rights reserved.
 *
 * DISCLAIMER
 * Changing this file will render any support provided by us null and void.
 */

class ProductRentalRate extends ObjectModel
{
    public $id_roja45_product_rate;
    public $id_roja45_product;
    public $id_parent;
    public $id_type;
    public $rate;
    public $name;
    public $description;

    public static $definition = array(
        'table' => 'roja45_productrental_rate',
        'primary' => 'id_roja45_product_rate',
        'multilang' => true,
        'fields' => array(
            'id_roja45_product' => array('type' => self::TYPE_INT),
            'id_parent' => array('type' => self::TYPE_INT),
            'id_type' => array('type' => self::TYPE_INT),
            'rate' => array('type' => self::TYPE_FLOAT),
            'name' => array('type' => self::TYPE_STRING, 'lang' => true),
            'description' => array('type' => self::TYPE_STRING, 'lang' => true),
        ),
    );

    public function __construct($id = null, $id_lang = null)
    {
        parent::__construct($id, $id_lang);
    }

    public function add($auto_date = true, $null_values = false)
    {
        if (parent::add($auto_date, $null_values)) {
            $groups = Group::getGroups(Context::getContext()->language->id);
            $data = array();
            foreach ($groups as $group) {
                $data[] = array(
                    'id_roja45_product_rate' => $this->id,
                    'id_group' => $group['id_group']
                );
            }
            return Db::getInstance()->insert('roja45_productrental_rategroup', $data);
        }
        return false;
    }

    public function delete()
    {
        if (parent::delete()) {
            return Db::getInstance()->execute(
                'DELETE FROM '. _DB_PREFIX_ . 'roja45_productrental_rategroup
                WHERE id_roja45_product_rate='.(int) $this->id
            );
        }
        return false;
    }
    public function isRemovable()
    {
        return true;
    }

    public static function getRates(
        $id_roja45_product,
        $id_roja45_product_model = null,
        $id_lang = null,
        $group_ids = null,
        $id_roja45_product_rateduration = null
    ) {
        if (!$id_lang) {
            $id_lang = (int) Configuration::get('PS_LANG_DEFAULT');
        }
        $sql = new DbQuery();
        $sql->select('*');
        $sql->from('roja45_productrental_rate', 'r');
        if ($id_roja45_product_rateduration) {
            $sql->leftJoin(
                'roja45_productrental_ratetype',
                'rt',
                'r.id_type = rt.id_roja45_product_ratetype AND rt.id_roja45_product_rateduration = ' . $id_roja45_product_rateduration
            );
        } else {
            $sql->leftJoin(
                'roja45_productrental_ratetype',
                'rt',
                'r.id_type = rt.id_roja45_product_ratetype'
            );
        }

        $sql->where('r.`id_roja45_product` = ' . (int) $id_roja45_product);

        if ($id_roja45_product_model) {
            $sql->where('r.`id_parent` = ' . (int) $id_roja45_product_model);
        }

        $sql->orderBy('r.rate ASC');
        $sql->leftJoin(
            'roja45_productrental_ratetype_lang',
            'rtl',
            'rtl.id_roja45_product_ratetype = rt.id_roja45_product_ratetype'
        );
        $sql->where('rtl.id_lang = ' . (int) $id_lang);
        $id_lang_default = (int) Configuration::get('PS_LANG_DEFAULT');
        $rates = Db::getInstance()->executeS($sql);
        if (!count($rates) && ($id_lang_default != $id_lang)) {
            $rates = self::getRates(
                $id_roja45_product,
                $id_roja45_product_model,
                Configuration::get('PS_LANG_DEFAULT'),
                $group_ids,
                $id_roja45_product_rateduration
            );
        }
        foreach ($rates as $key => &$rate) {
            $sql = new DbQuery();
            $sql->select('g.id_group, gl.name');
            $sql->from('group', 'g');
            $sql->leftJoin('group_lang', 'gl', 'g.id_group = gl.id_group');
            $sql->leftJoin('roja45_productrental_rategroup', 'rg', 'g.id_group = rg.id_group');
            $sql->where('rg.`id_roja45_product_rate` = ' . (int) $rate['id_roja45_product_rate']);
            $sql->where('gl.`id_lang` = ' . (int) $id_lang);
            $groups = Db::getInstance()->executeS($sql);
            $rate_group_ids = array();
            foreach ($groups as $group_id) {
                $rate_group_ids[] = $group_id['id_group'];
            }
            $rate['groups'] = $groups;
            if ($group_ids) {
                $valid_groups = array_intersect($rate_group_ids, $group_ids);
                if (!count($valid_groups)) {
                    unset($rates[$key]);
                }
            }
            $rate['rate_formatted'] = Tools::displayPrice(Tools::convertPrice($rate['rate']));
        }

        return $rates;
    }

    public static function deleteRatesForParent($id_roja45_product, $id_parent)
    {
        $sql = '
            DELETE FROM `'._DB_PREFIX_.'roja45_productrental_rate`
            WHERE `id_roja45_product` = '.(int) $id_roja45_product.'
            AND `id_parent`='.(int) $id_parent;

        return Db::getInstance()->execute($sql);
    }

    public static function getLowestRate($id_roja45_product)
    {
        $sql = '
            SELECT rate 
            FROM `'._DB_PREFIX_.'roja45_productrental_rate`
            WHERE `id_roja45_product` = ' . (int) $id_roja45_product . '
            ORDER BY `rate`';

        return Db::getInstance()->getValue($sql);
    }

    public static function getLowestRateByGroup($id_roja45_product, $id_roja45_product_rateduration, $group_ids)
    {
        $sql = new DbQuery();
        $sql->select('*');
        $sql->from('roja45_productrental_rate', 'r');
        if ($id_roja45_product_rateduration) {
            $sql->leftJoin(
                'roja45_productrental_ratetype',
                'rt',
                'r.id_type = rt.id_roja45_product_ratetype AND rt.id_roja45_product_rateduration = ' . $id_roja45_product_rateduration
            );
        } else {
            $sql->leftJoin(
                'roja45_productrental_ratetype',
                'rt',
                'r.id_type = rt.id_roja45_product_ratetype'
            );
        }
        $sql->where('r.`id_roja45_product` = ' . (int) $id_roja45_product);
        $sql->orderBy('r.rate ASC');
        $rates = Db::getInstance()->executeS($sql);
        foreach ($rates as $key => &$rate) {
            $sql = new DbQuery();
            $sql->select('g.id_group');
            $sql->from('group', 'g');
            $sql->leftJoin('roja45_productrental_rategroup', 'rg', 'g.id_group = rg.id_group');
            $sql->where('rg.`id_roja45_product_rate` = ' . (int) $rate['id_roja45_product_rate']);
            $groups = Db::getInstance()->executeS($sql);
            $rate_group_ids = array();
            foreach ($groups as $group_id) {
                $rate_group_ids[] = $group_id['id_group'];
            }
            $rate['groups'] = $groups;
            if ($group_ids) {
                $valid_groups = array_intersect($rate_group_ids, $group_ids);
                if (!count($valid_groups)) {
                    unset($rates[$key]);
                }
            }
            $rate['rate_formatted'] = Tools::displayPrice(Tools::convertPrice($rate['rate']));
        }

        if (count($rates)) {
            $rates = array_reverse($rates);
            return array_pop($rates);
        } else {
            return false;
        }
    }
}
