<?php
/**
 * RateCalculatorFactory
 *
 * @author    Roja45
 * @copyright 2016 Roja45
 * @license   license.txt
 * @category  RateCalculatorFactory
 *
 * 2016 ROJA45 - All rights reserved.
 *
 * DISCLAIMER
 * Changing this file will render any support provided by us null and void.
 */

/**
 * RateCalculatorFactory
 *
 * @author    Roja45
 * @copyright 2016 Roja45
 * @license   license.txt
 * @category  Class
 *
 * 2016 ROJA45 - All rights reserved.
 *
 * DISCLAIMER
 * Changing this file will render any support provided by us null and void.
 */
class ProductRentalRateCalculatorFactory
{
    protected static $cache_rate_calculator;

    /**
    * Returns a rate calculator able to handle this rate duration
    *
    * @param int $id_roja45_product_rateduration
    *
    * @return ProductRentalRateCalculatorInterface
    */
    public static function getManager($id_roja45_product_rateduration)
    {
        $cache_id = ProductRentalRateCalculatorFactory::getCacheKey($id_roja45_product_rateduration);
        if (!isset(ProductRentalRateCalculatorFactory::$cache_rate_calculator[$cache_id])) {
            $rate_calculator = ProductRentalRateCalculatorFactory::getRateCalculator($id_roja45_product_rateduration);
            TaxManagerFactory::$cache_tax_manager[$cache_id] = $rate_calculator;
        }
        return ProductRentalRateCalculatorFactory::$cache_rate_calculator[$cache_id];
    }

    /**
    * Check for a rate calculator able to handle this rate duration
    *
    * @param int $id_roja45_product_rateduration
    *
    * @return ProductRentalRateCalculatorInterface|false
    */
    public static function getRateCalculator($id_roja45_product_rateduration)
    {
        $rate_calculator = false;
        switch ($id_roja45_product_rateduration) {
            case ProductRentalRateDuration::DAILY:
                $rate_calculator = new ProductRentalDailyRateCalculator();
                break;
            case ProductRentalRateDuration::WEEKLY:
                break;
            case ProductRentalRateDuration::MONTHLY:
                break;
            case ProductRentalRateDuration::HOURLY:
                break;
        }
        return $rate_calculator;
    }


    protected static function getCacheKey($id_roja45_product_rateduration)
    {
        return $id_roja45_product_rateduration;
    }
}
