<?php
/**
 * ProductRentalRateDuration
 *
 * @author    Roja45
 * @copyright 2016 Roja45
 * @license   license.txt
 * @category  ProductRentalRateDuration
 *
 * 2016 ROJA45 - All rights reserved.
 *
 * DISCLAIMER
 * Changing this file will render any support provided by us null and void.
 */

/**
 * ProductRentalRateDuration
 *
 * @author    Roja45
 * @copyright 2016 Roja45
 * @license   license.txt
 * @category  Class
 *
 * 2016 ROJA45 - All rights reserved.
 *
 * DISCLAIMER
 * Changing this file will render any support provided by us null and void.
 */
class ProductRentalRateDuration extends ObjectModel
{
    public $id_roja45_product_rateduration;
    public $name;
    public $active;
    public $type;
    public $duration;

    const HOURLY = 1;
    const DAILY = 2;
    const DAILY_CUSTOM = 3;
    const WEEKLY = 4;
    const WEEKLY_CUSTOM = 5;
    const MONTHLY = 6;

    const ROUND_UP = 1;  // Round up to nearest period
    const ROUND_DOWN = 1; // round down to nearest period

    /**
     * @see ObjectModel::$definition
     */
    public static $definition = array(
        'table' => 'roja45_productrental_rateduration',
        'primary' => 'id_roja45_product_rateduration',
        'multilang' => true,
        'fields' => array(
            'name' => array('type' => self::TYPE_STRING, 'required' => true, 'lang' => true),
            'type' => array('type' => self::TYPE_INT),
            'active' => array('type' => self::TYPE_INT),
            'duration' => array('type' => self::TYPE_INT),
        ),
    );

    public function __construct($id = null, $id_lang = null)
    {
        parent::__construct($id, $id_lang);
    }

    public function add($null_values = false, $auto_date = true)
    {
        return parent::add($null_values, $auto_date);
    }

    public function update($null_values = false)
    {
        return parent::update($null_values);
    }

    public function isRemovable()
    {
        return true;
    }

    public function getPeriods($collection_datetime, $return_datetime, $date_format = null)
    {
        $periods = array();
        switch ($this->type) {
            case self::HOURLY:
                break;
            case self::DAILY:
                if (!$date_format) {
                    $date_format = 'Y-m-d H:s:i';
                }
                $collection_datetime = DateTime::createFromFormat(
                    $date_format,
                    $collection_datetime
                );
                $return_datetime = DateTime::createFromFormat(
                    $date_format,
                    $return_datetime
                );
                $hours = (strtotime(
                    $return_datetime->format('Y-m-d H:s:i')
                ) - strtotime($collection_datetime->format('Y-m-d H:s:i')))/3600;
                $number_periods = ceil($hours/24);
                $return_time = Configuration::get('ROJA45_PRODUCTRENTAL_RETURNTIME');
                $return_time = explode(":", $return_time);

                for ($counter = 1; $counter <= $number_periods; $counter++) {
                    if ($counter == 1) {
                        $start_date = $collection_datetime->format('Y-m-d');
                        $start_time = $collection_datetime->format('H:s:i');
                        $collection_datetime->add(new DateInterval('P1D'));
                        $collection_datetime->setTime($return_time[0], $return_time[1], '0');
                        $end_date = $collection_datetime->format('Y-m-d');
                        $end_time = $collection_datetime->format('H:s:i');
                    } elseif ($counter == $number_periods) {
                        $start_date = $collection_datetime->format('Y-m-d');
                        $start_time = $collection_datetime->format('H:s:i');
                        $end_date = $return_datetime->format('Y-m-d');
                        $end_time = $return_datetime->format('H:s:i');
                    } else {
                        $start_date = $collection_datetime->format('Y-m-d');
                        $start_time = $collection_datetime->format('H:s:i');
                        $collection_datetime->add(new DateInterval('P1D'));
                        $collection_datetime->setTime($return_time[0], $return_time[1], '0');
                        $end_date = $collection_datetime->format('Y-m-d');
                        $end_time = $collection_datetime->format('H:s:i');
                    }

                    $collection = DateTime::createFromFormat('Y-m-d H:i:s', $start_date . ' ' . $start_time);
                    $return = DateTime::createFromFormat('Y-m-d H:i:s', $end_date . ' ' . $end_time);

                    $period = array(
                        'period_type' => self::DAILY,
                        'period' => $start_date,
                        'period_weekday' => $collection->format('N'),
                        'period_startdate' => $start_date,
                        'period_starttime' => $start_time,
                        'period_enddate' => $end_date,
                        'period_endtime' => $end_time,
                        'period_start_formatted_full' => $collection->format(
                            Context::getContext()->language->date_format_full
                        ),
                        'period_start_formatted' => $collection->format(
                            Context::getContext()->language->date_format_lite
                        ),
                        'period_start_formatted_sml' => $collection->format(
                            'm-d'
                        ),
                        'period_end_formatted_full' => $return->format(
                            Context::getContext()->language->date_format_full
                        ),
                        'period_end_formatted' => $return->format(
                            Context::getContext()->language->date_format_lite
                        ),
                        'period_end_formatted_sml' => $return->format(
                            'm-d'
                        ),
                        'period_name' => strftime("%a", $collection->getTimestamp()),
                    );
                    $periods[] = (object) $period;
                }
                break;
            case self::DAILY_CUSTOM:
                break;
            case self::WEEKLY:
                break;
            case self::WEEKLY_CUSTOM:
                break;
            case self::MONTHLY:
                break;
        }

        return $periods;
    }

    public static function getRateDurations($active = true, $id_lang = null)
    {
        $sql = new DbQuery();
        $sql->select('*');
        $sql->from('roja45_productrental_rateduration', 'rd');
        $sql->where('rd.active = ' . (int)$active);
        if ($id_lang) {
            $sql->leftJoin(
                'roja45_productrental_rateduration_lang',
                'rdl',
                'rd.id_roja45_product_rateduration=rdl.id_roja45_product_rateduration'
            );
            $sql->where('rdl.id_lang = ' . (int)$id_lang);
        }

        return Db::getInstance()->executeS($sql);
    }

    public static function getRateDurationId($type)
    {
        $sql = new DbQuery();
        $sql->select('id_roja45_product_rateduration');
        $sql->from('roja45_productrental_rateduration', 'rd');
        $sql->where('rd.type = ' . (int)$type);

        return Db::getInstance()->getValue($sql);
    }
}
