<?php
/**
 * ProductRentalRateType
 *
 * @author    Roja45
 * @copyright 2016 Roja45
 * @license   license.txt
 * @category  ProductRentalRateType
 *
 * 2016 ROJA45 - All rights reserved.
 *
 * DISCLAIMER
 * Changing this file will render any support provided by us null and void.
 */

/**
 * ProductRentalRateType
 *
 * @author    Roja45
 * @copyright 2016 Roja45
 * @license   license.txt
 * @category  Class
 *
 * 2016 ROJA45 - All rights reserved.
 *
 * DISCLAIMER
 * Changing this file will render any support provided by us null and void.
 */
class ProductRentalRateType extends ObjectModel
{
    public $id_roja45_product_ratetype;
    public $id_roja45_product_rateduration;
    public $name;
    public $description;

    /**
     * @see ObjectModel::$definition
     */
    public static $definition = array(
        'table' => 'roja45_productrental_ratetype',
        'primary' => 'id_roja45_product_ratetype',
        'multilang' => true,
        'fields' => array(
            'id_roja45_product_rateduration' => array('type' => self::TYPE_INT),
            'name' => array('type' => self::TYPE_STRING, 'required' => true, 'lang' => true),
            'description' => array('type' => self::TYPE_STRING, 'required' => true, 'lang' => true),
        ),
    );

    public function __construct($id = null, $id_lang = null)
    {
        parent::__construct($id, $id_lang);
    }

    public function add($null_values = false, $auto_date = true)
    {
        $duration = Tools::getValue('duration');
        if ($duration == 1) {
            $this->id_roja45_product_rateduration = ProductRentalRateDuration::DAILY;
        }
        return parent::add($null_values, $auto_date);
    }

    public function update($null_values = false)
    {
        $duration = Tools::getValue('duration');
        if ($duration == 1) {
            $this->id_roja45_product_rateduration = ProductRentalRateDuration::DAILY;
        }
        return parent::update($null_values);
    }

    public function isRemovable()
    {
        return true;
    }

    public static function getRateTypes($id_lang = null)
    {
        $sql = new DbQuery();
        $sql->select('*');
        $sql->from('roja45_productrental_ratetype', 'rt');

        if ($id_lang) {
            $sql->leftJoin(
                'roja45_productrental_ratetype_lang',
                'rtl',
                'rt.id_roja45_product_ratetype=rtl.id_roja45_product_ratetype'
            );
            $sql->where('rtl.id_lang = ' . (int)$id_lang);
        }

        return Db::getInstance()->executeS($sql);
    }
}
