<?php
/**
 * ProductRentalRental
 *
 * @author    Roja45
 * @copyright 2016 Roja45
 * @license   license.txt
 * @category  ProductRentalRental
 *
 * 2016 ROJA45 - All rights reserved.
 *
 * DISCLAIMER
 * Changing this file will render any support provided by us null and void.
 */

/**
 * ProductRentalRental
 *
 * @author    Roja45
 * @copyright 2016 Roja45
 * @license   license.txt
 * @category  Class
 *
 * 2016 ROJA45 - All rights reserved.
 *
 * DISCLAIMER
 * Changing this file will render any support provided by us null and void.
 */
class ProductRentalRental extends ObjectModel
{
    public $id_roja45_product_rental;
    public $id_roja45_product;
    public $id_customer;
    public $id_lang;
    public $id_shop;
    public $id_currency;
    public $id_roja45_product_rental_status;
    public $id_delivery_address;
    public $id_collection_address;
    public $reference;
    public $type;
    public $total;
    public $date_add;
    public $date_upd;
    public $modified;
    public $cod;
    public $tax_calculator;
    public $uid;

    /**
     * @see ObjectModel::$definition
     */
    public static $definition = array(
        'table' => 'roja45_productrental_rental',
        'primary' => 'id_roja45_product_rental',
        'multilang' => false,
        'fields' => array(
            'id_customer' => array('type' => self::TYPE_INT),
            'id_customer' => array('type' => self::TYPE_INT),
            'id_lang' => array('type' => self::TYPE_INT),
            'id_shop' => array('type' => self::TYPE_INT),
            'id_currency' => array('type' => self::TYPE_INT),
            'id_delivery_address' => array('type' => self::TYPE_INT),
            'id_collection_address' => array('type' => self::TYPE_INT),
            'id_roja45_product_rental_status' => array('type' => self::TYPE_INT),
            'reference' => array('type' => self::TYPE_STRING),
            'type' => array('type' => self::TYPE_INT),
            'total' => array('type' => self::TYPE_FLOAT),
            'date_add' => array('type' => self::TYPE_DATE, 'validate' => 'isDateFormat', 'required' => true),
            'date_upd' => array('type' => self::TYPE_DATE, 'validate' => 'isDateFormat', 'required' => true),
            'modified' => array('type' => self::TYPE_BOOL, 'validate' => 'isBool'),
            'cod' => array('type' => self::TYPE_BOOL, 'validate' => 'isBool'),
            'uid' => array('type' => self::TYPE_STRING),
        ),
    );

    public function __construct($id = null, $id_lang = null)
    {
        parent::__construct($id, $id_lang);
    }

    public function add($auto_date = true, $null_values = false)
    {
        $return = parent::add($auto_date, $null_values);
        Hook::exec(
            'actionProductRentalAddRental',
            array(
                'rental' => $this
            )
        );
        return $return;
    }

    public function update($null_values = false)
    {
        $return = parent::update($null_values);
        Hook::exec(
            'actionProductRentalUpdateRental',
            array(
                'rental' => $this
            )
        );
        return $return;
    }

    public function delete()
    {
        $return = true;
        $return &= $this->deleteAll();
        $return &= parent::delete();
        Hook::exec(
            'actionProductRentalDeleteRental',
            array(
                'rental' => $this
            )
        );
        return $return;
    }

    public static function exists($id_roja45_product_rental)
    {
        $sql = '
            SELECT id_roja45_product_rental
            FROM `' . _DB_PREFIX_ . 'roja45_productrental_rental` r
            WHERE r.id_roja45_product_rental = '. (int) $id_roja45_product_rental;
        return (bool) (Db::getInstance(_PS_USE_SQL_SLAVE_)->getValue($sql)>0);
    }

    public static function ordered($id_roja45_product_rental)
    {
        $sql = '
            SELECT id_order
            FROM `' . _DB_PREFIX_ . 'roja45_productrental_rentalpayment` rp
            WHERE rp.id_roja45_product_rental = '. (int) $id_roja45_product_rental;
        return (bool) (Db::getInstance(_PS_USE_SQL_SLAVE_)->getValue($sql)>0);
    }

    public function isRemovable()
    {
        return true;
    }

    public function isLocked()
    {
        return false;
    }

    public function isAdminRental()
    {
        return ProductRentalRentalStatus::isStatus($this, ProductRentalRentalStatus::$ADMN);
    }

    public function isConfirmed()
    {
        return ProductRentalRentalProcess::exists($this->id, ProductRentalRentalStatus::$CONF);
    }

    public function isComplete()
    {
        return (
            ProductRentalRentalProcess::exists($this->id, ProductRentalRentalStatus::$COMP) ||
            ProductRentalRentalProcess::exists($this->id, ProductRentalRentalStatus::$CCLD)
        );
    }

    public function isPreReserved()
    {
        return ProductRentalRentalProcess::exists($this->id, ProductRentalRentalStatus::$PRES);
    }

    public function isDepositPaid()
    {
        return ProductRentalRentalProcess::exists($this->id, ProductRentalRentalStatus::$DPST);
    }

    public function deleteAll()
    {
        $return = true;
        $return &= $this->deleteProducts();
        $return &= $this->deleteNotes();
        $return &= $this->deletePayments();
        $return &= $this->deleteProcess();
        return $return;
    }

    public function deleteProducts()
    {
        return ProductRentalRentalProduct::deleteAll((int)$this->id);
    }

    public function addNote($note)
    {
        $object = new ProductRentalRentalNote();
        $object->id_roja45_product_rental = (int)$this->id;
        $object->note = $note;
        if ($object->save()) {
            return true;
        } else {
            throw new Exception(Db::getInstance()->getMsgError());
        }
    }

    public function deleteNote($id_roja45_product_note)
    {
        $object = new ProductRentalRentalNote($id_roja45_product_note);
        if ($object->delete()) {
            return true;
        } else {
            throw new Exception(Db::getInstance()->getMsgError());
        }
    }

    public function getNotes()
    {
        $notes = ProductRentalRentalNote::getList($this->id);
        if (!count($notes)) {
            return false;
        }
        return $notes;
    }

    public function getMessages()
    {
        $messages = ProductRentalRentalMessage::getList($this->id);
        if (!count($messages)) {
            return false;
        }
        return $messages;
    }

    public function deleteNotes()
    {
        return ProductRentalRentalNote::deleteAll((int)$this->id);
    }

    public function deleteProcess()
    {
        return ProductRentalRentalProcess::deleteAll((int)$this->id);
    }

    public function deletePayments()
    {
        return ProductRentalRentalPayment::deleteAll((int)$this->id);
    }

    public function closeRental()
    {
        $this->type = ProductRentalRental::CLOSED;
        $this->save();
    }

    public function updateFromOrder($order)
    {
        $rental_products = $this->getProducts();
        if (count($rental_products)>0) {
            $stock_management_active = Configuration::get('PS_ADVANCED_STOCK_MANAGEMENT');
            $this->reference = Tools::strtoupper((Tools::passwdGen(9, 'NO_NUMERIC')));
            $this->id_customer = (int) $order->id_customer;
            $this->save();
            $this->setStatus(ProductRentalRentalStatus::$CCNF);

            $id_roja45_product_rental_payment = RojaFortyFiveProductRentalCore::getCustomerRequirement(
                'ROJA45_PRODUCTRENTAL_ID_RENTAL_PAYMENT'
            );
            $product_rental_payment = new ProductRentalRentalPayment($id_roja45_product_rental_payment);
            $product_rental_payment->id_order = $order->id;
            $product_rental_payment->date_due = date('Y-m-d H:i:s');
            $product_rental_payment->date_paid = date('Y-m-d H:i:s');
            $product_rental_payment->total = $order->total_paid_tax_excl;
            $product_rental_payment->total_with_tax = $order->total_paid_tax_incl;

            $requires_confirmation = false;
            foreach ($rental_products as $rental_product) {
                $rental = new ProductRentalDetails($rental_product['id_roja45_product']);
                if (!$rental->instant_rental) {
                    $requires_confirmation = true;
                }
                $product = new Product(
                    $rental_product['id_product'],
                    false,
                    Context::getContext()->language->id
                );
                $models = ProductRentalRentalModel::getModels($rental_product['id_roja45_product_rental_product']);
                foreach ($models as $model) {
                    if ($stock_management_active && (int)$product->advanced_stock_management == 1) {
                        $sql = new DbQuery();
                        $sql->select('id_warehouse');
                        $sql->from('order_detail', 'od');
                        $sql->where('od.id_order=' . (int)$order->id);
                        $sql->where('od.product_id=' . (int)$rental_product['id_product']);
                        $sql->where('od.product_attribute_id=' . (int)$model['id_product_attribute']);

                        $id_warehouse = Db::getInstance()->getValue($sql);
                        $warehouse = new Warehouse($id_warehouse);
                        $qty_in_cart = $model['qty'];
                        $price = str_replace(',', '.', $product->wholesale_price);
                        if ($price == 0) {
                            $price = 0.000001;
                        }

                        $super_admin_array = Employee::getEmployeesByProfile(_PS_ADMIN_PROFILE_, true);
                        $employee = new Employee($super_admin_array[0]['id_employee']);

                        $price = round((float)($price), 6);
                        $manager = StockManagerFactory::getManager();
                        $manager->addProduct(
                            $rental_product['id_product'],
                            $model['id_product_attribute'],
                            $warehouse,
                            $qty_in_cart,
                            Configuration::get('PS_STOCK_MVT_INC_REASON_DEFAULT'),
                            $price,
                            true,
                            null,
                            $employee
                        );
                    } else {
                        $stock_on_hand = (int)StockAvailable::getQuantityAvailableByProduct(
                            $rental_product['id_product'],
                            $model['id_product_attribute']
                        );
                        $qty_in_cart = $model['qty'];
                        $qty = $stock_on_hand + $qty_in_cart;
                        StockAvailable::setQuantity(
                            $rental_product['id_product'],
                            $model['id_product_attribute'],
                            $qty
                        );
                    }
                }
            }

            $this->setStatus(ProductRentalRentalStatus::$DPST);
            if ($order->total_paid == $order->total_paid_real) {
                $product_rental_payment->completed = 1;
                $this->setStatus(ProductRentalRentalStatus::$PAYC);
                if ($requires_confirmation) {
                    $this->setStatus(ProductRentalRentalStatus::$PRES);
                } elseif (Configuration::get('ROJA45_PRODUCTRENTAL_AUTOCONFIRM')) {
                    $this->setStatus(ProductRentalRentalStatus::$CONF);
                }
            } else {
                $product_rental_payment->completed = 0;
                $this->setStatus(ProductRentalRentalStatus::$PAYU);
                if ($requires_confirmation) {
                    $this->setStatus(ProductRentalRentalStatus::$PRES);
                }
            }
            $product_rental_payment->save();
            SpecificPrice::deleteByIdCart($product_rental_payment->id_cart);
            RojaFortyFiveProductRentalCore::clearCustomerRequirement('ROJA45_PRODUCTRENTAL_ID_RENTAL_PAYMENT');
        }
    }

    public function resetQuantities()
    {
        $rental_products = $this->getProducts();
        $stock_management_active = Configuration::get('PS_ADVANCED_STOCK_MANAGEMENT');
        foreach ($rental_products as $rental_product) {
            $product = new Product(
                $rental_product['id_product'],
                false,
                Context::getContext()->language->id
            );
            $models = ProductRentalRentalModel::getModels($rental_product['id_roja45_product_rental_product']);
            foreach ($models as $model) {
                if ($stock_management_active && (int)$product->advanced_stock_management == 1) {
                    /*$warehouse_list = Warehouse::getProductWarehouseList(
                        $rental_product['id_product'],
                        $rental_product['id_product_attribute'],
                        Context::getContext()->shop->id_shop
                    );
                    if (count($warehouse_list) == 0) {
                        $warehouse_list = Warehouse::getProductWarehouseList(
                            $rental_product['id_product'],
                            $rental_product['id_product_attribute']
                        );
                    }
                    $warehouse_in_stock = array();
                    $manager = StockManagerFactory::getManager();*/
                } else {
                    $stock_on_hand = (int) StockAvailable::getQuantityAvailableByProduct(
                        $rental_product['id_product'],
                        $model['id_product_attribute']
                    );
                    $qty_in_cart = $model['qty'];
                    $qty = $stock_on_hand + $qty_in_cart;
                    StockAvailable::setQuantity($rental_product['id_product'], $model['id_product_attribute'], $qty);
                }
            }
        }
    }

    public function getProduct($id_roja45_product)
    {
        $sql = new DbQuery();
        $sql->select('rp.id_roja45_product_rental_product');
        $sql->from('roja45_productrental_rentalproduct', 'rp');
        $sql->where('rp.id_roja45_product_rental='. (int) $this->id_roja45_product_rental);
        $sql->where('rp.id_roja45_product='. (int) $id_roja45_product);
        return Db::getInstance()->getValue($sql);
    }

    public function getModel($id_roja45_product_model)
    {
        $sql = new DbQuery();
        $sql->select('rp.id_roja45_product_rental_model');
        $sql->from('roja45_productrental_rentalmodel', 'rp');
        $sql->where('rp.id_roja45_product_rental='. (int) $this->id_roja45_product_rental);
        $sql->where('rp.id_roja45_product_model='. (int) $id_roja45_product_model);
        return Db::getInstance()->getValue($sql);
    }

    public static function returnModel($id_roja45_product_rental_model)
    {
        $sql = '
          UPDATE `' . _DB_PREFIX_ . 'roja45_productrental_rentalmodel`
          SET returned = 1
          WHERE `id_roja45_product_rental_model` = ' . (int)$id_roja45_product_rental_model;
        Db::getInstance()->execute($sql);
    }

    public static function deleteRentalProduct($id_cart, $id_product, $id_product_attribute)
    {
        $sql = '
            SELECT rpr.id_roja45_product_rental_product, rm.id_roja45_product_rental_model
            FROM `' . _DB_PREFIX_ . 'roja45_productrental_rentalproduct` rpr
            LEFT JOIN `' . _DB_PREFIX_ . 'roja45_productrental_rentalpayment` rpy
            ON (rpr.id_roja45_product_rental = rpy.id_roja45_product_rental)
            LEFT JOIN `' . _DB_PREFIX_ . 'roja45_productrental_rentalmodel` rm
            ON (rpr.id_roja45_product_rental_product = rm.id_roja45_product_rental_product)
            WHERE rpr.id_product = ' . (int)$id_product . '
            AND  rm.id_product_attribute = ' . (int)$id_product_attribute . '
            AND  rpy.id_cart = ' . (int)$id_cart;
        if (!$return = Db::getInstance()->getRow($sql)) {
            throw new Exception(Db::getInstance(_PS_USE_SQL_SLAVE_)->getMsgError());
        } else {
            // delete model
            $rental_model = new ProductRentalRentalModel($return['id_roja45_product_rental_model']);
            if (!Validate::isLoadedObject($rental_model)) {
                return false;
            }
            $rental_model->delete();
            $models = ProductRentalRentalModel::getModels($return['id_roja45_product_rental_product']);
            if (!count($models)) {
                $rental_product = new ProductRentalRentalProduct($return['id_roja45_product_rental_product']);
                if (!Validate::isLoadedObject($rental_product)) {
                    return false;
                }
                $rental_product->delete();
            }
        }
        return true;
    }

    public function deleteModel($id_product, $id_product_attribute)
    {
        $sql = '
            SELECT rpr.id_roja45_product_rental_product, rm.id_roja45_product_rental_model
            FROM `' . _DB_PREFIX_ . 'roja45_productrental_rentalproduct` rpr
            LEFT JOIN `' . _DB_PREFIX_ . 'roja45_productrental_rentalmodel` rm
            ON (rpr.id_roja45_product_rental_product = rm.id_roja45_product_rental_product)
            WHERE rpr.id_roja45_product_rental = ' . (int)$this->id_roja45_product_rental . '
            AND rpr.id_product = ' . (int)$id_product . '
            AND  rm.id_product_attribute = ' . (int)$id_product_attribute;
        if ($return = Db::getInstance()->getRow($sql)) {
            $rental_model = new ProductRentalRentalModel($return['id_roja45_product_rental_model']);
            if (!Validate::isLoadedObject($rental_model)) {
                return false;
            }
            $rental_model->delete();
            $models = ProductRentalRentalModel::getModels($return['id_roja45_product_rental_product']);
            if (!count($models)) {
                $rental_product = new ProductRentalRentalProduct($return['id_roja45_product_rental_product']);
                if (!Validate::isLoadedObject($rental_product)) {
                    return false;
                }
                $rental_product->delete();
            }
        }
        return true;
    }

    public function getPayments()
    {
        $payments = ProductRentalRentalPayment::getList($this->id);
        if (!count($payments)) {
            return array();
        }
        foreach ($payments as &$payment) {
            //$payment['total_inc'] = $this->addTax($payment['total']);
            $payment['total_inc'] = 0;
            $payment['taxes'] = $payment['total_inc'] - $payment['total'];
            $payment['total_paid'] = $payment['total'];

            if ($payment['id_order']) {
                $payment['total_paid_confirmed_inc'] = $payment['total_inc'];
                $payment['total_paid_confirmed_exc'] = $payment['total'];
            } else {
                $payment['total_paid_confirmed_inc'] = 0;
                $payment['total_paid_confirmed_exc'] = 0;
            }

            if ($payment['date_paid'] == '0000-00-00 00:00:00') {
                $payment['date_paid'] = '';
                $payment['paid'] = 0;
                $payment['total_paid'] = 0;
            } else {
                $payment['paid'] = 1;
                $payment['total_paid'] = $payment['total'];
            }
        }
        return $payments;
    }

    public static function getDatesForProduct($id_roja45_product, $id_parent)
    {
        $sql = '
            SELECT *
            FROM `' . _DB_PREFIX_ . 'roja45_productrental_rental`
            WHERE `id_roja45_property` = ' . (int)$id_roja45_product . '
            AND id_parent=' . (int)$id_parent;
        return Db::getInstance()->executeS($sql);
    }

    public static function getAvailability($id_roja45_product)
    {
        $availability = array();
        $rental_product = new ProductRentalDetails($id_roja45_product);
        $product = new Product($rental_product->id_product);
        $models = ProductRentalModel::getModels($id_roja45_product);
        $total_stock_on_hand = 0;
        foreach ($models as &$model) {
            if (!isset($availability[$model['id_product_attribute']])) {
                $availability[$model['id_product_attribute']] = array(
                    'total_available' => 0,
                    'max_rented' => 0,
                    'dates' => array(),
                    'availability' => 0,
                );
            }
            $model_obj = new ProductRentalModel($model['id_roja45_product_model']);
            if ($model_obj->enabled) {
                if ($model_obj->is_linked) {
                    if (Configuration::get('PS_ADVANCED_STOCK_MANAGEMENT') &&
                        (int)$product->advanced_stock_management == 1
                    ) {
                        $warehouse_list = Warehouse::getProductWarehouseList(
                            $rental_product->id_product,
                            $model['id_product_attribute'],
                            Context::getContext()->shop->id_shop
                        );
                        if (count($warehouse_list) == 0) {
                            $warehouse_list = Warehouse::getProductWarehouseList(
                                $rental_product->id_product,
                                $model['id_product_attribute']
                            );
                        }
                        $warehouse_in_stock = array();
                        $manager = StockManagerFactory::getManager();

                        $stock_on_hand = 0;
                        foreach ($warehouse_list as $warehouse) {
                            $product_real_quantities = $manager->getProductRealQuantities(
                                $rental_product->id_product,
                                $model['id_product_attribute'],
                                array($warehouse['id_warehouse']),
                                true
                            );
                            if ($product_real_quantities > 0 || Pack::isPack((int)$rental_product->id_product)) {
                                $warehouse_in_stock[] = $warehouse;
                            }
                            $stock_on_hand += $product_real_quantities;
                        }
                    } else {
                        $stock_on_hand = StockAvailable::getQuantityAvailableByProduct(
                            $rental_product->id_product,
                            $model['id_product_attribute'],
                            (int)Context::getContext()->shop->id
                        );
                    }
                } else {
                    $stock_on_hand = (int)$model['qty_available'];
                }
                $availability[$model['id_product_attribute']]['total_available'] += $stock_on_hand;
                $availability[$model['id_product_attribute']]['availability'] += $stock_on_hand;
                $total_stock_on_hand += $stock_on_hand;
            }
        }
        $availability['all']['total_available'] = $total_stock_on_hand;
        $sql = new DbQuery();
        $sql->select('*');
        $sql->from('roja45_productrental_rental', 'r');
        $rentals = Db::getInstance()->executeS($sql);
        //$total_available = 0;
        $total_max_rented = 0;
        foreach ($rentals as $rental) {
            $rental_obj = new ProductRentalRental($rental['id_roja45_product_rental']);
            $reconditiondays = (int)Configuration::get('ROJA45_PRODUCTRENTAL_RECONDITIONDAYS');
            if ($rental_obj->statusBlocksCalendar()) {
                foreach ($rental_obj->getProducts() as $product) {
                    if (($product['id_roja45_product'] == $id_roja45_product)) {
                        //$max_rented = 0;
                        foreach (ProductRentalRentalModel::getModels($product['id_roja45_product_rental_product']) as &$model) {
                            if (empty($model['collection_time'])) {
                                $model['collection_time'] = Configuration::get('ROJA45_PRODUCTRENTAL_COLLECTIONTIME');
                            }
                            if (empty($model['return_time'])) {
                                $model['return_time'] = Configuration::get('ROJA45_PRODUCTRENTAL_RETURNTIME');
                            }
                            $end_date = new DateTime($model['end_date'] . ' ' . $model['return_time']);
                            if ($reconditiondays) {
                                $end_date->add(new DateInterval('P' . ($reconditiondays) . 'D'));
                            } else {
                                //$end_date->add(new DateInterval('P1D'));
                            }
                            $model['end_date'] = $end_date->format('Y-m-d');
                            $rate_duration = new ProductRentalRateDuration($model['id_roja45_product_rateduration']);
                            $periods = $rate_duration->getPeriods(
                                $model['start_date'] . ' ' . $model['collection_time'],
                                $model['end_date'] . ' ' . $model['return_time']
                            );

                            if (count($periods)) {
                                for ($i = 0; $i <= count($periods); $i++) {
                                    if ($i < count($periods)) {
                                        $current_period = $periods[$i]->period;
                                    } else {
                                        $current_period = $periods[$i - 1]->period;
                                        $current_period = new DateTime($current_period);
                                        $current_period->add(new DateInterval('P1D'));
                                        $current_period = $current_period->format('Y-m-d');
                                    }
                                    if (isset($availability[$model['id_product_attribute']]['dates'][$current_period])) {
                                        $entry = $availability[$model['id_product_attribute']]['dates'][$current_period];
                                        $count = (int)$entry['count'] + $model['qty'];
                                        $entry['date'] = $current_period;

                                        if (strtotime($model['return_time']) < strtotime($entry['time'])) {
                                            $entry['time'] = $model['return_time'];
                                        }

                                        $entry['count'] = (string)$count;
                                        if ($entry['type'] == 3) {
                                            $entry['type'] = 2;
                                        }
                                        $entry['total_available'] -= $model['qty'];
                                        $entry['total_rented'] += $model['qty'];
                                        $availability[$model['id_product_attribute']]['dates'][$current_period] = $entry;
                                    } else {
                                        $entry = array();
                                        $entry['date'] = $current_period;
                                        $entry['time'] = $model['return_time'];
                                        $entry['count'] = $model['qty'];
                                        if ($i == 0) {
                                            $entry['type'] = 1;
                                            $entry['total_available'] =
                                                $availability[$model['id_product_attribute']]['total_available'] - $model['qty'];
                                            $entry['total_rented'] = $model['qty'];
                                        } elseif (($i) == count($periods)) {
                                            $entry['type'] = 3;
                                            $entry['total_available'] =
                                                $availability[$model['id_product_attribute']]['total_available'];
                                            $entry['total_rented'] = 0;
                                        } else {
                                            $entry['type'] = 2;
                                            $entry['total_available'] =
                                                $availability[$model['id_product_attribute']]['total_available'] - $model['qty'];
                                            $entry['total_rented'] = $model['qty'];
                                        }
                                        $availability[$model['id_product_attribute']]['dates'][$current_period] = $entry;
                                    }

                                    if (isset($availability['all']['dates'][$current_period])) {
                                        $entry = $availability['all']['dates'][$current_period];
                                        $count = (int)$entry['count'] + $model['qty'];
                                        $entry['date'] = $current_period;

                                        if (strtotime($model['return_time']) < strtotime($entry['time'])) {
                                            $entry['time'] = $model['return_time'];
                                        }

                                        $entry['count'] = (string)$count;
                                        if ($entry['type'] == 3) {
                                            $entry['type'] = 2;
                                        }
                                        $entry['total_available'] -= $model['qty'];
                                        $entry['total_rented'] += $model['qty'];
                                        $availability['all']['dates'][$current_period] = $entry;
                                    } else {
                                        $entry = array();
                                        $entry['date'] = $current_period;
                                        $entry['time'] = $model['return_time'];
                                        $entry['count'] = $model['qty'];
                                        if ($i == 0) {
                                            $entry['type'] = 1;
                                            $entry['total_available'] =
                                                $availability['all']['total_available'] - $model['qty'];
                                            $entry['total_rented'] = $model['qty'];
                                        } elseif (($i) == count($periods)) {
                                            $entry['type'] = 3;
                                            $entry['total_available'] = $availability['all']['total_available'];
                                            $entry['total_rented'] = 0;
                                        } else {
                                            $entry['type'] = 2;
                                            $entry['total_available'] =
                                                $availability['all']['total_available'] - $model['qty'];
                                            $entry['total_rented'] = $model['qty'];
                                        }
                                        $availability['all']['dates'][$current_period] = $entry;
                                    }
                                }
                            }

                            $max_rented = 0;
                            foreach ($availability[$model['id_product_attribute']]['dates'] as $date) {
                                if ($date['total_rented'] > $max_rented) {
                                    $max_rented = $date['total_rented'];
                                }
                            }
                            $availability[$model['id_product_attribute']]['max_rented'] = $max_rented;
                            $availability[$model['id_product_attribute']]['availability'] =
                                $availability[$model['id_product_attribute']]['total_available'] - $max_rented;
                            $total_max_rented += $max_rented;
                        }
                    }
                }
            }
        }
        $availability['all']['max_rented'] = $total_max_rented;
        $availability['all']['availability'] = $availability['all']['total_available'] - $total_max_rented;

        $unavailables = ProductUnavailable::getUnavailable($id_roja45_product);
        if (count($unavailables)) {
            foreach ($unavailables as $unavailable) {
                $id_product_attribute = 0;
                if ($unavailable['id_roja45_product_model']) {
                    $model = new ProductRentalModel($unavailable['id_roja45_product_model']);
                    $id_product_attribute = $model->id_product_attribute;
                }
                if (!isset($availability[$id_product_attribute])) {
                    $availability[$id_product_attribute] = array();
                }

                $start_date = new DateTime($unavailable['start_date']);
                $end_date = new DateTime($unavailable['end_date']);
                $end_date->add(new DateInterval("P1D"));
                $period = new DatePeriod(
                    $start_date,
                    new DateInterval('P1D'),
                    $end_date
                );
                $periods = iterator_to_array($period);
                foreach ($periods as $date) {
                    $str = $date->format('Y-m-d');
                    if (!isset($availability[$id_product_attribute]['dates'][$str])) {
                        $availability[$id_product_attribute]['dates'][$str]['unavailable'] = 1;
                    }
                }
            }
        }
        return $availability;
    }

    public static function getAllRentalsForModel(
        $id_roja45_product,
        $id_roja45_product_model,
        $collection_date = null,
        $return_date = null,
        $ignore_list = null
    ) {
        if (!is_array($ignore_list)) {
            $ignore_list = array();
        }
        $rentals = ProductRentalRental::getRentalsForModel(
            $id_roja45_product,
            $id_roja45_product_model
        );
        $rental_product = new ProductRentalDetails($id_roja45_product);
        $rental_model = new ProductRentalModel($id_roja45_product_model);
        $model_dates = array();
        $stock_on_hand = 0;
        $product = new Product($rental_product->id_product, false);
        if ($rental_model->enabled) {
            if ($rental_model->is_linked) {
                if (Configuration::get('PS_ADVANCED_STOCK_MANAGEMENT') &&
                    (int)$product->advanced_stock_management == 1) {
                    $warehouse_list = Warehouse::getProductWarehouseList(
                        $rental_product->id_product,
                        $rental_model->id_product_attribute,
                        Context::getContext()->shop->id_shop
                    );
                    if (count($warehouse_list) == 0) {
                        $warehouse_list = Warehouse::getProductWarehouseList(
                            $rental_product->id_product,
                            $rental_model->id_product_attribute
                        );
                    }
                    // Does the product is in stock ?
                    // If yes, get only warehouse where the product is in stock

                    $warehouse_in_stock = array();
                    $manager = StockManagerFactory::getManager();


                    foreach ($warehouse_list as $warehouse) {
                        $product_real_quantities = $manager->getProductRealQuantities(
                            $rental_product->id_product,
                            $rental_model->id_product_attribute,
                            array($warehouse['id_warehouse']),
                            true
                        );

                        if ($product_real_quantities > 0 || Pack::isPack((int)$rental_product->id_product)) {
                            $warehouse_in_stock[] = $warehouse;
                        }
                        $stock_on_hand += $product_real_quantities;
                    }
                } else {
                    $stock_on_hand = StockAvailable::getQuantityAvailableByProduct(
                        $rental_product->id_product,
                        $rental_model->id_product_attribute,
                        (int)Context::getContext()->shop->id
                    );
                }
            } else {
                $stock_on_hand = (int)$rental_model->qty_available;
            }
        }

        $total_available = $stock_on_hand;
        $max_rented = 0;
        $model_availability = array();
        foreach ($rentals as $rental) {
            // TODO - if rental in ignore list, skip
            if (!in_array($rental['reference'], $ignore_list)) {
                $rentalObj = new ProductRentalRental($rental['id_roja45_product_rental']);
                $reconditiondays = (int)Configuration::get('ROJA45_PRODUCTRENTAL_RECONDITIONDAYS');
                $rental_status = new ProductRentalRentalStatus($rental['id_roja45_product_rental_status']);
               // if (ProductRentalRentalProcess::exists($rental['id_roja45_product_rental'], ProductRentalRentalStatus::$CCNF)) {
                if ($rental_status->block_calendar) {
                    foreach ($rentalObj->getProducts() as $product) {
                        foreach (ProductRentalRentalModel::getModels($product['id_roja45_product_rental_product']) as $model) {
                            if ($model['id_roja45_product_model'] == $id_roja45_product_model) {
                                $start_date = new DateTime($model['start_date'] . ' ' . $model['collection_time']);
                                $end_date = new DateTime($model['end_date'] . ' ' . $model['return_time']);
                                $period_end_date = new DateTime($model['end_date'] . ' ' . $model['return_time']);

                                if ($reconditiondays) {
                                    $period_end_date->add(new DateInterval('P' . ($reconditiondays+1) . 'D'));
                                } else {
                                    $period_end_date->add(new DateInterval('P1D'));
                                }

                                $date_requested = true;
                                if ($collection_date && (strtotime($collection_date) > strtotime($end_date->format('Y-m-d') . ' ' . $rental['return_time']))
                                ) {
                                    $date_requested = false;
                                }
                                if ($return_date && (strtotime($return_date) <= strtotime($rental['start_date'] . ' ' . $rental['collection_time']))) {
                                    $date_requested = false;
                                }

                                if ($date_requested) {
                                    $period = new DatePeriod(
                                        $start_date,
                                        new DateInterval('P1D'),
                                        $period_end_date
                                    );
                                    $periods = iterator_to_array($period);
                                    $day = 0;

                                    foreach ($periods as $date) {
                                        // TODO - assign earlist time available.
                                        $time = $end_date->format('H:i');
                                        $str = $date->format('Y-m-d');
                                        $entry = array();
                                        if (isset($model_dates[$str])) {
                                            $entry = $model_dates[$str];
                                            $count = (int)$entry['count'] + $rental['qty'];
                                            $entry['date'] = $str;

                                            if (strtotime($time) < strtotime($entry['time'])) {
                                                $entry['time'] = $time;
                                            }

                                            $entry['count'] = (string)$count;
                                            if ($entry['type'] == 3) {
                                                $entry['type'] = 2;
                                            }
                                            $entry['total_available'] -= $rental['qty'];
                                            $entry['total_rented'] += $rental['qty'];
                                            if ($entry['total_rented'] > $max_rented) {
                                                $max_rented = $entry['total_rented'];
                                            }
                                            $model_dates[$str] = $entry;
                                        } else {
                                            $entry['date'] = $str;
                                            $entry['time'] = $time;
                                            $entry['count'] = $rental['qty'];
                                            if ($day == 0) {
                                                $entry['type'] = 1;
                                                $entry['total_available'] = $total_available - $rental['qty'];
                                                $entry['total_rented'] = $rental['qty'];
                                                if ($rental['qty'] > $max_rented) {
                                                    $max_rented = $rental['qty'];
                                                }
                                            } elseif (($day + 1) == iterator_count($period)) {
                                                $entry['type'] = 3;
                                                $entry['total_available'] = $total_available;
                                                $entry['total_rented'] = 0;
                                                //$max_rented = 0;
                                            } else {
                                                $entry['type'] = 2;
                                                $entry['total_available'] = $total_available - $rental['qty'];
                                                $entry['total_rented'] = $rental['qty'];
                                                if ($rental['qty'] > $max_rented) {
                                                    $max_rented = $rental['qty'];
                                                }
                                            }
                                            $model_dates[$str] = $entry;
                                        }
                                        $day++;
                                    }
                                }
                            }
                        }
                    }
                }
            }
        }
        $model_availability['id_roja45_product_model'] = $id_roja45_product_model;
        $model_availability['dates'] = $model_dates;
        $model_availability['total_available'] = $stock_on_hand;
        $model_availability['max_rented'] = $max_rented;
        $model_availability['availability'] = $stock_on_hand-$max_rented;

        return $model_availability;
    }

    public static function getAllOpenRentals()
    {
        $sql = new DbQuery();
        $sql->select('id_roja45_product_rental_status');
        $sql->from('roja45_productrental_rentalstatus', 'rs');
        $sql->where('rs.code NOT IN ("DLTD, CLSD")');
        $results = Db::getInstance()->executeS($sql);
        $ids = array();
        foreach ($results as $row) {
            $ids[] = $row['id_roja45_product_rental_status'];
        }
        $ids = implode(',', $ids);

        $sql = new DbQuery();
        $sql->select('*');
        $sql->from('roja45_productrental_rental', 'rp');
        $sql->where('rp.id_roja45_product_rental_status IN ('.$ids.')');
        return Db::getInstance()->executeS($sql);
    }

    public static function getRentalsForProduct($id_roja45_product)
    {
        $sql = '
            SELECT *
            FROM `' . _DB_PREFIX_ . 'roja45_productrental_rental` r
            LEFT JOIN `' . _DB_PREFIX_ . 'roja45_productrental_rentalproduct` rp
            ON (r.id_roja45_product_rental = rp.id_roja45_product_rental)
            WHERE rp.`id_roja45_product` = ' . (int)$id_roja45_product;

        return Db::getInstance()->executeS($sql);
    }

    public static function getRentalsForModel(
        $id_roja45_product,
        $id_roja45_product_model,
        $unavailable = true
    ) {
        $sql = new DbQuery();
        $sql->select('*');
        $sql->from(
            'roja45_productrental_rentalproduct',
            'rp'
        );
        $sql->leftJoin(
            'roja45_productrental_rentalmodel',
            'rm',
            'rp.id_roja45_product_rental_product = rm.id_roja45_product_rental_product'
        );
        $sql->leftJoin(
            'roja45_productrental_rental',
            'r',
            'r.id_roja45_product_rental = rp.id_roja45_product_rental'
        );
        $sql->leftJoin(
            'roja45_productrental_rentalstatus',
            'rs',
            'r.id_roja45_product_rental_status = rs.id_roja45_product_rental_status'
        );
        $sql->where('rp.id_roja45_product = ' . (int)$id_roja45_product);
        $sql->where('rm.id_roja45_product_model = ' . (int)$id_roja45_product_model);
        if ($unavailable) {
            $sql->where('rs.block_calendar = 1');
            $sql->where('rm.returned = 0');
        }

        return Db::getInstance()->executeS($sql);
    }

    public function getModelsOutstanding()
    {
        $models = array();
        foreach ($this->getProducts() as $product) {
            foreach (ProductRentalRentalModel::getModels($product['id_roja45_product_rental_product']) as $model) {
                if (!$model['returned']) {
                    $models[] = $model['id_roja45_product_rental_model'];
                }
            }
        }

        if (count($models)) {
            return $models;
        } else {
            return false;
        }
    }

    public static function getRentalsForProductDate(
        $id_roja45_product,
        $date,
        $blocks_calendar = false
    ) {
        $date = DateTime::createFromFormat('Y-m-d', $date);

        $sql = new DbQuery();
        $sql->select(
            'rp.id_roja45_product_rental,
            rm.id_roja45_product_model,
            rm.id_product_attribute,
            rm.qty,
            r.id_roja45_product_rental_status'
        );
        $sql->from('roja45_productrental_rentalproduct', 'rp');
        $sql->leftJoin(
            'roja45_productrental_rentalmodel',
            'rm',
            'rm.id_roja45_product_rental_product = rp.id_roja45_product_rental_product'
        );
        $sql->leftJoin(
            'roja45_productrental_rental',
            'r',
            'r.id_roja45_product_rental = rp.id_roja45_product_rental'
        );
        $sql->leftJoin(
            'roja45_productrental_rentalstatus',
            'rs',
            'r.id_roja45_product_rental_status = rs.id_roja45_product_rental_status'
        );
        $sql->where('rp.id_roja45_product=' . (int) $id_roja45_product);
        if ($blocks_calendar) {
            $sql->where('rs.block_calendar=1');
        }

        $sql->where('rm.returned=0');
        $sql->where('rm.start_date<="' . pSQL($date->format('Y-m-d')) .'"');
        $sql->where('rm.end_date>"' . pSQL($date->format('Y-m-d')) .'"');

        $bookings = Db::getInstance()->executeS($sql);
        return $bookings;
    }

    public static function getRentalsForDateRange(
        $arrival_date,
        $departure_date,
        $id_lang,
        $id_shop = null,
        $id_roja45_product = null
    ) {
        $sql = new DbQuery();
        $sql->select(
            'rp.id_roja45_product, 
            rm.*, r.*, rs.code, 
            rsl.status as status_full, 
            rs.color, CONCAT(c.`firstname`, \' \', c.`lastname`) AS `customer_name`'
        );
        $sql->from('roja45_productrental_rentalmodel', 'rm');
        $sql->leftJoin(
            'roja45_productrental_rentalproduct',
            'rp',
            '(rp.id_roja45_product_rental_product = rm.id_roja45_product_rental_product)'
        );
        $sql->leftJoin(
            'roja45_productrental_details',
            'd',
            '(d.id_roja45_product = rp.id_roja45_product)'
        );
        if ($id_shop) {
            $sql->leftJoin(
                'roja45_productrental_details_shop',
                'ds',
                '(d.id_roja45_product = ds.id_roja45_product)'
            );
            $sql->where('ds.id_shop='.$id_shop);
            $sql->where('ds.enabled=1');
        } else {
            $sql->where('d.enabled=1');
        }
        $sql->leftJoin(
            'roja45_productrental_rental',
            'r',
            'r.id_roja45_product_rental = rp.id_roja45_product_rental'
        );
        $sql->leftJoin(
            'roja45_productrental_rentalstatus',
            'rs',
            '(rs.id_roja45_product_rental_status = r.id_roja45_product_rental_status)'
        );
        $sql->leftJoin(
            'roja45_productrental_rentalstatus_lang',
            'rsl',
            '(rs.id_roja45_product_rental_status = rsl.id_roja45_product_rental_status) AND (rsl.id_lang='.$id_lang.')'
        );
        $sql->leftJoin(
            'customer',
            'c',
            '(c.id_customer = r.id_customer)'
        );

        $sql->where('rs.block_calendar=1');
        $sql->where('rm.returned=0');

        $sql->where('NOT rm.start_date <= "' . pSQL($departure_date) . '" OR rm.end_date >="' . pSQL($arrival_date) . '"');
        $sql->where('NOT rm.start_date > "' . pSQL($departure_date) . '"');

        if ($id_roja45_product) {
            $sql->where('rp.id_roja45_product=' . (int) $id_roja45_product);
        }
        $sql->orderBy('rm.start_date ASC');
        return Db::getInstance()->executeS($sql);
    }

    public static function getMaxRentedForDateRange($id_roja45_product_model, $arrival_date, $departure_date)
    {
        $period = new DatePeriod(
            DateTime::createFromFormat('Y-m-d', $arrival_date),
            new DateInterval('P1D'),
            DateTime::createFromFormat('Y-m-d', $departure_date)
        );

        $max_available = 0;
        foreach ($period as $date) {
            $sql = '
            SELECT qty
            FROM ' . _DB_PREFIX_ . 'roja45_productrental_rentalmodel
            WHERE id_roja45_product_model=' . (int) $id_roja45_product_model . '
            AND returned = 0
            AND start_date<="' . pSQL($date->format('Y-m-d')) . '"
            AND end_date>"' . pSQL($date->format('Y-m-d')) . '"';

            $qtys = Db::getInstance()->executeS($sql);
            $rented_for_day = 0;
            foreach ($qtys as $qty) {
                $rented_for_day += (int)$qty['qty'];
            }
            if ($rented_for_day > $max_available) {
                $max_available = $rented_for_day;
            }
        }

        return $max_available;
    }

    public static function getRentalByReference($reference)
    {
        $sql = '
            SELECT id_roja45_product_rental
            FROM `' . _DB_PREFIX_ . 'roja45_productrental_rental`
            WHERE `reference` = "' . pSQL($reference) . '"';
        $id_roja45_product_rental = Db::getInstance()->getValue($sql);

        return new self($id_roja45_product_rental);
    }

    public static function getRentalByOrderId($id_order)
    {
        $sql = '
            SELECT id_roja45_product_rental
            FROM `' . _DB_PREFIX_ . 'roja45_productrental_rentalpayment`
            WHERE `id_order` = "' . (int)$id_order . '"';
        $id_roja45_product_rental = Db::getInstance()->getValue($sql);

        if ($id_roja45_product_rental) {
            return new self($id_roja45_product_rental);
        } else {
            return false;
        }
    }

    public static function getRentalByCartId($id_cart)
    {
        $sql = '
            SELECT id_roja45_product_rental
            FROM `' . _DB_PREFIX_ . 'roja45_productrental_rentalpayment`
            WHERE `id_cart` = ' . (int)$id_cart;
        $id_roja45_product_rental = Db::getInstance()->getValue($sql);

        if ($id_roja45_product_rental) {
            return new self($id_roja45_product_rental);
        } else {
            return false;
        }
    }

    public static function getRentalsForCustomer($id_customer)
    {
        $sql = '
            SELECT *
            FROM ' . _DB_PREFIX_ . 'roja45_productrental_rental r
            WHERE `id_customer` = ' . (int)$id_customer .'
            AND r.id_roja45_product_rental_status IN (
                SELECT id_roja45_product_rental_status
                FROM ' . _DB_PREFIX_ . 'roja45_productrental_rentalstatus rs
                WHERE rs.customer_account=1)
            ORDER BY r.id_roja45_product_rental DESC';

        return Db::getInstance()->executeS($sql);
    }

    public static function checkDate($id_roja45_product_model, $dates)
    {
        if (!is_array($dates)) {
            $checkdates = array();
            $checkdates[] = $dates;
        } else {
            $checkdates = $dates;
        }
        $return = true;
        foreach ($checkdates as $date) {
            $sql = '
                SELECT count(id_roja45_product_rental) 
                FROM ' . _DB_PREFIX_ . 'roja45_productrental_rentalmodel
                WHERE id_roja45_product_model=' . (int)$id_roja45_product_model . '
                AND start_date<="' . pSQL($date) . '"
                AND end_date>"' . pSQL($date) . '"';
            $bookings = (int)Db::getInstance()->getValue($sql);
            $sql = '
                SELECT rooms_available
                FROM ' . _DB_PREFIX_ . 'roja45_productrental_model
                WHERE id_roja45_product_model=' . (int)$id_roja45_product_model;
            $rooms_available = (int)Db::getInstance()->getValue($sql);

            if ($bookings >= $rooms_available) {
                $return = false;
            }
        }
        return $return;
    }

    public function markUnavailable()
    {
        $sql = '
            UPDATE `' . _DB_PREFIX_ . 'roja45_productrental_rentalspace` rm 
            SET id_customer=NULL,id_order=NULL,reference=NULL,type=1
            WHERE rm.id_roja45_product_rental = ' . (int) $this->id_roja45_product_rental;
        return (bool)Db::getInstance()->execute($sql);
    }

    public function getProducts()
    {
        $sql = '
          SELECT * 
          FROM `' . _DB_PREFIX_ . 'roja45_productrental_rentalproduct` rp
          WHERE rp.`id_roja45_product_rental` = ' . (int)$this->id;
        return Db::getInstance()->executeS($sql);
    }

    public function getRatesForModel($id_roja45_product_rental_product, $id_roja45_product_model)
    {
        $sql = '
            SELECT *
            FROM `' . _DB_PREFIX_ . 'roja45_productrental_rentalrate` rr
            WHERE rr.id_roja45_product_rental_product = ' . (int) $id_roja45_product_rental_product . '
            AND rr.id_roja45_product_model=' . (int) $id_roja45_product_model;
        return Db::getInstance()->executeS($sql);
    }

    public function getExtrasForModel($id_roja45_product_model)
    {
        $sql = '
            SELECT *
            FROM `' . _DB_PREFIX_ . 'roja45_productrental_rentalextra` re
            LEFT JOIN `' . _DB_PREFIX_ . 'roja45_productrental_rentalmodel` rm
            ON (re.id_roja45_product_rental = rm.id_roja45_product_rental)
            WHERE re.id_roja45_product_rental = ' . (int)$this->id_roja45_product_rental . '
            AND rm.id_roja45_product_model=' . (int)$id_roja45_product_model;
        return Db::getInstance()->executeS($sql);
    }

    public function getPaymentsForModel($id_product, $id_product_attribute)
    {
        $sql = new DbQuery();
        $sql->select('*');
        $sql->from('roja45_productrental_rentalpayment', 'rp');
        $sql->leftJoin(
            'roja45_productrental_rentalpayment_item',
            'rpi',
            'rp.id_roja45_product_rental_payment = rpi.id_roja45_product_rental_payment'
        );

        $sql->where('rp.id_roja45_product_rental='.$this->id);
        $sql->where('rpi.id_product='.$id_product);
        $sql->where('rpi.id_product_attribute='.$id_product_attribute);

        if ($result = Db::getInstance()->executeS($sql)) {
            return $result;
        } else {
            return array();
        }
    }

    public function getFirstOrder()
    {
        $sql = new DbQuery();
        $sql->select('id_order');
        $sql->from('roja45_productrental_rentalpayment', 'rp');
        $sql->where('rp.`id_roja45_product_rental` = ' . (int) $this->id);
        $sql->orderBy('id_order ASC');
        return Db::getInstance()->getValue($sql);
    }

    public function getTotals()
    {
        $data = $this->getSummary();
        $total = array();
        $total['total_to_pay'] = $data['total_to_pay'];
        $total['total_to_pay_inc'] = $data['total_to_pay_inc'];
        $total['total_to_pay_now_inc'] = $data['total_to_pay_now_inc'];
        $total['total_paid'] = $data['total_paid'];
        $total['total_paid_inc'] = $data['total_paid_inc'];
        $total['total_paid_confirmed'] = $data['total_paid_confirmed'];
        $total['total_paid_confirmed_with_tax'] = $data['total_paid_confirmed_with_tax'];
        $total['total_outstanding'] = $data['total_outstanding'];
        $total['total_outstanding_inc'] = $data['total_outstanding_inc'];
        return $total;
    }

    public function getSummary()
    {
        $context = Context::getContext();
        $total_to_pay = 0.0;

        $total_to_pay_now_inc = 0.0;
        $total_to_pay_now_exc = 0.0;
        $total_deposit_to_pay = 0.0;
        $total_to_pay_inc = 0.0;
        $total_to_pay_exc = 0.0;
        $total_products_exc = 0.0;
        $total_extras_exc = 0.0;

        $total_paid = 0.0;
        $total_paid_inc = 0.0;

        $total_deposit_to_pay_inc = 0.0;
        $total_damage_deposit = 0.0;
        $total_damage_deposit_inc = 0.0;

        $tax_enabled = Configuration::get('PS_TAX');
        $usetax = true;
        if (Tax::excludeTaxeOption()) {
            $usetax = false;
        }
        if (Configuration::get('PS_TAX_ADDRESS_TYPE') == 'id_address_invoice') {
            $address_id = isset($context->cart) ? (int)$context->cart->id_address_invoice : null;
        } else {
            $address_id = isset($context->cart) ? (int)$context->cart->id_address_delivery : null;
        }
        if (!Address::addressExists($address_id)) {
            $address_id = null;
        }
        $address = Address::initialize($address_id, true);

        $rental_products = array();
        $products = $this->getProducts();
        $rental_deposits = array();
        foreach ($products as &$product) {
            $rental_product = new ProductRentalDetails($product['id_roja45_product']);
            $productObj = new Product($product['id_product'], true, $context->language->id);
            $total_to_pay_product = 0.0;
            $total_to_pay_now_product = 0.0;
            $collection_date = '';
            $return_date = '';
            $product['name'] = $rental_product->getName($context->language->id);

            if (Configuration::get('ROJA45_PRODUCTRENTAL_HASADDRESS') == 1) {
                if ($rental_product->state) {
                    $state = new State($rental_product->state, $context->language->id_lang);
                    $product['state_name'] = $state->name;
                }
                if ($rental_product->country) {
                    $country = new Country($rental_product->country, $context->language->id_lang);
                    $product['country_name'] = $country->name;
                }

                $product_address = new Address();
                $product_address->name = $rental_product->getName($context->language->id_lang);
                $product_address->address1 = $rental_product->address;
                $product_address->address2 = $rental_product->address_2;
                $product_address->city = $rental_product->city;
                $product_address->id_state = $rental_product->state;
                $product_address->id_country = $rental_product->country;
                $product_address->postcode = $rental_product->postal_code;
                $product['product_address_block_txt'] = $this->_getFormatedAddress($product_address, ', ');
                $product['product_address_block_html'] = $this->_getFormatedAddress($product_address, '<br>');
            }

            if (Configuration::get('ROJA45_PRODUCTRENTAL_HASLOCATION') == 1) {
                $image_size = Image::getSize(ImageType::getFormatedName('home'));
                if ($rental_product->lat && $rental_product->lon) {
                    $google_url =
                        'https://www.google.com/maps/dir/' .
                        $rental_product->lat . ',' .
                        $rental_product->lon;
                    $google_directions_url =
                        'https://www.google.com/maps?saddr=current+location&daddr=' .
                        $rental_product->lat . ',' .
                        $rental_product->lon;
                    $google_url_txt =
                        'Copy this link into your browser to view on Google Maps: https://www.google.com/maps/dir/' .
                        $rental_product->lat . ',' .
                        $rental_product->lon . '/';
                    $google_static_image =
                        'https://maps.googleapis.com/maps/api/staticmap?size=' .
                        $image_size['width'] . 'x' . $image_size['height'] . '&format=jpg&path=geodesic%3Atrue%7C' .
                        $rental_product->lat . '%2C' . $rental_product->lon . '&zoom=15&markers=color:red%7C' .
                        $rental_product->lat . '%2C' . $rental_product->lon;
                    $product['google_directions_url'] = $google_directions_url;
                    $product['google_static_image'] = $google_static_image;
                    $product['google_url_txt'] = $google_url_txt;
                    $product['google_url'] = $google_url;
                    $product['image_width'] = $image_size['width'];
                    $product['image_height'] = $image_size['height'];
                }
            }

            $id_main_image = Product::getCover($productObj->id, $context);
            $product['product'] = $productObj;
            $product['rental_product'] = $rental_product;

            $total_product_taxes = 0;
            $total_models = 0;
            $total_to_pay_model = 0.0;
            $total_to_pay_with_tax_model = 0.0;

            if (!isset($product['id_paymentprofile'])) {
                $product['id_paymentprofile'] = $rental_product->id_paymentprofile;
            }
            $deposit_amount = 100;
            $paymentprofile = new ProductRentalPaymentProfile(
                $product['id_paymentprofile'],
                $context->language->id
            );

            $deposit_percentages = array();
            $models = ProductRentalRentalModel::getModels($product['id_roja45_product_rental_product']);
            $product['models'] = $models;
            foreach ($product['models'] as &$model) {
                $collection_date = $model['start_date'];
                $return_date = $model['end_date'];

                if ($paymentprofile) {
                    $deposit_amount = number_format(
                        (float)$paymentprofile->getDepositPercentage($collection_date),
                        2,
                        '.',
                        ''
                    );
                }
                $deposit_percentages[] = $deposit_amount;
                $total_model = 0;
                $total_model_with_extras = 0;
                $modelObj = new ProductRentalModel($model['id_roja45_product_model'], $context->language->id);
                $rental_model = new ProductRentalRentalModel($model['id_roja45_product_rental_model']);

                $id_image = Product::getCombinationImageById(
                    $rental_model->id_product_attribute,
                    $context->language->id
                );
                if ($id_image) {
                    $model['id_image'] = $id_image['id_image'];
                } else {
                    $model['id_image'] = $id_main_image['id_image'];
                }
                $model['image_url'] = $context->link->getImageLink(
                    $productObj->link_rewrite,
                    $model['id_image'],
                    ImageType::getFormatedName('small')
                );

                $collection_date_obj = DateTime::createFromFormat(
                    'Y-m-d H:i:s',
                    $model['start_date'] . ' ' . $model['collection_time']
                );
                $model['collection_date'] = $collection_date_obj->format($context->language->date_format_lite);
                $model['collection_time'] = $collection_date_obj->format('H:i');

                $return_date_obj = DateTime::createFromFormat(
                    'Y-m-d H:i:s',
                    $model['end_date'] . ' ' . $model['return_time']
                );
                $model['return_date'] = $return_date_obj->format($context->language->date_format_lite);
                $model['return_time'] = $return_date_obj->format('H:i');
                $model['model_name'] = $modelObj->getModelName($context->language->id);
                $total_for_rate = 0.0;

                $model['total_paid'] = 0;
                if ($payments = $this->getPaymentsForModel($product['id_product'], $model['id_product_attribute'])) {
                    foreach ($payments as $payment) {
                        $payment_item = new ProductRentalRentalPaymentItem(
                            $payment['id_roja45_product_rental_payment_item']
                        );
                        if ($payment['date_paid'] != '0000-00-00 00:00:00') {
                            $model['total_paid'] += (float)$payment_item->total_paid;
                        }
                    }
                }
                $model['total_paid_formatted'] = Tools::displayPrice(Tools::convertPrice($model['total_paid']));
                $total_paid += (float)$model['total_paid'];

                $sql = '
                    SELECT DISTINCT id_roja45_product_rate
                    FROM `' . _DB_PREFIX_ . 'roja45_productrental_rentalrate` rr
                    WHERE rr.id_roja45_product_rental_model=' . (int)$model['id_roja45_product_rental_model'];
                $rates = array();
                foreach (Db::getInstance()->executeS($sql) as $rate_id) {
                    $rate = array();
                    $rate['id'] = $rate_id['id_roja45_product_rate'];
                    $ratetypeObj = new ProductRentalRate(
                        $rate_id['id_roja45_product_rate'],
                        $context->language->id
                    );
                    $sql = '
                        SELECT *
                        FROM `' . _DB_PREFIX_ . 'roja45_productrental_rentalrate` rr
                        WHERE rr.id_roja45_product_rental_model=' . (int)$model['id_roja45_product_rental_model'] . '
                        AND rr.id_roja45_product_rate = ' . $rate_id['id_roja45_product_rate'] . '
                        ORDER BY rr.period';
                    $periods = Db::getInstance()->executeS($sql);
                    foreach ($periods as &$period) {
                        $period['period_name'] = '';
                        if ((int)Configuration::get('ROJA45_PRODUCTRENTAL_USEPERIODPRICING')) {
                            if ($special_rate = ProductRentalPeriodRate::getPricePeriodForDate(
                                $product['id_roja45_product'],
                                $model['id_roja45_product_rental_model'],
                                $ratetypeObj->id_type,
                                $context->language->id,
                                $period['period']
                            )) {
                                $period['period_name'] = $special_rate[0]['name'];
                            }
                        }
                        $period['value_formatted'] = Tools::displayPrice(
                            Tools::convertPrice($period['value'])
                        );
                        $period['discount_formatted'] = Tools::displayPrice(
                            Tools::convertPrice($period['discount'])
                        );
                        $period['total_formatted'] = Tools::displayPrice(
                            Tools::convertPrice($period['total'])
                        );
                        if (!isset($period['tax'])) {
                            $period['tax'] = 0;
                        }
                        $period['tax_formatted'] = Tools::displayPrice(
                            Tools::convertPrice($period['tax'])
                        );
                        $period['period_formatted'] = Tools::displayDate($period['period'], null, false);
                        $total_for_rate += ($period['total'] * $period['entry']);
                    }
                    $rate['name'] = $ratetypeObj->name;
                    $rate['total'] = $total_for_rate;
                    $rate['total_formatted'] = Tools::displayPrice(Tools::convertPrice($total_for_rate));
                    $rate['average_per_day'] = $total_for_rate / (int)count($periods);
                    $rate['periods'] = $periods;
                    $rates[] = $rate;
                }
                $total_model += $total_for_rate;
                $total_model_with_extras += $total_for_rate;
                $model['rates'] = $rates;
                $model['total_model'] = $total_model;
                $model['total_model_with_extras'] = $total_model;
                $model['total_model_formatted'] = Tools::displayPrice(Tools::convertPrice($total_model));
                $model['total_model_with_extras_formatted'] = Tools::displayPrice(Tools::convertPrice($total_model));

                $total_products_exc += $total_model;

                $rental_extras = $rental_model->getExtras();
                $total_extras = 0.0;
                foreach ($rental_extras as &$extra) {
                    if (is_numeric($extra['id_roja45_product_extra'])) {
                        $extraObj = new ProductRentalExtra($extra['id_roja45_product_extra'], $context->language->id);
                        $extraType = new ProductRentalExtraType(
                            $extraObj->id_roja45_productrental_extra_type,
                            $context->language->id
                        );
                        $id_roja45_product_extralink = ProductRentalModelExtra::getModelExtra(
                            $extra['id_roja45_product_extra'],
                            $modelObj->id_roja45_product_model
                        );
                        $model_extra = new ProductRentalModelExtra($id_roja45_product_extralink);

                        $extra['total'] = $extraObj->calculateExtraCost(
                            $model_extra->rate,
                            $collection_date,
                            $return_date,
                            $model['qty'],
                            1
                        );
                        $extra['total_formatted'] = Tools::displayPrice(Tools::convertPrice($extra['total']));
                        $extra['tax_formatted'] = Tools::displayPrice(Tools::convertPrice($extra['tax']));
                        $extra['total_deposit_formatted'] = Tools::displayPrice(Tools::convertPrice($extra['total_deposit']));
                        $extra['discount_formatted'] = Tools::displayPrice(Tools::convertPrice($extra['discount']));
                        $extra['rate'] = $model_extra->rate;
                        $extra['rate_formatted'] = Tools::displayPrice(Tools::convertPrice($model_extra->rate));
                        $extra['name'] = $extraObj->name;
                        // TODO -  Need to create an extra rate type class and data

                        $extra['rate_name'] = $extraType->name;
                        $total_extras += $extra['total'];
                    }
                }
                $total_extras_exc += $total_extras;
                $total_model_with_extras += $total_extras;
                $total_to_pay_model += ($total_model_with_extras);
                $total_to_pay += ($total_model_with_extras);

                $model['total_extras'] = $total_extras;
                $model['total_extras_formatted'] = Tools::displayPrice(Tools::convertPrice($model['total_extras']));
                $model['extras'] = $rental_extras;

                $product_tax_calculator = null;
                if ($tax_enabled && $usetax) {
                    $id_tax_rules_group = Product::getIdTaxRulesGroupByIdProduct(
                        (int)$rental_product->id_product,
                        $context
                    );
                    $product_tax_calculator = TaxManagerFactory::getManager(
                        $address,
                        $id_tax_rules_group
                    )->getTaxCalculator();
                    //$total_extra_with_tax = $product_tax_calculator->addTaxes($total_extras);
                    $total_model_with_tax = $product_tax_calculator->addTaxes($total_model_with_extras);
                    $total_paid_inc += $product_tax_calculator->addTaxes($model['total_paid']);
                    $total_to_pay_with_tax_model += $total_model_with_tax;
                    $total_to_pay_inc += $total_model_with_tax;
                    $total_to_pay_exc += $total_model_with_extras;
                    $model['taxes'] = $total_model_with_tax - $total_model_with_extras;
                    $model['taxes_formatted'] = Tools::displayPrice(
                        Tools::convertPrice($total_model_with_tax - $total_model_with_extras)
                    );
                } else {
                    $total_to_pay_exc += $total_model_with_extras;
                    $total_model_with_tax = $total_model_with_extras;
                    $model['taxes'] = 0.0;
                    $model['taxes_formatted'] = Tools::displayPrice(Tools::convertPrice(0.0));
                }

                $total_product_taxes += $model['taxes'];
                $model['deposit'] = $deposit_amount;
                $model['total'] = $total_model_with_extras;
                $model['total_formatted'] = Tools::displayPrice(Tools::convertPrice($total_model_with_extras));
                $model['total_to_pay_now'] = (float)$total_model_with_extras * ($deposit_amount / 100);
                $model['total_to_pay_now_formatted'] = Tools::displayPrice(
                    Tools::convertPrice($model['total_to_pay_now'])
                );
                $model['damage_deposit_formatted'] = Tools::displayPrice(
                    Tools::convertPrice($model['damage_deposit'])
                );
                $total_damage_deposit += $model['damage_deposit'];
                $total_damage_deposit_inc += $model['damage_deposit_inc'];
                $model['total_with_tax'] = $total_model_with_tax;
                $model['total_with_tax_formatted'] = Tools::displayPrice(Tools::convertPrice($total_model_with_tax));
                $model['tax'] = $total_model_with_tax - $total_model_with_extras;
                $model['tax_formatted'] = Tools::displayPrice(Tools::convertPrice($model['tax']));
                $total_to_pay_product += $total_model_with_extras;
                $total_to_pay_now_product += $model['total_to_pay_now'];
            }

            $deposit_percentage = 0;
            foreach ($deposit_percentages as $percentage) {
                $deposit_percentage += $percentage;
            }
            if (count($deposit_percentages)) {
                $product['deposit'] = $deposit_percentage / count($deposit_percentages);
            } else {
                $product['deposit'] = $deposit_percentage;
            }

            $rental_deposits[] = $product['deposit'];
            $product['product_link'] = $context->link->getProductLink(
                $productObj,
                $productObj->link_rewrite,
                $productObj->category,
                null,
                null,
                $context->shop->id
            );
            $product['image_url'] = $context->link->getImageLink(
                $productObj->link_rewrite,
                $id_main_image['id_image'],
                ImageType::getFormatedName('small')
            );

            $product['collection_date'] = $collection_date;
            $product['return_date'] = $return_date;
            $product['total_models'] = (float)$total_models;
            $product['total_product'] = (float)$total_to_pay_product;
            $product['taxes'] = (float)$total_product_taxes;
            $product['total_deposit_to_pay_exc'] = $total_to_pay_now_product;

            if ($tax_enabled && $usetax) {
                $id_tax_rules_group = Product::getIdTaxRulesGroupByIdProduct(
                    (int)$rental_product->id_product,
                    $context
                );
                $product_tax_calculator = TaxManagerFactory::getManager(
                    $address,
                    $id_tax_rules_group
                )->getTaxCalculator();
                //$total_to_pay_with_tax_product = $product_tax_calculator->addTaxes($total_to_pay_product);
                $product['total_deposit_to_pay_inc'] = $product_tax_calculator->addTaxes($total_to_pay_now_product);
                $total_to_pay_now_inc += Tools::ps_round(
                    $product['total_deposit_to_pay_inc'],
                    _PS_PRICE_COMPUTE_PRECISION_
                );
            } else {
                $product['total_deposit_to_pay_inc'] = $product['total_deposit_to_pay_exc'];
            }

            $total_to_pay_now_exc += Tools::ps_round(
                $product['total_deposit_to_pay_exc'],
                _PS_PRICE_COMPUTE_PRECISION_
            );
            $total_deposit_to_pay += $product['total_deposit_to_pay_exc'];
            $total_deposit_to_pay_inc += $product['total_deposit_to_pay_inc'];

            $rental_products[] = $product;
        }

        if (!count($rental_deposits)) {
            $rental_deposit = 100;
        } else {
            $rental_deposit = 0;
            foreach ($rental_deposits as $percentage) {
                $rental_deposit += $percentage;
            }
            $rental_deposit = $rental_deposit/(count($rental_deposits));
        }

        $total_paid_confirmed = ProductRentalRentalPayment::getTotalConfirmedPaid($this->id, false);
        $total_paid_confirmed_with_tax = ProductRentalRentalPayment::getTotalConfirmedPaid($this->id, true);

        $tax = 0.0;

        $total_outstanding = Tools::convertPrice(($total_to_pay - $total_paid), $this->id_currency);
        $total_outstanding_inc = Tools::convertPrice(
            ($total_to_pay_inc - $total_paid_inc),
            $this->id_currency
        );

        $display_without_tax = true;
        if ($tax_enabled && $usetax) {
            $tax = ($total_to_pay_inc - $total_to_pay_exc);
            $display_without_tax = false;
        }

        if ($total_outstanding<0) {
            $total_outstanding=0.0;
        }

        $data = array(
            'taxes' => $tax,
            'taxes_formatted' => Tools::displayPrice(Tools::convertPrice($tax)),
            'rental_deposit' => $rental_deposit,
            'total_to_pay' => $total_to_pay,
            'total_products' => $total_products_exc,
            'total_products_formatted' => Tools::displayPrice(Tools::convertPrice($total_products_exc)),
            'total_extras' => $total_extras_exc,
            'total_extras_formatted' => Tools::displayPrice(Tools::convertPrice($total_extras_exc)),
            'total_to_pay_formatted' => Tools::displayPrice(Tools::convertPrice($total_to_pay)),
            'total_to_pay_inc' => $total_to_pay_inc,
            'total_to_pay_inc_formatted' => Tools::displayPrice(Tools::convertPrice($total_to_pay_inc)),
            'total_damage_deposit' => $total_damage_deposit,
            'total_damage_deposit_formatted' => Tools::displayPrice(Tools::convertPrice($total_damage_deposit)),
            'total_damage_deposit_inc' => $total_damage_deposit_inc,
            'total_damage_deposit_inc_formatted' => Tools::displayPrice(Tools::convertPrice($total_damage_deposit_inc)),
            'total_to_pay_now_inc' => $total_to_pay_now_inc,
            'total_to_pay_now_inc_formatted' => Tools::displayPrice(Tools::convertPrice($total_to_pay_now_inc)),
            'total_to_pay_now_exc' => $total_to_pay_now_exc,
            'total_to_pay_now_exc_formatted' => Tools::displayPrice(Tools::convertPrice($total_to_pay_now_exc)),
            'total_inc' => $total_to_pay_now_inc + $total_damage_deposit_inc,
            'total_inc_formatted' => Tools::displayPrice(
                Tools::convertPrice($total_to_pay_now_inc + $total_damage_deposit_inc)
            ),
            'total_exc' => $total_to_pay_now_exc + $total_damage_deposit,
            'total_exc_formatted' => Tools::displayPrice(
                Tools::convertPrice($total_to_pay_now_exc + $total_damage_deposit)
            ),
            'total_paid' => $total_paid,
            'total_paid_formatted' => Tools::displayPrice(Tools::convertPrice($total_paid)),
            'total_paid_inc' => $total_paid_inc,
            'total_paid_inc_formatted' => Tools::displayPrice(Tools::convertPrice($total_paid_inc)),
            'total_paid_confirmed' => $total_paid_confirmed,
            'total_paid_confirmed_formatted' => Tools::displayPrice(Tools::convertPrice($total_paid_confirmed)),
            'total_paid_confirmed_with_tax' => $total_paid_confirmed_with_tax,
            'total_paid_confirmed_with_tax_formatted' => Tools::displayPrice(
                Tools::convertPrice($total_paid_confirmed_with_tax)
            ),
            'total_outstanding' => Tools::ps_round($total_outstanding, 2),
            'total_outstanding_formatted' => Tools::displayPrice(Tools::convertPrice($total_outstanding)),
            'total_outstanding_inc' => $total_outstanding_inc,
            'total_outstanding_inc_formatted' => Tools::displayPrice(
                Tools::convertPrice($total_outstanding_inc)
            ),
            'total_deposit_to_pay' => $total_deposit_to_pay,
            'rental_products' => $products,
            'display_without_tax' => $display_without_tax,
            'id_lang' => $context->language->id,
            'id_shop' => $context->shop->id,
            'link' => $context->link,
        );

        $delivery_address = null;
        if (isset($this->id_delivery_address) && $this->id_delivery_address) {
            $delivery_address = new Address($this->id_delivery_address);
            $addressFields = AddressFormat::getOrderedAddressFields($delivery_address->id_country);
            $addressFormatedValues = AddressFormat::getFormattedAddressFieldsValues($delivery_address, $addressFields);
            $addressFormatedValues['id_address'] = $this->id_delivery_address;
            $addressFormatedValues['alias'] = $delivery_address->alias;
            $delivery_address = $addressFormatedValues;
        }
        $data['delivery_address'] = $delivery_address;

        $collection_address = null;
        if (isset($this->id_collection_address) && $this->id_collection_address) {
            $collection_address = new Address($this->id_collection_address);
            $addressFields = AddressFormat::getOrderedAddressFields($collection_address->id_country);
            $addressFormatedValues = AddressFormat::getFormattedAddressFieldsValues($collection_address, $addressFields);
            $addressFormatedValues['id_address'] = $this->id_collection_address;
            $addressFormatedValues['alias'] = $collection_address->alias;
            $collection_address = $addressFormatedValues;
        }
        $data['collection_address'] = $collection_address;

        if ($total_deposit_to_pay > 0) {
            if ($tax_enabled && $usetax) {
                $additional = array(
                    'total_deposit_to_pay_with_tax' => Tools::ps_round(
                        $total_deposit_to_pay_inc,
                        _PS_PRICE_COMPUTE_PRECISION_
                    ),
                    'display_without_tax' => 0,
                );
            } else {
                $additional = array(
                    'total_deposit_to_pay' => Tools::ps_round($total_deposit_to_pay, _PS_PRICE_COMPUTE_PRECISION_),
                    'display_without_tax' => 1,
                );
            }
            return array_merge($data, $additional);
        } else {
            return $data;
        }
    }

    /**
     * createRental
     *
     * Create the rental object from the request date
     *
     * @param ProductRentalRental $rental Rental Object
     * @param int $id_roja45_product Rental Product Id
     *
     * @return ProductRentalRental
     * @throws Exception
     */
    public static function createRental(
        $id_roja45_product_rental,
        $id_roja45_product,
        $id_customer,
        $collection_date,
        $collection_time,
        $return_date,
        $return_time,
        $rental_request,
        $uid,
        $initial_status,
        $id_lang,
        $id_currency,
        $id_shop
    ) {
        $mysql_date_now = date('Y-m-d H:i:s');

        $rental_product = new ProductRentalDetails($id_roja45_product);

        if ($id_roja45_product_rental) {
            $rental = new ProductRentalRental($id_roja45_product_rental);
        } else {
            $rental = new ProductRentalRental();
            $rental->date_add = $mysql_date_now;
            $rental->reference = Tools::strtoupper(Tools::passwdGen(9, 'NO_NUMERIC'));
        }

        $rental->id_lang = (int) $id_lang;
        $rental->id_shop = (int) $id_shop;
        $rental->id_customer = (int) $id_customer;
        $rental->id_currency = (int) $id_currency;
        $rental->uid = $uid;
        $rental->date_upd = $mysql_date_now;
        $rental->modified = 0;

        if (!$rental->save()) {
            throw new Exception(
                'Unable to save rental.: '.Db::getInstance()->getMsgError(),
                1001
            );
        }

        $rental->setStatus($initial_status);

        foreach ($rental_request->products as &$product_rental) {
            if (!$product_rental_obj = ProductRentalRentalProduct::exists($rental->id, $rental_product->id_product)) {
                $product_rental_obj = new ProductRentalRentalProduct();
                $product_rental_obj->id_roja45_product = $product_rental->id_roja45_product;
                $product_rental_obj->id_product = $rental_product->id_product;
                $product_rental_obj->id_roja45_product_rental = $rental->id;
            } else {
                $product_rental_obj->deleteChildren();
            }
            if (!isset($product_rental->id_paymentprofile)) {
                $product_rental->id_paymentprofile = $rental_product->id_paymentprofile;
            }
            $paymentprofile = new ProductRentalPaymentProfile($product_rental->id_paymentprofile, $id_lang);
            $product_rental_obj->id_paymentprofile = $paymentprofile->id_roja45_product_paymentprofile;

            $vouchers = '';
            foreach ($product_rental->vouchers as $voucher) {
                $vouchers .= $voucher->code;
            }
            $product_rental_obj->vouchers = $vouchers;

            if (!$product_rental_obj->save()) {
                throw new Exception(
                    'Fatal error creating rental product: '.Db::getInstance()->getMsgError(),
                    1002
                );
            }
            foreach ($product_rental->models as $model) {
                if ($model) {
                    $rental_model = $product_rental_obj->addModel(
                        $model->id_roja45_product_rental_model,
                        $model->id_product_attribute,
                        $collection_date,
                        $collection_time,
                        $return_date,
                        $return_time,
                        0,
                        $model->number_of_models,
                        $model->total_model - $model->total_model_discount,
                        $model->total_model_with_tax - $model->total_model_discount_with_tax,
                        $model->damage_deposit_exc,
                        $model->damage_deposit_inc,
                        $model->id_roja45_product_rateduration
                    );


                    foreach ($model->rates as $rate) {
                        if ($rate) {
                            $rate = (object) $rate;
                            foreach ($rate->periods as $period) {
                                $period = (object) $period;
                                $rental_model->addRate(
                                    $rate->id_roja45_product_rate,
                                    $period->original_rate,
                                    $period->discount,
                                    $period->rate,
                                    $period->tax,
                                    $period->period,
                                    $rate->qty
                                );
                            }
                        }
                    }

                    if (isset($model->extras)) {
                        foreach ($model->extras as $extra) {
                            $rental_model->addExtra(
                                $extra->id_roja45_product_extra,
                                $extra->value,
                                $extra->tax,
                                1,
                                $extra->total
                            );
                        }
                    }
                }
            }
        }
        return $rental;
    }

    /**
     * updateRental
     *
     * Create the rental object from the request date
     *
     * @param ProductRentalRental $rental Rental Object
     * @param int $id_roja45_product Rental Product Id
     *
     * @return ProductRentalRental
     * @throws Exception
     */
    public static function updateRental(
        $id_roja45_product_rental,
        $rental_details
    ) {
        $context = Context::getContext();
        $rental = new ProductRentalRental($id_roja45_product_rental);
        if (!Validate::isLoadedObject($rental)) {
            throw new Exception('Rental does not exist');
        }

        foreach ($rental_details->products as &$product_rental) {
            $rental_product = new ProductRentalDetails($product_rental->id_roja45_product);
            $product_rental->action = 'new';
            if ($id_roja45_product_rental_product = $rental->getProduct($product_rental->id_roja45_product)) {
                $product_rental->action = 'update';
            }
            if ($product_rental->action=='new') {
                if (isset($product_rental->id_roja45_rental_product)) {
                    $product_rental_obj = new ProductRentalRentalProduct($product_rental->id_roja45_rental_product);
                } else {
                    $product_rental_obj = new ProductRentalRentalProduct();
                    $product_rental_obj->id_roja45_product = $product_rental->id_roja45_product;
                    $product_rental_obj->id_product = $rental_product->id_product;
                    $product_rental_obj->id_roja45_product_rental = $rental->id;
                    if (!empty($product_rental->id_paymentprofile)) {
                        $product_rental_obj->id_paymentprofile = $product_rental->id_paymentprofile;
                    } else {
                        $product_rental_obj->id_paymentprofile = $rental_product->id_paymentprofile;
                    }
                    if (!$product_rental_obj->save()) {
                        throw new Exception(
                            'Fatal error creating rental product: '.Db::getInstance()->getMsgError(),
                            1002
                        );
                    }
                }
            } elseif ($product_rental->action=='update') {
                $product_rental_obj = new ProductRentalRentalProduct($id_roja45_product_rental_product);
            }

            foreach ($product_rental->models as $model) {
                if ($model) {
                    if ($model->action=='new') {
                        // TODO - Check if already on rental, if yes, increaase qty.
                        $collection_date_obj = DateTime::createFromFormat(
                            $context->language->date_format_lite . ' H:i:s',
                            $model->collection_date . ' ' . $model->collection_time
                        );
                        $return_date_obj = DateTime::createFromFormat(
                            $context->language->date_format_lite . ' H:i:s',
                            $model->return_date . ' ' . $model->return_time
                        );
                        $number_of_days = ceil(
                            ((strtotime($return_date_obj->format('Y-m-d')) -
                                    strtotime($collection_date_obj->format('Y-m-d')))/3600)/24
                        );

                        $rental_model = $product_rental_obj->addModel(
                            $model->id_roja45_product_rental_model,
                            $model->id_product_attribute,
                            $collection_date_obj->format('Y-m-d'),
                            $model->collection_time,
                            $return_date_obj->format('Y-m-d'),
                            $model->return_time,
                            $number_of_days,
                            $model->number_of_models,
                            $model->total_model - $model->total_model_discount,
                            $model->total_model_with_tax - $model->total_model_discount_with_tax,
                            $model->damage_deposit_exc,
                            $model->damage_deposit_inc,
                            $model->id_roja45_product_rateduration
                        );
                    } elseif ($model->action=='update') {
                        $collection_date_obj = DateTime::createFromFormat(
                            $context->language->date_format_lite . ' H:i:s',
                            $model->collection_date . ' ' . $model->collection_time
                        );
                        $return_date_obj = DateTime::createFromFormat(
                            $context->language->date_format_lite . ' H:i:s',
                            $model->return_date . ' ' . $model->return_time
                        );
                        $number_of_days = ceil(
                            ((strtotime($return_date_obj->format('Y-m-d')) -
                                    strtotime($collection_date_obj->format('Y-m-d')))/3600)/24
                        );
                        $rental_model = new ProductRentalRentalModel($model->id_roja45_product_rental_model);
                        $rental_model->start_date = $collection_date_obj->format('Y-m-d');
                        $rental_model->collection_time = $collection_date_obj->format('H:i:s');
                        $rental_model->end_date = $return_date_obj->format('Y-m-d');
                        $rental_model->return_time = $return_date_obj->format('H:i:s');
                        $rental_model->periods = $number_of_days;
                        $rental_model->save();
                    }

                    // TODO - We should just delet and recreate the dates.
                    if (count($model->rates)) {
                        $rental_model->deleteRates();
                        foreach ($model->rates as $rate) {
                            if ($rate) {
                                $rate = (object) $rate;
                                foreach ($rate->periods as $period) {
                                    $period = (object) $period;
                                    $rental_model->addRate(
                                        $rate->id_roja45_product_rate,
                                        $period->original_rate,
                                        $period->discount,
                                        $period->rate,
                                        $period->tax,
                                        $period->period,
                                        $rate->qty
                                    );
                                }
                            }
                        }
                    }
                    /*if (isset($model->extras)) {
                        foreach ($model->extras as $extra) {
                        }
                    }*/
                }
            }
        }
        return $rental;
    }

    public static function validateRental($rental_details)
    {
        $rental_details->rental_valid = 0;
        $rental_details->info = array();
        $rental_details->warnings = array();
        $rental_details->errors = array();

        $context = Context::getContext();
        $tax_enabled = Configuration::get('PS_TAX');
        $usetax = true;
        if (Tax::excludeTaxeOption()) {
            $usetax = false;
        }
        //$all_rental_products = array();

        if (Configuration::get('PS_TAX_ADDRESS_TYPE') == 'id_address_invoice') {
            $address_id = isset($context->cart) ? (int)$context->cart->id_address_invoice : null;
        } else {
            $address_id = isset($context->cart) ? (int)$context->cart->id_address_delivery : null;
        }
        if (!Address::addressExists($address_id)) {
            $address_id = null;
        }
        $address = Address::initialize($address_id, true);
        $total_rental_discounts = 0;
        $total_rental_exc = 0;
        $total_to_pay_rental_exc = 0;
        $total_rental_inc = 0;
        $total_to_pay_rental_inc = 0;
        $total_rental_to_pay_exc = 0;
        $total_rental_to_pay_inc = 0;
        $total_damage_deposit_exc = 0.0;
        $total_damage_deposit_inc = 0.0;
        $average_tax_rate = 0.0;
        $total_product_damage_deposit_amount_exc = 0.0;
        $product_deposits = array();
        foreach ($rental_details->products as &$product) {
            $total_product_damage_deposit_exc = 0.0;
            $total_product_damage_deposit_inc = 0.0;
            $rental_product = new ProductRentalDetails($product->id_roja45_product);
            if (!isset($product->id_paymentprofile)) {
                $product->id_paymentprofile = $rental_product->id_paymentprofile;
            }
            if (!isset($product->id_product)) {
                $product->id_product = $rental_product->id_product;
            }
            $deposit_amount = 100;
            $paymentprofile = new ProductRentalPaymentProfile(
                $product->id_paymentprofile,
                $context->language->id
            );
            if ($rental_product->id_roja45_product_damagedeposit) {
                $damage_deposit = new ProductRentalDamageDeposit($rental_product->id_roja45_product_damagedeposit);
                $rental_details->damage_deposit = $damage_deposit;
            }

            $damage_deposit_tax_calculator = null;
            if ($tax_enabled && $usetax) {
                $id_tax_rules_group = Product::getIdTaxRulesGroupByIdProduct(
                    (int)$product->id_product,
                    $context
                );
                $product_tax_calculator = TaxManagerFactory::getManager(
                    $address,
                    $id_tax_rules_group
                )->getTaxCalculator();
                $average_tax_rate += $product_tax_calculator->getTotalRate();

                if ($id_damage_tax_rules_group = (int) Configuration::get('ROJA45_PRODUCTRENTAL_PRODUCTDEPOSITUSESYSTEMTAX')) {
                    $damage_deposit_tax_calculator = TaxManagerFactory::getManager(
                        $address,
                        $id_damage_tax_rules_group
                    )->getTaxCalculator();
                }
            }

            if (isset($product->vouchers)) {
                foreach ($product->vouchers as $key => &$voucher) {
                    if ($id_voucher = ProductRentalVoucher::getIdByCode($voucher->code)) {
                        $voucherObj = new ProductRentalVoucher($id_voucher, $context->language->id);
                        if (!Validate::isLoadedObject($voucherObj)) {
                            $rental_details->errors[] = 'VOUCHER_DOES_NOT_EXIST';
                            unset($product->vouchers[$key]);
                            break;
                        }

                        if ($voucherObj->id_customer && !$context->customer->isLogged()) {
                            $rental_details->errors[] = 'VOUCHER_NOT_LOGGED_IN';
                            unset($product->vouchers[$key]);
                            break;
                        }

                        if ($voucherObj->id_customer && ($voucherObj->id_customer != $context->customer->id)) {
                            $rental_details->errors[] = 'VOUCHER_NOT_OWNER';
                            unset($product->vouchers[$key]);
                            break;
                        }

                        foreach (ProductRentalRental::getRentalsForCustomer($context->customer->id) as $rental) {
                            $rental = new ProductRentalRental($rental['id_roja45_product_rental']);
                            foreach ($rental->getProducts() as $rp) {
                                $rpvs = explode(',', $rp['vouchers']);
                                foreach ($rpvs as $rpv) {
                                    if ($rpv == $voucherObj->code) {
                                        $rental_details->errors[] = 'VOUCHER_USED';
                                        unset($product->vouchers[$key]);
                                        break;
                                    }
                                }
                            }
                        }

                        $date = date('Y-m-d H:i:s');
                        $date=date('Y-m-d H:i:s', strtotime($date));
                        $fromDate = date('Y-m-d H:i:s', strtotime($voucherObj->date_from));
                        $toDate = date('Y-m-d H:i:s', strtotime($voucherObj->date_to));

                        if (($date > $fromDate) && ($date < $toDate)) {
                            $voucher->name = $voucherObj->name;
                            $voucher->reduction_percent = (float) $voucherObj->reduction_percent;
                            $voucher->reduction_amount = (float) $voucherObj->reduction_amount;
                            $voucher->reduction_extras = (int) $voucherObj->reduction_extras;
                            $voucher->enabled = (int) $voucherObj->enabled;
                        } else {
                            $rental_details->errors[] = 'VOUCHER_EXPIRED';
                            unset($product->vouchers[$key]);
                            break;
                        }
                        if (isset($voucherObj->reduction_percent) && $voucherObj->reduction_amount == '0.00') {
                            $voucher->reduction_formatted = Tools::displayNumber($voucherObj->reduction_percent).'%';
                        } elseif (isset($voucherObj->reduction_amount) && $voucherObj->reduction_amount > 0) {
                            $voucher->reduction_formatted = Tools::displayPrice(Tools::convertPrice($voucher->reduction_amount));
                        }
                        $voucher->reduction_formatted = '-'.$voucher->reduction_formatted;
                        foreach ($voucherObj->getExtras($context->language->id) as $extra) {
                            $voucher->extras[] = $extra['id_roja45_product_extra'];
                        }
                    }
                }
            }

            $total = 0.0;
            $total_to_pay = 0.0;
            $total_to_pay_now_exc = 0.0;
            $total_to_pay_now_inc = 0.0;
            $total_deposit_to_pay = 0.0;
            $total_with_tax = 0.0;
            $total_to_pay_with_tax = 0.0;
            $total_deposit_to_pay_with_tax = 0.0;
            $total_product = 0;
            $total_to_pay_product = 0;
            $total_product_discount = 0;
            $total_product_rates = 0;
            $total_product_rates_with_tax = 0;
            $total_product_models = 0;
            $total_product_models_with_tax = 0;
            $total_product_extras = 0;
            $total_product_extras_with_tax = 0;
            $total_product_extras_to_pay = 0;
            $total_product_extras_to_pay_with_tax = 0;
            //$total_with_tax_model = 0.0;
            //$total_to_pay_with_tax_model = 0.0;
            $total_rate_discount = 0.0;
            $total_extra_discount = 0.0;
            $total_voucher_discount = 0.0;
            $total_number_models = 0;
            $deposit_percentages = array();
            if (isset($product->models) && count((array)$product->models)) {
                foreach ($product->models as &$model) {
                    $rental_details->no_models = 0;
                    $rental_details->rental_valid = 1;
                    $number_of_models = 0;
                    $total_model = 0;
                    $total_model_with_tax = 0;
                    $total_to_pay_model = 0;
                    $total_to_pay_model_with_tax = 0;
                    $total_model_discount = 0;
                    $modelObj = new ProductRentalModel($model->id_roja45_product_rental_model, $context->language->id);

                    if (Configuration::get('ROJA45_PRODUCTRENTAL_ENABLECUSTOMERTIMESELECT')) {
                        if (empty($model->collection_time)) {
                            $model->collection_time = Configuration::get('ROJA45_PRODUCTRENTAL_COLLECTIONTIME').':00';
                        }
                        $collection_date_obj = DateTime::createFromFormat(
                            $context->language->date_format_lite . ' H:s:i',
                            $model->collection_date . ' ' . $model->collection_time
                        );
                        if (empty($model->return_time)) {
                            $model->return_time = Configuration::get('ROJA45_PRODUCTRENTAL_RETURNTIME').':00';
                        }
                        $return_date_obj = DateTime::createFromFormat(
                            $context->language->date_format_lite . ' H:s:i',
                            $model->return_date . ' ' . $model->return_time
                        );
                    } else {
                        $collection_date_obj = DateTime::createFromFormat(
                            $context->language->date_format_lite,
                            $model->collection_date
                        );
                        $return_date_obj = DateTime::createFromFormat(
                            $context->language->date_format_lite,
                            $model->return_date
                        );
                        $model->collection_time = Configuration::get('ROJA45_PRODUCTRENTAL_COLLECTIONTIME').':00';
                        $model->return_time = Configuration::get('ROJA45_PRODUCTRENTAL_RETURNTIME').':00';
                    }
                    if (Validate::isLoadedObject($paymentprofile)) {
                        $deposit_amount = number_format(
                            (float)$paymentprofile->getDepositPercentage($collection_date_obj->format('Y-m-d')),
                            2,
                            '.',
                            ''
                        );
                    }
                    $deposit_percentages[] = $deposit_amount;

                    $total_rates = 0.0;
                    $total_rates_with_tax = 0.0;
                    $total_to_pay_rates = 0.0;
                    $total_to_pay_rates_with_tax = 0.0;
                    $total_discount_rates = 0.0;
                    $number_of_periods = 0;
                    // TODO -  This should be moved to a calculation class (like tax calculator), to contain period specific calculations.

                    $rate_duration = new ProductRentalRateDuration($model->id_roja45_product_rateduration);
                    foreach ($model->rates as &$rate) {
                        $rateObj = new ProductRentalRate($rate->id_roja45_product_rate);
                        //dump($rate);
                        $total_for_rate = 0.0;
                        $total_for_rate_with_tax = 0.0;
                        $total_to_pay_rate = 0.0;
                        $total_to_pay_rate_with_tax = 0.0;
                        //$total_discount_for_rate = 0.0;

                        if (!isset($rate->periods)) {
                            $periods = $rate_duration->getPeriods(
                                $model->collection_date . ' ' . $model->collection_time,
                                $model->return_date . ' ' . $model->return_time,
                                $context->language->date_format_lite . ' H:s:i'
                            );
                            $periods = ProductRentalPriceRule::processPriceRules(
                                $product->id_roja45_product,
                                $periods
                            );
                            $rate->periods = $periods;
                        }
                        $offset = 0;
                        foreach ($rate->periods as &$period) {
                            $rate_details = array();
                            if (!isset($period->total)) {
                                $current_discount = ProductRentalDiscount::getDiscount(
                                    $product->id_roja45_product,
                                    $period->period,
                                    true,
                                    $offset
                                );
                               // dump($period->period);

                                //este dump saca el descuento a ser aplicado como porcentaje (10, 20, 30, etc)
                                //dump($offset.": ".$current_discount);

                                if (Configuration::get('ROJA45_PRODUCTRENTAL_RULEMODIFIERDISCOUNTPROCESS')) {
                                    if (!isset($period->rule_modifier) || (isset($period->rule_modifier) && isset($period->apply_discount))) {

                                        $offset++;
                                    } else {
                                        $current_discount = 0;
                                    }
                                } else {
                                    $offset++;

                                }

                                if (!isset($rate->value)) {
                                    $rate_value = (float)($rateObj->rate);
                                } else {
                                    $rate_value = $rate->value;
                                }

                                $period->special_rate = 0;
                                if (!isset($rate->value)) {
                                    // TODO - will need to be ProductRentalPeriodRate
                                    if ($id_roja45_product_daterate = ProductRentalDateRate::exists(
                                        $product->id_roja45_product,
                                        $rateObj->id_parent,
                                        $rate->id_roja45_product_rate,
                                        $period->period
                                    )) {
                                        $period_rate = new ProductRentalDateRate($id_roja45_product_daterate);
                                        $rate_value = $period_rate->rate;
                                        $rate_details['special_rate'] = true;
                                        $period->special_rate = 1;
                                    }
                                }

                                $period->value = $rate_value;
                                $period->original_rate = $rate_value;
                                $period->original_rate_formatted = Tools::displayPrice(
                                    Tools::convertPrice($period->original_rate)
                                );

                                // Special rules.
                                $period->modified_rate = $rate_value;
                                $period->rule_discount = 0;
                                if (isset($period->rule_modifier) && $period->rule_modifier) {
                                    $period->rule_discount = $period->original_rate * ($period->rule_modifier/100);
                                    $period->modified_rate = $period->original_rate - $period->rule_discount;
                                }

                                $discount_rate_value = $rate_value;

                                if ($current_discount) {
                                    $discount_rate_value = $rate_value - ($rate_value * ($current_discount/100));
                                }
                                // este dump ya saca el total menos lo descontado por día
                                //dump($discount_rate_value);
                                $discount_for_rate = 0;
                                if ($discount_rate_value <= $period->modified_rate) {
                                    $discount_for_rate = ($rate_value - $discount_rate_value);
                                    $rate_value = $discount_rate_value;
                                } else {
                                    $discount_for_rate = $period->rule_discount;
                                    $rate_value = $period->modified_rate;
                                }
                                $total_rate_discount += $discount_for_rate;

                                $voucher_discount_percent = 0.0;
                                $voucher_discount_amount = 0.0;
                                if (isset($product->vouchers) && count((array)$product->vouchers)) {
                                    foreach ($product->vouchers as $voucher) {
                                        if ($voucher->enabled) {
                                            // TODO - Need to check the dates here
                                            $voucher_discount_percent += $voucherObj->reduction_percent;
                                            $voucher_discount_amount += $voucherObj->reduction_amount;
                                        }
                                    }
                                }

                                $voucher_discount_for_rate = 0;
                                if ($voucher_discount_percent) {
                                    $voucher_discount = $rate_value * ($voucher_discount_percent/100);
                                    $voucher_discount_for_rate += $voucher_discount;
                                }
                                if ($voucher_discount_amount) {
                                    $voucher_discount_for_rate += $voucher_discount_amount;
                                }

                                $period->discount = $discount_for_rate + $voucher_discount_for_rate;
                                $period->discount_formatted = Tools::displayPrice(
                                    Tools::convertPrice($period->discount)
                                );
                                $total_rate_discount += $voucher_discount_for_rate;
                                //$total_voucher_discount += $period->discount;
                                //$total_voucher_discount += $voucher_discount_for_rate;
                                $rate_value -= $voucher_discount_for_rate;

                                // TODO - Need to get rate value inc period price and discount check.
                                $period->rate = $rate_value;
                                $period->rate_formatted = Tools::displayPrice(
                                    Tools::convertPrice($period->rate)
                                );
                                $period->tax = 0;
                                if ($tax_enabled && $usetax) {
                                    $period->tax = $product_tax_calculator->addTaxes($rate_value) - $rate_value;
                                }
                                $period->tax_formatted = Tools::displayPrice(
                                    Tools::convertPrice($period->tax)
                                );
//                                if(isset($period->period_weekday) && $period->period_weekday == 7){
//                                    $period->total = 0;
//                                }
//                                else {
                                    $period->total = $rate_value;
//                                }
                            }

                            $total_for_period = $period->value * $rate->qty;
                            $total_for_period_with_tax = 0;
                            if ($tax_enabled && $usetax) {
                                $total_for_period_with_tax = $product_tax_calculator->addTaxes($total_for_period);
                            }


                                $total_to_pay_period = $period->total * $rate->qty;

                            $total_to_pay_period_with_tax = ($period->total + $period->tax ) * $rate->qty;

                            $total_discount_for_period = $period->discount * $rate->qty;
                            $total_for_rate += $total_for_period;
                            $total_for_rate_with_tax += $total_to_pay_period_with_tax;
                            $total_to_pay_rate += $total_to_pay_period;
                            $total_to_pay_rate_with_tax += $total_to_pay_period_with_tax;
                            if ($modelObj->minimum_rate_enabled > 0 && $total_for_rate < $modelObj->minimum_rate) {
                                $total_for_rate = $modelObj->minimum_rate;
                                if ($tax_enabled && $usetax) {
                                    $total_for_rate_with_tax = $product_tax_calculator->addTaxes($modelObj->minimum_rate);
                                }
                            }

                            $total_rates += $total_for_period;
                            $total_rates_with_tax += $total_for_period_with_tax;
                            $total_to_pay_rates += $total_to_pay_period;
                            $total_to_pay_rates_with_tax += $total_to_pay_period_with_tax;
                            $total_discount_rates += $total_discount_for_period;
                            $number_of_periods++;
                            //dump($period);
                        }


                        if ($number_of_periods) {
                            $rate->average_rate = $total_to_pay_rates/$number_of_periods;
                            $rate->average_rate_formatted = Tools::displayPrice(Tools::convertPrice($rate->average_rate));
                        } else {
                            $rate->average_rate = 0;
                            $rate->average_rate_formatted = Tools::displayPrice(Tools::convertPrice(0));
                        }
                        $number_of_models += $rate->qty;
                    }

                    $total_model += $total_rates;
                    $total_model_with_tax += $total_rates_with_tax;
                    $total_to_pay_model += $total_to_pay_rates;
                    $total_to_pay_model_with_tax += $total_to_pay_rates_with_tax;
                    //$total_model_discount += $total_discount_rates;
                    $total_to_pay_extras = 0.0;
                    $total_to_pay_extras_with_tax = 0.0;
                    $total_extras = 0.0;
                    $total_extras_with_tax = 0.0;
                    if (isset($model->extras)) {
                        foreach ($model->extras as &$extra) {
                            if (is_numeric($extra->id_roja45_product_extra)) {
                                $extraObj = new ProductRentalExtra(
                                    $extra->id_roja45_product_extra,
                                    $context->language->id
                                );
                                $id_roja45_product_extralink = ProductRentalModelExtra::getModelExtra(
                                    $extra->id_roja45_product_extra,
                                    $extra->id_roja45_product_model
                                );
                                $model_extra = new ProductRentalModelExtra($id_roja45_product_extralink);

                                $extra->total = $extraObj->calculateExtraCost(
                                    $model_extra->rate,
                                    $collection_date_obj->format('Y-m-d'),
                                    $return_date_obj->format('Y-m-d'),
                                    $number_of_models,
                                    1
                                );
                                $extra->value = $model_extra->rate;
                                $extra->name = $extraObj->name;
                                $voucher_discount_percent = 0.0;
                                $voucher_discount_amount = 0.0;
                                if (isset($product->vouchers) && count((array)$product->vouchers)) {
                                    foreach ($product->vouchers as $voucher) {
                                        if ($voucher->enabled && $voucher->reduction_extras) {
                                            $voucher_discount_percent += $voucherObj->reduction_percent;
                                            $voucher_discount_amount += $voucherObj->reduction_amount;
                                        }
                                        if (isset($voucher->extras) &&
                                            in_array($extra->id_roja45_product_extra, $voucher->extras)
                                        ) {
                                            $voucher_discount_percent = 100;
                                            $voucher_discount_amount = 0;
                                        }
                                    }
                                }

                                $extra->discount = 0.0;
                                if ($voucher_discount_percent) {
                                    $extra->discount += $extra->total * ($voucher_discount_percent/100);
                                }
                                if ($voucher_discount_amount) {
                                    $extra->discount += ($voucher_discount_amount *$number_of_periods);
                                }
                                //$total_voucher_discount += $extra->discount;
                                $total_extra_discount += $extra->discount;
                                $extra_with_discount = $extra->total - $extra->discount;
                                $total_to_pay_extras += $extra_with_discount;
                                $total_extras += $extra_with_discount;

                                $extra->tax = 0;
                                if ($tax_enabled && $usetax) {
                                    $extra->tax = $product_tax_calculator->addTaxes(
                                        $extra_with_discount
                                    ) - $extra_with_discount;
                                    $total_to_pay_extras_with_tax = $product_tax_calculator->addTaxes(
                                        $total_to_pay_extras
                                    );
                                }
                                $total_extras_with_tax += ($extra_with_discount+$extra->tax);
                            }
                        }
                    }
                    $total_model_discount += $total_rate_discount;
                    $total_model_discount += $total_extra_discount;
                    //$total_model_discount += $total_voucher_discount;
                    $total_model += $total_extras;
                    $total_model_with_tax += $total_extras_with_tax;
                    $total_to_pay_model += $total_extras;
                    $total_to_pay_model_with_tax += $total_extras_with_tax;

                    $total += $total_model;
                    $total_with_tax += $total_model_with_tax;
                    $total_to_pay += $total_to_pay_model;

                    $total_model_to_pay_now_exc = ($total_to_pay_model * ($deposit_amount / 100));
                    $total_to_pay_now_exc += $total_model_to_pay_now_exc;

                    $total_to_pay_with_tax += $total_to_pay_model_with_tax;

                    $total_model_to_pay_now_inc = ($total_to_pay_model_with_tax * ($deposit_amount / 100));
                    $total_to_pay_now_inc += $total_model_to_pay_now_inc;

                    $total_product += $total_model;
                    $total_to_pay_product += $total_to_pay_model;
                    $total_product_discount += $total_model_discount;
                    $total_product_rates += $total_rates;
                    $total_product_rates_with_tax += $total_rates_with_tax;
                    $total_product_models += $total_to_pay_model;
                    $total_product_models_with_tax += $total_to_pay_model_with_tax;
                    $total_product_extras += $total_extras;
                    $total_product_extras_with_tax += $total_extras_with_tax;

                    $total_product_extras_to_pay += $total_to_pay_extras;
                    $total_product_extras_to_pay_with_tax += $total_to_pay_extras_with_tax;

                    $model->total_rates = $total_rates;
                    $model->total_rates_with_tax = $total_rates_with_tax;
                    $model->total_model = $total_model;
                    $model->total_model_with_tax = $total_model_with_tax;
                    $model->total_model_discount = $total_model_discount;
                    $model->total_model_discount_with_tax  = $total_model_discount;
                    if ($tax_enabled && $usetax) {
                        $model->total_model_discount_with_tax = $product_tax_calculator->addTaxes($total_model_discount);
                    }
                    $model->total_to_pay_model = $total_to_pay_model * ($deposit_amount / 100);
                    $model->total_to_pay_model_formatted = Tools::displayPrice(
                        Tools::convertPrice($model->total_to_pay_model)
                    );
                    $total_number_models += $number_of_models;
                    $model->number_of_models = $number_of_models;
                    if ($rental_product->id_roja45_product_damagedeposit) {
                        $damage_deposit_total = (double) $damage_deposit->calculateDamageDeposit(
                            $number_of_models,
                            count((array) $rate->periods),
                            $total_to_pay_model,
                            $total_to_pay_model_with_tax,
                            $total_model_to_pay_now_exc,
                            $total_model_to_pay_now_inc
                        );
                        $model->damage_deposit_exc = $damage_deposit_total;
                        $model->damage_deposit_inc = $damage_deposit_total;
                        $total_product_damage_deposit_exc += $model->damage_deposit_exc;
                        if (isset($damage_deposit_tax_calculator)) {
                            $model->damage_deposit_inc = $damage_deposit_tax_calculator->addTaxes(
                                $model->damage_deposit_exc
                            );
                            $total_product_damage_deposit_inc += $model->damage_deposit_inc;
                        }
                    } else {
                        $model->damage_deposit_exc = 0;
                        $model->damage_deposit_inc = 0;
                    }
                    $model->damage_deposit_exc_formatted = Tools::displayPrice(
                        Tools::convertPrice($model->damage_deposit_exc)
                    );
                    $model->damage_deposit_inc_formatted = Tools::displayPrice(
                        Tools::convertPrice($model->damage_deposit_inc)
                    );
                }
            } else {
                $rental_details->no_models = 1;
                $rental_details->errors[] = 'ERROR_NO_MODELS';
            }

            if (!count($deposit_percentages)) {
                $deposit_percentage = 100;
            } else {
                $deposit_percentage = 0;
                foreach ($deposit_percentages as $percentage) {
                    $deposit_percentage += $percentage;
                }
                $deposit_percentage = $deposit_percentage/(count($deposit_percentages));
            }

            if ($tax_enabled && $usetax) {
                $total_tax = $total_to_pay_with_tax - $total_to_pay;
            } else {
                $total_tax = 0;
            }

            $total_damage_deposit_exc += $total_product_damage_deposit_exc;
            $total_damage_deposit_inc += $total_product_damage_deposit_inc;

            $product->total_number_of_models = $total_product_models;
            $product->total_rate_discount = $total_rate_discount;
            $product->total_rate_discount_formatted = Tools::displayPrice(
                Tools::convertPrice($total_rate_discount)
            );
            $product->total_extra_discount = $total_extra_discount;
            $product->total_extra_discount_formatted = Tools::displayPrice(
                Tools::convertPrice($product->total_extra_discount)
            );
            $product->total_models_discount = $total_product_discount;
            $product->total_models_discount_formatted = Tools::displayPrice(
                Tools::convertPrice($total_product_discount)
            );
            $product->total_rates = $total_product_rates;
            $product->total_rates_formatted = Tools::displayPrice(Tools::convertPrice($total_product_rates));
            $product->total_rates_with_tax = $total_product_rates_with_tax;
            $product->total_rates_formatted_with_tax = Tools::displayPrice(
                Tools::convertPrice($total_product_rates_with_tax)
            );
            $product->total_models = $total_product_models;
            $product->total_models_with_tax = $total_product_models_with_tax;
            $product->total_models_formatted = Tools::displayPrice(Tools::convertPrice($total_product_models));
            $product->total_models_with_tax_formatted = Tools::displayPrice(
                Tools::convertPrice($total_product_models_with_tax)
            );
            $product->total = $total;
            $product->total_formatted = Tools::displayPrice(Tools::convertPrice($total));
            $product->total_with_tax = $total_with_tax;
            $product->total_with_tax_formatted = Tools::displayPrice(Tools::convertPrice($total_with_tax));
            $product->total_to_pay = $total_to_pay;
            $product->total_to_pay_formatted = Tools::displayPrice(Tools::convertPrice($total_to_pay));
            $product->total_to_pay_with_tax = $total_to_pay_with_tax;
            $product->total_to_pay_with_tax_formatted = Tools::displayPrice(
                Tools::convertPrice($total_to_pay_with_tax)
            );
            $product->total_tax = $total_tax;
            $product->total_tax_formatted = Tools::displayPrice(Tools::convertPrice($total_tax));
            $product->total_to_pay_now_exc = $total_to_pay_now_exc;
            $product->total_to_pay_now_inc = $total_to_pay_now_inc;
            $product->total_to_pay_now_exc_formatted = Tools::displayPrice(Tools::convertPrice($total_to_pay_now_exc));
            $product->total_to_pay_now_inc_formatted = Tools::displayPrice(Tools::convertPrice($total_to_pay_now_inc));
            $product->total_deposit_to_pay = $total_deposit_to_pay;
            $product->total_deposit_to_pay_formatted = Tools::displayPrice(Tools::convertPrice($total_deposit_to_pay));
            $product->total_deposit_to_pay_with_tax = $total_deposit_to_pay_with_tax;
            $product->total_deposit_to_pay_with_tax_formatted = Tools::displayPrice(
                Tools::convertPrice($total_deposit_to_pay_with_tax)
            );
            $product->total_extras_to_pay = $total_product_extras_to_pay;
            $product->total_extras_to_pay_formatted = Tools::displayPrice(
                Tools::convertPrice($product->total_extras_to_pay)
            );
            $product->deposit_amount = $deposit_percentage;
            $product->total_voucher_discount = $total_voucher_discount;
            //$product->deposit_amount = $deposit_amount;
            $product_deposits[] = $product->deposit_amount;
            $total_rental_discounts += $total_product_discount;
            $total_rental_exc += $total;
            $total_to_pay_rental_exc += $total_to_pay;
            $total_rental_inc += $total_with_tax;
            $total_to_pay_rental_inc += $total_to_pay_with_tax;

            $total_rental_to_pay_exc += $total_to_pay_now_exc;
            $total_rental_to_pay_inc += $total_to_pay_now_inc;

            if ($rental_product->id_roja45_product_damagedeposit) {
                $total_product_damage_deposit_amount_exc += $damage_deposit->deposit_amount;
            }
        }

        if ($total_product_damage_deposit_amount_exc) {
            $total_product_damage_deposit_amount_exc/count((array) $rental_details->products);
        }

        if (!count($product_deposits)) {
            $total_rental_deposit = 100;
        } else {
            $product_deposit = 0;
            foreach ($product_deposits as $percentage) {
                $product_deposit += $percentage;
            }
            $total_rental_deposit = $product_deposit/(count($product_deposits));
        }

        $rental_details->total_rental_deposit = $total_rental_deposit;
        $rental_details->total_rental_discounts = $total_rental_discounts;
        $rental_details->total_rental_discounts_formatted = Tools::displayPrice(
            Tools::convertPrice($total_rental_discounts)
        );
        $rental_details->total_rental_exc = $total_rental_exc;
        $rental_details->total_rental_exc_formatted = Tools::displayPrice(
            Tools::convertPrice($total_rental_exc)
        );
        $rental_details->total_rental_inc = $total_rental_inc;
        $rental_details->total_rental_inc_formatted = Tools::displayPrice(
            Tools::convertPrice($total_rental_inc)
        );
        $rental_details->total_rental_to_pay_exc = $total_rental_to_pay_exc;
        $rental_details->total_rental_to_pay_exc_formatted = Tools::displayPrice(
            Tools::convertPrice($total_rental_to_pay_exc)
        );
        $rental_details->total_rental_to_pay_inc = $total_rental_to_pay_inc;
        $rental_details->total_rental_to_pay_inc_formatted = Tools::displayPrice(
            Tools::convertPrice($total_rental_to_pay_inc)
        );
        $rental_details->tax_enabled = $tax_enabled;

        $rental_details->average_tax_rate = $average_tax_rate;
        if ($average_tax_rate>0) {
            $rental_details->average_tax_rate = $average_tax_rate/count($rental_details->products);
        }

        $rental_details->total_rental = 0;
        $rental_details->average_damage_deposit_amount_exc = $total_product_damage_deposit_amount_exc;
        $rental_details->average_damage_deposit_amount_exc_formatted = Tools::displayPrice(
            Tools::convertPrice($total_product_damage_deposit_amount_exc)
        );
        $rental_details->total_damage_deposit_exc = $total_damage_deposit_exc;
        $rental_details->total_damage_deposit_exc_formatted = Tools::displayPrice(
            Tools::convertPrice($total_damage_deposit_exc)
        );

        $rental_details->total_damage_deposit_inc = $total_damage_deposit_inc;
        $rental_details->total_damage_deposit_inc_formatted = Tools::displayPrice(
            Tools::convertPrice($total_damage_deposit_inc)
        );

        $rental_details->total_to_pay_with_damage_deposit_exc = $total_damage_deposit_exc+$total_rental_to_pay_exc;
        $rental_details->total_to_pay_with_damage_deposit_exc_formatted = Tools::displayPrice(
            Tools::convertPrice($rental_details->total_to_pay_with_damage_deposit_exc)
        );

        $rental_details->total_with_damage_deposit_exc = $total_damage_deposit_exc+$total_rental_exc;
        $rental_details->total_with_damage_deposit_exc_formatted = Tools::displayPrice(
            Tools::convertPrice($rental_details->total_with_damage_deposit_exc)
        );

        $rental_details->total_with_damage_deposit_inc = $total_damage_deposit_inc+$total_rental_inc;

        $rental_details->total_with_damage_deposit_inc_formatted = Tools::displayPrice(
            Tools::convertPrice($rental_details->total_with_damage_deposit_inc)
        );

        $rental_details->total_to_pay_with_damage_deposit_inc = $total_damage_deposit_inc+$total_rental_to_pay_inc;
        $rental_details->total_to_pay_with_damage_deposit_inc_formatted = Tools::displayPrice(
            Tools::convertPrice($rental_details->total_to_pay_with_damage_deposit_inc)
        );
        if (count($rental_details->errors)) {
            $rental_details->rental_valid = 0;
        }
        //dump($rental_details);

        return $rental_details;
    }

    public function populateCart($id_roja45_productrental_payment)
    {
        $context = Context::getContext();
        if (!$context->cart->id) {
            if ($context->cookie->id_guest) {
                $guest = new Guest($context->cookie->id_guest);
                $context->cart->mobile_theme = $guest->mobile_theme;
            }
            $context->cart->add();
            if ($context->cart->id) {
                $context->cookie->id_cart = (int) $context->cart->id;
            }
        } else {
            $cart_products = $context->cart->getProducts(true);
            foreach ($cart_products as $cart_product) {
                $context->cart->deleteProduct(
                    $cart_product['id_product'],
                    $cart_product['id_product_attribute']
                );
            }
        }

        $mysql_date_now = date('Y-m-d H:i:s', strtotime(date('Y-m-d H:i:s'))-60 * 60);
        $mysql_date_until = date('Y-m-d H:i:s', strtotime(date('Y-m-d H:i:s') . ' +1 day'));
        SpecificPrice::deleteByIdCart((int) $context->cart->id);

        $payment = new ProductRentalRentalPayment($id_roja45_productrental_payment);
        foreach ($this->getProducts() as $product) {
            $models = ProductRentalRentalModel::getModels($product['id_roja45_product_rental_product']);
            foreach ($models as $model) {
                $payment_item = $payment->getPaymentItem(
                    $product['id_product'],
                    $model['id_product_attribute']
                );
                if ($payment_item && $payment_item->total_paid > 0) {
                    $context->cart->deleteProduct(
                        $product['id_product'],
                        $model['id_product_attribute'],
                        null,
                        0
                    );
                    $specific_price = new SpecificPrice();
                    $specific_price->id_shop = $context->shop->id;
                    $specific_price->id_shop_group = $context->shop->id_shop_group;
                    $specific_price->id_currency = 0;
                    $specific_price->id_country = 0;
                    $specific_price->id_group = 0;
                    $specific_price->id_cart = (int) $context->cart->id;
                    $specific_price->id_customer = (int)$context->customer->id;
                    $specific_price->id_product = $product['id_product'];
                    $specific_price->id_product_attribute = $model['id_product_attribute'];
                    $specific_price->price = $payment_item->total_paid;
                    $specific_price->from_quantity = 1;
                    $specific_price->reduction = 0;
                    $specific_price->reduction_type = 'amount';
                    $specific_price->reduction_tax = 0;
                    $specific_price->from = $mysql_date_now;
                    $specific_price->to = $mysql_date_until;
                    if ($specific_price->save()) {
                        if (!$context->cart->updateQty(
                            1,
                            $product['id_product'],
                            $model['id_product_attribute']
                        )) {
                            throw new Exception($this->l(
                                'Unable to add product to cart ['.
                                $product['id_product'].
                                '] ['.$model['id_product_attribute'].
                                ']'
                            ), 'AdminProductRentals');
                        }
                    }
                }
            }
        }

        return true;
    }

    public static function getDailyRateDetails(
        $collection_date,
        $collection_time,
        $return_date,
        $return_time,
        $id_roja45_product,
        $id_roja45_product_rate,
        $selected_qty
    ) {
        if (Configuration::get('ROJA45_PRODUCTRENTAL_ENABLECUSTOMERTIMESELECT')) {
            $collection_date_obj = DateTime::createFromFormat(
                Context::getContext()->language->date_format_lite . ' H:s',
                $collection_date . ' ' . $collection_time
            );
            $return_date_obj = DateTime::createFromFormat(
                Context::getContext()->language->date_format_lite . ' H:s',
                $return_date . ' ' . $return_time
            );
        } else {
            $collection_date_obj = DateTime::createFromFormat(
                Context::getContext()->language->date_format_lite,
                $collection_date
            );
            $return_date_obj = DateTime::createFromFormat(
                Context::getContext()->language->date_format_lite,
                $return_date
            );
        }

        $rental_rate = new ProductRentalRate($id_roja45_product_rate);
        $rental_rate_type = new ProductRentalRateType($rental_rate->id_type);
        $rental_rate_duration = new ProductRentalRateDuration($rental_rate_type->id_roja45_product_rateduration);

        $periods = $rental_rate_duration->getPeriods(
            $collection_date_obj,
            $return_date_obj
        );

        $periods = ProductRentalPriceRule::processPriceRules(
            $id_roja45_product,
            $periods
        );

        foreach ($periods as $offset => &$period) {
            $current_discount = ProductRentalDiscount::getDiscount(
                $id_roja45_product,
                $period->period,
                true,
                $offset
            );
            $rate_value = (float)($rental_rate->rate);
            $date = DateTime::createFromFormat(
                'Y-m-d',
                $period['period']
            );

            $period['special_rate'] = 0;

            if ((int) Configuration::get('ROJA45_PRODUCTRENTAL_USEPERIODPRICING')) {
                if ($special_rate = ProductRentalPeriodRate::getPricePeriodForDate(
                    $id_roja45_product,
                    $rental_rate->id_parent,
                    $rental_rate_type->id_roja45_product_ratetype,
                    Context::getContext()->language->id,
                    $period['period']
                )) {
                    $rate_value = (float)($special_rate[0]['rate']);
                    $period['special_rate'] = 1;
                }
            } else {
                if ($id_roja45_product_daterate = ProductRentalDateRate::exists(
                    $id_roja45_product,
                    $rental_rate->id_parent,
                    $rental_rate->id_roja45_product_rate,
                    $period['period']
                )) {
                    $date_rate = new ProductRentalDateRate($id_roja45_product_daterate);
                    $rate_value = $date_rate->rate;
                    $period['special_rate'] = true;
                }
            }

            //$day['day'] = $current_day;
            // TODO - this need
            $period['original_rate'] = $rate_value;
            $period['original_rate_formatted'] = Tools::displayPrice(
                Tools::convertPrice($rate_value)
            );
            $period['total_original_rate'] = $rate_value * $selected_qty;
            $period['total_original_rate_formatted'] = Tools::displayPrice(
                Tools::convertPrice($period['total_original_rate'])
            );
            $period['qty'] = $selected_qty;

            if ($current_discount) {
                $discount_rate_value = $rate_value - ($rate_value * ($current_discount/100));
                $discount_for_rate = ($rate_value - $discount_rate_value);
                $rate_value = $discount_rate_value;
                $period['discount_amount'] = $current_discount;
                $period['discount_for_rate'] = $discount_for_rate;
                $period['discount_for_rate_formatted'] = Tools::displayPrice(
                    Tools::convertPrice($discount_for_rate)
                );
                $period['total_discount_for_rate'] = $discount_for_rate * $selected_qty;
                $period['total_discount_for_rate_formatted'] = Tools::displayPrice(
                    Tools::convertPrice($period['total_discount_for_rate'])
                );
            }

            $period['rate'] = $rate_value;
            $period['rate_formatted'] = Tools::displayPrice(
                Tools::convertPrice($period['rate'])
            );
            $period['total_rate'] = $rate_value * $selected_qty;
            $period['total_rate_formatted'] = Tools::displayPrice(
                Tools::convertPrice($period['total_rate'])
            );

            $date->add(new DateInterval('P1D'));
        }
        return $periods;
    }

    public function setStatus($status)
    {
        Hook::exec(
            'actionProductRentalSetStatus'.$status.'Before',
            array(
                'rental' => $this
            )
        );
        PrestaShopLogger::addLog(
            'Manuel Roja Debug::setStatus - '.$status,
            3,
            null,
            'ProductRentalRental',
            (int) $this->id_roja45_product_rental,
            true
        );
        $context = Context::getContext();
        $id_roja45_product_rental_status = ProductRentalRentalStatus::getStatusByType($status);

        $statusObj = new ProductRentalRentalStatus($id_roja45_product_rental_status);
       // dump($statusObj);die();
        $this->id_roja45_product_rental_status = $statusObj->id;
        $this->save();

        Hook::exec(
            'actionProductRentalStatusChange',
            array('rental' => $this->toJSON(Configuration::get('PS_LANG_DEFAULT')))
        );

        if (isset($statusObj->send_always) &&
            !$statusObj->send_always &&
            ProductRentalRentalProcess::exists($this->id_roja45_product_rental, $status)
        ) {
            PrestaShopLogger::addLog(
                'Manuel Roja Debug::Status no existe',
                3,
                null,
                'ProductRentalRental',
                (int) $this->id_roja45_product_rental,
                true
            );
            return;
        }

        if (isset($statusObj->record_history) && $statusObj->record_history) {
            ProductRentalRentalProcess::addStatus($this->id, $status);
        }

        $customer = new Customer((int)$this->id_customer);
        $template_vars = $this->getTemplateVars();
        if (Validate::isLoadedObject($customer)) {
            if ($statusObj->send_email && $statusObj->answer_template) {
                $summary_tpl = RojaFortyFiveProductRentalCore::createTemplate(
                    'roja45productrental',
                    'emailTemplateCustomerRentalSummary'
                );
                $summary_tpl->assign($this->getSummary());
                $summary_tpl->assign(
                    array(
                        'currency' =>  $context->currency,
                        'id_propertycart' =>  $this->id,
                        'cartImage' => ImageType::getFormatedName('cart'),
                        'mediumImage' => ImageType::getFormatedName('medium'),
                        'cartSize' => Image::getSize(ImageType::getFormatedName('cart')),
                        'mediumSize' => Image::getSize(ImageType::getFormatedName('medium')),
                    )
                );

                $summary = $summary_tpl->fetch();
                $summaryTxt = new Html2Text($summary);
                $summaryTxt = $summaryTxt->getText();
                $summary_vars = array(
                    '{summary_html}' => $summary,
                    '{summary_txt}' => $summaryTxt,
                );
                $template_vars = array_merge($summary_vars, $template_vars);
                $file_attachment = null;
                $pdf = $this->generateRentalConfirmationPDF(
                    false,
                    !Group::getPriceDisplayMethod(Group::getCurrent()->id)
                );
                $file_attachment['invoice']['content'] = $pdf;
                $file_attachment['invoice']['name'] = $this->reference;
                $file_attachment['invoice']['mime'] = 'application/pdf';
                switch ($statusObj->code) {
                    case ProductRentalRentalStatus::$RCVD:
                        $subject = Module::getInstanceByName('roja45productrental')->l('Rental Request Received');
                        $pdf = $this->generateRentalConfirmationPDF(
                            false,
                            !Group::getPriceDisplayMethod(Group::getCurrent()->id),
                            'Podsumowanie zamówienia'
                        );

                        $file_attachment['invoice']['content'] = $pdf;
                        $file_attachment['invoice']['name'] = $this->reference;
                        $file_attachment['invoice']['mime'] = 'application/pdf';
                        break;
                        break;
                    case ProductRentalRentalStatus::$CCNF:
                        $subject = Module::getInstanceByName('roja45productrental')->l('Rental Request Received');
                        PrestaShopLogger::addLog(
                            'Manuel Roja Debug::Subject -> '.$subject.', ref -> '.$this->reference,
                            3,
                            null,
                            'ProductRentalRental',
                            (int) $this->id_roja45_product_rental,
                            true
                        );
                        $pdf = $this->generateRentalConfirmationPDF(
                            false,
                            !Group::getPriceDisplayMethod(Group::getCurrent()->id),
                            'Podsumowanie zamówienia'
                        );

                        $file_attachment['invoice']['content'] = $pdf;
                        $file_attachment['invoice']['name'] = $this->reference;
                        $file_attachment['invoice']['mime'] = 'application/pdf';
                        break;
                    case ProductRentalRentalStatus::$PRES:
                        $subject = Module::getInstanceByName('roja45productrental')->l('Rental Prereserved');
                        $pdf = $this->generateRentalConfirmationPDF(
                            false,
                            !Group::getPriceDisplayMethod(Group::getCurrent()->id),
                            'Podsumowanie zamówienia'
                        );

                        $file_attachment['invoice']['content'] = $pdf;
                        $file_attachment['invoice']['name'] = $this->reference;
                        $file_attachment['invoice']['mime'] = 'application/pdf';
                        break;
                    case ProductRentalRentalStatus::$CONF:
                        $subject = 'Potwierdzenie rezerwacji';
                        ///$subject = Module::getInstanceByName('roja45productrental')->l('Rental Confirmation');
                        $pdf = $this->generateRentalConfirmationPDF(
                            false,
                            !Group::getPriceDisplayMethod(Group::getCurrent()->id)
                        );
                        $file_attachment['invoice']['content'] = $pdf;
                        $file_attachment['invoice']['name'] = $this->reference;
                        $file_attachment['invoice']['mime'] = 'application/pdf';
                        break;
                    case ProductRentalRentalStatus::$DPST:
                        $subject = Module::getInstanceByName('roja45productrental')->l('Deposit Received');
                        $pdf = $this->generateRentalConfirmationPDF(
                            false,
                            !Group::getPriceDisplayMethod(Group::getCurrent()->id)
                        );
                        $file_attachment['invoice']['content'] = $pdf;
                        $file_attachment['invoice']['name'] = $this->reference;
                        $file_attachment['invoice']['mime'] = 'application/pdf';
                        break;
                    case ProductRentalRentalStatus::$OVER:
                        $subject = Module::getInstanceByName('roja45productrental')->l('Rental Return Overdue');
                        break;
                    case ProductRentalRentalStatus::$CLCT:
                        $subject = Module::getInstanceByName('roja45productrental')->l('Rental Collection Soon');
                        break;
                    case ProductRentalRentalStatus::$CCLR:
                        $subject = Module::getInstanceByName(
                            'roja45productrental'
                        )->l('Rental Cancellation Request Received');
                        break;
                    case ProductRentalRentalStatus::$RDUE:
                        $subject = Module::getInstanceByName('roja45productrental')->l('Rental Return Due');
                        break;
                    case ProductRentalRentalStatus::$REVW:
                        $subject = Module::getInstanceByName('roja45productrental')->l(
                            'Please review your rental experience'
                        );
                        break;
                    case ProductRentalRentalStatus::$RETN:
                        $subject = Module::getInstanceByName('roja45productrental')->l('Rental Return Confirmation');
                        break;
                    case ProductRentalRentalStatus::$CCLD:
                        $subject = Module::getInstanceByName('roja45productrental')->l('Rental Cancelled');
                        break;
                    case ProductRentalRentalStatus::$PAYM:
                        $subject = Module::getInstanceByName('roja45productrental')->l('Rental Payment Due');
                        $payment = ProductRentalRentalPayment::getRequestedPayment($this->id_roja45_product_rental);
                        if (!Group::getPriceDisplayMethod(Group::getCurrent()->id)) {
                            $total_to_pay = $payment->total_with_tax;
                        } else {
                            $total_to_pay = $payment->total;
                        }
                        $extra_vars = array(
                            '{required_amount}' => Tools::displayPrice(Tools::convertPrice($total_to_pay)),
                            '{payment_link}' => $context->link->getModuleLink(
                                'roja45productrental',
                                'ProductRentalFront',
                                array(
                                    'pay_customer_rental' => 1,
                                    'id_roja45_product_rental' => $this->id_roja45_product_rental,
                                    'id_roja45_product_rental_payment' => $payment->id,
                                )
                            ),
                        );
                        $template_vars = array_merge($template_vars, $extra_vars);
                        break;
                    case ProductRentalRentalStatus::$PAYR:
                        $subject = Module::getInstanceByName('roja45productrental')->l('Rental Payment Reminder');
                        $payment = ProductRentalRentalPayment::getRequestedPayment($this->id_roja45_product_rental);
                        $reminder = (string) $payment->reminders_sent;
                        if ($payment->reminders_sent==(int) Configuration::get('ROJA45_PRODUCTRENTAL_MAXIMUMREMINDERS')) {
                            $reminder = Module::getInstanceByName('roja45productrental')->l('FINAL');
                        }
                        $extra_vars = array(
                            '{required_amount}' => Tools::displayPrice(Tools::convertPrice($payment->total)),
                            '{reminder_text}' => $reminder,
                        );
                        $template_vars = array_merge($template_vars, $extra_vars);
                        break;
                    case ProductRentalRentalStatus::$PAYO:
                        $subject = Module::getInstanceByName('roja45productrental')->l('Rental Payment Overdue');
                        $payment = ProductRentalRentalPayment::getRequestedPayment($this->id_roja45_product_rental);
                        $extra_vars = array(
                            '{required_amount}' => Tools::displayPrice(Tools::convertPrice($payment->total))
                        );
                        $template_vars = array_merge($template_vars, $extra_vars);
                        break;
                    case ProductRentalRentalStatus::$PAYC:
                        $subject = Module::getInstanceByName('roja45productrental')->l('Rental Payment Confirmation');
                        $payment = ProductRentalRentalPayment::getNextPayment($this->id_roja45_product_rental);
                        $extra_vars = array(
                            '{required_amount}' => Tools::displayPrice(Tools::convertPrice($payment->total)),
                        );
                        $template_vars = array_merge($template_vars, $extra_vars);
                        break;
                    case ProductRentalRentalStatus::$CLSD:
                        if ($this->id_collection_address) {
                            $address = new Address($this->id_collection_address);
                            $address->delete();
                        }
                        if ($this->id_delivery_address) {
                            $address = new Address($this->id_delivery_address);
                            $address->delete();
                        }
                        break;
                    default:
                        break;
                }

                $subject .= ' : [#tc' . $this->reference . ']';
                $sent = Mail::Send(
                    (int)Roja45ProductRental::getTemplateLangId($statusObj->answer_template, (int)$this->id_lang),
                    $statusObj->answer_template,
                    $subject,
                    $template_vars,
                    $customer->email,
                    $customer->firstname . ' ' . $customer->lastname,
                    null,
                    null,
                    $file_attachment,
                    null,
                    _PS_ROOT_DIR_ . '/modules/roja45productrental/mails/',
                    false,
                    (int)$this->id_shop
                );
                if (!$sent) {
                    $module = Module::getInstanceByName('roja45productrental');
                    if ((bool)_PS_MODE_DEV_) {
                        PrestaShopLogger::addLog(
                            'Roja45ProductRental::setStatus - '.$module->l('Unable to send email'),
                            1,
                            null,
                            'ProductRentalRental',
                            (int) $this->id_roja45_product_rental,
                            true
                        );
                    }
                }else{
                    PrestaShopLogger::addLog(
                        'Manuel Roja Debug::Enviado '.$subject." ---" .$statusObj->answer_template,
                        3,
                        null,
                        'ProductRentalRental',
                        (int) $this->id_roja45_product_rental,
                        true
                    );
                }
            }else{
                PrestaShopLogger::addLog(
                    'Manuel Roja Debug::No entra porque no tiene activado el sendmail para este status',
                    3,
                    null,
                    'ProductRentalRental',
                    (int) $this->id_roja45_product_rental,
                    true
                );
            }
        }

        if ($statusObj->notify_admin) {
            $context = Context::getContext();
            $email = Configuration::get('ROJA45_PRODUCTRENTAL_EMAIL');
            $template_vars = array(
                '{shop_logo}' => $context->link->getMediaLink(_PS_IMG_ . Configuration::get('PS_LOGO')),
                '{shop_name}' => Configuration::get('PS_SHOP_NAME'),
                '{shop_email}' => Configuration::get('PS_SHOP_EMAIL'),
                '{shop_url}' => $context->link->getPageLink(
                    'index',
                    true,
                    $context->language->id,
                    null,
                    false,
                    $context->shop->id
                ),
                '{reference}' => $this->reference,
                '{status}' => $statusObj->status,
            );
            if (!empty($email)) {
                $sent = Mail::Send(
                    (int)Roja45ProductRental::getTemplateLangId('rental_notify_admin', (int)$this->id_lang),
                    'rental_notify_admin',
                    sprintf(
                        Mail::l(
                            'Your rental [%s]',
                            (int)Context::getContext()->language->id,
                            Context::getContext()
                        ),
                        $this->reference
                    ),
                    $template_vars,
                    $email,
                    Configuration::get('ROJA45_PRODUCTRENTAL_CONTACT_NAME'),
                    null,
                    null,
                    null,
                    null,
                    _PS_ROOT_DIR_ . '/modules/roja45productrental/mails/',
                    false,
                    (int)$this->id_shop
                );
                if (!$sent) {
                    $module = Module::getInstanceByName('roja45productrental');
                    if ((bool)_PS_MODE_DEV_) {
                        PrestaShopLogger::addLog(
                            'Roja45ProductRental::setStatus - '.$module->l('Unable to send email'),
                            1,
                            null,
                            'ProductRentalRental',
                            (int) $this->id_roja45_product_rental,
                            true
                        );
                    }
                }
            }
        }
        Hook::exec('actionProductRentalSetStatus'.$status.'After', array('reservation' => $this));
        return true;
    }

    public function getTemplateVars()
    {
        $context = Context::getContext();
        $customer = new Customer((int)$this->id_customer);
        //$rental_product = new ProductRentalDetails($this->id_roja45_product);
        $discounts = array();//$this->getReservationChargeList(ReservationCharge::$DISCOUNT);
        $charges = array();//$this->getAllCharges();
        $status = new ProductRentalRentalStatus(
            $this->id_roja45_product_rental_status,
            (int) $context->language->id
        );
        $language = new Language($this->id_lang);
        $languages = Language::getLanguages();
        if ($this->id_currency) {
            $currency = new Currency($this->id_currency);
        } else {
            $currency = new Currency(Configuration::get('PS_CURRENCY_DEFAULT'));
        }

        $tmp_vars = array(
            'languages' => $languages,
            'language' => $language,
            'defaultFormLanguage' => (int)$context->language->id,
            'reservation' => $this,
            'discounts' => $discounts,
            'charges' => $charges,
            'email' => true,
            'customer' => $customer,
            'show_exchange_rate' => ((float)$currency->conversion_rate == (float)1.0) ? 0 : 1,
            'exchange_rate' => $currency->conversion_rate,
            'tax_average_rate' => 0.0
        );

        $data = $this->getSummary();
        $total_to_pay = 0.0;
        $total_to_pay_wt = 0.0;
        // create a product list template in html and txt

        $last_payment = ProductRentalRentalPayment::getLastPayment($this->id_roja45_product_rental);
        if ($last_payment) {
            $order_summary = '';
        } else {
            $order_summary = '';
        }
        $order_summary_txt = new Html2Text($order_summary);
        $order_summary_txt = $order_summary_txt->getText();

        $template_vars = array(
            '{shop_logo}' => $context->link->getMediaLink(_PS_IMG_ . Configuration::get('PS_LOGO')),
            '{shop_name}' => Configuration::get('PS_SHOP_NAME'),
            '{shop_email}' => Configuration::get('PS_SHOP_EMAIL'),
            '{shop_address}' => Configuration::get('BLOCKCONTACTINFOS_ADDRESS'),
            '{shop_url}' => $context->link->getPageLink(
                'index',
                true,
                $context->language->id,
                null,
                false,
                $context->shop->id
            ),
            '{my_account_url}' => $context->link->getPageLink(
                'my-account',
                true,
                $context->language->id,
                null,
                false,
                $context->shop->id
            ),
            '{my_reservations_link}' => '',
            '{guest_tracking_url}' => $context->link->getPageLink(
                'guest-tracking',
                true,
                $context->language->id,
                null,
                false,
                $context->shop->id
            ),
            '{history_url}' => $context->link->getPageLink(
                'history',
                true,
                $context->language->id,
                null,
                false,
                $context->shop->id
            ),
            '{rentals_url}' => $context->link->getModuleLink(
                'roja45productrental',
                'ProductRentalFront',
                array(
                    'customer_rentals' => 1
                )
            ),
            '{rental_details_url}' => $context->link->getModuleLink(
                'roja45productrental',
                'ProductRentalFront',
                array(
                    'view_customer_rental' => 1,
                    'id_roja45_product_rental' => $this->id,
                )
            ),
            '{customer_email}' => $customer->email,
            '{firstname}' => $customer->firstname,
            '{lastname}' => $customer->lastname,
            '{customer_company}' => $customer->company,
            '{reference}' => $this->reference,
            '{received}' => $this->date_add,
            '{status_code}' => $status->code,
            '{status}' => $status->status,
            '{lastupdate}' => $this->date_upd,
            '{total}' => $total_to_pay,
            '{total_wt}' => $total_to_pay_wt,
            '{order_summary_html}' => $order_summary,
            '{order_summary_txt}' => $order_summary_txt,
            '{payment}' => '',
            //'{summary_html}' => $summary,
            //'{summary_txt}' => $summaryTxt,
            '{total_price}' => Tools::displayPrice(Tools::convertPrice($data['total_to_pay_inc'])),
        );

        return $template_vars;
    }

    public function getTaxCalculator($id_product)
    {
        if ($this->tax_calculator==null) {
            $order = new Order($this->getFirstOrder());
            $address = Address::initialize($order->id_address_invoice, false);
            //$id_address = (int)$address->id;
            $id_tax_rules_group = Product::getIdTaxRulesGroupByIdProduct((int)$id_product);
            $tax_calculator = TaxManagerFactory::getManager($address, $id_tax_rules_group)->getTaxCalculator();
            $this->tax_calculator = $tax_calculator;
        }
        return $this->tax_calculator;
    }

    public function addTax($id_product, $value)
    {
        $tax_calculator = $this->getTaxCalculator($id_product);
        return $tax_calculator->addTaxes($value);
    }

    public function getTaxCalculationMethod()
    {
        return (int)($this->taxCalculationMethod);
    }

    public function getEmailTemplateContent($template_name, $mail_type, $vars, $context, $iso_code = null)
    {
        $email_configuration = Configuration::get('PS_MAIL_TYPE');
        if ($email_configuration != $mail_type && $email_configuration != Mail::TYPE_BOTH) {
            return '';
        }

        if (!$iso_code) {
            $iso_code=$context->language->iso_code;
        }
        $theme_template_path =
            _PS_THEME_DIR_.
            'modules/roja45productrental/views/mails'.
            DIRECTORY_SEPARATOR.$iso_code.
            DIRECTORY_SEPARATOR.$template_name;
        $default_mail_template_path =
            _PS_MODULE_DIR_.
            'roja45productrental/views/mails'.
            DIRECTORY_SEPARATOR.$iso_code.
            DIRECTORY_SEPARATOR.$template_name;

        if (Tools::file_exists_cache($theme_template_path)) {
            $default_mail_template_path = $theme_template_path;
        }

        if (Tools::file_exists_cache($default_mail_template_path)) {
            $context->smarty->assign($vars);
            return $context->smarty->fetch($default_mail_template_path);
        }
        return '';
    }

    public static function recursiveArraySearch($needle, $haystack)
    {
        foreach ($haystack as $key => $value) {
            $current_key = $key;
            if ($needle === $value or
                (is_array($value) && ProductRentalRental::recursiveArraySearch($needle, $value) !== false)
            ) {
                return $current_key;
            }
        }
        return false;
    }

    public function _getFormatedAddress(Address $the_address, $line_sep, $fields_style = array())
    {
        return AddressFormat::generateAddress($the_address, array('avoid' => array()), $line_sep, ' ', $fields_style);
    }

    public function toJSON($id_lang, $encode = true)
    {
        //$customer = new Customer($this->id_customer);
        //$id_address = Address::getFirstCustomerAddressId($this->id_customer, true);
        $object = array(
            'id_roja45_product_rental' => $this->id_roja45_product_rental,
            'uid' => $this->uid,
            'reference' => $this->reference,
            'products' => array()
        );

        foreach ($this->getProducts() as $product) {
            $rental_product = new ProductRentalRentalProduct($product['id_roja45_product_rental_product'], $id_lang);
            $object['products'][] = $rental_product->toJSON($id_lang, false);
        }
        if ($encode) {
            return Tools::jsonEncode((object) $object);
        } else {
            return (object) $object;
        }
    }

    public function postProcess()
    {
        $return = true;
        Hook::exec('actionRoja45ProductRentalPostProcessBefore', array('rental' => $this));

        if (ProductRentalRentalProcess::exists($this->id_roja45_product_rental, ProductRentalRentalStatus::$CCLD)) {
            return $return;
        }
        if (ProductRentalRentalProcess::exists($this->id_roja45_product_rental, ProductRentalRentalStatus::$DLTD)) {
            return $return;
        }
        if ((int)Configuration::get('ROJA45_PRODUCTRENTAL_REQUESTPAYMENTS')) {
            $total_payment = 0;
            $totals = $this->getTotals();
            if ($totals['total_outstanding'] > 0) {
                foreach ($this->getProducts() as $rental_product) {
                    $payment_profile = new ProductRentalPaymentProfile($rental_product['id_paymentprofile']);
                    if (!Validate::isLoadedObject($payment_profile)) {
                        throw new Exception(
                            Module::getInstanceByName(
                                'roja45productrental'
                            )->l('The payment profile could not be loaded.')
                        );
                    }

                    if (($payment_profile->type != ProductRentalPaymentProfile::COD_FINAL) &&
                        ($payment_profile->type != ProductRentalPaymentProfile::FULL)
                    ) {
                        $models = ProductRentalRentalModel::getModels(
                            $rental_product['id_roja45_product_rental_product']
                        );
                        foreach ($models as $model) {
                            if ($payments = $this->getPaymentsForModel(
                                $rental_product['id_product'],
                                $model['id_product_attribute']
                            )) {
                                $total_paid = 0;
                                $total_requested = 0;
                                foreach ($payments as $payment) {
                                    $payment_item = new ProductRentalRentalPaymentItem(
                                        $payment['id_roja45_product_rental_payment_item']
                                    );
                                    if ($payment['date_paid'] != '0000-00-00 00:00:00') {
                                        $total_paid += (float)$payment_item->total_paid;
                                    }
                                    if ($payment['date_paid'] == '0000-00-00 00:00:00' && $payment['requested']) {
                                        $total_requested += (float)$payment_item->total_paid;
                                    }
                                }
                                if ($total_paid < $model['total']) {
                                    $collection_date = $model['start_date'];
                                    $days_until_collection = (
                                        strtotime($collection_date) - strtotime(date("Y-m-d" . '00:00:00'))
                                    ) / 86400;
                                    if ($days_until_collection <= $payment_profile->payment_request_days) {
                                        $total_payment += $model['total'] - $total_paid - $total_requested;
                                    }
                                }
                            }
                        }
                    }
                }
                if ($total_payment > 0) {
                    $date_due = new DateTime('now');
                    $date_due->modify(
                        '+'.(int) Configuration::get('ROJA45_PRODUCTRENTAL_FIRSTREMINDERAFTER').' day'
                    );
                    $new_payment = new ProductRentalRentalPayment();
                    $new_payment->id_roja45_product_rental = $this->id;
                    $new_payment->id_roja45_product_payment_type = ProductRentalPaymentType::BALANCE;
                    $new_payment->note = Tools::getValue(
                        Module::getInstanceByName('roja45productrental')->l('Automatically generated')
                    );
                    $new_payment->payment_due = 0;
                    $new_payment->date_due = $date_due->format('Y-m-d H:s:i');
                    $new_payment->date_requested = $date_due->format('Y-m-d H:s:i');
                    $new_payment->requested = 1;
                    $new_payment->payment_due = 1;
                    $new_payment->total = Tools::convertPrice($total_payment, $this->id_currency, false);
                    $new_payment->save();
                    $products = $this->getProducts();
                    foreach ($products as $product) {
                        $models = ProductRentalRentalModel::getModels($product['id_roja45_product_rental_product']);
                        foreach ($models as $model) {
                            $payments = $this->getPaymentsForModel(
                                $product['id_product'],
                                $model['id_product_attribute']
                            );
                            $total_paid = 0;
                            foreach ($payments as $payment) {
                                $payment_item = new ProductRentalRentalPaymentItem(
                                    $payment['id_roja45_product_rental_payment_item']
                                );
                                $total_paid += (float)$payment_item->total_paid;
                            }
                            $outstanding = $model['total'] - $total_paid;
                            if ($outstanding > 0) {
                                $payment_item = new ProductRentalRentalPaymentItem();
                                $payment_item->id_roja45_product_rental_payment = $new_payment->id;
                                $payment_item->id_product = $product['id_product'];
                                $payment_item->id_product_attribute = $model['id_product_attribute'];
                                $payment_item->total_paid = $outstanding;
                                $payment_item->save();
                            }
                        }
                    }
                    $this->setStatus(ProductRentalRentalStatus::$PAYM);
                }
            }

            $requested_payments = ProductRentalRentalPayment::getRequestedPayments($this->id);
            if (count($requested_payments)) {
                foreach ($requested_payments as $requested_payment) {
                    $payment = new ProductRentalRentalPayment(
                        $requested_payment['id_roja45_product_rental_payment']
                    );
                    $requested_date = $payment->date_requested;
                    $days_since_request = (
                            strtotime(date("Y-m-d" . '00:00:00')) - strtotime($requested_date)
                        ) / 86400;
                    if ($payment->reminders_sent &&
                        $payment->reminders_sent >= (int) Configuration::get('ROJA45_PRODUCTRENTAL_MAXIMUMREMINDERS')
                    ) {
                        $this->setStatus(ProductRentalRentalStatus::$PAYO);
                    } elseif ((bool) Configuration::get('ROJA45_PRODUCTRENTAL_REMINDERAFTER') &&
                        $payment->reminders_sent &&
                        $days_since_request > (int) Configuration::get('ROJA45_PRODUCTRENTAL_REMINDERAFTER')
                    ) {
                        (int) $payment->reminders_sent++;
                        $date_requested = new DateTime('now');
                        $payment->date_requested = $date_requested->format('Y-m-d H:s:i');
                        $payment->save();
                        $this->setStatus(ProductRentalRentalStatus::$PAYR);
                    } elseif ((bool) Configuration::get('ROJA45_PRODUCTRENTAL_FIRSTREMINDERAFTER') &&
                        !$payment->reminders_sent &&
                        $days_since_request > (int) Configuration::get('ROJA45_PRODUCTRENTAL_FIRSTREMINDERAFTER')
                    ) {
                        (int) $payment->reminders_sent++;
                        $date_requested = new DateTime('now');
                        $payment->date_requested = $date_requested->format('Y-m-d H:s:i');
                        $payment->save();
                        $this->setStatus(ProductRentalRentalStatus::$PAYR);
                    }
                }
            }
        }

        if (!ProductRentalRentalProcess::exists($this->id_roja45_product_rental, ProductRentalRentalStatus::$DLTD) ||
            !ProductRentalRentalProcess::exists($this->id_roja45_product_rental, ProductRentalRentalStatus::$CCLD) ||
            !ProductRentalRentalProcess::exists($this->id_roja45_product_rental, ProductRentalRentalStatus::$COMP)) {
            $return_due = array();
            $overdue = array();
            $rental_open = array();
            $collection_due = array();
            foreach ($this->getProducts() as $product) {
                $models = ProductRentalRentalModel::getModels($product['id_roja45_product_rental_product']);
                foreach ($models as $model) {
                    if (!$model['returned']) {
                        $time_until_collection = (
                            strtotime(
                                $model['start_date'] . ' ' . $model['collection_time']
                            ) - strtotime(date("Y-m-d H:s:i")));
                        $time_until_return = (strtotime(
                            $model['end_date'] . ' ' . $model['return_time']
                        ) - strtotime(date("Y-m-d H:s:i")));
                        if ($model['id_roja45_product_rateduration'] == ProductRentalRateDuration::DAILY) {
                            $time_until_collection = $time_until_collection / 86400;
                            $time_until_return = $time_until_return / 86400;

                            if (!$model['out_for_rent'] && $time_until_collection <= 0) {
                                $rental_open[] = $model['id_roja45_product_rental_model'];
                            } elseif (!$model['out_for_rent'] && $time_until_collection <= 1) {
                                $collection_due[] = $model['id_roja45_product_rental_model'];
                            }
                            if (!$model['return_due'] &&
                                !$model['overdue'] &&
                                $time_until_return <= (int)Configuration::get(
                                    'ROJA45_PRODUCTRENTAL_RENTALRETURNREMINDER'
                                )) {
                                $return_due[] = $model['id_roja45_product_rental_model'];
                            }

                            if ((int)Configuration::get('ROJA45_PRODUCTRENTAL_ENABLEMANUALRETURNPROCESS')) {
                                // TODO - get time until return
                                if (!$model['overdue'] && $time_until_return <= 0) {
                                    $overdue[] = $model['id_roja45_product_rental_model'];
                                }
                            }
                        }
                    }
                }
            }
            if (count($rental_open)) {
                foreach ($return_due as $due) {
                    $model = new ProductRentalRentalModel($due);
                    $model->out_for_rent = 1;
                    $model->save();
                }
                $this->setStatus(ProductRentalRentalStatus::$OPEN);
            }

            if (count($collection_due)) {
                $this->setStatus(ProductRentalRentalStatus::$CLCT);
            }

            if (count($return_due)) {
                foreach ($return_due as $due) {
                    $model = new ProductRentalRentalModel($due);
                    $model->return_due = 1;
                    $model->save();
                }
                $this->setStatus(ProductRentalRentalStatus::$RDUE);
            }

            if (count($overdue)) {
                foreach ($overdue as $over) {
                    $rental_model = new ProductRentalRentalModel($over);
                    $model = new ProductRentalModel($rental_model->id_roja45_product_model);
                    $rental_product = new ProductRentalDetails($model->id_roja45_product);

                    $rates = $rental_model->getRates();
                    $last = $rates[count($rates) - 1];
                    $date = new DateTime($last['period']);
                    $date->add(new DateInterval('P1D'));
                    switch ($rental_product->id_roja45_product_overdueaction) {
                        case 1:
                            break;
                        case 2:
                            $rental_model->addRate(
                                $last['id_roja45_product_rate'],
                                $last['value'],
                                $last['discount'],
                                $last['total'],
                                $last['tax'],
                                $date->format('Y-m-d H:i:s'),
                                $last['entry']
                            );
                            break;
                        case 3:
                            // TODO - Need to recalc tax
                            $rental_model->addRate(
                                $last['id_roja45_product_rate'],
                                $last['value'],
                                0,
                                $last['total'],
                                $last['tax'],
                                $date->format('Y-m-d H:i:s'),
                                $last['entry']
                            );
                            break;
                    }

                    $rental_model->overdue = 1;
                    $rental_model->end_date = $date->format('Y-m-d');
                    $rental_model->save();
                    // TODO -  add charge if necessary, add this as unpaid payment
                }
                $this->setStatus(ProductRentalRentalStatus::$OVER);
            }
        }
        return true;
    }

    public static function deleteCustomerData($email)
    {
        $return = true;
        $id_customer = Customer::customerExists($email, true);
        if ($id_customer && $rentals = ProductRentalRental::getRentalsForCustomer($id_customer)) {
            foreach ($rentals as $rental) {
                $rental = new ProductRentalRental($rental['id_roja45_product_rental']);
                $return &= $rental->delete();
            }
        }
        return $return;
    }

    public static function exportCustomerData($email)
    {
        $id_customer = Customer::customerExists($email, true);
        if ($id_customer && $rentals = ProductRentalRental::getRentalsForCustomer($id_customer)) {
            $sql = "
                SELECT * 
                FROM "._DB_PREFIX_."roja45_productrental_rental WHERE id_customer = '".(int) $id_customer."'";
            if ($results = Db::getInstance()->executeS($sql)) {
                $rentals = array();
                foreach ($results as $result) {
                    $rental = array();
                    $rental['email'] = $email;
                    $rental['reference'] = $result['reference'];
                    $rental['uid'] = $result['uid'];
                    $rental['date_add'] = $result['date_add'];
                    $rental['uid'] = $result['uid'];
                    $rentals[] = $rental;
                }
                return Tools::jsonEncode($rentals);
            }
        }
        return false;
    }

    public static function processRentals($parameters)
    {
        if (isset($parameters['reference'])) {
            $rentals = ProductRentalRental::getRentalByReference($parameters['reference']);
        } else {
            $rentals = ProductRentalRental::getAllOpenRentals();
        }

        $processed = true;
        foreach ($rentals as $rental) {
            try {
                $rental = new ProductRentalRental($rental['id_roja45_product_rental']);
                $processed &= $rental->postProcess();
            } catch (Exception $e) {
                Tools::error_log(__FUNCTION__ . ': ' . $e->getMessage());
            }
        }
        return $processed;
    }

    public static function preselectRate(
        $requested_qty,
        $id_product_attribute,
        $product_details,
        $id_roja45_product_rateduration
    ) {
        $models = array();
        $selected_qty = 0;
        foreach ($product_details['models'] as $model) {
            if ($model['id_product_attribute'] == $id_product_attribute) {
                if (count($model['rates']) && $model['availability']) {
                    $stock_on_hand = ProductRentalDetails::getStockOnHand(
                        $model['id_roja45_product'],
                        $model['id_roja45_product_model']
                    );
                    usort($model['rates'], array('RojaFortyFiveProductRentalCore','sortByRateValue'));
                    $model_details = array();
                    $model_details['id_roja45_product_rental_model'] = $model['id_roja45_product_model'];
                    $model_details['id_product_attribute'] = $model['id_product_attribute'];
                    $model_details['collection_date'] = $model['collection_date'];
                    $model_details['collection_time'] = $model['collection_time'] .':00';
                    $model_details['return_date'] = $model['return_date'];
                    $model_details['id_roja45_product_rateduration'] = $id_roja45_product_rateduration;
                    $model_details['return_time'] = $model['return_time'] .':00';

                    $rate_duration = new ProductRentalRateDuration(
                        $model['rates'][0]['id_roja45_product_rateduration']
                    );
                    $periods = $rate_duration->getPeriods(
                        $model['collection_date'] . ' ' . $model['collection_time'] .':00',
                        $model['return_date'] . ' ' . $model['return_time'] .':00',
                        Context::getContext()->language->date_format_lite . ' H:s:i'
                    );
                    $periods = ProductRentalPriceRule::processPriceRules(
                        $product_details['id_roja45_product'],
                        $periods
                    );

                    if (($stock_on_hand-($requested_qty-$selected_qty)) >= 0) {
                        $qty_selected = ($requested_qty-$selected_qty);
                    } else {
                        $qty_selected = $stock_on_hand;
                    }
                    $model['rates'][0]['qty'] = $qty_selected;
                    $model_details['rates'][] = (object)$model['rates'][0];
                    $model_details['rates'][0]->periods = (object) $periods;

                    if (isset($model['addons'])) {
                        $model_details['extras'] = array();
                        foreach ($model['addons'] as $extra) {
                            if ((int)$extra['default_selected']) {
                                $model_details['extras'][] = (object) $extra;
                            }
                        }
                    }

                    $models[] = (object) $model_details;
                    $selected_qty += $qty_selected;
                }
            }
            if ($selected_qty >= $requested_qty) {
                break;
            }
        }
        return $models;
    }

    public function statusBlocksCalendar()
    {
        $status = new ProductRentalRentalStatus($this->id_roja45_product_rental_status);
        return (bool) $status->block_calendar;
    }

    public function generateRentalConfirmationPDF($display = false, $show_taxes = true, $custom_title = 'Potwierdzenie rezerwacji')
    {
        $currency = Currency::getCurrencyInstance($this->id_currency);
        $defaultCurrency = Currency::getDefaultCurrency();
        $custom_object = (object) $this->getSummary();
        $customer = new Customer($this->id_customer);
        if (Validate::isLoadedObject($customer)) {
            $custom_object->customer = $customer;
        }

        $custom_object->filename = $this->reference.'.pdf';
        $custom_object->title = $this->reference;
        $custom_object->header = Module::getInstanceByName('roja45productrental')->l('Rental Confirmation');
        $custom_object->firstname = $customer->firstname;
        $custom_object->lastname = $customer->lastname;
        $custom_object->email = $customer->email;
        $custom_object->customer = $customer;
        $custom_object->notes = '';
        $custom_object->custom_title = $custom_title;
        $custom_object->default_tax_method = $show_taxes;
        $custom_object->use_taxes = $show_taxes;
        $custom_object->show_exchange_rate = ((float)$currency->conversion_rate == (float)1.0) ? 0 : 1;
        $custom_object->exchange_rate = (float) $currency->conversion_rate;
        $custom_object->default_currency = $defaultCurrency;
        $pdf = new PDF($custom_object, 'RentalConfirmationPdf', Context::getContext()->smarty);
        return $pdf->render($display);
    }

    public function generatePaymentInvoicePDF($payment, $display = false, $show_taxes = true)
    {
        $currency = Currency::getCurrencyInstance($this->id_currency);
        $defaultCurrency = Currency::getDefaultCurrency();
        $custom_object = (object) $this->getSummary();
        $customer = new Customer($this->id_customer);
        if (Validate::isLoadedObject($customer)) {
            $custom_object->customer = $customer;
        }

        $custom_object->filename = $this->reference.'.pdf';
        $custom_object->title = $this->reference;
        $custom_object->payment = $payment;
        $custom_object->header = Module::getInstanceByName('roja45productrental')->l('Rental Payment Invoice');
        $custom_object->firstname = $customer->firstname;
        $custom_object->lastname = $customer->lastname;
        $custom_object->email = $customer->email;
        $custom_object->customer = $customer;
        $custom_object->notes = '';
        $custom_object->default_tax_method = $show_taxes;
        $custom_object->use_taxes = $show_taxes;
        $custom_object->show_exchange_rate = ((float)$currency->conversion_rate == (float)1.0) ? 0 : 1;
        $custom_object->exchange_rate = (float) $currency->conversion_rate;
        $custom_object->default_currency = $defaultCurrency;
        $pdf = new PDF($custom_object, 'RentalPaymentInvoicePdf', Context::getContext()->smarty);
        return $pdf->render($display);
    }
}
