<?php
/**
 * PropertyReservationHistory
 *
 * @author    Roja45
 * @copyright 2016 Roja45
 * @license   license.txt
 * @category  PropertyReservationHistory
 *
 * 2016 ROJA45 - All rights reserved.
 *
 * DISCLAIMER
 * Changing this file will render any support provided by us null and void.
 */

/**
 * PropertyReservationHistory.
 *
 * @author    Roja45
 * @copyright 2016 Roja45
 * @license   license.txt
 * @category  Class
 *
 * 2016 ROJA45 - All rights reserved.
 *
 * DISCLAIMER
 * Changing this file will render any support provided by us null and void.
 */

class ProductRentalRentalHistory extends ObjectModel
{
    public $id_roja45_productrental_rentalhistory;
    public $id_roja45_productrental_rental;
    public $id_roja45_productrental_rentalstatus;
    public $id_roja45_productrental_rentalhistory_type;
    public $detail;
    public $date_add;
    public $date_upd;

    /* TODO - to become PropertyReservationHistory,
     * function historyContainsStatus to check whether a status has been passed.
     * record all changes; status change, rates, extras, etc
     * history status change entry (includes status)
     */

    /**
     * @see ObjectModel::$definition
     */
    public static $definition = array(
        'table' => 'roja45_propertymanager_reservationhistory',
        'primary' => 'id_roja45_productrental_rentalhistory',
        'multilang' => false,
        'fields' => array(
            'id_roja45_property_cart' => array(
                'type' => self::TYPE_INT,
                'validate' => 'isUnsignedId',
                'required' => true
            ),
            'id_roja45_productrental_rentalhistory_type' => array(
                'type' => self::TYPE_INT,
                'validate' => 'isUnsignedId',
                'required' => true
            ),
            'id_roja45_productrental_rentalstatus' => array(
                'type' => self::TYPE_INT,
                'validate' => 'isUnsignedId',
                'required' => false
            ),
            'date_add' => array('type' => self::TYPE_DATE, 'required' => true),
            'date_upd' => array('type' => self::TYPE_DATE, 'required' => true),
            'detail' => array('type' => self::TYPE_STRING, 'required' => false),
        ),
    );

    public function add($auto_date = true, $null_values = false)
    {
        return parent::add($auto_date, $null_values);
    }

    public static function containsStatus($id_roja45_productrental_rental, $id_roja45_productrental_rentalstatus)
    {
        $sql = new DbQuery();
        $sql->select('id_roja45_productrental_rentalstatus');
        $sql->from('roja45_propertymanager_reservationhistory', 'rh');
        $sql->where('r.`id_roja45_property_cart` = '.(int)$id_roja45_productrental_rental);
        $sql->where('r.`id_roja45_productrental_rentalstatus` = '.(int)$id_roja45_productrental_rentalstatus);
        return Db::getInstance()->getValue($sql);
    }

    public static function getReservationHistory($id_roja45_productrental_rental)
    {
        // select all history rows for reservaton is, ordererd
    }

    public static function getReservationStatusHistory($id_roja45_productrental_rental)
    {
        // select all history rows for reservaton id that have a status id
    }

    public static function addHistory(
        $id_roja45_productrental_rental,
        $id_roja45_productrental_rentalstatus,
        $id_roja45_productrental_rentalhistory_type,
        $detail
    ) {
        $reservation_history = new ProductRentalRentalHistory();
        $reservation_history->id_roja45_property_cart = $id_roja45_productrental_rental;
        $reservation_history->id_roja45_productrental_rentalhistory_type = $id_roja45_productrental_rentalhistory_type;
        $reservation_history->id_roja45_productrental_rentalstatus = $id_roja45_productrental_rentalstatus;
        $reservation_history->id_roja45_productrental_rentalhistory_type = $id_roja45_productrental_rentalhistory_type;
        $reservation_history->detail = $detail->toJSON();
        $reservation_history->save();
    }
}
