<?php
/**
 * ReservationMessage.
 *
 * @author    Roja45
 * @copyright 2016 Roja45
 * @license   license.txt
 * @category  ReservationMessage
 *
 * 2016 ROJA45 - All rights reserved.
 *
 * DISCLAIMER
 * Changing this file will render any support provided by us null and void.
 */

/**
 * ReservationMessage
 *
 * @author    Roja45
 * @copyright 2016 Roja45
 * @license   license.txt
 * @category  Class
 *
 * 2016 ROJA45 - All rights reserved.
 *
 * DISCLAIMER
 * Changing this file will render any support provided by us null and void.
 */

class ProductRentalRentalMessage extends ObjectModel
{
    public $id_roja45_product_rentalmessage;
    public $id_roja45_product_rental;
    public $id_customer_thread;

    /**
     * @see ObjectModel::$definition
     */
    public static $definition = array(
        'table' => 'roja45_productrental_rentalmessage',
        'primary' => 'id_roja45_product_rentalmessage',
        'multilang' => false,
        'fields' => array(
            'id_roja45_product_rental' => array('type' => self::TYPE_INT, 'validate' => 'isUnsignedId', 'required' => true),
            'id_customer_thread' => array('type' => self::TYPE_INT, 'validate' => 'isUnsignedId', 'required' => true),
        ),
    );

    public static function getList($id_roja45_product_rental)
    {
        $sql = new DbQuery();
        $sql->select('*');
        $sql->from('roja45_productrental_rentalmessage', 'rm');
        $sql->where('rm.id_roja45_product_rental='.(int)$id_roja45_product_rental);
        return Db::getInstance()->executeS($sql);
    }

    public static function deleteReservationMessages($id_roja45_product_rental)
    {
        $sql = '
            DELETE FROM `'._DB_PREFIX_.'roja45_productrental_rentalmessage`
            WHERE `id_roja45_product_rental` = '.(int) $id_roja45_product_rental;
        return Db::getInstance()->execute($sql);
    }

    public static function getReservationForThread($id_customer_thread)
    {
        $sql = new DbQuery();
        $sql->select('id_roja45_product_rental');
        $sql->from('roja45_productrental_rentalmessage', 'rm');
        $sql->where('rm.id_customer_thread='.(int)$id_customer_thread);
        return Db::getInstance()->getValue($sql);
    }
}
