<?php
/**
 * ProductRentalRentalModel
 *
 * @author    Roja45
 * @copyright 2016 Roja45
 * @license   license.txt
 * @category  ProductRentalRentalModel
 *
 * 2016 ROJA45 - All rights reserved.
 *
 * DISCLAIMER
 * Changing this file will render any support provided by us null and void.
 */

/**
 * ProductRentalRentalModel
 *
 * @author    Roja45
 * @copyright 2016 Roja45
 * @license   license.txt
 * @category  Class
 *
 * 2016 ROJA45 - All rights reserved.
 *
 * DISCLAIMER
 * Changing this file will render any support provided by us null and void.
 */
class ProductRentalRentalModel extends ObjectModel
{
    public $id_roja45_product_rental_model;
    public $id_roja45_product_rental_product;
    public $id_roja45_product_model;
    public $id_roja45_product_rateduration;
    public $id_product_attribute;
    public $start_date;
    public $collection_time;
    public $end_date;
    public $return_time;
    public $periods;
    public $qty;
    public $total;
    public $total_wt;
    public $damage_deposit;
    public $damage_deposit_inc;
    public $return_due;
    public $overdue;
    public $out_for_rent;
    public $returned;
    public $date_rtn;
    public $date_add;
    public $date_upd;

    /**
     * @see ObjectModel::$definition
     */
    public static $definition = array(
        'table' => 'roja45_productrental_rentalmodel',
        'primary' => 'id_roja45_product_rental_model',
        'multilang' => false,
        'fields' => array(
            'id_roja45_product_rental_product' => array('type' => self::TYPE_INT),
            'id_roja45_product_model' => array('type' => self::TYPE_INT),
            'id_roja45_product_rateduration' => array('type' => self::TYPE_INT),
            'id_product_attribute' => array('type' => self::TYPE_INT),
            'start_date' => array('type' => self::TYPE_DATE),
            'collection_time' => array('type' => self::TYPE_DATE),
            'end_date' => array('type' => self::TYPE_DATE),
            'return_time' => array('type' => self::TYPE_DATE),
            'periods' => array('type' => self::TYPE_INT),
            'qty' => array('type' => self::TYPE_INT),
            'total' => array('type' => self::TYPE_FLOAT),
            'total_wt' => array('type' => self::TYPE_FLOAT),
            'damage_deposit' => array('type' => self::TYPE_FLOAT),
            'damage_deposit_inc' => array('type' => self::TYPE_FLOAT),
            'return_due' => array('type' => self::TYPE_BOOL),
            'overdue' => array('type' => self::TYPE_BOOL),
            'out_for_rent' => array('type' => self::TYPE_BOOL),
            'returned' => array('type' => self::TYPE_BOOL),
            'date_rtn' => array('type' => self::TYPE_DATE),
            'date_add' => array('type' => self::TYPE_DATE),
            'date_upd' => array('type' => self::TYPE_DATE),
        ),
    );

    public function __construct($id = null, $id_lang = null)
    {
        parent::__construct($id, $id_lang);
    }

    public function delete()
    {
        ProductRentalDateRate::deleteAll($this->id_roja45_product_rental_model);
        ProductRentalRentalModelRate::deleteAll($this->id_roja45_product_rental_model);
        ProductRentalRentalModelExtra::deleteAll($this->id_roja45_product_rental_model);
        return parent::delete();
    }

    public function addRate($id_roja45_product_rate, $value, $discount, $total, $tax, $period, $model_number)
    {
        $return = true;
        $object = new ProductRentalRentalModelRate();
        $object->id_roja45_product_rental_model = $this->id;
        $object->id_roja45_product_rate = (int)$id_roja45_product_rate;
        $object->entry = $model_number;
        //$object->day = $day;
        $object->period = $period;
        $object->value = $value;
        $object->discount = $discount;
        $object->total = $total;
        $object->tax = $tax;
        if (!$return &= $object->save()) {
            throw new Exception(Db::getInstance(_PS_USE_SQL_SLAVE_)->getMsgError());
        }
        return $return;
    }

    public function addExtra(
        $id_roja45_product_extra,
        $rate,
        $tax,
        $qty,
        $total
    ) {
        $return = true;
        $object = new ProductRentalRentalModelExtra();
        $object->id_roja45_product_rental_model = $this->id;
        $object->id_roja45_product_extra = $id_roja45_product_extra;
        $object->rate = $rate;
        $object->tax = $tax;
        $object->qty = $qty;
        $object->total = $total;
        if (!$return &= $object->save()) {
            throw new Exception(Db::getInstance(_PS_USE_SQL_SLAVE_)->getMsgError());
        }
        return $return;
    }

    public function hasExtra($id_roja45_product_extra)
    {
        $sql = new DbQuery();
        $sql->select(
            're.id_roja45_product_rental_extra'
        );
        $sql->from('roja45_productrental_rentalextra', 're');
        $sql->where('re.id_roja45_product_rental_model='.(int) $this->id_roja45_product_rental_model);
        $sql->where('re.id_roja45_product_extra='.(int) $id_roja45_product_extra);
        return Db::getInstance()->getValue($sql);
    }

    public function deleteRate($id_roja45_product_rate)
    {
        return ProductRentalRentalModelRate::deleteRate((int)$this->id, $id_roja45_product_rate);
    }

    public function deleteRates()
    {
        return ProductRentalRentalModelRate::deleteAll((int)$this->id);
    }

    public function deleteExtras()
    {
        return ProductRentalRentalModelExtra::deleteAll((int)$this->id);
    }

    public function deleteExtra($id_roja45_product_extra)
    {
        $sql = new DbQuery();
        $sql->select(
            're.id_roja45_product_rental_extra'
        );
        $sql->from('roja45_productrental_rentalextra', 're');
        $sql->where('re.id_roja45_product_extra='.(int) $id_roja45_product_extra);
        if ($id_roja45_product_rental_extra = Db::getInstance()->getValue($sql)) {
            $rental_extra = new ProductRentalRentalModelExtra($id_roja45_product_rental_extra);
            return $rental_extra->delete();
        } else {
            return false;
        }
    }

    public static function deleteAll($id_roja45_product_rental_product)
    {
        $return = true;
        $sql = new DbQuery();
        $sql->select(
            'rm.id_roja45_product_rental_model'
        );
        $sql->from('roja45_productrental_rentalmodel', 'rm');
        $sql->where('rm.id_roja45_product_rental_product='.(int) $id_roja45_product_rental_product);
        $results = Db::getInstance()->executeS($sql);
        foreach ($results as $row) {
            $rental_model = new ProductRentalRentalModel($row['id_roja45_product_rental_model']);
            $return &= $rental_model->delete();
        }
    }

    public function getRentalDates()
    {
        $sql = '
          SELECT MIN(start_date) as start_date, MAX(end_date) as end_date
          FROM ' . _DB_PREFIX_ . 'roja45_productrental_rentalmodel
          WHERE id_roja45_product_rental_model = ' . (int)$this->id;
        $dates = Db::getInstance()->getRow($sql);
        return $dates;
    }

    public function getRates()
    {
        $sql = '
            SELECT *
            FROM `' . _DB_PREFIX_ . 'roja45_productrental_rentalrate` rr
            WHERE rr.id_roja45_product_rental_model=' . (int) $this->id .'
            ORDER BY rr.period ASC';
        return Db::getInstance()->executeS($sql);
    }

    public function getExtras()
    {
        $sql = '
            SELECT *
            FROM `' . _DB_PREFIX_ . 'roja45_productrental_rentalextra` re
            WHERE re.id_roja45_product_rental_model=' . (int)$this->id;
        return Db::getInstance()->executeS($sql);
    }

    public static function getModel($id_roja45_product_rental_product, $id_roja45_product_rental_model)
    {
        $sql = '
          SELECT * FROM `' . _DB_PREFIX_ . 'roja45_productrental_rentalmodel`
          WHERE `id_roja45_product_rental_product` = ' . (int)$id_roja45_product_rental_product . '
          AND `id_roja45_product_rental_model` = ' . (int)$id_roja45_product_rental_model;
        return Db::getInstance()->executeS($sql);
    }

    public static function getModels($id_roja45_product_rental_product)
    {
        $sql = '
          SELECT * FROM `' . _DB_PREFIX_ . 'roja45_productrental_rentalmodel`
          WHERE `id_roja45_product_rental_product` = ' . (int)$id_roja45_product_rental_product;
        return Db::getInstance()->executeS($sql);
    }

    public function toJSON($id_lang, $encode)
    {
        $collection_time = $this->collection_time;
        $return_time = $this->return_time;
        if (empty($collection_time)) {
            $collection_time = Configuration::get('ROJA45_PRODUCTRENTAL_COLLECTIONTIME').':00';
        }
        if (empty($return_time)) {
            $return_time = Configuration::get('ROJA45_PRODUCTRENTAL_RETURNTIME').':00';
        }
        $collection_date_obj = DateTime::createFromFormat(
            'Y-m-d H:i:s',
            $this->start_date . ' ' . $collection_time
        );
        $return_date_obj = DateTime::createFromFormat(
            'Y-m-d H:i:s',
            $this->end_date . ' ' . $return_time
        );

        $object = array(
            'id_roja45_product_rental_model' => $this->id_roja45_product_rental_model,
            'id_roja45_product_model' => $this->id_roja45_product_model,
            'id_roja45_product_rateduration' => $this->id_roja45_product_rateduration,
            'id_product_attribute' => $this->id_product_attribute,
            'collection_date' => $collection_date_obj->format(Context::getContext()->language->date_format_lite),
            'collection_time' => $collection_date_obj->format('H:i:s'),
            'return_date' => $return_date_obj->format(Context::getContext()->language->date_format_lite),
            'return_time' => $return_date_obj->format('H:i:s'),
            'number_of_models' => $this->qty,
            'rates' => array(),
            'extras' => array()
        );

        $sql = '
            SELECT DISTINCT id_roja45_product_rate
            FROM `' . _DB_PREFIX_ . 'roja45_productrental_rentalrate` rr
            WHERE rr.id_roja45_product_rental_model=' . (int)$this->id;
        $rates = array();
        foreach (Db::getInstance()->executeS($sql) as $rate_id) {
            $rate = array();
            $rate['id'] = $rate_id['id_roja45_product_rate'];
            $rate['id_roja45_product_rate'] = $rate_id['id_roja45_product_rate'];
            $sql = '
                SELECT *
                FROM `' . _DB_PREFIX_ . 'roja45_productrental_rentalrate` rr
                WHERE rr.id_roja45_product_rental_model=' . (int)$this->id . '
                AND rr.id_roja45_product_rate = '.$rate_id['id_roja45_product_rate'] .'
                ORDER BY rr.period';
            $periods = array();
            foreach ($periods = Db::getInstance()->executeS($sql) as $period) {
                $period['id_roja45_product_rate'] = $rate_id['id_roja45_product_rate'];
                //$day['day'] = $current_day['day'];
                $period['rate'] = $period['value'];
                //$day['tax'] = $current_day['tax'];
                $period['qty'] = $period['entry'];
                $rate['qty'] = $period['entry'];
            }

            $rate['periods'] = $periods;
            $rates[] = $rate;
        }

        $object['rates'] = $rates;

        foreach ($this->getExtras() as $extra) {
            $rental_product_model_extra = new ProductRentalRentalModelExtra($extra['id_roja45_product_rental_extra'], $id_lang);
            $extra = $rental_product_model_extra->toJSON($id_lang, false);
            $extra->id_roja45_product_model = $this->id_roja45_product_model;
            $object['extras'][] = $extra;
        }

        if ($encode) {
            return Tools::jsonEncode((object) $object);
        } else {
            return (object) $object;
        }
    }
}
