<?php
/**
 * ProductRentalRentalModelExtra
 *
 * @author    Roja45
 * @copyright 2016 Roja45
 * @license   license.txt
 * @category  ProductRentalRentalModelExtra
 *
 * 2016 ROJA45 - All rights reserved.
 *
 * DISCLAIMER
 * Changing this file will render any support provided by us null and void.
 */

/**
 * ProductRentalRentalModelExtra
 *
 * @author    Roja45
 * @copyright 2016 Roja45
 * @license   license.txt
 * @category  Class
 *
 * 2016 ROJA45 - All rights reserved.
 *
 * DISCLAIMER
 * Changing this file will render any support provided by us null and void.
 */

class ProductRentalRentalModelExtra extends ObjectModel
{
    public $id_roja45_product_rental_extra;
    public $id_roja45_product_rental_model;
    public $id_roja45_product_extra;
    public $rate;
    public $tax;
    public $qty;
    public $total_deposit;
    public $total;
    public $discount;
    public $date_add;
    public $date_upd;

    /**
     * @see ObjectModel::$definition
     */
    public static $definition = array(
        'table' => 'roja45_productrental_rentalextra',
        'primary' => 'id_roja45_product_rental_extra',
        'multilang' => false,
        'fields' => array(
            'id_roja45_product_rental_model' => array('type' => self::TYPE_INT),
            'id_roja45_product_extra' => array('type' => self::TYPE_DATE),
            'rate' => array('type' => self::TYPE_FLOAT),
            'tax' => array('type' => self::TYPE_FLOAT),
            'qty' => array('type' => self::TYPE_INT),
            'total_deposit' => array('type' => self::TYPE_FLOAT),
            'total' => array('type' => self::TYPE_FLOAT),
            'discount' => array('type' => self::TYPE_FLOAT),
            'date_add' => array('type' => self::TYPE_DATE),
            'date_upd' => array('type' => self::TYPE_DATE),
        ),
    );

    public function __construct($id = null, $id_lang = null)
    {
        parent::__construct($id, $id_lang);
    }

    public static function deleteAll($id_roja45_product_rental_model)
    {
        $sql = '
          DELETE FROM `' . _DB_PREFIX_ . 'roja45_productrental_rentalextra`
          WHERE `id_roja45_product_rental_model` = ' . (int)$id_roja45_product_rental_model;
        return (bool)Db::getInstance()->execute($sql);
    }

    public function toJSON($id_lang, $encode)
    {
        $object = array(
            'id_roja45_product_rental_extra' => $this->id_roja45_product_rental_extra,
            'id_roja45_product_rental_model' => $this->id_roja45_product_rental_model,
            'id_roja45_product_extra' => $this->id_roja45_product_extra,
            'value' => $this->total,
        );
        if ($encode) {
            return Tools::jsonEncode((object) $object);
        } else {
            return (object) $object;
        }
    }
}
