<?php
/**
 * ProductRentalRentalModelRate
 *
 * @author    Roja45
 * @copyright 2016 Roja45
 * @license   license.txt
 * @category  ProductRentalRentalModelRate
 *
 * 2016 ROJA45 - All rights reserved.
 *
 * DISCLAIMER
 * Changing this file will render any support provided by us null and void.
 */

/**
 * ProductRentalRentalModelRate
 *
 * @author    Roja45
 * @copyright 2016 Roja45
 * @license   license.txt
 * @category  Class
 *
 * 2016 ROJA45 - All rights reserved.
 *
 * DISCLAIMER
 * Changing this file will render any support provided by us null and void.
 */
class ProductRentalRentalModelRate extends ObjectModel
{
    public $id_roja45_product_rental_rate;
    public $id_roja45_product_rental_model;
    public $id_roja45_product_rate;
    public $period;
    public $entry;
    public $value;
    public $discount;
    public $total;
    public $tax;
    public $date_add;
    public $date_upd;

    /**
     * @see ObjectModel::$definition
     */
    public static $definition = array(
        'table' => 'roja45_productrental_rentalrate',
        'primary' => 'id_roja45_product_rental_rate',
        'multilang' => false,
        'fields' => array(
            'id_roja45_product_rental_model' => array('type' => self::TYPE_INT),
            'id_roja45_product_rate' => array('type' => self::TYPE_INT),
            'period' => array('type' => self::TYPE_DATE),
            'entry' => array('type' => self::TYPE_INT),
            'value' => array('type' => self::TYPE_FLOAT),
            'discount' => array('type' => self::TYPE_FLOAT),
            'total' => array('type' => self::TYPE_FLOAT),
            'tax' => array('type' => self::TYPE_FLOAT),
            'date_add' => array('type' => self::TYPE_DATE),
            'date_upd' => array('type' => self::TYPE_DATE),
        ),
    );

    public function __construct($id = null, $id_lang = null)
    {
        parent::__construct($id, $id_lang);
    }

    public static function deleteAll($id_roja45_product_rental_model)
    {
        $sql = '
          DELETE FROM `' . _DB_PREFIX_ . 'roja45_productrental_rentalrate`
          WHERE `id_roja45_product_rental_model` = ' . (int)$id_roja45_product_rental_model;
        return (bool)Db::getInstance()->execute($sql);
    }

    public static function deleteRate($id_roja45_product_rental_model, $id_roja45_product_rate)
    {
        $sql = '
          DELETE FROM `' . _DB_PREFIX_ . 'roja45_productrental_rentalrate`
          WHERE =`id_roja45_product_rental_model` = ' . (int)$id_roja45_product_rental_model . '
          AND `id_rate` = ' . (int)$id_roja45_product_rate;
        return (bool)Db::getInstance()->execute($sql);
    }

    public function toJSON($id_lang, $encode)
    {
        $object = array(
            'id_roja45_product_rental_rate' => $this->id_roja45_product_rental_rate,
            'id_roja45_product_rate' => $this->id_roja45_product_rate,
            'entry' => $this->entry,
            'value' => $this->value,
            'day' => $this->day,
            'date_add' => $this->date_add,
            'date_upd' => $this->date_upd,
        );
        if ($encode) {
            return Tools::jsonEncode((object) $object);
        } else {
            return (object) $object;
        }
    }
}
