<?php
/**
 * ProductRentalRentalPayment
 *
 * @author    Roja45
 * @copyright 2016 Roja45
 * @license   license.txt
 * @category  ProductRentalRentalPayment
 *
 * 2016 ROJA45 - All rights reserved.
 *
 * DISCLAIMER
 * Changing this file will render any support provided by us null and void.
 */

/**
 * ProductRentalRentalPayment
 *
 * @author    Roja45
 * @copyright 2016 Roja45
 * @license   license.txt
 * @category  Class
 *
 * 2016 ROJA45 - All rights reserved.
 *
 * DISCLAIMER
 * Changing this file will render any support provided by us null and void.
 */
class ProductRentalRentalPayment extends ObjectModel
{
    public $id_roja45_product_rental_payment;
    public $id_roja45_product_rental;
    public $id_cart;
    public $id_order;
    public $id_currency;
    public $id_roja45_product_payment_type;
    public $position;
    public $payment_due;
    public $payment_late;
    public $reminders_sent;
    public $completed;
    public $requested;
    public $total;
    public $note;
    public $total_with_tax;
    public $deleted;
    public $date_paid;
    public $date_due;
    public $date_requested;
    public $date_completed;
    public $date_add;
    public $date_upd;
    public $date_del;

    /**
     * @see ObjectModel::$definition
     */
    public static $definition = array(
        'table' => 'roja45_productrental_rentalpayment',
        'primary' => 'id_roja45_product_rental_payment',
        'multilang' => false,
        'fields' => array(
            'id_roja45_product_rental' => array('type' => self::TYPE_INT),
            'id_cart' => array('type' => self::TYPE_INT),
            'id_order' => array('type' => self::TYPE_INT),
            'id_currency' => array('type' => self::TYPE_INT),
            'id_roja45_product_payment_type' => array('type' => self::TYPE_INT),
            'position' => array('type' => self::TYPE_INT),
            'payment_due' => array('type' => self::TYPE_BOOL),
            'payment_late' => array('type' => self::TYPE_BOOL),
            'reminders_sent' => array('type' => self::TYPE_INT),
            'completed' => array('type' => self::TYPE_BOOL),
            'requested' => array('type' => self::TYPE_BOOL),
            'deleted' => array('type' => self::TYPE_BOOL),
            'total' => array('type' => self::TYPE_FLOAT),
            'note' => array('type' => self::TYPE_STRING),
            'total_with_tax' => array('type' => self::TYPE_FLOAT),
            'date_paid' => array('type' => self::TYPE_DATE),
            'date_due' => array('type' => self::TYPE_DATE),
            'date_completed' => array('type' => self::TYPE_DATE),
            'date_requested' => array('type' => self::TYPE_DATE),
            'date_add' => array('type' => self::TYPE_DATE),
            'date_upd' => array('type' => self::TYPE_DATE),
            'date_del' => array('type' => self::TYPE_DATE),
        ),
    );

    public function __construct($id = null, $id_lang = null)
    {
        parent::__construct($id, $id_lang);
    }

    public static function exists($id_cart)
    {
        $sql = '
            SELECT id_roja45_product_rental_payment
            FROM `' . _DB_PREFIX_ . 'roja45_productrental_rentalpayment` r
            WHERE r.id_cart = '. $id_cart;
        if (Db::getInstance(_PS_USE_SQL_SLAVE_)->getValue($sql)>0) {
            return new self(Db::getInstance(_PS_USE_SQL_SLAVE_)->getValue($sql));
        } else {
            return new self();
        }
    }

    public function delete()
    {
        $sql = '
            DELETE
            FROM `' . _DB_PREFIX_ . 'roja45_productrental_rentalpayment_item`
            WHERE `id_roja45_product_rental_payment` = ' . (int)$this->id_roja45_product_rental_payment;
        Db::getInstance()->execute($sql);
        return parent::delete();
    }

    public static function deleteAll($id_roja45_product_rental)
    {
        $sql = '
            SELECT id_roja45_product_rental_payment 
            FROM `' . _DB_PREFIX_ . 'roja45_productrental_rentalpayment`
            WHERE `id_roja45_product_rental` = ' . (int)$id_roja45_product_rental;
        foreach (Db::getInstance()->executeS($sql) as $row) {
            $sql = '
                DELETE
                FROM `' . _DB_PREFIX_ . 'roja45_productrental_rentalpayment_item`
                WHERE `id_roja45_product_rental_payment` = ' . (int) $row['id_roja45_product_rental_payment'];
            Db::getInstance()->execute($sql);
        }

        $sql = '
            DELETE
            FROM `' . _DB_PREFIX_ . 'roja45_productrental_rentalpayment`
            WHERE `id_roja45_product_rental` = ' . (int)$id_roja45_product_rental;
        return (bool) Db::getInstance()->execute($sql);
    }

    public static function getNextPayment($id_roja45_product_rental)
    {
        $sql = '
            SELECT id_roja45_product_rental_payment FROM `' . _DB_PREFIX_ . 'roja45_productrental_rentalpayment`
            WHERE `id_roja45_product_rental` = ' . (int)$id_roja45_product_rental . '
            AND completed=0
            AND id_order=0
            ORDER BY position ASC';
        $id_roja45_product_rental_payment = Db::getInstance()->getValue($sql);
        if ($id_roja45_product_rental_payment) {
            return new ProductRentalRentalPayment($id_roja45_product_rental_payment);
        } else {
            return new ProductRentalRentalPayment();
        }
    }

    public static function getDuePayment($id_roja45_product_rental)
    {
        $sql = '
            SELECT id_roja45_product_rental_payment FROM `' . _DB_PREFIX_ . 'roja45_productrental_rentalpayment`
            WHERE `id_roja45_product_rental` = ' . (int)$id_roja45_product_rental . '
            AND payment_due=1
            ORDER BY position ASC';
        $id_roja45_product_rental_payment = Db::getInstance()->getValue($sql);
        if ($id_roja45_product_rental_payment) {
            return new ProductRentalRentalPayment($id_roja45_product_rental_payment);
        } else {
            return false;
        }
    }

    public static function getRequestedPayment($id_roja45_product_rental)
    {
        $sql = new DbQuery();
        $sql->select('id_roja45_product_rental_payment');
        $sql->from('roja45_productrental_rentalpayment', 'rp');
        $sql->where('rp.`id_roja45_product_rental` = ' . (int)$id_roja45_product_rental);
        $sql->where('rp.`payment_due` = 1');
        $sql->where('rp.`requested` = 1');
        $sql->where('rp.`date_paid` = "0000-00-00 00:00:00"');
        $sql->orderBy('id_roja45_product_rental_payment');
        $id_roja45_product_rental_payment = Db::getInstance()->getValue($sql);
        if ($id_roja45_product_rental_payment) {
            return new ProductRentalRentalPayment($id_roja45_product_rental_payment);
        } else {
            return false;
        }
    }

    public static function getRequestedPayments($id_roja45_product_rental)
    {
        $sql = new DbQuery();
        $sql->select('id_roja45_product_rental_payment');
        $sql->from('roja45_productrental_rentalpayment', 'rp');
        $sql->where('rp.`id_roja45_product_rental` = ' . (int)$id_roja45_product_rental);
        $sql->where('rp.`payment_due` = 1');
        $sql->where('rp.`requested` = 1');
        $sql->where('rp.`date_paid` = "0000-00-00 00:00:00"');
        $sql->orderBy('id_roja45_product_rental_payment');
        return Db::getInstance()->executeS($sql);
    }

    public static function getPaymentForOrderId($id_order)
    {
        $sql = '
            SELECT rp.id_roja45_product_rental_payment
            FROM `' . _DB_PREFIX_ . 'roja45_productrental_rentalpayment` rp
            WHERE rp.`id_order` = ' . (int)$id_order;
        return Db::getInstance()->getValue($sql);
    }

    public static function getList($id_roja45_product_rental)
    {
        $sql = '
            SELECT * FROM `' . _DB_PREFIX_ . 'roja45_productrental_rentalpayment`
            WHERE `id_roja45_product_rental` = ' . (int)$id_roja45_product_rental;
        return Db::getInstance()->executeS($sql);
    }

    public static function getTotalPaid($id_roja45_product_rental, $with_tax)
    {
        $total_paid = 0;
        $total_paid_with_tax = 0;

        $sql = new DbQuery();
        $sql->select('total, total_with_tax');
        $sql->from('roja45_productrental_rentalpayment', 'rp');
        $sql->leftJoin('roja45_productrental_paymenttype', 'pt', 'rp.id_roja45_product_payment_type = pt.id_roja45_product_payment_type');
        $sql->where('rp.id_roja45_product_rental = ' . (int) $id_roja45_product_rental);
        $sql->where('rp.requested = 1');
        $sql->where('rp.date_paid != "0000-00-00 00:00:00"');
        $sql->where('pt.include = 1');
        $results = Db::getInstance()->executeS($sql);
        foreach ($results as $result) {
            $total_paid += (float)$result['total'];
            $total_paid_with_tax += (float)$result['total_with_tax'];
        }
        if ($with_tax) {
            return Tools::math_round($total_paid_with_tax, 2);
        } else {
            return Tools::math_round($total_paid, 2);
        }
    }

    public static function getTotalConfirmedPaid($id_roja45_product_rental, $with_tax)
    {
        $total_paid = 0;
        $total_paid_with_tax = 0;
        $sql = new DbQuery();
        $sql->select('total, total_with_tax');
        $sql->from('roja45_productrental_rentalpayment', 'rp');
        $sql->leftJoin('roja45_productrental_paymenttype', 'pt', 'rp.id_roja45_product_payment_type = pt.id_roja45_product_payment_type');
        $sql->where('rp.id_roja45_product_rental = ' . (int) $id_roja45_product_rental);
        $sql->where('rp.completed = 1');
        $sql->where('pt.include = 1');
        $total_paid = 0;
        if ($results = Db::getInstance()->executeS($sql)) {
            foreach ($results as $result) {
                $total_paid += (float)$result['total'];
                $total_paid_with_tax += (float)$result['total_with_tax'];
            }
        }
        if ($with_tax) {
            return $total_paid_with_tax;
        } else {
            return $total_paid;
        }
    }

    public static function getPayments($id_roja45_product_rental)
    {
        $payments = ProductRentalRentalPayment::getList($id_roja45_product_rental);
        foreach ($payments as &$payment) {
            $order = new Order($payment['id_order']);
            if ($payment['date_paid'] == '0000-00-00 00:00:00') {
                $payment['date_paid'] = '';
            }
            //$payment['total_inc'] = $this->addTax($payment['total']);
            $payment['total_paid'] = $order->total_paid;
            $payment['total_paid_real'] = $order->total_paid_real;
        }
        return $payments;
    }

    public static function getLastPayment($id_roja45_product_rental)
    {
        $sql = '
            SELECT rp.id_roja45_product_rental_payment
            FROM `' . _DB_PREFIX_ . 'roja45_productrental_rentalpayment` rp
            WHERE rp.`id_roja45_product_rental` = ' . (int)$id_roja45_product_rental .'
            ORDER BY rp.`date_paid`';
        if ($id_roja45_product_rental_payment = Db::getInstance()->getValue($sql)) {
            return new self($id_roja45_product_rental_payment);
        } else {
            return false;
        }
    }

    public static function cleanPayments($id_cart)
    {
        $sql = '
            UPDATE `' . _DB_PREFIX_ . 'roja45_productrental_rentalpayment`
            SET id_cart = 0
            WHERE `id_cart` = ' . (int)$id_cart;
        return (bool)Db::getInstance()->execute($sql);
    }

    public function getPaymentItem(
        $id_product,
        $id_product_attribute
    ) {
        $sql = '
            SELECT rpi.id_roja45_product_rental_payment_item
            FROM `' . _DB_PREFIX_ . 'roja45_productrental_rentalpayment_item` rpi
            WHERE rpi.`id_roja45_product_rental_payment` = ' . (int) $this->id_roja45_product_rental_payment .'
            AND rpi.id_product = ' . $id_product .'
            AND rpi.id_product_attribute = ' . $id_product_attribute;
        if ($id_roja45_product_rental_payment_item = Db::getInstance()->getValue($sql)) {
            return new ProductRentalRentalPaymentItem($id_roja45_product_rental_payment_item);
        } else {
            return false;
        }
    }
}
