<?php
/**
 * ProductRentalRentalProcess.
 *
 * @author    Roja45
 * @copyright 2016 Roja45
 * @license   license.txt
 * @category  ProductRentalRentalProcess
 *
 *
 * 2016 ROJA45 - All rights reserved.
 *
 * DISCLAIMER
 * Changing this file will render any support provided by us null and void.
 */

/**
 * ProductRentalRentalProcess.
 *
 * @author    Roja45
 * @copyright 2016 Roja45
 * @license   license.txt
 * @category  Class
 *
 *
 * 2016 ROJA45 - All rights reserved.
 *
 * DISCLAIMER
 * Changing this file will render any support provided by us null and void.
 */

class ProductRentalRentalProcess extends ObjectModel
{
    /** @var string Name */
    public $id_roja45_product_rental_process;
    public $id_roja45_product_rental;
    public $id_roja45_product_rental_status;
    public $position;

    /**
     * @see ObjectModel::$definition
     */
    public static $definition = array(
        'table' => 'roja45_productrental_rentalprocess',
        'primary' => 'id_roja45_product_rental_process',
        'multilang' => false,
        'fields' => array(
            'id_roja45_product_rental' => array(
                'type' => self::TYPE_INT,
                'validate' => 'isUnsignedId',
                'required' => true
            ),
            'id_roja45_product_rental_status' => array(
                'type' => self::TYPE_INT,
                'validate' => 'isUnsignedId',
                'required' => true
            ),
            'position' => array('type' => self::TYPE_INT, 'validate' => 'isUnsignedId'),
        ),
    );

    public function add($auto_date = true, $null_values = false)
    {
        $pos = (int) Db::getInstance(_PS_USE_SQL_SLAVE_)->getValue(
            'SELECT position
            FROM `'._DB_PREFIX_.'roja45_productrental_rentalprocess` p
            WHERE id_roja45_product_rental = ' . (int)$this->id_roja45_product_rental . '
            ORDER BY p.`position` ASC'
        );
        $this->position = ++$pos;

        return parent::add($auto_date, $null_values);
    }

    /**
     * Get current reservation position in the flow.
     *
     * @param int $id_lang Language id for status name
     *
     * @return array Order statuses
     */
    public static function getRentalProcess($id_roja45_product_rental, $id_lang)
    {
        $result = Db::getInstance(_PS_USE_SQL_SLAVE_)->executeS(
            'SELECT id_roja45_product_rental_status
            FROM `'._DB_PREFIX_.'roja45_productrental_rentalprocess` p
            WHERE id_roja45_product_rental = ' . (int)$id_roja45_product_rental . '
            ORDER BY p.`position` ASC'
        );

        $array = array();
        foreach ($result as $status) {
            $status = new ProductRentalRentalStatus($status['id_roja45_product_rental_status'], $id_lang);
            $array[] = $status;
        }
        return $array;
    }

    public static function getRentalCurrentProcess($id_roja45_product_rental, $id_lang)
    {
        $result = Db::getInstance(_PS_USE_SQL_SLAVE_)->getVAlue(
            'SELECT id_roja45_product_rental_status
            FROM `'._DB_PREFIX_.'roja45_productrental_rentalprocess` p
            WHERE id_roja45_product_rental = ' . (int)$id_roja45_product_rental . '
            ORDER BY p.`position` DESC
            LIMIT 1'
        );
        $status = new ProductRentalRentalProcess($result, $id_lang);
        return $status;
    }

    public static function addStatus($id_roja45_product_rental, $status)
    {
        $id_roja45_product_rental_status = ProductRentalRentalStatus::getStatusByType($status);
        if (!ProductRentalRentalProcess::exists($id_roja45_product_rental, $status)) {
            $reservation_process = new ProductRentalRentalProcess();
            $reservation_process->id_roja45_product_rental = (int)$id_roja45_product_rental;
            $reservation_process->id_roja45_product_rental_status = (int)$id_roja45_product_rental_status;
            $reservation_process->add();
        }
    }

    public static function exists($id_roja45_product_rental, $status)
    {
        $id_roja45_product_rental_status = ProductRentalRentalStatus::getStatusByType($status);
        $id_roja45_product_rental_process = Db::getInstance(_PS_USE_SQL_SLAVE_)->getValue(
            'SELECT id_roja45_product_rental_process
            FROM `'._DB_PREFIX_.'roja45_productrental_rentalprocess` p
            WHERE id_roja45_product_rental = ' . (int)$id_roja45_product_rental . '
            AND id_roja45_product_rental_status = ' . (int)$id_roja45_product_rental_status
        );
        return ($id_roja45_product_rental_process>0);
    }

    public static function deleteAll($id_roja45_product_rental)
    {
        $sql = '
          DELETE FROM `' . _DB_PREFIX_ . 'roja45_productrental_rentalprocess`
          WHERE `id_roja45_product_rental` = ' . (int)$id_roja45_product_rental;
        return (bool)Db::getInstance()->execute($sql);
    }
}
