<?php
/**
 * ProductRentalRentalModel
 *
 * @author    Roja45
 * @copyright 2016 Roja45
 * @license   license.txt
 * @category  ProductRentalRentalModel
 *
 * 2016 ROJA45 - All rights reserved.
 *
 * DISCLAIMER
 * Changing this file will render any support provided by us null and void.
 */

/**
 * ProductRentalRentalModel
 *
 * @author    Roja45
 * @copyright 2016 Roja45
 * @license   license.txt
 * @category  Class
 *
 * 2016 ROJA45 - All rights reserved.
 *
 * DISCLAIMER
 * Changing this file will render any support provided by us null and void.
 */
class ProductRentalRentalProduct extends ObjectModel
{
    public $id_roja45_product_rental_product;
    public $id_roja45_product_rental;
    public $id_roja45_product;
    public $id_product;
    public $id_paymentprofile;
    public $vouchers;

    /**
     * @see ObjectModel::$definition
     */
    public static $definition = array(
        'table' => 'roja45_productrental_rentalproduct',
        'primary' => 'id_roja45_product_rental_product',
        'multilang' => false,
        'fields' => array(
            'id_roja45_product_rental' => array('type' => self::TYPE_INT),
            'id_roja45_product' => array('type' => self::TYPE_INT),
            'id_product' => array('type' => self::TYPE_INT),
            'id_paymentprofile' => array('type' => self::TYPE_INT),
            'vouchers' => array('type' => self::TYPE_STRING),
        ),
    );

    public function __construct($id = null, $id_lang = null)
    {
        parent::__construct($id, $id_lang);
    }

    public function delete()
    {
        ProductRentalRentalModel::deleteAll($this->id_roja45_product_rental_product);
        return parent::delete();
    }

    public static function deleteAll($id_roja45_product_rental)
    {
        $return = true;
        $sql = new DbQuery();
        $sql->select(
            'rp.id_roja45_product_rental_product'
        );
        $sql->from('roja45_productrental_rentalproduct', 'rp');
        $sql->where('rp.id_roja45_product_rental='.(int) $id_roja45_product_rental);
        $results = Db::getInstance()->executeS($sql);
        foreach ($results as $row) {
            $rental_product = new ProductRentalRentalProduct($row['id_roja45_product_rental_product']);
            $return &= $rental_product->delete();
        }
    }

    public static function exists($id_roja45_product_rental, $id_product)
    {
        $sql = '
            SELECT id_roja45_product_rental_product
            FROM `' . _DB_PREFIX_ . 'roja45_productrental_rentalproduct` r
            WHERE r.id_roja45_product_rental = '. (int)$id_roja45_product_rental . '
            AND r.id_product = '. (int)$id_product;
        if (Db::getInstance(_PS_USE_SQL_SLAVE_)->getValue($sql)>0) {
            return new self(Db::getInstance(_PS_USE_SQL_SLAVE_)->getValue($sql));
        } else {
            return false;
        }
    }

    public function addModel(
        $id_roja45_product_model,
        $id_product_attribute,
        $start_date,
        $collection_time,
        $end_date,
        $return_time,
        $periods,
        $number_of_models,
        $total_model,
        $total_model_inc,
        $damage_deposit,
        $damage_deposit_inc,
        $id_roja45_product_rateduration
    ) {
        $model = new ProductRentalRentalModel();
        $model->id_roja45_product_rental_product = (int) $this->id;
        $model->id_roja45_product_model = (int) $id_roja45_product_model;
        $model->id_product_attribute = (int) $id_product_attribute;
        $model->start_date = pSQL($start_date);
        $model->collection_time = pSQL($collection_time);
        $model->end_date = pSQL($end_date);
        $model->return_time = pSQL($return_time);
        $model->periods = (int)$periods;
        $model->qty = (int)$number_of_models;
        $model->returned = 0;
        $model->total = $total_model;
        $model->total_wt = $total_model_inc;
        $model->damage_deposit = $damage_deposit;
        $model->damage_deposit_inc = $damage_deposit_inc;
        $model->id_roja45_product_rateduration = $id_roja45_product_rateduration;

        if (!$model->save()) {
            throw new Exception(Db::getInstance(_PS_USE_SQL_SLAVE_)->getMsgError());
        }
        return $model;
    }

    public function getModel($id_roja45_product_model)
    {
        $sql = '
          SELECT * FROM `' . _DB_PREFIX_ . 'roja45_productrental_rentalmodel`
          WHERE `id_roja45_product_rental_product` = ' . (int)$this->id . '
          AND = id_roja45_product_rental_model' . (int)  $id_roja45_product_model;
        return Db::getInstance()->executeS($sql);
    }

    public function getModels()
    {
        $sql = '
          SELECT * FROM `' . _DB_PREFIX_ . 'roja45_productrental_rentalmodel`
          WHERE `id_roja45_product_rental_product` = ' . (int)$this->id;
        return Db::getInstance()->executeS($sql);
    }

    public function deleteChildren()
    {
        foreach (ProductRentalRentalModel::getModels($this->id) as $model) {
            ProductRentalRentalModelRate::deleteAll((int)$model['id_roja45_product_rental_model']);
            ProductRentalRentalModelExtra::deleteAll((int)$model['id_roja45_product_rental_model']);
            ProductRentalRentalModel::deleteAll((int)$this->id);
        }
    }

    public function deleteModels()
    {
        return ProductRentalRentalModel::deleteAll((int)$this->id);
    }

    public function getRentalDates()
    {
        $sql = '
          SELECT MIN(start_date) as start_date, MAX(end_date) as end_date
          FROM ' . _DB_PREFIX_ . 'roja45_productrental_rentalmodel
          WHERE id_roja45_product_rental_product = ' . (int)$this->id;
        $dates = Db::getInstance()->getRow($sql);
        return $dates;
    }

    public function addVoucher($code)
    {
        $this->vouchers .= $code . ',';
        $this->save();
    }

    public function getVouchers($id_lang)
    {
        $vouchers = array();
        foreach (explode(',', $this->vouchers) as $voucher) {
            $id_voucher = ProductRentalVoucher::getIdByCode($voucher);
            if ($id_voucher) {
                $voucher = new ProductRentalVoucher($id_voucher, $id_lang);
                $vouchers[] = array(
                    'id_roja45_product_voucher' => $voucher->id,
                    'code' => $voucher->code,
                    'name' => $voucher->name,
                );
            }
        }
        return $vouchers;
    }

    public function toJSON($id_lang, $encode)
    {
        $object = array(
            'id_roja45_product_rental_product' => $this->id_roja45_product_rental_product,
            'id_roja45_product_rental' => $this->id_roja45_product_rental,
            'id_roja45_product' => $this->id_roja45_product,
            'id_paymentprofile' => $this->id_paymentprofile,
            'id_product' => $this->id_product,
            'vouchers' => array(),
            'models' => array()
        );

        foreach (explode(',', $this->vouchers) as $voucher) {
            $id_voucher = ProductRentalVoucher::getIdByCode($voucher);
            $voucher = new ProductRentalVoucher($id_voucher);
            $object['vouchers'][] = $voucher;
        }
        foreach ($this->getModels() as $model) {
            $rental_product_model = new ProductRentalRentalModel($model['id_roja45_product_rental_model'], $id_lang);
            $object['models'][] = $rental_product_model->toJSON($id_lang, false);
        }
        if ($encode) {
            return Tools::jsonEncode((object) $object);
        } else {
            return (object) $object;
        }
    }
}
