<?php
/**
 * ProductRentalRentalStatus.
 *
 * @author    Roja45
 * @copyright 2016 Roja45
 * @license   license.txt
 * @category  ProductRentalRentalStatus
 *
 * 2016 ROJA45 - All rights reserved.
 *
 * DISCLAIMER
 * Changing this file will render any support provided by us null and void.
 */

/**
 * ProductRentalRentalStatus.
 *
 * @author    Roja45
 * @copyright 2016 Roja45
 * @license   license.txt
 * @category  Class
 *
 * 2016 ROJA45 - All rights reserved.
 *
 * DISCLAIMER
 * Changing this file will render any support provided by us null and void.
 */

class ProductRentalRentalStatus extends ObjectModel
{
    public static $INPR = 'INPR';
    public static $RCVD = 'RCVD';
    public static $CHKT = 'CHKT';
    public static $CCNF = 'CCNF';
    public static $PRES = 'PRES';
    public static $CONF = 'CONF';
    public static $DPST = 'DPST';
    public static $PAYM = 'PAYM';
    public static $PAYU = 'PAYU';
    public static $PAYC = 'PAYC';
    public static $PAYR = 'PAYR';
    public static $PAYO = 'PAYO';
    public static $PAID = 'PAID';
    public static $ORDR = 'ORDR';
    public static $CLSD = 'CLSD';
    public static $INCP = 'INCP';
    public static $RETN = 'RETN';
    public static $DLTD = 'DLTD';
    public static $CUSR = 'CUSR';
    public static $MESG = 'MESG';
    public static $CCLD = 'CCLD';
    public static $CORD = 'CORD';
    public static $UNVL = 'UNVL';
    public static $OTHR = 'OTHR';
    public static $COMP = 'COMP';
    public static $REVW = 'REVW';
    public static $ABND = 'ABND';
    public static $OVER = 'OVER';
    public static $ADMN = 'ADMN';
    public static $RDUE = 'RDUE';
    public static $SHIP = 'SHIP';
    public static $CLCT = 'CLCT';
    public static $OPEN = 'OPEN';
    public static $CCLR = 'CCLR';

    public $id_roja45_product_rental_status;

    /** @var string Name */
    public $status;

    /** @var string Template name if there is any e-mail to send */
    public $answer_template;

    /** @var bool Send an e-mail to customer ? */
    public $send_email;

    /** @var bool Send an e-mail to customer ? */
    public $notify_admin;

    public $record_history;

    public $customer_account;

    public $code;

    /** @var string Display state in the specified color */
    public $color;

    public $unremovable;
    public $block_calendar;

    /**
     * @see ObjectModel::$definition
     */
    public static $definition = array(
        'table' => 'roja45_productrental_rentalstatus',
        'primary' => 'id_roja45_product_rental_status',
        'multilang' => true,
        'fields' => array(
            'send_email' => array('type' => self::TYPE_BOOL, 'validate' => 'isBool'),
            'notify_admin' => array('type' => self::TYPE_BOOL, 'validate' => 'isBool'),
            'record_history' => array('type' => self::TYPE_BOOL, 'validate' => 'isBool'),
            'code' => array('type' => self::TYPE_STRING, 'validate' => 'isModuleName'),
            'color' => array('type' => self::TYPE_STRING, 'validate' => 'isColor'),
            'unremovable' => array('type' => self::TYPE_BOOL, 'validate' => 'isBool'),
            'block_calendar' => array('type' => self::TYPE_BOOL, 'validate' => 'isBool'),
            'customer_account' => array('type' => self::TYPE_BOOL, 'validate' => 'isBool'),
            'answer_template' => array('type' => self::TYPE_STRING, 'validate' => 'isGenericName', 'size' => 64),
            /* Lang fields */
            'status' => array(
                'type' => self::TYPE_STRING,
                'lang' => true,
                'validate' => 'isGenericName',
                'required' => true,
                'size' => 64
            ),
        ),
    );

    public function add($auto_date = true, $null_values = false)
    {
        $status = ProductRentalRentalStatus::getStatusByType($this->code);
        if ($status && count($status)) {
            throw new PrestaShopException('Status code is not unique.');
        }
        return parent::add($auto_date, $null_values);
    }

    /**
     * Get all available order statuses.
     *
     * @param int $id_lang Language id for status name
     *
     * @return array Order statuses
     */
    public static function getStatus($id_lang)
    {
        $cache_id = 'ProductRentalRentalStatus::getStatus'.(int) $id_lang;
        if (!Cache::isStored($cache_id)) {
            $result = Db::getInstance(_PS_USE_SQL_SLAVE_)->executeS(
                'SELECT *
                FROM `'._DB_PREFIX_.'roja45_productrental_rentalstatus` qs
                LEFT JOIN `'._DB_PREFIX_.'roja45_productrental_rentalstatus_lang` qsl
                ON (qs.`id_roja45_product_rental_status` = qsl.`id_roja45_product_rental_status`
                AND qsl.`id_lang` = '.(int) $id_lang.')
                ORDER BY qs.`id_roja45_product_rental_status` ASC'
            );
            Cache::store($cache_id, $result);
        }

        return Cache::retrieve($cache_id);
    }

    /**
     * Get all available order statuses.
     *
     * @param int $id_lang Language id for status name
     *
     * @return array Order statuses
     */
    public static function getStates($id_lang)
    {
        $cache_id = 'ProductRentalRentalStatus::getStates'.(int) $id_lang;
        if (!Cache::isStored($cache_id)) {
            $sql = new DbQuery();
            $sql->select('*');
            $sql->from('roja45_productrental_rentalstatus', 'rs');
            $sql->leftJoin(
                'roja45_productrental_rentalstatus_lang',
                'rsl',
                '(rs.id_roja45_product_rental_status = rsl.id_roja45_product_rental_status)'
            );
            $sql->where('rsl.`id_lang` = ' . (int) $id_lang);
            $result =  Db::getInstance(_PS_USE_SQL_SLAVE_)->executeS($sql);
            Cache::store($cache_id, $result);
        }

        return Cache::retrieve($cache_id);
    }

    public static function isStatus($rental, $status)
    {
        if ($rental->id_roja45_product_rental_status == ProductRentalRentalStatus::getStatusByType($status)) {
            return new self($rental->id_roja45_product_rental_status, Context::getContext()->language->id);
        } else {
            return false;
        }
    }

    public static function getStatusByType($status_code)
    {
        $sql = new DbQuery();
        $sql->select('rs.id_roja45_product_rental_status');
        $sql->from('roja45_productrental_rentalstatus', 'rs');
        $sql->where('rs.code="'.pSQL($status_code).'"');
        return Db::getInstance()->getValue($sql);
    }

    public static function getCalendarBlockStates()
    {
        $result = Db::getInstance(_PS_USE_SQL_SLAVE_)->executeS(
            'SELECT code
            FROM `'._DB_PREFIX_.'roja45_productrental_rentalstatus`
            WHERE block_calendar = 1'
        );
        return $result;
    }

    public function isRemovable()
    {
        return !($this->unremovable);
    }

    public static function deleteAll()
    {
        $result = Db::getInstance(_PS_USE_SQL_SLAVE_)->execute(
            'DELETE
            FROM `'._DB_PREFIX_.'roja45_productrental_rentalstatus`'
        );
        return $result;
    }

    public static function getBlockingStatus()
    {
        $sql = new DbQuery();
        $sql->select('rs.id_roja45_product_rental_status');
        $sql->from('roja45_productrental_rentalstatus', 'rs');
        $sql->where('rs.block_calendar=1');
        return Db::getInstance()->executeS($sql);
    }

    public static function getBlockingStatusCodes()
    {
        $sql = new DbQuery();
        $sql->select('rs.code');
        $sql->from('roja45_productrental_rentalstatus', 'rs');
        $sql->where('rs.block_calendar=1');
        $results = Db::getInstance()->executeS($sql);
        $codes = array();
        foreach ($results as $result) {
            $codes[] = $result['code'];
        }
        return $codes;
    }
}
