<?php
/**
 * PropertyDiscount
 *
 * @author    Roja45
 * @copyright 2016 Roja45
 * @license   license.txt
 * @category  PropertyDiscount
 *
 * 2016 ROJA45 - All rights reserved.
 *
 * DISCLAIMER
 * Changing this file will render any support provided by us null and void.
 */

/**
 * PropertyDiscount
 *
 * @author    Roja45
 * @copyright 2016 Roja45
 * @license   license.txt
 * @category  Class
 *
 * 2016 ROJA45 - All rights reserved.
 *
 * DISCLAIMER
 * Changing this file will render any support provided by us null and void.
 */
class ProductRentalVoucher extends ObjectModel
{
    public $id_customer;
    public $code;
    public $name;
    public $quantity;
    public $quantity_per_user;
    public $reduction_percent;
    public $reduction_amount;
    public $reduction_extras;
    public $free_extras;
    public $enabled;
    public $date_from;
    public $date_to;
    public $date_add;
    public $date_upd;

    /**
     * @see ObjectModel::$definition
     */
    public static $definition = array(
        'table' => 'roja45_productrental_voucher',
        'primary' => 'id_roja45_product_voucher',
        'multilang' => true,
        'fields' => array(
            'name' => array(
                'type' => self::TYPE_STRING,
                'validate' => 'isGenericName',
                'required' => true,
                'lang' => true
            ),
            'id_customer' => array('type' => self::TYPE_INT, 'required' => false),
            'code' => array('type' => self::TYPE_STRING, 'required' => false),
            'quantity' => array('type' => self::TYPE_INT, 'validate' => 'isGenericName', 'required' => false),
            'quantity_per_user' => array('type' => self::TYPE_INT, 'required' => false),
            'reduction_percent' => array('type' => self::TYPE_FLOAT, 'required' => false),
            'reduction_amount' => array('type' => self::TYPE_FLOAT, 'required' => false),
            'reduction_extras' => array('type' => self::TYPE_BOOL, 'required' => false),
            'free_extras' => array('type' => self::TYPE_BOOL, 'required' => false),
            'enabled' => array('type' => self::TYPE_BOOL, 'required' => false),
            'date_from' => array('type' => self::TYPE_DATE, 'validate' => 'isDateFormat', 'required' => false),
            'date_to' => array('type' => self::TYPE_DATE, 'validate' => 'isDateFormat', 'required' => false),
            'date_add' => array('type' => self::TYPE_DATE, 'validate' => 'isDateFormat', 'required' => false),
            'date_upd' => array('type' => self::TYPE_DATE, 'validate' => 'isDateFormat', 'required' => false),
        ),
    );

    public static function getIdByCode($code)
    {
        $sql = new DbQuery();
        $sql->select('pv.id_roja45_product_voucher');
        $sql->from('roja45_productrental_voucher', 'pv');
        $sql->where('pv.code="'.pSQL($code).'"');
        return Db::getInstance()->getValue($sql);
    }

    public static function vouchersEnabled()
    {
        $sql = new DbQuery();
        $sql->select('count(pv.id_roja45_product_voucher)');
        $sql->from('roja45_productrental_voucher', 'pv');
        return Db::getInstance()->getValue($sql);
    }

    public function addExtra($id_roja45_product_extra)
    {
        $sql = new DbQuery();
        $sql->select('ve.id_roja45_product_extra');
        $sql->from('roja45_productrental_voucher', 'v');
        $sql->leftJoin(
            'roja45_productrental_voucher_extra',
            've',
            'v.id_roja45_product_voucher = ve.id_roja45_product_voucher'
        );
        $sql->where('ve.id_roja45_product_extra='. (int) $id_roja45_product_extra);
        $sql->where('ve.id_roja45_product_voucher='. (int) $this->id);
        if (!Db::getInstance()->getValue($sql)) {
            return Db::getInstance()->execute(
                'INSERT INTO `'._DB_PREFIX_.'roja45_productrental_voucher_extra` (`id_roja45_product_voucher`, `id_roja45_product_extra`) 
                VALUES ('. (int) $this->id.','. (int) $id_roja45_product_extra.')'
            );
        } else {
            return false;
        }
    }

    public function getExtras($id_lang)
    {
        $sql = new DbQuery();
        $sql->select('ve.*, el.name');
        $sql->from('roja45_productrental_voucher_extra', 've');
        $sql->leftJoin('roja45_productrental_extra', 'e', 'e.id_roja45_product_extra = ve.id_roja45_product_extra');
        $sql->leftJoin(
            'roja45_productrental_extra_lang',
            'el',
            'e.id_roja45_product_extra = el.id_roja45_product_extra'
        );
        $sql->where('ve.id_roja45_product_voucher='. (int) $this->id);
        $sql->where('el.id_lang='. (int) $id_lang);
        return Db::getInstance()->executeS($sql);
    }

    public function deleteExtra($id_roja45_product_extra)
    {
        return Db::getInstance()->execute(
            'DELETE FROM `'._DB_PREFIX_.'roja45_productrental_voucher_extra`
            WHERE id_roja45_product_extra='.$id_roja45_product_extra.''
        );
    }

    public static function getVoucherExtras($id_roja45_product_voucher, $id_lang = null)
    {
        $sql = new DbQuery();
        $sql->select('ve.id_roja45_product_voucher, ve.id_roja45_product_extra');
        $sql->from('roja45_productrental_voucher_extra', 've');
        $sql->leftJoin('roja45_productrental_extra', 'e', 'e.id_roja45_product_extra = ve.id_roja45_product_extra');
        $sql->where('ve.id_roja45_product_voucher='. (int) $id_roja45_product_voucher);
        if ($id_lang) {
            $sql->select('el.name');
            $sql->leftJoin(
                'roja45_productrental_extra_lang',
                'el',
                'e.id_roja45_product_extra = el.id_roja45_product_extra'
            );
            $sql->where('el.id_lang='. (int) $id_lang);
        }
        return Db::getInstance()->executeS($sql);
    }
}
