<?php
/**
 * ProductRentalWorkingDay
 *
 * @author    Roja45
 * @copyright 2016 Roja45
 * @license   license.txt
 * @category  ProductRentalWorkingDay
 *
 * 2016 ROJA45 - All rights reserved.
 *
 * DISCLAIMER
 * Changing this file will render any support provided by us null and void.
 */

/**
 * ProductRentalWorkingDay
 *
 * @author    Roja45
 * @copyright 2016 Roja45
 * @license   license.txt
 * @category  Class
 *
 * 2016 ROJA45 - All rights reserved.
 *
 * DISCLAIMER
 * Changing this file will render any support provided by us null and void.
 */
class ProductRentalWorkingDay extends ObjectModel
{
    public $id_roja45_product_rental_workingday;
    public $day;
    public $is_working_day;
    public $allow_rentals;
    public $opening_time;
    public $closing_time;
    public $name;

    const MONDAY = 'MONDAY';
    const TUESDAY = 'TUESDAY';
    const WEDNESDAY = 'WEDNESDAY';
    const THURSDAY = 'THURSDAY';
    const FRIDAY = 'FRIDAY';
    const SATURDAY = 'SATURDAY';
    const SUNDAY = 'SUNDAY';

    /**
     * @see ObjectModel::$definition
     */
    public static $definition = array(
        'table' => 'roja45_productrental_workingday',
        'primary' => 'id_roja45_product_rental_workingday',
        'multilang' => true,
        'fields' => array(
            'day' => array('type' => self::TYPE_STRING),
            'opening_time' => array('type' => self::TYPE_DATE),
            'closing_time' => array('type' => self::TYPE_DATE),
            'is_working_day' => array('type' => self::TYPE_BOOL),
            'allow_rentals' => array('type' => self::TYPE_BOOL),
            'name' => array('type' => self::TYPE_STRING, 'validate' => 'isGenericName', 'lang' => true),
        ),
    );

    public static function getWorkingDay($day)
    {
        $sql = new DbQuery();
        $sql->select('id_roja45_product_rental_workingday');
        $sql->from('roja45_productrental_workingday', 'wd');
        $sql->where('wd.day="'.pSQL($day).'"');
        return Db::getInstance()->getValue($sql);
    }

    /*
    public static function getDays($id_lang = null)
    {
        $sql = new DbQuery();
        $sql->select('*');
        $sql->from('roja45_productrental_workingday', 'wd');
        if ($id_lang) {
            $sql->leftJoin(
                'roja45_productrental_workingday_lang',
                'wdl',
                'wd.id_roja45_product_rental_workingday = wdl.id_roja45_product_rental_workingday'
            );
            $sql->where('wdl.id_lang='.(int)$id_lang);
        }

        return Db::getInstance()->executeS($sql);
    }*/

    public static function getDays($id_lang = null)
    {
        $sql = new DbQuery();
        $sql->select('*');
        $sql->from('roja45_productrental_workingday', 'wd');
        if ($id_lang) {
            $sql->leftJoin(
                'roja45_productrental_workingday_lang',
                'wdl',
                'wd.id_roja45_product_rental_workingday = wdl.id_roja45_product_rental_workingday'
            );
            $sql->where('wdl.id_lang='.(int)$id_lang);
        }

        $id_lang_default = (int) Configuration::get('PS_LANG_DEFAULT');
        $days = Db::getInstance()->executeS($sql);
        if (!count($days) && ($id_lang_default != $id_lang)) {
            $days = self::getDays($id_lang_default);
        }
        return $days;
    }

    public static function getWorkingDays($id_lang = null)
    {
        $sql = new DbQuery();
        $sql->select('*');
        $sql->from('roja45_productrental_workingday', 'wd');
        if ($id_lang) {
            $sql->leftJoin(
                'roja45_productrental_workingday_lang',
                'wdl',
                'wd.id_roja45_product_rental_workingday = wdl.id_roja45_product_rental_workingday'
            );
            $sql->where('wdl.id_lang='.(int)$id_lang);
        }
        $sql->where('wd.is_working_day=1');
        return Db::getInstance()->executeS($sql);
    }

    public static function getNonWorkingDays($id_lang = null)
    {
        $sql = new DbQuery();
        $sql->select('*');
        $sql->from('roja45_productrental_workingday', 'wd');
        if ($id_lang) {
            $sql->leftJoin(
                'roja45_productrental_workingday_lang',
                'wdl',
                'wd.id_roja45_product_rental_workingday = wdl.id_roja45_product_rental_workingday'
            );
            $sql->where('wdl.id_lang='.(int)$id_lang);
        }
        $sql->where('wd.is_working_day=0');

        return Db::getInstance()->executeS($sql);
    }
}
