<?php
/**
 * PropertyDiscount
 *
 * @author    Roja45
 * @copyright 2016 Roja45
 * @license   license.txt
 * @category  PropertyDiscount
 *
 * 2016 ROJA45 - All rights reserved.
 *
 * DISCLAIMER
 * Changing this file will render any support provided by us null and void.
 */

/**
 * PropertyDiscount
 *
 * @author    Roja45
 * @copyright 2016 Roja45
 * @license   license.txt
 * @category  Class
 *
 * 2016 ROJA45 - All rights reserved.
 *
 * DISCLAIMER
 * Changing this file will render any support provided by us null and void.
 */
class ProductUnavailable extends ObjectModel
{
    public $id_roja45_product;
    public $id_roja45_product_model;
    public $start_date;
    public $date_add;
    public $end_date;
    public $date_upd;

    /**
     * @see ObjectModel::$definition
     */
    public static $definition = array(
        'table' => 'roja45_productrental_productunavailable',
        'primary' => 'id_roja45_product_unavailable',
        'fields' => array(
            'id_roja45_product' => array('type' => self::TYPE_INT, 'required' => true),
            'id_roja45_product_model' => array('type' => self::TYPE_INT, 'required' => true),
            'start_date' => array('type' => self::TYPE_DATE, 'validate' => 'isDateFormat', 'required' => true),
            'end_date' => array('type' => self::TYPE_DATE, 'validate' => 'isDateFormat', 'required' => true),
            'date_add' => array('type' => self::TYPE_DATE, 'validate' => 'isDateFormat', 'required' => false),
            'date_upd' => array('type' => self::TYPE_DATE, 'validate' => 'isDateFormat', 'required' => false),
        ),
    );

    public static function getUnavailable(
        $id_roja45_product,
        $id_roja45_product_model = 0
    ) {
        $sql = new DbQuery();
        $sql->select('*');
        $sql->from('roja45_productrental_productunavailable', 'pu');
        $sql->where('pu.`id_roja45_product` = '.(int)$id_roja45_product);
        if ($id_roja45_product_model) {
            $sql->where('pu.`id_roja45_product_model` = '.(int)$id_roja45_product_model);
        }

        return Db::getInstance()->executeS($sql);
    }

    public static function getUnavailableDate(
        $id_roja45_product,
        $id_roja45_product_model,
        $date
    ) {
        if (!$id_roja45_product_model) {
            $id_roja45_product_model = 0;
        }
        $date = DateTime::createFromFormat('Y-m-d', $date);
        $sql = new DbQuery();
        $sql->select('*');
        $sql->from('roja45_productrental_productunavailable', 'pu');
        $sql->where('pu.`id_roja45_product` = '.(int)$id_roja45_product);
        $sql->where('pu.`id_roja45_product_model` = '.(int)$id_roja45_product_model);
        $sql->where('pu.start_date<="' . pSQL($date->format('Y-m-d')) . '"');
        $sql->where('pu.end_date>"' . pSQL($date->format('Y-m-d')) . '"');
        return Db::getInstance()->executeS($sql);
    }

    public static function getAllUnavailable()
    {
        $sql = new DbQuery();
        $sql->select('*');
        $sql->from('roja45_productrental_productunavailable', 'pu');
        return Db::getInstance()->executeS($sql);
    }
}
