<?php
/**
 * Roja45ProductRental.
 *
 * @author    Roja45
 * @copyright 2016 Roja45
 * @license   license.txt
 * @category  Roja45ProductRental
 *
 * 2016 ROJA45 - All rights reserved.
 *
 * DISCLAIMER
 * Changing this file will render any support provided by us null and void.
 */

/**
 * Roja45ProductRental.
 *
 * @author    Roja45
 * @copyright 2016 Roja45
 * @license   license.txt
 * @category  Class
 *
 * 2016 ROJA45.COM - All rights reserved.
 *
 * DISCLAIMER
 * Changing this file will render any support provided by us null and void.
 */

class RojaFortyFiveProductRentalCore
{
    protected $html = '';

    public static function renderHeader($module)
    {
        if (version_compare(_PS_VERSION_, '1.7', '>=') == true) {
            return self::displayTemplate(
                $module,
                'displayBackOfficeHeader',
                array(),
                'hookRoja45Header.tpl'
            );
        }
    }

    public static function renderFooter($module)
    {
        return self::displayTemplate(
            $module,
            'displayBackOfficeFooter',
            array(),
            'hookRoja45Footer.tpl'
        );
    }

    public static function sendHeartbeat($params)
    {
        $post_params = array();
        foreach ($params as $key => &$val) {
            if (is_array($val)) {
                $val = implode(',', $val);
            }
            $post_params[] = $key.'='.urlencode($val);
        }

        $post_string = implode(' & ', $post_params);
        $parts = parse_url(hex2bin('68747470733a2f2f7777772e726f6a6134352e636f6d2f75706461746573'));

        $fp = fsockopen(
            $parts['host'],
            isset($parts['port']) ? $parts['port'] : 80,
            $errno,
            $errstr,
            30
        );

        $out = "POST " . $parts['path'] . " HTTP/1.1\r\n";
        $out .= "Host: " . $parts['host'] . "\r\n";
        $out .= "Content-Type: application/x-www-form-urlencoded\r\n";
        $out .= "Content-Length: " . Tools::strlen($post_string) . "\r\n";
        $out .= "Connection: Close\r\n\r\n";
        if (isset($post_string)) {
            $out .= $post_string;
        }

        fwrite($fp, $out);
        fclose($fp);
    }

    public static function validateUpdate($module)
    {
        if (Configuration::get('ROJA45_UPDATE_' . $module->name) < (date("U") - 604800)) {
            $data = array(
                'module_name' => $module->name,
                'module_version' => $module->version,
                'host' => $_SERVER['HTTP_HOST'],
                'email' => Configuration::get('PS_SHOP_EMAIL')
            );

            $data_encoded = bin2hex(Tools::jsonEncode($data));
            $params = array(
                'p' => $data_encoded
            );
            self::sendHeartbeat($params);
            Configuration::updateValue('ROJA45_UPDATE_' . $module->name, date('U'));
        }
    }

    public static function addJs($controller, $uri, $check_path = true)
    {
        if (version_compare(_PS_VERSION_, '1.7', '<') == true) {
            $controller->addJs($uri, $check_path);
        } else {
        }
    }

    public static function removeJs($controller, $js_uri, $check_path = true)
    {
        if (version_compare(_PS_VERSION_, '1.7', '<') == true) {
            $controller->addJs($js_uri, $check_path);
        } else {
        }
    }

    public static function addCss($controller, $css_uri, $css_media_type = 'all', $offset = null, $check_path = true)
    {
        if (version_compare(_PS_VERSION_, '1.7', '<') == true) {
            $controller->addCss($css_uri, $css_media_type, $offset, $check_path);
        } else {
        }
    }

    public function removeCss($controller, $css_uri, $css_media_type = 'all', $check_path = true)
    {
        if (version_compare(_PS_VERSION_, '1.7', '<') == true) {
            $controller->addCss($css_uri, $css_media_type, $check_path);
        } else {
        }
    }

    public static function displayTemplate($module, $hook_name, $params, $template, $cache_id = null)
    {
        if (version_compare(_PS_VERSION_, '1.7', '<') == true) {
            return $module->display($module->name . '.php', $template, $cache_id);
        } else {
            return $module->renderWidget($hook_name, $params);
        }
    }

    public static function createTemplate($module, $template)
    {
        if (version_compare(_PS_VERSION_, '1.7', '>=') == true) {
            $template = 'PS17_'.$template;
        }

        if (file_exists(_PS_THEME_DIR_.'modules/'.$module.'/views/templates/hook/'.$template.'.tpl')) {
            return Context::getContext()->smarty->createTemplate(_PS_THEME_DIR_.'modules/'.$module.'/views/templates/hook/'.$template.'.tpl');
        } elseif (file_exists(_PS_ROOT_DIR_.'/modules/'.$module.'/views/templates/hook/'.$template.'.tpl')) {
            return Context::getContext()->smarty->createTemplate(_PS_ROOT_DIR_.'/modules/'.$module.'/views/templates/hook/'.$template.'.tpl');
        }
    }

    public static function setFrontControllerTemplate($controller, $template)
    {
        if (version_compare(_PS_VERSION_, '1.7', '<') == true) {
            $controller->setTemplate($template);
        } else {
            $controller->setTemplate('module:'.$controller->module->name.'/views/templates/front/PS17_'.$template);
        }
    }

    public static function getIncludedTemplate($controller, $template)
    {
        if (version_compare(_PS_VERSION_, '1.7', '<') == true) {
            return Context::getContext()->smarty->createTemplate($controller->getTemplatePath($template));
        } else {
            return Context::getContext()->smarty->createTemplate('module:'.$controller->module->name.'/views/templates/front/PS17_'.$template);
        }
    }

    public static function clearCache($module, $template)
    {
        if (version_compare(_PS_VERSION_, '1.7', '<') == true) {
            $module->_clearCache($template.'.tpl', $module->name.'::'.$template.'.tpl');
        } else {
            $module->_clearCache('module:'.$module->name.'/views/templates/hook/PS17_'.$template.'.tpl');
        }
    }

    public static function isCached($module, $template)
    {
        if (version_compare(_PS_VERSION_, '1.7', '<') == true) {
            return $module->isCached($template.'.tpl', $module->name.'::'.$template.'.tpl');
        } else {
            return $module->isCached('module:'.$module->name.'/views/templates/hook/PS17_'.$template.'.tpl');
        }
    }

    public static function getCacheId($module, $name = null)
    {
        if (version_compare(_PS_VERSION_, '1.7', '<') == true) {
            return $module->getCacheId($name.'.tpl');
        } else {
            return $module->getCacheId('module:'.$module->name.'/views/templates/hook/PS17_'.$name.'.tpl');
        }
    }

    public static function getLocalTranslation($module, $key, $lang)
    {
        if ($translation = Cache::getInstance()->get('local.'.$lang['iso_code'])) {
            return $translation[$key];
        } else {
            if (file_exists(_PS_MODULE_DIR_ . $module->name . '/translations/local.' . $lang['iso_code'])) {
                $data = file(_PS_MODULE_DIR_ . $module->name . '/translations/local.' . $lang['iso_code']);
            } elseif (file_exists(_PS_MODULE_DIR_ . $module->name . '/translations/local.en')) {
                $data = file(_PS_MODULE_DIR_ . $module->name . '/translations/local.en');
            }
            $returnArray = array();
            foreach ($data as $line) {
                $explode = explode("=", $line);
                $returnArray[$explode[0]] = trim(preg_replace('/\s+/', ' ', $explode[1]));
            }
            Cache::getInstance()->store('local.'.$lang['iso_code'], $returnArray);
            return $returnArray[$key];
        }
    }

    public static function isValidDateTimeString($str_dt, $str_dateformat)
    {
        $date = DateTime::createFromFormat($str_dateformat, $str_dt);
        return $date && $date->format($str_dateformat) == $str_dt;
    }

    public static function convertDateFormat($php_format)
    {
        $SYMBOLS_MATCHING = array(
            // Day
            'd' => 'dd',
            'D' => 'D',
            'j' => 'd',
            'l' => 'DD',
            'N' => '',
            'S' => '',
            'w' => '',
            'z' => 'o',
            // Week
            'W' => '',
            // Month
            'F' => 'MM',
            'm' => 'mm',
            'M' => 'M',
            'n' => 'm',
            't' => '',
            // Year
            'L' => '',
            'o' => '',
            'Y' => 'yy',
            'y' => 'y',
            // Time
            'a' => '',
            'A' => '',
            'B' => '',
            'g' => '',
            'G' => '',
            'h' => '',
            'H' => '',
            'i' => '',
            's' => '',
            'u' => ''
        );
        $jqueryui_format = "";
        $escaping = false;
        for ($i = 0; $i < Tools::strlen($php_format); $i++) {
            $char = $php_format[$i];
            if ($char === '\\') {
                $i++;
                if ($escaping) {
                    $jqueryui_format .= $php_format[$i];
                } else {
                    $jqueryui_format .= '\'' . $php_format[$i];
                }
                $escaping = true;
            } else {
                if ($escaping) {
                    $jqueryui_format .= "'";
                    $escaping = false;
                }
                if (isset($SYMBOLS_MATCHING[$char])) {
                    $jqueryui_format .= $SYMBOLS_MATCHING[$char];
                } else {
                    $jqueryui_format .= $char;
                }
            }
        }
        return $jqueryui_format;
    }

    public static function saveCustomerRequirements($requirements)
    {
        foreach ($requirements as $key => $requirement) {
            Context::getContext()->cookie->__set($key, $requirement);
        }
    }

    public static function saveCustomerRequirement($requirement, $value)
    {
        return Context::getContext()->cookie->__set($requirement, $value);
    }

    public static function getCustomerRequirement($requirement)
    {
        return Context::getContext()->cookie->__get($requirement);
    }

    public static function getCustomerRequirements($family)
    {
        return Context::getContext()->cookie->getFamily($family);
    }

    public static function clearCustomerRequirement($requirement)
    {
        return Context::getContext()->cookie->__unset($requirement);
    }

    public static function clearCustomerRequirements($requirements)
    {
        foreach ($requirements as $requirement) {
            Context::getContext()->cookie->__unset($requirement);
        }
    }

    public static function clearAllCustomerRequirements($family)
    {
        Context::getContext()->cookie->unsetFamily($family);
    }

    public static function sortByRateValue($x, $y)
    {
        return $x['rate'] - $y['rate'];
    }

    public static function createDateRangeArray($start_date, $range)
    {
        $now = new DateTime('midnight');
        $end_date = new DateTime($start_date->format('Y-m-d'));
        $end_date->add(new DateInterval('P' . $range . 'D'));

        $date_range = new DatePeriod(
            $start_date,
            new DateInterval('P1D'),
            $end_date
        );
        $periods = iterator_to_array($date_range);
        $dates = array();
        foreach ($periods as $period) {
            $type = '';
            $diff = $now->diff($period);
            $diffDays = (integer)$diff->format("%R%a");
            if ($period < $now) {
                $type .= 'past';
            } else if ($diffDays==0) {
                $type .= 'today';
            }
            $weekend = '';
            $weekday = '';
            if ($period->format('N') >= 6) {
                $weekend = 'weekend';
            } else {
                $weekday = 'weekday';
            }
            $dates[] = array(
                'date' => $period->format('Y-m-d'),
                'date_formatted' => $period->format(Context::getContext()->language->date_format_lite),
                'day_formatted' => $period->format('d'),
                'day_name' => $period->format('D'),
                'type' => $type,
                'weekday' => $weekday,
                'weekend' => $weekend,
            );
        }
        return $dates;
    }

    public static function disableModule()
    {
        Configuration::updateValue('RJ45DISMOD', 1);
    }

    public static function enableModule()
    {
        Configuration::deleteByName('RJ45DISMOD');
    }

    public static function deleteCustomerCartProductSpecificPrice(
        $id_customer,
        $id_cart,
        $id_product,
        $id_product_attribute = null
    ) {
        $sql = 'DELETE FROM `' . _DB_PREFIX_ . 'specific_price` WHERE id_cart = ' . (int) $id_cart . ' AND id_customer = '. (int) $id_customer . ' AND id_product = '. (int) $id_product;
        if ($id_product_attribute) {
            $sql .= ' AND id_product_attribute=' . (int) $id_product_attribute;
        }
        return Db::getInstance()->execute($sql);
    }
}
