<?php
/**
 * AdminProductRentalController
 *
 * @author    Roja45
 * @copyright 2016 Roja45
 * @license   license.txt
 * @category  AdminProductRentalController
 *
 * 2016 ROJA45 - All rights reserved.
 *
 * DISCLAIMER
 * Changing this file will render any support provided by us null and void.
 */

/**
 * AdminProductRentalController
 *
 * @author    Roja45
 * @copyright 2016 Roja45
 * @license   license.txt
 * @category  Class
 *
 * 2016 ROJA45 - All rights reserved.
 *
 * DISCLAIMER
 * Changing this file will render any support provided by us null and void.
 */

class AdminProductRentalController extends ModuleAdminController
{
    /**
     * Constructor
     */
    public function __construct()
    {
        parent::__construct();
        $this->context = Context::getContext();
        $this->override_folder = 'roja45productrental/';
        $this->tpl_folder = 'product_rental_old/';
        $this->bootstrap = true;
        $this->table = 'roja45_productrental_details';
        $this->identifier = 'id_roja45_product';
        $this->submit_action = $this->context->link->getAdminLink('AdminProductRental', true);
        $this->show_cancel_button = true;
        $this->className = 'ProductRentalDetails';
        $this->deleted = false;
        $this->colorOnBackground = false;
        $this->list_no_link = false;
        $this->_defaultOrderBy = $this->identifier = 'id_roja45_product';
        $this->_orderBy = 'id_roja45_product';
        $this->_orderWay = 'ASC';

        $this->bulk_actions = array(
            'delete' => array(
                'text' => $this->l(' Delete Selected'),
                'confirm' => $this->l('Delete selected items?'),
                'icon' => 'icon-trash',
            ),
            'change' => array(
                'text' => $this->l('Enable'),
                'confirm' => $this->l('Enable or Disable?'),
                'icon' => 'icon-refresh',
            ),
        );

        $this->_select = ' pds.enabled as shop_enabled,
            pl.name as product_name, image_shop.`id_image` AS `id_image`,shop.name as shop_name,
            (SELECT count(id_roja45_product_model) 
            FROM `'._DB_PREFIX_.'roja45_productrental_model` m 
            WHERE m.id_roja45_product = a.id_roja45_product) as number_models';

        if (Shop::getContext() == Shop::CONTEXT_SHOP && Shop::isFeatureActive()) {
            $this->_join =
                'LEFT JOIN `'._DB_PREFIX_.'roja45_productrental_details_shop` pds ON a.id_roja45_product = pds.id_roja45_product AND pds.`id_shop` = '. (int) Context::getContext()->shop->id .'
                LEFT JOIN `'._DB_PREFIX_.'product` p ON p.id_product = a.id_product
                LEFT JOIN `'._DB_PREFIX_.'product_lang` pl ON (p.`id_product` = pl.`id_product` AND pl.`id_shop` = '. (int) Context::getContext()->shop->id .')
                LEFT JOIN `'._DB_PREFIX_.'shop` shop ON (shop.id_shop = '. (int) Context::getContext()->shop->id .')
                LEFT JOIN `'._DB_PREFIX_.'image_shop` image_shop ON (image_shop.`id_product` = a.`id_product` AND image_shop.`cover` = 1 AND image_shop.`id_shop` = '. (int) Context::getContext()->shop->id .')
                LEFT JOIN `'._DB_PREFIX_.'image` i ON (i.`id_image` = image_shop.`id_image`)';
        } else {
            $this->_join =
                'LEFT JOIN `'._DB_PREFIX_.'roja45_productrental_details_shop` pds ON a.id_roja45_product = pds.id_roja45_product AND pds.`id_shop` = '. (int) Context::getContext()->shop->id .'
                LEFT JOIN `'._DB_PREFIX_.'product` p ON p.id_product = a.id_product
                LEFT JOIN `'._DB_PREFIX_.'product_lang` pl ON (p.`id_product` = pl.`id_product` AND pl.`id_shop` = a.id_shop_default)
                LEFT JOIN `'._DB_PREFIX_.'shop` shop ON (shop.id_shop = a.id_shop_default)
                LEFT JOIN `'._DB_PREFIX_.'image_shop` image_shop ON (image_shop.`id_product` = a.`id_product` AND image_shop.`cover` = 1 AND image_shop.`id_shop` = a.id_shop_default)
                LEFT JOIN `'._DB_PREFIX_.'image` i ON (i.`id_image` = image_shop.`id_image`)';
        }

        $this->_where .= ' AND pl.id_lang = '.(int) Context::getContext()->language->id;

        $this->fields_list = array(
            'id_roja45_product' => array(
                'title' => $this->l('Id'),
                'class' => 'fixed-width-xs'
            ),
            'image' => array(
                'title' => $this->l('Image'),
                'align' => 'center',
                'image' => 'p',
                'image_id' => 'id_image',
                'orderby' => false,
                'filter' => false,
                'search' => false
            ),
            'product_name' => array(
                'title' => $this->l('Product'),
                'width' => 'auto',
                'havingFilter' => true,
            ),
            'number_models' => array(
                'title' => $this->l('Models'),
                'width' => 'auto',
            ),
            'enabled' => array(
                'title' => $this->l('Enabled'),
                'align' => 'text-center',
                'active' => 'enableRentalProduct',
                'type' => 'bool',
                'ajax' => true,
                'orderby' => false,
                'class' => 'fixed-width-sm',
                'filter_type' => 'bool',
                'filter_key' => 'a!enabled',
            )
        );
        $this->list_no_link = false;
        $this->addRowAction('edit');
        $this->addRowAction('delete');
        $this->tabAccess = Profile::getProfileAccess($this->context->employee->id_profile, Tab::getIdFromClassName('AdminProductRental'));
    }

    /**
     * Initialise
     */
    public function init()
    {
        if ($this->controller_name != 'AdminLogin' &&
            (!isset($this->context->employee) || !$this->context->employee->isLoggedBack())
        ) {
            if (isset($this->context->employee)) {
                $this->context->employee->logout();
            }

            $email = false;
            if (Tools::getValue('email') && Validate::isEmail(Tools::getValue('email'))) {
                $email = Tools::getValue('email');
            }
            Tools::redirectAdmin(
                $this->context->link->getAdminLink('AdminLogin') .
                ((!Tools::getIsset(Tools::getValue('logout')) && $this->controller_name != 'AdminNotFound' && Tools::getValue('controller')) ? '&redirect=' . $this->controller_name : '') . ($email ? '&email=' . $email : '')
            );
        }

        if (Tools::isSubmit('add'.$this->table)) {
            $this->display = 'add';
        } elseif (Tools::isSubmit('view'.$this->table)) {
            $this->display = 'view';
        } elseif (Tools::isSubmit('update'.$this->table)) {
            $this->display = 'edit';
        } elseif (Tools::isSubmit('delete'.$this->table)) {
            $this->display = 'delete';
        }
        parent::init();
    }

    public function initPageHeaderToolbar()
    {
        parent::initPageHeaderToolbar();

        if (empty($this->display)) {
            $this->page_header_toolbar_btn['add_product'] = array(
                'href' => self::$currentIndex.'&add'.$this->table.'&token='.$this->token,
                'desc' => $this->l('Enable Product', null, null, false),
                'icon' => 'process-icon-new'
            );
        }
    }

    public function postProcess()
    {
        if (Tools::isSubmit($this->table . 'Orderby') || Tools::isSubmit($this->table . 'Orderway')) {
            $this->filter = true;
        }

        if (Tools::isSubmit('submitAdd' . $this->table)) {
            return true;
        } elseif (Tools::isSubmit('selectProduct' . $this->table)) {
            $rental_product = new ProductRentalDetails();
            $rental_product->initialiseRental(Tools::getValue('id_product'));
            Tools::redirectAdmin(
                $this->context->link->getAdminLink(
                    'AdminProductRental',
                    true
                ).'&token=' . $this->token
            );
        } elseif (Tools::isSubmit('delete' . $this->table)) {
            $rentalproduct = new ProductRentalDetails(Tools::getValue('id_roja45_product'));
            $rentalproduct->delete();
            Tools::redirectAdmin(
                $this->context->link->getAdminLink(
                    'AdminProductRental',
                    true
                ).'&token=' . $this->token
            );
        } elseif (Tools::isSubmit('submitBulkdelete' . $this->table)) {
            $products = Tools::getValue($this->table.'Box');
            foreach ($products as $product) {
                $rental_product = new ProductRentalDetails($product);
                $rental_product->delete();
            }
            Tools::redirectAdmin($this->context->link->getAdminLink(
                'AdminProductRental',
                true
            ));
        } elseif (Tools::getValue('action')=='addSelected') {
            $products = Tools::getValue('id_productBox');
            foreach ($products as $product) {
                $rental_product = new ProductRentalDetails();
                $rental_product->initialiseRental($product);
            }
            Tools::redirectAdmin($this->context->link->getAdminLink(
                'AdminProductRental',
                true
            ));
        }

        return parent::postProcess();
    }

    public function setMedia($isNewTheme = false)
    {
        parent::setMedia($isNewTheme);
        if ($this->display &&
            isset($this->tabAccess[$this->display]) &&
            $this->tabAccess[$this->display] == 1 &&
            in_array($this->display, array('add', 'edit'))
        ) {
            $this->context->controller->addJS(_PS_MODULE_DIR_ . $this->module->name . '/views/js/roja45productadmin.js');
            $this->context->controller->addCSS(_PS_MODULE_DIR_ . $this->module->name . '/views/css/roja45productadmin.css');
            $this->context->controller->addCss(_PS_MODULE_DIR_ . $this->module->name . '/vendor/jquery-confirm/jquery-confirm.min.css');
            $this->context->controller->addJS(_PS_MODULE_DIR_ . $this->module->name . '/vendor/jquery-confirm/jquery-confirm.min.js');

            $this->context->controller->addJS(array(
                _PS_JS_DIR_.'tiny_mce/tiny_mce.js',
                _PS_JS_DIR_.'tinymce.inc.js',
                _PS_JS_DIR_.'admin/tinymce.inc.js'
            ));

            $this->context->controller->addJqueryUI('ui.dialog');
            $this->context->controller->addJqueryUI('ui.effect');
            $this->context->controller->addJqueryUI('ui.datepicker');
            $this->context->controller->addJqueryUI('ui.selectable');
            $this->context->controller->addJqueryPlugin('validate');
            $this->context->controller->addJqueryPlugin('tablednd');
            $this->context->controller->addJS(_PS_MODULE_DIR_ . $this->module->name . '/vendor/riotjs/riot+compiler.js');
        }
    }

    public function initToolbarTitle()
    {
        $this->toolbar_title = is_array($this->breadcrumbs) ? array_unique($this->breadcrumbs) : array($this->breadcrumbs);
        /** @var ProductRentalDetails $rental_product */
        $rental_product = $this->loadObject(true);

        switch ($this->display) {
            case 'edit':
                $this->toolbar_title[] = $this->l('Edit Rental Product:'). $rental_product->getName((int)$this->context->language->id);
                $this->addMetaTitle($this->l('Edit Rental Product:'). $rental_product->getName((int)$this->context->language->id));
                break;

            case 'add':
                $this->toolbar_title[] = $this->l('Add new Rental Product', null, null, false);
                $this->addMetaTitle($this->l('Add new Rental Product', null, null, false));
                break;

            case 'view':
                $this->toolbar_title[] = $this->l('View Rental Product:'). $rental_product->getName((int)$this->context->language->id);
                $this->addMetaTitle($this->l('View Rental Product:'). $rental_product->getName((int)$this->context->language->id));
                break;
            default:
                $this->toolbar_title[] = $this->l('Rental Catalog');
                $this->addMetaTitle($this->l('Rental Catalog'));
        }

        if ($filter = $this->addFiltersToBreadcrumbs()) {
            $this->toolbar_title[] = $filter;
        }
    }

    public function renderForm()
    {
        if (!($obj = $this->loadObject(true))) {
            return;
        }
        switch ($this->display) {
            case 'edit':
                return $this->buildForm($obj);
            case 'add':
                return $this->buildProductSelectForm($obj);
        }
    }

    public function ajaxProcessenableRentalProductroja45Productrentaldetails()
    {
        $id = (int)Tools::getValue($this->identifier);
        Shop::addTableAssociation('roja45_productrental_details', array('type' => 'shop'));
        $rental_product = new ProductRentalDetails($id);
        $rental_product->enabled = ($rental_product->enabled) ? 0 : 1;
        $result = $rental_product->save();
        if ($result) {
            Roja45ProductRental::clearAllCached();
            $json = Tools::jsonEncode(array(
                'success' => 1,
                'text' => $this->l('The status has been updated successfully.'),
            ));
            die($json);
        } else {
            $json = Tools::jsonEncode(array(
                'success' => 0,
                'text' => $this->l('An error occurred while updating this status.'),
            ));
            die($json);
        }
    }

    /**
     * Submit rental product details.
     */
    public function ajaxProcessSubmitProductDetails()
    {
        $validationErrors = array();
        if ($this->tabAccess['edit'] === '0') {
            $validationErrors[] = $this->l('You do not have the right permission');
            die(Tools::jsonEncode(
                array(
                    'result' => 'error',
                    'errors' => $validationErrors
                )
            ));
        }

        try {
            $id_roja45_product = Tools::getValue('ROJA45_PRODUCTRENTAL_ID');
            $rentalproduct = new ProductRentalDetails($id_roja45_product);
            if (!Validate::isLoadedObject($rentalproduct)) {
                throw new Exception($this->l('The object cannot be loaded.'));
            }

            if (!count($validationErrors)) {
                $rentalproduct->id_product = Tools::getValue('ROJA45_PRODUCTRENTAL_PRODUCT_ID');
                $rentalproduct->address = Tools::getValue('ROJA45_PRODUCTRENTAL_ADDRESS');
                $rentalproduct->address_2 = Tools::getValue('ROJA45_PRODUCTRENTAL_ADDRESS_2');
                $rentalproduct->city = Tools::strtoupper(Tools::getValue('ROJA45_PRODUCTRENTAL_CITY'));
                $rentalproduct->country = Tools::getValue('ROJA45_PRODUCTRENTAL_COUNTRY');
                $rentalproduct->state = Tools::getValue('ROJA45_PRODUCTRENTAL_STATE');
                $rentalproduct->postal_code = Tools::getValue('ROJA45_PRODUCTRENTAL_ZIP');
                $rentalproduct->telephone_1 = Tools::getValue('ROJA45_PRODUCTRENTAL_CONTACT_NUMBER_1');
                $rentalproduct->telephone_2 = Tools::getValue('ROJA45_PRODUCTRENTAL_CONTACT_NUMBER_2');
                $rentalproduct->url = Tools::getValue('ROJA45_PRODUCTRENTAL_URL');
                $rentalproduct->lat = Tools::getValue('ROJA45_PRODUCTRENTAL_LAT');
                $rentalproduct->lon = Tools::getValue('ROJA45_PRODUCTRENTAL_LON');
                $rentalproduct->email = Tools::getValue('ROJA45_PRODUCTRENTAL_EMAIL');
                $rentalproduct->id_paymentprofile = Tools::getValue('ROJA45_PRODUCTRENTAL_PAYMENTPROFILE_ID');
                $rentalproduct->minimum_duration = Tools::getValue('ROJA45_PRODUCTRENTAL_MINIMUM_DURATION');
                $rentalproduct->maximum_duration = Tools::getValue('ROJA45_PRODUCTRENTAL_MAXIMUM_DURATION');
                $rentalproduct->enabled = Tools::getValue('ROJA45_PRODUCTRENTAL_RESERVATIONSENABLED');
                $rentalproduct->instant_rental = Tools::getValue('ROJA45_PRODUCTRENTAL_INSTANTRENTAL');
                if ($timeStr = Tools::getValue('ROJA45_PRODUCTRENTAL_COLLECTIONTIME')) {
                    $dateObj = DateTime::createFromFormat('d.m.Y H:i', '10.10.2010 ' . $timeStr);
                    if ($dateObj !== false) {
                        $rentalproduct->collection_time = $timeStr;
                    } else {
                        throw new Exception('Collection time format invalid');
                    }
                }
                if ($timeStr = Tools::getValue('ROJA45_PRODUCTRENTAL_RETURNTIME')) {
                    $dateObj = DateTime::createFromFormat('d.m.Y H:i', '10.10.2010 ' . $timeStr);
                    if ($dateObj !== false) {
                        $rentalproduct->return_time = $timeStr;
                    } else {
                        throw new Exception('Return time format invalid');
                    }
                }
                $rentalproduct->id_roja45_product_damagedeposit = Tools::getValue('ROJA45_PRODUCTRENTAL_DAMAGEDEPOSIT');
                $rentalproduct->id_roja45_product_overdueaction = Tools::getValue('ROJA45_PRODUCTRENTAL_DEFAULTOVERDUERENTALACTION');
                $rentalproduct->overdue_fine = Tools::getValue('ROJA45_PRODUCTRENTAL_OVERDUEFINE');
                $result = $rentalproduct->save();

                if ($result) {
                    Roja45ProductRental::clearAllCached();
                    die(Tools::jsonEncode(array(
                        'result' => 'success',
                        'response' => 'Rental Product Details Updated',
                        'id_roja45_product' => $rentalproduct->id_roja45_product,
                    )));
                } else {
                    $validationErrors[] = $this->l('Unable to save rental product.');
                    $validationErrors[] = $this->l('EXCEPTION: '.Db::getInstance()->getMsgError());
                    die(Tools::jsonEncode(array(
                        'result' => 'error',
                        'errors' => $validationErrors,
                    )));
                }
            } else {
                die(Tools::jsonEncode(array(
                    'result' => 'error',
                    'errors' => $validationErrors,
                )));
            }
        } catch (Exception $e) {
            $validationErrors = array();
            $validationErrors[] = $e->getMessage();
            $json = Tools::jsonEncode(array(
                'result' => 'error',
                'errors' => $validationErrors,
                'exception' => $e,
            ));
            die($json);
        }
    }

    public function ajaxProcessAddProductModel()
    {
        $validationErrors = array();
        if ($this->tabAccess['add'] === '0') {
            $validationErrors[] = $this->l('You do not have the right permission');
            die(Tools::jsonEncode(
                array(
                    'result' => 'error',
                    'errors' => $validationErrors
                )
            ));
        }
        try {
            $id_roja45_product = Tools::getValue('id_roja45_product');
            $rentalproduct = new ProductRentalDetails($id_roja45_product);
            if (!Validate::isLoadedObject($rentalproduct)) {
                throw new Exception($this->l('The object cannot be loaded.'));
            }

            $exists = ProductRentalModel::getProductModel($id_roja45_product, 0);
            if ($exists) {
                throw new Exception($this->l('Only one unlinked rental product model is allowed.'));
            }
            $model = new ProductRentalModel();
            $model->id_roja45_product = $rentalproduct->id_roja45_product;
            //$model->rate_type = ProductRentalModel::DAILY;
            //$model->minimum_duration = 1;
            $model->qty_available = 1;
            $model->service_charge = 0;
            $model->service_charge_type = 0;
            $model->is_linked = 0;
            $model->enabled = 1;

            if ($model->save()) {
                $tpl = $this->context->smarty->createTemplate(
                    $this->getTemplatePath('productrental_models.tpl').'productrental_models.tpl'
                );
                $tpl->assign(
                    array(
                        'languages' => $this->context->controller->getLanguages(),
                        'link' => $this->context->link,
                        'productrental_models' => ProductRentalModel::getModels(
                            $id_roja45_product,
                            (int)$this->context->language->id
                        ),
                    )
                );
                $view = $tpl->fetch();
                $json = Tools::jsonEncode(array(
                    'result' => 'success',
                    'response' => $this->l('New model created.'),
                    'id_roja45_product_model' => $model->id,
                    'view' => $view,
                ));
                die($json);
            } else {
                $validationErrors[] = $this->l('Unable to create new model.');
                $validationErrors[] = $this->l('EXCEPTION: '.Db::getInstance()->getMsgError());
                $json = Tools::jsonEncode(array(
                    'result' => 'error',
                    'errors' => $validationErrors,
                ));
                die($json);
            }
        } catch (Exception $e) {
            $validationErrors[] = $this->l('General error raised.');
            $validationErrors[] = $this->l('EXCEPTION: '.$e->getMessage());
            $json = Tools::jsonEncode(array(
                'result' => 'error',
                'errors' => $validationErrors,
                'msg' => 'EXCEPTION: ' . $e->getMessage() . "\n",
                'exception' => $e,
            ));
            die($json);
        }
    }

    public function ajaxProcessUpdateProductModel()
    {
        $validationErrors = array();
        if ($this->tabAccess['edit'] === '0') {
            $validationErrors[] = $this->l('You do not have the right permission');
            die(Tools::jsonEncode(
                array(
                    'result' => 'error',
                    'errors' => $validationErrors
                )
            ));
        }
        try {
            $id_roja45_product = Tools::getValue('ROJA45_PRODUCTRENTAL_ID');
            $id_roja45_product_model = Tools::getValue('ROJA45_PRODUCTRENTAL_MODEL_ID');

            $rentalproduct = new ProductRentalDetails($id_roja45_product);
            if (!Validate::isLoadedObject($rentalproduct)) {
                throw new Exception($this->l('The object cannot be loaded.'));
            }

            if ($id_roja45_product_model > 0) {
                $model = new ProductRentalModel($id_roja45_product_model);
            } else {
                $model = new ProductRentalModel();
                $model->id_roja45_product = $id_roja45_product;
            }

            $model->name = Tools::getValue('ROJA45_PRODUCTRENTAL_NAME');
            if ($model->is_linked) {
                $model->qty_available = 0;
            } else {
                $model->qty_available = (int) Tools::getValue('ROJA45_PRODUCTRENTAL_QTY_AVAILABLE');
            }
            $model->enabled = Tools::getValue('ROJA45_PRODUCTRENTAL_MODELENABLED');
            $model->reference = Tools::getValue('ROJA45_PRODUCTRENTAL_MODEL_REFERENCE');
            //$model->rate_type = Tools::getValue('ROJA45_PRODUCTRENTAL_RATETYPE');
            $descs = Tools::getValue('ROJA45_PRODUCTRENTAL_DESCRIPTION');
            foreach ($descs as $desc) {
                $model->description[key($desc)] = $desc[key($desc)];
            }
            if ($model->save() && $model->id > 0) {
                die(Tools::jsonEncode(array(
                    'redirect' => $this->context->link->getAdminLink(
                        'AdminProductRental',
                        true
                    ).'&id_roja45_product='.$id_roja45_product.'&updateroja45_productrental_details',
                    'result' => 1,
                    'response' => $this->l('Model Updated'),
                )));
            } else {
                $validationErrors[] = $this->l('Error updating house prices.');
                $validationErrors[] = $this->l('EXCEPTION: '.Db::getInstance()->getMsgError());
                die(Tools::jsonEncode(array(
                    'result' => 0,
                    'errors' => $validationErrors,
                )));
            }
        } catch (Exception $e) {
            $validationErrors = array();
            $validationErrors[] = $e->getMessage();
            error_log($e->getMessage());
            $json = Tools::jsonEncode(array(
                'result' => 0,
                'errors' => $validationErrors,
                'exception' => $e,
            ));
            die($json);
        }
    }

    public function ajaxProcessDeleteProductModel()
    {
        $validationErrors = array();
        if ($this->tabAccess['delete'] === '0') {
            $validationErrors[] = $this->l('You do not have the right permission');
            die(Tools::jsonEncode(
                array(
                    'result' => 'error',
                    'errors' => $validationErrors
                )
            ));
        }
        try {
            $id_roja45_product = Tools::getValue('id_roja45_product');
            $id_roja45_product_model = Tools::getValue('id_roja45_product_model');
            $model = new ProductRentalModel($id_roja45_product_model);
            if (!Validate::isLoadedObject($model)) {
                throw new Exception($this->l('The object cannot be loaded.'));
            }
            $return = (bool)$model->delete();

            if ($return) {
                $tpl = $this->context->smarty->createTemplate(
                    $this->getTemplatePath('productrental_models.tpl').'productrental_models.tpl'
                );
                $tpl->assign(
                    array(
                        'languages' => $this->context->controller->getLanguages(),
                        'link' => $this->context->link,
                        'productrental_models' => ProductRentalModel::getModels(
                            $id_roja45_product,
                            (int)$this->context->language->id
                        ),
                    )
                );
                $view = $tpl->fetch();
                $json = Tools::jsonEncode(array(
                    'result' => 'success',
                    'response' => $this->l('New model created.'),
                    'view' => $view,
                ));
                die($json);
            } else {
                $validationErrors[] = 'Unable to create new model.';
                $json = Tools::jsonEncode(array(
                    'result' => 'error',
                    'errors' => $validationErrors,
                ));
                die($json);
            }
        } catch (Exception $e) {
            $validationErrors[] = $e->getMessage();
            $json = Tools::jsonEncode(array(
                'result' => 'error',
                'errors' => $validationErrors,
                'msg' => 'Caught exception: ' . $e->getMessage() . "\n",
                'exception' => $e,
            ));
            die($json);
        }
    }

    public function ajaxProcessDuplicateProductModel()
    {
        $validationErrors = array();
        if ($this->tabAccess['add'] === '0') {
            $validationErrors[] = $this->l('You do not have the right permission');
            die(Tools::jsonEncode(
                array(
                    'result' => 'error',
                    'errors' => $validationErrors
                )
            ));
        }
        try {
            $id_roja45_product = Tools::getValue('id_roja45_product');
            $id_roja45_product_model = Tools::getValue('id_roja45_product_model');
            $rentalproduct = new ProductRentalDetails($id_roja45_product);
            if (!Validate::isLoadedObject($rentalproduct)) {
                throw new Exception($this->l('The object cannot be loaded.'));
            }

            $model = new ProductRentalModel($id_roja45_product_model);
            $model->id_roja45_product = $rentalproduct->id_roja45_product;
            $return = $model->copySpace($this->l('Copy of ') . $model->name[$this->context->language->id]);

            if ($return) {
                $tpl = $this->context->smarty->createTemplate(
                    $this->getTemplatePath('productrental_models.tpl').'productrental_models.tpl'
                );
                $tpl->assign(array(
                    'languages' => $this->context->controller->getLanguages(),
                    'link' => $this->context->link,
                    'models' => ProductRentalModel::getModels(
                        $id_roja45_product,
                        (int)$this->context->language->id
                    ),
                ));
                $view = $tpl->fetch();
                $json = Tools::jsonEncode(array(
                    'result' => 'success',
                    'response' => $this->l('New model created.'),
                    'view' => $view,
                ));
                die($json);
            } else {
                $validationErrors[] = 'Unable to create new model.';
                $json = Tools::jsonEncode(array(
                    'result' => 'error',
                    'errors' => $validationErrors,
                ));
                die($json);
            }
        } catch (Exception $e) {
            $validationErrors = array();
            $validationErrors[] = $e->getMessage();
            $json = Tools::jsonEncode(array(
                'result' => 'error',
                'errors' => $validationErrors,
                'msg' => 'Caught exception: ' . $e->getMessage() . "\n",
                'exception' => $e,
            ));
            die($json);
        }
    }

    public function ajaxProcessGetModels()
    {
        $validationErrors = array();
        if ($this->tabAccess['view'] === '0') {
            $validationErrors[] = $this->l('You do not have the right permission');
            die(Tools::jsonEncode(
                array(
                    'result' => 'error',
                    'errors' => $validationErrors
                )
            ));
        }
        try {
            $models = ProductRentalModel::getModels(
                Tools::getValue('id_roja45_product'),
                (int)$this->context->language->id
            );

            $model_rows = array();
            foreach ($models as &$model) {
                $modelObj = new ProductRentalModel($model['id_roja45_product_model']);
                $model['name'] = $modelObj->getModelName($this->context->language->id);
                $model_rows[]['id'] = $modelObj->id;
                $model_rows[]['name'] = $modelObj->getModelName($this->context->language->id);
            }
            $tpl = $this->context->smarty->createTemplate(
                $this->getTemplatePath('productrental_models.tpl').'productrental_models.tpl'
            );

            $tpl->assign(
                array(
                    'id_lang' => $this->context->language->id,
                    'languages' => $this->context->controller->getLanguages(),
                    'link' => $this->context->link,
                    'admin_link' => $this->context->link->getAdminLink('AdminProductRental'),
                    'productrental_models' => $models,
                    'models' => Tools::jsonEncode(array(
                        'columns' => array(
                            array('content' =>  $this->l('Id'), 'key' => 'id', 'center' => true),
                            array('content' => $this->l('Model'), 'key' => 'model', 'center' => true),
                        ),
                        'rows' => $model_rows,
                        'rows_actions' => array(
                            array('title' => $this->l('Model'), 'action' => 'editModel', 'icon' => 'pencil', 'fa' => 'pencil')
                        ),
                        'top_actions' => array(
                            array('title' => $this->l('Add Model'), 'action' => 'addModel', 'icon' => 'add', 'img' => 'themes/default/img/process-icon-new.png', 'fa' => 'plus'),
                        ),
                        //'url_params' => array('configure' => $this->name),
                        'identifier' => 'id'
                    ))
                )
            );

            $html = $tpl->fetch();
            $html .= $this->context->smarty->fetch($this->local_path.'views/templates/admin/prestui/ps-tags.tpl');

            die(Tools::jsonEncode(array(
                'result' => 'success',
                'id_lang' => $this->context->language->id,
                'languages' => $this->context->controller->getLanguages(),
                'response' => 'Success',
                'html' => $html,
            )));
        } catch (Exception $e) {
            $validationErrors = array();
            $validationErrors[] = $e->getMessage();
            $json = Tools::jsonEncode(array(
                'result' => 'error',
                'errors' => $validationErrors,
                'exception' => $e,
            ));
            die($json);
        }
    }

    public function ajaxProcessRetrieveModel()
    {
        $validationErrors = array();
        if ($this->tabAccess['view'] === '0') {
            $validationErrors[] = $this->l('You do not have the right permission');
            die(Tools::jsonEncode(
                array(
                    'result' => 'error',
                    'errors' => $validationErrors
                )
            ));
        }
        try {
            $model = new ProductRentalModel(Tools::getValue('id_roja45_product_model'));
            if (!Validate::isLoadedObject($model)) {
                throw new Exception($this->l('The object cannot be loaded.'));
            }
            $product = new Product(Tools::getValue('id_product'), false, (int)$this->context->language->id);
            if (!Validate::isLoadedObject($product)) {
                throw new Exception($this->l('The product object cannot be loaded.'));
            }

            $rentalproduct = new ProductRentalDetails($model->id_roja45_product);
            $tpl = $this->context->smarty->createTemplate(
                $this->getTemplatePath('productrental_model.tpl').'productrental_model.tpl'
            );
            $rate_types = ProductRentalRateType::getRateTypes(
                (int)$this->context->language->id
            );
            $rate_durations = ProductRentalRateDuration::getRateDurations(
                true,
                (int)$this->context->language->id
            );

            $productrental_rates = ProductRentalRate::getRates(
                Tools::getValue('id_roja45_product'),
                $model->id,
                $this->context->language->id
            );
            usort($productrental_rates, array($this, 'sortByRateValue'));

            $periods = ProductRentalPeriod::getPeriodsForLang((int)$this->context->language->id);
            $period_rates = array();
            if (count($periods)>0) {
                $period = new ProductRentalPeriod($periods[0]['id_roja45_product_period']);
                $period_rates = $this->getPeriodRates(
                    $periods,
                    $rentalproduct->id_roja45_product,
                    $model->id_roja45_product_model
                );
                $tpl->assign(
                    array(
                        'default_period' => $period,
                        'default_period_name' => $period->name[$this->context->language->id],
                    )
                );
            }

            $payment_profiles = ProductRentalPaymentProfile::getPaymentProfilesForLang($this->context->language->id);
            $available_addons = ProductRentalExtra::getExtras($this->context->language->id);
            $all_selected = ProductRentalModelExtra::getExtrasForModel(
                $model->id_roja45_product_model,
                $this->context->language->id
            );
            $selected_ids = array();
            $selected_addons = array();
            foreach ($all_selected as $selected) {
                $selected_ids[] = $selected['id_roja45_product_extra'];
                $selected_addons[$selected['id_roja45_product_extra']] = $selected;
            }
            if (count($available_addons)>0) {
                $tpl->assign(
                    array(
                        'available_addons' => $available_addons,
                        'selected_ids' => $selected_ids,
                        'selected' => $selected_addons,
                    )
                );
            }
            $is_linked = true;
            if (!(int) $model->id_product_attribute) {
                $is_linked = false;
            }
            $tpl->assign(
                array(
                    'id_lang' => $this->context->language->id,
                    'languages' => $this->context->controller->getLanguages(),
                    'link' => $this->context->link,
                    'admin_link' => $this->context->link->getAdminLink('AdminProductRental'),
                    'link_rewrite' => $product->link_rewrite,
                    'model' => $model,
                    'is_linked' => $is_linked,
                    'fields_value' => $this->getModelFieldsValues($model),
                    'id_product' => $rentalproduct->id_product,
                    'id_roja45_product' => $rentalproduct->id_roja45_product,
                    'id_roja45_product_model' => $model->id_roja45_product_model,
                    'productrental_model_rates' => $productrental_rates,
                    'rate_types' => $rate_types,
                    'rate_durations' => $rate_durations,
                    'period_rates' => $period_rates,
                    'payment_profiles' => $payment_profiles,
                    'currency' => $this->context->currency,
                    'stock_management_enabled' => Configuration::get('PS_STOCK_MANAGEMENT'),
                    'use_period_pricing' => Configuration::get('ROJA45_PRODUCTRENTAL_USEPERIODPRICING'),
                    'customer_groups' => Group::getGroups($this->context->language->id, $this->context->shop->id),
                )
            );
            $html = $tpl->fetch();

            die(Tools::jsonEncode(array(
                'result' => 'success',
                'id_lang' => $this->context->language->id,
                'languages' => $this->context->controller->getLanguages(),
                'response' => 'Success',
                'html' => $html,
            )));
        } catch (Exception $e) {
            $validationErrors = array();
            $validationErrors[] = $e->getMessage();
            $json = Tools::jsonEncode(array(
                'result' => 'error',
                'errors' => $validationErrors,
                'exception' => $e,
            ));
            die($json);
        }
    }

    public function ajaxProcessGetStates()
    {
        try {
            $states = State::getStatesByIdCountry(Tools::getValue('id_country'));
            die(Tools::jsonEncode(array(
                'result' => true,
                'states' => $states
            )));
        } catch (Exception $e) {
            $validationErrors = array();
            $validationErrors[] = $e->getMessage();
            $json = Tools::jsonEncode(array(
                'result' => false,
                'errors' => $validationErrors,
                'exception' => $e,
            ));
            die($json);
        }
    }

    public function ajaxProcessGetRateTypesForModel()
    {
        try {
            $model = new ProductRentalModel(Tools::getValue('ROJA45_PRODUCTRENTAL_SPACE_ID'));
            if (!Validate::isLoadedObject($model)) {
                throw new Exception($this->l('The object cannot be loaded.'));
            }
            //$model->rate_type = Tools::getValue('ROJA45_PRODUCTRENTAL_RATETYPE');
            $model->save();

            $rate_types = ProductRentalRateType::getRateTypes(
                (int)$this->context->language->id
            );
            $tpl = $this->context->smarty->createTemplate(
                _PS_MODULE_DIR_ . 'roja45productrental/views/templates/hook/productrental_rates.tpl'
            );
            $tpl->assign(
                array(
                    'languages' => $this->context->controller->getLanguages(),
                    'link' => $this->context->link,
                    'model_rates' => ProductRentalRate::getRates(
                        Tools::getValue('ROJA45_PRODUCTRENTAL_ID_MODEL'),
                        $model->id,
                        $this->context->language->id
                    ),
                    'rate_types' => $rate_types,
                    'currency' => $this->context->currency,
                )
            );

            $rates = $tpl->fetch();

            die(Tools::jsonEncode(array(
                'languages' => $this->context->controller->getLanguages(),
                'result' => 'success',
                'rates' => $rates,
                'lang' => $this->context->language->id,
            )));
        } catch (Exception $e) {
            $validationErrors = array();
            $validationErrors[] = $e->getMessage();
            $json = Tools::jsonEncode(array(
                'result' => 'error',
                'errors' => $validationErrors,
                'exception' => $e,
            ));
            die($json);
        }
    }

    public function ajaxProcessAddModelImages()
    {
        try {
            $model = new ProductRentalModel(Tools::getValue('id_roja45_product_model'));
            if (!Validate::isLoadedObject($model)) {
                throw new Exception($this->l('The model object cannot be loaded.'));
            }

            $product = new Product(Tools::getValue('ROJA45_PRODUCTRENTAL_PRODUCT_ID'));
            if (!Validate::isLoadedObject($product)) {
                throw new Exception($this->l('The product object cannot be loaded.'));
            }

            $model->deleteImages();

            $image_list = Tools::getValue('images');

            $images = array();

            foreach ($image_list as $key => $id_image) {
                $image = array();
                $image['id_image'] = $id_image;
                $image['position'] = $key;
                if ($key == 0) {
                    $image['cover'] = 1;
                } else {
                    $image['cover'] = 0;
                }

                $model->addModelImage($image);

                $imageObj = new Image($image, (int)$this->context->language->id);
                $image['title'] = $imageObj->legend;
                $images[$key] = $image;
            }

            $link_rewrite = $product->link_rewrite;
            if (is_array($link_rewrite)) {
                $link_rewrite = $link_rewrite[(int)$this->context->language->id];
            }

            $tpl = $this->context->smarty->createTemplate(
                _PS_MODULE_DIR_ . 'roja45productrental/views/templates/hook/productrental_imagelist.tpl'
            );
            $tpl->assign(
                array(
                    'link_rewrite' => $link_rewrite,
                    'languages' => $this->context->controller->getLanguages(),
                    'link' => $this->context->link,
                    'productrental_model_images' => $images,
                    'image_size_type' => ImageType::getFormatedName('small'),
                    'image_size' => Image::getSize(ImageType::getFormatedName('small')),
                )
            );
            $view = $tpl->fetch();
            die(Tools::jsonEncode(array(
                'languages' => $this->context->controller->getLanguages(),
                'result' => 'success',
                'view' => $view,
            )));
        } catch (Exception $e) {
            $validationErrors = array();
            $validationErrors[] = $e->getMessage();
            $json = Tools::jsonEncode(array(
                'result' => 'error',
                'errors' => $validationErrors,
                'exception' => $e,
            ));
            die($json);
        }
    }

    public function ajaxProcessUpdateEnabledStatus()
    {
        $validationErrors = array();
        if ($this->tabAccess['edit'] === '0') {
            $validationErrors[] = $this->l('You do not have the right permission');
            die(Tools::jsonEncode(
                array(
                    'result' => 'error',
                    'errors' => $validationErrors
                )
            ));
        }
        try {
            $id_roja45_product = Tools::getValue('id_roja45_product');
            $rentalproduct = new ProductRentalDetails($id_roja45_product);
            if (!Validate::isLoadedObject($rentalproduct)) {
                throw new Exception($this->l('The object cannot be loaded.'));
            }
            $status = Tools::getValue('status');
            $rentalproduct->enabled = $status;
            if ($rentalproduct->save()) {
                die(Tools::jsonEncode(array(
                    'result' => 'success',
                    'response' => $this->l('Status updated')
                )));
            }
        } catch (Exception $e) {
            $validationErrors = array();
            $validationErrors[] = $e->getMessage();
            error_log($e->getMessage());
            die(Tools::jsonEncode(array(
                'result' => false,
                'errors' => $validationErrors,
                'exception' => $e,
            )));
        }
    }

    public function ajaxProcessSubmitProductModelRate()
    {
        $validationErrors = array();
        if ($this->tabAccess['add'] === '0') {
            $validationErrors[] = $this->l('You do not have the right permission');
            die(Tools::jsonEncode(
                array(
                    'result' => 'error',
                    'errors' => $validationErrors
                )
            ));
        }
        try {
            $id_roja45_product = Tools::getValue('ROJA45_PRODUCTRENTAL_ID');
            $id_roja45_product_model = Tools::getValue('ROJA45_PRODUCTRENTAL_MODEL_ID');

            $rentalproduct = new ProductRentalDetails($id_roja45_product);
            if (!Validate::isLoadedObject($rentalproduct)) {
                $validationErrors[] = $this->l('The object cannot be loaded.');
                throw new Exception($this->l('The object cannot be loaded.'));
            }

            $model = new ProductRentalModel($id_roja45_product_model);
            if (!Validate::isLoadedObject($model)) {
                $validationErrors[] = $this->l('The model object cannot be loaded.');
                throw new Exception($this->l('The model object cannot be loaded.'));
            }

            $id_roja45_product_rate = Tools::getValue('ROJA45_PRODUCTRENTAL_RATE_ID');
            if ($id_roja45_product_rate > 0) {
                $rate = new ProductRentalRate($id_roja45_product_rate);
            } else {
                $rate = new ProductRentalRate();
                $rate->id_roja45_product = $id_roja45_product;
                $rate->id_parent = $id_roja45_product_model;
            }

            $rate->rate = (float) Tools::getValue('ROJA45_PRODUCTRENTAL_RATE');
            $id_productrental_ratetype = Tools::getValue('ROJA45_PRODUCTRENTAL_RATE_TYPE');
            if ($id_productrental_ratetype > 0) {
                $rate->id_type = $id_productrental_ratetype;
                $rate_type = new ProductRentalRateType($id_productrental_ratetype);
                $rate->name = $rate_type->name;
                $rate->description = $rate_type->description;
            } else {
                $rate->name = '';
                $rate->description = '';
            }

            if ($rate->save()) {
                $groups = Group::getGroups($this->context->language->id);
                $group_ids = explode(',', Tools::getValue('ROJA45_PRODUCTRENTAL_RATE_GROUPS'));
                if (count($groups)) {
                    Db::getInstance()->execute(
                        'DELETE FROM ' . _DB_PREFIX_ . 'roja45_productrental_rategroup 
                        WHERE id_roja45_product_rate=' . (int)$rate->id
                    );
                    $data = array();
                    foreach ($group_ids as $group_id) {
                        $data[] = array(
                            'id_roja45_product_rate' => $rate->id,
                            'id_group' => $group_id
                        );
                    }
                    Db::getInstance()->insert('roja45_productrental_rategroup', $data);
                }

                // TODO - Update price
                $rates = ProductRentalRate::getRates(
                    $id_roja45_product,
                    $id_roja45_product_model,
                    $this->context->language->id
                );
                usort($rates, array($this, 'sortByRateValue'));
                $rate_types = ProductRentalRateType::getRateTypes(
                    (int)$this->context->language->id
                );

                if (Configuration::get('ROJA45_PRODUCTRENTAL_UPDATEPRODUCTPRICE') == 1) {
                    $id_product = Tools::getValue('ROJA45_PRODUCTRENTAL_PRODUCT_ID');
                    $product = new Product($id_product, true);
                    $lowest_rate = ProductRentalRate::getLowestRate($id_roja45_product);
                    if ($lowest_rate) {
                        $product->price = $lowest_rate;
                    } else {
                        $product->price = 0;
                    }
                    $product->save();
                }
                $tpl = $this->context->smarty->createTemplate(
                    $this->getTemplatePath('productrental_rates.tpl').'productrental_rates.tpl'
                );
                $tpl->assign(
                    array(
                        'languages' => $this->context->controller->getLanguages(),
                        'link' => $this->context->link,
                        'productrental_model_rates' => $rates,
                        'rate_types' => $rate_types,
                        'currency' => $this->context->currency,
                    )
                );

                $view = $tpl->fetch();
                die(Tools::jsonEncode(array(
                    'result' => 1,
                    'response' => $this->l('Price Saved Successfully'),
                    'rate' => $rate,
                    'rate_name' => $rate->name[$this->context->language->id],
                    'rates' => $view,
                )));
            } else {
                $validationErrors[] = 'Error adding price period';
                die(Tools::jsonEncode(array(
                    'result' => 0,
                    'errors' => $validationErrors,
                )));
            }
        } catch (Exception $e) {
            $validationErrors = array();
            $validationErrors[] = $e->getMessage();
            $json = Tools::jsonEncode(array(
                'result' => 0,
                'errors' => $validationErrors,
                'exception' => $e,
            ));
            die($json);
        }
    }

    public function ajaxProcessDeleteProductModelRate()
    {
        $validationErrors = array();
        if ($this->tabAccess['delete'] === '0') {
            $validationErrors[] = $this->l('You do not have the right permission');
            die(Tools::jsonEncode(
                array(
                    'result' => 'error',
                    'errors' => $validationErrors
                )
            ));
        }

        try {
            $id_roja45_product = Tools::getValue('ROJA45_PRODUCTRENTAL_ID');
            $id_roja45_product_model = Tools::getValue('ROJA45_PRODUCTRENTAL_MODEL_ID');

            $rentalproduct = new ProductRentalDetails($id_roja45_product);
            if (!Validate::isLoadedObject($rentalproduct)) {
                $validationErrors[] = $this->l('The object cannot be loaded.');
            }
            $model = new ProductRentalModel($id_roja45_product_model);
            if (!Validate::isLoadedObject($model)) {
                $validationErrors[] = $this->l('The model object cannot be loaded.');
            }

            $id_roja45_rate = Tools::getValue('ROJA45_PRODUCTRENTAL_RATE_ID');
            $rate = new ProductRentalRate($id_roja45_rate);
            if (!Validate::isLoadedObject($rate)) {
                $validationErrors[] = $this->l('The rate object cannot be loaded.');
            }

            $result = $rate->delete();
            $result &= ProductRentalPeriodRate::deletePeriodRates($id_roja45_product, $rate->id_type);

            if ($result) {
                $rates = ProductRentalRate::getRates(
                    $id_roja45_product,
                    $id_roja45_product_model,
                    $this->context->language->id
                );
                usort($rates, array($this, 'sortByRateValue'));
                $rate_types = ProductRentalRateType::getRateTypes(
                    (int)$this->context->language->id
                );
                if (Configuration::get('ROJA45_PRODUCTRENTAL_UPDATEPRODUCTPRICE') == 1) {
                    $id_product = Tools::getValue('ROJA45_PRODUCTRENTAL_PRODUCT_ID');
                    $product = new Product($id_product, false, $this->context->language->id);
                    $lowest_rate = ProductRentalRate::getLowestRate($id_roja45_product);
                    if ($lowest_rate) {
                        $product->price = $lowest_rate;
                    } else {
                        $product->price = 0;
                    }
                    $product->save();
                }
                $tpl = $this->context->smarty->createTemplate(
                    $this->getTemplatePath('productrental_rates.tpl').'productrental_rates.tpl'
                );
                $tpl->assign(
                    array(
                        'languages' => $this->context->controller->getLanguages(),
                        'link' => $this->context->link,
                        'productrental_model_rates' => $rates,
                        'rate_types' => $rate_types,
                        'currency' => $this->context->currency,
                    )
                );

                $rates_view = $tpl->fetch();
                $periods = ProductRentalPeriod::getPeriodsForLang((int)$this->context->language->id);
                $period_rates = array();
                if (count($periods)>0) {
                    $period = new ProductRentalPeriod($periods[0]['id_roja45_product_period']);
                    $period_rates = $this->getPeriodRates(
                        $periods,
                        $id_roja45_product,
                        $id_roja45_product_model
                    );
                    $tpl->assign(
                        array(
                            'default_period' => $period,
                            'default_period_name' => $period->name[$this->context->language->id],
                        )
                    );
                }
                $tpl->assign(
                    array(
                        'languages' => $this->context->controller->getLanguages(),
                        'link' => $this->context->link,
                        'period_rates' => $period_rates,
                    )
                );

                $periods_view = $tpl->fetch();
                die(Tools::jsonEncode(array(
                    'result' => 'success',
                    'response' => 'success',
                    'id_rate' => $rate->id_type,
                    'rates' => $rates_view,
                    'periods_view' => $periods_view,
                )));
            } else {
                $validationErrors[] = 'Error deleting price period';
                die(Tools::jsonEncode(array(
                    'result' => 'error',
                    'errors' => $validationErrors,
                )));
            }
        } catch (Exception $e) {
            $validationErrors = array();
            $validationErrors[] = $e->getMessage();
            $json = Tools::jsonEncode(array(
                'result' => 'error',
                'errors' => $validationErrors,
                'exception' => $e,
            ));
            die($json);
        }
    }

    public function ajaxProcessSubmitPeriodRate()
    {
        $validationErrors = array();
        if ($this->tabAccess['add'] === '0') {
            $validationErrors[] = $this->l('You do not have the right permission');
            die(Tools::jsonEncode(
                array(
                    'result' => 'error',
                    'errors' => $validationErrors
                )
            ));
        }
        try {
            $id_roja45_product = Tools::getValue('ROJA45_PRODUCTRENTAL_PROPERTY_ID');
            $rentalproduct = new ProductRentalDetails($id_roja45_product);
            if (!Validate::isLoadedObject($rentalproduct)) {
                $validationErrors[] = $this->l('The object cannot be loaded.');
            }

            die(Tools::jsonEncode(array(
                'result' => true
            )));
        } catch (Exception $e) {
            $validationErrors[] = $e->getMessage();
            $json = Tools::jsonEncode(array(
                'result' => 'error',
                'errors' => $validationErrors,
                'exception' => $e,
            ));
            die($json);
        }
    }

    public function ajaxProcessGetPeriodDetails()
    {
        try {
            $validationErrors = array();
            $period = new ProductRentalPeriod(Tools::getValue('id_period'));
            if ($period->is_recurring) {
                $period->start_date = Tools::substr($period->start_date, 5, Tools::strlen($period->start_date));
                $period->end_date = Tools::substr($period->end_date, 5, Tools::strlen($period->end_date));
            }
            if (Validate::isLoadedObject($period)) {
                die(Tools::jsonEncode(array(
                    'result' => 'success',
                    'id_lang' => $this->context->language->id,
                    'period' => $period,
                )));
            } else {
                $validationErrors[] = $this->l('The period details cannot be loaded.');
                die(Tools::jsonEncode(array(
                    'result' => 'error',
                    'errors' => $validationErrors,
                )));
            }
        } catch (Exception $e) {
            $validationErrors[] = $e->getMessage();
            $json = Tools::jsonEncode(array(
                'result' => error,
                'errors' => $validationErrors,
                'exception' => $e,
            ));
            die($json);
        }
    }

    public function ajaxProcessSubmitProductPeriodRates()
    {
        $validationErrors = array();
        if ($this->tabAccess['add'] === '0') {
            $validationErrors[] = $this->l('You do not have the right permission');
            die(Tools::jsonEncode(
                array(
                    'result' => 'error',
                    'errors' => $validationErrors
                )
            ));
        }
        try {
            $id_roja45_product = Tools::getValue('ROJA45_PRODUCTRENTAL_ID');
            $id_roja45_product_model = Tools::getValue('ROJA45_PRODUCTRENTAL_MODEL_ID');
            $id_roja45_product_rate = Tools::getValue('ROJA45_PRODUCTRENTAL_RATE_ID');
            $id_roja45_product_periodrate = Tools::getValue('ROJA45_PRODUCTRENTAL_PERIOD_RATE_ID');
            $id_roja45_product_period = Tools::getValue('ROJA45_PRODUCTRENTAL_PERIOD_ID');

            $rentalproduct = new ProductRentalDetails($id_roja45_product);
            if (!Validate::isLoadedObject($rentalproduct)) {
                throw new Exception($this->l('The object cannot be loaded.'));
            }

            $model = new ProductRentalModel($id_roja45_product_model);
            if (!Validate::isLoadedObject($model)) {
                throw new Exception($this->l('The model object cannot be loaded.'));
            }

            if ($id_roja45_product_periodrate > 0) {
                $periodrate = new ProductRentalPeriodRate($id_roja45_product_periodrate);
            } else {
                $periodrate = new ProductRentalPeriodRate();
            }

            $periodrate->id_roja45_product = $id_roja45_product;
            $periodrate->id_parent = $model->id_roja45_product_model;
            $ratetype = new ProductRentalRateType($id_roja45_product_rate);

            if (!Validate::isLoadedObject($ratetype)) {
                throw new Exception($this->l('The rate type object cannot be loaded.'));
            }

            if ($id_roja45_product_period > 0) {
                $period = new ProductRentalPeriod($id_roja45_product_period);
                if (!Validate::isLoadedObject($period)) {
                    throw new Exception($this->l('The period object cannot be loaded.'));
                }
                $periodrate->id_roja45_product_period = $id_roja45_product_period;
                $periodrate->start_date = $period->start_date;
                $periodrate->end_date = $period->end_date;
                foreach ($period->name as $key => $period_name) {
                    $periodrate->name[$key] = $period_name;
                }
            } else {
                /* Custom Date */
                $date = DateTime::createFromFormat(
                    'Y-m-d H:i:s',
                    Tools::getValue('ROJA45_PRODUCTRENTAL_PERIOD_START_DATE') . ' 00:00:00'
                );
                $start_date_string = $date->format('Y-m-d');
                $date = DateTime::createFromFormat(
                    'Y-m-d H:i:s',
                    Tools::getValue('ROJA45_PRODUCTRENTAL_PERIOD_END_DATE') . ' 00:00:00'
                );
                $end_date_string = $date->format('Y-m-d');
                $periodrate->id_roja45_product_period = 0;
                $period_names = Tools::getValue('ROJA45_PRODUCTRENTAL_PERIOD_NAME');
                foreach ($period_names as $period_name) {
                    $periodrate->name[key($period_name)] = $period_name[key($period_name)];
                }

                $periodrate->start_date = $start_date_string;
                $periodrate->end_date = $end_date_string;
            }

            $periodrate->id_rate = $id_roja45_product_rate;
            $periodrate->rate = Tools::getValue('ROJA45_PRODUCTRENTAL_PERIOD_RATE');
            $result = $periodrate->save();

            if ($result) {
                $periods = ProductRentalPeriod::getPeriodsForLang((int)$this->context->language->id);
                $period_rates = $this->getPeriodRates($periods, $id_roja45_product, $id_roja45_product_model);
                $tpl = $this->context->smarty->createTemplate(
                    $this->getTemplatePath('productrental_periodrates.tpl').'productrental_periodrates.tpl'
                );
                $tpl->assign(
                    array(
                        'languages' => $this->context->controller->getLanguages(),
                        'link' => $this->context->link,
                        'period_rates' => $period_rates,
                    )
                );
                $view = $tpl->fetch();

                die(Tools::jsonEncode(array(
                    'result' => 'success',
                    'response' => $this->l('Period Rate Saved Successfully'),
                    'html' => $view,
                )));
            } else {
                $validationErrors[] = $this->l('Error adding price period');
                die(Tools::jsonEncode(array(
                    'result' => 'error',
                    'errors' => $validationErrors,
                )));
            }
        } catch (Exception $e) {
            $validationErrors = array();
            $validationErrors[] = $e->getMessage();
            $json = Tools::jsonEncode(array(
                'result' => false,
                'errors' => $validationErrors,
                'exception' => $e,
            ));
            die($json);
        }
    }

    public function ajaxProcessDeletePeriodRate()
    {
        $validationErrors = array();
        if ($this->tabAccess['delete'] === '0') {
            $validationErrors[] = $this->l('You do not have the right permission');
            die(Tools::jsonEncode(
                array(
                    'result' => 'error',
                    'errors' => $validationErrors
                )
            ));
        }
        try {
            $id_roja45_product = Tools::getValue('id_roja45_product');
            if (!isset($id_roja45_product) || $id_roja45_product == 0) {
                $validationErrors[] = $this->l('The id provided is invalid.');
            }

            $id_roja45_product_model = Tools::getValue('id_roja45_product_model');
            $model = new ProductRentalModel($id_roja45_product_model);
            if (!Validate::isLoadedObject($model)) {
                throw new Exception($this->l('The model cannot be loaded.'));
            }

            $id_price_period = Tools::getValue('id_price_period');
            if (!isset($id_roja45_product) || $id_roja45_product == 0) {
                $validationErrors[] = $this->l('The price period id provided is invalid.');
            }

            $priceperiod = new ProductRentalPeriodRate($id_price_period);
            if (!Validate::isLoadedObject($priceperiod)) {
                throw new Exception($this->l('The price period object cannot be loaded.'));
            }

            if (!count($validationErrors)) {
                $result = $priceperiod->delete();
                if ($result) {
                    $tpl = $this->context->smarty->createTemplate(
                        $this->getTemplatePath('productrental_periodrates.tpl').'productrental_periodrates.tpl'
                    );
                    $periods = ProductRentalPeriod::getPeriodsForLang((int)$this->context->language->id);
                    $period_rates = array();
                    if (count($periods)>0) {
                        $period = new ProductRentalPeriod($periods[0]['id_roja45_product_period']);
                        $period_rates = $this->getPeriodRates(
                            $periods,
                            $id_roja45_product,
                            $id_roja45_product_model
                        );
                        $tpl->assign(
                            array(
                                'default_period' => $period,
                                'default_period_name' => $period->name[$this->context->language->id],
                            )
                        );
                    }

                    $tpl->assign(
                        array(
                            'languages' => $this->context->controller->getLanguages(),
                            'link' => $this->context->link,
                            'period_rates' => $period_rates,
                        )
                    );
                    $view = $tpl->fetch();

                    die(Tools::jsonEncode(array(
                        'result' => 'success',
                        'response' => 'success',
                        'html' => $view,
                    )));
                } else {
                    $validationErrors[] = $this->l('Unable to delete price period');
                    die(Tools::jsonEncode(array(
                        'result' => 'error',
                        'errors' => $validationErrors,
                    )));
                }
            } else {
                $validationErrors[] = $this->l('Unable to delete price period.  Function validation errors');
                die(Tools::jsonEncode(array(
                    'result' => 'error',
                    'errors' => $validationErrors,
                )));
            }
        } catch (Exception $e) {
            $validationErrors = array();
            $validationErrors[] = $e->getMessage();
            $json = Tools::jsonEncode(array(
                'result' => false,
                'errors' => $validationErrors,
                'exception' => $e,
            ));
            die($json);
        }
    }

    public function ajaxProcessUpdateRental()
    {
        $validationErrors = array();
        if ($this->tabAccess['edit'] === '0') {
            $validationErrors[] = $this->l('You do not have the right permission');
            die(Tools::jsonEncode(
                array(
                    'result' => 'error',
                    'errors' => $validationErrors
                )
            ));
        }
        try {
            $id_roja45_product_rental = Tools::getValue('id_roja45_product_rental');
            $product_rental = new ProductRentalRental($id_roja45_product_rental);
            $id_roja45_product_rental_status = Tools::getValue('status');
            if (Validate::isLoadedObject($product_rental)) {
                $status = new ProductRentalRentalStatus($id_roja45_product_rental_status);
                if (($status->code==ProductRentalRentalStatus::$DLTD) && (Configuration::get('ROJA45_PRODUCTRENTALS_PERMANENTLYDELETE'))) {
                    if ($product_rental->delete()) {
                        die(Tools::jsonEncode(array(
                            'result' => 'success',
                            'response' => 'success',
                        )));
                    } else {
                        $validationErrors[] = 'Error deleting reservation';
                        die(Tools::jsonEncode(array(
                            'result' => 'error',
                            'errors' => $validationErrors,
                        )));
                    }
                } else {
                    if ($product_rental->save()) {
                        $models = $product_rental->getModels();
                        foreach ($models as $model) {
                            $rental_model = new ProductRentalRentalModel($model['id_roja45_product_rental_model']);
                            $rental_model->save();
                        }
                        $product_rental->setStatus($status->code);
                        die(Tools::jsonEncode(array(
                            'result' => 'success',
                            'response' => 'success',
                        )));
                    } else {
                        $validationErrors[] = 'Error saving rental';
                        die(Tools::jsonEncode(array(
                            'result' => 'error',
                            'errors' => $validationErrors,
                        )));
                    }
                }
            } else {
                $validationErrors[] = 'Error loading rental';
                die(Tools::jsonEncode(array(
                    'result' => 'error',
                    'errors' => $validationErrors,
                )));
            }
        } catch (Exception $e) {
            $validationErrors = array();
            $validationErrors[] = $e->getMessage();
            $json = Tools::jsonEncode(array(
                'result' => false,
                'errors' => $validationErrors,
                'exception' => $e,
            ));
            die($json);
        }
    }

    public function ajaxProcessAddRental()
    {
        $validationErrors = array();
        if ($this->tabAccess['add'] === '0') {
            $validationErrors[] = $this->l('You do not have the right permission');
            die(Tools::jsonEncode(
                array(
                    'result' => 'error',
                    'errors' => $validationErrors
                )
            ));
        }
        try {
            $id_roja45_product = Tools::getValue('id_roja45_product');
            $id_product = Tools::getValue('id_product');
            $id_roja45_product_model = Tools::getValue('id_roja45_product_model');
            $model = new ProductRentalModel($id_roja45_product_model, $this->context->language->id);
            $id_type = Tools::getValue('id_type');
            $start_date = Tools::getValue('start_date');
            $end_date = Tools::getValue('end_date');
            $mysql_date_now = date('Y-m-d H:i:s');

            $date = DateTime::createFromFormat($this->context->language->date_format_lite . ' H:i:s', $start_date . ' 00:00:00');
            $collection_date_db = $date->format('Y-m-d');
            $date = DateTime::createFromFormat($this->context->language->date_format_lite . ' H:i:s', $end_date . ' 00:00:00');
            $return_date_db = $date->format('Y-m-d');

            $rental = new ProductRentalRental();
            $rental->id_roja45_product = $id_roja45_product;
            $rental->type = $id_type;
            $rental->received = $mysql_date_now;
            $rental->last_update = $mysql_date_now;
            $rental->modified = 0;

            if ($rental->save()) {
                $customer_rental_product = new ProductRentalRentalProduct();
                $customer_rental_product->id_roja45_product = $id_roja45_product;
                $customer_rental_product->id_product = $id_product;
                $customer_rental_product->id_roja45_product_rental = $rental->id;
                $customer_rental_product->save();

                $datetime1 = new DateTime($start_date);
                $datetime2 = new DateTime($end_date);
                $interval = $datetime1->diff($datetime2);

                if ($customer_rental_product->addModel(
                    $id_roja45_product_model,
                    $model->id_product_attribute,
                    $collection_date_db,
                    $return_date_db,
                    $interval->format('%a'),
                    1,
                    0.0
                )
                ) {
                    switch ($id_type) {
                        case ProductRentalRental::BOOKING:
                            $border_color = '#7E8DBF';
                            $color = '#99ABEA';
                            $textColor = '#FFFFFF';
                            $title = $model->getModelName($this->context->language->id) . ' [' . $this->l('RESERVED') . ']';
                            break;
                        case ProductRentalRental::UNAVAILABLE:
                            $rental->setStatus(ProductRentalRentalStatus::$UNVL);
                            $border_color = '#A11024';
                            $color = '#EA99A4';
                            $textColor = '#FFFFFF';
                            $title = $model->getModelName($this->context->language->id) . ' [' . $this->l('UNAVAILABLE') . ']';
                            break;
                        case ProductRentalRental::OTHER_BOOKING:
                            $rental->setStatus(ProductRentalRentalStatus::$OTHR);
                            $border_color = '#6D6D6D';
                            $color = '#BBBBBB';
                            $textColor = '#FFFFFF';
                            $title = $model->getModelName($this->context->language->id) . ' [' . $this->l('RESERVED') . ']';
                            break;
                        default:
                            $border_color = '#5173DA';
                            $color = '#99ABEA';
                            $textColor = '#FFFFFF';
                            $title = $model->getModelName($this->context->language->id) . ' [' . $this->l('OTHER') . ']';
                            break;
                    }

                    die(Tools::jsonEncode(
                        array(
                            'result' => 'success',
                            'response' => 'success',
                            'title' => $title,
                            'borderColor' => $border_color,
                            'color' => $color,
                            'textColor' => $textColor,
                            'id' => $rental->id,
                            'id_roja45_product_rental' => $rental->id,
                            'summary' => $title,
                        )
                    ));
                } else {
                    $model->delete();
                    $validationErrors[] = 'Error creating booking.';
                    die(Tools::jsonEncode(array(
                        'result' => 'error',
                        'errors' => $validationErrors,
                    )));
                }
            } else {
                $model->delete();
                $validationErrors[] = 'Error creating booking.';
                die(Tools::jsonEncode(array(
                    'result' => 'error',
                    'errors' => $validationErrors,
                )));
            }
        } catch (Exception $e) {
            $validationErrors = array();
            $validationErrors[] = $e->getMessage();
            $json = Tools::jsonEncode(array(
                'result' => false,
                'errors' => $validationErrors,
                'exception' => $e,
            ));
            die($json);
        }
    }


    /**
     * Submit general configuration details.
     */
    public function ajaxProcessSubmitProductRentalModelExtras()
    {
        $validationErrors = array();
        if ($this->tabAccess['edit'] === '0') {
            $validationErrors[] = $this->l('You do not have the right permission');
            die(Tools::jsonEncode(
                array(
                    'result' => 'error',
                    'errors' => $validationErrors
                )
            ));
        }

        try {
            $id_model = Tools::getValue('ROJA45_PRODUCTRENTAL_MODEL_ID');
            $model = new ProductRentalModel($id_model, $this->context->language->id);
            if ($extra_ids = Tools::getValue('ROJA45_PRODUCTRENTAL_ID_EXTRA')) {
                foreach ($extra_ids as $id) {
                    $id_modelextra = Tools::getValue('ROJA45_PRODUCTRENTAL_ID_MODELEXTRA_'.$id);
                    $rate = Tools::getValue('ROJA45_PRODUCTRENTAL_EXTRA_RATE_'.$id);
                    $enabled = (int)Tools::getValue('ROJA45_PRODUCTRENTAL_EXTRA_ENABLED_'.$id);

                    if ($enabled==1) {
                        if ($id_modelextra && $id_modelextra>0) {
                            $product_model_extra = new ProductRentalModelExtra($id_modelextra);
                        } else {
                            $product_model_extra = new ProductRentalModelExtra();
                        }
                        $product_model_extra->id_roja45_product_extra = $id;
                        $product_model_extra->id_roja45_product_model = $id_model;
                        $product_model_extra->rate = $rate;
                        $product_model_extra->enabled = $enabled;
                        $product_model_extra->save();
                    } else {
                        if ($id_modelextra && $id_modelextra>0) {
                            $product_model_extra = new ProductRentalModelExtra($id_modelextra);
                            $product_model_extra->delete();
                        }
                    }
                }
            }

            $available_addons = ProductRentalExtra::getExtras($this->context->language->id);
            $all_selected = ProductRentalModelExtra::getExtrasForModel(
                $model->id_roja45_product_model,
                $this->context->language->id
            );
            $selected_ids = array();
            $selected_addons = array();
            foreach ($all_selected as $selected) {
                $selected_ids[] = $selected['id_roja45_product_extra'];
                $selected_addons[$selected['id_roja45_product_extra']] = $selected;
            }
            $tpl = $this->context->smarty->createTemplate(
                $this->getTemplatePath('productrental_extras.tpl').'productrental_extras.tpl'
            );
            if (count($available_addons)>0) {
                $tpl->assign(
                    array(
                        'available_addons' => $available_addons,
                        'selected_ids' => $selected_ids,
                        'selected' => $selected_addons,
                    )
                );
            }
            $tpl->assign(
                array(
                    'id_lang' => $this->context->language->id,
                    'languages' => $this->context->controller->getLanguages(),
                    'link' => $this->context->link,
                    'admin_link' => $this->context->link->getAdminLink('AdminProductRental'),
                    'currency' => $this->context->currency,
                )
            );
            $view = $tpl->fetch();
            Roja45ProductRental::clearAllCached();

            $json = Tools::jsonEncode(array(
                'result' => 'success',
                'view' => $view,
                'response' => $this->l('Model Extras Updated Successfully.'),
            ));
            die($json);
        } catch (Exception $e) {
            $validationErrors = array();
            $validationErrors[] = $e->getMessage();
            $json = Tools::jsonEncode(array(
                'result' => 'error',
                'errors' => $validationErrors,
                'msg' => 'Caught exception: ' . $e->getMessage() . "\n",
                'exception' => $e,
            ));
            die($json);
        }
    }

    public function ajaxProcessSubmitRequestPayment()
    {
        $validationErrors = array();
        if ($this->tabAccess['add'] === '0') {
            $validationErrors[] = $this->l('You do not have the right permission');
            die(Tools::jsonEncode(
                array(
                    'result' => 'error',
                    'errors' => $validationErrors
                )
            ));
        }

        try {
            $id_roja45_product_rental = Tools::getValue('id_roja45_product_rental');
            $product_rental = new ProductRentalRental($id_roja45_product_rental);
            if (!Validate::isLoadedObject($product_rental)) {
                throw new Exception('[SubmitRequestPayment] '. $this->l('The reservation could be loaded.'));
            }

            $data = $product_rental->getSummary();
            $result = true;
            $rental_payment = ProductRentalRentalPayment::getNextPayment($product_rental->id_roja45_product_rental);
            if (!$rental_payment->id_roja45_product_rental) {
                $rental_payment->id_roja45_product_rental = $product_rental->id_roja45_product_rental;
                $days = 7;
                $rental_payment->total = $data['total_outstanding'];
                $rental_payment->total_with_tax = $data['total_outstanding_with_tax'];
                $rental_payment->date_due = date('Y-m-d H:i:s', strtotime('+'.$days.' days'));
                $rental_payment->payment_due = 1;
                $rental_payment->id_currency = $product_rental->id_currency;
                $result &= $rental_payment->save();
            }
            $result &= $product_rental->setStatus(ProductRentalRentalStatus::$PAYM);
            if ($result) {
                die(Tools::jsonEncode(
                    array(
                        'result' => 'success',
                        'response' => 'success',
                    )
                ));
            } else {
                $validationErrors[] = $this->l('Unable to update reservation payment.');
                die(Tools::jsonEncode(
                    array(
                        'result' => 'error',
                        'errors' => $validationErrors
                    )
                ));
            }
        } catch (Exception $e) {
            $validationErrors = array();
            $validationErrors[] = $e->getMessage();
            $json = Tools::jsonEncode(array(
                'result' => 'error',
                'errors' => $validationErrors,
                'exception' => $e,
            ));
            die($json);
        }
    }

    private function getPeriodRates($periods, $id_roja45_product, $id_roja45_product_model)
    {
        $price_periods = ProductRentalPeriodRate::getPeriodRatesForLang(
            $id_roja45_product,
            $id_roja45_product_model,
            (int)$this->context->language->id
        );

        $periods_by_id = array();
        foreach ($periods as $period) {
            $periods_by_id[$period['id_roja45_product_period']] = $period;
        }

        $period_prices = array();
        foreach ($price_periods as $price_period) {
            if (isset($price_period['id_roja45_product_period']) && $price_period['id_roja45_product_period'] == 1) {
                $period_price = array();
                $period_price['id_roja45_product_period'] = $price_period['id_roja45_product_period'];
                $period_price['name'] = $periods_by_id[$price_period['id_roja45_product_period']]['name'];
                if ($periods_by_id[$price_period['id_roja45_product_period']]['is_recurring'] == 1) {
                    $period_price['start_date'] = Tools::substr(
                        $periods_by_id[$price_period['id_roja45_product_period']]['start_date'],
                        5,
                        Tools::strlen($periods_by_id[$price_period['id_roja45_product_period']]['start_date'])
                    );
                    $period_price['end_date'] = Tools::substr(
                        $periods_by_id[$price_period['id_roja45_product_period']]['end_date'],
                        5,
                        Tools::strlen($periods_by_id[$price_period['id_roja45_product_period']]['end_date'])
                    );
                } else {
                    $period_price['start_date'] = $periods_by_id[$price_period['id_roja45_product_period']]['start_date'];
                    $period_price['end_date'] = $periods_by_id[$price_period['id_roja45_product_period']]['end_date'];
                }
            } else {
                $period_price['id_roja45_product_period'] = 0;
                $period_price['name'] = $price_period['name'];
                $period_price['start_date'] = $price_period['start_date'];
                $period_price['end_date'] = $price_period['end_date'];
            }

            $period_price['ratetype_name'] = $price_period['ratetype_name'];
            $period_price['id_roja45_product'] = $price_period['id_roja45_product'];
            $period_price['id_roja45_product_model'] = $price_period['id_roja45_product_model'];
            $period_price['id_rate'] = $price_period['id_rate'];
            $period_price['id_roja45_product_periodrate'] = $price_period['id_roja45_product_periodrate'];
            $period_price['rate'] = $price_period['rate'];
            $period_price['description'] = $price_period['description'];
            $period_prices[] = $period_price;
        }

        //usort($period_prices, array($this, 'sortByRateValue'));
        return $period_prices;
    }

    private function sortByRateValue($x, $y)
    {
        return $x['rate'] - $y['rate'];
    }

    private function getModelFieldsValues($model)
    {
        return array(
            'ROJA45_PRODUCTRENTAL_MODEL_ID' => $model->id_roja45_product_model,
            'ROJA45_PRODUCTRENTAL_QTY_AVAILABLE' => $model->qty_available,
            //'ROJA45_PRODUCTRENTAL_MINIMUM_DURATION' => $model->minimum_duration,
            //'ROJA45_PRODUCTRENTAL_PAYMENT_PROFILE_ENABLED' => $model->payment_profile_enabled,
            //'ROJA45_PRODUCTRENTAL_PAYMENTPROFILE' => $model->id_paymentprofile,
            //'ROJA45_PRODUCTRENTAL_RATETYPE' => $model->rate_type,
            //'ROJA45_PRODUCTRENTAL_SERVICE_CHARGE' => $model->service_charge,
            //'ROJA45_PRODUCTRENTAL_SERVICE_CHARGE_TYPE' => $model->service_charge_type,
            //'ROJA45_PRODUCTRENTAL_MINIMUM_RATE' => $model->minimum_rate,
            //'ROJA45_PRODUCTRENTAL_MINIMUM_RATE_ENABLED' => $model->minimum_rate_enabled,
            'ROJA45_PRODUCTRENTAL_NAME' => $model->getModelName(),
            'ROJA45_PRODUCTRENTAL_MODEL_REFERENCE' => $model->reference,
            'ROJA45_PRODUCTRENTAL_DESCRIPTION' => $model->description,
            'ROJA45_PRODUCTRENTAL_MODELENABLED' => $model->enabled,
        );
    }

    /**
     * @param ProductRentalDetails $rentalproduct
     * @return string
     */
    private function buildForm($rentalproduct)
    {
        $html = '';
        $fields_values = array();
        if ($rentalproduct->id > 0) {
            $fields_values['ROJA45_PRODUCTRENTAL_PRODUCT_ID'] = $rentalproduct->id_product;
            $fields_values['ROJA45_PRODUCTRENTAL_ADDRESS'] = $rentalproduct->address;
            $fields_values['ROJA45_PRODUCTRENTAL_ADDRESS_2'] = $rentalproduct->address_2;
            $fields_values['ROJA45_PRODUCTRENTAL_CITY'] = $rentalproduct->city;
            //$fields_values['ROJA45_PRODUCTRENTAL_TYPE'] = $rentalproduct->type;

            if ($rentalproduct->country == 0) {
                $fields_values['ROJA45_PRODUCTRENTAL_COUNTRY'] = (int)$this->context->country->id;
            } else {
                $fields_values['ROJA45_PRODUCTRENTAL_COUNTRY'] = $rentalproduct->country;
            }

            if ($rentalproduct->state == 0) {
                $fields_values['ROJA45_PRODUCTRENTAL_STATE'] = 0;
            } else {
                $fields_values['ROJA45_PRODUCTRENTAL_STATE'] = $rentalproduct->state;
            }

            $fields_values['ROJA45_PRODUCTRENTAL_RESERVATIONSENABLED'] = $rentalproduct->enabled;
            $fields_values['ROJA45_PRODUCTRENTAL_ZIP'] = $rentalproduct->postal_code;
            $fields_values['ROJA45_PRODUCTRENTAL_CONTACT_NUMBER_1'] = $rentalproduct->telephone_1;
            $fields_values['ROJA45_PRODUCTRENTAL_CONTACT_NUMBER_2'] = $rentalproduct->telephone_2;
            $fields_values['ROJA45_PRODUCTRENTAL_URL'] = $rentalproduct->url;
            $fields_values['ROJA45_PRODUCTRENTAL_LAT'] = $rentalproduct->lat;
            $fields_values['ROJA45_PRODUCTRENTAL_LON'] = $rentalproduct->lon;
            $fields_values['ROJA45_PRODUCTRENTAL_EMAIL'] = $rentalproduct->email;
            $fields_values['ROJA45_PRODUCTRENTAL_PAYMENTPROFILE_ID'] = $rentalproduct->id_paymentprofile;
            $fields_values['ROJA45_PRODUCTRENTAL_INSTANTRENTAL'] = $rentalproduct->instant_rental;
            $fields_values['ROJA45_PRODUCTRENTAL_COLLECTIONTIME'] = $rentalproduct->collection_time;
            $fields_values['ROJA45_PRODUCTRENTAL_RETURNTIME'] = $rentalproduct->return_time;
            $fields_values['ROJA45_PRODUCTRENTAL_DAMAGEDEPOSIT'] = $rentalproduct->id_roja45_product_damagedeposit;
            $fields_values['ROJA45_PRODUCTRENTAL_DEFAULTOVERDUERENTALACTION'] = $rentalproduct->id_roja45_product_overdueaction;
            $fields_values['ROJA45_PRODUCTRENTAL_OVERDUEFINE'] = $rentalproduct->overdue_fine;

            if ($rentalproduct->minimum_duration) {
                $fields_values['ROJA45_PRODUCTRENTAL_MINIMUM_DURATION'] = $rentalproduct->minimum_duration;
            } else {
                $fields_values['ROJA45_PRODUCTRENTAL_MINIMUM_DURATION'] = Configuration::get('ROJA45_PRODUCTRENTAL_MINIMUM_DURATION');
            }

            if ($rentalproduct->maximum_duration) {
                $fields_values['ROJA45_PRODUCTRENTAL_MAXIMUM_DURATION'] = $rentalproduct->maximum_duration;
            } else {
                $fields_values['ROJA45_PRODUCTRENTAL_MAXIMUM_DURATION'] = Configuration::get('ROJA45_PRODUCTRENTAL_MAXIMUM_DURATION');
            }
        } else {
            $model = new ProductRentalModel();
            $model->id_roja45_product = $rentalproduct->id;
            $model->name = $this->l('New Model');
            $model->save();
        }

        $messages = array();
        $product = new Product($rentalproduct->id_product, false, $this->context->language->id);

        if (Configuration::get('PS_CATALOG_MODE')) {
            $message = array();
            $message['subject'] = $this->l('Catalog Mode');
            $message['severity'] = 'error';
            $message['message'] = $this->l('Your store is in catalog mode, this will disable the cart system that is required for this module to generate orders.');
            $message['resolution'] = $this->l('You should disable catalog mode.');
            $messages[] = $message;
        }

        $booking_types = array();
        $booking_types[0]['id'] = '1';
        $booking_types[0]['name'] = $this->l('Instant Book');

        $models = ProductRentalModel::getModels(
            $rentalproduct->id,
            (int)$this->context->language->id
        );

        foreach ($models as &$model) {
            $modelObj = new ProductRentalModel($model['id_roja45_product_model']);
            if (empty($model['name'])) {
                $model['name'] = $modelObj->getModelName($this->context->language->id);
            }
        }
        $product_link = $preview_url = $this->context->link->getProductLink(
            $product,
            $product->link_rewrite,
            Category::getLinkRewrite($product->id_category_default, $this->context->language->id),
            null,
            $this->context->language->id,
            (int) $this->context->shop->id,
            0,
            (bool) Configuration::get('PS_REWRITING_SETTINGS')
        );
        $tpl = $this->context->smarty->createTemplate(
            $this->getTemplatePath('rental-product-form.tpl').'rental-product-form.tpl'
        );
        $tpl->assign(
            array(
                'languages' => $this->context->controller->getLanguages(),
                'currency' => $this->context->currency,
                'id_product' => $rentalproduct->id_product,
                'id_lang' => $this->context->language->id,
                'id_lang_default' => $this->context->language->id,
                'id_roja45_product' => $rentalproduct->id,
                'rental_product' => $rentalproduct,
                'defaultFormLanguage' => (int)$this->context->language->id,
                'link_rewrite' => $product->link_rewrite,
                'link' => $this->context->link,
                'product_link' => $product_link,
                'countries' => Country::getCountries($this->context->language->id),
                'fields_value' => $fields_values,
                'productrental_models' => $models,
                'periods' => ProductRentalPeriod::getPeriodsForLang(
                    (int)$this->context->language->id
                ),
                'price_periods' => ProductRentalPeriodRate::getPeriodRatesForLang(
                    $rentalproduct->id,
                    (int)$this->context->language->id
                ),
                'payment_profiles' => ProductRentalPaymentProfile::getPaymentProfilesForLang(
                    (int)$this->context->language->id
                ),
                'damage_deposits' => ProductRentalDamageDeposit::getDamageDeposits(),
                'booking_types' => $booking_types,
                'admin_link' => $this->context->link->getAdminLink('AdminProductRental'),
                'enable_contact' => Configuration::get('ROJA45_PRODUCTRENTAL_HASCONTACT'),
                'enable_address' => Configuration::get('ROJA45_PRODUCTRENTAL_HASADDRESS'),
                'enable_location' => Configuration::get('ROJA45_PRODUCTRENTAL_HASLOCATION'),
                'messages' => $messages,
                'roja45_productrental_dateformat' => RojaFortyFiveProductRentalCore::convertDateFormat(
                    $this->context->language->date_format_lite
                ),
                'data' => Tools::jsonEncode(array(
                    'columns' => array(
                        array('content' => 'ID', 'key' => 'id', 'center' => true),
                        array('content' => 'Email', 'key' => 'email'),
                        array('content' => 'Name', 'key' => 'name'),
                        array('content' => 'Active', 'key' => 'active', 'bool' => true, 'center' => true, 'fa' => true)
                    ),
                    'rows' => array(
                        array('id' => 1, 'email' => 'bob@google.com', 'name' => 'Bob'),
                        array('id' => 2, 'email' => 'john@google.com', 'name' => 'John')
                    ),
                    'rows_actions' => array(
                        array('title' => 'Edit', 'action' => 'edit_employee', 'icon' => 'pencil', 'img' => '../img/admin/edit.gif', 'fa' => 'pencil'),
                        array('title' => 'Delete', 'action' => 'delete_employee', 'icon' => 'trash', 'img' => '../img/admin/delete.gif', 'fa' => 'trash')
                    ),
                    'top_actions' => array(
                        array('title' => 'Add employee', 'action' => 'add_employee', 'icon' => 'add', 'img' => 'themes/default/img/process-icon-new.png', 'fa' => 'plus'),
                    ),
                    'url_params' => array('configure' => 'A Name'),
                    'identifier' => 'id'
                ))
            )
        );

        if ($fields_values['ROJA45_PRODUCTRENTAL_COUNTRY'] > 0) {
            $states = State::getStatesByIdCountry($fields_values['ROJA45_PRODUCTRENTAL_COUNTRY']);
            $tpl->assign(
                array(
                    'states' => $states,
                )
            );
        }

        $html .= $tpl->fetch();
        $tpl = $this->context->smarty->createTemplate(
            $this->getTemplatePath('/prestui/ps-tags.tpl') . 'prestui/ps-tags.tpl'
        );
        $html .= $tpl->fetch();
        return $html;
    }

    private function buildProductSelectForm($object)
    {
        $fields_list = array(
            'id_product' => array(
                'title' => $this->l('ID'),
                'class' => 'fixed-width-xs'
            ),
            'image' => array(
                'title' => $this->l('Image'),
                'align' => 'center',
                'image' => 'p',
                'orderby' => false,
                'filter' => false,
                'search' => false
            ),
            'product_name' => array(
                'title' => $this->l('Product'),
                'width' => 'auto',
                'havingFilter' => true,
            )
        );

        $id_shop = Shop::isFeatureActive() && Shop::getContext() == Shop::CONTEXT_SHOP? (int)$this->context->shop->id : 'a.id_shop_default';
        $sql = new DbQuery();
        $sql->select('a.*, product_lang.name as product_name, image_shop.`id_image` AS `id_image`');
        $sql->from('product', 'a');
        $sql->join('JOIN `'._DB_PREFIX_.'product_shop` sa ON (a.`id_product` = sa.`id_product` AND sa.id_shop = '.$id_shop.')');
        $sql->leftJoin(
            'product_lang',
            'product_lang',
            'a.`id_product` = product_lang.`id_product` AND product_lang.`id_lang` = '.$this->context->language->id . ' AND product_lang.`id_shop` = '.$id_shop
        );
        $sql->leftJoin('shop', 'shop', 'shop.id_shop = '.$id_shop);
        $sql->leftJoin('image_shop', 'image_shop', 'image_shop.`id_product` = a.`id_product` AND image_shop.`cover` = 1 AND image_shop.id_shop = '.$this->context->shop->id);
        $sql->leftJoin('image', 'i', 'i.`id_image` = image_shop.`id_image`');

        // TODO - Need to remove all already enabled rental products from this list
        $products = Db::getInstance()->executeS($sql);
        foreach ($products as $key => $product) {
            if (ProductRentalDetails::isRentable($product['id_product'])) {
                unset($products[$key]);
            }
            if (Configuration::get('ROJA45_PRODUCTRENTAL_IDPRODUCTDEPOSIT') &&
                ($product['id_product'] == Configuration::get('ROJA45_PRODUCTRENTAL_IDPRODUCTDEPOSIT'))) {
                unset($products[$key]);
            }
            if (Configuration::get('ROJA45_PRODUCTRENTAL_IDPRODUCTOTHERPAYMENT') &&
                ($product['id_product'] == Configuration::get('ROJA45_PRODUCTRENTAL_IDPRODUCTOTHERPAYMENT'))) {
                unset($products[$key]);
            }
        }
        $helper = new HelperList();
        if (!is_array($products)) {
            $this->displayWarning($this->l('Bad SQL query', 'Helper').'<br />'.htmlspecialchars($this->_list_error));
            return false;
        }

        if ($this->object && $this->object->id) {
            $helper->id = $this->object->id;
        }

        $helper->title = $this->l('Select Product');
        $helper->toolbar_btn = array(
            'back' =>
                array(
                    'href' => $this->context->link->getAdminLink('AdminProductRental', true).'&token=' . $this->token,
                    'desc' => $this->l('Back to list')
                )
        );
        $helper->currentIndex = $this->context->link->getAdminLink('AdminProductRental', false).'&action=addSelected';
        $helper->token = Tools::getAdminTokenLite('AdminProductRental');
        $helper->show_toolbar = false;
        $helper->toolbar_scroll = false;
        $helper->override_folder = 'product_rental/';
        $helper->actions = array('select');
        $helper->simple_header = true;
        $helper->bulk_actions = null;
        $helper->table = 'product';
        $helper->orderBy = 'id_product';
        $helper->orderWay = 'ASC';
        $helper->listTotal = count($products);
        $helper->shopLink = $this->shopLink;
        $helper->shopLinkType = $this->shopLinkType;
        $helper->identifier = 'id_product';
        $helper->token = $this->token;
        $helper->languages = $this->_languages;
        $helper->imageType = $this->imageType;
        $helper->no_link = true;
        $helper->default_form_language = $this->default_form_language;
        $helper->allow_employee_form_lang = $this->allow_employee_form_lang;
        $helper->list_id = 'id_product';
        $helper->bootstrap = $this->bootstrap;
        $helper->list_skip_actions = $this->list_skip_actions;
        $helper->_default_pagination = $this->_default_pagination;
        $helper->_pagination = $this->_pagination;
        $helper->tpl_vars = array();
        $helper->bulk_actions = array(
            'select' => array(
                'text' => $this->l('Add selected'),
                'confirm' => $this->l('Add all selected items?')
            )
        );

        $helper->is_cms = false;
        $helper->sql = $sql->build();
        return $helper->generateList($products, $fields_list);
    }

    public function displaySelectLink($token, $id)
    {
        $tpl = $this->createTemplate('list_action_select_product.tpl');
        $tpl->assign(array(
            'href' => $this->context->link->getAdminLink('AdminProductRental', true) .'&selectProduct'.$this->table.'=1&token='.$token .'&id_product='.$id,
            'action' => ' Select',
            'id_product' => $id
        ));
        return $tpl->fetch();
    }
}
