<?php
/**
 * productrentals
 *
 * @author    Roja45
 * @copyright 2016 Roja45
 * @license   license.txt
 * @category  productrentals
 *
 * 2016 ROJA45 - All rights reserved.
 *
 * DISCLAIMER
 * Changing this file will render any support provided by us null and void.
 */

/**
 * productrentals
 *
 * @author    Roja45
 * @copyright 2016 Roja45
 * @license   license.txt
 * @category  Class
 *
 * 2016 ROJA45 - All rights reserved.
 *
 * DISCLAIMER
 * Changing this file will render any support provided by us null and void.
 */

class AdminProductRentalsController extends ModuleAdminController
{
    /**
     * Constructor
     */
    public function __construct()
    {
        parent::__construct();
        $this->context = Context::getContext();
        $this->override_folder = 'product_rentals';
        $this->bootstrap = true;
        $this->table = 'roja45_productrental_rental';
        $this->identifier = 'id_roja45_product_rental';
        $this->tpl_folder = 'product_rentals/';
        $this->submit_action = $this->context->link->getAdminLink('AdminProductRentals', true);
        $this->show_cancel_button = true;
        $this->className = 'ProductRentalRental';
        $this->deleted = false;
        $this->colorOnBackground = false;
        $this->bulk_actions = array(
            'delete' => array(
                'text' => $this->l('Delete selected', 'AdminProductRentals'),
                'confirm' => $this->l('Delete selected items?', 'AdminProductRentals')
            ),
            'delete_permanently' => array(
                'text' => $this->l('Permanently delete selected', 'AdminProductRentals'),
                'confirm' => $this->l('Permanently delete selected items?', 'AdminProductRentals')
            )
        );
        //$this->multishop_context = Shop::CONTEXT_ALL;
        $this->_defaultOrderBy = 'id_roja45_product_rental';
        $this->list_id = 'id_roja45_product_rental';
        $this->deleted = false;
        $this->_orderBy = 'id_roja45_product_rental';
        $this->_orderWay = 'DESC';
        $this->list_simple_header = false;

        $this->addRowAction('edit');
        $this->addRowAction('delete');

        $rental_status = ProductRentalRentalStatus::getStates($this->context->language->id);
        $states_array = array();
        foreach ($rental_status as $row) {
            $states_array[$row['id_roja45_product_rental_status']] = $row['status'];
        }

        $shops_array = array();
        foreach (Shop::getShops(true) as $row) {
            $shops_array[$row['id_shop']] = $row['name'];
        }

        $id_shop = Shop::isFeatureActive() && Shop::getContext() == Shop::CONTEXT_SHOP ?
            (int)$this->context->shop->id : Configuration::get('PS_SHOP_DEFAULT');

        $this->_select = '
            CONCAT(c.`firstname`, \' \', c.`lastname`) AS `customer_name`,
            c.email as customer_email,
            rental_status_lang.`status` AS `status_name`,
            shop.id_shop as shop_id,
            shop.name as shop_name,
            rental_status.`color` AS status_color,
            rental_status.`code` AS status_code';

        $this->_join = '
            LEFT JOIN `'._DB_PREFIX_.'customer` c ON (c.`id_customer` = a.`id_customer`)
            LEFT JOIN `'._DB_PREFIX_.'shop` shop ON (shop.id_shop = c.id_shop)
            LEFT JOIN `'._DB_PREFIX_.'roja45_productrental_rentalstatus` rental_status
            ON rental_status.id_roja45_product_rental_status = a.id_roja45_product_rental_status
            LEFT JOIN `'._DB_PREFIX_.'roja45_productrental_rentalstatus_lang` rental_status_lang 
            ON (rental_status.`id_roja45_product_rental_status` = rental_status_lang.`id_roja45_product_rental_status` 
            AND rental_status_lang.`id_lang` = '.(int)$this->context->language->id.')';

        // we add restriction for shop
        if (Shop::getContext() == Shop::CONTEXT_SHOP && Shop::isFeatureActive()) {
            $this->_where = ' AND shop.`id_shop` = ' . (int) $this->context->shop->id;
        }

        $this->fields_list = array(
            'id_roja45_product_rental' => array(
                'title' => $this->l('Id', 'AdminProductRentals'),
                'class' => 'fixed-width-xs',
            ),
            'status_name' => array(
                'title' => $this->l('Status', 'AdminProductRentals'),
                'color' => 'status_color',
                'width' => 'auto',
                'type' => 'select',
                'list' => $states_array,
                'filter_key' => 'a!id_roja45_product_rental_status',
                'filter_type' => 'int',
                'order_key' => 'id_roja45_product_rental_status',
            ),

            'reference' => array(
                'title' => $this->l('Reference', 'AdminProductRentals'),
            ),
            'rental_total' => array(
                'title' => $this->l('Rental Total', 'AdminProductRentals'),
                'type' => 'price',
                'havingFilter' => false,
                'orderby' => false,
                'search' => false,
            ),
            'customer_name' => array(
                'title' => $this->l('Customer', 'AdminProductRentals'),
                'orderby' => true,
                'havingFilter' => true,
            ),
            'customer_email' => array(
                'title' => $this->l('Email', 'AdminProductRentals'),
                'orderby' => false,
                'havingFilter' => true,
            ),
            'date_add' => array(
                'title' => $this->l('Received', 'AdminProductRentals'),
                'orderby' => true,
                'havingFilter' => true,
                'type' => 'datetime',
            ),
        );

        if (Shop::isFeatureActive() && Shop::getContext() != Shop::CONTEXT_SHOP) {
            $this->fields_list['shop_name'] = array(
                'title' => $this->l('Shop', 'AdminProductRentals'),
                'width' => 'auto',
                'type' => 'select',
                'list' => $shops_array,
                'filter_key' => 'shop!shop_id',
                'filter_type' => 'int',
            );
        }
        $this->tabAccess = Profile::getProfileAccess(
            $this->context->employee->id_profile,
            Tab::getIdFromClassName('AdminProductRentals')
        );
    }

    public function initPageHeaderToolbar()
    {
        parent::initPageHeaderToolbar();

        if (empty($this->display)) {
            $this->page_header_toolbar_btn['new_rental'] = array(
                'href' => self::$currentIndex.'&addroja45_productrental_rental&token='.$this->token,
                'desc' => $this->l('Add New Rental', null, null, false),
                'icon' => 'process-icon-new'
            );
        }
    }

    public function initToolbarTitle()
    {
        $this->toolbar_title = is_array($this->breadcrumbs) ? array_unique($this->breadcrumbs) : array($this->breadcrumbs);
        /** @var ProductRentalRental $rental */
        $rental = $this->loadObject(true);
        switch ($this->display) {
            case 'edit':
                $title = $this->l(sprintf('Edit Rental: [%s]', $rental->reference), 'AdminProductRentals');
                $this->toolbar_title[] = $title;
                $this->addMetaTitle($title);
                break;

            case 'add':
                $this->toolbar_title[] = $this->l(
                    'Add New Rental Product',
                    null,
                    null,
                    false
                );
                $this->addMetaTitle($this->l('Add New Rental Product', null, null, false));
                break;
            case 'view':
                $title = $this->l(sprintf('View Rental: [%s]', $rental->reference), 'AdminProductRentals');
                $this->toolbar_title[] = $title;
                $this->addMetaTitle($title);
                break;
        }

        if ($filter = $this->addFiltersToBreadcrumbs()) {
            $this->toolbar_title[] = $filter;
        }
    }

    public function postProcess()
    {
        if ((int)Configuration::get('RJ45DISMOD')) {
            return false;
        }
        if (Tools::isSubmit($this->table . 'Orderby') || Tools::isSubmit($this->table . 'Orderway')) {
            $this->filter = true;
            parent::processFilter();
        } elseif (Tools::isSubmit('delete' . $this->table)) {
            $object = new ProductRentalRental(Tools::getValue($this->identifier));
            if (!Validate::isLoadedObject($object)) {
                $this->errors[] = $this->l('The reservation could not be loaded.', 'AdminProductRentals');
            } else if (!$object->isRemovable()) {
                $this->errors[] = $this->l(
                    'For security reasons, you cannot delete this reservation.',
                    'AdminProductRentals'
                );
            } else if ((int) Configuration::get('ROJA45_PRODUCTRENTAL_PERMANENTLYDELETE')) {
                $object->delete();
            } else {
                $object->setStatus(ProductRentalRentalStatus::$DLTD);
                $object->save();
            }
            $link = $this->context->link->getAdminLink('AdminProductRentals', true).'&token=' . $this->token;
            Tools::redirectAdmin($link);
        } elseif (Tools::isSubmit('submitBulkdelete' . $this->table)) {
            if (Tools::getValue($this->identifier . 'Box')) {
                foreach (Tools::getValue($this->identifier . 'Box') as $selection) {
                    $object = new ProductRentalRental($selection);
                    if (!Validate::isLoadedObject($object)) {
                        $this->errors[] = $this->l(
                            'The reservation could not be loaded.',
                            'AdminProductRentals'
                        );
                    } else if (!$object->isRemovable()) {
                        $this->errors[] = $this->l(
                            'For security reasons, you cannot delete this reservation.',
                            'AdminProductRentals'
                        );
                    } else if ((int) Configuration::get('ROJA45_PRODUCTRENTAL_PERMANENTLYDELETE')) {
                        $object->delete();
                    } else {
                        $object->setStatus(ProductRentalRentalStatus::$DLTD);
                        $object->save();
                    }
                }
            }
            $link = $this->context->link->getAdminLink('AdminProductRentals', true).'&token=' . $this->token;
            Tools::redirectAdmin($link);
        } elseif (Tools::isSubmit('submitBulkdelete_permanently' . $this->table)) {
            if (Tools::getValue($this->identifier . 'Box')) {
                foreach (Tools::getValue($this->identifier . 'Box') as $selection) {
                    $object = new ProductRentalRental($selection);
                    if (!Validate::isLoadedObject($object)) {
                        $this->errors[] = $this->l(
                            'The reservation could not be loaded.',
                            'AdminProductRentals'
                        );
                    }
                    $object->delete();
                }
            }
            $link = $this->context->link->getAdminLink('AdminProductRentals', true).'&token=' . $this->token;
            Tools::redirectAdmin($link);
        } elseif (Tools::isSubmit('submitFilter' . $this->identifier)) {
            $this->filter = true;
            parent::processFilter();
        } elseif (Tools::isSubmit('add' . $this->table)) {
        }

        return parent::postProcess();
    }

    public function getList(
        $id_lang,
        $orderBy = null,
        $orderWay = null,
        $start = 0,
        $limit = null,
        $id_lang_shop = null
    ) {
        parent::getList($id_lang, $orderBy, $orderWay, $start, $limit, $id_lang_shop);
        foreach ($this->_list as &$list_item) {
            $rental = new ProductRentalRental($list_item['id_roja45_product_rental']);
            $totals = $rental->getTotals();
            $list_item['rental_total'] = $totals['total_to_pay_inc'];
        }
    }

    public function renderView()
    {
        if (!($rental = $this->loadObject(true))) {
            return;
        }
        return $this->getRentalForm($rental);
    }

    public function renderForm()
    {
        /** @var ProductRentalRental $rental */
        if (!($rental = $this->loadObject(true))) {
            return;
        }

        if ($this->display == 'add') {
            $rental->date_add = date('Y-m-d H:i:s');
            $rental->id_lang = (int) $this->context->language->id;
            $rental->id_shop = (int) $this->context->shop->id;
            $rental->uid = date('YmdHis').'-'.uniqid().'@'.$_SERVER['SERVER_NAME'];
            $rental->date_upd = date('Y-m-d H:i:s');
            $rental->modified = 0;
            //$rental->save();
            $id_roja45_product_rental_status = ProductRentalRentalStatus::getStatusByType(
                ProductRentalRentalStatus::$ADMN
            );
            $this->id_roja45_product_rental_status = $id_roja45_product_rental_status;
           // $rental->setStatus(ProductRentalRentalStatus::$ADMN);
        }

        return $this->getRentalForm($rental);
    }

    public function setMedia($isNewTheme = false)
    {
        parent::setMedia($isNewTheme);
        if ($this->display &&
            isset($this->tabAccess[$this->display]) &&
            $this->tabAccess[$this->display] == 1 &&
            in_array($this->display, array('add', 'view', 'edit'))
        ) {
            $this->context->controller->addJs(
                _PS_MODULE_DIR_ . $this->module->name . '/views/js/roja45productrentaladmin_rental.js'
            );
            $this->context->controller->addCSS(
                _PS_MODULE_DIR_ . $this->module->name . '/views/css/roja45productrentaladmin.css'
            );
            $this->context->controller->addJqueryUI('ui.dialog');
            /*$this->context->controller->addCss(
                _PS_MODULE_DIR_ . $this->module->name . '/vendor/jquery-confirm/jquery-confirm.min.css'
            );*/
            $this->context->controller->addJS(
                _PS_MODULE_DIR_ . $this->module->name . '/vendor/jquery-confirm/jquery-confirm.min.js'
            );
            $this->context->controller->addJS(
                _PS_MODULE_DIR_ . $this->module->name . '/vendor/riotjs/riot+compiler.min.js'
            );
            $this->context->controller->addCSS(
                _PS_MODULE_DIR_ . $this->module->name . '/vendor/fullcalendar-3.9.0/fullcalendar.css'
            );
            $this->context->controller->addJS(
                _PS_MODULE_DIR_ . $this->module->name . '/vendor/fullcalendar-3.9.0/lib/moment.min.js'
            );
            $this->context->controller->addJS(
                _PS_MODULE_DIR_ . $this->module->name . '/vendor/fullcalendar-3.9.0/fullcalendar.js'
            );
            $this->context->controller->addJS(
                _PS_MODULE_DIR_ .
                $this->module->name .
                '/vendor/fullcalendar-3.9.0/locale/' .
                $this->context->language->iso_code . '.js'
            );
            $this->context->controller->addJqueryUI('ui.datepicker');
            $this->context->controller->addJqueryUI('ui.selectable');
            $this->context->controller->addJS(
                _PS_MODULE_DIR_ . $this->module->name . '/vendor/timepicker/jquery.ui-timepicker-addon.js'
            );
            $this->context->controller->addJS(
                _PS_MODULE_DIR_ .
                $this->module->name .
                '/vendor/timepicker/localization/jquery-ui-timepicker-'.
                Context::getContext()->language->iso_code.'.js'
            );
            $this->context->controller->addCSS(
                _PS_MODULE_DIR_ . $this->module->name . '/vendor/timepicker/jquery.ui-timepicker-addon.css',
                'all'
            );
        }
    }

    public function processUpdateReturned()
    {
        $id_roja45_product_rental_model = Tools::getValue($this->identifier);
        ProductRentalRental::returnModel($id_roja45_product_rental_model);
    }

    public function processDownloadPaymentPDF()
    {
        $validationErrors = array();
        if ($this->tabAccess['edit'] === '0') {
            $validationErrors[] = $this->l('You do not have the right permission', 'AdminProductRentals');
            die(Tools::jsonEncode(
                array(
                    'result' => 0,
                    'errors' => $validationErrors
                )
            ));
        }
        try {
            if (!$id_roja45_product_rental = Tools::getValue('id_roja45_product_rental')) {
                $validationErrors[] = $this->l('Rental Id missing', 'AdminProductRentals');
            }
            if (!$id_roja45_product_rental_payment = Tools::getValue('id_roja45_product_rental_payment')) {
                $validationErrors[] = $this->l('Payment id missing', 'AdminProductRentals');
            }

            if (!count($validationErrors)) {
                $rental = new ProductRentalRental($id_roja45_product_rental);
                if (!Validate::isLoadedObject($rental)) {
                    throw new Exception($this->l('The rental could not be loaded.', 'AdminProductRentals'));
                }

                $payment = new ProductRentalRentalPayment($id_roja45_product_rental_payment);
                if (!Validate::isLoadedObject($payment)) {
                    throw new Exception($this->l(
                        'The rental payment could not be loaded.',
                        'AdminProductRentals'
                    ));
                }

                $order = new Order((int) $payment->id_order);
                if (!Validate::isLoadedObject($order)) {
                    die($this->trans('The order cannot be found within your database.', array(), 'Admin.Orderscustomers.Notification'));
                }
                $order_invoice_list = $order->getInvoicesCollection();
                $pdf = new PDF($order_invoice_list, PDF::TEMPLATE_INVOICE, Context::getContext()->smarty);
                $pdf->render();
                exit;
            }
        } catch (Exception $e) {
            $validationErrors = array();
            $validationErrors[] = $e->getMessage();
        }
    }

    public function ajaxProcessGetProductRentals()
    {
        $validationErrors = array();
        if ($this->tabAccess['view'] === '0') {
            $validationErrors[] = $this->l('You do not have the right permission', 'AdminProductRentals');
            die(Tools::jsonEncode(
                array(
                    'result' => 'error',
                    'errors' => $validationErrors
                )
            ));
        }
        if (!count($validationErrors)) {
            try {
                $id_roja45_product = Tools::getValue('id_roja45_product');
                $id_roja45_product_model = Tools::getValue('id_roja45_product_model');
                if ($id_roja45_product_model) {
                    $rentals = ProductRentalRental::getRentalsForModel(
                        $id_roja45_product,
                        $id_roja45_product_model
                    );
                } else {
                    $rentals = ProductRentalRental::getRentalsForProduct($id_roja45_product);
                }

                $booking_array = array();
                if ($rentals) {
                    $rentalproduct = new ProductRentalDetails($id_roja45_product);
                    foreach ($rentals as $rental) {
                        $rentalObj = new ProductRentalRental($rental['id_roja45_product_rental']);
                        if (!Validate::isLoadedObject($rentalObj)) {
                            break;
                        }

                        foreach ($rentalObj->getProducts() as $product_rental) {
                            if ($product_rental['id_roja45_product'] == $id_roja45_product) {
                                $product_rental = new ProductRentalRentalProduct(
                                    $product_rental['id_roja45_product_rental_product']
                                );
                                $models = ProductRentalRentalModel::getModels(
                                    $product_rental->id_roja45_product_rental_product
                                );
                                foreach ($models as $model) {
                                    $rental_model = new ProductRentalRentalModel(
                                        $model['id_roja45_product_rental_model']
                                    );
                                    $model = new ProductRentalModel($rental_model->id_roja45_product_model);
                                    $dates = $rental_model->getRentalDates();
                                    $collection_date = DateTime::createFromFormat(
                                        'Y-m-d' . ' H:i:s',
                                        $dates['start_date'] . ' 00:00:00'
                                    );
                                    $return_date = DateTime::createFromFormat(
                                        'Y-m-d' . ' H:i:s',
                                        $dates['end_date'] . ' 00:00:00'
                                    );
                                    $calendar_entry_tpl = $this->context->smarty->createTemplate(
                                        $this->getTemplatePath('calendar_entry.tpl') . 'calendar_entry.tpl'
                                    );
                                    $booking_summary_tpl = $this->context->smarty->createTemplate(
                                        $this->getTemplatePath('booking_summary.tpl') . 'booking_summary.tpl'
                                    );
                                    $booking_summary_tpl->assign(
                                        array
                                        (
                                            'order_link' => $this->context->link->getAdminLink(
                                                'AdminOrders',
                                                true
                                            ),
                                            'languages' => $this->context->controller->getLanguages(),
                                            'link' => $this->context->link,
                                            'productrental' => $rentalproduct,
                                            'model_name' => $model->getModelName($this->context->language->id),
                                            'model_qty' => $rental_model->qty,
                                            'roja45_productrental_dateformat' => RojaFortyFiveProductRentalCore::convertDateFormat(
                                                $this->context->language->date_format_lite
                                            ),
                                        )
                                    );

                                    $id_order = $rentalObj->getFirstOrder();
                                    if ($id_order) {
                                        $order = new Order($id_order, $this->context->language->id);
                                        $billing_address = new Address($order->id_address_invoice);
                                        $booking_summary_tpl->assign(
                                            array(
                                                'order' => $order,
                                                'id_order' => $order->id,
                                                'address' => $billing_address,
                                            )
                                        );
                                    }

                                    $customer = new Customer($rental['id_customer']);
                                    if (Validate::isLoadedObject($customer)) {
                                        $calendar_entry_name = $customer->firstname . ' ' . $customer->lastname;
                                    } else {
                                        $calendar_entry_name = $this->l(
                                            'No name provided',
                                            'AdminProductRentals'
                                        );
                                    }

                                    $product = new Product($rentalproduct->id_product, $this->context->language->id);
                                    $title = $rentalObj->reference;

                                    if ($rentalObj->id_roja45_product_rental_status) {
                                        $status = new ProductRentalRentalStatus(
                                            $rentalObj->id_roja45_product_rental_status,
                                            $this->context->language->id
                                        );
                                        $border_color = $status->color;
                                        $color = $status->color;
                                        $title .= ' [' . trim($status->status) . ']';
                                        $textColor = '#FFFFFF';
                                        $calendar_entry_reference = trim($status->status);
                                        $status = trim($status->status);
                                    } else {
                                        $border_color = '#cacaca';
                                        $color = '#e7e7e7';
                                        $textColor = '#808080';
                                        $calendar_entry_reference = $this->l('Unknown Status', 'AdminProductRentals');
                                        $title .= ' [' . $this->l('Unknown Status', 'AdminProductRentals') . ']';
                                        $status = $this->l('Unknown Status', 'AdminProductRentals');
                                    }

                                    $calendar_entry_tpl->assign(
                                        array(
                                            'title' => $title,
                                            'calendar_entry_name' => $calendar_entry_name,
                                            'calendar_entry_reference' => $calendar_entry_reference,
                                        )
                                    );

                                    $description = $calendar_entry_tpl->fetch();
                                    $summary = $rentalObj->getSummary();
                                    $booking_summary_tpl->assign($summary);
                                    $booking_summary_tpl->assign(
                                        array(
                                            'customer' => $customer,
                                            'id_roja45_product_rental' => $rentalObj->id,
                                            //'summary' => $summary,
                                            'product' => $product,
                                            'customer_name' => $calendar_entry_name,
                                            'email' => $customer->email,
                                            //'statuses' => $statuses,
                                            'status' => $status,
                                            'id_status' => $rentalObj->id_roja45_product_rental_status,
                                            'reference' => $rentalObj->reference,
                                            'description' => $description,
                                            'start_date' => $collection_date->format(
                                                $this->context->language->date_format_lite
                                            ),
                                            'end_date' => $return_date->format(
                                                $this->context->language->date_format_lite
                                            ),
                                            'rental' => $rentalObj,
                                            'payments' => ProductRentalRentalPayment::getPayments(
                                                $rentalObj->id_roja45_product_rental
                                            ),
                                            'roja45_productrental_controller' => $this->context->link->getAdminLink(
                                                'AdminProductRentals',
                                                true
                                            )
                                        )
                                    );

                                    $view = $booking_summary_tpl->fetch();
                                    $details = array(
                                        'id' => $rental['id_roja45_product_rental'],
                                        'title' => $title,
                                        'description' => $description,
                                        'allDay' => true,
                                        'start' => $collection_date->format('Y-m-d'),
                                        'end' => $return_date->format('Y-m-d'),
                                        'summary' => $view,
                                        'borderColor' => $border_color,
                                        'color' => $color,
                                        'textColor' => $textColor,
                                        'id_roja45_product' => $rental['id_roja45_product'],
                                        'id_roja45_product_rental' => $rental['id_roja45_product_rental'],
                                    );
                                    array_push($booking_array, $details);
                                }
                            }
                        }
                    }
                    $bookings_enc = Tools::jsonEncode($booking_array);
                    die($bookings_enc);
                } else {
                    $bookings_enc = Tools::jsonEncode($booking_array);
                    die($bookings_enc);
                }
            } catch (Exception $e) {
                $validationErrors = array();
                $validationErrors[] = $e->getMessage();
                $json = Tools::jsonEncode(array(
                    'result' => false,
                    'errors' => $validationErrors,
                    'exception' => $e,
                ));
                die($json);
            }
        } else {
            $validationErrors[] = $this->l(
                'Unable to get product rentals.  Function validation errors',
                'AdminProductRentals'
            );
            die(Tools::jsonEncode(array(
                'result' => 'error',
                'errors' => $validationErrors,
            )));
        }
    }

    public function ajaxProcessGetUnavailable()
    {
        $validationErrors = array();
        if ($this->tabAccess['view'] === '0') {
            $validationErrors[] = $this->l('You do not have the right permission', 'AdminProductRentals');
            die(Tools::jsonEncode(
                array(
                    'result' => 'error',
                    'errors' => $validationErrors
                )
            ));
        }
        try {
            $id_roja45_product = Tools::getValue('id_roja45_product');
            $id_roja45_product_model = Tools::getValue('id_roja45_product_model');
            //$unavailables = ProductUnavailable::getAllUnavailable($id_roja45_product);
            $unavailables = ProductUnavailable::getUnavailable($id_roja45_product, $id_roja45_product_model);
            $unavailable_array = array();
            if ($unavailables) {
                $context = Context::getContext();
                foreach ($unavailables as $unavailable) {
                    $rental_product = new ProductRentalDetails($id_roja45_product, $context->language->id);
                    $product = new Product($rental_product->id_product, false, $context->language->id);
                    $border_color = '#EA99A4';
                    $color = '#EA99A4';
                    $textColor = '#FFFFFF';
                    $calendar_entry_name = $this->l('Dates Unavailable', 'AdminProductRentals');
                    $calendar_entry_reference = $this->l('Dates Unavailable', 'AdminProductRentals');
                    $title = '[' . $this->l('Unavailable', 'AdminProductRentals') . '] ';
                    $title .= $product->name;
                    $status = $this->l('Dates Unavailable', 'AdminProductRentals');
                    $calendar_entry_tpl = $context->smarty->createTemplate(
                        $this->getTemplatePath('calendar_entry.tpl') . 'calendar_entry.tpl'
                    );
                    $booking_summary_tpl = $context->smarty->createTemplate(
                        $this->getTemplatePath('booking_summary.tpl') . 'booking_summary.tpl'
                    );

                    $calendar_entry_tpl->assign(
                        array(
                            'title' => $title,
                            'calendar_entry_name' => $calendar_entry_name,
                            'calendar_entry_reference' => $calendar_entry_reference
                        )
                    );
                    $description = $calendar_entry_tpl->fetch();
                    $booking_summary_tpl->assign(
                        array(
                            'id_roja45_product_unavailable' => $unavailable['id_roja45_product_unavailable'],
                            'unavailable' => 1,
                            'customer_name' => $calendar_entry_name,
                            'description' => $description,
                            'start_date' => $unavailable['start_date'],
                            'end_date' => $unavailable['end_date'],
                            'roja45_productrental_controller' => $this->context->link->getAdminLink(
                                'AdminProductRentals',
                                true
                            ),
                        )
                    );
                    $view = $booking_summary_tpl->fetch();

                    $details = array(
                        'id' => $unavailable['id_roja45_product_unavailable'],
                        'unavailable' => true,
                        'title' => $title,
                        'description' => $description,
                        'allDay' => false,
                        'start' => $unavailable['start_date'] . ' ' . '12:00:00',
                        'end' => $unavailable['end_date'] . ' ' . '12:00:00',
                        'summary' => $view,
                        'borderColor' => $border_color,
                        'color' => $color,
                        'textColor' => $textColor,
                        'id_roja45_product_rental' => $unavailable['id_roja45_product_unavailable'],
                        'id_roja45_product' => $id_roja45_product,
                    );
                    array_push($unavailable_array, $details);
                }
            }
            $unavailable_dates = Tools::jsonEncode($unavailable_array);
            die($unavailable_dates);
        } catch (Exception $e) {
            $validationErrors = array();
            $validationErrors[] = $e->getMessage();
            $json = Tools::jsonEncode(array(
                'result' => false,
                'errors' => $validationErrors,
                'exception' => $e,
            ));
            die($json);
        }
    }

    public function ajaxProcessAddNote()
    {
        $validationErrors = array();
        if ($this->tabAccess['edit'] === '0') {
            $validationErrors[] = $this->l('You do not have the right permission', 'AdminProductRentals');
            die(Tools::jsonEncode(
                array(
                    'result' => 0,
                    'errors' => $validationErrors
                )
            ));
        }
        try {
            if (!$id_roja45_product_rental = Tools::getValue('id_roja45_product_rental')) {
                $validationErrors[] = $this->l('Rental Id missing', 'AdminProductRentals');
            }
            if (!$note = Tools::getValue('note')) {
                $validationErrors[] = $this->l('Note missing', 'AdminProductRentals');
            }

            if (!count($validationErrors)) {
                $rental = new ProductRentalRental($id_roja45_product_rental);
                if (!Validate::isLoadedObject($rental)) {
                    throw new Exception($this->l('The rental could not be loaded.', 'AdminProductRentals'));
                }
                $rental->addNote($note);
                die(Tools::jsonEncode(
                    array(
                        'result' => 1,
                        'refresh' => 1,
                        'redirect' => $this->context->link->getAdminLink(
                            'AdminProductRentals',
                            true
                        ).'&id_roja45_product_rental='.$id_roja45_product_rental.'&view'.$this->table,
                        //'view' => $view,
                        'response' => $this->l('Success', 'AdminProductRentals')
                    )
                ));
            } else {
                $validationErrors[] = $this->l('Validation Errors', 'AdminProductRentals');
                $json = Tools::jsonEncode(array(
                    'result' => 0,
                    'errors' => $validationErrors,
                ));
                die($json);
            }
        } catch (Exception $e) {
            $validationErrors = array();
            $validationErrors[] = $e->getMessage();
            error_log($e->getMessage());
            $json = Tools::jsonEncode(array(
                'result' => 0,
                'errors' => $validationErrors,
                'exception' => $e,
            ));
            die($json);
        }
    }

    public function ajaxProcessDeleteNote()
    {
        $validationErrors = array();
        if ($this->tabAccess['edit'] === '0') {
            $validationErrors[] = $this->l('You do not have the right permission', 'AdminProductRentals');
            die(Tools::jsonEncode(
                array(
                    'result' => 0,
                    'errors' => $validationErrors
                )
            ));
        }
        try {
            if (!$id_roja45_product_rental = Tools::getValue('id_roja45_product_rental')) {
                $validationErrors[] = $this->l('Rental Id missing', 'AdminProductRentals');
            }
            if (!$id_roja45_rental_note = Tools::getValue('id_roja45_rental_note')) {
                $validationErrors[] = $this->l('Note Id missing', 'AdminProductRentals');
            }

            if (!count($validationErrors)) {
                $rental = new ProductRentalRental($id_roja45_product_rental);
                if (!Validate::isLoadedObject($rental)) {
                    throw new Exception($this->l('The rental could not be loaded.', 'AdminProductRentals'));
                }
                if ($rental->deleteNote($id_roja45_rental_note)) {
                    die(Tools::jsonEncode(
                        array(
                            'result' => 1,
                            'redirect' => $this->context->link->getAdminLink(
                                'AdminProductRentals',
                                true
                            ).'&id_roja45_product_rental='.$id_roja45_product_rental.'&viewroja45_productrental_rental',
                            'response' => $this->l('Success', 'AdminProductRentals')
                        )
                    ));
                } else {
                    throw new Exception($this->l(
                        'There were errors while deleting your selection.',
                        'AdminProductRentals'
                    ));
                }
            } else {
                $validationErrors[] = $this->l('Validation Errors', 'AdminProductRentals');
                $json = Tools::jsonEncode(array(
                    'result' => 0,
                    'errors' => $validationErrors,
                ));
                die($json);
            }
        } catch (Exception $e) {
            $validationErrors = array();
            $validationErrors[] = $e->getMessage();
            error_log($e->getMessage());
            $json = Tools::jsonEncode(array(
                'result' => false,
                'errors' => $validationErrors,
                'exception' => $e,
            ));
            die($json);
        }
    }

    public function ajaxProcessSetStatus()
    {
        $validationErrors = array();
        if (!$this->tabAccess['edit']) {
            $validationErrors[] = $this->l('You do not have permission', 'AdminProductRentals');
            die(Tools::jsonEncode(
                array(
                    'result' => 0,
                    'errors' => $validationErrors
                )
            ));
        }
        try {
            $id_roja45_product_rental = Tools::getValue('id_roja45_product_rental');
            $rental = new ProductRentalRental($id_roja45_product_rental);
            if (!Validate::isLoadedObject($rental)) {
                throw new Exception(
                    '[SubmitRequestPayment] '. $this->l('The rental could be loaded.')
                );
            }

            $id_status = Tools::getValue('id_status');
            $status = new ProductRentalRentalStatus($id_status);
            if (!Validate::isLoadedObject($status)) {
                throw new Exception(
                    '[SubmitRequestPayment] '. $this->l(
                        'The reservation status could be loaded.',
                        'AdminProductRentals'
                    )
                );
            }

            if ($id_status === $rental->id_roja45_product_rental_status) {
                die(Tools::jsonEncode(
                    array(
                        'result' => 1,
                        'refresh' => 0,
                        'response' => $this->l('No Change', 'AdminProductRentals'),
                        'redirect' => $this->context->link->getAdminLink(
                            'AdminProductRentals',
                            true
                        ).'&id_roja45_product_rental='.$id_roja45_product_rental.'&view'.$this->table,
                    )
                ));
            }

            if ($rental->setStatus($status->code)) {
                die(Tools::jsonEncode(
                    array(
                        'result' => 1,
                        'refresh' => 1,
                        'response' => $this->l('Success', 'AdminProductRentals'),
                        'redirect' => $this->context->link->getAdminLink(
                            'AdminProductRentals',
                            true
                        ).'&id_roja45_product_rental='.$id_roja45_product_rental.'&view'.$this->table,
                    )
                ));
            } else {
                $validationErrors[] = 'Error';
                die(Tools::jsonEncode(array(
                    'result' => 0,
                    'errors' => $validationErrors,
                )));
            }
        } catch (Exception $e) {
            $validationErrors = array();
            $validationErrors[] = $e->getMessage();
            error_log($e->getMessage());
            $json = Tools::jsonEncode(array(
                'result' => 0,
                'errors' => $validationErrors,
                'exception' => $e,
            ));
            die($json);
        }
    }

    public function ajaxProcessCancelRental()
    {
        $validationErrors = array();
        if ($this->tabAccess['edit'] === '0') {
            $validationErrors[] = $this->l('You do not have the right permission', 'AdminProductRentals');
            die(Tools::jsonEncode(
                array(
                    'result' => 'error',
                    'errors' => $validationErrors
                )
            ));
        }
        try {
            $id_roja45_product_rental = Tools::getValue('id_roja45_product_rental');
            $rental = new ProductRentalRental($id_roja45_product_rental);
            if (!Validate::isLoadedObject($rental)) {
                throw new Exception($this->l('The rental could not be loaded.', 'AdminProductRentals'));
            }
            $rental->setStatus(ProductRentalRentalStatus::$CCLD);
            if ($rental->save()) {
                if ($id_roja45_product_rental_status = ProductRentalRentalStatus::getStatusByType(
                    ProductRentalRentalStatus::$CCLD
                )) {
                    die(Tools::jsonEncode(
                        array(
                            'result' => 'success',
                            'redirect' => $this->context->link->getAdminLink(
                                'AdminProductRentals',
                                true
                            ).'&id_roja45_product_rental='.$id_roja45_product_rental.'&view'.$this->table,
                        )
                    ));
                } else {
                    throw new Exception(
                        $this->l('The rental status could not be loaded.', 'AdminProductRentals')
                    );
                }
            } else {
                throw new Exception(
                    $this->l(
                        'Database Error: ',
                        'AdminProductRentals'
                    ).Db::getInstance()->getMsgError()
                );
            }
        } catch (Exception $e) {
            $validationErrors = array();
            $validationErrors[] = $e->getMessage();
            error_log($e->getMessage());
            $json = Tools::jsonEncode(array(
                'result' => false,
                'errors' => $validationErrors,
                'exception' => $e,
            ));
            die($json);
        }
    }

    public function ajaxProcessProcessRental()
    {
        $validationErrors = array();
        if ($this->tabAccess['edit'] === '0') {
            $validationErrors[] = $this->l('You do not have the right permission', 'AdminProductRentals');
            die(Tools::jsonEncode(
                array(
                    'result' => 'error',
                    'errors' => $validationErrors
                )
            ));
        }
        try {
            $id_roja45_product_rental = Tools::getValue('id_roja45_product_rental');
            $rental = new ProductRentalRental($id_roja45_product_rental);
            if (!Validate::isLoadedObject($rental)) {
                throw new Exception($this->l('The rental could not be loaded.', 'AdminProductRentals'));
            }

            if ($rental->postProcess()) {
                die(Tools::jsonEncode(
                    array(
                        'result' => 'success',
                        'message' => $this->l('The rental has been processed successfully', 'AdminProductRentals'),
                        'redirect' => $this->context->link->getAdminLink(
                            'AdminProductRentals',
                            true
                        ).'&id_roja45_product_rental='.$id_roja45_product_rental.'&view'.$this->table,
                    )
                ));
            } else {
                throw new Exception($this->l('Database Error: ', 'AdminProductRentals').Db::getInstance()->getMsgError());
            }
        } catch (Exception $e) {
            $validationErrors = array();
            $validationErrors[] = $e->getMessage();
            error_log($e->getMessage());
            $json = Tools::jsonEncode(array(
                'result' => false,
                'errors' => $validationErrors,
                'exception' => $e,
            ));
            die($json);
        }
    }

    public function ajaxProcessGetCalendarProductModels()
    {
        $validationErrors = array();
        if ($this->tabAccess['edit'] === '0') {
            $validationErrors[] = $this->l('You do not have the right permission', 'AdminProductRentals');
            die(Tools::jsonEncode(
                array(
                    'result' => 'error',
                    'errors' => $validationErrors
                )
            ));
        }
        try {
            $id_roja45_product = Tools::getValue('id_roja45_product');
            $rental_product = new ProductRentalDetails($id_roja45_product, (int)$this->context->language->id);
            if (Validate::isLoadedObject($rental_product)) {
                $date = DateTime::createFromFormat('Y-m-d H:i:s', Tools::getValue('start_date') . ' 00:00:00');
                $start_date = $date->format($this->context->language->date_format_lite);
                $date = DateTime::createFromFormat('Y-m-d H:i:s', Tools::getValue('end_date') . ' 00:00:00');
                $end_date = $date->format($this->context->language->date_format_lite);
                $models = ProductRentalModel::getModels($id_roja45_product, (int)$this->context->language->id);

                foreach ($models as &$model) {
                    $modelObj = new ProductRentalModel($model['id_roja45_product_model'], $this->context->language->id);
                    $model['name'] = $modelObj->getModelName($this->context->language->id);
                }
                $tpl = $this->context->smarty->createTemplate(
                    $this->getTemplatePath('calendar-modal-popup.tpl') . 'calendar-modal-popup.tpl'
                );
                $tpl->assign(
                    array(
                        'models' => $models,
                        'start_date' => $start_date,
                        'end_date' => $end_date,
                        'roja45_productrental_controller' => $this->context->link->getAdminLink('AdminProductRentals'),
                        'roja45_productrental_dateformat' => RojaFortyFiveProductRentalCore::convertDateFormat(
                            $this->context->language->date_format_lite
                        ),
                    )
                );
                $view = $tpl->fetch();

                die(Tools::jsonEncode(array(
                    'result' => true,
                    'view' => $view,
                )));
            } else {
                die(Tools::jsonEncode(array(
                    'result' => true,
                )));
            }
        } catch (Exception $e) {
            $validationErrors = array();
            $validationErrors[] = $e->getMessage();
            error_log($e->getMessage());
            $json = Tools::jsonEncode(array(
                'result' => false,
                'errors' => $validationErrors,
                'exception' => $e,
            ));
            die($json);
        }
    }

    public function ajaxProcessGetCalendarProductRates()
    {
        $validationErrors = array();
        if ($this->tabAccess['edit'] === '0') {
            $validationErrors[] = $this->l('You do not have the right permission', 'AdminProductRentals');
            die(Tools::jsonEncode(
                array(
                    'result' => 'error',
                    'errors' => $validationErrors
                )
            ));
        }
        try {
            $id_roja45_product = Tools::getValue('id_roja45_product');
            $rental_product = new ProductRentalDetails($id_roja45_product, (int)$this->context->language->id);
            if (Validate::isLoadedObject($rental_product)) {
                $date = DateTime::createFromFormat('Y-m-d H:i:s', Tools::getValue('start_date') . ' 00:00:00');
                $start_date = $date->format($this->context->language->date_format_lite);
                $date = DateTime::createFromFormat('Y-m-d H:i:s', Tools::getValue('end_date') . ' 00:00:00');
                $end_date = $date->format($this->context->language->date_format_lite);
                $models = ProductRentalModel::getModels($id_roja45_product, (int)$this->context->language->id);
                foreach ($models as &$model) {
                    $modelObj = new ProductRentalModel($model['id_roja45_product_model'], $this->context->language->id);
                    $model['name'] = $modelObj->getModelName($this->context->language->id);

                    $rates = ProductRentalRate::getRates(
                        $id_roja45_product,
                        $model['id_roja45_product_model'],
                        $this->context->language->id
                    );
                    foreach ($rates as &$rate) {
                        $rate['rate_formatted'] = Tools::displayPrice(Tools::convertPrice($rate['rate']));
                    }
                    $model['rates'] = $rates;
                }
                $tpl = $this->context->smarty->createTemplate(
                    $this->getTemplatePath('calendar-rates-block.tpl') . 'calendar-rates-block.tpl'
                );
                $tpl->assign(
                    array(
                        'id_roja45_product' => $id_roja45_product,
                        'controller_url' => $this->context->link->getAdminLink('AdminProductRentals', true),
                        'models' => $models,
                        'start_date' => $start_date,
                        'end_date' => $end_date,
                        'roja45_productrental_controller' => $this->context->link->getAdminLink('AdminProductRentals'),
                        'roja45_productrental_dateformat' => RojaFortyFiveProductRentalCore::convertDateFormat(
                            $this->context->language->date_format_lite
                        ),
                    )
                );
                $view = $tpl->fetch();

                die(Tools::jsonEncode(array(
                    'result' => true,
                    'view' => $view,
                )));
            } else {
                die(Tools::jsonEncode(array(
                    'result' => true,
                )));
            }
        } catch (Exception $e) {
            $validationErrors = array();
            $validationErrors[] = $e->getMessage();
            error_log($e->getMessage());
            $json = Tools::jsonEncode(array(
                'result' => false,
                'errors' => $validationErrors,
                'exception' => $e,
            ));
            die($json);
        }
    }

    public function ajaxProcessCreateUnavailable()
    {
        $validationErrors = array();
        if ($this->tabAccess['add'] === '0') {
            $validationErrors[] = $this->l('You do not have the right permission', 'AdminProductRentals');
            die(Tools::jsonEncode(
                array(
                    'result' => 'error',
                    'errors' => $validationErrors
                )
            ));
        }
        try {
            $context = Context::getContext();
            $id_roja45_product = Tools::getValue('id_roja45_product');
            if (!$id_roja45_product) {
                throw new Exception(
                    '[ajaxProcessDeleteUnavailable] '. $this->l(
                        'The rental product could not be loaded.',
                        'AdminProductRentals'
                    )
                );
            }
            $date = DateTime::createFromFormat($context->language->date_format_lite, Tools::getValue('event_start_date'));
            $start_date = $date->format('Y-m-d');
            $date = DateTime::createFromFormat($context->language->date_format_lite, Tools::getValue('event_end_date'));
            $end_date = $date->format('Y-m-d') ;

            $unavailable = new ProductUnavailable();
            $unavailable->id_roja45_product = $id_roja45_product;
            $unavailable->id_roja45_product_model = 0;
            $unavailable->start_date = $start_date;
            $unavailable->end_date = $end_date;

            if ($unavailable->save()) {
                die(Tools::jsonEncode(
                    array(
                        'result' => 1,
                        'response' => $this->l('Success', 'AdminProductRentals'),
                    )
                ));
            }
        } catch (Exception $e) {
            $validationErrors = array();
            $validationErrors[] = $e->getMessage();
            $json = Tools::jsonEncode(array(
                'result' => false,
                'errors' => $validationErrors,
                'exception' => $e,
            ));
            die($json);
        }
    }

    public function ajaxProcessCreatePayment()
    {
        $validationErrors = array();
        if ($this->tabAccess['edit'] === '0') {
            $validationErrors[] = $this->l('You do not have the right permission', 'AdminProductRentals');
            die(Tools::jsonEncode(
                array(
                    'result' => 0,
                    'errors' => $validationErrors
                )
            ));
        }
        try {
            $id_roja45_product_rental = Tools::getValue('id_roja45_product_rental');
            $request_amount = Tools::getValue('request_amount');
            $date_due = Tools::getValue('due_date');
            $date_due = DateTime::createFromFormat(
                $this->context->language->date_format_lite . ' H:i:s',
                $date_due . ' 00:00:00'
            );
            $date_due = $date_due->format('Y-m-d H:i:s');

            $rental = new ProductRentalRental($id_roja45_product_rental);
            if (!Validate::isLoadedObject($rental)) {
                throw new Exception(
                    '[ajaxProcessCreatePayment] '. $this->l(
                        'The rental could be loaded.',
                        'AdminProductRentals'
                    )
                );
            }

            //$id_customer = $rental->id_customer;
            $customer = new Customer((int)$rental->id_customer);
            $addresses = $customer->getAddresses((int)$this->context->language->id);
            //$address = $addresses[0];

            if (!count($addresses)) {
                $address = new Address();
                $address->id_country = Configuration::get('PS_COUNTRY_DEFAULT');
                $address->id_state = 0;
                $address->lastname = $customer->lastname;
                $address->firstname = $customer->firstname;
                $address->city = $this->l('UNKNOWN', 'AdminProductRentals');
                $address->address1 = $this->l('UNKNOWN', 'AdminProductRentals');
                $address->alias = $this->l('SYSTEM GENERATED', 'AdminProductRentals');
            } else {
                $address = Address::initialize($addresses[0]['id_address'], true);
            }
            $new_payment = new ProductRentalRentalPayment();
            $new_payment->id_roja45_product_rental = $rental->id;
            $new_payment->id_roja45_product_payment_type = Tools::getValue('id_roja45_product_payment_type');
            $new_payment->note = Tools::getValue('note');
            $new_payment->payment_due = 0;
            $new_payment->date_due = $date_due;
            $new_payment->requested = 0;
            $new_payment->total = Tools::convertPrice($request_amount, $rental->id_currency, false);
            if ($new_payment->save()) {
                $products = $rental->getProducts();
                $tax_applied = 0;
                foreach ($products as $product) {
                    $id_tax_rules_group = Product::getIdTaxRulesGroupByIdProduct(
                        (int) $product['id_product'],
                        $this->context
                    );
                    $product_tax_calculator = TaxManagerFactory::getManager(
                        $address,
                        $id_tax_rules_group
                    )->getTaxCalculator();

                    $models = ProductRentalRentalModel::getModels($product['id_roja45_product_rental_product']);
                    foreach ($models as $model) {
                        $payments = $rental->getPaymentsForModel(
                            $product['id_product'],
                            $model['id_product_attribute']
                        );
                        $total_paid = 0;
                        foreach ($payments as $payment) {
                            $payment_item = new ProductRentalRentalPaymentItem(
                                $payment['id_roja45_product_rental_payment_item']
                            );
                            $total_paid += (float) $payment_item->total_paid;
                        }
                        $outstanding = $model['total'] - $total_paid;
                        $amount_to_apply = 0;
                        if ($outstanding && $outstanding<=$request_amount) {
                            $amount_to_apply = $outstanding;
                            $request_amount = $request_amount - $outstanding;
                        } else if ($outstanding && $outstanding>$request_amount) {
                            $amount_to_apply = $request_amount;
                            $request_amount = 0;
                        }

                        if ($amount_to_apply) {
                            $payment_item = new ProductRentalRentalPaymentItem();
                            $payment_item->id_roja45_product_rental_payment = $new_payment->id;
                            $payment_item->id_product = $product['id_product'];
                            $payment_item->id_product_attribute = $model['id_product_attribute'];
                            $payment_item->total_paid = $amount_to_apply;
                            $payment_item->save();
                            $tax_applied += ($product_tax_calculator->addTaxes($amount_to_apply) - $amount_to_apply);
                        }
                    }
                }
                $new_payment->total_with_tax = $new_payment->total + $tax_applied;
                $new_payment->save();
                die(Tools::jsonEncode(
                    array(
                        'result' => 1,
                        'response' => $this->l('Success', 'AdminProductRentals'),
                        'redirect' => $this->context->link->getAdminLink(
                            'AdminProductRentals',
                            true
                        ).'&id_roja45_product_rental='.$rental->id.'&viewroja45_productrental_rental',
                    )
                ));
            } else {
                $validationErrors[] = $this->l('Unable to update reservation payment.', 'AdminProductRentals');
                die(Tools::jsonEncode(
                    array(
                        'result' => 0,
                        'errors' => $validationErrors,
                        'redirect' => $this->context->link->getAdminLink(
                            'AdminProductRentals',
                            true
                        ).'&id_roja45_product_rental='.$rental->id.'&viewroja45_productrental_rental',
                    )
                ));
            }
        } catch (Exception $e) {
            $validationErrors = array();
            $validationErrors[] = $e->getMessage();
            error_log($e->getMessage());
            $json = Tools::jsonEncode(array(
                'result' => 0,
                'errors' => $validationErrors,
                'exception' => $e,
            ));
            die($json);
        }
    }

    public function ajaxProcessCreateOtherPayment()
    {
        $validationErrors = array();
        if ($this->tabAccess['edit'] === '0') {
            $validationErrors[] = $this->l('You do not have the right permission', 'AdminProductRentals');
            die(Tools::jsonEncode(
                array(
                    'result' => 0,
                    'errors' => $validationErrors
                )
            ));
        }
        try {
            $id_roja45_product_rental = Tools::getValue('id_roja45_product_rental');
            $request_amount = Tools::getValue('request_amount');
            $date_due = Tools::getValue('due_date');
            $date_due = DateTime::createFromFormat(
                $this->context->language->date_format_lite . ' H:i:s',
                $date_due . ' 00:00:00'
            );
            $date_due = $date_due->format('Y-m-d H:i:s');

            $rental = new ProductRentalRental($id_roja45_product_rental);
            if (!Validate::isLoadedObject($rental)) {
                throw new Exception(
                    '[ajaxProcessCreatePayment] '. $this->l(
                        'The rental could be loaded.',
                        'AdminProductRentals'
                    )
                );
            }

            $customer = new Customer((int)$rental->id_customer);
            $addresses = $customer->getAddresses((int)$this->context->language->id);
            if (!count($addresses)) {
                $address = new Address();
                $address->id_country = Configuration::get('PS_COUNTRY_DEFAULT');
                $address->id_state = 0;
                $address->lastname = $customer->lastname;
                $address->firstname = $customer->firstname;
                $address->city = $this->l('UNKNOWN', 'AdminProductRentals');
                $address->address1 = $this->l('UNKNOWN', 'AdminProductRentals');
                $address->alias = $this->l('SYSTEM GENERATED', 'AdminProductRentals');
            } else {
                $address = Address::initialize($addresses[0]['id_address'], true);
            }
            $id_tax_rules_group = Product::getIdTaxRulesGroupByIdProduct(
                (int) Configuration::get('ROJA45_PRODUCTRENTAL_IDPRODUCTOTHERPAYMENT'),
                $this->context
            );
            $product_tax_calculator = TaxManagerFactory::getManager(
                $address,
                $id_tax_rules_group
            )->getTaxCalculator();
            $new_payment = new ProductRentalRentalPayment();
            $new_payment->id_roja45_product_rental = $rental->id;
            $new_payment->id_roja45_product_payment_type = Tools::getValue('id_roja45_product_payment_type');
            $new_payment->note = Tools::getValue('note');
            $new_payment->payment_due = 0;
            $new_payment->date_due = $date_due;
            $new_payment->requested = 0;
            $new_payment->total = Tools::convertPrice($request_amount, $rental->id_currency, false);
            $new_payment->total_with_tax = $product_tax_calculator->addTaxes($request_amount);
            if ($new_payment->save()) {
                $payment_item = new ProductRentalRentalPaymentItem();
                $payment_item->id_roja45_product_rental_payment = $new_payment->id;
                $payment_item->id_product = Configuration::get('ROJA45_PRODUCTRENTAL_IDPRODUCTOTHERPAYMENT');
                $payment_item->id_product_attribute = 0;
                $payment_item->total_paid = $request_amount;
                $payment_item->save();
                die(Tools::jsonEncode(
                    array(
                        'result' => 1,
                        'response' => $this->l('Success', 'AdminProductRentals'),
                        'redirect' => $this->context->link->getAdminLink(
                            'AdminProductRentals',
                            true
                        ).'&id_roja45_product_rental='.$rental->id.'&viewroja45_productrental_rental',
                    )
                ));
            } else {
                $validationErrors[] = $this->l('Unable to update reservation payment.', 'AdminProductRentals');
                die(Tools::jsonEncode(
                    array(
                        'result' => 0,
                        'errors' => $validationErrors,
                        'redirect' => $this->context->link->getAdminLink(
                            'AdminProductRentals',
                            true
                        ).'&id_roja45_product_rental='.$rental->id.'&viewroja45_productrental_rental',
                    )
                ));
            }
        } catch (Exception $e) {
            $validationErrors = array();
            $validationErrors[] = $e->getMessage();
            error_log($e->getMessage());
            $json = Tools::jsonEncode(array(
                'result' => 0,
                'errors' => $validationErrors,
                'exception' => $e,
            ));
            die($json);
        }
    }

    public function ajaxProcessDeletePayment()
    {
        $validationErrors = array();
        if ($this->tabAccess['edit'] === '0') {
            $validationErrors[] = $this->l('You do not have the right permission', 'AdminProductRentals');
            die(Tools::jsonEncode(
                array(
                    'result' => 0,
                    'errors' => $validationErrors
                )
            ));
        }
        try {
            if (!$id_roja45_product_rental = Tools::getValue('id_roja45_product_rental')) {
                $validationErrors[] = $this->l('Rental Id missing', 'AdminProductRentals');
            }
            if (!$id_roja45_product_rental_payment = Tools::getValue('id_roja45_product_rental_payment')) {
                $validationErrors[] = $this->l('Payment id missing', 'AdminProductRentals');
            }

            if (!count($validationErrors)) {
                $rental = new ProductRentalRental($id_roja45_product_rental);
                if (!Validate::isLoadedObject($rental)) {
                    throw new Exception($this->l('The rental could not be loaded.', 'AdminProductRentals'));
                }

                $payment = new ProductRentalRentalPayment($id_roja45_product_rental_payment);
                if (!Validate::isLoadedObject($payment)) {
                    throw new Exception($this->l(
                        'The rental payment could not be loaded.',
                        'AdminProductRentals'
                    ));
                }
                if ($payment->delete()) {
                    die(Tools::jsonEncode(
                        array(
                            'result' => 1,
                            'redirect' => $this->context->link->getAdminLink(
                                'AdminProductRentals',
                                true
                            ) .'&id_roja45_product_rental='.$rental->id.'&viewroja45_productrental_rental',
                            //'view' => $view,
                            'response' => $this->l('Success', 'AdminProductRentals')
                        )
                    ));
                } else {
                    throw new Exception($this->l(
                        'There were errors while deleting your selection.',
                        'AdminProductRentals'
                    ));
                }
            } else {
                $validationErrors[] = $this->l('Validation Errors', 'AdminProductRentals');
                $json = Tools::jsonEncode(array(
                    'result' => 0,
                    'errors' => $validationErrors,
                ));
                die($json);
            }
        } catch (Exception $e) {
            $validationErrors = array();
            $validationErrors[] = $e->getMessage();
            error_log($e->getMessage());
            $json = Tools::jsonEncode(array(
                'result' => 0,
                'errors' => $validationErrors,
                'exception' => $e,
            ));
            die($json);
        }
    }

    public function ajaxProcessRequestPayment()
    {
        $validationErrors = array();
        if ($this->tabAccess['edit'] === '0') {
            $validationErrors[] = $this->l('You do not have the right permission', 'AdminProductRentals');
            die(Tools::jsonEncode(
                array(
                    'result' => 0,
                    'errors' => $validationErrors
                )
            ));
        }
        try {
            if (!$id_roja45_product_rental = Tools::getValue('id_roja45_product_rental')) {
                $validationErrors[] = $this->l('Rental Id missing', 'AdminProductRentals');
            }
            if (!$id_roja45_product_rental_payment = Tools::getValue('id_roja45_product_rental_payment')) {
                $validationErrors[] = $this->l('Payment Id missing', 'AdminProductRentals');
            }

            if (!count($validationErrors)) {
                $rental = new ProductRentalRental($id_roja45_product_rental);
                if (!Validate::isLoadedObject($rental)) {
                    throw new Exception(
                        '[SubmitRequestPayment] ' . $this->l(
                            'The rental could be loaded.',
                            'AdminProductRentals'
                        )
                    );
                }
                if (!$rental->isPreReserved() && !$rental->isConfirmed()) {
                    die(Tools::jsonEncode(
                        array(
                            'result' => false,
                            'errors' => array(
                                $this->l(
                                    'Rental needs to be pre-reserved or confirmed to make payments.',
                                    'AdminProductRentals'
                                )
                            )
                        )
                    ));
                }

                $payment = new ProductRentalRentalPayment($id_roja45_product_rental_payment);
                $payment->payment_due = 1;
                $payment->requested = 1;
                $payment->date_requested = date('Y-m-d H:i:s');
                if ($payment->save() && $rental->setStatus(ProductRentalRentalStatus::$PAYM)) {
                    die(Tools::jsonEncode(
                        array(
                            'result' => 1,
                            'response' => $this->l('Success', 'AdminProductRentals'),
                            'redirect' => $this->context->link->getAdminLink(
                                'AdminProductRentals',
                                true
                            ) . '&id_roja45_product_rental='.$rental->id.'&viewroja45_productrental_rental',
                        )
                    ));
                } else {
                    die(Tools::jsonEncode(
                        array(
                            'result' => 1,
                            'response' => $this->l(
                                'Updated - Unable to send customer email.',
                                'AdminProductRentals'
                            ),
                            'redirect' => $this->context->link->getAdminLink(
                                'AdminProductRentals',
                                true
                            ) . '&id_roja45_product_rental='.$rental->id.'&viewroja45_productrental_rental',
                        )
                    ));
                }
            } else {
                $validationErrors[] = $this->l('Validation Errors', 'AdminProductRentals');
                $json = Tools::jsonEncode(array(
                    'result' => 0,
                    'errors' => $validationErrors,
                ));
                die($json);
            }
        } catch (Exception $e) {
            $validationErrors = array();
            $validationErrors[] = $e->getMessage();
            error_log($e->getMessage());
            $json = Tools::jsonEncode(array(
                'result' => 0,
                'errors' => $validationErrors,
                'exception' => $e,
            ));
            die($json);
        }
    }

    public function ajaxProcessPreReserveRental()
    {
        $validationErrors = array();
        if ($this->tabAccess['edit'] === '0') {
            $validationErrors[] = $this->l('You do not have the right permission', 'AdminProductRentals');
            die(Tools::jsonEncode(
                array(
                    'result' => 0,
                    'errors' => $validationErrors
                )
            ));
        }
        try {
            if (!$id_roja45_product_rental = Tools::getValue('id_roja45_product_rental')) {
                $validationErrors[] = $this->l('Rental Id missing', 'AdminProductRentals');
            }

            if (!count($validationErrors)) {
                $rental = new ProductRentalRental($id_roja45_product_rental);
                if (!Validate::isLoadedObject($rental)) {
                    throw new Exception(
                        '[SubmitRequestPayment] ' . $this->l(
                            'The rental could be loaded.',
                            'AdminProductRentals'
                        )
                    );
                }
                if ($rental->setStatus(ProductRentalRentalStatus::$PRES)) {
                    die(Tools::jsonEncode(
                        array(
                            'result' => 1,
                            'response' => $this->l('Rental pre-reserved successfully.', 'AdminProductRentals'),
                            'redirect' => $this->context->link->getAdminLink(
                                'AdminProductRentals',
                                true
                            ) . '&id_roja45_product_rental='.$rental->id.'&viewroja45_productrental_rental',
                        )
                    ));
                } else {
                    $validationErrors[] = $this->l('Unable to update status.', 'AdminProductRentals');
                    die(Tools::jsonEncode(
                        array(
                            'result' => 0,
                            'errors' => $validationErrors
                        )
                    ));
                }
            } else {
                $validationErrors[] = $this->l('Validation Errors', 'AdminProductRentals');
                $json = Tools::jsonEncode(array(
                    'result' => 0,
                    'errors' => $validationErrors,
                ));
                die($json);
            }
        } catch (Exception $e) {
            $validationErrors = array();
            $validationErrors[] = $e->getMessage();
            error_log($e->getMessage());
            $json = Tools::jsonEncode(array(
                'result' => 0,
                'errors' => $validationErrors,
                'exception' => $e,
            ));
            die($json);
        }
    }

    public function ajaxProcessConfirmRental()
    {
        $validationErrors = array();
        if ($this->tabAccess['edit'] === '0') {
            $validationErrors[] = $this->l('You do not have the right permission', 'AdminProductRentals');
            die(Tools::jsonEncode(
                array(
                    'result' => 0,
                    'errors' => $validationErrors
                )
            ));
        }
        try {
            if (!$id_roja45_product_rental = Tools::getValue('id_roja45_product_rental')) {
                $validationErrors[] = $this->l('Rental Id missing', 'AdminProductRentals');
            }

            if (!count($validationErrors)) {
                $rental = new ProductRentalRental($id_roja45_product_rental);
                if (!Validate::isLoadedObject($rental)) {
                    throw new Exception(
                        '[SubmitRequestPayment] ' . $this->l(
                            'The rental could be loaded.',
                            'AdminProductRentals'
                        )
                    );
                }
                if ($rental->setStatus(ProductRentalRentalStatus::$CONF)) {
                    die(Tools::jsonEncode(
                        array(
                            'result' => 1,
                            'response' => $this->l(
                                'Reservation confirmed successfully.',
                                'AdminProductRentals'
                            ),
                            'redirect' => $this->context->link->getAdminLink(
                                'AdminProductRentals',
                                true
                            ) . '&id_roja45_product_rental='.$rental->id.'&viewroja45_productrental_rental',
                        )
                    ));
                } else {
                    $validationErrors[] = $this->l(
                        'Unable to update status.',
                        'AdminProductRentals'
                    );
                    die(Tools::jsonEncode(
                        array(
                            'result' => 0,
                            'errors' => $validationErrors
                        )
                    ));
                }
            } else {
                $validationErrors[] = $this->l('Validation Errors', 'AdminProductRentals');
                $json = Tools::jsonEncode(array(
                    'result' => 0,
                    'errors' => $validationErrors,
                ));
                die($json);
            }
        } catch (Exception $e) {
            $validationErrors = array();
            $validationErrors[] = $e->getMessage();
            error_log($e->getMessage());
            $json = Tools::jsonEncode(array(
                'result' => 0,
                'errors' => $validationErrors,
                'exception' => $e,
            ));
            die($json);
        }
    }

    public function ajaxProcessDeleteRental()
    {
        $validationErrors = array();
        if ($this->tabAccess['edit'] === '0') {
            $validationErrors[] = $this->l('You do not have the right permission', 'AdminProductRentals');
            die(Tools::jsonEncode(
                array(
                    'result' => 'error',
                    'errors' => $validationErrors
                )
            ));
        }
        try {
            if (!$id_roja45_product_rental = Tools::getValue('id_roja45_product_rental')) {
                $validationErrors[] = $this->l('Rental Id missing', 'AdminProductRentals');
            }

            if (!count($validationErrors)) {
                $rental = new ProductRentalRental($id_roja45_product_rental);
                if (!Validate::isLoadedObject($rental)) {
                    throw new Exception(
                        '[SubmitRequestPayment] ' . $this->l(
                            'The rental could be loaded.',
                            'AdminProductRentals'
                        )
                    );
                }
                if ($rental->setStatus(ProductRentalRentalStatus::$DLTD)) {
                    die(Tools::jsonEncode(
                        array(
                            'result' => 1,
                            'response' => $this->l(
                                'Reservation marked as deleted.',
                                'AdminProductRentals'
                            ),
                            'redirect' => $this->context->link->getAdminLink(
                                'AdminProductRentals',
                                true
                            ) . '&id_roja45_product_rental='.$rental->id.'&viewroja45_productrental_rental',
                        )
                    ));
                } else {
                    $validationErrors[] = $this->l(
                        'Unable to update status.',
                        'AdminProductRentals'
                    );
                    die(Tools::jsonEncode(
                        array(
                            'result' => 0,
                            'errors' => $validationErrors
                        )
                    ));
                }
            } else {
                $validationErrors[] = $this->l('Validation Errors', 'AdminProductRentals');
                $json = Tools::jsonEncode(array(
                    'result' => 0,
                    'errors' => $validationErrors,
                ));
                die($json);
            }
        } catch (Exception $e) {
            $validationErrors = array();
            $validationErrors[] = $e->getMessage();
            error_log($e->getMessage());
            $json = Tools::jsonEncode(array(
                'result' => 0,
                'errors' => $validationErrors,
                'exception' => $e,
            ));
            die($json);
        }
    }

    public function ajaxProcessCreateOrder()
    {
        $validationErrors = array();
        try {
            if (!$id_roja45_product_rental = Tools::getValue('id_roja45_product_rental')) {
                $validationErrors[] = $this->l('Rental Id missing');
            }
            if (!$id_roja45_product_payment = Tools::getValue('id_roja45_product_payment')) {
                $validationErrors[] = $this->l('Payment Id missing');
            }
            if (!$amount_paid = Tools::getValue('amount_paid')) {
                $validationErrors[] = $this->l('Payment total missing');
            }

            $rental = new ProductRentalRental($id_roja45_product_rental);
            if (!Validate::isLoadedObject($rental)) {
                throw new Exception(
                    '[SubmitRequestPayment] ' . $this->l(
                        'The rental could be loaded.',
                        'AdminProductRentals'
                    )
                );
            }

            $id_currency = Tools::getValue('id_currency');
            if (!Tools::strlen($id_currency) > 0) {
                throw new Exception($this->l('You must provide a payment currency.', 'AdminProductRentals'));
            }

            $payment_method = Tools::getValue('payment_method');
            if (!Tools::strlen($payment_method) > 0) {
                throw new Exception($this->l('You must provide a payment method.', 'AdminProductRentals'));
            }

            $id_order_state = Tools::getValue('id_order_status');
            if (!Tools::strlen($id_order_state) > 0) {
                throw new Exception($this->l('You must provide an order status.', 'AdminProductRentals'));
            }

            if (!$rental->isPreReserved() && !$rental->isConfirmed()) {
                throw new Exception($this->l(
                    'Rental needs to be pre-reserved or confirmed to make payments.',
                    'AdminProductRentals'
                ));
            }

            if (!count($validationErrors)) {
                $id_customer = $rental->id_customer;
                $customer = new Customer((int)$id_customer);
                $this->context->customer = $customer;
                $this->context->cart = new Cart();
                $this->context->cart->recyclable = 0;
                $this->context->cart->gift = 0;
                $this->context->cart->id_customer = $id_customer;

                if (Validate::isLoadedObject($this->context->cart) && $this->context->cart->OrderExists()) {
                    throw new Exception(
                        $this->l('An order already exists for this cart.', 'AdminProductRentals')
                    );
                }
                if (!Validate::isLoadedObject($customer)) {
                    throw new Exception(
                        $this->l('The order customer does not have an account.', 'AdminProductRentals')
                    );
                }
                if (!$this->context->cart->secure_key) {
                    $this->context->cart->secure_key = $this->context->customer->secure_key;
                }
                if (!$this->context->cart->id_shop) {
                    $this->context->cart->id_shop = (int)$this->context->shop->id;
                }
                if (!$this->context->cart->id_lang) {
                    $this->context->cart->id_lang = (($id_lang = (int)Tools::getValue('id_lang')) ? $id_lang : Configuration::get('PS_LANG_DEFAULT'));
                }
                $this->context->cart->id_currency = ($id_currency ? $id_currency : Configuration::get('PS_CURRENCY_DEFAULT'));
                $addresses = $customer->getAddresses((int)$this->context->cart->id_lang);
                if (!count($addresses)) {
                    $address = new Address();
                    $address->id_country = Configuration::get('PS_COUNTRY_DEFAULT');
                    $address->id_state = 0;
                    $address->lastname = $customer->lastname;
                    $address->firstname = $customer->firstname;
                    $address->city = $this->l('UNKNOWN', 'AdminProductRentals');
                    $address->address1 = $this->l('UNKNOWN', 'AdminProductRentals');
                    $address->alias = $this->l('SYSTEM GENERATED', 'AdminProductRentals');
                    $address->save();

                    $this->context->cart->id_address_invoice = (int)$address->id;
                    $this->context->cart->id_address_delivery = (int)$address->id;
                } else {
                    if (!$this->context->cart->id_address_invoice && isset($addresses[0])) {
                        $this->context->cart->id_address_invoice = (int)$addresses[0]['id_address'];
                    }

                    if (!$this->context->cart->id_address_delivery && isset($addresses[0])) {
                        $this->context->cart->id_address_delivery = $addresses[0]['id_address'];
                    }
                }

                $this->context->cart->setNoMultishipping();
                $this->context->cart->save();
                $currency = new Currency($id_currency);
                $this->context->currency = $currency;
                Configuration::updateGlobalValue('PS_CART_RULE_FEATURE_ACTIVE', '1');

                Context::getContext()->currency = new Currency((int) $id_currency);
                Context::getContext()->customer = new Customer((int) $id_customer);

                $mysql_date_now = date('Y-m-d H:i:s', strtotime(date('Y-m-d H:i:s'))-60 * 60);
                $mysql_date_until = date('Y-m-d H:i:s', strtotime(date('Y-m-d H:i:s') . ' +1 day'));
                SpecificPrice::deleteByIdCart((int) $this->context->cart->id);

                $payment = new ProductRentalRentalPayment($id_roja45_product_payment);
                foreach ($rental->getProducts() as $product) {
                    $models = ProductRentalRentalModel::getModels($product['id_roja45_product_rental_product']);
                    foreach ($models as $model) {
                        $payment_item = $payment->getPaymentItem(
                            $product['id_product'],
                            $model['id_product_attribute']
                        );
                        if ($payment_item && $payment_item->total_paid > 0) {
                            $this->context->cart->deleteProduct(
                                $product['id_product'],
                                $model['id_product_attribute'],
                                null,
                                0
                            );
                            $specific_price = new SpecificPrice();
                            $specific_price->id_shop = $this->context->shop->id;
                            $specific_price->id_shop_group = $this->context->shop->id_shop_group;
                            $specific_price->id_currency = 0;
                            $specific_price->id_country = 0;
                            $specific_price->id_group = 0;
                            $specific_price->id_cart = (int) $this->context->cart->id;
                            $specific_price->id_customer = (int)$this->context->customer->id;
                            $specific_price->id_product = $product['id_product'];
                            $specific_price->id_product_attribute = $model['id_product_attribute'];
                            $specific_price->price = $payment_item->total_paid;
                            $specific_price->from_quantity = 1;
                            $specific_price->reduction = 0;
                            $specific_price->reduction_type = 'amount';
                            $specific_price->reduction_tax = 0;
                            $specific_price->from = '0000-00-00 00:00:00';
                            $specific_price->to = '0000-00-00 00:00:00';
                            if ($specific_price->save()) {
                                if (!$this->context->cart->updateQty(
                                    1,
                                    $product['id_product'],
                                    $model['id_product_attribute']
                                )) {
                                    throw new Exception($this->l(
                                        'Unable to add product to cart ['.
                                        $product['id_product'].
                                        '] ['.$model['id_product_attribute'].
                                        ']'
                                    ), 'AdminProductRentals');
                                }
                            }
                        }
                    }
                }

                //$this->context->cart->save();
                if (!Configuration::get('PS_CATALOG_MODE')) {
                    $payment_module = Module::getInstanceByName($payment_method);
                } else {
                    $payment_module = new BoOrder();
                }
                $bad_delivery = false;
                if (($bad_delivery = (bool)!Address::isCountryActiveById((int)$this->context->cart->id_address_invoice))
                    || !Address::isCountryActiveById((int)$this->context->cart->id_address_invoice)) {
                    if ($bad_delivery) {
                        $validationErrors[] = $this->l('The invoice address country is not valid.');
                        die(Tools::jsonEncode(
                            array(
                                'result' => 0,
                                'errors' => $validationErrors,
                            )
                        ));
                    }
                } else {
                    $subject = $this->l(
                        'Manual Order - Rental',
                        'AdminProductRentals'
                    ).' ['.$rental->reference.']';
                    $validated = $payment_module->validateOrder(
                        (int)$this->context->cart->id,
                        (int)$id_order_state,
                        $this->context->cart->getOrderTotal(true, Cart::BOTH),
                        $payment_module->displayName,
                        $subject,
                        array(),
                        $id_currency,
                        false,
                        $this->context->cart->secure_key
                    );

                    /**
                     * Hack for paypal module which returns null here
                     */
                    if (is_null($validated)) {
                        $validated = true;
                    }

                    if ($validated && $payment_module->currentOrder) {
                        $order = new Order($payment_module->currentOrder);
                        if (!Validate::isLoadedObject($order)) {
                            throw new Exception(
                                $this->l('Unable to load new order details.', 'AdminProductRentals')
                            );
                        }
                        $payment->requested = 1;
                        $payment->id_order = $order->id;
                        $payment->date_paid = date('Y-m-d H:i:s');
                        $payment->total = $order->total_paid_tax_excl;
                        $payment->total_with_tax = $order->total_paid_tax_incl;

                        if ($order->total_paid == $order->total_paid_real) {
                            $payment->completed = 1;
                            $rental->setStatus(ProductRentalRentalStatus::$PAYC);
                        } else {
                            $payment->completed = 0;
                            $rental->setStatus(ProductRentalRentalStatus::$PAYU);
                        }

                        if ($payment->save()) {
                            die(Tools::jsonEncode(
                                array(
                                    'result' => 1,
                                    'redirect' => $this->context->link->getAdminLink(
                                        'AdminProductRentals',
                                        true
                                    ).'&id_roja45_product_rental='.$id_roja45_product_rental.'&view'.$this->table,
                                )
                            ));
                        }
                    } else {
                        throw new Exception($this->l('An error occurred while creating the order.'));
                    }
                }
            }
        } catch (Exception $e) {
            $validationErrors = array();
            $validationErrors[] = $e->getMessage();
            die(Tools::jsonEncode(
                array(
                    'result' => 0,
                    'errors' => $validationErrors
                )
            ));
        }
    }

    public function ajaxProcessCreateCustomerAccount()
    {
        $validationErrors = array();
        if ($this->tabAccess['edit'] === '0') {
            $validationErrors[] = $this->l('You do not have the right permission', 'AdminProductRentals');
            die(Tools::jsonEncode(
                array(
                    'result' => 'error',
                    'errors' => $validationErrors
                )
            ));
        }
        try {
            if (!$email = Tools::getValue('email')) {
                $validationErrors[] = $this->l('Email address missing', 'AdminProductRentals');
            }
            if (!$firstname = Tools::getValue('firstname')) {
                $validationErrors[] = $this->l('First name missing', 'AdminProductRentals');
            }
            if (!$lastname = Tools::getValue('lastname')) {
                $validationErrors[] = $this->l('Last name missing', 'AdminProductRentals');
            }
            if (!count($validationErrors)) {
                if (!$id_roja45_product_rental = Tools::getValue('id_roja45_product_rental')) {
                    $rental = new ProductRentalRental();
                    $rental->save();
                    $rental->setStatus(ProductRentalRentalStatus::$ADMN);
                } else {
                    $rental = new ProductRentalRental($id_roja45_product_rental);
                }
                $customer = new Customer();
                $customer->getByEmail($email);
                if (!Validate::isLoadedObject($customer)) {
                    $customer->firstname = Tools::getValue('firstname');
                    $customer->lastname = Tools::getValue('lastname');
                    $customer->email = $email;
                    $password = Tools::passwdGen();
                    $customer->passwd =Tools::encrypt($password);
                    $customer->save();
                }
                $rental->id_customer = $customer->id;
                $rental->save();
                die(Tools::jsonEncode(
                    array(
                        'result' => 1,
                        'response' => $this->l(
                            'Customer account found',
                            'AdminProductRentals'
                        ),
                        'redirect' => $this->context->link->getAdminLink(
                            'AdminProductRentals',
                            true
                        ) . '&id_roja45_product_rental='.$rental->id.'&viewroja45_productrental_rental',
                    )
                ));
            } else {
                $validationErrors[] = $this->l('Validation Errors', 'AdminProductRentals');
                $json = Tools::jsonEncode(array(
                    'result' => 0,
                    'errors' => $validationErrors,
                ));
                die($json);
            }
        } catch (Exception $e) {
            $validationErrors = array();
            $validationErrors[] = $e->getMessage();
            error_log($e->getMessage());
            $json = Tools::jsonEncode(array(
                'result' => 0,
                'errors' => $validationErrors,
                'exception' => $e,
            ));
            die($json);
        }
    }

    public function ajaxProcessRetrieveCustomerAccount()
    {
        $validationErrors = array();
        if ($this->tabAccess['edit'] === '0') {
            $validationErrors[] = $this->l('You do not have the right permission', 'AdminProductRentals');
            die(Tools::jsonEncode(
                array(
                    'result' => 'error',
                    'errors' => $validationErrors
                )
            ));
        }
        try {
            if (!$email = Tools::getValue('email')) {
                $validationErrors[] = $this->l('Email address missing', 'AdminProductRentals');
            }
            if (!count($validationErrors)) {
                if ($id_customer = Customer::customerExists($email, true)) {
                    if (!$id_roja45_product_rental = Tools::getValue('id_roja45_product_rental')) {
                        $rental = new ProductRentalRental();
                        if (!$rental->reference) {
                            $rental->reference = Tools::strtoupper(Tools::passwdGen(9, 'NO_NUMERIC'));
                        }
                        $rental->save();
                        $rental->setStatus(ProductRentalRentalStatus::$ADMN);
                    } else {
                        $rental = new ProductRentalRental($id_roja45_product_rental);
                    }

                    $rental->id_customer = $id_customer;
                    $rental->save();
                    die(Tools::jsonEncode(
                        array(
                            'result' => 1,
                            'response' => $this->l(
                                'Customer account found',
                                'AdminProductRentals'
                            ),
                            'redirect' => $this->context->link->getAdminLink(
                                'AdminProductRentals',
                                true
                            ) . '&id_roja45_product_rental='.$rental->id.'&viewroja45_productrental_rental',
                        )
                    ));
                } else {
                    $validationErrors[] = $this->l(
                        'Customer account does not exist.',
                        'AdminProductRentals'
                    );
                    die(Tools::jsonEncode(
                        array(
                            'result' => 0,
                            'errors' => $validationErrors,
                        )
                    ));
                }
            } else {
                $validationErrors[] = $this->l('Validation Errors', 'AdminProductRentals');
                $json = Tools::jsonEncode(array(
                    'result' => 0,
                    'errors' => $validationErrors,
                ));
                die($json);
            }
        } catch (Exception $e) {
            $validationErrors = array();
            $validationErrors[] = $e->getMessage();
            error_log($e->getMessage());
            $json = Tools::jsonEncode(array(
                'result' => 0,
                'errors' => $validationErrors,
                'exception' => $e,
            ));
            die($json);
        }
    }

    public function ajaxProcessGetRentalProducts()
    {
        $validationErrors = array();
        if ($this->tabAccess['edit'] === '0') {
            $validationErrors[] = $this->l('You do not have the right permission', 'AdminProductRentals');
            die(Tools::jsonEncode(
                array(
                    'result' => 'error',
                    'errors' => $validationErrors
                )
            ));
        }
        try {
            if (!$id_roja45_product_rental = Tools::getValue('id_roja45_product_rental')) {
                $validationErrors[] = $this->l('Rental Id missing', 'AdminProductRentals');
            }
            if (!$collection_date = Tools::getValue('collection_date')) {
                $validationErrors[] = $this->l('Collection date missing', 'AdminProductRentals');
            }
            if (!$return_date = Tools::getValue('return_date')) {
                $validationErrors[] = $this->l('Return date missing', 'AdminProductRentals');
            }
            if (!count($validationErrors)) {
                $tpl = $this->context->smarty->createTemplate(
                    $this->getTemplatePath('rental-modal-select-product.tpl') . 'rentalview-modal-select-product.tpl'
                );
                $products = ProductRentalDetails::getEnabledRentalProducts();
                $rental_products = array();
                $rental = new ProductRentalRental($id_roja45_product_rental);
                if (!Validate::isLoadedObject($rental)) {
                    throw new Exception($this->l('Unable to load rental', 'AdminProductRentals'));
                }

                foreach ($products as $product) {
                    //if (!$rental->getProduct($product['id_roja45_product'])) {
                        $rental_product = new ProductRentalDetails(
                            $product['id_roja45_product'],
                            $this->context->language->id
                        );
                        $rental_products[] = array(
                            'id_roja45_product' => $product['id_roja45_product'],
                            'id_product' => $rental_product->id_product,
                            'name' => $rental_product->getName($this->context->language->id),
                        );
                   // }
                }

                $tpl->assign(
                    array(
                        'collection_date' => $collection_date,
                        'collection_time' => Tools::getValue('collection_time'),
                        'return_date' => $return_date,
                        'return_time' => Tools::getValue('return_time'),
                        'rental_products' => $rental_products,
                    )
                );
                $view = $tpl->fetch();

                die(Tools::jsonEncode(array(
                    'result' => true,
                    'view' => $view,
                    'response' => $this->l('Success', 'AdminProductRentals')
                )));
            } else {
                $validationErrors[] = $this->l('Validation Errors', 'AdminProductRentals');
                $json = Tools::jsonEncode(array(
                    'result' => 0,
                    'errors' => $validationErrors,
                ));
                die($json);
            }
        } catch (Exception $e) {
            $validationErrors = array();
            $validationErrors[] = $e->getMessage();
            error_log($e->getMessage());
            $json = Tools::jsonEncode(array(
                'result' => 0,
                'errors' => $validationErrors,
                'exception' => $e,
            ));
            die($json);
        }
    }

    public function ajaxProcessGetRentalProductModels()
    {
        $validationErrors = array();
        if ($this->tabAccess['edit'] === '0') {
            $validationErrors[] = $this->l('You do not have the right permission', 'AdminProductRentals');
            die(Tools::jsonEncode(
                array(
                    'result' => 'error',
                    'errors' => $validationErrors
                )
            ));
        }
        try {
            if (!$id_roja45_product_rental = Tools::getValue('id_roja45_product_rental')) {
                $validationErrors[] = $this->l('Rental Id missing', 'AdminProductRentals');
            }
            if (!$id_roja45_product = Tools::getValue('id_roja45_product')) {
                $validationErrors[] = $this->l('Rental Product id missing', 'AdminProductRentals');
            }
            if (!$collection_date = Tools::getValue('collection_date')) {
                $validationErrors[] = $this->l('Collection date missing', 'AdminProductRentals');
            }
            if (!$return_date = Tools::getValue('return_date')) {
                $validationErrors[] = $this->l('Return date missing', 'AdminProductRentals');
            }
            if (!count($validationErrors)) {
                $tpl = $this->context->smarty->createTemplate(
                    $this->getTemplatePath('rentalview-modal-select-model.tpl') . 'rentalview-modal-select-model.tpl'
                );
                $rental = new ProductRentalRental($id_roja45_product_rental);
                if ($id_roja45_product_rental_product = $rental->getProduct($id_roja45_product)) {
                    $rental_product_product = new ProductRentalRentalProduct($id_roja45_product_rental_product);
                } else {
                }
                $rental_product = new ProductRentalDetails($id_roja45_product);
                if (!Validate::isLoadedObject($rental_product)) {
                    throw new Exception($this->l('Unable to load rental product', 'AdminProductRentals'));
                }

                $id_roja45_product_rateduration = Tools::getValue('id_roja45_product_rateduration');
                if (!$collection_time = Tools::getValue('collection_time')) {
                    $collection_time = Configuration::get('ROJA45_PRODUCTRENTAL_COLLECTIONTIME');
                }
                if (!$return_time = Tools::getValue('return_time')) {
                    $return_time = Configuration::get('ROJA45_PRODUCTRENTAL_RETURNTIME');
                }
                $product_details = $rental_product->getRentalProductDetails(
                    $collection_date,
                    $collection_time,
                    $return_date,
                    $return_time,
                    $this->context->language->id,
                    $id_roja45_product_rateduration
                );

                $rate_durations = ProductRentalRateDuration::getRateDurations(
                    true,
                    (int)$this->context->language->id
                );

                foreach ($product_details['models'] as &$model) {
                    $rate_duration = new ProductRentalRateDuration($rate_durations[0]['id_roja45_product_rateduration']);
                    $periods = $rate_duration->getPeriods(
                        $model['collection_db'],
                        $model['return_db'],
                        'Y-m-d H:s:i'
                    );
                    $model['periods'] = $periods;
                }

                $tpl->assign(
                    array(
                        'collection_date' => $collection_date,
                        'collection_time' => $collection_time,
                        'return_date' => $return_date,
                        'return_time' => $return_time,
                        'availability' => $product_details['total_availability'],
                        'models' => $product_details['models'],
                        'periods' => $periods,
                        'rate_durations' => $rate_durations,
                    )
                );
                $view = $tpl->fetch();

                die(Tools::jsonEncode(array(
                    'result' => true,
                    'view' => $view,
                    'response' => $this->l('Success', 'AdminProductRentals')
                )));
            } else {
                $validationErrors[] = $this->l('Validation Errors', 'AdminProductRentals');
                $json = Tools::jsonEncode(array(
                    'result' => 0,
                    'errors' => $validationErrors,
                ));
                die($json);
            }
        } catch (Exception $e) {
            $validationErrors = array();
            $validationErrors[] = $e->getMessage();
            error_log($e->getMessage());
            $json = Tools::jsonEncode(array(
                'result' => 0,
                'errors' => $validationErrors,
                'exception' => $e,
            ));
            die($json);
        }
    }

    public function ajaxProcessAddRentalProductModel()
    {
        $validationErrors = array();
        if ($this->tabAccess['edit'] === '0') {
            $validationErrors[] = $this->l('You do not have the right permission', 'AdminProductRentals');
            die(Tools::jsonEncode(
                array(
                    'result' => 'error',
                    'errors' => $validationErrors
                )
            ));
        }
        try {
            if (!$id_roja45_product_rental = Tools::getValue('id_roja45_product_rental')) {
                $validationErrors[] = $this->l('Rental Id missing', 'AdminProductRentals');
            }
            if (!$rental_request = Tools::getValue('products')) {
                $validationErrors[] = $this->l('Product details missing', 'AdminProductRentals');
            }
            if (!count($validationErrors)) {
                $rental_object = Tools::jsonDecode($rental_request);
                $rental_object = ProductRentalRental::validateRental($rental_object);
                ProductRentalRental::updateRental($id_roja45_product_rental, $rental_object);
                die(Tools::jsonEncode(array(
                    'result' => true,
                    'redirect' => $this->context->link->getAdminLink(
                        'AdminProductRentals',
                        true
                    ).'&id_roja45_product_rental='.$id_roja45_product_rental.'&view'.$this->table,
                    'response' => $this->l('Success', 'AdminProductRentals')
                )));
            } else {
                $validationErrors[] = $this->l('Validation Errors', 'AdminProductRentals');
                $json = Tools::jsonEncode(array(
                    'result' => 0,
                    'errors' => $validationErrors,
                ));
                die($json);
            }
        } catch (Exception $e) {
            $validationErrors = array();
            $validationErrors[] = $e->getMessage();
            error_log($e->getMessage());
            $json = Tools::jsonEncode(array(
                'result' => 0,
                'errors' => $validationErrors,
                'exception' => $e,
            ));
            die($json);
        }
    }

    public function ajaxProcessReturnModel()
    {
        $validationErrors = array();
        if ($this->tabAccess['edit'] === '0') {
            $validationErrors[] = $this->l('You do not have the right permission', 'AdminProductRentals');
            die(Tools::jsonEncode(
                array(
                    'result' => 'error',
                    'errors' => $validationErrors
                )
            ));
        }
        try {
            if (!$id_roja45_product_rental = Tools::getValue('id_roja45_product_rental')) {
                $validationErrors[] = $this->l('Rental Id missing', 'AdminProductRentals');
            }
            if (!$id_roja45_product_rental_model = Tools::getValue('id_roja45_product_rental_model')) {
                $validationErrors[] = $this->l('Rental model Id missing', 'AdminProductRentals');
            }
            if (!count($validationErrors)) {
                $rental = new ProductRentalRental($id_roja45_product_rental);
                if (!Validate::isLoadedObject($rental)) {
                    throw new Exception($this->l('Unable to load rental', 'AdminProductRentals'));
                }
                $rental_model = new ProductRentalRentalModel($id_roja45_product_rental_model);
                if (!Validate::isLoadedObject($rental)) {
                    throw new Exception($this->l('Unable to load rental product', 'AdminProductRentals'));
                }
                $rental_model->out_for_rent = 0;
                $rental_model->returned = 1;
                $rental_model->date_rtn = date('Y-m-d H:i:s');
                if ($rental_model->save()) {
                    $models = $rental->getModelsOutstanding();
                    if (!$models) {
                        $rental->setStatus(ProductRentalRentalStatus::$COMP);
                    }
                    die(Tools::jsonEncode(array(
                        'result' => true,
                        'redirect' => $this->context->link->getAdminLink(
                            'AdminProductRentals',
                            true
                        ).'&id_roja45_product_rental='.$id_roja45_product_rental.'&view'.$this->table,
                        'response' => $this->l('Success', 'AdminProductRentals')
                    )));
                } else {
                    throw new Exception(
                        $this->l('Error while updating rental model.', 'AdminProductRentals')
                    );
                }
            } else {
                $validationErrors[] = $this->l('Validation Errors', 'AdminProductRentals');
                $json = Tools::jsonEncode(array(
                    'result' => 0,
                    'errors' => $validationErrors,
                ));
                die($json);
            }
        } catch (Exception $e) {
            $validationErrors = array();
            $validationErrors[] = $e->getMessage();
            error_log($e->getMessage());
            $json = Tools::jsonEncode(array(
                'result' => 0,
                'errors' => $validationErrors,
                'exception' => $e,
            ));
            die($json);
        }
    }

    public function ajaxProcessReturnAll()
    {
        $validationErrors = array();
        if ($this->tabAccess['edit'] === '0') {
            $validationErrors[] = $this->l('You do not have the right permission', 'AdminProductRentals');
            die(Tools::jsonEncode(
                array(
                    'result' => 'error',
                    'errors' => $validationErrors
                )
            ));
        }
        try {
            if (!$id_roja45_product_rental = Tools::getValue('id_roja45_product_rental')) {
                $validationErrors[] = $this->l('Rental Id missing', 'AdminProductRentals');
            }
            if (!count($validationErrors)) {
                $rental = new ProductRentalRental($id_roja45_product_rental);
                if (!Validate::isLoadedObject($rental)) {
                    throw new Exception($this->l('Unable to load rental', 'AdminProductRentals'));
                }
                $returned = true;
                foreach ($rental->getProducts() as $product) {
                    $product = new ProductRentalRentalProduct($product['id_roja45_product_rental_product']);
                    foreach ($product->getModels() as $model) {
                        $rental_model = new ProductRentalRentalModel($model['id_roja45_product_rental_model']);
                        if (!Validate::isLoadedObject($rental_model)) {
                            throw new Exception($this->l('Unable to load rental model', 'AdminProductRentals'));
                        }
                        $rental_model->out_for_rent = 0;
                        $rental_model->returned = 1;
                        $rental_model->date_rtn = date('Y-m-d H:i:s');
                        $returned &= $rental_model->save();
                    }
                }
                if ($returned) {
                    $rental->setStatus(ProductRentalRentalStatus::$COMP);
                    die(Tools::jsonEncode(array(
                        'result' => true,
                        'redirect' => $this->context->link->getAdminLink(
                            'AdminProductRentals',
                            true
                        ).'&id_roja45_product_rental='.$id_roja45_product_rental.'&view'.$this->table,
                        'response' => $this->l('Success', 'AdminProductRentals')
                    )));
                } else {
                    throw new Exception(
                        $this->l('Error while updating rental model.', 'AdminProductRentals')
                    );
                }
            } else {
                $validationErrors[] = $this->l('Validation Errors', 'AdminProductRentals');
                $json = Tools::jsonEncode(array(
                    'result' => 0,
                    'errors' => $validationErrors,
                ));
                die($json);
            }
        } catch (Exception $e) {
            $validationErrors = array();
            $validationErrors[] = $e->getMessage();
            error_log($e->getMessage());
            $json = Tools::jsonEncode(array(
                'result' => 0,
                'errors' => $validationErrors,
                'exception' => $e,
            ));
            die($json);
        }
    }

    public function ajaxProcessDeleteRentalProduct()
    {
        $validationErrors = array();
        if ($this->tabAccess['edit'] === '0') {
            $validationErrors[] = $this->l('You do not have the right permission', 'AdminProductRentals');
            die(Tools::jsonEncode(
                array(
                    'result' => 'error',
                    'errors' => $validationErrors
                )
            ));
        }
        try {
            if (!$id_roja45_product_rental = Tools::getValue('id_roja45_product_rental')) {
                $validationErrors[] = $this->l('Rental Id missing', 'AdminProductRentals');
            }
            if (!$id_roja45_product_rental_product = Tools::getValue('id_roja45_product_rental_product')) {
                $validationErrors[] = $this->l('Rental product Id missing', 'AdminProductRentals');
            }
            if (!count($validationErrors)) {
                $rental = new ProductRentalRental($id_roja45_product_rental);
                if (!Validate::isLoadedObject($rental)) {
                    throw new Exception($this->l('Unable to load rental', 'AdminProductRentals'));
                }
                $rental_product = new ProductRentalRentalProduct($id_roja45_product_rental_product);
                if (!Validate::isLoadedObject($rental)) {
                    throw new Exception($this->l('Unable to load rental product', 'AdminProductRentals'));
                }
                if ($rental_product->delete()) {
                    die(Tools::jsonEncode(array(
                        'result' => true,
                        'redirect' => $this->context->link->getAdminLink(
                            'AdminProductRentals',
                            true
                        ).'&id_roja45_product_rental='.$id_roja45_product_rental.'&view'.$this->table,
                        'response' => $this->l('Success', 'AdminProductRentals')
                    )));
                } else {
                    throw new Exception(
                        $this->l('Error while deleting rental product.', 'AdminProductRentals')
                    );
                }
            } else {
                $validationErrors[] = $this->l('Validation Errors', 'AdminProductRentals');
                $json = Tools::jsonEncode(array(
                    'result' => 0,
                    'errors' => $validationErrors,
                ));
                die($json);
            }
        } catch (Exception $e) {
            $validationErrors = array();
            $validationErrors[] = $e->getMessage();
            error_log($e->getMessage());
            $json = Tools::jsonEncode(array(
                'result' => 0,
                'errors' => $validationErrors,
                'exception' => $e,
            ));
            die($json);
        }
    }

    public function ajaxProcessDeleteRentalProductModel()
    {
        $validationErrors = array();
        if ($this->tabAccess['edit'] === '0') {
            $validationErrors[] = $this->l('You do not have the right permission', 'AdminProductRentals');
            die(Tools::jsonEncode(
                array(
                    'result' => 'error',
                    'errors' => $validationErrors
                )
            ));
        }
        try {
            if (!$id_roja45_product_rental = Tools::getValue('id_roja45_product_rental')) {
                $validationErrors[] = $this->l('Rental Id missing', 'AdminProductRentals');
            }
            if (!$id_roja45_product_rental_product = Tools::getValue('id_roja45_product_rental_product')) {
                $validationErrors[] = $this->l('Rental product Id missing', 'AdminProductRentals');
            }
            if (!$id_roja45_product_rental_model = Tools::getValue('id_roja45_product_rental_model')) {
                $validationErrors[] = $this->l('Rental model id missing', 'AdminProductRentals');
            }
            if (!count($validationErrors)) {
                $rental = new ProductRentalRental($id_roja45_product_rental);
                if (!Validate::isLoadedObject($rental)) {
                    throw new Exception($this->l('Unable to load rental', 'AdminProductRentals'));
                }
                $rental_model = new ProductRentalRentalModel($id_roja45_product_rental_model);
                if (!Validate::isLoadedObject($rental)) {
                    throw new Exception($this->l('Unable to load rental model', 'AdminProductRentals'));
                }
                if ($rental_model->delete()) {
                    $models = ProductRentalRentalModel::getModels($id_roja45_product_rental_product);
                    if (!count($models)) {
                        $rental_product = new ProductRentalRentalProduct($id_roja45_product_rental_product);
                        $rental_product->delete();
                    }
                    die(Tools::jsonEncode(array(
                        'result' => true,
                        'redirect' => $this->context->link->getAdminLink(
                            'AdminProductRentals',
                            true
                        ).'&id_roja45_product_rental='.$id_roja45_product_rental.'&view'.$this->table,
                        'response' => $this->l('Success', 'AdminProductRentals')
                    )));
                } else {
                    throw new Exception(
                        $this->l('Error while deleting rental model.', 'AdminProductRentals')
                    );
                }
                die(Tools::jsonEncode(array(
                    'result' => true,
                    'redirect' => $this->context->link->getAdminLink(
                        'AdminProductRentals',
                        true
                    ).'&id_roja45_product_rental='.$id_roja45_product_rental.'&view'.$this->table,
                    'response' => $this->l('Success', 'AdminProductRentals')
                )));
            } else {
                $validationErrors[] = $this->l('Validation Errors', 'AdminProductRentals');
                $json = Tools::jsonEncode(array(
                    'result' => 0,
                    'errors' => $validationErrors,
                ));
                die($json);
            }
        } catch (Exception $e) {
            $validationErrors = array();
            $validationErrors[] = $e->getMessage();
            error_log($e->getMessage());
            $json = Tools::jsonEncode(array(
                'result' => 0,
                'errors' => $validationErrors,
                'exception' => $e,
            ));
            die($json);
        }
    }

    public function ajaxProcessGetExtras()
    {
        $validationErrors = array();
        if ($this->tabAccess['edit'] === '0') {
            $validationErrors[] = $this->l('You do not have the right permission', 'AdminProductRentals');
            die(Tools::jsonEncode(
                array(
                    'result' => 'error',
                    'errors' => $validationErrors
                )
            ));
        }
        try {
            if (!$id_roja45_product_rental = Tools::getValue('id_roja45_product_rental')) {
                $validationErrors[] = $this->l('Rental Id missing', 'AdminProductRentals');
            }
            if (!$id_roja45_product_rental_model = Tools::getValue('id_roja45_product_rental_model')) {
                $validationErrors[] = $this->l('Rental model id missing', 'AdminProductRentals');
            }
            if (!count($validationErrors)) {
                $rental = new ProductRentalRental($id_roja45_product_rental);
                if (!Validate::isLoadedObject($rental)) {
                    throw new Exception($this->l('Unable to load rental', 'AdminProductRentals'));
                }
                $rental_model = new ProductRentalRentalModel($id_roja45_product_rental_model);
                if (!Validate::isLoadedObject($rental)) {
                    throw new Exception($this->l('Unable to load rental model', 'AdminProductRentals'));
                }

                $datetime1 = DateTime::createFromFormat(
                    'Y-m-d',
                    $rental_model->start_date
                );
                $datetime2 = DateTime::createFromFormat(
                    'Y-m-d',
                    $rental_model->end_date
                );
                $interval = $datetime1->diff($datetime2);

                $product_model = new ProductRentalModel($rental_model->id_roja45_product_model);
                $extras = ProductRentalModelExtra::getExtrasForModel($rental_model->id_roja45_product_model);
                foreach ($extras as $key => &$extra) {
                    if ($rental_model->hasExtra($extra['id_roja45_product_extra'])) {
                        unset($extras[$key]);
                    } else {
                        $rental_extra = new ProductRentalExtra(
                            $extra['id_roja45_product_extra'],
                            $this->context->language->id
                        );
                        $extra['name'] = $rental_extra->name;
                        $extra['rate_formatted'] = Tools::displayPrice(Tools::convertPrice($extra['rate']));
                    }
                }

                $tpl = $this->context->smarty->createTemplate(
                    $this->getTemplatePath('rentalview-modal-select-extras.tpl') . 'rentalview-modal-select-extras.tpl'
                );
                $tpl->assign(
                    array(
                        'id_roja45_product_rental_model' => $id_roja45_product_rental_model,
                        'product_model' => $product_model,
                        'extras' => $extras,
                        'days' => $interval->days,
                    )
                );
                $view = $tpl->fetch();
                die(Tools::jsonEncode(
                    array(
                        'result' => 'success',
                        'view' => $view
                    )
                ));
            } else {
                $validationErrors[] = $this->l('Validation Errors', 'AdminProductRentals');
                $json = Tools::jsonEncode(array(
                    'result' => 0,
                    'errors' => $validationErrors,
                ));
                die($json);
            }
        } catch (Exception $e) {
            $validationErrors = array();
            $validationErrors[] = $e->getMessage();
            error_log($e->getMessage());
            $json = Tools::jsonEncode(array(
                'result' => false,
                'errors' => $validationErrors,
                'exception' => $e,
            ));
            die($json);
        }
    }

    public function ajaxProcessAddExtras()
    {
        $validationErrors = array();
        if ($this->tabAccess['edit'] === '0') {
            $validationErrors[] = $this->l('You do not have the right permission', 'AdminProductRentals');
            die(Tools::jsonEncode(
                array(
                    'result' => 'error',
                    'errors' => $validationErrors
                )
            ));
        }
        try {
            if (!$id_roja45_product_rental = Tools::getValue('id_roja45_product_rental')) {
                $validationErrors[] = $this->l('Rental Id missing', 'AdminProductRentals');
            }
            if (!$extras = Tools::getValue('extras')) {
                $validationErrors[] = $this->l('Rates missing', 'AdminProductRentals');
            }

            if (!count($validationErrors)) {
                $rental = new ProductRentalRental($id_roja45_product_rental);
                if (!Validate::isLoadedObject($rental)) {
                    throw new Exception($this->l('Unable to load rental', 'AdminProductRentals'));
                }

                $tax_enabled = Configuration::get('PS_TAX');
                $usetax = true;
                if (Tax::excludeTaxeOption()) {
                    $usetax = false;
                }
                $all_rental_products = array();

                if (Configuration::get('PS_TAX_ADDRESS_TYPE') == 'id_address_invoice') {
                    $address_id = isset($this->context->cart) ? (int)$this->context->cart->id_address_invoice : null;
                } else {
                    $address_id = isset($this->context->cart) ? (int)$this->context->cart->id_address_delivery : null;
                }
                if (!Address::addressExists($address_id)) {
                    $address_id = null;
                }
                $address = Address::initialize($address_id, true);

                foreach ($extras as &$extra) {
                    $model = new ProductRentalRentalModel($extra['id_roja45_product_rental_model']);
                    $rental_product = new ProductRentalRentalProduct($model->id_roja45_product_rental_product);
                    if ($tax_enabled && $usetax) {
                        $id_tax_rules_group = Product::getIdTaxRulesGroupByIdProduct(
                            (int)$rental_product->id_product,
                            $this->context
                        );
                        $product_tax_calculator = TaxManagerFactory::getManager(
                            $address,
                            $id_tax_rules_group
                        )->getTaxCalculator();
                    }

                    $extraObj = new ProductRentalExtra(
                        $extra['id_roja45_product_extra'],
                        $this->context->language->id
                    );

                    $modelExtraObj = new ProductRentalModelExtra(
                        $extra['id_roja45_product_extralink'],
                        $this->context->language->id
                    );

                    if (!Validate::isLoadedObject($extraObj)) {
                        throw new Exception($this->l('The extra could not be loaded.', 'AdminProductRentals'));
                    }

                    if (!Validate::isLoadedObject($modelExtraObj)) {
                        throw new Exception($this->l('The extra is not available for this model.', 'AdminProductRentals'));
                    }

                    $extra_total = $extraObj->calculateExtraCost(
                        $modelExtraObj->rate,
                        $model->start_date,
                        $model->end_date,
                        $model->qty,
                        $extra['qty_per_day']
                    );

                    $extra['tax'] = 0;
                    if ($tax_enabled && $usetax) {
                        $extra['tax'] = $product_tax_calculator->addTaxes($extra_total) - $extra_total;
                    }

                    $model->addExtra(
                        $extraObj->id_roja45_product_extra,
                        $extraObj->rate,
                        $extra['tax'],
                        1,
                        $extra_total
                    );
                }

                die(Tools::jsonEncode(
                    array(
                        'result' => 1,
                        'redirect' => $this->context->link->getAdminLink(
                            'AdminProductRentals',
                            true
                        ).'&id_roja45_product_rental='.$id_roja45_product_rental.'&view'.$this->table,
                        'response' => $this->l('Success', 'AdminProductRentals')
                    )
                ));
            } else {
                $validationErrors[] = $this->l('Validation Errors', 'AdminProductRentals');
                $json = Tools::jsonEncode(array(
                    'result' => 0,
                    'errors' => $validationErrors,
                ));
                die($json);
            }
        } catch (Exception $e) {
            $validationErrors = array();
            $validationErrors[] = $e->getMessage();
            error_log($e->getMessage());
            $json = Tools::jsonEncode(array(
                'result' => 0,
                'errors' => $validationErrors,
                'exception' => $e,
            ));
            die($json);
        }
    }

    public function ajaxProcessDeleteExtra()
    {
        $validationErrors = array();
        if ($this->tabAccess['edit'] === '0') {
            $validationErrors[] = $this->l('You do not have the right permission', 'AdminProductRentals');
            die(Tools::jsonEncode(
                array(
                    'result' => 0,
                    'errors' => $validationErrors
                )
            ));
        }

        try {
            if (!$id_roja45_product_rental = Tools::getValue('id_roja45_product_rental')) {
                $validationErrors[] = $this->l('Rental Id missing', 'AdminProductRentals');
            }
            if (!$id_roja45_product_rental_extra = Tools::getValue('id_roja45_product_rental_extra')) {
                $validationErrors[] = $this->l('Rental model id missing', 'AdminProductRentals');
            }

            if (!count($validationErrors)) {
                $rental = new ProductRentalRental($id_roja45_product_rental);
                if (!Validate::isLoadedObject($rental)) {
                    throw new Exception($this->l('Unable to load rental', 'AdminProductRentals'));
                }
                $rental_extra = new ProductRentalRentalModelExtra($id_roja45_product_rental_extra);
                if (!Validate::isLoadedObject($rental_extra)) {
                    throw new Exception($this->l('Unable to load rental extra', 'AdminProductRentals'));
                }
                if ($rental_extra->delete()) {
                    die(Tools::jsonEncode(
                        array(
                            'result' => 1,
                            'redirect' => $this->context->link->getAdminLink(
                                'AdminProductRentals',
                                true
                            ).'&id_roja45_product_rental='.$id_roja45_product_rental.'&view'.$this->table,
                            'response' => $this->l('Success', 'AdminProductRentals')
                        )
                    ));
                }
            } else {
                $validationErrors[] = $this->l('Validation Errors', 'AdminProductRentals');
                $json = Tools::jsonEncode(array(
                    'result' => 0,
                    'errors' => $validationErrors,
                ));
                die($json);
            }
        } catch (Exception $e) {
            $validationErrors = array();
            $validationErrors[] = $e->getMessage();
            error_log($e->getMessage());
            $json = Tools::jsonEncode(array(
                'result' => 0,
                'errors' => $validationErrors,
                'exception' => $e,
            ));
            die($json);
        }
    }

    public function ajaxProcessUpdatePaymentConfirmedStatus()
    {
        $validationErrors = array();
        if ($this->tabAccess['edit'] === '0') {
            $validationErrors[] = $this->l('You do not have the right permission', 'AdminProductRentals');
            die(Tools::jsonEncode(
                array(
                    'result' => 0,
                    'errors' => $validationErrors
                )
            ));
        }

        try {
            if (!$id_roja45_product_rental = Tools::getValue('id_roja45_product_rental')) {
                $validationErrors[] = $this->l('Rental Id missing', 'AdminProductRentals');
            }
            if (!$id_roja45_product_rental_payment = Tools::getValue('id_roja45_product_rental_payment')) {
                $validationErrors[] = $this->l('Payment id missing', 'AdminProductRentals');
            }

            if (!count($validationErrors)) {
                $rental = new ProductRentalRental($id_roja45_product_rental);
                if (!Validate::isLoadedObject($rental)) {
                    throw new Exception($this->l('Unable to load rental', 'AdminProductRentals'));
                }

                $payment = new ProductRentalRentalPayment($id_roja45_product_rental_payment);
                if (!Validate::isLoadedObject($payment)) {
                    throw new Exception($this->l('Unable to load payment', 'AdminProductRentals'));
                }

                if ($payment->completed) {
                    $payment->completed = 0;
                    if ($payment->save()) {
                        die(Tools::jsonEncode(
                            array(
                                'result' => 1,
                                'redirect' => $this->context->link->getAdminLink(
                                    'AdminProductRentals',
                                    true
                                ).'&id_roja45_product_rental='.$id_roja45_product_rental.'&view'.$this->table,
                                'response' => $this->l('Success', 'AdminProductRentals')
                            )
                        ));
                    }
                } else {
                    $date = date('Y-m-d H:i:s');
                    $payment->payment_due = 1;
                    $payment->requested = 1;
                    $payment->date_completed = $date;
                    $payment->completed = 1;
                    if (!$payment->save()) {
                        throw new Exception($this->l(
                            'Unable to update reservation payment.',
                            'AdminProductRentals'
                        ));
                    }

                    try {
                        $order = new Order($payment->id_order);
                        $order_state = new OrderState(Configuration::get('PS_OS_PAYMENT'));
                        if (Validate::isLoadedObject($order_state)) {
                            $current_order_state = $order->getCurrentOrderState();
                            if ($current_order_state->id != $order_state->id) {
                                $history = new OrderHistory();
                                $history->id_order = $order->id;
                                $history->id_employee = (int)$this->context->employee->id;
                                $use_existings_payment = false;
                                if (!$order->hasInvoice()) {
                                    $use_existings_payment = true;
                                }
                                $history->changeIdOrderState((int)$order_state->id, $order, $use_existings_payment);
                                $carrier = new Carrier($order->id_carrier, $order->id_lang);
                                $templateVars = array();
                                if ($history->id_order_state == Configuration::get('PS_OS_SHIPPING') &&
                                    $order->shipping_number
                                ) {
                                    $templateVars = array(
                                        '{followup}' => str_replace('@', $order->shipping_number, $carrier->url)
                                    );
                                }
                                $history->addWithemail(true, $templateVars);
                            }
                        }
                    } catch (Exception $e) {
                        throw new Exception($this->l(
                            'Unable to update reservation payment to confirmed.',
                            'Reservations'
                        ));
                    }
                    die(Tools::jsonEncode(
                        array(
                            'result' => 1,
                            'redirect' => $this->context->link->getAdminLink(
                                'AdminProductRentals',
                                true
                            ).'&id_roja45_product_rental='.$id_roja45_product_rental.'&view'.$this->table,
                            'response' => $this->l('Success', 'AdminProductRentals')
                        )
                    ));
                }
            } else {
                throw new Exception($this->l('Validation Errors', 'AdminProductRentals'));
            }
        } catch (Exception $e) {
            $validationErrors = array();
            $validationErrors[] = $e->getMessage();
            error_log($e->getMessage());
            $json = Tools::jsonEncode(array(
                'result' => 0,
                'errors' => $validationErrors,
                'exception' => $e,
            ));
            die($json);
        }
    }

    public function ajaxProcessUpdatePaymentReceivedStatus()
    {
        $validationErrors = array();
        if ($this->tabAccess['edit'] === '0') {
            $validationErrors[] = $this->l('You do not have the right permission', 'AdminProductRentals');
            die(Tools::jsonEncode(
                array(
                    'result' => 0,
                    'errors' => $validationErrors
                )
            ));
        }

        try {
            if (!$id_roja45_product_rental = Tools::getValue('id_roja45_product_rental')) {
                $validationErrors[] = $this->l('Rental Id missing', 'AdminProductRentals');
            }
            if (!$id_roja45_product_rental_payment = Tools::getValue('id_roja45_product_rental_payment')) {
                $validationErrors[] = $this->l('Payment id missing', 'AdminProductRentals');
            }

            if (!count($validationErrors)) {
                $rental = new ProductRentalRental($id_roja45_product_rental);
                if (!Validate::isLoadedObject($rental)) {
                    throw new Exception($this->l('Unable to load rental', 'AdminProductRentals'));
                }

                $payment = new ProductRentalRentalPayment($id_roja45_product_rental_payment);
                if (!Validate::isLoadedObject($payment)) {
                    throw new Exception($this->l('Unable to load payment', 'AdminProductRentals'));
                }
                $date = date('Y-m-d H:i:s');
                $payment->payment_due = 1;
                $payment->requested = 1;
                $payment->requested_date = $date;
                if (!isset($payment->paid_date)) {
                    $payment->paid_date = $date;
                } else {
                    $payment->paid_date = null;
                }

                if ($payment->save()) {
                    die(Tools::jsonEncode(
                        array(
                            'result' => 1,
                            'redirect' => $this->context->link->getAdminLink(
                                'AdminProductRentals',
                                true
                            ).'&id_roja45_product_rental='.$id_roja45_product_rental.'&view'.$this->table,
                            'response' => $this->l('Success', 'AdminProductRentals')
                        )
                    ));
                } else {
                    throw new Exception($this->l(
                        'Unable to update reservation payment.',
                        'AdminProductRentals'
                    ));
                }
            } else {
                throw new Exception($this->l('Validation Errors', 'AdminProductRentals'));
            }
        } catch (Exception $e) {
            $validationErrors = array();
            $validationErrors[] = $e->getMessage();
            error_log($e->getMessage());
            $json = Tools::jsonEncode(array(
                'result' => 0,
                'errors' => $validationErrors,
                'exception' => $e,
            ));
            die($json);
        }
    }

    public function ajaxProcessCreateRental()
    {
        $validationErrors = array();
        if ($this->tabAccess['edit'] === '0') {
            $validationErrors[] = $this->l('You do not have the right permission', 'AdminProductRentals');
            die(Tools::jsonEncode(
                array(
                    'result' => 'error',
                    'errors' => $validationErrors
                )
            ));
        }

        try {
            if (!$id_roja45_product_rental = Tools::getValue('id_roja45_product_rental')) {
                $validationErrors[] = $this->l('Rental Id missing', 'AdminProductRentals');
            }

            if (!count($validationErrors)) {
                $rental = new ProductRentalRental($id_roja45_product_rental);
                if (!Validate::isLoadedObject($rental)) {
                    throw new Exception($this->l('Unable to load rental', 'AdminProductRentals'));
                }

                $rental_object = Tools::jsonDecode($rental->toJSON($this->context->language->id));
                $rental_object = ProductRentalRental::validateRental($rental_object);
                if ($rental_object->rental_valid) {
                    $rental->setStatus(ProductRentalRentalStatus::$RCVD);
                    $rental->setStatus(ProductRentalRentalStatus::$CCNF);
                    $rental->setStatus(ProductRentalRentalStatus::$PRES);
                    die(Tools::jsonEncode(
                        array(
                            'result' => 1,
                            'redirect' => $this->context->link->getAdminLink(
                                'AdminProductRentals',
                                true
                            ) . '&id_roja45_product_rental=' . $id_roja45_product_rental . '&view' . $this->table,
                            'response' => $this->l('Success', 'AdminProductRentals')
                        )
                    ));
                } else {
                    throw new Exception($this->l('Rental is not valid', 'AdminProductRentals'));
                }
            } else {
                throw new Exception($this->l('There are validation errors', 'AdminProductRentals'));
            }
        } catch (Exception $e) {
            $validationErrors = array();
            $validationErrors[] = $e->getMessage();
            error_log($e->getMessage());
            $json = Tools::jsonEncode(array(
                'result' => 0,
                'errors' => $validationErrors,
                'exception' => $e,
            ));
            die($json);
        }
    }

    public function ajaxProcessCreateCustomRates()
    {
        $validationErrors = array();
        if ($this->tabAccess['view'] === '0') {
            $validationErrors[] = $this->l('You do not have the right permission', 'AdminProductRentals');
        }
        if (!count($validationErrors)) {
            try {
                $id_roja45_product = Tools::getValue('id_roja45_product');
                $event_start_date = DateTime::createFromFormat(
                    $this->context->language->date_format_lite,
                    Tools::getValue('event_start_date')
                );
                $event_end_date = DateTime::createFromFormat(
                    $this->context->language->date_format_lite,
                    Tools::getValue('event_end_date')
                );
                $event_end_date->modify('+1 day');
                $period = new DatePeriod(
                    $event_start_date,
                    new DateInterval('P1D'),
                    $event_end_date
                );
                $periods = iterator_to_array($period);

                $selected_days = Tools::getValue('apply_rates_to');
                $models = Tools::getValue('model_rates');
                $result = true;
                foreach ($models as $id_roja45_product_model => $model) {
                    foreach ($model as $id_roja45_product_rate => $rate) {
                        foreach ($periods as $date) {
                            $date_str = $date->format('Y-m-d');
                            $day = $date->format('w');
                            if (in_array($day, $selected_days)) {
                                if ($id_roja45_product_daterate = ProductRentalDateRate::exists(
                                    $id_roja45_product,
                                    $id_roja45_product_model,
                                    $id_roja45_product_rate,
                                    $date_str
                                )) {
                                    $date_rate = new ProductRentalDateRate($id_roja45_product_daterate);
                                } else {
                                    $date_rate = new ProductRentalDateRate();
                                }
                                $date_rate->id_roja45_product = $id_roja45_product;
                                $date_rate->id_roja45_product_model = $id_roja45_product_model;
                                $date_rate->id_roja45_product_rate = $id_roja45_product_rate;
                                $date_rate->date = $date_str;
                                $date_rate->rate = $rate;
                                $result &= $date_rate->save();
                            }
                        }
                    }
                }
                if ($result) {
                    $start_date = Tools::getValue('start_date');
                    $page = Tools::getValue('page');
                    $offset = Tools::getValue('offset');
                    $number_days = Tools::getValue('number_days');
                    $redirect = $this->context->link->getAdminLink(
                        'AdminRentalCalendar',
                        true
                    );
                    $redirect .= '&start_date='.$start_date.'&offset='.$offset.'&number_days='.$number_days;
                    die(Tools::jsonEncode(
                        array(
                            'result' => 1,
                            'response' => $this->l('Success', 'AdminProductRentals'),
                            'redirect' => $redirect,
                        )
                    ));
                } else {
                    throw new Exception($this->l('Error while saving custom rate.', 'AdminProductRentals'));
                }
            } catch (Exception $e) {
                $validationErrors = array();
                $validationErrors[] = $e->getMessage();
            }
        } else {
            $validationErrors[] = $this->l(
                'Unable to get product rentals.  Function validation errors',
                'AdminProductRentals'
            );
        }
    }

    public function ajaxProcessDeleteCustomRates()
    {
        $validationErrors = array();
        if ($this->tabAccess['view'] === '0') {
            $validationErrors[] = $this->l('You do not have the right permission', 'AdminProductRentals');
        }
        if (!count($validationErrors)) {
            try {
                $id_roja45_product = Tools::getValue('id_roja45_product');
                $event_start_date = DateTime::createFromFormat(
                    $this->context->language->date_format_lite,
                    Tools::getValue('event_start_date')
                );
                $event_end_date = DateTime::createFromFormat(
                    $this->context->language->date_format_lite,
                    Tools::getValue('event_end_date')
                );
                $event_end_date->modify('+1 day');
                $period = new DatePeriod(
                    $event_start_date,
                    new DateInterval('P1D'),
                    $event_end_date
                );
                $periods = iterator_to_array($period);
                $selected_days = Tools::getValue('apply_rates_to');
                $models = Tools::getValue('model_rates');
                foreach ($models as $id_roja45_product_model => $model) {
                    foreach ($model as $id_roja45_product_rate => $rate) {
                        foreach ($periods as $date) {
                            $day = $date->format('w');
                            if (in_array($day, $selected_days)) {
                                $date = $date->format('Y-m-d');
                                if ($id_roja45_product_daterate = ProductRentalDateRate::exists(
                                    $id_roja45_product,
                                    $id_roja45_product_model,
                                    $id_roja45_product_rate,
                                    $date
                                )) {
                                    $date_rate = new ProductRentalDateRate($id_roja45_product_daterate);
                                    $date_rate->delete();
                                }
                            }
                        }
                    }
                }
                $start_date = Tools::getValue('start_date');
                $page = Tools::getValue('page');
                $offset = Tools::getValue('offset');
                $number_days = Tools::getValue('number_days');
                $redirect = $this->context->link->getAdminLink(
                    'AdminRentalCalendar',
                    true
                );
                $redirect .= '&start_date='.$start_date.'&offset='.$offset.'&number_days='.$number_days;
                die(Tools::jsonEncode(
                    array(
                        'result' => 1,
                        'response' => $this->l('Success', 'AdminProductRentals'),
                        'redirect' => $redirect,
                    )
                ));
            } catch (Exception $e) {
                $validationErrors = array();
                $validationErrors[] = $e->getMessage();
            }
        } else {
            $validationErrors[] = $this->l(
                'Unable to get product rentals.  Function validation errors',
                'AdminProductRentals'
            );
        }
    }
    public function ajaxProcessCreateBlockedRentalDates()
    {
        $validationErrors = array();
        if ($this->tabAccess['edit'] === '0') {
            $validationErrors[] = $this->l('You do not have the right permission', 'AdminProductRentals');
            die(Tools::jsonEncode(
                array(
                    'result' => 'error',
                    'errors' => $validationErrors
                )
            ));
        }

        try {
            if (!$id_roja45_product = Tools::getValue('id_roja45_product')) {
                $validationErrors[] = $this->l('Rental Product Id missing', 'AdminProductRentals');
            }

            if (!count($validationErrors)) {
                $context = Context::getContext();
                $date = DateTime::createFromFormat($context->language->date_format_lite, Tools::getValue('event_start_date'));
                $start_date = $date->format('Y-m-d');
                $date = DateTime::createFromFormat($context->language->date_format_lite, Tools::getValue('event_end_date'));
                $end_date = $date->format('Y-m-d') ;

                if (!$id_roja45_product_model = Tools::getValue('id_roja45_product_model')) {
                    $unavailable = new ProductUnavailable();
                    $unavailable->id_roja45_product = $id_roja45_product;
                    $unavailable->id_roja45_product_model = 0;
                    $unavailable->start_date = $start_date;
                    $unavailable->end_date = $end_date;
                    $unavailable->save();
                    foreach (ProductRentalModel::getModels($id_roja45_product) as $model) {
                        $unavailable = new ProductUnavailable();
                        $unavailable->id_roja45_product = $id_roja45_product;
                        $unavailable->id_roja45_product_model = $model['id_roja45_product_model'];
                        $unavailable->start_date = $start_date;
                        $unavailable->end_date = $end_date;
                        $unavailable->save();
                    }
                } else {
                    $unavailable = new ProductUnavailable();
                    $unavailable->id_roja45_product = $id_roja45_product;
                    $unavailable->id_roja45_product_model = $id_roja45_product_model;
                    $unavailable->start_date = $start_date;
                    $unavailable->end_date = $end_date;
                    $unavailable->save();
                }

                $start_date = Tools::getValue('start_date');
                $page = Tools::getValue('page');
                $offset = Tools::getValue('offset');
                $number_days = Tools::getValue('number_days');
                $redirect = $this->context->link->getAdminLink(
                    'AdminRentalCalendar',
                    true
                );
                $redirect .= '&start_date='.$start_date.'&offset='.$offset.'&number_days='.$number_days;
                die(Tools::jsonEncode(
                    array(
                        'result' => 1,
                        'response' => $this->l('Success', 'AdminProductRentals'),
                        'redirect' => $redirect,
                    )
                ));
            } else {
                throw new Exception($this->l('There are validation errors', 'AdminProductRentals'));
            }
        } catch (Exception $e) {
            $validationErrors = array();
            $validationErrors[] = $e->getMessage();
            error_log($e->getMessage());
            $json = Tools::jsonEncode(array(
                'result' => 0,
                'errors' => $validationErrors,
                'exception' => $e,
            ));
            die($json);
        }
    }

    public function ajaxProcessUpdateUnavailable()
    {
        $validationErrors = array();
        if ($this->tabAccess['edit'] === '0') {
            $validationErrors[] = $this->l('You do not have the right permission', 'AdminProductRentals');
            die(Tools::jsonEncode(
                array(
                    'result' => 0,
                    'errors' => $validationErrors
                )
            ));
        }
        try {
            $id_roja45_product_unavailable = Tools::getValue('id_roja45_product_unavailable');
            $unavailable = new ProductUnavailable($id_roja45_product_unavailable);
            if (!Validate::isLoadedObject($unavailable)) {
                throw new Exception('[ajaxProcessDeleteUnavailable] '. $this->l('The entry could not be loaded.'));
            }
            $date = DateTime::createFromFormat($this->context->language->date_format_lite, Tools::getValue('event_start_date'));
            $start_date = $date->format('Y-m-d');
            $date = DateTime::createFromFormat($this->context->language->date_format_lite, Tools::getValue('event_end_date'));
            $end_date = $date->format('Y-m-d') ;
            $unavailable->start_date =$start_date;
            $unavailable->end_date = $end_date;
            $start_date = Tools::getValue('start_date');
            $page = Tools::getValue('page');
            $offset = Tools::getValue('offset');
            $number_days = Tools::getValue('number_days');
            $redirect = $this->context->link->getAdminLink(
                'AdminRentalCalendar',
                true
            );
            $redirect .= '&start_date='.$start_date.'&offset='.$offset.'&number_days='.$number_days;
            if ($unavailable->save()) {
                die(Tools::jsonEncode(
                    array(
                        'result' => 1,
                        'redirect' => $redirect,
                        'response' => $this->l('Success', 'AdminProductRentals'),
                    )
                ));
            } else {
                $validationErrors[] = 'Error';
                die(Tools::jsonEncode(array(
                    'result' => 0,
                    'errors' => $validationErrors,
                )));
            }
        } catch (Exception $e) {
            $validationErrors = array();
            $validationErrors[] = $e->getMessage();
            error_log($e->getMessage());
            $json = Tools::jsonEncode(array(
                'result' => 0,
                'errors' => $validationErrors,
                'exception' => $e,
            ));
            die($json);
        }
    }

    public function ajaxProcessDeleteUnavailable()
    {
        $validationErrors = array();
        if ($this->tabAccess['edit'] === '0') {
            $validationErrors[] = $this->l('You do not have the right permission', 'AdminProductRentals');
            die(Tools::jsonEncode(
                array(
                    'result' => 0,
                    'errors' => $validationErrors
                )
            ));
        }
        try {
            $id_roja45_product_unavailable = Tools::getValue('id_roja45_product_unavailable');
            $unavailable = new ProductUnavailable($id_roja45_product_unavailable);
            if (!Validate::isLoadedObject($unavailable)) {
                throw new Exception('[ajaxProcessDeleteUnavailable] '. $this->l('The entry could not be loaded.'));
            }
            if ($unavailable->delete()) {
                $start_date = Tools::getValue('start_date');
                $page = Tools::getValue('page');
                $offset = Tools::getValue('offset');
                $number_days = Tools::getValue('number_days');
                $redirect = $this->context->link->getAdminLink(
                    'AdminRentalCalendar',
                    true
                );
                $redirect .= '&start_date='.$start_date.'&offset='.$offset.'&number_days='.$number_days;
                die(Tools::jsonEncode(
                    array(
                        'result' => 1,
                        'redirect' => $redirect,
                        'response' => $this->l('Success', 'AdminProductRentals'),
                    )
                ));
            } else {
                $validationErrors[] = 'Error';
                die(Tools::jsonEncode(array(
                    'result' => 0,
                    'errors' => $validationErrors,
                )));
            }
        } catch (Exception $e) {
            $validationErrors = array();
            $validationErrors[] = $e->getMessage();
            error_log($e->getMessage());
            $json = Tools::jsonEncode(array(
                'result' => 0,
                'errors' => $validationErrors,
                'exception' => $e,
            ));
            die($json);
        }
    }

    public function ajaxProcessGetCalendarRentalSummaryModal()
    {
        $validationErrors = array();
        if ($this->tabAccess['add'] === '0') {
            $validationErrors[] = $this->l('You do not have the right permission');
            die(Tools::jsonEncode(
                array(
                    'result' => 'error',
                    'errors' => $validationErrors
                )
            ));
        }

        try {
            $id_roja45_product_rental = Tools::getValue('id_roja45_product_rental');
            $rental = new ProductRentalRental($id_roja45_product_rental);
            if (!Validate::isLoadedObject($rental)) {
                throw new Exception('[SubmitRequestPayment] '. $this->l('The reservation could be loaded.'));
            }
            $tpl = $this->context->smarty->createTemplate(
                $this->getTemplatePath('modal-calendar-rental-summary.tpl') . 'modal-calendar-rental-summary.tpl'
            );
            $data = $this->getRentalData($rental, false);
            $summary = $rental->getSummary(Context::getContext()->language->id);
            $tpl->assign($summary);
            $tpl->assign($data);
            $tpl->assign(
                array(
                    'controller_url' => $this->context->link->getAdminLink('AdminProductRentals', true),
                )
            );
            die(Tools::jsonEncode(
                array(
                    'result' => 1,
                    'view' => $tpl->fetch(),
                    'response' => 'success',
                )
            ));
        } catch (Exception $e) {
            $validationErrors = array();
            $validationErrors[] = $e->getMessage();
            $json = Tools::jsonEncode(array(
                'result' => 'error',
                'errors' => $validationErrors,
                'exception' => $e,
            ));
            die($json);
        }
    }

    public function ajaxProcessCalendarDeleteRental()
    {
        $validationErrors = array();
        if ($this->tabAccess['edit'] === '0') {
            $validationErrors[] = $this->l('You do not have the right permission', 'AdminProductRentals');
            die(Tools::jsonEncode(
                array(
                    'result' => 'error',
                    'errors' => $validationErrors
                )
            ));
        }
        try {
            if (!$id_roja45_product_rental = Tools::getValue('id_roja45_product_rental')) {
                $validationErrors[] = $this->l('Rental Id missing', 'AdminProductRentals');
            }

            if (!count($validationErrors)) {
                $rental = new ProductRentalRental($id_roja45_product_rental);
                if (!Validate::isLoadedObject($rental)) {
                    throw new Exception(
                        '[SubmitRequestPayment] ' . $this->l(
                            'The rental could be loaded.',
                            'AdminProductRentals'
                        )
                    );
                }
                if ($rental->setStatus(ProductRentalRentalStatus::$DLTD)) {
                    $start_date = Tools::getValue('start_date');
                    $number_days = Tools::getValue('number_days');
                    $redirect = $this->context->link->getAdminLink(
                        'AdminRentalCalendar',
                        true
                    );
                    $redirect .= '&start_date='.$start_date.'&offset=0&number_days='.$number_days;
                    die(Tools::jsonEncode(
                        array(
                            'result' => 1,
                            'response' => $this->l(
                                'Rental marked as deleted.',
                                'AdminProductRentals'
                            ),
                            'redirect' => $redirect
                        )
                    ));
                } else {
                    $validationErrors[] = $this->l(
                        'Unable to update status.',
                        'AdminProductRentals'
                    );
                    die(Tools::jsonEncode(
                        array(
                            'result' => 0,
                            'errors' => $validationErrors
                        )
                    ));
                }
            } else {
                $validationErrors[] = $this->l('Validation Errors', 'AdminProductRentals');
                $json = Tools::jsonEncode(array(
                    'result' => 0,
                    'errors' => $validationErrors,
                ));
                die($json);
            }
        } catch (Exception $e) {
            $validationErrors = array();
            $validationErrors[] = $e->getMessage();
            error_log($e->getMessage());
            $json = Tools::jsonEncode(array(
                'result' => 0,
                'errors' => $validationErrors,
                'exception' => $e,
            ));
            die($json);
        }
    }

    public function ajaxProcessCalendarCancelRental()
    {
        $validationErrors = array();
        if ($this->tabAccess['edit'] === '0') {
            $validationErrors[] = $this->l('You do not have the right permission', 'AdminProductRentals');
            die(Tools::jsonEncode(
                array(
                    'result' => 'error',
                    'errors' => $validationErrors
                )
            ));
        }
        try {
            if (!$id_roja45_product_rental = Tools::getValue('id_roja45_product_rental')) {
                $validationErrors[] = $this->l('Rental Id missing', 'AdminProductRentals');
            }

            if (!count($validationErrors)) {
                $rental = new ProductRentalRental($id_roja45_product_rental);
                if (!Validate::isLoadedObject($rental)) {
                    throw new Exception(
                        '[SubmitRequestPayment] ' . $this->l(
                            'The rental could be loaded.',
                            'AdminProductRentals'
                        )
                    );
                }
                if ($rental->setStatus(ProductRentalRentalStatus::$CCLD)) {
                    $start_date = Tools::getValue('start_date');
                    $number_days = Tools::getValue('number_days');
                    $redirect = $this->context->link->getAdminLink(
                        'AdminRentalCalendar',
                        true
                    );
                    $redirect .= '&start_date='.$start_date.'&offset=0&number_days='.$number_days;
                    die(Tools::jsonEncode(
                        array(
                            'result' => 1,
                            'response' => $this->l(
                                'Rental cancelled.',
                                'AdminProductRentals'
                            ),
                            'redirect' => $redirect
                        )
                    ));
                } else {
                    $validationErrors[] = $this->l(
                        'Unable to update status.',
                        'AdminProductRentals'
                    );
                    die(Tools::jsonEncode(
                        array(
                            'result' => 0,
                            'errors' => $validationErrors
                        )
                    ));
                }
            } else {
                $validationErrors[] = $this->l('Validation Errors', 'AdminProductRentals');
                $json = Tools::jsonEncode(array(
                    'result' => 0,
                    'errors' => $validationErrors,
                ));
                die($json);
            }
        } catch (Exception $e) {
            $validationErrors = array();
            $validationErrors[] = $e->getMessage();
            error_log($e->getMessage());
            $json = Tools::jsonEncode(array(
                'result' => 0,
                'errors' => $validationErrors,
                'exception' => $e,
            ));
            die($json);
        }
    }

    public function ajaxProcessGetCalendarDatesModal()
    {
        $validationErrors = array();
        if ($this->tabAccess['edit'] === '0') {
            $validationErrors[] = $this->l('You do not have the right permission', 'AdminProductRentals');
            die(Tools::jsonEncode(
                array(
                    'result' => 'error',
                    'errors' => $validationErrors
                )
            ));
        }
        try {
            $id_roja45_product = Tools::getValue('id_roja45_product');
            $rental_product = new ProductRentalDetails($id_roja45_product, (int)$this->context->language->id);
            if (Validate::isLoadedObject($rental_product)) {
                $date = DateTime::createFromFormat('Y-m-d H:i:s', Tools::getValue('start_date') . ' 00:00:00');
                $start_date = $date->format($this->context->language->date_format_lite);
                $date = DateTime::createFromFormat('Y-m-d H:i:s', Tools::getValue('end_date') . ' 00:00:00');
                $end_date = $date->format($this->context->language->date_format_lite);
                $id_roja45_product_model = Tools::getValue('id_roja45_product_model');
                if ($id_roja45_product_model) {
                    $models = ProductRentalModel::getModel(
                        $id_roja45_product,
                        $id_roja45_product_model,
                        (int)$this->context->language->id
                    );
                } else {
                    $models = ProductRentalModel::getModels(
                        $id_roja45_product,
                        (int)$this->context->language->id
                    );
                }

                foreach ($models as &$model) {
                    $modelObj = new ProductRentalModel($model['id_roja45_product_model'], $this->context->language->id);
                    $model['name'] = $modelObj->getModelName($this->context->language->id);

                    $rates = ProductRentalRate::getRates(
                        $id_roja45_product,
                        $model['id_roja45_product_model'],
                        $this->context->language->id
                    );
                    foreach ($rates as &$rate) {
                        $rate['rate_formatted'] = Tools::displayPrice(Tools::convertPrice($rate['rate']));
                    }
                    $model['rates'] = $rates;
                }
                $tpl = $this->context->smarty->createTemplate(
                    $this->getTemplatePath('modal-calendar-dates.tpl') . 'modal-calendar-dates.tpl'
                );
                $tpl->assign(
                    array(
                        'id_roja45_product' => $id_roja45_product,
                        'controller_url' => $this->context->link->getAdminLink('AdminProductRentals', true),
                        'models' => $models,
                        'start_date' => $start_date,
                        'end_date' => $end_date,
                        'roja45_productrental_controller' => $this->context->link->getAdminLink('AdminProductRentals'),
                        'roja45_productrental_dateformat' => RojaFortyFiveProductRentalCore::convertDateFormat(
                            $this->context->language->date_format_lite
                        ),
                    )
                );
                die(Tools::jsonEncode(array(
                    'result' => 1,
                    'view' => $tpl->fetch(),
                )));
            } else {
                die(Tools::jsonEncode(array(
                    'result' => 0,
                )));
            }
        } catch (Exception $e) {
            $validationErrors = array();
            $validationErrors[] = $e->getMessage();
            error_log($e->getMessage());
            $json = Tools::jsonEncode(array(
                'result' => false,
                'errors' => $validationErrors,
                'exception' => $e,
            ));
            die($json);
        }
    }

    public function ajaxProcessGetChangeDatesModal()
    {
        $validationErrors = array();
        if ($this->tabAccess['edit'] === '0') {
            $validationErrors[] = $this->l('You do not have the right permission', 'AdminProductRentals');
            die(Tools::jsonEncode(
                array(
                    'result' => 'error',
                    'errors' => $validationErrors
                )
            ));
        }
        try {
            $id_roja45_product_rental = Tools::getValue('id_roja45_product_rental');
            $rental = new ProductRentalRental($id_roja45_product_rental, (int)$this->context->language->id);
            if (Validate::isLoadedObject($rental)) {
                $rental_product = new ProductRentalDetails(Tools::getValue('id_roja45_product'));
                $id_roja45_product_rental_model = Tools::getValue('id_roja45_rental_model');
                $rental_model = new ProductRentalRentalModel(
                    $id_roja45_product_rental_model,
                    (int)$this->context->language->id
                );

                $list = array();
                if (Validate::isLoadedObject($rental_product) && $rental_product->id_roja45_product) {
                    $models = ProductRentalModel::getModels($rental_product->id_roja45_product);
                    $rental_data = array();

                    $models_data = array();
                    foreach ($models as $model) {
                        $model = new ProductRentalModel(
                            $model['id_roja45_product_model'],
                            (int)$this->context->language->id
                        );

                        $rates = ProductRentalRate::getRates(
                            Tools::getValue('id_roja45_product'),
                            $model->id_roja45_product_model,
                            (int)$this->context->language->id
                        );
                        $custom_rates = $model->getCustomRates($this->context->language->id);
                        $models_data[] = array(
                            'id_roja45_product_model' => $model->id_roja45_product_model,
                            'available' => ProductRentalDetails::getStockOnHand(
                                $rental_product->id_roja45_product,
                                $model->id_roja45_product_model
                            ),
                            'name' => $model->getModelName($this->context->language->id),
                            'unavailable' => 0,
                            'total' => 0,
                            'rates' => $rates,
                            'custom_rates' => $custom_rates,
                        );
                    }
                    $rental_data['models'] = $models_data;
                    $list['tr'] = array(
                        'name' => $rental_product->getName((int)$this->context->language->id),
                        'id_roja45_product' => Tools::getValue('id_roja45_product'),
                        'rental_data' => $rental_data,
                        'offset' => 0,
                    );
                }

                $period = 30;
                $start_date = $rental_model->start_date;
                $start_date = new DateTime($start_date);
                $start_date->sub(new DateInterval('P2D'));

                $month_dates = RojaFortyFiveProductRentalCore::createDateRangeArray(
                    $start_date,
                    $period
                );

                $rentals = ProductRentalRental::getRentalsForDateRange(
                    $month_dates[0]['date'] . ' 00:00:00',
                    $month_dates[$period-1]['date']  . ' 00:00:00',
                    $this->context->language->id,
                    $this->context->shop->id,
                    Tools::getValue('id_roja45_product')
                );

                foreach ($rentals as &$rental) {
                    $rental['preparation'] = (int) Configuration::get('ROJA45_PRODUCTRENTAL_PREPARATIONDAYS');
                    $rental['recondition'] = (int) Configuration::get('ROJA45_PRODUCTRENTAL_RECONDITIONDAYS');
                    $date = new DateTime($rental['start_date'] . ' ' . $rental['collection_time']);
                    $rental['collection_formatted'] = $date->format('Y-m-d @ H:i');
                    $date = new DateTime($rental['end_date'] . ' ' . $rental['return_time']);
                    $rental['return_formatted'] = $date->format('Y-m-d @ H:i');
                    if (($rental['id_roja45_product_rental'] == $id_roja45_product_rental) &&
                        ($rental['id_roja45_product_model'] == $rental_model->id_roja45_product_model)
                    ) {
                        $rental['active'] = 1;
                    } else {
                        $rental['active'] = 0;
                    }
                }

                $unavailables = ProductUnavailable::getUnavailable(
                    Tools::getValue('id_roja45_product'),
                    Tools::getValue('id_roja45_product_model')
                );

                $calendar_tpl = $this->context->smarty->createTemplate(
                    $this->getTemplatePath('rental-calendar-summary.tpl') . 'rental-calendar-summary.tpl'
                );
                $calendar_tpl->assign(array(
                    'roja45_calendar_controller' => $this->context->link->getAdminLink(
                        'AdminRentalCalendar',
                        true
                    ),
                    'roja45_rental_controller' => $this->context->link->getAdminLink(
                        'AdminProductRentals',
                        true
                    ),
                    'roja45_productrental_dateformat' => RojaFortyFiveProductRentalCore::convertDateFormat(
                        $this->context->language->date_format_lite
                    ),
                    'dates' => $month_dates,
                    'start_date' => $month_dates[0]['date'],
                    'period' => $period,
                    'end_date' => $month_dates[$period-1]['date'],
                    'days' => $period,
                    'rentals' => $rentals,
                    'unavailables' => $unavailables,
                    'list' => $list,
                    'past_selectable' => 1,
                ));

                $rate_durations = ProductRentalRateDuration::getRateDurations(
                    true,
                    (int)$this->context->language->id
                );

                $rates = ProductRentalRate::getRates(
                    Tools::getValue('id_roja45_product'),
                    Tools::getValue('id_roja45_product_model')
                );
                $rate_duration = new ProductRentalRateDuration($rate_durations[0]['id_roja45_product_rateduration']);

                $collection_date = new DateTime($rental_model->start_date);
                $return_date = new DateTime($rental_model->end_date);
                $periods = $rate_duration->getPeriods(
                    $rental_model->start_date . ' ' . $rental_model->collection_time,
                    $rental_model->end_date . ' ' . $rental_model->return_time,
                    'Y-m-d H:s:i'
                );

                $controls_tpl = $this->context->smarty->createTemplate(
                    $this->getTemplatePath('rental-calendar-controls.tpl') . 'rental-calendar-controls.tpl'
                );

                $controls_tpl->assign(array(
                    'id_roja45_product' => Tools::getValue('id_roja45_product'),
                    'id_roja45_product_model' => Tools::getValue('id_roja45_product_model'),
                    'id_roja45_rental_product' => $rental_model->id_roja45_product_rental_product,
                    'id_roja45_rental_model' => $rental_model->id_roja45_product_rental_model,
                    'collection_date' => $collection_date->format($this->context->language->date_format_lite),
                    'collection_time' => $rental_model->collection_time,
                    'return_date' => $return_date->format($this->context->language->date_format_lite),
                    'return_time' => $rental_model->return_time,
                    'rate_durations' => $rate_durations,
                    'periods' => $periods,
                    'rates' => $rates,
                    'quantity' => $rental_model->qty,
                    'availability' => $model->getAvailableQuantity(),
                ));
                die(Tools::jsonEncode(array(
                    'result' => 1,
                    'calendar' => $calendar_tpl->fetch(),
                    'controls' => $controls_tpl->fetch(),
                )));
            } else {
                die(Tools::jsonEncode(array(
                    'result' => 0,
                )));
            }
        } catch (Exception $e) {
            $validationErrors = array();
            $validationErrors[] = $e->getMessage();
            error_log($e->getMessage());
            $json = Tools::jsonEncode(array(
                'result' => false,
                'errors' => $validationErrors,
                'exception' => $e,
            ));
            die($json);
        }
    }

    public function ajaxProcessValidateDates()
    {
        $validationErrors = array();
        if ($this->tabAccess['edit'] === '0') {
            $validationErrors[] = $this->l('You do not have the right permission', 'AdminProductRentals');
            die(Tools::jsonEncode(
                array(
                    'result' => 'error',
                    'errors' => $validationErrors
                )
            ));
        }

        try {
            if (!$rental_details= Tools::getValue('rental_details')) {
                $validationErrors[] = $this->module->l('No rental details provided');
            }

            if (!count($validationErrors)) {
                $rental_details = Tools::jsonDecode($rental_details);
                $rental_details = ProductRentalRental::validateRental($rental_details);
                if ($rental_details->rental_valid) {
                    $tpl = $this->context->smarty->createTemplate(
                        $this->getTemplatePath('rental-calendar-totals.tpl') . 'rental-calendar-totals.tpl'
                    );

                    $tpl->assign(array(
                        'rental_details' => $rental_details,
                    ));
                    die(Tools::jsonEncode(
                        array(
                            'result' => 1,
                            'totals' => $tpl->fetch(),
                            'response' => $this->l('Success', 'AdminProductRentals')
                        )
                    ));
                } else {
                    throw new Exception($this->l('Rental is not valid', 'AdminProductRentals'));
                }
            } else {
                throw new Exception($this->l('There are validation errors', 'AdminProductRentals'));
            }
        } catch (Exception $e) {
            $validationErrors = array();
            $validationErrors[] = $e->getMessage();
            error_log($e->getMessage());
            $json = Tools::jsonEncode(array(
                'result' => 0,
                'errors' => $validationErrors,
                'exception' => $e,
            ));
            die($json);
        }
    }

    public function ajaxProcessApplyNewDates()
    {
        $validationErrors = array();
        if ($this->tabAccess['edit'] === '0') {
            $validationErrors[] = $this->l('You do not have the right permission', 'AdminProductRentals');
            die(Tools::jsonEncode(
                array(
                    'result' => 'error',
                    'errors' => $validationErrors
                )
            ));
        }

        try {
            if (!$id_roja45_product_rental = Tools::getValue('id_roja45_product_rental')) {
                $validationErrors[] = $this->l('Rental product id missing', 'AdminProductRentals');
            }
            if (!$rental_details= Tools::getValue('rental_details')) {
                $validationErrors[] = $this->module->l('No rental details provided');
            }

            if (!count($validationErrors)) {
                $rental = new ProductRentalRental($id_roja45_product_rental);
                if (!Validate::isLoadedObject($rental)) {
                    throw new Exception($this->l('Unable to load rental', 'AdminProductRentals'));
                }
                $rental_details = Tools::jsonDecode($rental_details);
                $rental_details = ProductRentalRental::validateRental($rental_details);
                if ($rental_details->rental_valid && ProductRentalRental::updateRental($id_roja45_product_rental, $rental_details)) {
                    die(Tools::jsonEncode(
                        array(
                            'result' => 1,
                            'redirect' => $this->context->link->getAdminLink(
                                'AdminProductRentals',
                                true
                            ).'&id_roja45_product_rental='.$id_roja45_product_rental.'&view'.$this->table,
                            'response' => $this->l('Success', 'AdminProductRentals')
                        )
                    ));
                }
            } else {
                throw new Exception($this->l('There are validation errors', 'AdminProductRentals'));
            }
        } catch (Exception $e) {
            $validationErrors = array();
            $validationErrors[] = $e->getMessage();
            error_log($e->getMessage());
            $json = Tools::jsonEncode(array(
                'result' => 0,
                'errors' => $validationErrors,
                'exception' => $e,
            ));
            die($json);
        }
    }

    public function ajaxProcessGetUpdateBlockedDatesModal()
    {
        $validationErrors = array();
        if ($this->tabAccess['edit'] === '0') {
            $validationErrors[] = $this->l('You do not have the right permission', 'AdminProductRentals');
            die(Tools::jsonEncode(
                array(
                    'result' => 'error',
                    'errors' => $validationErrors
                )
            ));
        }
        try {
            $id_roja45_product_unavailable = Tools::getValue('id_roja45_product_unavailable');
            $unavailable = new ProductUnavailable($id_roja45_product_unavailable);
            if (Validate::isLoadedObject($unavailable)) {
                $tpl = $this->context->smarty->createTemplate(
                    $this->getTemplatePath('modal-calendar-edit-blocked.tpl') . 'modal-calendar-edit-blocked.tpl'
                );
                $date = DateTime::createFromFormat('Y-m-d', $unavailable->start_date);
                $start_date = $date->format($this->context->language->date_format_lite);
                $date = DateTime::createFromFormat('Y-m-d', $unavailable->end_date);
                $end_date = $date->format($this->context->language->date_format_lite);
                $tpl->assign(
                    array(
                        'id_roja45_product_unavailable' => $id_roja45_product_unavailable,
                        'start_date' => $start_date,
                        'end_date' => $end_date,
                        'roja45_productrental_controller' => $this->context->link->getAdminLink('AdminProductRentals'),
                        'roja45_productrental_dateformat' => RojaFortyFiveProductRentalCore::convertDateFormat(
                            $this->context->language->date_format_lite
                        ),
                    )
                );
                die(Tools::jsonEncode(array(
                    'result' => 1,
                    'view' => $tpl->fetch(),
                    'start_date' => $start_date,
                    'end_date' => $end_date,
                )));
            } else {
                die(Tools::jsonEncode(array(
                    'result' => 0,
                )));
            }
        } catch (Exception $e) {
            $validationErrors = array();
            $validationErrors[] = $e->getMessage();
            error_log($e->getMessage());
            $json = Tools::jsonEncode(array(
                'result' => false,
                'errors' => $validationErrors,
                'exception' => $e,
            ));
            die($json);
        }
    }

    public function ajaxProcessGetPayBalancePOSModal()
    {
        $validationErrors = array();
        if ($this->tabAccess['edit'] === '0') {
            $validationErrors[] = $this->l('You do not have the right permission', 'AdminProductRentals');
            die(Tools::jsonEncode(
                array(
                    'result' => 'error',
                    'errors' => $validationErrors
                )
            ));
        }
        try {
            if (!$id_roja45_product_rental = Tools::getValue('id_roja45_product_rental')) {
                $validationErrors[] = $this->l('Rental Id missing', 'AdminProductRentals');
            }
            if (!count($validationErrors)) {
                $rental = new ProductRentalRental($id_roja45_product_rental);
                if (!Validate::isLoadedObject($rental)) {
                    throw new Exception($this->l('Unable to load rental', 'AdminProductRentals'));
                }

                $totals = $rental->getTotals();
                $tpl = $this->context->smarty->createTemplate(
                    $this->getTemplatePath('rentalview-modal-pay-balance.tpl') . 'rentalview-modal-pay-balance.tpl'
                );
                $tpl->assign(
                    array(
                        'total_to_pay_formatted' => Tools::displayPrice(Tools::convertPrice($totals['total_outstanding'])),
                        'total_to_pay' => $totals['total_outstanding'],
                        'total_to_pay_inc' => $totals['total_outstanding_inc'],
                        'total_to_pay_inc_formatted' => Tools::displayPrice(Tools::convertPrice($totals['total_outstanding_inc'])),
                        'total_tax_to_pay_formatted' => Tools::displayPrice(Tools::convertPrice($totals['total_outstanding_inc']-$totals['total_outstanding']))
                    )
                );
                $view = $tpl->fetch();
                die(Tools::jsonEncode(
                    array(
                        'result' => 1,
                        'response' => $this->l('Success', 'AdminProductRentals'),
                        'view' => $view
                    )
                ));
            } else {
                $validationErrors[] = $this->l('Validation Errors', 'AdminProductRentals');
                $json = Tools::jsonEncode(array(
                    'result' => 0,
                    'errors' => $validationErrors,
                ));
                die($json);
            }
        } catch (Exception $e) {
            $validationErrors = array();
            $validationErrors[] = $e->getMessage();
            error_log($e->getMessage());
            $json = Tools::jsonEncode(array(
                'result' => false,
                'errors' => $validationErrors,
                'exception' => $e,
            ));
            die($json);
        }
    }

    public function ajaxProcessPayBalancePOS()
    {
        $validationErrors = array();
        if ($this->tabAccess['edit'] === '0') {
            $validationErrors[] = $this->l('You do not have the right permission', 'AdminProductRentals');
            die(Tools::jsonEncode(
                array(
                    'result' => 'error',
                    'errors' => $validationErrors
                )
            ));
        }

        try {
            if (!$id_roja45_product_rental = Tools::getValue('id_roja45_product_rental')) {
                $validationErrors[] = $this->l('Rental Id missing', 'AdminProductRentals');
            }
            if (!$total_to_pay = Tools::getValue('total_to_pay')) {
                $validationErrors[] = $this->l('Total to pay missing', 'AdminProductRentals');
            }
            /*
            $id_currency = Tools::getValue('id_currency');
            if (!Tools::strlen($id_currency) > 0) {
                throw new Exception($this->l('You must provide a payment currency.', 'Reservations'));
            }
            */
            if (!count($validationErrors)) {
                $rental = new ProductRentalRental($id_roja45_product_rental);
                if (!Validate::isLoadedObject($rental)) {
                    throw new Exception($this->l('Unable to load rental', 'AdminProductRentals'));
                }
                $date = new DateTime();
                $date = $date->format('Y-m-d H:i:s');

                $payment = new ProductRentalRentalPayment();
                $payment->id_roja45_product_rental = $rental->id;
                $payment->id_roja45_product_payment_type = ProductRentalPaymentType::BALANCE;
                $payment->note = '';
                $payment->payment_due = 0;
                $payment->date_due = $date;
                $payment->requested = 1;
                $payment->completed = 1;
                $payment->date_completed = $date;
                $payment->date_requested = $date;
                $payment->date_paid = $date;
                $payment->total = Tools::convertPrice($total_to_pay, $rental->id_currency, false);
                if ($payment->save()) {
                    $products = $rental->getProducts();

                    // TODO - Create the order and confirm it.
                    $id_customer = $rental->id_customer;
                    $customer = new Customer((int)$id_customer);
                    $this->context->customer = $customer;
                    $this->context->cart = new Cart();
                    $this->context->cart->recyclable = 0;
                    $this->context->cart->gift = 0;
                    $this->context->cart->id_customer = $id_customer;
                    $this->context->cart->customer = new Customer((int) $id_customer);

                    if (Validate::isLoadedObject($this->context->cart) && $this->context->cart->OrderExists()) {
                        throw new Exception($this->l('An order already exists for this cart.', 'Reservations'));
                    }
                    if (!Validate::isLoadedObject($customer)) {
                        throw new Exception($this->l('The order customer does not have an account.', 'Reservations'));
                    }
                    if (!$this->context->cart->secure_key) {
                        $this->context->cart->secure_key = $this->context->customer->secure_key;
                    }
                    if (!$this->context->cart->id_shop) {
                        $this->context->cart->id_shop = (int)$this->context->shop->id;
                    }
                    if (!$this->context->cart->id_lang) {
                        $this->context->cart->id_lang = (($id_lang = (int)Tools::getValue('id_lang')) ? $id_lang : Configuration::get('PS_LANG_DEFAULT'));
                    }
                    $this->context->cart->id_currency = ($rental->id_currency ? $rental->id_currency : Configuration::get('PS_CURRENCY_DEFAULT'));
                    $currency = new Currency($this->context->cart->id_currency);
                    $this->context->currency = $currency;
                    $addresses = $customer->getAddresses((int)$this->context->cart->id_lang);
                    if (!count($addresses)) {
                        $address = new Address();
                        $address->id_country = Configuration::get('PS_COUNTRY_DEFAULT');
                        $address->id_state = 0;
                        $address->lastname = $customer->lastname;
                        $address->firstname = $customer->firstname;
                        $address->city = $this->l('UNKNOWN', 'Reservations');
                        $address->address1 = $this->l('UNKNOWN', 'Reservations');
                        $address->alias = $this->l('SYSTEM GENERATED', 'Reservations');
                        $address->save();

                        $this->context->cart->id_address_invoice = (int)$address->id;
                        $this->context->cart->id_address_delivery = (int)$address->id;
                    } else {
                        if (!$this->context->cart->id_address_invoice && isset($addresses[0])) {
                            $this->context->cart->id_address_invoice = (int)$addresses[0]['id_address'];
                        }

                        if (!$this->context->cart->id_address_delivery && isset($addresses[0])) {
                            $this->context->cart->id_address_delivery = $addresses[0]['id_address'];
                        }
                    }
                    $this->context->cart->setNoMultishipping();
                    $this->context->cart->save();

                    $mysql_date_now = date('Y-m-d H:i:s', strtotime(date('Y-m-d H:i:s'))-60 * 60);
                    $mysql_date_until = date('Y-m-d H:i:s', strtotime(date('Y-m-d H:i:s') . ' +1 day'));

                    $this->context->cart->checkedTOS = 1;
                    SpecificPrice::deleteByIdCart((int) $this->context->cart->id);
                    foreach ($products as $product) {
                        $models = ProductRentalRentalModel::getModels($product['id_roja45_product_rental_product']);
                        foreach ($models as $model) {
                            $previous_payments = $rental->getPaymentsForModel(
                                $product['id_product'],
                                $model['id_product_attribute']
                            );
                            $total_paid = 0;
                            foreach ($previous_payments as $previous_payment) {
                                $payment_item = new ProductRentalRentalPaymentItem(
                                    $previous_payment['id_roja45_product_rental_payment_item']
                                );
                                $total_paid += (float) $payment_item->total_paid;
                            }
                            $outstanding = $model['total'] - $total_paid;
                            $amount_to_apply = 0;
                            if ($outstanding && $outstanding<=$total_to_pay) {
                                $amount_to_apply = $outstanding;
                                $request_amount = $total_to_pay - $outstanding;
                            } else if ($outstanding && $outstanding>$total_to_pay) {
                                $amount_to_apply = $total_to_pay;
                                $request_amount = 0;
                            }

                            if ($amount_to_apply) {
                                $payment_item = new ProductRentalRentalPaymentItem();
                                $payment_item->id_roja45_product_rental_payment = $payment->id;
                                $payment_item->id_product = $product['id_product'];
                                $payment_item->id_product_attribute = $model['id_product_attribute'];
                                $payment_item->total_paid = $amount_to_apply;
                                $payment_item->save();
                            }

                            $specific_price = new SpecificPrice();
                            $specific_price->id_shop = $this->context->shop->id;
                            $specific_price->id_shop_group = $this->context->shop->id_shop_group;
                            $specific_price->id_currency = 0;
                            $specific_price->id_country = 0;
                            $specific_price->id_group = 0;
                            $specific_price->id_cart = (int) $this->context->cart->id;
                            $specific_price->id_customer = (int)$this->context->customer->id;
                            $specific_price->id_product = $product['id_product'];
                            $specific_price->id_product_attribute = $model['id_product_attribute'];
                            $specific_price->price = $amount_to_apply;
                            $specific_price->from_quantity = 1;
                            $specific_price->reduction = 0;
                            $specific_price->reduction_type = 'amount';
                            $specific_price->reduction_tax = 0;
                            $specific_price->from = '0000-00-00 00:00:00';
                            $specific_price->to = '0000-00-00 00:00:00';
                            if ($specific_price->save()) {
                                $in_cart = $this->context->cart->updateQty(
                                    $model['qty'],
                                    $product['id_product'],
                                    $model['id_product_attribute']
                                );
                            } else {
                                throw new Exception($this->module->l('Unable to create cart specific price:') . '['. Db::getInstance()->getMsgError() .']');
                            }
                        }
                    }

                    $payment_module = new BoOrder();
                    $bad_delivery = false;
                    if (($bad_delivery = (bool)!Address::isCountryActiveById((int)$this->context->cart->id_address_invoice))
                        || !Address::isCountryActiveById((int)$this->context->cart->id_address_invoice)) {
                        if ($bad_delivery) {
                            $validationErrors[] = $this->l('The invoice address country is not valid.');
                            die(Tools::jsonEncode(
                                array(
                                    'result' => 0,
                                    'errors' => $validationErrors,
                                )
                            ));
                        }
                    } else {
                        $subject = $this->l(
                            'Rental POS Payment',
                            'AdminProductRentals'
                        ).' ['.$rental->reference.']';
                        $validated = $payment_module->validateOrder(
                            (int)$this->context->cart->id,
                            Configuration::get('PS_OS_PAYMENT'),
                            $this->context->cart->getOrderTotal(true, Cart::BOTH),
                            $payment_module->displayName,
                            $subject,
                            array(),
                            $this->context->currency->id,
                            false,
                            $this->context->cart->secure_key
                        );

                        /**
                         * Hack for paypal module which returns null here
                         */
                        if (is_null($validated)) {
                            $validated = true;
                        }

                        if ($validated && $payment_module->currentOrder) {
                            $order = new Order($payment_module->currentOrder);
                            if (!Validate::isLoadedObject($order)) {
                                throw new Exception(
                                    $this->l('Unable to load new order details.', 'AdminProductRentals')
                                );
                            }
                            $payment->requested = 1;
                            $payment->id_order = $order->id;
                            $payment->date_paid = date('Y-m-d H:i:s');
                            $payment->total = $order->total_paid_tax_excl;
                            $payment->total_with_tax = $order->total_paid_tax_incl;

                            if ($order->total_paid == $order->total_paid_real) {
                                $payment->completed = 1;
                                $rental->setStatus(ProductRentalRentalStatus::$PAYC);
                            } else {
                                $payment->completed = 0;
                                $rental->setStatus(ProductRentalRentalStatus::$PAYU);
                            }

                            if ($payment->save()) {
                                die(Tools::jsonEncode(
                                    array(
                                        'result' => 1,
                                        'redirect' => $this->context->link->getAdminLink(
                                            'AdminProductRentals',
                                            true
                                        ).'&id_roja45_product_rental='.$id_roja45_product_rental.'&view'.$this->table,
                                    )
                                ));
                            }
                        } else {
                            throw new Exception($this->l('An error occurred while creating the order.'));
                        }
                    }
                    die(Tools::jsonEncode(
                        array(
                            'result' => 1,
                            'response' => $this->l('Success', 'AdminProductRentals'),
                        )
                    ));
                } else {
                    throw new Exception($this->l('Unable to create payment', 'AdminProductRentals'));
                }
            } else {
                throw new Exception($this->l('Validation Errors', 'AdminProductRentals'));
            }
        } catch (Exception $e) {
            $validationErrors = array();
            $validationErrors[] = $e->getMessage();
            error_log($e->getMessage());
            $json = Tools::jsonEncode(array(
                'result' => false,
                'errors' => $validationErrors,
                'exception' => $e,
            ));
            die($json);
        }
    }
    /**
     * @param ProductRentalRental $rental
     * @param bool $update
     * @return string
     */
    private function getRentalForm($rental, $update = true)
    {
        $view = '';
        $tpl = $this->context->smarty->createTemplate(
            $this->getTemplatePath('_adminHeader.tpl') . '_adminHeader.tpl'
        );
        $view .= $tpl->fetch();

        $data = $this->getRentalData($rental, $update);
        $tpl = $this->context->smarty->createTemplate(
            $this->getTemplatePath('rentalview.tpl') . 'rentalview.tpl'
        );
        $tpl->assign($data);
        // TODO - CAll hook to display reservation object detail
        $summary = $rental->getSummary(Context::getContext()->language->id);
        $tpl->assign($summary);
        $view .= $tpl->fetch();

        $tpl = $this->context->smarty->createTemplate(
            $this->getTemplatePath('/prestui/ps-tags.tpl') . 'prestui/ps-tags.tpl'
        );
        $view .= $tpl->fetch();
        return $view;
    }

    /**
     * @param ProductRentalRental $rental
     * @param $update
     * @return array
     */
    private function getRentalData($rental, $update)
    {
        $current_status = new ProductRentalRentalStatus(
            $rental->id_roja45_product_rental_status,
            $this->context->language->id
        );
        $process = ProductRentalRentalProcess::getRentalProcess($rental->id, $this->context->language->id);
        $lang = new Language($rental->id_lang);
        if (!(int)$rental->id_currency) {
            $currency = new Currency((int)Configuration::get('PS_CURRENCY_DEFAULT'));
        } else {
            $currency = new Currency((int)$rental->id_currency);
        }

        // TODO if status in this list, disable editing.
        $disabled_states = array('CHKT', 'ARVD', 'LEAV', 'COMP');
        $editing_disabled = 0;
        if (in_array($current_status->code, $disabled_states)) {
            $editing_disabled = 1;
        }
        $convert_cart = 0;
        if ($current_status->code == 'CHKT') {
            $convert_cart = 1;
        }
        $notes = $rental->getNotes();
        $messages = $rental->getMessages();
        $currencies = Currency::getCurrencies(false, true);
        $customer = new Customer($rental->id_customer);
        $gender = new Gender((int)$customer->id_gender, $this->context->language->id);

        $customer_addresses = array();
        $id_address = Address::getFirstCustomerAddressId($rental->id_customer);
        $address = new Address($id_address);
        $addressFields = AddressFormat::getOrderedAddressFields($address->id_country);
        $addressFormatedValues = AddressFormat::getFormattedAddressFieldsValues($address, $addressFields);
        $addressFormatedValues['alias'] = $address->alias;
        $customer_addresses[] = $addressFormatedValues;

        $statuses = ProductRentalRentalStatus::getStates($this->context->language->id);
        $tax_enabled = Configuration::get('PS_TAX');
        $use_tax = true;
        if (Tax::excludeTaxeOption()) {
            $use_tax = false;
        }

        $totals = $rental->getTotals();
        $payment_types = ProductRentalPaymentType::getPaymentTypes(Context::getContext()->language->id);
        foreach ($payment_types as $key => $payment_type) {
            if (($payment_type['id_roja45_product_payment_type'] == ProductRentalPaymentType::DEPOSIT) &&
                $rental->isDepositPaid()
            ) {
                unset($payment_types[$key]);
            }
            if (($payment_type['id_roja45_product_payment_type'] == ProductRentalPaymentType::BALANCE) &&
                ($totals['total_outstanding'] == 0)
            ) {
                unset($payment_types[$key]);
            }
            if (($payment_type['id_roja45_product_payment_type'] == ProductRentalPaymentType::OTHER) &&
                (!(int) Configuration::get('ROJA45_PRODUCTRENTAL_ENABLEOTHERRENTALPAYMENTS')
                )) {
                unset($payment_types[$key]);
            }
        }

        $payments = $rental->getPayments();
        $total_payments = 0;
        foreach ($payments as &$payment) {
           // $payment['amount'] = $payment['total'];
            $total_payments += $payment['total'];
            $payment['confirmed'] = 0;
            $payment['completed'] = 0;
            $payment['reference'] = '';
            if ((int) $payment['id_order']) {
                $order = new Order($payment['id_order']);
                $payment['link'] = Context::getContext()->link->getAdminLink(
                    'AdminOrders'
                ) . '&vieworder&id_order=' . $payment['id_order'];
                $payment['reference'] = $order->reference;

                if ($order->total_paid_real > 0) {
                    $payment['received'] = $order->total_paid_real;
                    $payment['confirmed'] = 1;
                } else {
                    $payment['received'] = 0;
                    $payment['confirmed'] = 0;
                }
                if ($payment['date_paid'] == '0000-00-00 00:00:00') {
                    $payment['paid'] = '';
                } else {
                }
                $payment['completed'] = 1;
            }
            $payment['number_requests'] = (int) $payment['reminders_sent'] + 1;
            $payment_type = new ProductRentalPaymentType(
                $payment['id_roja45_product_payment_type'],
                Context::getContext()->language->id
            );
            $payment['type'] = $payment_type->name;
        }

        $data = array(
            'roja45_productrental_controller' => $this->context->link->getAdminLink('AdminProductRentals'),
            'roja45_productrental_dateformat' => RojaFortyFiveProductRentalCore::convertDateFormat(
                $this->context->language->date_format_lite
            ),
            'roja45_productrental_preparationdays' => Configuration::get('ROJA45_PRODUCTRENTAL_PREPARATIONDAYS'),
            'roja45_productrental_reconditiondays' => Configuration::get('ROJA45_PRODUCTRENTAL_RECONDITIONDAYS'),
            'roja45_productrental_enabletimeselect' => (int) Configuration::get(
                'ROJA45_PRODUCTRENTAL_ENABLECUSTOMERTIMESELECT'
            ),
            'editing_disabled' => (int) $editing_disabled,
            'convert_cart' => (int) $convert_cart,
            'languages' => $this->context->controller->getLanguages(),
            'link' => $this->context->link,
            'payment_methods' => PaymentModule::getInstalledPaymentModules(),
            'payment_profiles' => ProductRentalPaymentProfile::getPaymentProfiles((int)$this->context->language->id),
            'order_states' => OrderState::getOrderStates(Context::getContext()->language->id),
            'rental' => $rental,
            'update' => $update,
            'total_payments' => $total_payments,
            'payment_types' => $payment_types,
            'payments' => $payments,
            'customer' => $customer,
            'customer_addresses' => $customer_addresses,
            'gender' => $gender,
            'default_collection_time' => Configuration::get('ROJA45_PRODUCTRENTAL_COLLECTIONTIME'),
            'default_return_time' => Configuration::get('ROJA45_PRODUCTRENTAL_RETURNTIME'),
            'customer_confirmed' => ProductRentalRentalProcess::exists($rental->id, ProductRentalRentalStatus::$CCNF),
            'prereserved' => ProductRentalRentalProcess::exists($rental->id, ProductRentalRentalStatus::$PRES),
            'confirmed' => ProductRentalRentalProcess::exists($rental->id, ProductRentalRentalStatus::$CONF),
            'use_tax' => $use_tax,
            'customerStats' => $customer->getStats(),
            'default_currency' => $currency,
            'notes' => $notes,
            'messages' => $messages,
            'statuses' => $statuses,
            'current_status' => $current_status,
            'process' => $process,
            'currencies' => $currencies,
            'lang' => $lang,
            'current_id_lang' => $this->context->language->id,
            'current_index' => self::$currentIndex,
            'cancelled' => ($current_status->code == ProductRentalRentalStatus::$CCLD),
            'return_status' => new ProductRentalRentalStatus(
                ProductRentalRentalStatus::getStatusByType(ProductRentalRentalStatus::$RDUE)
            ),
            'overdue_status' => new ProductRentalRentalStatus(
                ProductRentalRentalStatus::getStatusByType(ProductRentalRentalStatus::$OVER)
            ),
        );

        if ($rental->getFirstOrder()) {
            $order = new Order($rental->getFirstOrder());
            $addressInvoice = new Address($order->id_address_invoice, $this->context->language->id);
            $invoiceState = 0;
            if (Validate::isLoadedObject($addressInvoice) && $addressInvoice->id_state) {
                $invoiceState = new State((int)$addressInvoice->id_state);
            }
            $addressFields = AddressFormat::getOrderedAddressFields($addressInvoice->id_country);
            $addressFormatedValues = AddressFormat::getFormattedAddressFieldsValues($addressInvoice, $addressFields);

            $address_data = array(
                'address' => $addressInvoice,
                'address_full' => $addressFormatedValues,
                'state' => $invoiceState
            );
            $data = array_merge($address_data, $data);
        }
        return $data;
    }
}
