<?php
/**
 * RentalCalendarController
 *
 * @author    Roja45
 * @copyright 2016 Roja45
 * @license   license.txt
 * @category  RentalCalendarController
 *
 * 2016 ROJA45 - All rights reserved.
 *
 * DISCLAIMER
 * Changing this file will render any support provided by us null and void.
 */

/**
 * RentalCalendarController
 *
 * @author    Roja45
 * @copyright 2016 Roja45
 * @license   license.txt
 * @category  Class
 *
 * 2016 ROJA45 - All rights reserved.
 *
 * DISCLAIMER
 * Changing this file will render any support provided by us null and void.
 */

class AdminRentalCalendarController extends ModuleAdminController
{
    /**
     * Constructor
     */
    public function __construct()
    {
        parent::__construct();
        $this->context = Context::getContext();
        $this->bootstrap = true;
        $this->override_folder = 'rental_calendar/';
        $this->tpl_folder = 'rental_calendar/';
        $this->table = 'roja45_productrental_details';
        $this->identifier = 'id_roja45_product';
        $this->submit_action = $this->context->link->getAdminLink('AdminRentalCalendar', true);
        $this->show_cancel_button = true;
        $this->className = 'ProductRentalDetails';
        $this->deleted = false;
        $this->colorOnBackground = false;
        $this->list_no_link = true;
        $this->addRowAction('viewCalendarRates');
        $this->addRowAction('viewCalendarRentals');

        //$this->_use_found_rows = true;

        $this->default_number_days = 14;
        $this->default_past_days = 1;

        $this->fields_list = array(
            'id_roja45_product' => array(
                'title' => $this->module->l('Id'),
                'class' => 'fixed-width-xs',
                'filter_type' => 'int',
            ),
            'product_name' => array(
                'title' => $this->l('Product'),
                'width' => 'auto',
                'havingFilter' => true,
            )
        );

        $this->_select = 'pds.enabled as shop_enabled,
            pl.name as product_name, image_shop.`id_image` AS `id_image`,shop.name as shop_name,
            (SELECT count(id_roja45_product_model) 
            FROM `'._DB_PREFIX_.'roja45_productrental_model` m 
            WHERE m.id_roja45_product = a.id_roja45_product) as number_models';

        if (Shop::getContext() == Shop::CONTEXT_SHOP && Shop::isFeatureActive()) {
            $this->_join =
                'LEFT JOIN `'._DB_PREFIX_.'roja45_productrental_details_shop` pds ON a.id_roja45_product = pds.id_roja45_product AND pds.`id_shop` = '. (int) Context::getContext()->shop->id .'
                LEFT JOIN `'._DB_PREFIX_.'product` p ON p.id_product = a.id_product
                LEFT JOIN `'._DB_PREFIX_.'product_lang` pl ON (p.`id_product` = pl.`id_product` AND pl.`id_shop` = '. (int) Context::getContext()->shop->id .')
                LEFT JOIN `'._DB_PREFIX_.'shop` shop ON (shop.id_shop = '. (int) Context::getContext()->shop->id .')
                LEFT JOIN `'._DB_PREFIX_.'image_shop` image_shop ON (image_shop.`id_product` = a.`id_product` AND image_shop.`cover` = 1 AND image_shop.`id_shop` = '. (int) Context::getContext()->shop->id .')
                LEFT JOIN `'._DB_PREFIX_.'image` i ON (i.`id_image` = image_shop.`id_image`)';
        } else {
            $this->_join =
                'LEFT JOIN `'._DB_PREFIX_.'roja45_productrental_details_shop` pds ON a.id_roja45_product = pds.id_roja45_product AND pds.`id_shop` = '. (int) Context::getContext()->shop->id .'
                LEFT JOIN `'._DB_PREFIX_.'product` p ON p.id_product = a.id_product
                LEFT JOIN `'._DB_PREFIX_.'product_lang` pl ON (p.`id_product` = pl.`id_product` AND pl.`id_shop` = a.id_shop_default)
                LEFT JOIN `'._DB_PREFIX_.'shop` shop ON (shop.id_shop = a.id_shop_default)
                LEFT JOIN `'._DB_PREFIX_.'image_shop` image_shop ON (image_shop.`id_product` = a.`id_product` AND image_shop.`cover` = 1 AND image_shop.`id_shop` = a.id_shop_default)
                LEFT JOIN `'._DB_PREFIX_.'image` i ON (i.`id_image` = image_shop.`id_image`)';
        }

        $this->_where .= ' AND pl.id_lang = '.(int) Context::getContext()->language->id;

        $this->_defaultOrderBy = $this->identifier = 'id_roja45_product';
        $this->_orderBy = 'id_roja45_product';
        $this->_orderWay = 'ASC';

        $this->explicitSelect = false;
        $this->_use_found_rows = false;

        $this->tabAccess = Profile::getProfileAccess(
            $this->context->employee->id_profile,
            Tab::getIdFromClassName('AdminRentalCalendar')
        );
    }

    public function setMedia($isNewTheme = false)
    {
        parent::setMedia($isNewTheme);
        $this->context->controller->addCSS(_PS_MODULE_DIR_ . $this->module->name . '/views/css/roja45productadmin.css');
        if ($this->display &&
            isset($this->tabAccess[$this->display]) &&
            $this->tabAccess[$this->display] == 1 &&
            in_array($this->display, array('view', 'edit'))
        ) {
            if (Tools::getValue('action')=='view_rentals') {
                $this->context->controller->addJs(
                    _PS_MODULE_DIR_ . $this->module->name . '/views/js/roja45productrentaladmin_calendar.js'
                );
            }
            if (Tools::getValue('action')=='view_rates') {
                $this->context->controller->addJs(
                    _PS_MODULE_DIR_ . $this->module->name . '/views/js/roja45productrentaladmin_calendar_rates.js'
                );
            }
            $this->context->controller->addCSS(
                _PS_MODULE_DIR_ . $this->module->name . '/views/css/roja45productrentaladmin_calendar.css'
            );
            $this->context->controller->addCSS(
                _PS_MODULE_DIR_ . $this->module->name . '/vendor/fullcalendar-3.9.0/fullcalendar.css'
            );
            $this->context->controller->addJS(
                _PS_MODULE_DIR_ . $this->module->name . '/vendor/fullcalendar-3.9.0/lib/moment.min.js'
            );
            $this->context->controller->addJS(
                _PS_MODULE_DIR_ . $this->module->name . '/vendor/fullcalendar-3.9.0/fullcalendar.js'
            );
            $this->context->controller->addJS(
                _PS_MODULE_DIR_ . $this->module->name . '/vendor/fullcalendar-3.9.0/locale/' . $this->context->language->iso_code . '.js'
            );
            $this->context->controller->addCss(
                _PS_MODULE_DIR_ . $this->module->name . '/vendor/jquery-confirm/jquery-confirm.min.css'
            );
            $this->context->controller->addJS(
                _PS_MODULE_DIR_ . $this->module->name . '/vendor/jquery-confirm/jquery-confirm.min.js'
            );
        } else {
            $this->context->controller->addJs(
                _PS_MODULE_DIR_ . $this->module->name . '/views/js/roja45productrentaladmin_calendarsummary.js'
            );
            $this->context->controller->addJqueryUI('ui.datepicker');
            $this->context->controller->addJqueryUI('ui.selectable');
            $this->context->controller->addCss(
                _PS_MODULE_DIR_ . $this->module->name . '/vendor/jquery-confirm/jquery-confirm.min.css'
            );
            $this->context->controller->addJS(
                _PS_MODULE_DIR_ . $this->module->name . '/vendor/jquery-confirm/jquery-confirm.min.js'
            );
        }
    }

    public function init()
    {
        if ($this->controller_name != 'AdminLogin' && (!isset($this->context->employee) || !$this->context->employee->isLoggedBack())) {
            if (isset($this->context->employee)) {
                $this->context->employee->logout();
            }

            $email = false;
            if (Tools::getValue('email') && Validate::isEmail(Tools::getValue('email'))) {
                $email = Tools::getValue('email');
            }

            $json = Tools::jsonEncode(array(
                'result' => 'redirect',
                'message' => $this->l('Session expired, redirecting to login screen.'),
                'route' => $this->context->link->getAdminLink(
                    'AdminLogin'
                ) . ((!Tools::getIsset(Tools::getValue('logout')) && $this->controller_name != 'AdminNotFound' && Tools::getValue('controller')) ? '&redirect=' . $this->controller_name : '') . ($email ? '&email=' . $email : ''),
            ));
            die($json);
        }

        parent::init();
    }

    public function getTemplateListVars()
    {
        $number_days = Tools::getValue('number_days');
        if ($number_days) {
            Context::getContext()->cookie->__set('ROJA45_PRODUCTRENTAL_ADMINCALENDARPERIOD', $number_days);
        }
        $period = Context::getContext()->cookie->__get('ROJA45_PRODUCTRENTAL_ADMINCALENDARPERIOD');
        if (!$period || $period=='undefined') {
            $period = 14;
        }
        $start_date = Tools::getValue('start_date');
        if (!$start_date) {
            if ($start_date = Context::getContext()->cookie->__get('ROJA45_PRODUCTRENTAL_ADMINCALENDARSTARTDATE')) {
                $start_date = new DateTime($start_date);
            } else {
                $start_date = new DateTime(date('Y-m-d'));
            }
        } else {
            $start_date = new DateTime(Tools::getValue('start_date'));
        }

        $offset = Tools::getValue('offset');
        if ($offset && $offset > 0) {
            $start_date->add(new DateInterval('P' . $offset . 'D'));
        } elseif ($offset && $offset < 0) {
            $start_date->sub(new DateInterval('P' . abs($offset) . 'D'));
        } elseif (!Context::getContext()->cookie->__get('ROJA45_PRODUCTRENTAL_ADMINCALENDARSTARTDATE')) {
            $start_date->sub(new DateInterval('P'.$this->default_past_days.'D'));
        }

        Context::getContext()->cookie->__set(
            'ROJA45_PRODUCTRENTAL_ADMINCALENDARSTARTDATE',
            $start_date->format('Y-m-d')
        );

        $month_dates = RojaFortyFiveProductRentalCore::createDateRangeArray(
            $start_date,
            $period
        );

        $rentals = ProductRentalRental::getRentalsForDateRange(
            $month_dates[0]['date'] . ' 00:00:00',
            $month_dates[$period-1]['date']  . ' 00:00:00',
            $this->context->language->id
        );

        foreach ($rentals as &$rental) {
            $rental['preparation'] = (int) Configuration::get('ROJA45_PRODUCTRENTAL_PREPARATIONDAYS');
            $rental['recondition'] = (int) Configuration::get('ROJA45_PRODUCTRENTAL_RECONDITIONDAYS');
            $date = new DateTime($rental['start_date'] . ' ' . $rental['collection_time']);
            $rental['collection_formatted'] = $date->format('Y-m-d @ H:i');
            $date = new DateTime($rental['end_date'] . ' ' . $rental['return_time']);
            $rental['return_formatted'] = $date->format('Y-m-d @ H:i');
        }
        $unavailables = ProductUnavailable::getAllUnavailable();
        $this->tpl_list_vars = parent::getTemplateListVars();
        $this->tpl_list_vars = array(
            'roja45_calendar_controller' => $this->context->link->getAdminLink(
                'AdminRentalCalendar',
                true
            ),
            'roja45_rental_controller' => $this->context->link->getAdminLink(
                'AdminProductRentals',
                true
            ),
            'roja45_productrental_dateformat' => RojaFortyFiveProductRentalCore::convertDateFormat(
                $this->context->language->date_format_lite
            ),
            'dates' => $month_dates,
            'start_date' => $month_dates[0]['date'],
            'period' => $period,
            'end_date' => $month_dates[$period-1]['date'],
            'days' => $period,
            'rentals' => $rentals,
            'unavailables' => $unavailables,
        );
        return $this->tpl_list_vars;
    }

    public function renderList()
    {
        parent::renderList();
        $tpl = $this->context->smarty->createTemplate(
            $this->getTemplatePath('rental-calendar-summary.tpl') . 'rental-calendar-summary.tpl'
        );
        $tpl->assign($this->tpl_list_vars);
        $tpl->assign(array(
            'list' => $this->_list,
            'past_selectable' => 0,
        ));
        return $tpl->fetch();
    }

    public function renderView()
    {
        if (Tools::getValue('action')=='view_rentals') {
            return $this->renderRentalsView();
        } else if (Tools::getValue('action')=='view_rates') {
            return $this->renderRatesView();
        }
        /** @var ProductRentalDetails $object */
        if (!($object = $this->loadObject(true))) {
            return;
        }
    }

    private function renderRentalsView()
    {
        /** @var ProductRentalDetails $object */
        if (!($object = $this->loadObject(true))) {
            return;
        }

        $tpl = $this->context->smarty->createTemplate(
            $this->getTemplatePath('rental-calendar.tpl') . 'rental-calendar.tpl'
        );
        $tpl->assign(
            array(
                'roja45_productrental_controller' => $this->context->link->getAdminLink(
                    'AdminProductRentals',
                    true
                ),
                'languages' => $this->context->controller->getLanguages(),
                'link' => $this->context->link,
                'rental_product' => $object,
                'roja45_productrental_dateformat' => RojaFortyFiveProductRentalCore::convertDateFormat(
                    $this->context->language->date_format_lite
                ),
                'timezone' => date_default_timezone_get()
            )
        );

        return $tpl->fetch();
    }

    private function renderRatesView()
    {
        /** @var ProductRentalDetails $object */
        if (!($object = $this->loadObject(true))) {
            return;
        }

        $rates = ProductRentalDateRate::getRates($object->id_roja45_product);
        $date_rates = array();
        foreach ($rates as $date_rate) {
            $model = new ProductRentalModel($date_rate['id_roja45_product_model']);
            if (!isset($date_rates[$date_rate['date']])) {
                $models = ProductRentalModel::getModels($object->id_roja45_product, $this->context->language->id);
                foreach ($models as &$model) {
                    $model['name'] = ProductRentalModel::getModelNameStatic(
                        $model['id_roja45_product_model'],
                        $this->context->language->id
                    );
                    $date_rates[$date_rate['date']][$model['id_roja45_product_model']] = $model;
                }
            }

            if (!isset($date_rates[$date_rate['date']][$date_rate['id_roja45_product_model']]['rates'][$date_rate['id_roja45_product_rate']])) {
                $rate = new ProductRentalRate($date_rate['id_roja45_product_rate'], $this->context->language->id);
                $date_rates[$date_rate['date']][$date_rate['id_roja45_product_model']]['rates'][$date_rate['id_roja45_product_rate']] = array(
                    'name' => $rate->name,
                    'description' => $rate->description
                );
            }
            $date_rates[$date_rate['date']][$date_rate['id_roja45_product_model']]['rates'][$date_rate['id_roja45_product_rate']]['id_roja45_product_rate'] = $date_rate['id_roja45_product_rate'];
            $date_rates[$date_rate['date']][$date_rate['id_roja45_product_model']]['rates'][$date_rate['id_roja45_product_rate']]['rate'] = $date_rate['rate'];
            $date_rates[$date_rate['date']][$date_rate['id_roja45_product_model']]['rates'][$date_rate['id_roja45_product_rate']]['rate_formatted'] = Tools::displayPrice(Tools::convertPrice($date_rate['rate']));
        }

        $models = ProductRentalModel::getModels($object->id_roja45_product, $this->context->language->id);
        foreach ($models as &$model) {
            $model['name'] = ProductRentalModel::getModelNameStatic(
                $model['id_roja45_product_model'],
                $this->context->language->id
            );
            $rates = ProductRentalRate::getRates(
                $object->id_roja45_product,
                $model['id_roja45_product_model'],
                $this->context->language->id
            );
            foreach ($rates as &$rate) {
                $rate['rate_formatted'] = Tools::displayPrice(Tools::convertPrice($rate['rate']));
            }

            $model['rates'] = $rates;
        }

        $tpl = $this->context->smarty->createTemplate($this->getTemplatePath('rental-calendar.tpl') . 'rental-calendar.tpl');
        $tpl->assign(
            array(
                'roja45_productrental_controller' => $this->context->link->getAdminLink(
                    'AdminProductRentals',
                    true
                ),
                'id_roja45_product' => $object->id_roja45_product,
                'languages' => $this->context->controller->getLanguages(),
                'link' => $this->context->link,
                'rental_product' => $object,
                'roja45_productrental_dateformat' => RojaFortyFiveProductRentalCore::convertDateFormat(
                    $this->context->language->date_format_lite
                ),
                'rates' => Tools::jsonEncode((object) $date_rates),
                'models' => Tools::jsonEncode((object) $models),
                'timezone' => date_default_timezone_get()
            )
        );

        return $tpl->fetch();
    }

    public function getList(
        $id_lang,
        $orderBy = null,
        $orderWay = null,
        $start = 0,
        $limit = null,
        $id_lang_shop = null
    ) {
        parent::getList($id_lang, $orderBy, $orderWay, $start, $limit, $id_lang_shop);

        foreach ($this->_list as $key => &$list_item) {
            $rentalproduct = new ProductRentalDetails($list_item['id_roja45_product']);
            $list_item['name'] = $rentalproduct->getName($id_lang);
            if (Validate::isLoadedObject($rentalproduct) && $rentalproduct->id_roja45_product) {
                $models = ProductRentalModel::getModels($rentalproduct->id_roja45_product);
                $rental_data = array();

                $models_data = array();
                foreach ($models as $model) {
                    $model = new ProductRentalModel(
                        $model['id_roja45_product_model'],
                        $id_lang
                    );

                    $rates = ProductRentalRate::getRates(
                        $list_item['id_roja45_product'],
                        $model->id_roja45_product_model,
                        (int)$id_lang
                    );
                    $custom_rates = $model->getCustomRates($id_lang);
                    $models_data[] = array(
                        'id_roja45_product_model' => $model->id_roja45_product_model,
                        'available' => ProductRentalDetails::getStockOnHand(
                            $rentalproduct->id_roja45_product,
                            $model->id_roja45_product_model
                        ),
                        'name' => $model->getModelName($id_lang),
                        'unavailable' => 0,
                        'total' => 0,
                        'rates' => $rates,
                        'custom_rates' => $custom_rates,
                    );
                }
                $rental_data['models'] = $models_data;
                $list_item['rental_data'] = $rental_data;
                $list_item['offset'] = 0;
            } else {
                unset($this->_list[$key]);
            }
        }
        return $this->_list;
    }

    public function initToolbarTitle()
    {
        $this->toolbar_title = is_array($this->breadcrumbs) ? array_unique($this->breadcrumbs) : array($this->breadcrumbs);
        /** @var ProductRentalDetails $object */
        $object = $this->loadObject(true);

        if (Tools::getValue('action')=='view_rates') {
            $title = $this->l('Calendar Rates: ', 'AdminRentalCalendar');
        } else if (Tools::getValue('action')=='view_rentals') {
            $title = $this->l('Calendar Rentals: ', 'AdminRentalCalendar');
        } else {
            $title = $this->l('Calendar: ', 'AdminRentalCalendar');
        }
        switch ($this->display) {
            case 'edit':
                $this->toolbar_title[] = $title.$object->getName($this->context->language->id);
                $this->addMetaTitle($title.$object->getName($this->context->language->id));
                break;
            case 'view':
                $this->toolbar_title[] = $title.$object->getName($this->context->language->id);
                $this->addMetaTitle($title.$object->getName($this->context->language->id));
                break;
            default:
                $this->toolbar_title[] = $this->l('Calendar Summary');
                $this->addMetaTitle($this->l('Calendar Summary'));
        }

        if ($filter = $this->addFiltersToBreadcrumbs()) {
            $this->toolbar_title[] = $filter;
        }
    }

    public function displayViewCalendarRentalsLink($token, $id)
    {
        $tpl = $this->createTemplate('list_action_view_calendar_rentals.tpl');
        $tpl->assign(array(
            'href' => $this->context->link->getAdminLink('AdminRentalCalendar', true) . '&action=view_rentals&token='.$token .'&'.$this->identifier.'='.$id.'&view'.$this->table,
            'action' => ' View Rentals',
            'id_roja45_product' => $id
        ));
        return $tpl->fetch();
    }

    public function displayViewCalendarRatesLink($token, $id)
    {
        $tpl = $this->createTemplate('list_action_view_calendar_rates.tpl');
        $tpl->assign(array(
            'href' => $this->context->link->getAdminLink('AdminRentalCalendar', true) . '&action=view_rates&token='.$token .'&'.$this->identifier.'='.$id.'&view'.$this->table,
            'action' => ' View Rates',
            'id_roja45_product' => $id
        ));
        return $tpl->fetch();
    }

    public function ajaxProcessUpdateCalendarSummary()
    {
        $validationErrors = array();
        if ($this->tabAccess['edit'] === '0') {
            $validationErrors[] = $this->l('You do not have the right permission');
            die(Tools::jsonEncode(
                array(
                    'result' => 'error',
                    'errors' => $validationErrors
                )
            ));
        }
        try {
            $id_roja45_product = Tools::getValue('id_roja45_product');
            $offset = (int) Tools::getValue('offset');
            if (Tools::getValue('direction')=='right') {
                $offset++;
            } else {
                $offset--;
            }

            $result = true;

            $tpl = $this->context->smarty->createTemplate(
                _PS_MODULE_DIR_.$this->module->name.'/views/templates/admin/rental_calendar/helpers/list/list_content_dates.tpl'
            );

            $multiplier = (int) 30*$offset;
            $dates =RojaFortyFiveProductRentalCore::createDateRangeArray(
                date('Y-m-d', strtotime('+'.$multiplier.' days')),
                30
            );
            $rental_data = array();

            foreach ($dates as $date) {
                $total_qty = 0;
                $rentals = ProductRentalRental::getRentalsForProductDate(
                    $id_roja45_product,
                    $date
                );
                foreach ($rentals as $rental) {
                    $total_qty += (int)$rental['qty'];
                }
                $unavailable = ProductUnavailable::getUnavailableDate(
                    $id_roja45_product,
                    0,
                    $date,
                    true
                );
                $date_obj = new DateTime($date);
                $rental_data[$date] = array();
                $rental_data[$date]['date_formatted'] = $date_obj->format('m/d');
                $rental_data[$date]['total_qty'] = $total_qty;
                $rental_data[$date]['unavailable'] = 0;
                if (count($unavailable)) {
                    $rental_data[$date]['unavailable'] = 1;
                }
                $rental_data[$date]['rentals'] = array();
            }
            $tpl->assign(
                array(
                    'dates' => $rental_data,
                )
            );
            $view = $tpl->fetch();

            if ($result) {
                die(Tools::jsonEncode(array(
                    'result' => 1,
                    'view' => $view,
                    'offset' => $offset,
                )));
            } else {
                $validationErrors[] = 'Error';
                die(Tools::jsonEncode(array(
                    'result' => 0,
                    'errors' => $validationErrors,
                )));
            }
        } catch (Exception $e) {
            $validationErrors = array();
            $validationErrors[] = $e->getMessage();
            error_log($e->getMessage());
            $json = Tools::jsonEncode(array(
                'result' => 0,
                'errors' => $validationErrors,
                'exception' => $e,
            ));
            die($json);
        }
    }

    public function ajaxProcessLoadCalendar()
    {
        $validationErrors = array();
        if ($this->tabAccess['edit'] === '0') {
            $validationErrors[] = $this->l('You do not have the right permission');
            die(Tools::jsonEncode(
                array(
                    'result' => 'error',
                    'errors' => $validationErrors
                )
            ));
        }
        try {
            if (!$start_date = Tools::getValue('start_date')) {
                $validationErrors[] = $this->l('Start Date missing', 'AdminRentalCalendar');
            }
            $offset = Tools::getValue('offset');
            if (!isset($offset) || !is_numeric($offset)) {
                $validationErrors[] = $this->l('Required offset missing', 'AdminRentalCalendar');
            }
            if (!$page = Tools::getValue('page')) {
                $page = 1;
            }
            $number_days = Tools::getValue('number_days');
            if (!$number_days) {
                if (!$number_days = Context::getContext()->cookie->__get('ROJA45_PRODUCTRENTAL_ADMINCALENDARPERIOD')) {
                    $number_days = 15;
                }
            }
            Context::getContext()->cookie->__set('ROJA45_PRODUCTRENTAL_ADMINCALENDARPERIOD', $number_days);
            $redirect = $this->context->link->getAdminLink(
                'AdminRentalCalendar',
                true
            );
            $redirect .= '&start_date='.$start_date.'&offset='.$offset.'&number_days='.$number_days;
            if ($page>1) {
                $redirect .= '&submitFilterid_roja45_product='.$page;
            }
            if (!count($validationErrors)) {
                if (true) {
                    die(Tools::jsonEncode(array(
                        'result' => 1,
                        'redirect' => $redirect,
                        'response' => 'Success',
                    )));
                } else {
                    throw new Exception($this->l('Failed', 'AdminRentalCalendar'));
                }
            } else {
                throw new Exception($this->l('Validation errors', 'AdminRentalCalendar'));
            }
        } catch (Exception $e) {
            $validationErrors = array();
            $validationErrors[] = $e->getMessage();
            if (_PS_MODE_DEV_) {
                error_log($e->getMessage());
            }
            $json = Tools::jsonEncode(array(
                'result' => 0,
                'errors' => $validationErrors,
                'exception' => $e,
            ));
            die($json);
        }
    }

    public function ajaxProcessTemplate()
    {
        $validationErrors = array();
        if ($this->tabAccess['edit'] === '0') {
            $validationErrors[] = $this->l('You do not have the right permission');
            die(Tools::jsonEncode(
                array(
                    'result' => 'error',
                    'errors' => $validationErrors
                )
            ));
        }
        try {
            //$id_property = Tools::getValue('ROJA45_PROPERTYMANAGER_PROPERTY_ID');
            $result = true;

            if ($result) {
                die(Tools::jsonEncode(array(
                    'result' => 'success',
                    'response' => 'Property Space Updated',
                )));
            } else {
                $validationErrors[] = 'Error';
                die(Tools::jsonEncode(array(
                    'result' => 'error',
                    'errors' => $validationErrors,
                )));
            }
        } catch (Exception $e) {
            $validationErrors = array();
            $validationErrors[] = $e->getMessage();
            error_log($e->getMessage());
            $json = Tools::jsonEncode(array(
                'result' => false,
                'errors' => $validationErrors,
                'exception' => $e,
            ));
            die($json);
        }
    }
}
