<?php
/**
 * RentalCalendarController
 *
 * @author    Roja45
 * @copyright 2016 Roja45
 * @license   license.txt
 * @category  RentalCalendarController
 *
 * 2016 ROJA45 - All rights reserved.
 *
 * DISCLAIMER
 * Changing this file will render any support provided by us null and void.
 */

/**
 * RentalCalendarController
 *
 * @author    Roja45
 * @copyright 2016 Roja45
 * @license   license.txt
 * @category  Class
 *
 * 2016 ROJA45 - All rights reserved.
 *
 * DISCLAIMER
 * Changing this file will render any support provided by us null and void.
 */

class AdminRentalGraphController extends ModuleAdminController
{
    /**
     * Constructor
     */
    public function __construct()
    {
        parent::__construct();
        $this->context = Context::getContext();
        $this->bootstrap = true;
        $this->override_folder = 'rental_graph/';
        $this->tpl_folder = 'rental_graph/';
        $this->table = 'roja45_productrental_details';
        $this->identifier = 'id_roja45_product';
        $this->submit_action = $this->context->link->getAdminLink('AdminRentalGraph', true);
        $this->show_cancel_button = true;
        $this->className = 'ProductRentalRental';
        $this->deleted = false;
        $this->colorOnBackground = false;
        $this->multishop_context = Shop::CONTEXT_ALL;

        $this->list_no_link = true;
        $this->toolbar_title = $this->l('Rental Catalog');
        $this->_defaultOrderBy = $this->identifier = 'id_roja45_product';
        $this->_orderBy = 'id_roja45_product';
        $this->_orderWay = 'ASC';

        $this->fields_list = array(
            'id_roja45_product' => array(
                'title' => $this->l('ID'),
                'class' => 'fixed-width-xs'
            ),
        );
        $this->tabAccess = Profile::getProfileAccess($this->context->employee->id_profile, Tab::getIdFromClassName('AdminRentalGraph'));
    }

    public function setMedia($isNewTheme = false)
    {
        parent::setMedia($isNewTheme);

        if ($this->tabAccess['edit'] == 1 && $this->display == null) {
            $this->context->controller->addJS(
                _PS_MODULE_DIR_ . $this->module->name . '/views/js/roja45productrentaladmin.js'
            );
            $this->context->controller->addCSS(
                _PS_MODULE_DIR_ . $this->module->name . '/views/css/roja45productrentaladmin.css'
            );
        }
    }

    public function getList(
        $id_lang,
        $orderBy = null,
        $orderWay = null,
        $start = 0,
        $limit = null,
        $id_lang_shop = null
    ) {
        parent::getList($id_lang, $orderBy, $orderWay, $start, $limit, $id_lang_shop);
        $dates = $this->createDateRangeArray(date('Y-m-d', strtotime('now')), date('Y-m-d', strtotime("+30 days")));
        foreach ($this->_list as $key => &$list_item) {
            $rentalproduct = new ProductRentalDetails($list_item['id_roja45_product']);
            if (Validate::isLoadedObject($rentalproduct) && $rentalproduct->id_roja45_product) {
                //$model = new ProductRentalModel($id_roja45_product_model);
                $qty = (int) StockAvailable::getQuantityAvailableByProduct($rentalproduct->id_product);
                $rental_data = array();
                foreach ($dates as $date) {
                    $total_qty = 0;
                    $blocks = array();
                    if ($qty) {
                        $rentals = ProductRentalRental::getRentalsForProductDate(
                            $list_item['id_roja45_product'],
                            $date,
                            true
                        );
                        foreach ($rentals as $rental) {
                            $total_qty += (int)$rental['qty'];
                        }
                        $percentage = round(ceil(($total_qty / $qty) * 10), 0);
                        for ($x = 1; $x <= 10; $x++) {
                            if ($x <= $percentage && $x >= 10) {
                                $blocks[$x] = 3;
                            } elseif ($x <= $percentage && $x >= 8) {
                                $blocks[$x] = 2;
                            } elseif ($x <= $percentage && $x < 8) {
                                $blocks[$x] = 1;
                            } else {
                                $blocks[$x] = 0;
                            }
                        }
                        $date = DateTime::createFromFormat('Y-m-d', $date);
                        $date = $date->format("m-d");
                    }
                    $rental_data[$date]['bars'] = array_reverse($blocks);
                    $rental_data[$date]['qty'] = $total_qty;
                }

                $product = new Product($rentalproduct->id_product, false, $this->context->language->id);
                $id_image = Product::getCover($rentalproduct->id_product);
                $image_url = $this->context->link->getImageLink(
                    $product->link_rewrite,
                    $id_image['id_image'],
                    ImageType::getFormatedName('medium')
                );
                $image_size = Image::getSize(ImageType::getFormatedName('medium'));

                $list_item['total_qty'] = $qty;
                $list_item['rental_data'] = $rental_data;
                $list_item['rentalproduct'] = $rentalproduct;
                $list_item['product_url'] = $this->context->link->getAdminLink('AdminProducts').'&id_product='.(int)$product->id.'&updateproduct';
                $list_item['product'] = $product;
                $list_item['image_url'] = $image_url;
                $list_item['image_size'] = $image_size;
                $list_item['enable_link'] = $this->context->link->getAdminLink('AdminProductRental', true);
                $list_item['edit_link'] = $this->context->link->getAdminLink('AdminProducts') . '&id_product=' . $rentalproduct->id_product . '&updateproduct';
            } else {
                unset($this->_list[$key]);
            }
        }
    }

    private function createDateRangeArray($strDateFrom, $strDateTo)
    {
        $aryRange=array();
        $iDateFrom = mktime(
            1,
            0,
            0,
            Tools::substr($strDateFrom, 5, 2),
            Tools::substr($strDateFrom, 8, 2),
            Tools::substr($strDateFrom, 0, 4)
        );
        $iDateTo = mktime(
            1,
            0,
            0,
            Tools::substr($strDateTo, 5, 2),
            Tools::substr($strDateTo, 8, 2),
            Tools::substr($strDateTo, 0, 4)
        );

        if ($iDateTo >= $iDateFrom) {
            array_push($aryRange, date('Y-m-d', $iDateFrom));
            while ($iDateFrom < $iDateTo) {
                $iDateFrom+=86400;
                array_push($aryRange, date('Y-m-d', $iDateFrom));
            }
        }
        return $aryRange;
    }
}
