<?php
/**
 * AdminReservationStatusController.
 *
 * @author    Roja45
 * @copyright 2016 Roja45
 * @license   license.txt
 * @category  AdminReservationStatusController
 *
 * 2016 ROJA45 - All rights reserved.
 *
 * DISCLAIMER
 * Changing this file will render any support provided by us null and void.
 */

/**
 * AdminReservationStatusController.
 *
 * @author    Roja45
 * @copyright 2016 Roja45
 * @license   license.txt
 * @category  Class
 *
 * 2016 ROJA45 - All rights reserved.
 *
 * DISCLAIMER
 * Changing this file will render any support provided by us null and void.
 */

class AdminRentalStatusController extends ModuleAdminController
{
    public function __construct()
    {
        parent::__construct();
        $this->context = Context::getContext();
        $this->override_folder = 'roja45productrental/';
        $this->bootstrap = true;
        $this->table = 'roja45_productrental_rentalstatus';
        $this->identifier = 'id_roja45_product_rental_status';
        $this->submit_action = 'submitAdd'.$this->table;
        $this->show_cancel_button = true;
        $this->className = 'ProductRentalRentalStatus';
        $this->lang = true;
        $this->deleted = false;
        $this->colorOnBackground = false;

        $this->multishop_context = Shop::CONTEXT_ALL;
        $this->imageType = 'gif';
        $this->fieldImageSettings = array(
            'name' => 'icon',
            'dir' => 'os',
        );

        $this->toolbar_title = $this->l('Rental Status');
        $this->_defaultOrderBy = $this->identifier = 'id_roja45_product_rental_status';
        $this->list_id = 'id_roja45_product_rental_status';
        $this->deleted = false;
        $this->_orderBy = null;

        $this->addRowAction('edit');
        $this->addRowAction('delete');
        $this->addRowActionSkipList('delete', range(1, 22));

        $this->bulk_actions = array(
            'delete' => array(
                'text' => $this->l('Delete selected'),
                'confirm' => $this->l('Delete selected status?'),
                'icon' => 'icon-trash',
            ),
        );

        $this->fields_list = array(
            'id_roja45_product_rental_status' => array(
                'title' => $this->l('Id'),
                'align' => 'text-center',
                'class' => 'fixed-width-sm',
            ),
            'status' => array(
                'title' => $this->l('Name'),
                'width' => 'auto',
            ),
            'code' => array(
                'title' => $this->l('Code'),
                'color' => 'color',
                'align' => 'text-center',
                'orderby' => false,
                'search' => false,
                'class' => 'fixed-width-md',
            ),
            'send_email' => array(
                'title' => $this->l('Send Email'),
                'align' => 'text-center',
                'active' => 'sendEmail',
                'type' => 'bool',
                'ajax' => true,
                'orderby' => false,
                'class' => 'fixed-width-sm',
            ),
            'notify_admin' => array(
                'title' => $this->l('Notify Admin'),
                'align' => 'text-center',
                'active' => 'notifyAdmin',
                'type' => 'bool',
                'ajax' => true,
                'orderby' => false,
                'class' => 'fixed-width-sm',
            ),
            'block_calendar' => array(
                'title' => $this->l('Blocks Calendar'),
                'align' => 'text-center',
                'active' => 'blockCalendar',
                'type' => 'bool',
                'ajax' => true,
                'orderby' => false,
                'class' => 'fixed-width-sm',
            ),
            'record_history' => array(
                'title' => $this->l('Record History'),
                'align' => 'text-center',
                'active' => 'recordHistory',
                'type' => 'bool',
                'ajax' => true,
                'orderby' => false,
                'class' => 'fixed-width-sm',
            ),
            'customer_account' => array(
                'title' => $this->l('Customer Account'),
                'align' => 'text-center',
                'active' => 'customerAccount',
                'type' => 'bool',
                'ajax' => true,
                'orderby' => false,
                'class' => 'fixed-width-sm',
            ),
            'answer_template' => array(
                'title' => $this->l('Email Template'),
                'class' => 'fixed-width-sm',
            ),
        );
        $this->tabAccess = Profile::getProfileAccess(
            $this->context->employee->id_profile,
            Tab::getIdFromClassName('AdminRentalStatus')
        );
    }

    public function init()
    {
        if (Tools::isSubmit('add'.$this->table)) {
            $this->display = 'add';
        } elseif (Tools::isSubmit('update'.$this->table)) {
            $this->display = 'edit';
        }

        return parent::init();
    }


    public function postProcess()
    {
        if (Tools::isSubmit($this->table.'Orderby') || Tools::isSubmit($this->table.'Orderway')) {
            $this->filter = true;
        }

        if (Tools::isSubmit('submitAdd'.$this->table)) {
            $this->deleted = false;
            return parent::postProcess();
        } elseif (Tools::isSubmit('delete'.$this->table)) {
            $status = new ProductRentalRentalStatus(Tools::getValue($this->identifier), $this->context->language->id);
            if (!$status->isRemovable()) {
                $this->errors[] = $this->l('For security reasons, you cannot delete default order statuses.');
            } else {
                return parent::postProcess();
            }
        } elseif (Tools::isSubmit('submitBulkdelete'.$this->table)) {
            foreach (Tools::getValue($this->table.'Box') as $selection) {
                $status = new ProductRentalRentalStatus((int) $selection, $this->context->language->id);
                if (!$status->isRemovable()) {
                    $this->errors[] = $this->l('For security reasons, you cannot delete default order statuses.');
                    break;
                }
            }

            if (!count($this->errors)) {
                return parent::postProcess();
            }
        } else {
            return parent::postProcess();
        }
    }

    public function initPageHeaderToolbar()
    {
        parent::initPageHeaderToolbar();
        unset($this->page_header_toolbar_btn['back']);
    }

    public function initTabModuleList()
    {
        parent::initTabModuleList();
    }

    public function addToolBarModulesListButton()
    {
        parent::addToolBarModulesListButton();
    }

    public function renderForm()
    {
        $this->fields_form = array(
            'legend' => array(
                'title' => $this->l('Rental status'),
                'icon' => 'icon-time',
            ),
            'input' => array(
                array(
                    'type' => 'text',
                    'label' => $this->l('Status name'),
                    'name' => 'status',
                    'lang' => true,
                    'required' => true,
                    'hint' => array(
                        $this->l('Rental status (e.g. \'Pending\').'),
                        $this->l('Invalid characters: numbers and').' !<>,;?=+()@#"{}_$%:',
                    ),
                ),
                array(
                    'type' => 'color',
                    'label' => $this->l('Color'),
                    'name' => 'color',
                    'hint' => $this->l(
                        'Status will be highlighted in this color. HTML colors only.'
                    ).' "lightblue", "#CC6600")',
                ),
                array(
                    'type' => 'text',
                    'label' => $this->l('Code'),
                    'name' => 'code',
                    'hint' => $this->l('Status Abbreviation Code.'),
                ),
                array(
                    'type' => 'switch',
                    'name' => 'send_email',
                    'label' => $this->l('Send Email'),
                    'hint' => $this->l('Select to automatically send an email.'),
                    'required' => true,
                    'values' => array(
                        array(
                            'id' => 'send_email_on',
                            'value' => 1,
                            'label' => $this->l('Enabled'),
                        ),
                        array(
                            'id' => 'send_email_off',
                            'value' => 0,
                            'label' => $this->l('Disabled'),
                        ),
                    ),
                ),
                array(
                    'type' => 'text',
                    'label' => $this->l('Template'),
                    'name' => 'answer_template',
                    'hint' => $this->l('Enter the template name. (NB. You will need to create the template)'),
                ),
                array(
                    'type' => 'switch',
                    'name' => 'notify_admin',
                    'label' => $this->l('Notify Admin'),
                    'hint' => $this->l(
                        'Select to automatically send an email to your administration address when this status is assigned.'
                    ),
                    'required' => false,
                    'values' => array(
                        array(
                            'id' => 'notify_admin_on',
                            'value' => 1,
                            'label' => $this->l('Enabled'),
                        ),
                        array(
                            'id' => 'notify_admin_off',
                            'value' => 0,
                            'label' => $this->l('Disabled'),
                        ),
                    ),
                ),
                array(
                    'type' => 'switch',
                    'name' => 'block_calendar',
                    'label' => $this->l('Blocks Calendar'),
                    'hint' => $this->l('Enable to have this status block the calendar for further reservations.'),
                    'required' => true,
                    'values' => array(
                        array(
                            'id' => 'block_calendar_on',
                            'value' => 1,
                            'label' => $this->l('Enabled'),
                        ),
                        array(
                            'id' => 'block_calendar_off',
                            'value' => 0,
                            'label' => $this->l('Disabled'),
                        ),
                    ),
                ),
                array(
                    'type' => 'switch',
                    'name' => 'record_history',
                    'label' => $this->l('Record History'),
                    'hint' => $this->l('When enabled the module will record the moment this status is applied for the first time.'),
                    'required' => true,
                    'values' => array(
                        array(
                            'id' => 'record_history_on',
                            'value' => 1,
                            'label' => $this->l('Enabled'),
                        ),
                        array(
                            'id' => 'record_history_off',
                            'value' => 0,
                            'label' => $this->l('Disabled'),
                        ),
                    ),
                ),
                array(
                    'type' => 'switch',
                    'name' => 'customer_account',
                    'label' => $this->l('Customer Account'),
                    'hint' => $this->l('When enabled the customer will have access to the rental from their customer account.'),
                    'required' => true,
                    'values' => array(
                        array(
                            'id' => 'customer_account_on',
                            'value' => 1,
                            'label' => $this->l('Enabled'),
                        ),
                        array(
                            'id' => 'customer_account_off',
                            'value' => 0,
                            'label' => $this->l('Disabled'),
                        ),
                    ),
                ),
            ),
            'submit' => array(
                'title' => $this->l('Save'),
            ),
        );

        if (Tools::isSubmit('update'.$this->table) || Tools::isSubmit('add'.$this->table)) {
            return $this->renderRentalStatusForm();
        } else {
            return parent::renderForm();
        }
    }

    protected function renderRentalStatusForm()
    {
        if (!($obj = $this->loadObject(true))) {
            return;
        }
        if ($this->getFieldValue($obj, 'color') !== false) {
            $this->fields_value['color'] = $this->getFieldValue($obj, 'color');
        } else {
            $this->fields_value['color'] = '#ffffff';
        }

        return parent::renderForm();
    }

    public function ajaxProcesssendemailroja45ProductrentalRentalstatus()
    {
        $id = (int)Tools::getValue($this->identifier);
        $sql =
            'UPDATE '._DB_PREFIX_.'roja45_productrental_rentalstatus
            SET `send_email`= NOT `send_email`
            WHERE '.pSQL($this->identifier).'='.(int) $id;
        $result = Db::getInstance()->execute($sql);

        if ($result) {
            $json = Tools::jsonEncode(array(
                'success' => 1,
                'text' => $this->l('The status has been updated successfully.'),
            ));
            die($json);
        } else {
            $json = Tools::jsonEncode(array(
                'success' => 0,
                'text' => $this->l('An error occurred while updating this meta.'),
            ));
            die($json);
        }
    }

    public function ajaxProcessnotifyadminroja45ProductrentalRentalstatus()
    {
        $id = (int)Tools::getValue($this->identifier);
        $sql =
            'UPDATE '._DB_PREFIX_.'roja45_productrental_rentalstatus
            SET `notify_admin`= NOT `notify_admin`
            WHERE '.pSQL($this->identifier).'='.(int) $id;
        $result = Db::getInstance()->execute($sql);

        if ($result) {
            $json = Tools::jsonEncode(array(
                'success' => 1,
                'text' => $this->l('The status has been updated successfully.'),
            ));
            die($json);
        } else {
            $json = Tools::jsonEncode(array(
                'success' => 0,
                'text' => $this->l('An error occurred while updating this meta.'),
            ));
            die($json);
        }
    }

    public function ajaxProcessblockcalendarroja45ProductrentalRentalstatus()
    {
        $id = (int)Tools::getValue($this->identifier);
        $sql =
            'UPDATE '._DB_PREFIX_.'roja45_productrental_rentalstatus 
            SET `block_calendar`= NOT `block_calendar`
             WHERE '.pSQL($this->identifier).'='.(int) $id;
        $result = Db::getInstance()->execute($sql);

        if ($result) {
            $json = Tools::jsonEncode(array(
                'success' => 1,
                'text' => $this->l('Updated successfully.'),
            ));
            die($json);
        } else {
            $json = Tools::jsonEncode(array(
                'success' => 0,
                'text' => $this->l('An error occurred while updating this value.'),
            ));
            die($json);
        }
    }

    public function ajaxProcessRecordhistoryroja45ProductrentalRentalstatus()
    {
        $id = (int)Tools::getValue($this->identifier);
        $sql =
            'UPDATE '._DB_PREFIX_.'roja45_productrental_rentalstatus 
            SET `record_history`= NOT `record_history` 
            WHERE '.$this->identifier.'='.$id;
        $result = Db::getInstance()->execute($sql);

        if ($result) {
            $json = Tools::jsonEncode(array(
                'success' => 1,
                'text' => $this->l('Updated successfully.'),
            ));
            die($json);
        } else {
            $json = Tools::jsonEncode(array(
                'success' => 0,
                'text' => $this->l('An error occurred while updating this value.'),
            ));
            die($json);
        }
    }

    public function ajaxProcessCustomeraccountroja45ProductrentalRentalstatus()
    {
        $id = (int)Tools::getValue($this->identifier);
        $sql =
            'UPDATE '._DB_PREFIX_.'roja45_productrental_rentalstatus 
            SET `customer_account`= NOT `customer_account` 
            WHERE '.$this->identifier.'='.$id;
        $result = Db::getInstance()->execute($sql);

        if ($result) {
            $json = Tools::jsonEncode(array(
                'success' => 1,
                'text' => $this->l('Updated successfully.'),
            ));
            die($json);
        } else {
            $json = Tools::jsonEncode(array(
                'success' => 0,
                'text' => $this->l('An error occurred while updating this value.'),
            ));
            die($json);
        }
    }
}
