<?php
/**
 * PricePeriodsController
 *
 * @author    Roja45
 * @copyright 2016 Roja45
 * @license   license.txt
 * @category  PricePeriodsController
 *
 * 2016 ROJA45 - All rights reserved.
 *
 * DISCLAIMER
 * Changing this file will render any support provided by us null and void.
 */

/**
 * PricePeriodsController
 *
 * @author    Roja45
 * @copyright 2016 Roja45
 * @license   license.txt
 * @category  Class
 *
 * 2016 ROJA45 - All rights reserved.
 *
 * DISCLAIMER
 * Changing this file will render any support provided by us null and void.
 */
class AdminWorkingDaysController extends ModuleAdminController
{
    public function __construct()
    {
        parent::__construct();
        $this->context = Context::getContext();

        $this->override_folder = 'working_days';
        $this->tpl_folder = 'working_days/';
        $this->bootstrap = true;
        $this->table = 'roja45_productrental_workingday';
        $this->table_id = 'roja45_productrental_workingday';
        $this->identifier = 'id_roja45_product_rental_workingday';
        $this->submit_action = 'submitAdd' . $this->table;
        $this->show_cancel_button = true;
        $this->className = 'ProductRentalWorkingDay';
        $this->lang = true;
        $this->deleted = false;
        $this->colorOnBackground = false;
        $this->bulk_actions = array(
            'delete' => array(
                'text' => $this->l('Delete selected'),
                'confirm' => $this->l('Delete selected items?')
            )
        );
        $this->multishop_context = Shop::CONTEXT_ALL;
        $this->imageType = 'gif';
        $this->fieldImageSettings = array(
            'name' => 'icon',
            'dir' => 'os',
        );

        $this->toolbar_title = $this->l('Working Days');

        $this->_defaultOrderBy = 'id_roja45_product_rental_workingday';
        $this->list_id = 'id_roja45_product_rental_workingday';
        $this->deleted = false;
        $this->_orderBy = 'id_roja45_product_rental_workingday';
        $this->_orderWay = 'ASC';
        $this->addRowAction('edit');
        $this->addRowActionSkipList('delete', range(1, 7));

        $this->fields_list = array(
            'id_roja45_product_rental_workingday' => array(
                'title' => $this->l('Id'),
            ),
            'name' => array(
                'title' => $this->l('Day'),
            ),
            'is_working_day' => array(
                'title' => $this->l('Enabled'),
            ),
        );
        $this->tabAccess = Profile::getProfileAccess($this->context->employee->id_profile, Tab::getIdFromClassName('AdminWorkingDays'));
    }

    public function init()
    {
        if (Tools::isSubmit('add' . $this->table)) {
            $this->display = 'add';
        } elseif (Tools::isSubmit('update' . $this->table)) {
            $this->display = 'edit';
        } elseif (Tools::isSubmit('delete' . $this->table)) {
            $this->display = 'delete';
        }

        return parent::init();
    }

    public function setMedia($isNewTheme = false)
    {
        parent::setMedia($isNewTheme);
        $this->context->controller->addJqueryUI('ui.effect');
        $this->context->controller->addJqueryUI('ui.datepicker');
        $this->context->controller->addJqueryUI('ui.tooltip');
        $this->context->controller->addJS(
            _PS_MODULE_DIR_ . $this->module->name . '/views/js/roja45productrentaladmin_workingdays.js'
        );
        $this->context->controller->addJS(_PS_MODULE_DIR_ . $this->module->name . '/vendor/riotjs/riot+compiler.js');
    }

    public function postProcess()
    {
        if (Tools::isSubmit($this->table.'Orderby') || Tools::isSubmit($this->table.'Orderway')) {
            $this->filter = true;
        }

        if (Tools::isSubmit('submitSave'.$this->table)) {
            return $this->processSaveWorkingDays();
        } elseif (Tools::isSubmit('delete'.$this->table)) {
            $propertygroup = new PropertyGroup(Tools::getValue($this->identifier), $this->context->language->id);
            if (!$propertygroup->isRemovable()) {
                $this->errors[] = $this->l('For security reasons, you cannot delete default payment profiles.');
            } else {
                return parent::postProcess();
            }
        } elseif (Tools::isSubmit('submitBulkdelete'.$this->table)) {
            return parent::postProcess();
        } else {
            return parent::postProcess();
        }
    }

    public function renderList()
    {
        $html = parent::renderList();
        $tpl = $this->context->smarty->createTemplate(
            $this->getTemplatePath('/prestui/ps-tags.tpl') . 'prestui/ps-tags.tpl'
        );
        $html .= $tpl->fetch();
        return $html;
    }

    public function getTemplateListVars()
    {
        $this->tpl_list_vars = parent::getTemplateListVars();
        $this->tpl_list_vars = array(
            'week_start_day' => Configuration::get('ROJA45_PRODUCTRENTAL_WEEKSTARTDAY'),
        );
        return $this->tpl_list_vars;
    }

    public function getList(
        $id_lang,
        $orderBy = null,
        $orderWay = null,
        $start = 0,
        $limit = null,
        $id_lang_shop = null
    ) {
        parent::getList($id_lang, $orderBy, $orderWay, $start, $limit, $id_lang_shop);
        foreach ($this->_list as &$list_item) {
            $date = new DateTime('2000-01-01 '.$list_item['opening_time']);
            $list_item['opening_time_formatted'] = $date->format('H:i');
            $date = new DateTime('2000-01-01 '.$list_item['closing_time']);
            $list_item['closing_time_formatted'] = $date->format('H:i');
        }
    }

    public function processSaveWorkingDays()
    {
        $validationErrors = array();
        if ($this->tabAccess['edit'] === '0') {
            $validationErrors[] = $this->l('You do not have the right permission');
            $this->errors = $validationErrors;
        } else {
            try {
                parent::getList(
                    $this->context->language->id,
                    'id_roja45_product_rental_workingday',
                    'asc',
                    0,
                    0
                );
                foreach ($this->_list as $working_day) {
                    $enabled = Tools::getValue('ROJA45_PRODUCTRENTAL_WORKINGDAY_'.Tools::strtoupper($working_day['day']));
                    $allow_rentals = Tools::getValue('ROJA45_PRODUCTRENTAL_ALLOWRENTALS_'.Tools::strtoupper($working_day['day']));
                    $opening_time = Tools::getValue('ROJA45_PRODUCTRENTAL_OPENING_'.Tools::strtoupper($working_day['day']));
                    $closing_time = Tools::getValue('ROJA45_PRODUCTRENTAL_CLOSING_'.Tools::strtoupper($working_day['day']));

                    $working_day = new ProductRentalWorkingDay($working_day['id_roja45_product_rental_workingday']);
                    $working_day->is_working_day = (bool) $enabled;
                    $working_day->allow_rentals = (bool) $allow_rentals;
                    $working_day->opening_time = $opening_time;
                    $working_day->closing_time = $closing_time;
                    if (!$working_day->save()) {
                        $validationErrors[] = Db::getInstance()->getMsgError();
                    }
                }
                Configuration::updateValue(
                    'ROJA45_PRODUCTRENTAL_WEEKSTARTDAY',
                    Tools::getValue('ROJA45_PRODUCTRENTAL_WEEKSTARTDAY')
                );
            } catch (Exception $e) {
                $validationErrors = array();
                $validationErrors[] = $e->getMessage();
                $this->errors = $validationErrors;
            }
        }
    }
}
