<?php
/**
 * PaymentProfilesController
 *
 * @author    Roja45
 * @copyright 2016 Roja45
 * @license   license.txt
 * @category  PaymentProfilesController
 *
 * 2016 ROJA45 - All rights reserved.
 *
 * DISCLAIMER
 * Changing this file will render any support provided by us null and void.
 */

/**
 * PaymentProfilesController
 *
 * @author    Roja45
 * @copyright 2016 Roja45
 * @license   license.txt
 * @category  Class
 *
 * 2016 ROJA45 - All rights reserved.
 *
 * DISCLAIMER
 * Changing this file will render any support provided by us null and void.
 */

class RentalDamageDepositsController extends ModuleAdminController
{
    private $deposit_type_options;

    public function __construct()
    {
        parent::__construct();
        $this->context = Context::getContext();
        $this->override_folder = 'roja45productrental_damagedeposits';
        $this->tpl_folder = 'damage_deposits/';
        $this->bootstrap = true;
        $this->table = 'roja45_productrental_damagedeposit';
        $this->identifier = 'id_roja45_product_damagedeposit';
        $this->submit_action = 'submitAddroja45_productrental_damagedeposit';
        $this->show_cancel_button = true;
        $this->className = 'ProductRentalDamageDeposit';
        $this->lang = false;
        $this->deleted = false;
        $this->colorOnBackground = false;
        $this->bulk_actions = array(
            'delete' => array(
                'text' => $this->l('Delete selected'),
                'confirm' => $this->l('Delete selected items?')
            )
        );
        $this->multishop_context = Shop::CONTEXT_ALL;
        $this->imageType = 'gif';
        $this->fieldImageSettings = array(
            'name' => 'icon',
            'dir' => 'os',
        );
        $this->tabAccess = Profile::getProfileAccess(
            $this->context->employee->id_profile,
            Tab::getIdFromClassName('RentalDamageDeposits')
        );

        $this->_defaultOrderBy = $this->identifier = 'id_roja45_product_damagedeposit';
        $this->list_id = 'roja45_productrental_damagedeposit';
        $this->deleted = false;
        $this->_orderBy = 'id_roja45_product_damagedeposit';
        $this->_orderWay = 'ASC';
        $this->position_identifier = 'id_roja45_product_damagedeposit';

        $this->addRowAction('edit');
        $this->addRowAction('delete');

        $this->bulk_actions = array(
            'delete' => array(
                'text' => $this->l('Delete selected', 'RentalDamageDeposit'),
                'confirm' => $this->l('Delete selected items?', 'RentalDamageDeposit'),
                'icon' => 'icon-trash',
            ),
        );

        $this->deposit_type_options = array(
            array(
                'id_deposit_type' => ProductRentalDamageDeposit::DAMAGE_DEPOSIT_FIXED_TYPE,
                'deposit_type_name' => $this->l('Fixed', 'RentalDamageDeposit'),
            ),
            array(
                'id_deposit_type' => ProductRentalDamageDeposit::DAMAGE_DEPOSIT_PERCENTAGE_TYPE,
                'deposit_type_name' => $this->l('Percentage', 'RentalDamageDeposit'),
            ),
        );

        $deposit_type_options_array = array();
        foreach ($this->deposit_type_options as $row) {
            $deposit_type_options_array[$row['id_deposit_type']] = $row['deposit_type_name'];
        }

        $this->fields_list = array(
            'id_roja45_product_damagedeposit' => array(
                'title' => $this->l('Id', 'RentalDamageDeposit'),
                'width' => 'auto',
            ),
            'name' => array(
                'title' => $this->l('Damage Deposit Name', 'RentalDamageDeposit'),
                'width' => 'auto',
            ),
            'deposit_type_name' => array(
                'title' => $this->l('Type', 'RentalDamageDeposit'),
                'width' => 'auto',
                'type' => 'select',
                'list' => $deposit_type_options_array,
                'filter_key' => 'a!id_deposit_type',
                'filter_type' => 'int',
                'order_key' => 'id_deposit_type',
            ),
            'deposit_amount_formatted' => array(
                'title' => $this->l('Amount', 'RentalDamageDeposit'),
                'width' => 'auto',
            ),
        );
    }

    public function init()
    {
        return parent::init();
    }

    public function setMedia($isNewTheme = false)
    {
        parent::setMedia($isNewTheme);
        if ($this->display &&
            isset($this->tabAccess[$this->display]) &&
            $this->tabAccess[$this->display] == 1 &&
            in_array($this->display, array('add', 'view', 'edit'))
        ) {
            $this->context->controller->addJs(
                _PS_MODULE_DIR_ . $this->module->name . '/views/js/roja45productrentaladmin_damagedeposit.js'
            );
        }
    }

    public function getList(
        $id_lang,
        $orderBy = null,
        $orderWay = null,
        $start = 0,
        $limit = null,
        $id_lang_shop = null
    ) {
        parent::getList($id_lang, $orderBy, $orderWay, $start, $limit, $id_lang_shop);
        foreach ($this->_list as &$list_item) {
            if ($list_item['id_deposit_type'] == ProductRentalDamageDeposit::DAMAGE_DEPOSIT_FIXED_TYPE) {
                $list_item['deposit_type_name'] = $this->l('Fixed', 'RentalDamageDeposit');
                $list_item['deposit_amount_formatted'] = Tools::displayPrice($list_item['deposit_amount']);
            } else {
                $list_item['deposit_type_name'] = $this->l('Percentage', 'RentalDamageDeposit');
                $list_item['deposit_amount_formatted'] = Tools::ps_round($list_item['deposit_amount'], 2).'%';
            }
        }
    }

    public function postProcess()
    {
        if (Tools::isSubmit($this->table.'Orderby') || Tools::isSubmit($this->table.'Orderway')) {
            $this->filter = true;
        }

        if (Tools::isSubmit('submitAdd'.$this->table)) {
            $this->deleted = false;

            return parent::postProcess();
        } elseif (Tools::isSubmit('delete'.$this->table)) {
            $damagedeposit = new ProductRentalDamageDeposit(
                Tools::getValue($this->identifier),
                $this->context->language->id
            );
            if (!$damagedeposit->isRemovable()) {
                $this->errors[] = $this->l('For security reasons, you cannot delete default payment profiles.');
            } else {
                return parent::postProcess();
            }
        } elseif (Tools::isSubmit('submitBulkdelete'.$this->table)) {
            return parent::postProcess();
        } else {
            return parent::postProcess();
        }
    }

    public function renderList()
    {
        $lists = parent::renderList();
        $this->postProcess();
        $this->toolbar_title = $this->l('Damage Deposits');

        parent::initToolbar();
        return $lists;
    }

    public function initPageHeaderToolbar()
    {
        if (empty($this->display)) {
            $this->page_header_toolbar_btn['new_damage_deposit'] = array(
                'href' => self::$currentIndex.'&add'.$this->table.'&token='.$this->token,
                'desc' => $this->l('Add new damage deposit', null, null, false),
                'icon' => 'process-icon-new'
            );
        }
        parent::initPageHeaderToolbar();
    }


    public function renderForm()
    {
        $deposit_method_options = array(
            array(
                'id_deposit_method' => ProductRentalDamageDeposit::DAMAGE_DEPOSIT_ASIS_METHOD,
                'name' => $this->l('As Is', 'RentalDamageDeposit'),
            ),
            array(
                'id_deposit_method' => ProductRentalDamageDeposit::DAMAGE_DEPOSIT_PERITEM_METHOD,
                'name' => $this->l('Per Item', 'RentalDamageDeposit'),
            ),
            array(
                'id_deposit_method' => ProductRentalDamageDeposit::DAMAGE_DEPOSIT_PERITEMPERDAY_METHOD,
                'name' => $this->l('Per Item / Per Day', 'RentalDamageDeposit'),
            ),
        );

        $deposit_source_options = array(
            array(
                'id_deposit_source_value' => ProductRentalDamageDeposit::DAMAGE_DEPOSIT_TOTALVALUE_SOURCE,
                'name' => $this->l('Total Rental Value', 'RentalDamageDeposit'),
            ),
            array(
                'id_deposit_source_value' => ProductRentalDamageDeposit::DAMAGE_DEPOSIT_TOTALPAID_SOURCE,
                'name' => $this->l('Total Paid at Checkout', 'RentalDamageDeposit'),
            ),
        );

        $deposit_tax_options = array(
            array(
                'with_tax' => ProductRentalDamageDeposit::DAMAGE_DEPOSIT_TAXINC,
                'name' => $this->l('Tax Inc.', 'RentalDamageDeposit'),
            ),
            array(
                'with_tax' => ProductRentalDamageDeposit::DAMAGE_DEPOSIT_TAXEXC,
                'name' => $this->l('Tax Exc.', 'RentalDamageDeposit'),
            ),
        );
        $this->fields_form = array(
            'legend' => array(
                'title' => $this->l('Damage Deposit'),
                'icon' => 'icon-time',
            ),
            'input' => array(
                array(
                    'type' => 'text',
                    'label' => $this->l('Damge Deposit Profile Name'),
                    'hint' => $this->l('Provide a name for this profile.'),
                    'name' => 'name',
                    'required' => true,
                    'lang' => false,
                ),
                array(
                    'type' => 'select',
                    'label' => $this->l('Select Type'),
                    'name' => 'id_deposit_type',
                    'hint' => $this->l('Select the type of damage deposit.'),
                    'options' => array(
                        'query' => $this->deposit_type_options,
                        'id' => 'id_deposit_type',
                        'name' => 'deposit_type_name',
                    ),
                ),
                array(
                    'type' => 'select',
                    'label' => $this->l('Deposit Method'),
                    'name' => 'id_deposit_method',
                    'hint' => $this->l('Fixed type calculation method'),
                    'options' => array(
                        'query' => $deposit_method_options,
                        'id' => 'id_deposit_method',
                        'name' => 'name',
                    ),
                ),
                array(
                    'type' => 'select',
                    'label' => $this->l('Deposit Source'),
                    'name' => 'id_deposit_source_value',
                    'hint' => $this->l('Percentage type source price'),
                    'options' => array(
                        'query' => $deposit_source_options,
                        'id' => 'id_deposit_source_value',
                        'name' => 'name',
                    ),
                ),
                array(
                    'type' => 'text',
                    'label' => $this->l('Deposit Amount'),
                    'hint' => $this->l('Provide the deposit amount, if required.'),
                    'name' => 'deposit_amount',
                    'suffix' => $this->context->currency->sign,
                    'required' => false,
                    'lang' => false,
                ),
                array(
                    'type' => 'switch',
                    'label' => $this->l('Enabled'),
                    'name' =>'enabled',
                    'class' => 't',
                    'is_bool' => true,
                    'required' => false,
                    'values' => array(
                        array(
                            'id' => 'enabled_on',
                            'value' => 1,
                            'label' => $this->l('Yes')
                        ),
                        array(
                            'id' => 'enabled_off',
                            'value' => 0,
                            'label' => $this->l('No')
                        )
                    )
                ),
            ),
            'submit' => array(
                'title' => $this->l('Save'),
            ),
        );

        if (Tools::isSubmit('update'.$this->table) ||
            Tools::isSubmit('add'.$this->table)
        ) {
            return $this->renderDamageDepositForm();
        } else {
            return parent::renderForm();
        }
    }

    protected function renderDamageDepositForm()
    {
        if (!($this->loadObject(true))) {
            return;
        }

        return parent::renderForm();
    }
}
