<?php
/**
 * PricePeriodsController
 *
 * @author    Roja45
 * @copyright 2016 Roja45
 * @license   license.txt
 * @category  PricePeriodsController
 *
 * 2016 ROJA45 - All rights reserved.
 *
 * DISCLAIMER
 * Changing this file will render any support provided by us null and void.
 */

/**
 * PricePeriodsController
 *
 * @author    Roja45
 * @copyright 2016 Roja45
 * @license   license.txt
 * @category  Class
 *
 * 2016 ROJA45 - All rights reserved.
 *
 * DISCLAIMER
 * Changing this file will render any support provided by us null and void.
 */

class RentalDiscountsController extends ModuleAdminController
{
    public function __construct()
    {
        parent::__construct();
        $this->context = Context::getContext();
        $this->override_folder = 'rental_discounts/';
        $this->tpl_folder = 'rental_discounts/';
        $this->bootstrap = true;
        $this->table = 'roja45_productrental_discount';
        $this->table_id = 'id_roja45_product_discount';
        $this->identifier = 'id_roja45_product_discount';
        $this->submit_action = 'submitAdd' . $this->table;
        $this->show_cancel_button = true;
        $this->className = 'ProductRentalDiscount';
        $this->lang = false;
        $this->deleted = false;
        $this->colorOnBackground = false;
        $this->bulk_actions = array(
            'delete' => array(
                'text' => $this->l('Delete selected'),
                'confirm' => $this->l('Delete selected items?')
            )
        );
        $this->multishop_context = Shop::CONTEXT_ALL;
        $this->imageType = 'gif';
        $this->fieldImageSettings = array(
            'name' => 'icon',
            'dir' => 'os',
        );

        $this->toolbar_title = $this->l('Rental Discounts');

        $this->_defaultOrderBy = $this->identifier = 'id_roja45_product_discount';
        $this->deleted = false;
        $this->_orderBy = 'id_roja45_product_discount';
        $this->_orderWay = 'ASC';
        $this->addRowAction('edit');
        $this->addRowAction('delete');
        $this->addRowAction('duplicateDiscount');

        $this->bulk_actions = array(
            'delete' => array(
                'text' => $this->l('Delete selected'),
                'confirm' => $this->l('Delete selected items?'),
                'icon' => 'icon-trash',
            ),
        );

        $this->fields_list = array(
            'id_roja45_product_discount' => array(
                'title' => $this->l('Id'),
                'width' => 'auto'
            ),
            'name' => array(
                'title' => $this->l('Name'),
                'width' => 'auto',
            ),
            'start_date' => array(
                'title' => $this->l('Starting'),
                'width' => 'auto',
                'type' => 'datetime'
            ),
            'end_date' => array(
                'title' => $this->l('Ending'),
                'width' => 'auto',
                'type' => 'datetime'
            ),
            'enabled' => array(
                'title' => $this->l('Enabled'),
                'align' => 'text-center',
                'active' => 'enableDiscount',
                'type' => 'bool',
                'ajax' => true,
                'orderby' => false,
                'class' => 'fixed-width-sm',
                'filter_type' => 'bool',
                'filter_key' => 'a!enabled',
            ),
        );
        $this->tabAccess = Profile::getProfileAccess(
            $this->context->employee->id_profile,
            Tab::getIdFromClassName('RentalDiscounts')
        );
    }

    public function postProcess()
    {
        if (Tools::isSubmit($this->table.'Orderby') || Tools::isSubmit($this->table.'Orderway')) {
            $this->filter = true;
        }

        if (Tools::isSubmit('submitAdd'.$this->table)) {
            $object = parent::postProcess();
            if (Validate::isLoadedObject($object)) {
                $this->deleted = false;
                Tools::redirectAdmin($this->context->link->getAdminLink(
                    'RentalDiscounts',
                    true
                ) . '&id_roja45_product_discount=' . $object->id . '&updateroja45_productrental_discount');
            }
        } elseif (Tools::isSubmit('submitBulkdelete'.$this->table)) {
            return parent::postProcess();
        } elseif (Tools::isSubmit('duplicate'.$this->table)) {
            $object = new ProductRentalDiscount(Tools::getValue($this->identifier));
            if (Validate::isLoadedObject($object)) {
                $object->duplicate();
            }
            Tools::redirectAdmin($this->context->link->getAdminLink(
                'RentalDiscounts',
                true
            ));
            return parent::postProcess();
        } else {
            return parent::postProcess();
        }
    }

    public function processSave()
    {
        $_POST['reduction_type'] = ProductRentalDiscount::TYPE_PERCENTAGE;
        $_POST['reduction_tax'] = false;
        if (Validate::isLoadedObject(($object = parent::processSave()))) {
            /** @var ProductRentalDiscount $object */
            $object->deleteConditions();
            foreach ($_POST as $key => $values) {
                if (preg_match('/^condition_group_([0-9]+)$/Ui', $key, $condition_group)) {
                    $conditions = array();
                    foreach ($values as $value) {
                        $condition = explode('_', $value);
                        $conditions[] = array('type' => $condition[0], 'value' => $condition[1]);
                    }
                    $object->addConditions($conditions);
                }
            }

            if (Tools::getValue('discounts')) {
                foreach (Tools::getValue('discounts') as $key => $values) {
                    $values = explode('_', $values);
                    $discount = array(
                        'id' => (int)$values[0],
                        'position' => (int)$key,
                        'period_start' => (int)$values[1],
                        'period_end' => (int)$values[2],
                        'value' => $values[3]
                    );
                    if (isset($values[4]) && ((int)$values[4]==1)) {
                        $object->deleteDiscountProfile($values[0]);
                    } else {
                        $object->addDiscountProfile($discount);
                    }
                }
            }

            $object->apply();
            return $object;
        }
    }

    public function initPageHeaderToolbar()
    {
        if (empty($this->display)) {
            $this->page_header_toolbar_btn['new_rental_discount'] = array(
                'href' => self::$currentIndex.'&add'.$this->table.'&token='.$this->token,
                'desc' => $this->l('Add new rental discount', null, null, false),
                'icon' => 'process-icon-new'
            );
        }

        parent::initPageHeaderToolbar();
    }

    public function renderForm()
    {
        if (!$this->object->id) {
            $this->object->price = -1;
        }

        $this->fields_form = array(
            'legend' => array(
                'title' => $this->l('Rental Discount'),
            ),
            'input' => array(
                array(
                    'type' => 'text',
                    'label' => $this->l('Name'),
                    'name' => 'name',
                    'maxlength' => 32,
                    'required' => true,
                    'hint' => $this->l('Forbidden characters').' <>;=#{}'
                ),
                array(
                    'type' => 'datetime',
                    'label' => $this->l('From'),
                    'hint' => $this->l('The discount defined will apply from this date.'),
                    'name' => 'start_date',
                    'autocomplete' => 'off'
                ),
                array(
                    'type' => 'datetime',
                    'label' => $this->l('Until'),
                    'hint' => $this->l('The discount defined will apply until this date.'),
                    'name' => 'end_date',
                    'autocomplete' => 'off'
                ),
                array(
                    'type' => 'switch',
                    'label' => $this->l('Enabled'),
                    'name' => 'enabled',
                    'is_bool' => true,
                    'required' => false,
                    'values' => array(
                        array(
                            'id' => 'required_on',
                            'value' => 1,
                            'label' => $this->l('Yes')
                        ),
                        array(
                            'id' => 'required_off',
                            'value' => 0,
                            'label' => $this->l('No')
                        )
                    )
                ),
            ),
            'submit' => array(
                'title' => $this->l('Save')
            ),
        );

        $this->fields_value = array(
            'from_quantity' => (($value = $this->getFieldValue($this->object, 'from_quantity')) ? $value : 1),
            'reduction' => number_format((($value = $this->getFieldValue($this->object, 'reduction')) ? $value : 0), 6),
            'enabled' => (int) $this->getFieldValue($this->object, 'enabled')
        );

        $this->tpl_form_vars = array(
            'categories' => Category::getSimpleCategories((int)$this->context->language->id),
            'conditions' => $this->object->getConditions(),
            'discounts' => $this->object->getDiscounts(),
            'products' => ProductRentalDetails::getRentalProducts(
                $this->context->language->id
            ),
            'period_upper_limit' => 365,
            'period_txt' => 'Days',
        );
        return parent::renderForm();
    }

    public function displayDuplicateDiscountLink($token, $id)
    {
        $tpl = $this->createTemplate('list_action_duplicate_discount.tpl');
        $tpl->assign(array(
            'href' => $this->context->link->getAdminLink('RentalDiscounts', true) . '&token='.$token .'&'.$this->identifier.'='.$id.'&duplicate'.$this->table,
            'action' => ' Duplicate',
            'id_roja45_product_discount' => $id
        ));
        return $tpl->fetch();
    }

    public function ajaxProcessenableDiscountroja45ProductrentalDiscount()
    {
        $id = (int)Tools::getValue($this->identifier);
        $sql = '
            UPDATE '._DB_PREFIX_.'roja45_productrental_discount
            SET `enabled`= NOT `enabled`
            WHERE '.$this->identifier.'='.$id;
        $result = Db::getInstance()->execute($sql);

        if ($result) {
            $json = Tools::jsonEncode(array(
                'success' => 1,
                'text' => $this->l('The status has been updated successfully.'),
            ));
            die($json);
        } else {
            $json = Tools::jsonEncode(array(
                'success' => 0,
                'text' => $this->l('An error occurred while updating this status.'),
            ));
            die($json);
        }
    }

    public function ajaxProcessUpdateDiscountProfileAmount()
    {
        $id_roja45_product_discount = (int)Tools::getValue($this->identifier);
        $discount_profile = explode('_', (int)Tools::getValue('id_discount'));
        $discount_amount = (int)Tools::getValue('discount_amount');
        $sql = '
            UPDATE '._DB_PREFIX_.'roja45_productrental_discountprofile
            SET `value`= ' .$discount_amount . '
            WHERE id_roja45_product_discountprofile='.$discount_profile[0];
        if (Db::getInstance()->execute($sql)) {
            $json = Tools::jsonEncode(array(
                'success' => 1,
                'text' => $this->l('The status has been updated successfully.'),
            ));
            die($json);
        } else {
            $json = Tools::jsonEncode(array(
                'success' => 0,
                'text' => $this->l('An error occurred while updating this status.'),
            ));
            die($json);
        }
    }
}
