<?php
/**
 * PricePeriodsController
 *
 * @author    Roja45
 * @copyright 2016 Roja45
 * @license   license.txt
 * @category  PricePeriodsController
 *
 * 2016 ROJA45 - All rights reserved.
 *
 * DISCLAIMER
 * Changing this file will render any support provided by us null and void.
 */

/**
 * PricePeriodsController
 *
 * @author    Roja45
 * @copyright 2016 Roja45
 * @license   license.txt
 * @category  Class
 *
 * 2016 ROJA45 - All rights reserved.
 *
 * DISCLAIMER
 * Changing this file will render any support provided by us null and void.
 */

class RentalExtrasController extends ModuleAdminController
{
    public function __construct()
    {
        parent::__construct();
        $this->context = Context::getContext();
        $this->override_folder = 'productrental_extras';
        $this->bootstrap = true;
        $this->table = 'roja45_productrental_extra';
        $this->identifier = 'id_roja45_product_extra';
        $this->submit_action = 'submitAdd'.$this->table;
        $this->show_cancel_button = true;
        $this->className = 'ProductRentalExtra';
        $this->lang = true;
        $this->deleted = false;
        $this->colorOnBackground = false;
        $this->bulk_actions = array(
            'delete' => array('text' => $this->l('Delete selected'), 'confirm' => $this->l('Delete selected items?'))
        );
        $this->multishop_context = Shop::CONTEXT_ALL;
        $this->imageType = 'gif';
        $this->fieldImageSettings = array(
            'name' => 'icon',
            'dir' => 'os',
        );

        $this->_defaultOrderBy = 'id_roja45_product_extra';
        $this->_use_found_rows = true;
        $this->list_id = 'id_roja45_product_extra';
        $this->deleted = false;
        $this->_orderBy = 'id_roja45_product_extra';
        $this->_orderWay = 'ASC';
        $this->position_identifier = 'id_roja45_product_extra';

        $this->_select = '
		a.*,
		etl.name as charge_type';

        $this->_join = '
		LEFT JOIN `'._DB_PREFIX_.'roja45_productrental_extra_type` et 
		ON et.id_roja45_productrental_extra_type = a.id_roja45_productrental_extra_type
		LEFT JOIN `'._DB_PREFIX_.'roja45_productrental_extra_type_lang` etl 
		ON (et.`id_roja45_productrental_extra_type` = etl.`id_roja45_productrental_extra_type` 
		AND etl.`id_lang` = '.(int)$this->context->language->id.')';

        $extra_types = ProductRentalExtraType::getExtraTypes($this->context->language->id);
        $extra_types_array = array();
        foreach ($extra_types as $extra_type) {
            $extra_types_array[$extra_type['id_roja45_productrental_extra_type']] = $extra_type['name'];
        }

        $this->addRowAction('edit');
        $this->addRowAction('delete');

        $this->bulk_actions = array(
            'delete' => array(
                'text' => $this->l('Delete selected'),
                'confirm' => $this->l('Delete selected items?'),
                'icon' => 'icon-trash',
            ),
        );

        $this->fields_list = array(
            'id_roja45_product_extra' => array(
                'title' => $this->l('ID'),
                'align' => 'text-center',
                'class' => 'fixed-width-sm',
            ),
            'name' => array(
                'title' => $this->l('Name'),
                'width' => 'auto',
            ),
            'rate' => array(
                'title' => $this->l('Rate'),
                'width' => 'auto',
                'type' => 'price',
            ),

            'charge_type' => array(
                'title' => $this->module->l('Charged'),
                'width' => 'auto',
                'type' => 'select',
                'list' => $extra_types_array,
                'filter_key' => 'charge_type',
                'filter_type' => 'int',
                'order_key' => 'charge_type',
            ),
            'required' => array(
                'title' => $this->l('Required'),
                'align' => 'center',
                'active' => 'required',
                'type' => 'bool',
                'ajax' => true,
                'orderby' => false,
                'class' => 'fixed-width-sm'
            ),
            'default_selected' => array(
                'title' => $this->l('Selected'),
                'align' => 'center',
                'active' => 'default_selected',
                'type' => 'bool',
                'ajax' => true,
                'orderby' => false,
                'class' => 'fixed-width-sm'
            ),
            'enabled' => array(
                'title' => $this->l('Enabled'),
                'align' => 'center',
                'active' => 'enabled',
                'type' => 'bool',
                'ajax' => true,
                'orderby' => false,
                'class' => 'fixed-width-sm'
            ),
        );

        $this->tabAccess = Profile::getProfileAccess($this->context->employee->id_profile, Tab::getIdFromClassName('RentalExtras'));
    }

    public function init()
    {
        if (Tools::isSubmit('add'.$this->table)) {
            $this->display = 'add';
        } elseif (Tools::isSubmit('update'.$this->table)) {
            $this->display = 'edit';
        } elseif (Tools::isSubmit('delete'.$this->table)) {
            $this->display = 'delete';
        }

        return parent::init();
    }

    public function postProcess()
    {
        if (Tools::isSubmit($this->table.'Orderby') || Tools::isSubmit($this->table.'Orderway')) {
            $this->filter = true;
        }

        if (Tools::isSubmit('submitAdd'.$this->table)) {
            $this->deleted = false;
            return parent::postProcess();
        } elseif (Tools::isSubmit('delete'.$this->table)) {
            return parent::postProcess();
        } elseif (Tools::isSubmit('submitBulkdelete'.$this->table)) {
            return parent::postProcess();
        } else {
            return parent::postProcess();
        }
    }

    public function processSave()
    {
        $extra = $this->loadObject(true);
        if (isset($_FILES['image']) &&
            (Tools::strlen($_FILES['image']['name']) > 0)) {
            $type = Tools::strtolower(
                Tools::substr(
                    strrchr($_FILES['image']['name'], '.'),
                    1
                )
            );
            $imagesize = @getimagesize($_FILES['image']['tmp_name']);

            if (isset($_FILES['image']['tmp_name']) &&
                !empty($_FILES['image']['tmp_name']) &&
                !empty($imagesize) &&
                in_array(
                    Tools::strtolower(
                        Tools::substr(
                            strrchr(
                                $imagesize['mime'],
                                '/'
                            ),
                            1
                        )
                    ),
                    array(
                        'jpg',
                        'gif',
                        'jpeg',
                        'png',
                    )
                )
                && in_array($type, array('jpg', 'gif', 'jpeg', 'png'))
            ) {
                // Set the image name with a name contextual to the shop context
                $file_details = pathinfo($_FILES['image']['name']);
                $salt = sha1(microtime());
                //$extra->image = $salt . '_' . $file_details['filename'];
                //$extra->image .= '.' . $file_details['extension'];
                $_POST['image'] = $salt . '_' . $file_details['filename'] . '.' . $file_details['extension'];
                // Copy the image in the module directory with its new name
                if (!move_uploaded_file(
                    $_FILES['image']['tmp_name'],
                    _PS_MODULE_DIR_ . $this->module->name . '/views/img/' . Tools::getValue('image')
                )) {
                    throw new Exception($this->module->l('File upload error.'));
                }
            } else {
                throw new Exception(
                    $this->module->l('Image provided was not in a supported format (jpeg,gif,png).')
                );
            }
        } else if (!empty($extra->image)) {
            $_POST['image'] = $extra->image;
        }
        if ($extra = parent::processSave()) {
            // TODO - Enable all product model extras
            $rental_products = ProductRentalDetails::getRentalProducts($this->context->language->id);
            foreach ($rental_products as $rental_product) {
                $models = ProductRentalModel::getModels($rental_product['id_roja45_product']);
                foreach ($models as $model) {
                    $id_roja45_product_extralink = ProductRentalModelExtra::getModelExtra(
                        Tools::getValue('id_roja45_product_extra'),
                        $model['id_roja45_product_model']
                    );

                    $product_model_extra = new ProductRentalModelExtra($id_roja45_product_extralink);
                    if ((int) Tools::getValue('enabled')) {
                        $product_model_extra->id_roja45_product_extra = Tools::getValue('id_roja45_product_extra');
                        $product_model_extra->id_roja45_product_model = $model['id_roja45_product_model'];
                        $product_model_extra->rate = $extra->rate;
                        $product_model_extra->enabled = (int) Tools::getValue('enabled');
                        $product_model_extra->save();
                    } else if (Validate::isLoadedObject($product_model_extra)) {
                        $product_model_extra->delete();
                    }
                }
            }
        }
        return $extra;
    }

    public function initToolbarTitle()
    {
        $this->toolbar_title = is_array($this->breadcrumbs) ? array_unique($this->breadcrumbs) : array($this->breadcrumbs);
        $extra = $this->loadObject(true);

        switch ($this->display) {
            case 'edit':
                $this->toolbar_title[] = $this->l('Edit Extra: '. $extra->name[Context::getContext()->language->id]);
                $this->addMetaTitle($this->l('Edit Extra: '. $extra->name[Context::getContext()->language->id]));
                break;

            case 'add':
                $this->toolbar_title[] = $this->l('Add new', null, null, false);
                $this->addMetaTitle($this->l('Add new', null, null, false));
                break;

            case 'view':
                $this->toolbar_title[] = $this->l('View Extra: '. $extra->name[Context::getContext()->language->id]);
                $this->addMetaTitle($this->l('View Extra: '. $extra->name[Context::getContext()->language->id]));
                break;
        }

        if ($filter = $this->addFiltersToBreadcrumbs()) {
            $this->toolbar_title[] = $filter;
        }
    }

    public function initPageHeaderToolbar()
    {
        if (empty($this->display)) {
            $this->page_header_toolbar_btn['new_rental_extra'] = array(
                'href' => self::$currentIndex.'&add'.$this->table.'&token='.$this->token,
                'desc' => $this->l('Add new rental extra', null, null, false),
                'icon' => 'process-icon-new'
            );
        }
        parent::initPageHeaderToolbar();
    }

    public function renderForm()
    {
        $extra = $this->loadObject(true);
        $image_url = false;
        if (!empty($extra->image)) {
            $image_url = _PS_MODULE_DIR_.$this->module->name.'/views/img/'.$extra->image;
            $image_url = ImageManager::thumbnail(
                $image_url,
                $this->table.'_'.(int)$extra->id.'.jpg',
                350,
                'jpg',
                false,
                false
            );
        }

        $this->fields_form = array(
            'legend' => array(
                'title' => $this->l('Rental Product Extras'),
                'icon' => 'icon-time',
            ),
            'input' => array(
                array(
                    'type' => 'file',
                    'label' => $this->l('Image'),
                    'hint' => $this->l('Provide an image for the extras'),
                    'name' => 'image',
                    'required' => false,
                    'multiple' => false,
                    'lang' => false,
                    'display_image' => true,
                    'image' => $image_url ? $image_url : false,
                ),
                array(
                    'type' => 'text',
                    'label' => $this->l('Name'),
                    'hint' => $this->l('Provide a name'),
                    'name' => 'name',
                    'required' => true,
                    'lang' => true,
                ),
                array(
                    'type' => 'textarea',
                    'label' => $this->l('Description'),
                    'hint' => $this->l('Provide a description'),
                    'name' => 'description',
                    'required' => true,
                    'lang' => true,
                    'autoload_rte' => true,
                ),
                array(
                    'type' => 'text',
                    'label' => $this->l('Rate'),
                    'hint' => $this->l('Provide the default rate for this extra'),
                    'name' => 'rate',
                    'required' => true,
                    'lang' => false,
                    'class' => 'fixed-width-md',
                    'prefix' => $this->context->currency->sign,
                ),
                array(
                    'type' => 'select',
                    'label' => $this->l('Charge Type'),
                    'name' => 'id_roja45_productrental_extra_type',
                    'hint' => $this->l('How is this extra charged to the rental'),
                    'options' => array(
                        'query' => ProductRentalExtraType::getExtraTypes($this->context->language->id),
                        'id' => 'id_roja45_productrental_extra_type',
                        'name' => 'name',
                    ),
                ),
                array(
                    'type' => 'switch',
                    'label' => $this->l('Required'),
                    'name' => 'required',
                    'hint' => $this->l('Select yes for required or no to make it optional.'),
                    'class' => 't',
                    'is_bool' => true,
                    'required' => false,
                    'values' => array(
                        array(
                            'id' => 'required_on',
                            'value' => 1,
                            'label' => $this->l('Yes')
                        ),
                        array(
                            'id' => 'required_off',
                            'value' => 0,
                            'label' => $this->l('No')
                        )
                    )
                ),
                array(
                    'type' => 'switch',
                    'label' => $this->l('Selected'),
                    'name' => 'default_selected',
                    'hint' => $this->l('Set this extra selected by default.'),
                    'class' => 't',
                    'is_bool' => true,
                    'required' => false,
                    'values' => array(
                        array(
                            'id' => 'default_selected_on',
                            'value' => 1,
                            'label' => $this->l('Yes')
                        ),
                        array(
                            'id' => 'default_selected_off',
                            'value' => 0,
                            'label' => $this->l('No')
                        )
                    )
                ),
                array(
                    'type' => 'switch',
                    'label' => $this->l('Deselect Warning'),
                    'name' => 'deselect_warning',
                    'hint' => $this->l('Display a warning popup if the customer deselects this extra.'),
                    'class' => 't',
                    'is_bool' => true,
                    'required' => false,
                    'values' => array(
                        array(
                            'id' => 'deselect_warning_on',
                            'value' => 1,
                            'label' => $this->l('Yes')
                        ),
                        array(
                            'id' => 'deselect_warning_off',
                            'value' => 0,
                            'label' => $this->l('No')
                        )
                    )
                ),
                array(
                    'type' => 'textarea',
                    'label' => $this->l('Deselect Warning Text'),
                    'hint' => $this->l('Text to display in the warning popup.'),
                    'name' => 'deselect_warning_text',
                    'required' => false,
                    'lang' => true,
                    'autoload_rte' => true,
                ),
                array(
                    'type' => 'switch',
                    'label' => $this->l('Enabled'),
                    'name' => 'enabled',
                    'hint' => $this->l('Enable or disable this extra globally.'),
                    'class' => 't',
                    'is_bool' => true,
                    'required' => false,
                    'values' => array(
                        array(
                            'id' => 'enabled_on',
                            'value' => 1,
                            'label' => $this->l('Yes')
                        ),
                        array(
                            'id' => 'enabled_off',
                            'value' => 0,
                            'label' => $this->l('No')
                        )
                    )
                ),
            ),
            'submit' => array(
                'title' => $this->l('Save'),
            ),
        );

        if (Tools::isSubmit('update'.$this->table) || Tools::isSubmit('add'.$this->table)) {
            return $this->renderExtrasForm();
        } else {
            return parent::renderForm();
        }
    }

    protected function renderExtrasForm()
    {
        if (!($this->loadObject(true))) {
            return;
        }

        return parent::renderForm();
    }
}
