<?php
/**
 * PaymentProfilesController
 *
 * @author    Roja45
 * @copyright 2016 Roja45
 * @license   license.txt
 * @category  PaymentProfilesController
 *
 * 2016 ROJA45 - All rights reserved.
 *
 * DISCLAIMER
 * Changing this file will render any support provided by us null and void.
 */

/**
 * PaymentProfilesController
 *
 * @author    Roja45
 * @copyright 2016 Roja45
 * @license   license.txt
 * @category  Class
 *
 * 2016 ROJA45 - All rights reserved.
 *
 * DISCLAIMER
 * Changing this file will render any support provided by us null and void.
 */

class RentalPaymentProfilesController extends ModuleAdminController
{
    public function __construct()
    {
        parent::__construct();
        $this->context = Context::getContext();
        $this->override_folder = 'roja45productrental_paymentprofiles';
        $this->bootstrap = true;
        $this->table = 'roja45_productrental_paymentprofile';
        $this->identifier = 'id_roja45_product_paymentprofile';
        $this->submit_action = 'submitAddroja45_productrental_paymentprofile';
        $this->show_cancel_button = true;
        $this->className = 'ProductRentalPaymentProfile';
        $this->lang = true;
        $this->deleted = false;
        $this->colorOnBackground = false;
        $this->bulk_actions = array(
            'delete' => array(
                'text' => $this->l('Delete selected'),
                'confirm' => $this->l('Delete selected items?')
            )
        );
        $this->multishop_context = Shop::CONTEXT_ALL;
        $this->imageType = 'gif';
        $this->fieldImageSettings = array(
            'name' => 'icon',
            'dir' => 'os',
        );
        $this->addRowActionSkipList('delete', range(1, 3));
        $this->tabAccess = Profile::getProfileAccess(
            $this->context->employee->id_profile,
            Tab::getIdFromClassName('RentalPaymentProfiles')
        );

        $this->_defaultOrderBy = $this->identifier = 'id_roja45_product_paymentprofile';
        $this->list_id = 'roja45_productrental_paymentprofile';
        $this->deleted = false;
        $this->_orderBy = 'position';
        $this->_orderWay = 'ASC';
        $this->position_identifier = 'position';

        $this->addRowAction('edit');
        $this->addRowAction('delete');

        $this->bulk_actions = array(
            'delete' => array(
                'text' => $this->l('Delete selected'),
                'confirm' => $this->l('Delete selected items?'),
                'icon' => 'icon-trash',
            ),
        );

        $this->fields_list = array(
            'position' => array(
                'title' => $this->l('Position'),
                'width' => 'auto',
                'position' => true
            ),
            'id_group' => array(
                'title' => $this->l('Default Group'),
                'width' => 'auto',
            ),
            'name' => array(
                'title' => $this->l('Profile Name'),
                'width' => 'auto',
            ),
            'type' => array(
                'title' => $this->l('Type'),
                'width' => 'auto',
            ),
            'deposit_amount' => array(
                'title' => $this->l('Deposit Amount'),
                'width' => 'auto',
            ),
            'deposit_type' => array(
                'title' => $this->l('Deposit Type'),
                'width' => 'auto',
            ),
            'enabled' => array(
                'title' => $this->l('Enabled'),
                'align' => 'center',
                'active' => 'enabled',
                'type' => 'bool',
                'ajax' => true,
                'orderby' => false,
                'class' => 'fixed-width-sm'
            ),
        );
    }

    public function init()
    {
        if (Tools::isSubmit('addroja45_productrental_paymentprofile')) {
            $this->display = 'add';
        } elseif (Tools::isSubmit('updateroja45_productrental_paymentprofile')) {
            $this->display = 'edit';
        } elseif (Tools::isSubmit('deleteroja45_productrental_paymentprofile')) {
            $this->display = 'delete';
        }

        return parent::init();
    }

    public function setMedia($isNewTheme = false)
    {
        parent::setMedia($isNewTheme);
        if ($this->display &&
            isset($this->tabAccess[$this->display]) &&
            $this->tabAccess[$this->display] == 1 &&
            in_array($this->display, array('add', 'view', 'edit'))
        ) {
            $this->context->controller->addJs(
                _PS_MODULE_DIR_ . $this->module->name . '/views/js/roja45productrental_profiles.js'
            );
        }
    }
    public function postProcess()
    {
        if (Tools::isSubmit($this->table.'Orderby') || Tools::isSubmit($this->table.'Orderway')) {
            $this->filter = true;
        }

        if (Tools::isSubmit('submitAdd'.$this->table)) {
            $this->deleted = false;

            return parent::postProcess();
        } elseif (Tools::isSubmit('delete'.$this->table)) {
            $paymentprofile = new ProductRentalPaymentProfile(
                Tools::getValue('id_roja45_product_paymentprofile'),
                $this->context->language->id
            );
            if (!$paymentprofile->isRemovable()) {
                $this->errors[] = $this->l('For security reasons, you cannot delete default payment profiles.');
            } else {
                return parent::postProcess();
            }
        } elseif (Tools::isSubmit('submitBulkdelete'.$this->table)) {
            return parent::postProcess();
        } else {
            return parent::postProcess();
        }
    }

    public function getList(
        $id_lang,
        $orderBy = null,
        $orderWay = null,
        $start = 0,
        $limit = null,
        $id_lang_shop = null
    ) {
        parent::getList($id_lang, $orderBy, $orderWay, $start, $limit, $id_lang_shop);
        foreach ($this->_list as &$list_item) {
            if ($list_item['enabled'] == 1) {
                $list_item['enabled'] = $this->l('Yes');
            } else {
                $list_item['enabled'] = $this->l('No');
            }

            if ((int) $list_item['id_group'] > 0) {
                $group = new Group($list_item['id_group'], $this->context->language->id);
                $list_item['id_group'] = $group['name'];
            } else {
                $list_item['id_group'] = $this->l('All Groups');
            }

            if ($list_item['type'] == ProductRentalPaymentProfile::FULL) {
                $list_item['type'] = $this->l('Full Payment');
            } elseif ($list_item['type'] == ProductRentalPaymentProfile::DEPOSIT_FINAL) {
                $list_item['type'] = $this->l('Deposit + Final');
            } elseif ($list_item['type'] == ProductRentalPaymentProfile::COD_FINAL) {
                $list_item['type'] = $this->l('Deposit + COD');
            }
            if ($list_item['deposit_type'] == ProductRentalPaymentProfile::PERCENTAGE) {
                $list_item['deposit_type'] = $this->l('Percentage');
            } elseif ($list_item['deposit_type'] == ProductRentalPaymentProfile::FIXED) {
                $list_item['deposit_type'] = $this->l('Fixed Amount');
            }
        }
    }

    public function ajaxProcessUpdatePositions()
    {
        $way = (int)(Tools::getValue('way'));
        $id = (int)(Tools::getValue('id'));
        $positions = Tools::getValue('roja45_product_paymentprofile');

        foreach ($positions as $position => $value) {
            $pos = explode('_', $value);

            if (isset($pos[2]) && (int)$pos[2] === $id) {
                if ($profile = new ProductRentalPaymentProfile((int)$pos[2])) {
                    if (isset($position) && $profile->updatePosition($way, $position)) {
                        echo 'ok position '.(int)$position.' for profile '.(int)$pos[1].'\r\n';
                    } else {
                        echo '{"hasError" : true, "errors" : "Can not update profile '.(int)$id.' to position '.(int)$position.' "}';
                    }
                } else {
                    echo '{"hasError" : true, "errors" : "This profile ('.(int)$id.') can t be loaded"}';
                }

                break;
            }
        }
    }

    public function renderList()
    {
        $lists = parent::renderList();

        // call postProcess() to take care of actions and filters
        $this->postProcess();
        $this->toolbar_title = $this->l('Payment Profiles');

        parent::initToolbar();

        return $lists;
    }

    public function initPageHeaderToolbar()
    {
        parent::initPageHeaderToolbar();
        unset($this->page_header_toolbar_btn['back']);
    }

    public function renderForm()
    {
        $deposit_type_options = array(
            array(
                'id_deposit_type' => ProductRentalPaymentProfile::PERCENTAGE,
                'name' => $this->l('Percentage'),
            ),
        );

        $type_options = array(
            array(
                'id_type' => ProductRentalPaymentProfile::FULL,
                'name' => $this->l('Full Payment'),
            ),
            array(
                'id_type' => ProductRentalPaymentProfile::DEPOSIT_FINAL,
                'name' => $this->l('Deposit + Final'),
            ),
            array(
                'id_type' => ProductRentalPaymentProfile::COD_FINAL,
                'name' => $this->l('Deposit + COD'),
            ),
        );

        $all = array();
        $all[0]['id_group'] = 0;
        $all[0]['name'] = $this->l('All Groups');

        $groups = Group::getGroups($this->context->language->id);
        $groups = array_merge($all, $groups);

        $this->fields_form = array(
            'legend' => array(
                'title' => $this->l('Payment Profiles'),
                'icon' => 'icon-time',
            ),
            'input' => array(
                array(
                    'type' => 'text',
                    'label' => $this->l('Profile name'),
                    'hint' => $this->l('Provide a name for this profile.  Not seen by the customer'),
                    'name' => 'name',
                    'required' => true,
                    'lang' => true,
                ),
                array(
                    'type' => 'text',
                    'label' => $this->l('Description'),
                    'hint' => $this->l('Provide a description for the profile, this can be displayed to the customer.'),
                    'name' => 'description',
                    'required' => true,
                    'lang' => true,
                ),
                array(
                    'type' => 'select',
                    'label' => $this->l('Group'),
                    'name' => 'id_group',
                    'hint' => $this->l('Restrict payment profile to a group of customers.'),
                    'options' => array(
                        'query' => $groups,
                        'id' => 'id_group',
                        'name' => 'name',
                    ),
                ),
                array(
                    'type' => 'select',
                    'label' => $this->l('Select Profile'),
                    'name' => 'type',
                    'hint' => $this->l('Select the type of profile.'),
                    'options' => array(
                        'query' => $type_options,
                        'id' => 'id_type',
                        'name' => 'name',
                    ),
                ),
                array(
                    'type' => 'select',
                    'label' => $this->l('Deposit Type'),
                    'name' => 'deposit_type',
                    'hint' => $this->l('Deposit percentage or fixed amount'),
                    'options' => array(
                        'query' => $deposit_type_options,
                        'id' => 'id_deposit_type',
                        'name' => 'name',
                    ),
                ),
                array(
                    'type' => 'text',
                    'label' => $this->l('Deposit Amount'),
                    'hint' => $this->l('Provide the deposit amount, if required.'),
                    'name' => 'deposit_amount',
                    'required' => false,
                    'lang' => false,
                ),
                array(
                    'type' => 'text',
                    'label' => $this->l('Minimum Days'),
                    'hint' => $this->l('Number of days before collection the payment profile will be applied, 100% otherwise.'),
                    'name' => 'days_until_reservation',
                    'required' => false,
                    'lang' => false,
                ),
                array(
                    'type' => 'text',
                    'label' => $this->l('Request Payment'),
                    'hint' => $this->l('Number of days before collection any outstanding payment will be required.'),
                    'name' => 'payment_request_days',
                    'required' => false,
                    'lang' => false,
                ),
                array(
                    'type' => 'switch',
                    'label' => $this->l('Enabled'),
                    'name' => $this->l('enabled'),
                    'hint' => $this->l('Enable or disable this extra globally.'),
                    'class' => 't',
                    'is_bool' => true,
                    'required' => false,
                    'values' => array(
                        array(
                            'id' => 'enabled_on',
                            'value' => 1,
                            'label' => $this->l('Yes')
                        ),
                        array(
                            'id' => 'enabled_off',
                            'value' => 0,
                            'label' => $this->l('No')
                        )
                    )
                ),
            ),
            'submit' => array(
                'title' => $this->l('Save'),
            ),
        );

        $this->override_folder = 'roja45productrental';
        if (Tools::isSubmit('updateroja45_productrental_paymentprofile') ||
            Tools::isSubmit('addroja45_productrental_paymentprofile')
        ) {
            return $this->renderPaymentProfileForm();
        } else {
            return parent::renderForm();
        }
    }

    protected function renderPaymentProfileForm()
    {
        if (!($this->loadObject(true))) {
            return;
        }

        return parent::renderForm();
    }
}
