<?php
/**
 * PricePeriodsController
 *
 * @author    Roja45
 * @copyright 2016 Roja45
 * @license   license.txt
 * @category  PricePeriodsController
 *
 * 2016 ROJA45 - All rights reserved.
 *
 * DISCLAIMER
 * Changing this file will render any support provided by us null and void.
 */

/**
 * PricePeriodsController
 *
 * @author    Roja45
 * @copyright 2016 Roja45
 * @license   license.txt
 * @category  Class
 *
 * 2016 ROJA45 - All rights reserved.
 *
 * DISCLAIMER
 * Changing this file will render any support provided by us null and void.
 */

class RentalPricePeriodsController extends ModuleAdminController
{
    public function __construct()
    {
        parent::__construct();
        $this->context = Context::getContext();

        $this->override_folder = 'price_periods';
        $this->bootstrap = true;
        $this->table = 'roja45_productrental_period';
        $this->identifier = 'id_roja45_product_period';
        $this->submit_action = 'submitAddroja45_productrental_period';
        $this->show_cancel_button = true;
        $this->className = 'ProductRentalPeriod';
        $this->lang = true;
        $this->deleted = false;
        $this->colorOnBackground = false;
        $this->bulk_actions = array(
            'delete' => array('text' => $this->l('Delete selected'), 'confirm' => $this->l('Delete selected items?'))
        );
        $this->multishop_context = Shop::CONTEXT_ALL;
        $this->imageType = 'gif';
        $this->fieldImageSettings = array(
            'name' => 'icon',
            'dir' => 'os',
        );
        $this->tabAccess = Profile::getProfileAccess($this->context->employee->id_profile, Tab::getIdFromClassName('RentalPricePeriods'));
    }

    public function postProcess()
    {
        if (Tools::isSubmit($this->table.'Orderby') || Tools::isSubmit($this->table.'Orderway')) {
            $this->filter = true;
        }

        if (Tools::isSubmit('submitAdd'.$this->table)) {
            $this->deleted = false;

            return parent::postProcess();
        } elseif (Tools::isSubmit('delete'.$this->table)) {
            $period = new ProductRentalPeriod(
                Tools::getValue('id_roja45_product_period'),
                $this->context->language->id
            );
            if (!$period->isRemovable()) {
                $this->errors[] = $this->l('For security reasons, you cannot delete default price periods.');
            } else {
                return parent::postProcess();
            }
        } elseif (Tools::isSubmit('submitBulkdelete'.$this->table)) {
            return parent::postProcess();
        } else {
            return parent::postProcess();
        }
    }

    public function setMedia($isNewTheme = false)
    {
        parent::setMedia($isNewTheme);
        $this->context->controller->addJqueryUI('ui.datepicker');
        $this->addJs(__PS_BASE_URI__.'modules/'.$this->module->name.'/views/js/'.'roja45productrental_priceperiods.js');
    }

    public function renderList()
    {
        //init and render the first list
        $this->initPricePeriodList();
        $lists = parent::renderList();

        // call postProcess() to take care of actions and filters
        $this->postProcess();
        $this->toolbar_title = $this->l('Price Periods');
       // $this->checkFilterForOrdersReturnsList();

        parent::initToolbar();

        return $lists;
    }

    public function getList(
        $id_lang,
        $orderBy = null,
        $orderWay = null,
        $start = 0,
        $limit = null,
        $id_lang_shop = null
    ) {
        parent::getList($id_lang, $orderBy, $orderWay, $start, $limit, $id_lang_shop);
        foreach ($this->_list as &$list_item) {
            if ($list_item['is_recurring'] == 1) {
                $list_item['start_date'] = Tools::substr(
                    $list_item['start_date'],
                    5,
                    Tools::strlen($list_item['start_date'])
                );
                $list_item['end_date'] = Tools::substr(
                    $list_item['end_date'],
                    5,
                    Tools::strlen($list_item['end_date'])
                );
                $list_item['is_recurring'] = $this->l('Yes');
            } else {
                $list_item['is_recurring'] = $this->l('No');
            }
        }
    }

    protected function filterToField($key, $filter)
    {
        if ($this->table == 'roja45_productrental_period') {
            $this->initPricePeriodList();
        }

        return parent::filterToField($key, $filter);
    }

    /**
     * init all variables to render the order status list.
     */
    protected function initPricePeriodList()
    {
        $this->_defaultOrderBy = $this->identifier = 'id_roja45_product_period';
        $this->list_id = 'roja45_productrental_period';
        $this->deleted = false;
        $this->_orderBy = null;

        $this->addRowAction('edit');
        $this->addRowAction('delete');

        $this->bulk_actions = array(
            'delete' => array(
                'text' => $this->l('Delete selected'),
                'confirm' => $this->l('Delete selected items?'),
                'icon' => 'icon-trash',
            ),
        );

        $this->fields_list = array(
            'id_roja45_product_period' => array(
                'title' => $this->l('ID'),
                'align' => 'text-center',
                'class' => 'fixed-width-sm',
            ),
            'name' => array(
                'title' => $this->l('Name'),
                'width' => 'auto',
            ),
            'is_recurring' => array(
                'title' => $this->l('Recurring'),
                'width' => 'auto',
            ),
            'start_date' => array(
                'title' => $this->l('Start Date'),
                'width' => 'auto',
            ),
            'end_date' => array(
                'title' => $this->l('End Date'),
                'width' => 'auto',
            ),
        );
    }

    public function printMakeRecurring($tr)
    {
        return ($tr['new'] ? $this->l('Yes') : $this->l('No'));
    }

    public function initPageHeaderToolbar()
    {
        parent::initPageHeaderToolbar();
        unset($this->page_header_toolbar_btn['back']);
    }

    public function initTabModuleList()
    {
        parent::initTabModuleList();
    }

    public function addToolBarModulesListButton()
    {
        parent::addToolBarModulesListButton();
    }

    public function renderForm()
    {
        $this->fields_form = array(
            'legend' => array(
                'title' => $this->l('Price Periods'),
                'icon' => 'icon-time',
            ),
            'input' => array(
                array(
                    'type' => 'text',
                    'label' => $this->l('Name'),
                    'name' => 'name',
                    'required' => true,
                    'lang' => true,
                ),
                array(
                    'type' => 'switch',
                    'label' => $this->l('Make Recurring'),
                    'name' => 'is_recurring',
                    'class' => 't',
                    'is_bool' => true,
                    'required' => false,
                    'values' => array(
                        array(
                            'id' => 'is_recurring_on',
                            'value' => 1,
                            'label' => $this->l('Yes')
                        ),
                        array(
                            'id' => 'is_recurring_off',
                            'value' => 0,
                            'label' => $this->l('No')
                        )
                    ),
                    'hint' => $this->l('If true this period will check days of the month, valid for all years.')
                ),
                array(
                    'type' => 'roja45_date',
                    'label' => $this->l('Start Date'),
                    'name' => 'start_date',
                    'hint' => $this->l('Start Date'),
                ),
                array(
                    'type' => 'roja45_date',
                    'label' => $this->l('End Date'),
                    'name' => 'end_date',
                    'hint' => $this->l('End Date'),
                ),
            ),
            'submit' => array(
                'title' => $this->l('Save'),
            ),
        );

        if (Tools::isSubmit('updateroja45_productrental_period') || Tools::isSubmit('addroja45_productrental_period')) {
            return $this->renderPricePeriodForm();
        } else {
            return parent::renderForm();
        }
    }

    protected function renderPricePeriodForm()
    {
        if (!($this->loadObject(true))) {
            return;
        }

        return parent::renderForm();
    }
}
