<?php
/**
 * RentalPriceRulesController
 *
 * @author    Roja45
 * @copyright 2016 Roja45
 * @license   license.txt
 * @category  RentalPriceRulesController
 *
 * 2016 ROJA45 - All rights reserved.
 *
 * DISCLAIMER
 * Changing this file will render any support provided by us null and void.
 */

/**
 * RentalPriceRulesController
 *
 * @author    Roja45
 * @copyright 2016 Roja45
 * @license   license.txt
 * @category  Class
 *
 * 2016 ROJA45 - All rights reserved.
 *
 * DISCLAIMER
 * Changing this file will render any support provided by us null and void.
 */

class RentalPriceRulesController extends ModuleAdminController
{
    public function __construct()
    {
        parent::__construct();
        $this->context = Context::getContext();
        $this->override_folder = 'rental_pricerules';
        $this->tpl_folder = 'rental_pricerules/';
        $this->bootstrap = true;
        $this->table = 'roja45_productrental_pricerule';
        $this->table_id = 'id_roja45_product_pricerule';
        $this->identifier = 'id_roja45_product_pricerule';
        $this->submit_action = 'submitAdd' . $this->table;
        $this->show_cancel_button = true;
        $this->className = 'ProductRentalPriceRule';
        $this->lang = false;
        $this->deleted = false;
        $this->colorOnBackground = false;
        $this->bulk_actions = array(
            'delete' => array(
                'text' => $this->l('Delete selected'),
                'confirm' => $this->l('Delete selected items?')
            )
        );
        $this->multishop_context = Shop::CONTEXT_ALL;
        $this->imageType = 'gif';
        $this->fieldImageSettings = array(
            'name' => 'icon',
            'dir' => 'os',
        );

        $this->toolbar_title = $this->l('Rental Price Rules');

        $this->_defaultOrderBy = $this->identifier = 'id_roja45_product_pricerule';
        $this->deleted = false;
        $this->_orderBy = 'id_roja45_product_pricerule';
        $this->_orderWay = 'ASC';
        $this->addRowAction('edit');
        $this->addRowAction('delete');

        $this->bulk_actions = array(
            'delete' => array(
                'text' => $this->l('Delete selected'),
                'confirm' => $this->l('Delete selected items?'),
                'icon' => 'icon-trash',
            ),
        );

        $this->fields_list = array(
            'id_roja45_product_pricerule' => array(
                'title' => $this->l('Id'),
                'width' => 'auto'
            ),
            'name' => array(
                'title' => $this->l('Name'),
                'width' => 'auto',
            ),
            'enabled' => array(
                'title' => $this->l('Enabled'),
                'align' => 'text-center',
                'active' => 'enablePriceRule',
                'type' => 'bool',
                'ajax' => true,
                'orderby' => false,
                'class' => 'fixed-width-sm',
                'filter_type' => 'bool',
                'filter_key' => 'a!enabled',
            ),
        );
        $this->tabAccess = Profile::getProfileAccess(
            $this->context->employee->id_profile,
            Tab::getIdFromClassName('RentalPriceRules')
        );
    }

    public function setMedia($isNewTheme = false)
    {
        parent::setMedia($isNewTheme);
        if ($this->display &&
            isset($this->tabAccess[$this->display]) &&
            $this->tabAccess[$this->display] == 1 &&
            in_array($this->display, array('add', 'view', 'edit'))
        ) {
            $this->context->controller->addJs(
                _PS_MODULE_DIR_ . $this->module->name . '/views/js/roja45productrentaladmin_pricerules.js'
            );
            $this->context->controller->addCSS(
                _PS_MODULE_DIR_ . $this->module->name . '/views/css/roja45productrentaladmin.css'
            );
        }
    }

    public function postProcess()
    {
        if (Tools::isSubmit($this->table.'Orderby') || Tools::isSubmit($this->table.'Orderway')) {
            $this->filter = true;
        }

        if (Tools::isSubmit('submitAdd'.$this->table.'AndStay')) {
            $object = parent::postProcess();
            Tools::redirectAdmin($this->context->link->getAdminLink(
                'RentalPriceRules',
                true
            ) . '&id_roja45_product_pricerule=' . $object->id . '&updateroja45_productrental_pricerule');
        } elseif (Tools::isSubmit('submitAdd'.$this->table)) {
            return parent::postProcess();
        } elseif (Tools::isSubmit('submitBulkdelete'.$this->table)) {
            return parent::postProcess();
        } else {
            return parent::postProcess();
        }
    }

    public function processSave()
    {
        if (Validate::isLoadedObject(($object = parent::processSave()))) {
            /** @var ProductRentalDiscount $object */
            $object->deleteConditions();
            foreach ($_POST as $key => $values) {
                if (preg_match('/^condition_group_([0-9]+)$/Ui', $key, $condition_group)) {
                    $conditions = array();
                    foreach ($values as $value) {
                        $condition = explode('_', $value);
                        $conditions[] = array('type' => $condition[0], 'value' => $condition[1]);
                    }
                    $object->addConditions($conditions);
                }
            }

            if (Tools::getValue('pricerules')) {
                foreach (Tools::getValue('pricerules') as $key => $values) {
                    $values = explode('_', $values);
                    $id =  (int)$values[0];
                    $delete =  (int)$values[1];
                    $profile =  $values[2];
                    $price_rule = array(
                        'id' => (int)$id,
                        'position' => (int)$key,
                        'profile' => $profile,
                    );

                    // TODO - get list days & values
                    if ($delete) {
                        $object->deletePriceRuleProfile($values[0]);
                    } else {
                        $object->addPriceRuleProfile($price_rule);
                    }
                }
            }

            $object->apply();
            return $object;
        }
    }

    public function initPageHeaderToolbar()
    {
        if (empty($this->display)) {
            $this->page_header_toolbar_btn['new_rental_pricerule'] = array(
                'href' => self::$currentIndex.'&add'.$this->table.'&token='.$this->token,
                'desc' => $this->l('Add new rental price rule', null, null, false),
                'icon' => 'process-icon-new'
            );
        }

        parent::initPageHeaderToolbar();
    }

    public function renderForm()
    {
        if (!$this->object->id) {
            $this->object->price = -1;
        }

        $this->fields_form = array(
            'legend' => array(
                'title' => $this->l('Rental Price Rule'),
            ),
            'input' => array(
                array(
                    'type' => 'text',
                    'label' => $this->l('Name'),
                    'name' => 'name',
                    'maxlength' => 32,
                    'required' => true,
                    'hint' => $this->l('Forbidden characters').' <>;=#{}'
                ),
                array(
                    'type' => 'switch',
                    'label' => $this->l('Enabled'),
                    'name' => 'enabled',
                    'is_bool' => true,
                    'required' => false,
                    'values' => array(
                        array(
                            'id' => 'required_on',
                            'value' => 1,
                            'label' => $this->l('Yes')
                        ),
                        array(
                            'id' => 'required_off',
                            'value' => 0,
                            'label' => $this->l('No')
                        )
                    )
                ),
            )
        );

        $this->fields_form['submit'] = array(
            'title' => $this->l('Save')
        );

        $this->fields_form['buttons'] = array(
            'save-and-stay' => array(
                'title' => $this->l('Save and Stay'),
                'name' => 'submitAdd' . $this->table . 'AndStay',
                'type' => 'submit',
                'class' => 'btn btn-default pull-right',
                'icon' => 'process-icon-save',
            ),
        );

        $this->fields_value = array(
            'enabled' => (int) $this->getFieldValue($this->object, 'enabled')
        );

        $this->tpl_form_vars = array(
            'show_toolbar' => true,
            'categories' => Category::getSimpleCategories((int)$this->context->language->id),
            'conditions' => $this->object->getConditions(),
            'price_rules' => $this->object->getPriceRules(),
            'products' => ProductRentalDetails::getRentalProducts(
                $this->context->language->id
            ),
        );
        return parent::renderForm();
    }

    public function ajaxProcessenablePriceRuleroja45ProductrentalPriceRule()
    {
        $id = (int)Tools::getValue($this->identifier);
        $sql = '
            UPDATE '._DB_PREFIX_.'roja45_productrental_pricerule
            SET `enabled`= NOT `enabled`
            WHERE '.$this->identifier.'='.$id;
        $result = Db::getInstance()->execute($sql);

        if ($result) {
            $json = Tools::jsonEncode(array(
                'success' => 1,
                'text' => $this->l('The status has been updated successfully.'),
            ));
            die($json);
        } else {
            $json = Tools::jsonEncode(array(
                'success' => 0,
                'text' => $this->l('An error occurred while updating this status.'),
            ));
            die($json);
        }
    }
}
