<?php
/**
 * RateTypesController
 *
 * @author    Roja45
 * @copyright 2016 Roja45
 * @license   license.txt
 * @category  RateTypesController
 *
 * 2016 ROJA45 - All rights reserved.
 *
 * DISCLAIMER
 * Changing this file will render any support provided by us null and void.
 */

/**
 * RateTypesController
 *
 * @author    Roja45
 * @copyright 2016 Roja45
 * @license   license.txt
 * @category  Class
 *
 * 2016 ROJA45 - All rights reserved.
 *
 * DISCLAIMER
 * Changing this file will render any support provided by us null and void.
*/

class RentalRateTypesController extends ModuleAdminController
{
    public function __construct()
    {
        parent::__construct();
        $this->context = Context::getContext();

        $this->override_folder = 'rental_rate_types/';
        $this->bootstrap = true;
        $this->table = 'roja45_productrental_ratetype';
        $this->identifier = 'id_roja45_product_ratetype';
        $this->submit_action = 'submitAdd'.$this->table;
        $this->show_cancel_button = true;
        $this->className = 'ProductRentalRateType';
        $this->lang = true;
        $this->deleted = false;
        $this->colorOnBackground = false;

        $this->multishop_context = Shop::CONTEXT_ALL;
        $this->imageType = 'gif';
        $this->fieldImageSettings = array(
            'name' => 'icon',
            'dir' => 'os',
        );

        $this->_defaultOrderBy = $this->identifier = 'id_roja45_product_ratetype';
        $this->list_id = 'roja45_productrental_ratetype';
        $this->deleted = false;
        $this->_orderBy = null;
        $this->addRowAction('edit');
        $this->addRowAction('duplicateRate');
        $this->addRowAction('delete');

        $this->bulk_actions = array(
            'delete' => array(
                'text' => $this->l('Delete selected'),
                'confirm' => $this->l('Delete selected items?'),
                'icon' => 'icon-trash',
            ),
        );

        $this->fields_list = array(
            'id_roja45_product_ratetype' => array(
                'title' => $this->l('ID'),
                'align' => 'text-center',
                'class' => 'fixed-width-sm',
            ),
            'name' => array(
                'title' => $this->l('Rate Name'),
                'width' => 'auto',
            ),
            'description' => array(
                'title' => $this->l('Description'),
                'width' => 'auto',
            )
        );

        $this->tabAccess = Profile::getProfileAccess($this->context->employee->id_profile, Tab::getIdFromClassName('RentalRateTypes'));
    }

    public function postProcess()
    {
        if (Tools::isSubmit($this->table.'Orderby') || Tools::isSubmit($this->table.'Orderway')) {
            $this->filter = true;
        }

        if (Tools::isSubmit('submitAdd'.$this->table)) {
            $this->deleted = false;
            return parent::postProcess();
        } elseif (Tools::isSubmit('delete'.$this->table)) {
            $ratetype = new ProductRentalRateType(
                Tools::getValue('id_roja45_product_ratetype'),
                $this->context->language->id
            );
            if (!$ratetype->isRemovable()) {
                $this->errors[] = $this->l('Sorry, you cannot delete default rate types');
            } else {
                return parent::postProcess();
            }
        } elseif (Tools::isSubmit('submitBulkdelete'.$this->table)) {
            return parent::postProcess();
        } elseif (Tools::isSubmit('duplicateRate'.$this->table)) {
            $this->action = 'duplicateRate';
            return parent::postProcess();
        } else {
            return parent::postProcess();
        }
    }

    public function initToolbarTitle()
    {
        $this->toolbar_title = is_array($this->breadcrumbs) ? array_unique($this->breadcrumbs) : array($this->breadcrumbs);
        /** @var ProductRentalRateType $rate_type */
        $rate_type = $this->loadObject(true);

        switch ($this->display) {
            case 'edit':
                $this->toolbar_title[] = $this->l('Edit Rate Type:') . $rate_type->name[(int)$this->context->language->id];
                $this->addMetaTitle($this->l('Edit Rate Type:') . $rate_type->name[(int)$this->context->language->id]);
                break;
            case 'add':
                $this->toolbar_title[] = $this->l('Add new Rate Type', null, null, false);
                $this->addMetaTitle($this->l('Add new Rate Type', null, null, false));
                break;
            case 'view':
                $this->toolbar_title[] = $this->l('View Rate Type:') . $rate_type->name[(int)$this->context->language->id];
                $this->addMetaTitle($this->l('View Rate Type:') . $rate_type->name[(int)$this->context->language->id]);
                break;
            default:
                $this->toolbar_title[] = $this->l('Rate Type');
                $this->addMetaTitle($this->l('Rate Type'));
        }

        if ($filter = $this->addFiltersToBreadcrumbs()) {
            $this->toolbar_title[] = $filter;
        }
    }

    protected function filterToField($key, $filter)
    {
        if ($this->table == 'roja45_productrental_ratetype') {
            $this->initRateTypesList();
        }

        return parent::filterToField($key, $filter);
    }

    protected function beforeAdd($object)
    {
        $default_lang = Configuration::get('PS_LANG_DEFAULT');
        foreach (Language::getLanguages(true) as $lang) {
            if (!Tools::strlen($this->object->name[$lang['id_lang']])) {
                $this->object->name[$lang['id_lang']] = $this->object->name[$default_lang];
            }
        }
    }

    public function initPageHeaderToolbar()
    {
        parent::initPageHeaderToolbar();
        unset($this->page_header_toolbar_btn['back']);
    }


    public function renderForm()
    {
        $durations = array(
            array(
                'id_duration' => 1,
                'name' => $this->l('Daily'),
            ),
        );

        $this->fields_form = array(
            'legend' => array(
                'title' => $this->l('Rate Type'),
                'icon' => 'icon-time',
            ),
            'input' => array(
                array(
                    'type' => 'text',
                    'label' => $this->l('Rate Name'),
                    'name' => 'name',
                    'required' => true,
                    'lang' => true,
                    'hint' => $this->l('Display name provided to user'),
                ),
                array(
                    'type' => 'text',
                    'label' => $this->l('Description'),
                    'name' => 'description',
                    'required' => true,
                    'lang' => true,
                    'hint' => $this->l('Description of rate type provided to user.'),
                ),
                array(
                    'type' => 'select',
                    'label' => $this->l('Duration'),
                    'name' => 'duration',
                    'hint' => $this->l('Type of rate being created'),
                    'options' => array(
                        'query' => $durations,
                        'id' => 'id_duration',
                        'name' => 'name',
                    ),
                )
            ),
            'submit' => array(
                'title' => $this->l('Save'),
            ),
        );

        if (Tools::isSubmit('update'.$this->table) || Tools::isSubmit('add'.$this->table)) {
            return $this->renderRateTypeForm();
        } else {
            return parent::renderForm();
        }
    }

    public function processDuplicateRate()
    {
        $ratetype = new ProductRentalRateType(Tools::getValue('id_roja45_product_ratetype'));
        $new_ratetype = new ProductRentalRateType();
        $new_ratetype->id_roja45_product_ratetype = $ratetype->id_roja45_product_ratetype;
        $new_ratetype->id_roja45_product_rateduration = $ratetype->id_roja45_product_rateduration;
        foreach ($this->context->controller->getLanguages() as $language) {
            $new_ratetype->name[$language['id_lang']] = $ratetype->name[$language['id_lang']].' #2';
            $new_ratetype->description[$language['id_lang']] = $ratetype->description[$language['id_lang']];
        }
        return $new_ratetype->save();
    }

    public function displayDuplicateRateLink($token, $id)
    {
        $tpl = $this->createTemplate('list_action_duplicate_rate.tpl');
        $tpl->assign(array(
            'href' => $this->context->link->getAdminLink(
                'RentalRateTypes',
                true
            ) .'&duplicateRate'.$this->table.'=1&token='.$token .'&id_roja45_product_ratetype='.$id,
            'action' => $this->l('Duplicate'),
            'id_roja45_product_ratetype' => $id
        ));
        return $tpl->fetch();
    }

    protected function renderRateTypeForm()
    {
        if (!($this->loadObject(true))) {
            return;
        }

        return parent::renderForm();
    }
}
