<?php
/**
 * RentalVouchersController
 *
 * @author    Roja45
 * @copyright 2016 Roja45
 * @license   license.txt
 * @category  RentalVouchersController
 *
 * 2016 ROJA45 - All rights reserved.
 *
 * DISCLAIMER
 * Changing this file will render any support provided by us null and void.
 */

/**
 * RentalVouchersController
 *
 * @author    Roja45
 * @copyright 2016 Roja45
 * @license   license.txt
 * @category  Class
 *
 * 2016 ROJA45 - All rights reserved.
 *
 * DISCLAIMER
 * Changing this file will render any support provided by us null and void.
 */

class RentalVouchersController extends ModuleAdminController
{
    public function __construct()
    {
        parent::__construct();
        $this->context = Context::getContext();
        $this->override_folder = 'rental_vouchers';
        $this->tpl_folder = 'rental_vouchers/';
        $this->bootstrap = true;
        $this->table = 'roja45_productrental_voucher';
        $this->table_id = 'id_roja45_product_voucher';
        $this->identifier = 'id_roja45_product_voucher';
        $this->submit_action = 'submitAdd' . $this->table;
        $this->show_cancel_button = true;
        $this->className = 'ProductRentalVoucher';
        $this->lang = true;
        $this->deleted = false;
        $this->colorOnBackground = false;
        $this->bulk_actions = array(
            'delete' => array(
                'text' => $this->l('Delete selected'),
                'confirm' => $this->l('Delete selected items?')
            )
        );
        $this->multishop_context = Shop::CONTEXT_ALL;
        $this->imageType = 'gif';
        $this->fieldImageSettings = array(
            'name' => 'icon',
            'dir' => 'os',
        );

        $this->toolbar_title = $this->l('Rental Vouchers');

        $this->_defaultOrderBy = $this->identifier = 'id_roja45_product_voucher';
        $this->deleted = false;
        $this->_orderBy = 'id_roja45_product_voucher';
        $this->_orderWay = 'ASC';
        $this->addRowAction('edit');
        $this->addRowAction('delete');

        $this->bulk_actions = array(
            'delete' => array(
                'text' => $this->l('Delete selected'),
                'confirm' => $this->l('Delete selected items?'),
                'icon' => 'icon-trash',
            ),
        );

        $this->fields_list = array(
            'id_roja45_product_voucher' => array(
                'title' => $this->l('Id'),
                'width' => 'auto',
                'align' => 'center',
                'class' => 'fixed-width-xs'
            ),
            'name' => array(
                'title' => $this->l('Name'),
                'width' => 'auto'
            ),
            'code' => array(
                'title' => $this->l('Code'),
                'width' => 'auto',
                'class' => 'fixed-width-sm'
            ),
            'date_to' => array(
                'title' => $this->l('Ending'),
                'width' => 'auto',
                'type' => 'datetime',
                'class' => 'fixed-width-lg'
            ),
            'enabled' => array(
                'title' => $this->l('Enabled'),
                'align' => 'center',
                'active' => 'enableDiscount',
                'type' => 'bool',
                'ajax' => true,
                'orderby' => false,
                'class' => 'fixed-width-sm',
                'filter_type' => 'bool',
                'filter_key' => 'a!enabled',
            ),
        );
        $this->tabAccess = Profile::getProfileAccess(
            $this->context->employee->id_profile,
            Tab::getIdFromClassName('RentalVouchers')
        );
    }

    public function init()
    {
        if (Tools::isSubmit('add' . $this->table)) {
            $this->display = 'add';
        } elseif (Tools::isSubmit('update' . $this->table)) {
            $this->display = 'edit';
        } elseif (Tools::isSubmit('delete' . $this->table)) {
            $this->display = 'delete';
        }

        return parent::init();
    }

    public function setMedia($isNewTheme = false)
    {
        parent::setMedia($isNewTheme);
        if ($this->display &&
            isset($this->tabAccess[$this->display]) &&
            $this->tabAccess[$this->display] == 1 &&
            in_array($this->display, array('add', 'view', 'edit'))
        ) {
            $this->context->controller->addJS(
                _PS_MODULE_DIR_ . $this->module->name . '/views/js/roja45productrentaladmin_voucher.js'
            );
            $this->context->controller->addJqueryUI('ui.dialog');
            $this->context->controller->addJqueryUI('ui.effect');
            $this->context->controller->addJqueryUI('ui.datepicker');
            $this->context->controller->addJqueryUI('ui.selectable');
            $this->context->controller->addJqueryPlugin('validate');
            $this->context->controller->addJqueryPlugin('autocomplete');
            $this->context->controller->addJqueryPlugin('typewatch');
        }
    }

    public function postProcess()
    {
        if (Tools::isSubmit('submitAddVoucher') || Tools::isSubmit('submitAddVoucherAndStay')) {
            if (strtotime(Tools::getValue('date_from')) > strtotime(Tools::getValue('date_to'))) {
                $this->errors[] = $this->l(
                    'The voucher cannot end before it begins.',
                    'AdminProductRentals'
                );
            }
            if ((int)Tools::getValue('minimum_amount') < 0) {
                $this->errors[] = $this->l(
                    'The minimum amount cannot be lower than zero.',
                    'AdminProductRentals'
                );
            }
            if ((float)Tools::getValue('reduction_percent') < 0 || (float)Tools::getValue('reduction_percent') > 100) {
                $this->errors[] = $this->l(
                    'Reduction percentage must be between 0% and 100%.',
                    'AdminProductRentals'
                );
            }
            if ((int)Tools::getValue('reduction_amount') < 0) {
                $this->errors[] = $this->l(
                    'Reduction amount cannot be lower than zero.',
                    'AdminProductRentals'
                );
            }
            if (Tools::getValue('code') &&
                ($same_code = (int) ProductRentalVoucher::getIdByCode(Tools::getValue('code'))) &&
                $same_code != Tools::getValue('id_cart_rule')) {
                $this->errors[] = $this->l(
                    'This voucher code is already used (conflict with cart rule %rulename%)',
                    'AdminProductRentals'
                );
            }
            if (Tools::getValue('apply_discount') == 'off' && !Tools::getValue('free_extras')) {
                $this->errors[] = $this->l(
                    'An action is required for this cart rule.',
                    'AdminProductRentals'
                );
            }
        }
        return parent::postProcess();
    }

    public function processSave()
    {
        if (Validate::isLoadedObject(($voucher = parent::processSave()))) {
            /** @var ProductRentalVoucher $voucher */
            $current_selected = array();
            if ($selected_exras = ProductRentalVoucher::getVoucherExtras($voucher->id)) {
                foreach ($selected_exras as $extra) {
                    $current_selected[] = $extra['id_roja45_product_extra'];
                }
            }
            $selected_exras = Tools::getValue('selected_extras');
            if ($selected_exras) {
                foreach ($current_selected as $selected) {
                    if (!in_array($selected, $selected_exras)) {
                        $voucher->deleteExtra($selected);
                    }
                }

                foreach ($selected_exras as $selected) {
                    if (!in_array($selected, $current_selected)) {
                        $voucher->addExtra($selected);
                    }
                }
            } else {
                foreach ($current_selected as $selected) {
                    $voucher->deleteExtra($selected);
                }
                $voucher->free_extras = 0;
                $voucher->save();
            }

            return $voucher;
        }
    }

    public function ajaxProcessSearchCustomer()
    {
        $search_query = trim(Tools::getValue('q'));
        $customers = Db::getInstance()->executeS('
			SELECT `id_customer`, `email`, CONCAT(`firstname`, \' \', `lastname`) as cname
			FROM `'._DB_PREFIX_.'customer`
			WHERE `deleted` = 0 AND is_guest = 0 AND active = 1
			AND (
				`id_customer` = '.(int)$search_query.'
				OR `email` LIKE "%'.pSQL($search_query).'%"
				OR `firstname` LIKE "%'.pSQL($search_query).'%"
				OR `lastname` LIKE "%'.pSQL($search_query).'%"
			)
			'.Shop::addSqlRestriction(Shop::SHARE_CUSTOMER).'
			ORDER BY `firstname`, `lastname` ASC
			LIMIT 50');
        die(json_encode($customers));
    }

    public function ajaxProcessSearchExtras()
    {
        $search_query = trim(Tools::getValue('query'));
        $sql = new DbQuery();
        $sql->select('e.*, el.name');
        $sql->from('roja45_productrental_extra', 'e');
        $sql->leftJoin('roja45_productrental_extra_lang', 'el', 'e.id_roja45_product_extra = el.id_roja45_product_extra');
        $sql->where('el.id_lang='. (int) $this->context->language->id);
        $sql->where('el.name LIKE "%'. pSQL($search_query). '%"');

        $extras = Db::getInstance()->executeS($sql);
        if ($extras && count($extras)) {
            die(Tools::jsonEncode(array(
                'result' => 1,
                'response' => 'Success',
                'extras' => $extras
            )));
        } else {
            die(Tools::jsonEncode(array(
                'result' => 0,
                'response' => 'Nothing found'
            )));
        }
    }

    public function initPageHeaderToolbar()
    {
        if (empty($this->display)) {
            $this->page_header_toolbar_btn['new_rental_voucher'] = array(
                'href' => self::$currentIndex.'&add'.$this->table.'&token='.$this->token,
                'desc' => $this->l('Create new rental voucher', null, null, false),
                'icon' => 'process-icon-new'
            );
        }
        parent::initPageHeaderToolbar();
    }

    public function renderForm()
    {
        /** @var ProductRentalVoucher $rental */
        $voucher = $this->loadObject(true);
        $customer_filter = '';
        if (Validate::isUnsignedId($this->object->id_customer) &&
            ($customer = new Customer($this->object->id_customer)) &&
            Validate::isLoadedObject($customer)) {
            $customer_filter = $customer->firstname.' '.$customer->lastname.' ('.$customer->email.')';
        }

        $this->toolbar_btn['save-and-stay'] = array(
            'href' => '#',
            'desc' => $this->l(
                'Save and stay',
                'RentalVouchers'
            )
        );

        $tpl = $this->context->smarty->createTemplate(
            $this->getTemplatePath().'rental_vouchers/form.tpl'
        );
        $tpl->assign(
            array(
                'id_lang_default' => $this->context->language->id,
                'languages' => $this->context->controller->getLanguages(),
                'link' => $this->context->link,
                'table' => $this->table,
                'toolbar_btn' => $this->toolbar_btn,
                'controller' => $this->context->link->getAdminLink('RentalVouchers', true),
                'voucher' => $this->object,
                'show_toolbar' => true,
                'customerFilter' => $customer_filter,
                'defaultDateFrom' => date('Y-m-d H:00:00'),
                'defaultDateTo' => date('Y-m-d H:00:00', strtotime('+1 month')),
                'extras' => ProductRentalExtra::getExtras($this->context->language->id),
                'selected_extras' => ProductRentalVoucher::getVoucherExtras($voucher->id, $this->context->language->id),
            )
        );
        return  $tpl->fetch();
    }
}
