<?php
/**
 * roja45productrentalProductRentalFacetedSearchModuleFrontController.
 *
 * @author    Roja45
 * @copyright 2016 Roja45
 * @license   license.txt
 * @category  roja45productrentalProductRentalFacetedSearchModuleFrontController
 *
 * 2016 ROJA45 - All rights reserved.
 *
 * DISCLAIMER
 * Changing this file will render any support provided by us null and void.
 */

/**
 * roja45productrentalProductRentalFacetedSearchModuleFrontController.
 *
 * @author    Roja45
 * @copyright 2016 Roja45
 * @license   license.txt
 * @category  Class
 *
 * 2016 ROJA45 - All rights reserved.
 *
 * DISCLAIMER
 * Changing this file will render any support provided by us null and void.
 */

use PrestaShop\PrestaShop\Core\Product\Search\ProductSearchQuery;
use PrestaShop\PrestaShop\Core\Product\Search\SortOrder;
use PrestaShop\PrestaShop\Adapter\Search\SearchProductSearchProvider;

class roja45productrentalProductRentalFacetedSearchModuleFrontController extends ProductListingFrontController
{
    public $php_self = 'module-roja45productrental-ProductRentalFacetedSearchController';
    public $display_column_left = true;
    public $display_column_right = false;

    public function init()
    {
        $_POST['ajax'] = 1;
        parent::init();

        $this->doProductSearch(
            'catalog/listing/search',
            array(
                'entity' => 'search'
            )
        );
    }

    protected function getProductSearchQuery()
    {
        $id_category = Tools::getValue(
            'id_category',
            (Configuration::get('ROJA45_PRODUCTRENTAL_SEARCHCATEGORY')) ?
                Configuration::get('ROJA45_PRODUCTRENTAL_SEARCHCATEGORY') :
                Configuration::get('PS_HOME_CATEGORY')
        );

        $query = new ProductSearchQuery();
        $query->setIdCategory($id_category);
        $query->setSortOrder(
            new SortOrder(
                'product',
                Tools::getProductsOrder('by'),
                Tools::getProductsOrder('way')
            )
        );

        $requirements = array();
        if (!$collection_date = Tools::getValue('ROJA45_PRODUCTRENTAL_COLLECTION_DATE')) {
            $collection_date = null;
        }
        $collection = null;
        if ($collection_date) {
            $collection = DateTime::createFromFormat(
                $this->context->language->date_format_lite,
                $collection_date
            );
            $collection = $collection->format('Y-m-d');
        }

        if (!$return_date = Tools::getValue('ROJA45_PRODUCTRENTAL_RETURN_DATE')) {
            $return_date = null;
        }
        $return = null;
        if ($return_date) {
            $return = DateTime::createFromFormat(
                $this->context->language->date_format_lite,
                $return_date
            );
            $return = $return->format('Y-m-d');
        }
        $requirements['ROJA45_PRODUCTRENTAL_RATE_DURATION'] = Tools::getValue('ROJA45_PRODUCTRENTAL_RATE_DURATION');
        $requirements['ROJA45_PRODUCTRENTAL_COLLECTION_DATE'] = $collection;
        $requirements['ROJA45_PRODUCTRENTAL_RETURN_DATE'] = $return;
        $requirements['ROJA45_PRODUCTRENTAL_COLLECTION_TIME'] = Tools::getValue('ROJA45_PRODUCTRENTAL_COLLECTION_TIME');
        $requirements['ROJA45_PRODUCTRENTAL_RETURN_TIME'] = Tools::getValue('ROJA45_PRODUCTRENTAL_RETURN_TIME');

        $requirements['ROJA45_PRODUCTRENTAL_REQUESTED_QTY'] = Tools::getValue(
            'ROJA45_PRODUCTRENTAL_REQUESTED_QTY'
        );
        $requirements['id_category'] = $id_category;

        RojaFortyFiveProductRentalCore::saveCustomerRequirements($requirements);

        $query_string = http_build_query(
            $requirements,
            '',
            '&'
        );
        $query->setSearchString($query_string);
        // TODO - get search parameters, and save to search query string in this object
        return $query;
    }

    protected function getProductSearchVariables()
    {
        $context = $this->getProductSearchContext();
        $query = $this->getProductSearchQuery();
        $provider = $this->getDefaultProductSearchProvider();

        $resultsPerPage = (int) Tools::getValue('resultsPerPage');
        if ($resultsPerPage <= 0 || $resultsPerPage > 36) {
            $resultsPerPage = Configuration::get('PS_PRODUCTS_PER_PAGE');
        }

        $query
            ->setResultsPerPage($resultsPerPage)
            ->setPage(max((int) Tools::getValue('page'), 1))
        ;

        if (($encodedSortOrder = Tools::getValue('order'))) {
            $query->setSortOrder(SortOrder::newFromString(
                $encodedSortOrder
            ));
        }

        $encodedFacets = Tools::getValue('q');
        $query->setEncodedFacets($encodedFacets);
        $result = $provider->runQuery(
            $context,
            $query
        );
        if (!$result->getCurrentSortOrder()) {
            $result->setCurrentSortOrder($query->getSortOrder());
        }

        $products = $this->prepareMultipleProductsForTemplate(
            $result->getProducts()
        );

        if (!(int) Configuration::get('ROJA45_PRODUCTRENTAL_SHOWWHENSINGLE')) {
            if (count($products) == 1) {
                $controller_url = $this->context->link->getModuleLink(
                    'roja45productrental',
                    'ProductRentalFront',
                    array(
                        'getAvailability' => 1,
                        'ROJA45_PRODUCTRENTAL_ID_PRODUCT' => $products[0]['id_product'],
                        'ROJA45_PRODUCTRENTAL_ID_PRODUCT_ATTRIBUTE' => $products[0]['id_product_attribute'],
                        'qty' => 1,
                        'ROJA45_PRODUCTRENTAL_RATE_DURATION' => Tools::getValue('ROJA45_PRODUCTRENTAL_RATE_DURATION'),
                    )
                );
                Tools::redirect($controller_url);
            }
        }

        if ($provider instanceof FacetsRendererInterface) {
            $rendered_facets = $provider->renderFacets(
                $context,
                $result
            );
            $rendered_active_filters = $provider->renderActiveFilters(
                $context,
                $result
            );
        } else {
            $rendered_facets = $this->renderFacets(
                $result
            );
            $rendered_active_filters = $this->renderActiveFilters(
                $result
            );
        }

        $pagination = $this->getTemplateVarPagination(
            $query,
            $result
        );

        $sort_orders = $this->getTemplateVarSortOrders(
            $result->getAvailableSortOrders(),
            $query->getSortOrder()->toString()
        );

        $sort_selected = false;
        if (!empty($sort_orders)) {
            foreach ($sort_orders as $order) {
                if (isset($order['current']) && true === $order['current']) {
                    $sort_selected = $order['label'];
                    break;
                }
            }
        }

        foreach ($products as &$product) {
            $controller_url = $this->context->link->getModuleLink(
                'roja45productrental',
                'ProductRentalFront',
                array(
                    'getAvailability' => 1,
                    'ROJA45_PRODUCTRENTAL_ID_PRODUCT' => $product['id_product'],
                    'ROJA45_PRODUCTRENTAL_ID_PRODUCT_ATTRIBUTE' => $product['id_product_attribute'],
                    'qty' => 1,
                    'ROJA45_PRODUCTRENTAL_QTY' => 1,
                    'ROJA45_PRODUCTRENTAL_RATE_DURATION' => Tools::getValue('ROJA45_PRODUCTRENTAL_RATE_DURATION'),
                )
            );
            $product['availability_url'] = $controller_url;
            if ((int) Configuration::get('ROJA45_PRODUCTRENTAL_RESULTTOAVAILABLE')) {
                $product->offsetSet('url', $controller_url, true);
            }
        }

        $searchVariables = array(
            'label' => $this->getListingLabel(),
            'page_name' => $this->getPageName(),
            'products' => $products,
            'sort_orders' => $sort_orders,
            'sort_selected' => $sort_selected,
            'pagination' => $pagination,
            'rendered_facets' => $rendered_facets,
            'rendered_active_filters' => $rendered_active_filters,
            'js_enabled' => $this->ajax,
            'current_url' => $this->updateQueryString(array(
                'q' => $result->getEncodedFacets(),
            )),
        );

        Hook::exec('filterProductSearch', array('searchVariables' => &$searchVariables));
        Hook::exec('actionProductSearchAfter', $searchVariables);

        return $searchVariables;
    }

    protected function getAjaxProductSearchVariables()
    {
        $this->assignGeneralPurposeVariables();
        $data = parent::getAjaxProductSearchVariables();
        return $data;
    }

    protected function getTemplateVarSortOrders(array $sortOrders, $currentSortOrderURLParameter)
    {
        return array_map(function ($sortOrder) use ($currentSortOrderURLParameter) {
            $order = $sortOrder->toArray();
            $order['current'] = $order['urlParameter'] === $currentSortOrderURLParameter;
            $order['url'] = $this->updateQueryString(array(
                'order' => $order['urlParameter'],
                'page' => null,
                'ROJA45_PRODUCTRENTAL_COLLECTION_DATE' => Tools::getValue('ROJA45_PRODUCTRENTAL_COLLECTION_DATE'),
                'ROJA45_PRODUCTRENTAL_COLLECTION_TIME' => Tools::getValue('ROJA45_PRODUCTRENTAL_COLLECTION_TIME'),
                'ROJA45_PRODUCTRENTAL_RETURN_DATE' => Tools::getValue('ROJA45_PRODUCTRENTAL_RETURN_DATE'),
                'ROJA45_PRODUCTRENTAL_RETURN_TIME' => Tools::getValue('ROJA45_PRODUCTRENTAL_RETURN_TIME'),
                'ROJA45_PRODUCTRENTAL_RATE_DURATION' => Tools::getValue('ROJA45_PRODUCTRENTAL_RATE_DURATION'),
                'qty' => Tools::getValue('qty'),
            ));

            return $order;
        }, $sortOrders);
    }

    protected function getDefaultProductSearchProvider()
    {
        return new ProductRentalSearchProvider(
            Module::getInstanceByName('roja45productrental'),
            Context::getContext()->getTranslator()
        );
    }

    public function getListingLabel()
    {
        $collection = Tools::getValue('ROJA45_PRODUCTRENTAL_COLLECTION_DATE');
        $return = Tools::getValue('ROJA45_PRODUCTRENTAL_RETURN_DATE');
        $title = Module::getInstanceByName('roja45productrental')->l('Availability') . ': '. $collection . ' - ' . $return;
        return $title;
    }

    public function setMedia($isNewTheme = false)
    {
        parent::setMedia($isNewTheme);
        //$this->addJS(__PS_BASE_URI__ . 'modules/roja45productrental/views/js/roja45productrental.js');
        $this->addJqueryPlugin('validate');
        $this->addJqueryUI('ui.effect');
        $this->addJqueryUI('ui.datepicker');
    }
}
