<?php
/**
 * roja45productrentalProductRentalFrontModuleFrontController.
 *
 * @author    Roja45
 * @copyright 2016 Roja45
 * @license   license.txt
 * @category  roja45productrentalProductRentalFrontModuleFrontController
 *
 * 2016 ROJA45 - All rights reserved.
 *
 * DISCLAIMER
 * Changing this file will render any support provided by us null and void.
 */

/**
 * roja45productrentalProductRentalFrontModuleFrontController.
 *
 * @author    Roja45
 * @copyright 2016 Roja45
 * @license   license.txt
 * @category  Class
 *
 * 2016 ROJA45 - All rights reserved.
 *
 * DISCLAIMER
 * Changing this file will render any support provided by us null and void.
 */

class roja45productrentalProductRentalFrontModuleFrontController extends ModuleFrontController
{
    public function __construct()
    {
        parent::__construct();
        $this->context = Context::getContext();
    }

    public function postProcess()
    {
        parent::initContent();
        if (Tools::getValue('customer_rentals')) {
            $this->processSubmitGetCustomerRentals();
        } elseif (Tools::getValue('customer_rental_history')) {
            $this->processSubmitGetCustomerRentalHistory();
        } elseif (Tools::getValue('view_customer_rental')) {
            $this->processSubmitViewCustomerRental();
        } elseif (Tools::getValue('getAvailability')) {
            $this->processSubmitGetAvailability();
        } elseif (Tools::getValue('submitRental')) {
            $this->processSubmitRentalRequest();
        } elseif (Tools::getValue('confirmRental')) {
            $this->processSubmitCustomerConfirmation();
        } elseif (Tools::getValue('submitPayment')) {
            $this->processSubmitPayment();
        } elseif (Tools::getValue('view_rental_payments')) {
            $this->processSubmitViewRentalPayments();
        } elseif (Tools::getValue('pay_customer_rental')) {
            $this->processSubmitAddToCart();
        } elseif (Tools::getValue('request_cancellation')) {
            $this->processSubmitRequestCancellation();
        } elseif (Tools::getValue('get_rental_confirmation_pdf')) {
            $this->processDownloadPDF();
        } elseif (Tools::getValue('submitCustomDeliveryCollectionAddress')) {
            parent::postProcess();
        } elseif (isset($_SERVER['HTTP_REFERER']) && strpos($_SERVER['HTTP_REFERER'], 'order') !== false) {
            $this->processSubmitGetAvailability();
        }
    }

    private function countSundays($startDate, $endDate){
        $start = new DateTime('2013-01-06');
        $end = new DateTime('2013-01-20');
        $days = $startDate->diff($endDate, true)->days;

        $sundays = intval($days / 7) + ($start->format('N') + $days % 7 >= 7);

        return $sundays;
    }

    public function processSubmitGetAvailability()
    {
        $validationErrors = array();

        try {
            if ((int)Configuration::get('RJ45DISMOD')) {
                return false;
            }
            if (!$id_roja45_product_rateduration = Tools::getValue('ROJA45_PRODUCTRENTAL_RATE_DURATION')) {
                if (!$id_roja45_product_rateduration = RojaFortyFiveProductRentalCore::getCustomerRequirement(
                    'ROJA45_PRODUCTRENTAL_RATE_DURATION'
                )) {
                    $id_roja45_product_rateduration = ProductRentalRateDuration::DAILY;
                }
            }
            if (!$id_product = Tools::getValue('ROJA45_PRODUCTRENTAL_ID_PRODUCT')) {
                if (!$id_product = RojaFortyFiveProductRentalCore::getCustomerRequirement(
                    'ROJA45_PRODUCTRENTAL_ID_PRODUCT'
                )) {
                    $validationErrors[] = $this->module->l('Product Id missing');
                }
            }
            if (!$collection_date = Tools::getValue('ROJA45_PRODUCTRENTAL_COLLECTION_DATE')) {
                if (!$collection_date = RojaFortyFiveProductRentalCore::getCustomerRequirement(
                    'ROJA45_PRODUCTRENTAL_COLLECTION_DATE'
                )) {
                    $validationErrors[] = $this->module->l('Collection date missing');
                }
                $collection_date = DateTime::createFromFormat(
                    'Y-m-d',
                    $collection_date
                );
                if ($collection_date) {
                    $collection_date = $collection_date->format($this->context->language->date_format_lite);
                }
            }
            if (!$return_date = Tools::getValue('ROJA45_PRODUCTRENTAL_RETURN_DATE')) {
                if (!$return_date = RojaFortyFiveProductRentalCore::getCustomerRequirement(
                    'ROJA45_PRODUCTRENTAL_RETURN_DATE'
                )) {
                    $validationErrors[] = $this->module->l('Return date missing');
                }
                $return_date = DateTime::createFromFormat(
                    'Y-m-d',
                    $return_date
                );
                if ($return_date) {
                    $return_date = $return_date->format($this->context->language->date_format_lite);
                }
            }
            if (!is_numeric($id_product_attribute = Tools::getValue('ROJA45_PRODUCTRENTAL_ID_PRODUCT_ATTRIBUTE'))) {
                if (!$id_product_attribute = RojaFortyFiveProductRentalCore::getCustomerRequirement(
                    'ROJA45_PRODUCTRENTAL_ID_PRODUCT_ATTRIBUTE'
                )) {
                    $id_product_attribute = 0;
                }
            }

            $requested_qty = Tools::getValue(
                'qty',
                RojaFortyFiveProductRentalCore::getCustomerRequirement('ROJA45_PRODUCTRENTAL_PRODUCT_QTY')
            );
            if (!$requested_qty) {
                $validationErrors[] = $this->module->l('Required quantity missing');
            }

            $collection_time = Tools::getValue(
                'ROJA45_PRODUCTRENTAL_COLLECTION_TIME',
                RojaFortyFiveProductRentalCore::getCustomerRequirement('ROJA45_PRODUCTRENTAL_COLLECTION_TIME')
            );
            if (!$collection_time) {
                if (!$collection_time = Tools::getValue('ROJA45_PRODUCTRENTAL_COLLECTIONTIME')) {
                    $collection_time = '00:00';
                }
            }

            $return_time = Tools::getValue(
                'ROJA45_PRODUCTRENTAL_RETURN_TIME',
                RojaFortyFiveProductRentalCore::getCustomerRequirement('ROJA45_PRODUCTRENTAL_RETURN_TIME')
            );
            if (!$return_time) {
                if (!$return_time = Tools::getValue('ROJA45_PRODUCTRENTAL_COLLECTIONTIME')) {
                    $return_time = '00:00';
                }
            }
            if (!count($validationErrors)) {
                $id_roja45_product = ProductRentalDetails::isRentable($id_product);
                $requirements = array();
                $requirements['ROJA45_PRODUCTRENTAL_RATE_DURATION'] = $id_roja45_product_rateduration;
                $requirements['ROJA45_PRODUCTRENTAL_ID'] = $id_roja45_product;
                $requirements['ROJA45_PRODUCTRENTAL_ID_PRODUCT'] = $id_product;

                $collection_date_obj = DateTime::createFromFormat(
                    $this->context->language->date_format_lite,
                    $collection_date
                );
                $requirements['ROJA45_PRODUCTRENTAL_COLLECTION_DATE'] = $collection_date_obj->format(
                    'Y-m-d'
                );

                $requirements['ROJA45_PRODUCTRENTAL_COLLECTION_TIME'] = $collection_time;

                $return_date_obj = DateTime::createFromFormat(
                    $this->context->language->date_format_lite,
                    $return_date
                );
                $requirements['ROJA45_PRODUCTRENTAL_RETURN_DATE'] = $return_date_obj->format(
                    'Y-m-d'
                );

                $start_date = strtotime($requirements['ROJA45_PRODUCTRENTAL_COLLECTION_DATE'] . ' ' . $collection_time);
                $end_date = strtotime($requirements['ROJA45_PRODUCTRENTAL_RETURN_DATE'] . ' ' . $return_time);
                $datediff = $end_date - $start_date;
                $datediff = round($datediff / (60 * 60 * 24));

                $requirements['ROJA45_PRODUCTRENTAL_RETURN_TIME'] = $return_time;
                $requirements['ROJA45_PRODUCTRENTAL_ID_PRODUCT_ATTRIBUTE'] = $id_product_attribute;
                $requirements['ROJA45_PRODUCTRENTAL_PRODUCT_QTY'] = $requested_qty;
                $requirements['ROJA45_PRODUCTRENTAL_STATUS'] = 'availability';
                RojaFortyFiveProductRentalCore::saveCustomerRequirements($requirements);

                $rentalproduct = new ProductRentalDetails(
                    $id_roja45_product,
                    (int)$this->context->language->id,
                    (int)$this->context->shop->id
                );
                $rental_details  = array();
                $rental_details = (object) $rental_details;
                $rental_product_details = array(
                    'id_roja45_product' => $id_roja45_product,
                    'collection_date' => $collection_date,
                    'return_date' => $return_date,
                    'models' => array()
                );

                $product_details = $rentalproduct->getRentalProductDetails(
                    $collection_date,
                    $collection_time,
                    $return_date,
                    $return_time,
                    $this->context->language->id,
                    $id_roja45_product_rateduration
                );

                $selected = array();
                if (Configuration::get('ROJA45_PRODUCTRENTAL_PRESELECTRATE')) {
                    $model_details = ProductRentalRental::preselectRate(
                        $requested_qty,
                        $id_product_attribute,
                        $product_details,
                        $id_roja45_product_rateduration
                    );
                    $rental_details->rental_valid = 0;
                    if ($model_details && count($model_details)) {
                        $rental_product_details['models'] = (object)$model_details;
                        $rental_details->products[] = (object) $rental_product_details;
                        $rental_details = ProductRentalRental::validateRental($rental_details);

                        foreach ($rental_product_details['models'] as $model) {
                            if (isset($model->rates)) {
                                if (!isset($selected[$model->id_roja45_product_rental_model])) {
                                    $selected_rates = array();
                                } else {
                                    $selected_rates = $selected[$model->id_roja45_product_rental_model];
                                }
                                foreach ($model->rates as $rate) {
                                    $selected_rates['id_roja45_product_rate'] = $rate->id_roja45_product_rate;
                                    $selected_rates['qty'] = $rate->qty;
                                }
                                $selected[$model->id_roja45_product_rental_model] = $selected_rates;
                            }
                        }

                        if (count($selected)) {
                            $rental_details->rental_valid = 1;
                        }
                    } else {
                        $rental_details->products[] = (object) $rental_product_details;
                        $rental_details = ProductRentalRental::validateRental($rental_details);
                    }
                } else {
                    $rental_details->products[] = (object) $rental_product_details;
                    $rental_details = ProductRentalRental::validateRental($rental_details);
                }

                $this->context->smarty->assign(array(
                    'selected_rate' => $selected,
                    'rental_valid' => count($selected) ? 1 : 0,
                ));
                $token = Tools::getToken(false);
                $controller_url = $this->context->link->getModuleLink(
                    'roja45productrental',
                    'ProductRentalFront',
                    array(
                        'token' => $token
                    )
                );

                $rate_periods = array(
                    1 => array(
                        'id_rate_period' => 1,
                        'period' => 'DAY',
                        'name' => 'Daily Rates',
                    )
                );

                $rentals = ProductRentalRental::getAvailability(
                    $rentalproduct->id_roja45_product
                );

                $working_days = array();
                foreach (ProductRentalWorkingDay::getDays($this->context->language->id) as $working_day) {
                    $working_days[$working_day['id_roja45_product_rental_workingday']] = array(
                        'working_day' => (int) $working_day['is_working_day'],
                        'opening_time' => $working_day['opening_time'],
                        'closing_time' => $working_day['closing_time'],
                    );
                }

                $display_tax = !(Group::getPriceDisplayMethod(Group::getCurrent()->id));

                $roja45_productrental_hasextras = 0;
                foreach ($product_details['models'] as $model) {
                    if (isset($model['addons']) && count($model['addons'])) {
                        $roja45_productrental_hasextras = 1;
                        break;
                    }
                }
                $product = new Product($id_product, false, $this->context->language->id);
                $path = Tools::getPath($product->id_category_default, $product->name, true);
                $product_url = $this->context->link->getProductLink(
                    $id_product,
                    $product->link_rewrite,
                    null,
                    null,
                    $this->context->language->id
                );
                $cat_path = Tools::substr($path, 0, strrpos($path, '>', 0)+1);
                $path = $cat_path .
                    '<a href="'.$product_url.'" title="'.$product->name.'" data-gg="">'.$product->name.'</a>'.
                    '<span class="navigation-pipe">&gt;</span>' .
                    $this->module->l('Get Availability');

                $this->context->smarty->assign($product_details);
                $prod_array = array(
                    'display_tax' => $display_tax,
                    'roja45_productrental_controller' => $controller_url,
                    'roja45_product_url' => $product_url,
                    'roja45_productrental_dateformat' => RojaFortyFiveProductRentalCore::convertDateFormat(
                        $this->context->language->date_format_lite
                    ),
                    'roja45_productrental_timeformat' => 'hh:mm',
                    'qty' => $requested_qty,
                    'ROJA45_PRODUCTRENTAL_MINIMUM_ORDER_QUANTITY' => 1,
                    'ROJA45_PRODUCTRENTAL_ID' => $id_roja45_product,
                    'ROJA45_PRODUCTRENTAL_ID_PRODUCT' => Tools::getValue('ROJA45_PRODUCTRENTAL_ID_PRODUCT'),
                    'ROJA45_PRODUCTRENTAL_RATE_DURATION' => $id_roja45_product_rateduration,
                    'ROJA45_PRODUCTRENTAL_COLLECTION_DATE' => $collection_date,
                    'ROJA45_PRODUCTRENTAL_COLLECTION_TIME' => $collection_time,
                    'ROJA45_PRODUCTRENTAL_RETURN_DATE' => $return_date,
                    'ROJA45_PRODUCTRENTAL_RETURN_TIME' => $return_time,
                    'ROJA45_PRODUCTRENTAL_DAYS' => $datediff,
                    'ROJA45_PRODUCTRENTAL_PREPARATIONDAYS' => (int) Configuration::get(
                        'ROJA45_PRODUCTRENTAL_PREPARATIONDAYS'
                    ),
                    'ROJA45_PRODUCTRENTAL_RECONDITIONDAYS' => (int) Configuration::get(
                        'ROJA45_PRODUCTRENTAL_RECONDITIONDAYS'
                    ),
                    'ROJA45_PRODUCTRENTAL_MINIMUM_DURATION' =>  $rentalproduct->minimum_duration,
                    'ROJA45_PRODUCTRENTAL_MAXIMUM_DURATION' =>  $rentalproduct->maximum_duration,
                    'ROJA45_PRODUCTRENTAL_QTYWARNING' => 5,
                    'ROJA45_PRODUCTRENTAL_ENABLECUSTOMERTIMESELECT' => Configuration::get(
                        'ROJA45_PRODUCTRENTAL_ENABLECUSTOMERTIMESELECT'
                    ),
                    'roja45_productrental_rateperiods' => $rate_periods,
                    'default_id' => '1',
                    'errors' => $this->errors,
                    'rental_details' => $rental_details,
                    'current_product_id' => $id_roja45_product,
                    'has_vouchers' => ProductRentalVoucher::vouchersEnabled(),
                    'multiple_models' => (count($product_details['models']) > 1) ? true : false,
                    'roja45_productrental_singleitemrentals' => (int) Configuration::get(
                        'ROJA45_PRODUCTRENTAL_SINGLEITEMRENTALS'
                    ),
                    'roja45_productrental_hasextras' => $roja45_productrental_hasextras,
                    'path' => $path,
                );
                //print("<pre>".print_r($prod_array,true)."</pre>");
                $this->context->smarty->assign($prod_array);

                Media::addJsDef(array(
                    'roja45_productrental_dateformat' => RojaFortyFiveProductRentalCore::convertDateFormat(
                        $this->context->language->date_format_lite
                    ),
                    'roja45_productrental_timeformat' => 'hh:mm',
                    'roja45_productrental_enabletimeselect' => (int) Configuration::get(
                        'ROJA45_PRODUCTRENTAL_ENABLECUSTOMERTIMESELECT'
                    ),
                    'roja45_productrental_preparationdays' => (int) Configuration::get(
                        'ROJA45_PRODUCTRENTAL_PREPARATIONDAYS'
                    ),
                    'roja45_productrental_reconditiondays' => (int) Configuration::get(
                        'ROJA45_PRODUCTRENTAL_RECONDITIONDAYS'
                    ),
                    'roja45_productrental_controller' => $controller_url,
                    'roja45_id_product_attribute' => $id_product_attribute,
                    'roja45_productrental_requested_qty' => $requested_qty,
                    'roja45_currency_rate' => (float)$this->context->currency->getConversationRate(),
                    'roja45_currency_sign' => $this->context->currency->sign,
                    'roja45_currency_format' => $this->context->currency->format,
                    'roja45_currency_blank' => $this->context->currency->blank,
                    'roja45_productrental_dateformat' => RojaFortyFiveProductRentalCore::convertDateFormat(
                        $this->context->language->date_format_lite
                    ),
                    'minimum_duration' => Configuration::get(
                        'ROJA45_PRODUCTRENTAL_MINIMUM_DURATION'
                    ),
                    'roja45_rentals' => $rentals,
                    'roja45_working_days' => $working_days,
                    'roja45_productrental_rateperiods' => $rate_periods,
                    'roja45_productrental_singleitemrentals' => (int) Configuration::get(
                        'ROJA45_PRODUCTRENTAL_SINGLEITEMRENTALS'
                    ),
                ));

                RojaFortyFiveProductRentalCore::setFrontControllerTemplate($this, 'booking-page.tpl');
            } else {
                throw new Exception($this->module->l('You have validation errors'));
            }
        } catch (Exception $e) {
            $validationErrors[] = $this->module->l('An unexpected error has occurred.');
            $validationErrors[] = $e->getMessage();
            $this->errors = $validationErrors;
            RojaFortyFiveProductRentalCore::setFrontControllerTemplate($this, 'error-page.tpl');
        }
    }

    public function processSubmitRentalRequest()
    {
        $validationErrors = array();
        try {
            if (!$id_roja45_product = Tools::getValue('ROJA45_PRODUCTRENTAL_ID')) {
                if (!$id_roja45_product = RojaFortyFiveProductRentalCore::getCustomerRequirement(
                    'ROJA45_PRODUCTRENTAL_ID'
                )) {
                    $validationErrors[] = $this->module->l('Product Rental Id missing');
                }
            }
            if (!$collection_date = Tools::getValue('ROJA45_PRODUCTRENTAL_COLLECTION_DATE')) {
                if (!$collection_date = RojaFortyFiveProductRentalCore::getCustomerRequirement(
                    'ROJA45_PRODUCTRENTAL_COLLECTION_DATE'
                )) {
                    $validationErrors[] = $this->module->l('Collection date missing');
                }
                $collection_date = DateTime::createFromFormat(
                    'Y-m-d',
                    $collection_date
                );
                if ($collection_date) {
                    $collection_date = $collection_date->format($this->context->language->date_format_lite);
                }
            }

            if (!$return_date = Tools::getValue('ROJA45_PRODUCTRENTAL_RETURN_DATE')) {
                if (!$return_date = RojaFortyFiveProductRentalCore::getCustomerRequirement(
                    'ROJA45_PRODUCTRENTAL_RETURN_DATE'
                )) {
                    $validationErrors[] = $this->module->l('Return date missing');
                }
                $return_date = DateTime::createFromFormat(
                    'Y-m-d',
                    $return_date
                );
                if ($return_date) {
                    $return_date = $return_date->format($this->context->language->date_format_lite);
                }
            }

            if (!$rental_request = Tools::getValue('ROJA45_PRODUCTRENTAL_REQUEST')) {
                $get_availability_url = $this->context->link->getModuleLink(
                    'roja45productrental',
                    'ProductRentalFront',
                    array(
                        'getAvailability' => 1
                    )
                );
                Tools::redirect($get_availability_url);
            }

            if (!$collection_time = Tools::getValue('ROJA45_PRODUCTRENTAL_COLLECTION_TIME')) {
                if (!$collection_time = RojaFortyFiveProductRentalCore::getCustomerRequirement(
                    'ROJA45_PRODUCTRENTAL_COLLECTION_TIME'
                )) {
                    $collection_time = Configuration::get('ROJA45_PRODUCTRENTAL_COLLECTIONTIME');
                }
            }
            if (!$return_time = Tools::getValue('ROJA45_PRODUCTRENTAL_RETURN_TIME')) {
                if (!$return_time = RojaFortyFiveProductRentalCore::getCustomerRequirement(
                    'ROJA45_PRODUCTRENTAL_RETURN_TIME'
                )) {
                    $return_time = Configuration::get('ROJA45_PRODUCTRENTAL_COLLECTIONTIME');
                }
            }

            if (count($validationErrors)) {
                throw new Exception('Validation errors');
            }
            $requirements = array();
            $requirements['ROJA45_PRODUCTRENTAL_ID'] = $id_roja45_product;
            $collection_date_obj = DateTime::createFromFormat(
                $this->context->language->date_format_lite,
                $collection_date
            );
            $requirements['ROJA45_PRODUCTRENTAL_COLLECTION_DATE'] = $collection_date_obj->format(
                'Y-m-d'
            );

            $requirements['ROJA45_PRODUCTRENTAL_COLLECTION_TIME'] = $collection_time;

            $return_date_obj = DateTime::createFromFormat(
                $this->context->language->date_format_lite,
                $return_date
            );
            $requirements['ROJA45_PRODUCTRENTAL_RETURN_DATE'] = $return_date_obj->format(
                'Y-m-d'
            );
            $requirements['ROJA45_PRODUCTRENTAL_COLLECTION_TIME'] = $collection_time;
            $requirements['ROJA45_PRODUCTRENTAL_RETURN_TIME'] = $return_time;
            //$requirements['ROJA45_PRODUCTRENTAL_REQUEST'] = $rental_request;
            RojaFortyFiveProductRentalCore::saveCustomerRequirements($requirements);

            $order_process = Configuration::get('PS_ORDER_PROCESS_TYPE');
            if (!$order_process &&
                !Context::getContext()->customer->isLogged() &&
                (int) Configuration::get('ROJA45_PRODUCTRENTAL_REQUIRECUSTOMERACCOUNT')) {
                $params = array();
                $params['fc'] = 'module';
                $params['account_required'] = 1;
                $params['getAvailability'] = 0;
                $params['submitRental'] = 1;
                $back = urlencode($this->context->link->getModuleLink(
                    'roja45productrental',
                    'ProductRentalFront',
                    $params
                ));
                if (version_compare(_PS_VERSION_, '1.7', '<') == true) {
                    Tools::redirect('index.php?controller=authentication&back='.$back);
                } else {
                    $login_form = $this->makeLoginForm()->fillWith(
                        Tools::getAllValues()
                    );
                    $login_values = $login_form->getTemplateVariables();
                    $login_values['formFields']['back']['value'] = $back;
                    $this->context->smarty->assign($login_values);

                    $create_account_url = $this->context->link->getPageLink(
                        'authentication',
                        true,
                        null,
                        array(
                            'create_account' => '1',
                            'back' => $back
                        )
                    );

                    $login_url = $this->context->link->getPageLink(
                        'authentication',
                        true,
                        null,
                        array(
                            'back' => $back,
                            'submitLogin' => 1
                        )
                    );

                    $this->context->smarty->assign(array(
                        'create_account_url' => $create_account_url,
                        'login_url' => $login_url
                    ));
                    $this->setTemplate(
                        'module:'.$this->module->name.'/views/templates/front/PS17_customerlogin.tpl'
                    );
                    return;
                }
            }

            if (!$this->context->cart->id) {
                if (!Context::getContext()->customer->isLogged() && Context::getContext()->cookie->id_guest) {
                    $guest = new Guest(Context::getContext()->cookie->id_guest);
                    $this->context->cart->mobile_theme = $guest->mobile_theme;
                }
                $this->context->cart->add();
                if ($this->context->cart->id) {
                    $this->context->cookie->id_cart = (int)$this->context->cart->id;
                    $this->context->cookie->write();
                }
            } else {
            }

            //$id_roja45_product_rateduration = Tools::getValue('ROJA45_PRODUCTRENTAL_RATE_DURATION');
            $rental_details = new ProductRentalDetails($id_roja45_product);
            if (!Validate::isLoadedObject($rental_details)) {
                throw new Exception($this->module->l('The rental product cannot be loaded.'));
            }

            $collection_date_obj = DateTime::createFromFormat(
                $this->context->language->date_format_lite . ' H:i:s',
                $collection_date . ' ' . $collection_time .':00'
            );
            $collection_date_db = $collection_date_obj->format('Y-m-d');
            $return_date_obj = DateTime::createFromFormat(
                $this->context->language->date_format_lite . ' H:i:s',
                $return_date . ' ' . $return_time .':00'
            );
            $return_date_db = $return_date_obj->format('Y-m-d');

            $id_roja45_product_rental = RojaFortyFiveProductRentalCore::getCustomerRequirement(
                'ROJA45_PRODUCTRENTAL_ID_RENTAL'
            );
            if (ProductRentalRental::ordered($id_roja45_product_rental)) {
                $id_roja45_product_rental = 0;
            }
            if ($id_roja45_product_rental && (int) Configuration::get('ROJA45_PRODUCTRENTAL_SINGLEITEMRENTALS')) {
                $rental = new ProductRentalRental($id_roja45_product_rental);
                $rental->deleteProducts();
                foreach ($this->context->cart->getProducts() as $product) {
                    $this->context->cart->deleteProduct($product['id_product'], $product['id_product_attribute']);
                }
            } else if ($rental_product = ProductRentalRentalProduct::exists(
                $id_roja45_product_rental,
                $rental_details->id_product
            )) {
                $rental_product = new ProductRentalRentalProduct();
                $rental_product->deleteChildren();
            }

            $rental_object = Tools::jsonDecode($rental_request);
            $rental_object = ProductRentalRental::validateRental($rental_object);

            if (!count((array)$rental_object->products)) {
                $this->redirectAvailability(array('The rental request does not contain any products'));
            }

            try {
                $rental = ProductRentalRental::createRental(
                    $id_roja45_product_rental,
                    $id_roja45_product,
                    $this->context->customer->id,
                    $collection_date_db,
                    $collection_date_obj->format('H:i:s'),
                    $return_date_db,
                    $return_date_obj->format('H:i:s'),
                    $rental_object,
                    date('YmdHis').'-'.uniqid().'@'.$_SERVER['SERVER_NAME'],
                    ProductRentalRentalStatus::$RCVD,
                    $this->context->language->id,
                    $this->context->currency->id,
                    $this->context->shop->id
                );
                RojaFortyFiveProductRentalCore::saveCustomerRequirement(
                    'ROJA45_PRODUCTRENTAL_ID_RENTAL',
                    $rental->id
                );

                $rental_object = Tools::jsonDecode($rental->toJSON($this->context->language->id));
                $rental_object = ProductRentalRental::validateRental($rental_object);
                $requires_confirmation = false;
                foreach ($rental->getProducts() as $rental_product) {
                    $rental_product = new ProductRentalDetails($rental_product['id_roja45_product']);
                    if (!$rental_product->instant_rental) {
                        $requires_confirmation = true;
                    }
                }
                $this->context->smarty->assign(array(
                    'back_link' => $this->context->link->getModuleLink(
                        'roja45productrental',
                        'ProductRentalFront',
                        array(
                            'getAvailability' => 1
                        )
                    ),
                    'rental' => $rental,
                    'rental_value' => $rental_object->total_rental_to_pay_exc,
                ));

                $this->context->smarty->assign($rental->getSummary());
                if (version_compare(_PS_VERSION_, '1.7', '>=') == true) {
                    $delete_link = $this->context->link->getModuleLink(
                        'roja45productrental',
                        'ProductRentalFront',
                        array(
                            'ajax' => 1,
                            'action' => 'deleteProduct',
                        )
                    );
                } else {
                    $delete_link = $this->context->link->getModuleLink(
                        'roja45productrental',
                        'ProductRentalFront',
                        array(
                            'ajax' => 1,
                            'action' => 'deleteProduct',
                        )
                    );
                }

                $display_tax = !(Group::getPriceDisplayMethod(Group::getCurrent()->id));
                $this->context->smarty->assign(
                    array(
                        'display_tax' => $display_tax,
                        'id_roja45_product_rental' => $rental->id_roja45_product_rental,
                        'delete_product_link' => $delete_link,
                        'link' => Context::getContext()->link,
                        'cartImage' => ImageType::getFormatedName('cart'),
                        'mediumImage' => ImageType::getFormatedName('medium'),
                        'cartSize' => Image::getSize(ImageType::getFormatedName('cart')),
                        'mediumSize' => Image::getSize(ImageType::getFormatedName('medium')),
                        'enable_cod' => (int) Configuration::get('ROJA45_PRODUCTRENTAL_ENABLECUSTOMERSELECTCOD'),
                        'cod_enabled' => $rental->cod,
                        'rental_details' => $rental_object,
                    )
                );

                if ((int) Configuration::get('ROJA45_PRODUCTRENTAL_SINGLEITEMRENTALS') || (int) Configuration::get('ROJA45_PRODUCTRENTAL_SHOWCARTSUMMARY')) {
                    if ($this->populateCart($rental)) {
                        $rental->setStatus(ProductRentalRentalStatus::$CHKT);
                        if ($controller = Tools::getValue('ROJA45_PRODUCTRENTAL_ORDERCONTROLLER')) {
                            Tools::redirect($controller);
                        } else {
                            if ((int) Configuration::get('ROJA45_PRODUCTRENTAL_SHOWCARTSUMMARY')) {
                                if (version_compare(_PS_VERSION_, '1.7', '>=') == true) {
                                    $url = $this->context->link->getPageLink(
                                        'cart',
                                        true,
                                        $this->context->language->id,
                                        array(
                                            'action' => 'show'
                                        )
                                    );
                                } else {
                                    $url = $this->context->link->getPageLink('order', null);
                                }
                                Tools::redirect($url);
                            } else {
                                Tools::redirect('index.php?controller=order');
                            }
                        }
                    } else {
                        throw new Exception($this->module->l('Unable to add rental to cart.'));
                    }
                } else {
                    // TODO - if cart has standard products then force standard checkout.
                    if ((int) Configuration::get('ROJA45_PRODUCTRENTAL_ALWAYSUSECART') ||
                        ((int) Configuration::get('ROJA45_PRODUCTRENTAL_ENABLESALES')) ||
                        ($rental_object->total_rental_to_pay_exc && !$requires_confirmation)) {
                        $this->context->smarty->assign(array(
                            'payment_required' => 1
                        ));
                        RojaFortyFiveProductRentalCore::setFrontControllerTemplate($this, 'rental_summary.tpl');
                    } else {
                        $this->context->smarty->assign(array(
                            'payment_required' => 0
                        ));
                        RojaFortyFiveProductRentalCore::setFrontControllerTemplate($this, 'rental_summary.tpl');
                    }
                }
            } catch (Exception $e) {
                switch ($e->getCode()) {
                    case 1:
                        throw new Exception($this->module->l(
                            'Sorry, your chosen dates were just reserved, please choose again.'
                        ));
                    default:
                        throw new Exception($e->getMessage());
                }
            }
        } catch (Exception $e) {
            $validationErrors[] = $e->getMessage();
            $validationErrors[] = $e->getFile() . ' (' . $e->getLine() . ')';
            $this->errors = $validationErrors;
            RojaFortyFiveProductRentalCore::setFrontControllerTemplate($this, 'error-page.tpl');
        }
    }

    public function processSubmitPayment()
    {
        $validationErrors = array();
        try {
            if (!is_numeric($id_roja45_product_rental = Tools::getValue('ROJA45_PRODUCTRENTAL_RENTAL_ID'))) {
                if (!is_numeric($id_roja45_product_rental = $this->module->getCustomerRequirement(
                    'ROJA45_PRODUCTRENTAL_RENTAL_ID'
                ))) {
                    $validationErrors[] = $this->module->l('Rental ID missing');
                }
            }

            if (!count($validationErrors)) {
                $rental = new ProductRentalRental($id_roja45_product_rental);
                if (!Validate::isLoadedObject($rental)) {
                    throw new Exception($this->module->l('The rental could not be loaded.'));
                }
                if ($this->populateCart($rental)) {
                    $rental->setStatus(ProductRentalRentalStatus::$CHKT);
                    if ((int) Configuration::get('ROJA45_PRODUCTRENTAL_SHOWCARTSUMMARY')) {
                        if (version_compare(_PS_VERSION_, '1.7', '>=') == true) {
                            $url = $this->context->link->getPageLink(
                                'cart',
                                true,
                                $this->context->language->id,
                                array(
                                    'action' => 'show'
                                )
                            );
                        } else {
                            $url = $this->context->link->getPageLink('order', null);
                        }
                    } else {
                        if ($controller = Tools::getValue('ROJA45_PRODUCTRENTAL_ORDERCONTROLLER')) {
                            Tools::redirect($controller);
                        } else {
                            if ((int) Configuration::get('ROJA45_PRODUCTRENTAL_SHOWCARTSUMMARY')) {
                                if (version_compare(_PS_VERSION_, '1.7', '>=') == true) {
                                    $url = $this->context->link->getPageLink(
                                        'cart',
                                        true,
                                        $this->context->language->id,
                                        array(
                                            'action' => 'show'
                                        )
                                    );
                                } else {
                                    $url = $this->context->link->getPageLink('order', null);
                                }
                                Tools::redirect($url);
                            } else {
                                Tools::redirect('index.php?controller=order');
                            }
                        }
                    }
                    Tools::redirect($url);
                } else {
                    throw new Exception($this->module->l('Unable to add rental to cart.'));
                }
            } else {
                throw new Exception($this->module->l('Validation errors'));
            }
        } catch (Exception $e) {
            $validationErrors[] = $this->module->displayName . ' : ' . __FUNCTION__ . ' : ' . $e->getMessage();
            $this->errors = $validationErrors;
            RojaFortyFiveProductRentalCore::setFrontControllerTemplate($this, 'error-page.tpl');
        }
    }

    public function processSubmitRequestCancellation()
    {
        $validationErrors = array();
        try {
            if (!is_numeric($id_roja45_product_rental = Tools::getValue('id_roja45_product_rental'))) {
                $validationErrors[] = $this->module->l('Rental ID missing');
            }

            if (!count($validationErrors)) {
                $rental = new ProductRentalRental($id_roja45_product_rental);
                if (!Validate::isLoadedObject($rental)) {
                    throw new Exception($this->module->l('The rental could not be loaded.'));
                }
                $rental->setStatus(ProductRentalRentalStatus::$CCLR);
                Tools::redirect($this->context->link->getModuleLink(
                    'roja45productrental',
                    'ProductRentalFront',
                    array(
                        'customer_rentals' => 1
                    )
                ));
            } else {
                throw new Exception($this->module->l('Validation errors'));
            }
        } catch (Exception $e) {
            $validationErrors[] = $this->module->displayName . ' : ' . __FUNCTION__ . ' : ' . $e->getMessage();
            $this->errors = $validationErrors;
            RojaFortyFiveProductRentalCore::setFrontControllerTemplate($this, 'error-page.tpl');
        }
    }
    public function processSubmitCustomerConfirmation()
    {
        $validationErrors = array();
        try {
            if (!$id_roja45_product_rental = Tools::getValue('ROJA45_PRODUCTRENTAL_RENTAL_ID')) {
                $validationErrors[] = $this->module->l('Rental ID missing');
            }

            if (!count($validationErrors)) {
                $product_rental = new ProductRentalRental($id_roja45_product_rental);
                if (Validate::isLoadedObject($product_rental)) {
                    $product_rental->id_customer = (int) $this->context->customer->id;
                    $product_rental->setStatus(ProductRentalRentalStatus::$CCNF);

                    // TODO - Check whether cart contains non-rental products.
                    // if yes, force cart checkout.

                    // TODO - Check whether rental contains products that need confirmation.

                    $requires_confirmation = false;
                    foreach ($product_rental->getProducts() as $rental_product) {
                        $rental_product = new ProductRentalRentalProduct(
                            $rental_product['id_roja45_product_rental_product']
                        );
                        //SpecificPrice::deleteByProductId($rental_product->id_product);
                        RojaFortyFiveProductRentalCore::deleteCustomerCartProductSpecificPrice(
                            (int)$this->context->customer->id,
                            (int)$this->context->cart->id,
                            $rental_product->id_product,
                            null
                        );
                        $this->context->cart->deleteProduct($rental_product->id_product, 0);
                        $rental_product = new ProductRentalDetails($rental_product->id_roja45_product);
                        if (!$rental_product->instant_rental) {
                            $requires_confirmation = true;
                        }
                    }

                    if ($requires_confirmation) {
                        $product_rental->setStatus(ProductRentalRentalStatus::$PRES);
                    } elseif (Configuration::get('ROJA45_PRODUCTRENTAL_AUTOCONFIRM')) {
                        $product_rental->setStatus(ProductRentalRentalStatus::$CONF);
                    }

                    $display_tax = !(Group::getPriceDisplayMethod(Group::getCurrent()->id));
                    $this->context->smarty->assign($product_rental->getSummary());
                    $this->context->smarty->assign(array(
                        'display_tax' => $display_tax,
                        'id_roja45_product_rental' => $id_roja45_product_rental,
                        'logout_url' => $this->context->link->getPageLink('index', true, null),
                    ));

                    RojaFortyFiveProductRentalCore::setFrontControllerTemplate($this, 'rental_created.tpl');
                    RojaFortyFiveProductRentalCore::clearAllCustomerRequirements('ROJA45_PRODUCTRENTAL_');
                }
            } else {
                throw new Exception($this->module->l('Validation errors'));
            }
        } catch (Exception $e) {
            $validationErrors[] = $e->getMessage();
            $this->errors = $validationErrors;
            RojaFortyFiveProductRentalCore::setFrontControllerTemplate($this, 'error-page.tpl');
        }
    }

    public function processSubmitGetCustomerRentals()
    {
        if (!Context::getContext()->customer->isLogged()) {
            $back = $this->context->link->getModuleLink(
                'roja45productrental',
                'ProductRentalFront',
                array(
                    'customer_rentals' => 1,
                ),
                true
            );
            Tools::redirect('index.php?controller=authentication&back='.$back);
        }
        try {
            $validationErrors = array();
            if (!count($validationErrors)) {
                $customer_id = $this->context->customer->id;
                $rentals = ProductRentalRental::getRentalsForCustomer($customer_id);
                foreach ($rentals as $key => &$rental) {
                    $rentalObj = new ProductRentalRental($rental['id_roja45_product_rental']);
                    if (!Validate::isLoadedObject($rentalObj)) {
                        throw new Exception($this->module->l('The rental object cannot be loaded.'));
                    }

                    if ($rentalObj->isComplete()) {
                        unset($rentals[$key]);
                    } else {
                        $rental_products = $rentalObj->getProducts();
                        foreach ($rental_products as &$rental_product) {
                            $models = ProductRentalRentalModel::getModels(
                                $rental_product['id_roja45_product_rental_product']
                            );
                            $product = new Product(
                                $rental_product['id_product'],
                                false,
                                (int)$this->context->language->id
                            );
                            foreach ($models as &$model) {
                                $model['name'] = ProductRentalModel::getModelNameStatic(
                                    $model['id_roja45_product_model'],
                                    $this->context->language->id
                                );
                                $image = array();
                                $id_image = Product::getCover($rental_product['id_product'])['id_image'];
                                if ($model['id_product_attribute']) {
                                    $combination_image = $product->getCombinationImageById(
                                        $model['id_product_attribute'],
                                        (int)$this->context->language->id
                                    );
                                    if ($combination_image) {
                                        $id_image = $combination_image['id_image'];
                                    }
                                }
                                $imageObj = new Image($id_image, (int)$this->context->language->id);

                                $images = array();
                                foreach (ImageType::getImagesTypes() as $image_type) {
                                    $image_size = Image::getSize($image_type['name']);
                                    $image['title'] = $imageObj->legend;
                                    $image['width'] = $image_size['width'];
                                    $image['height'] = $image_size['height'];
                                    $image['src'] = $this->context->link->getImageLink(
                                        $product->link_rewrite,
                                        $id_image,
                                        $image_type['name']
                                    );
                                    $images[$image_type['name']] = $image;
                                }

                                if (version_compare(_PS_VERSION_, '1.7', '>=') == true) {
                                    $model['image'] = $images[ImageType::getFormatedName('cart')];
                                } else {
                                    $model['image'] = $images[ImageType::getFormatedName('medium')];
                                }

                                $model['images'] = $images;
                                $model['total_formatted'] = Tools::displayPrice(
                                    Tools::convertPrice($model['total'])
                                );
                            }
                            //$product = new Product($rental_product['id_product'], false, $this->context->language->id);
                            $rental_product['models'] = $models;
                            $rental_product['name'] = $product->name;
                            //$rental_product['product'] = $product;
                        }
                        $rental['products'] = $rental_products;

                        $payments = ProductRentalRentalPayment::getPayments($rental['id_roja45_product_rental']);
                        $total_paid = 0.0;
                        $total_paid_real = 0.0;

                        $rental['payments_due'] = array();
                        foreach ($payments as &$payment) {
                            if (!empty($payment['id_order'])) {
                                $order = new Order($payment['id_order'], $this->context->language->id);
                                $total_paid += $payment['total_paid'];
                                $total_paid_real += $order->total_paid_real;
                                $payment['has_order'] = 1;
                                $payment['order'] = $order;
                            } else {
                                $payment['has_order'] = 0;
                            }

                            if ($payment['date_due'] == '0000-00-00 00:00:00') {
                                $payment['date_due'] = '';
                            }
                            if (empty($payment['date_paid']) || ($payment['date_paid'] == '0000-00-00 00:00:00')) {
                                $payment['date_paid'] = '';
                                $payment['paid'] = 0;
                            } else {
                                $payment['paid'] = 1;
                            }

                            $payment['total'] = $payment['total_with_tax'];
                            $payment['total_formatted'] = Tools::displayPrice(
                                Tools::convertPrice($payment['total_with_tax'])
                            );
                            $payment['total_paid_formatted'] = Tools::displayPrice(
                                Tools::convertPrice($payment['total_paid'])
                            );
                            $payment['total_paid_real_formatted'] = Tools::displayPrice(
                                Tools::convertPrice($payment['total_paid_real'])
                            );
                            if (!$payment['paid'] && $payment['requested'] == 1) {
                                $rental['payments_due'][] = $payment;
                            }
                        }

                        $status = new ProductRentalRentalStatus(
                            $rentalObj->id_roja45_product_rental_status,
                            $this->context->language->id
                        );
                        $rental['rental'] = $rentalObj;
                        $rental['confirmed'] = $rentalObj->isConfirmed();
                        $rental['payments'] = $payments;
                        $rental['status'] = $status->status;
                        $rental['status_code'] = $status->code;
                        $rental['status_color'] = $status->color;
                        $rental['totals'] = $rentalObj->getSummary();
                        $rental['total_paid_real'] = $total_paid_real;
                        $rental['total_paid_real_formatted'] = Tools::displayPrice(
                            Tools::convertPrice($payment['total_paid_real'])
                        );
                        $download_pdf = false;
                        if (ProductRentalRentalProcess::exists($rentalObj->id, ProductRentalRentalStatus::$CCNF) ||
                            ProductRentalRentalProcess::exists($rentalObj->id, ProductRentalRentalStatus::$CONF)) {
                            $download_pdf = true;
                        }
                        $rental['download_pdf'] = $download_pdf;
                    }
                }

                $display_tax = !(Group::getPriceDisplayMethod(Group::getCurrent()->id));
                $this->context->smarty->assign(array(
                    'display_tax' => $display_tax,
                    'rentals' => $rentals,
                    'controller' => $this->context->link->getModuleLink(
                        'roja45productrental',
                        'ProductRentalFront',
                        array()
                    ),
                    'home_url' => $this->context->link->getPageLink('index'),
                    'my_account_url' => $this->context->link->getPageLink('my-account', true),
                ));
                RojaFortyFiveProductRentalCore::setFrontControllerTemplate($this, 'customer-rentals.tpl');
            } else {
                $this->errors = $validationErrors;
            }
        } catch (Exception $e) {
            $this->errors = array(
                $this->module->l('An unexpected error has occurred: ' . $e->getMessage())
            );
            if (version_compare(_PS_VERSION_, '1.7', '>=') == true) {
                $this->context->smarty->assign(array(
                    'logout_url' => $this->context->link->getPageLink('index', true, null, 'mylogout')
                ));
                $this->setTemplate('customer/my-account');
            } else {
                $this->setTemplate(_PS_THEME_DIR_.'my-account.tpl');
            }
        }
    }

    public function processSubmitGetCustomerRentalHistory()
    {
        if (!Context::getContext()->customer->isLogged()) {
            $back = $this->context->link->getModuleLink(
                'roja45productrental',
                'ProductRentalFront',
                array(
                    'customer_rentals' => 1,
                ),
                true
            );
            Tools::redirect('index.php?controller=authentication&back='.$back);
        }
        try {
            $validationErrors = array();
            if (!count($validationErrors)) {
                $customer_id = $this->context->customer->id;
                $rentals = ProductRentalRental::getRentalsForCustomer($customer_id);
                foreach ($rentals as $key => &$rental) {
                    $rentalObj = new ProductRentalRental($rental['id_roja45_product_rental']);
                    if (!Validate::isLoadedObject($rentalObj)) {
                        throw new Exception($this->module->l('The rental object cannot be loaded.'));
                    }
                    if (!$rentalObj->isComplete()) {
                        unset($rentals[$key]);
                    } else {
                        $rental_products = $rentalObj->getProducts();
                        foreach ($rental_products as &$rental_product) {
                            $models = ProductRentalRentalModel::getModels(
                                $rental_product['id_roja45_product_rental_product']
                            );
                            foreach ($models as &$model) {
                                $model['name'] = ProductRentalModel::getModelNameStatic(
                                    $model['id_roja45_product_model'],
                                    $this->context->language->id
                                );
                            }
                            $product = new Product($rental_product['id_product'], false, $this->context->language->id);
                            $rental_product['models'] = $models;
                            $rental_product['product'] = $product;
                        }
                        $rental['products'] = $rental_products;

                        $payments = ProductRentalRentalPayment::getPayments($rental['id_roja45_product_rental']);
                        $total_paid = 0.0;
                        $total_paid_real = 0.0;

                        $rental['payment_due'] = 0;
                        foreach ($payments as &$payment) {
                            if (!empty($payment['id_order'])) {
                                $order = new Order($payment['id_order'], $this->context->language->id);
                                $total_paid += $payment['total_paid'];
                                $total_paid_real += $order->total_paid_real;
                                $payment['has_order'] = 1;
                                $payment['order'] = $order;
                            } else {
                                $payment['has_order'] = 0;
                            }

                            if ($payment['date_due'] == '0000-00-00 00:00:00') {
                                $payment['date_due'] = '';
                            }
                            if ($payment['date_paid'] == '0000-00-00 00:00:00') {
                                $payment['date_paid'] = '';
                                $payment['paid'] = 0;
                            } else {
                                $payment['paid'] = 1;
                            }

                            if (empty($payment['date_paid']) && $payment['requested'] == 1) {
                                $rental['payment_due'] = 1;
                            }
                            $payment['total'] = $payment['total_with_tax'];
                            $payment['total_formatted'] = Tools::displayPrice(
                                Tools::convertPrice($payment['total_with_tax'])
                            );
                            $payment['total_paid_formatted'] = Tools::displayPrice(
                                Tools::convertPrice($payment['total_paid'])
                            );
                            $payment['total_paid_real_formatted'] = Tools::displayPrice(
                                Tools::convertPrice($payment['total_paid_real'])
                            );
                        }

                        $status = new ProductRentalRentalStatus(
                            $rentalObj->id_roja45_product_rental_status,
                            $this->context->language->id
                        );
                        $rental['rental'] = $rentalObj;
                        $rental['confirmed'] = $rentalObj->isConfirmed();
                        $rental['payments'] = $payments;
                        $rental['status'] = $status->status;
                        $rental['totals'] = $rentalObj->getSummary();
                        $rental['total_paid_real'] = $total_paid_real;
                        $rental['total_paid_real_formatted'] = Tools::displayPrice(
                            Tools::convertPrice($payment['total_paid_real'])
                        );
                    }
                }
                $display_tax = !(Group::getPriceDisplayMethod(Group::getCurrent()->id));
                $this->context->smarty->assign(array(
                    'display_tax' => $display_tax,
                    'rentals' => $rentals,
                    'controller' => $this->context->link->getModuleLink(
                        'roja45productrental',
                        'ProductRentalFront',
                        array()
                    ),
                    'home_url' => $this->context->link->getPageLink('index'),
                    'my_account_url' => $this->context->link->getPageLink('my-account', true),
                ));
                RojaFortyFiveProductRentalCore::setFrontControllerTemplate($this, 'customer-rental-history.tpl');
            } else {
                $this->errors = $validationErrors;
            }
        } catch (Exception $e) {
            $this->errors = array(
                $this->module->l('An unexpected error has occurred: ' . $e->getMessage())
            );
            if (version_compare(_PS_VERSION_, '1.7', '>=') == true) {
                $this->context->smarty->assign(array(
                    'logout_url' => $this->context->link->getPageLink('index', true, null, 'mylogout')
                ));
                $this->setTemplate('customer/my-account');
            } else {
                $this->setTemplate(_PS_THEME_DIR_.'my-account.tpl');
            }
        }
    }

    public function processSubmitViewCustomerRental()
    {
        if (!Context::getContext()->customer->isLogged()) {
            $back = $this->context->link->getModuleLink(
                'roja45productrental',
                'ProductRentalFront',
                array(
                    'view_customer_rental' => 1,
                ),
                true
            );
            Tools::redirect('index.php?controller=authentication&back='.$back);
        }
        try {
            $validationErrors = array();
            if (!count($validationErrors)) {
                //$customer_id = $this->context->customer->id;
                $rental = new ProductRentalRental(Tools::getValue('id_roja45_product_rental'));
                if (!Validate::isLoadedObject($rental)) {
                    throw new Exception($this->module->l('The reservation cannot be found.'));
                }
                $display_tax = !(Group::getPriceDisplayMethod(Group::getCurrent()->id));
                $this->context->smarty->assign($rental->getSummary());
                $this->context->smarty->assign(
                    array(
                        'rental' => $rental,
                        'display_tax' => $display_tax,
                        'id_roja45_product_rental' => $rental->id_roja45_product_rental,
                        'link' => Context::getContext()->link,
                        'cartImage' => ImageType::getFormatedName('cart'),
                        'mediumImage' => ImageType::getFormatedName('medium'),
                        'cartSize' => Image::getSize(ImageType::getFormatedName('cart')),
                        'mediumSize' => Image::getSize(ImageType::getFormatedName('medium')),
                        'home_url' => $this->context->link->getPageLink('index'),
                        'my_rentals_url' => $this->context->link->getPageLink('my-account', true),
                    )
                );
                RojaFortyFiveProductRentalCore::setFrontControllerTemplate($this, 'view-customer-rental.tpl');
            } else {
                $this->errors = $validationErrors;
            }
        } catch (Exception $e) {
            $this->errors = array(
                $this->module->l('An unexpected error has occurred: ' . $e->getMessage())
            );
        }
    }

    public function processSubmitViewRentalPayments()
    {
        if (!Context::getContext()->customer->isLogged()) {
            $back = $this->context->link->getModuleLink(
                'roja45productrental',
                'ProductRentalFront',
                array(
                    'view_rental_payments' => 1,
                ),
                true
            );
            Tools::redirect('index.php?controller=authentication&back='.$back);
        }
        try {
            $validationErrors = array();
            if (!count($validationErrors)) {
                $rental = new ProductRentalRental(Tools::getValue('id_roja45_product_rental'));
                if (!Validate::isLoadedObject($rental)) {
                    throw new Exception($this->module->l('The reservation cannot be found.'));
                }
                $payments = ProductRentalRentalPayment::getPayments($rental->id_roja45_product_rental);
                $total_paid = 0.0;
                $total_paid_real = 0.0;
                foreach ($payments as &$payment) {
                    if (!empty($payment['id_order'])) {
                        $order = new Order($payment['id_order'], $this->context->language->id);
                        $total_paid += $payment['total_paid'];
                        $total_paid_real += $order->total_paid_real;
                        $payment['has_order'] = 1;
                        $payment['order'] = $order;
                    } else {
                        $payment['has_order'] = 0;
                    }

                    if ($payment['date_due'] == '0000-00-00 00:00:00') {
                        $payment['date_due'] = '';
                    } else {
                        $date = new DateTime($payment['date_due']);
                        $payment['date_due'] =$date->format('Y-m-d');
                    }
                    if ((!Tools::strlen($payment['date_paid']) || $payment['date_paid'] == '0000-00-00 00:00:00')) {
                        $payment['date_paid'] = '';
                        $payment['paid'] = 0;
                    } else {
                        $date = new DateTime($payment['date_paid']);
                        $payment['date_paid'] = $date->format('Y-m-d');
                        $payment['paid'] = 1;
                    }
                    //$payment['total'] = $payment['total_with_tax'];
                    $payment['total_formatted'] = Tools::displayPrice(Tools::convertPrice($payment['total']));
                    $payment['total_with_tax_formatted'] = Tools::displayPrice(
                        Tools::convertPrice($payment['total_with_tax'])
                    );
                    $payment['total_paid_formatted'] = Tools::displayPrice(Tools::convertPrice($payment['total_paid']));
                    $payment['total_paid_real_formatted'] = Tools::displayPrice(
                        Tools::convertPrice($payment['total_paid_real'])
                    );
                }

                $this->context->smarty->assign(
                    array(
                        'id_roja45_product_rental' => $rental->id_roja45_product_rental,
                        'payments' => $payments,
                        'home_url' => $this->context->link->getPageLink('index'),
                        'my_rentals_url' => $this->context->link->getModuleLink(
                            'roja45productrental',
                            'ProductRentalFront',
                            array(
                                'customer_rentals' => 1
                            )
                        ),
                    )
                );
                RojaFortyFiveProductRentalCore::setFrontControllerTemplate($this, 'view-rental-payments.tpl');
            } else {
                $this->errors = $validationErrors;
            }
        } catch (Exception $e) {
            $this->errors = array(
                $this->module->l('An unexpected error has occurred: ' . $e->getMessage())
            );
            RojaFortyFiveProductRentalCore::setFrontControllerTemplate($this, 'customer-rentals.tpl');
        }
    }

    public function processSubmitAddToCart()
    {
        if (!Context::getContext()->customer->isLogged()) {
            $back = $this->context->link->getModuleLink(
                'roja45productrental',
                'ProductRentalFront',
                array(
                    'pay_customer_rental' => 1,
                ),
                true
            );
            Tools::redirect('index.php?controller=authentication&back='.$back);
        }
        try {
            $validationErrors = array();
            if (!$id_roja45_product_rental = Tools::getValue('id_roja45_product_rental')) {
                $validationErrors[] = $this->module->l('Rental ID missing');
            }
            if (!$id_roja45_product_rental_payment = Tools::getValue('id_roja45_product_rental_payment')) {
                $validationErrors[] = $this->module->l('Rental payment Id missing');
            }

            if (!count($validationErrors)) {
                $product_rental = new ProductRentalRental($id_roja45_product_rental);
                if (!Validate::isLoadedObject($product_rental)) {
                    throw new Exception($this->module->l('The reservation could not be loaded.'));
                }
                if ($product_rental->populateCart($id_roja45_product_rental_payment)) {
                    RojaFortyFiveProductRentalCore::saveCustomerRequirement(
                        'ROJA45_PRODUCTRENTAL_ID_RENTAL',
                        $id_roja45_product_rental
                    );
                    RojaFortyFiveProductRentalCore::saveCustomerRequirement(
                        'ROJA45_PRODUCTRENTAL_ID_RENTAL_PAYMENT',
                        $id_roja45_product_rental_payment
                    );

                    if ((int) Configuration::get('ROJA45_PRODUCTRENTAL_SHOWCARTSUMMARY')) {
                        if (version_compare(_PS_VERSION_, '1.7', '>=') == true) {
                            $url = $this->context->link->getPageLink(
                                'cart',
                                true,
                                $this->context->language->id,
                                array(
                                    'action' => 'show'
                                )
                            );
                        } else {
                            $url = $this->context->link->getPageLink('order', null);
                        }
                    } else {
                        if (!$controller = Tools::getValue('ROJA45_PRODUCTRENTAL_ORDERCONTROLLER')) {
                            $controller = 'order';
                        }
                        $url = $this->context->link->getPageLink(
                            $controller,
                            null,
                            $this->context->language->id,
                            array(
                                'step' => '1'
                            )
                        );
                    }
                    Tools::redirect($url);
                } else {
                    throw new Exception($this->module->l('Unable to populate customer cart.'));
                }
            } else {
                throw new Exception($this->module->l('Validation errors'));
            }
        } catch (Exception $e) {
            $this->errors[] = $this->module->l('An unexpected error has occurred.');
        }
    }

    public function processEnable()
    {
        RojaFortyFiveProductRentalCore::enableModule();
        die(0);
    }

    public function processDisable()
    {
        RojaFortyFiveProductRentalCore::disableModule();
        die(0);
    }

    public function ajaxProcessGetStates()
    {
        try {
            $states = State::getStatesByIdCountry(Tools::getValue('id_country'));
            die(Tools::jsonEncode(array(
                'result' => true,
                'states' => $states
            )));
        } catch (Exception $e) {
            $validationErrors = array();
            $validationErrors[] = $e->getMessage();
            $json = Tools::jsonEncode(array(
                'result' => false,
                'errors' => $validationErrors,
                'exception' => $e,
            ));
            die($json);
        }
    }

    public function processDownloadPDF()
    {
        if (!Context::getContext()->customer->isLogged()) {
            $back = $this->context->link->getModuleLink(
                'roja45productrental',
                'ProductRentalFront',
                array(
                    'get_rental_confirmation_pdf' => 1,
                ),
                true
            );
            Tools::redirect('index.php?controller=authentication&back='.$back);
        }
        $validationErrors = array();
        try {
            $rental = new ProductRentalRental(Tools::getValue('id_roja45_product_rental'));
            if (!Validate::isLoadedObject($rental)) {
                throw new Exception($this->module->l('Unable to load rental.'));
            }
            $rental->generateRentalConfirmationPDF(true, !Group::getPriceDisplayMethod(Group::getCurrent()->id));
            exit;
        } catch (Exception $e) {
            $validationErrors[] = $e->getMessage();
            $this->errors[] = Tools::displayError($e->getMessage());
            $this->processGetCustomerQuotes();
        }
    }

    public function displayAjaxSubmitCustomDeliveryCollectionAddress()
    {
        $validationErrors = array();

        if (!$id_roja45_product_rental = Tools::getValue('id_roja45_product_rental')) {
            $validationErrors[] = $this->module->l('No rental id provided');
        }
        if (!count($validationErrors)) {
            try {
                $rental = new ProductRentalRental($id_roja45_product_rental);
                if ($id_delivery_address = Tools::getValue('id_delivery_address')) {
                    $address = new Address($id_delivery_address);
                } else {
                    $id_address = Address::getFirstCustomerAddressId($rental->id_customer);
                    $address = new Address($id_address);
                    $address->id = null;
                }
                //$delivery_address = new Address();
                $address->alias = Tools::substr($this->module->l(sprintf('RENTAL #%s DELIVERY', $rental->reference)), 0, 32);
                $address->address1 = Tools::getValue('delivery_address1');
                $address->address2 = Tools::getValue('delivery_address2');
                $address->city = Tools::getValue('delivery_city');
                $address->postcode = Tools::getValue('delivery_postcode');
                $address->phone = $address->phone;
                if ($address->save()) {
                    $rental->id_delivery_address = $address->id;
                }

                if (!(int) Tools::getValue('use_same_address')) {
                    $id_collection_address = Tools::getValue('id_collection_address');
                    if ($id_collection_address && ($id_collection_address != $id_delivery_address)) {
                        $address = new Address($id_collection_address);
                    } else {
                        $address->id = null;
                    }
                    $address->alias = Tools::substr($this->module->l(sprintf('RENTAL #%s COLLECTION', $rental->reference)), 0, 32);
                    $address->address1 = Tools::getValue('collection_address1');
                    $address->address2 = Tools::getValue('collection_address1');
                    $address->city = Tools::getValue('collection_city');
                    $address->postcode = Tools::getValue('collection_postcode');
                    $address->phone = $address->phone;
                    if ($address->save()) {
                        $rental->id_collection_address = $address->id;
                    }
                } else {
                    $rental->id_collection_address = $rental->id_delivery_address;
                }
                if ($rental->save()) {
                    $json = Tools::jsonEncode(array(
                        'result' => 1,
                        'id_delivery_address' => $rental->id_delivery_address,
                        'id_collection_address' => $rental->id_collection_address,
                    ));
                    die($json);
                }
            } catch (Exception $e) {
                $validationErrors = array();
                $validationErrors[] = $e->getMessage();
                $json = Tools::jsonEncode(array(
                    'result' => false,
                    'errors' => $validationErrors,
                    'exception' => $e,
                ));
                die($json);
            }
        } else {
            $validationErrors[] = $this->module->l(
                'Unable to get product rentals.  Function validation errors',
                'AdminProductRentals'
            );
            die(Tools::jsonEncode(array(
                'result' => 'error',
                'errors' => $validationErrors,
            )));
        }
    }

    public function displayAjaxDeleteProduct()
    {
        try {
            $validationErrors = array();
            if (!$id_roja45_product_rental = Tools::getValue('id_roja45_product_rental')) {
                $validationErrors[] = $this->module->l('Product Rental Id missing');
            }
            if (!$id_product = Tools::getValue('id_product')) {
                $validationErrors[] = $this->module->l('Product Rental Product Id missing');
            }
            if (!is_numeric($id_product_attribute = Tools::getValue('id_product_attribute'))) {
                $validationErrors[] = $this->module->l('Product Rental Model Id missing');
            }

            if (!count($validationErrors)) {
                $this->module->deleteRentalEntry(
                    $id_roja45_product_rental,
                    $id_product,
                    $id_product_attribute,
                    true
                );
                $rental = new ProductRentalRental($id_roja45_product_rental);
                if (!Validate::isLoadedObject($rental)) {
                    die(Tools::jsonEncode(array(
                        'result' => 1,
                        'redirect' => $this->context->link->getPageLink('index')
                    )));
                }
                $products = $rental->getProducts();
                if (count($products)) {
                    $tpl = RojaFortyFiveProductRentalCore::getIncludedTemplate(
                        $this,
                        'rental-summary.tpl'
                    );
                    $tpl->assign(array(
                        'back_link' => $this->context->link->getModuleLink(
                            'roja45productrental',
                            'ProductRentalFront',
                            array(
                                'getAvailability' => 1
                            )
                        ),
                        'rental' => $rental,
                    ));

                    $tpl->assign($rental->getSummary());
                    if (version_compare(_PS_VERSION_, '1.7', '>=') == true) {
                        $delete_link = $this->context->link->getModuleLink(
                            'roja45productrental',
                            'ProductRentalFront',
                            array(
                                'ajax' => 1,
                                'action' => 'deleteProduct',
                            )
                        );
                    } else {
                        $delete_link = $this->context->link->getModuleLink(
                            'roja45productrental',
                            'ProductRentalFront',
                            array(
                                'ajax' => 1,
                                'action' => 'deleteProduct',
                            )
                        );
                    }
                    $tpl->assign(
                        array(
                            'id_roja45_product_rental' => $rental->id_roja45_product_rental,
                            'delete_product_link' => $delete_link,
                            'link' => Context::getContext()->link,
                            'cartImage' => ImageType::getFormatedName('cart'),
                            'mediumImage' => ImageType::getFormatedName('medium'),
                            'cartSize' => Image::getSize(ImageType::getFormatedName('cart')),
                            'mediumSize' => Image::getSize(ImageType::getFormatedName('medium')),
                        )
                    );

                    $rental_summary_html = $tpl->fetch();

                    $json = Tools::jsonEncode(array(
                        'html' => $rental_summary_html,
                        'result' => 1
                    ));
                } else {
                    $json = Tools::jsonEncode(array(
                        'result' => 1,
                        'redirect' => $this->context->link->getPageLink('index')
                    ));
                }
                die($json);
            } else {
                $json = Tools::jsonEncode(array(
                    'result' => 0,
                    'errors' => $validationErrors,
                ));
                die($json);
            }
        } catch (Exception $e) {
            $validationErrors = array();
            $validationErrors[] = $e->getMessage();
            $json = Tools::jsonEncode(array(
                'result' => false,
                'errors' => $validationErrors,
                'exception' => $e,
            ));
            die($json);
        }
    }

    public function displayAjaxSubmitAddToCart()
    {
        try {
            $validationErrors = array();
            if (!$id_roja45_rental = Tools::getValue('ROJA45_PRODUCTRENTAL_ID')) {
                $validationErrors[] = $this->module->l('Rental product ID missing');
            }

            if (!count($validationErrors)) {
                if (!$this->context->cart->id) {
                    if (!Context::getContext()->customer->isLogged() && Context::getContext()->cookie->id_guest) {
                        $guest = new Guest(Context::getContext()->cookie->id_guest);
                        $this->context->cart->mobile_theme = $guest->mobile_theme;
                    }
                    $this->context->cart->add();
                    if ($this->context->cart->id) {
                        $this->context->cookie->id_cart = (int) $this->context->cart->id;
                    }
                }

                $customer_rental = new ProductRentalRental($id_roja45_rental);
                if (!Validate::isLoadedObject($customer_rental)) {
                    throw new Exception($this->module->l('The rental  cannot be loaded.'));
                }

                $payment = ProductRentalRentalPayment::getDuePayment($id_roja45_rental);
                $payment->id_cart = (int) $this->context->cart->id;
                $payment->completed = 0;
                $payment->save();

                $customer_rental_products = $customer_rental->getProducts();
                foreach ($customer_rental_products as $customer_rental_product) {
                    $customer_rental_product = new ProductRentalRentalProduct(
                        $customer_rental_product['id_roja45_product_rental_product']
                    );
                    $dates = $customer_rental_product->getRentalDates();
                    $mysql_date_now = date('Y-m-d H:i:s');

                    $paymentprofile = ProductRentalPaymentProfile::getPaymentProfile(
                        $this->context->customer->getGroups(),
                        $dates['start_date'],
                        $this->context->language->id
                    );
                    if (!Validate::isLoadedObject($paymentprofile)) {
                        throw new Exception($this->module->l('The payment profile could not be loaded.'));
                    }
                    $customer_rental->last_update = $mysql_date_now;
                    $customer_rental->modified = 1;

                    if (!$customer_rental->save()) {
                        $validationErrors = array();
                        $validationErrors[] = $this->module->l('Unable to create rental, please try again later.');
                        throw new Exception($this->module->l('Unable to create rental, please try again later.'));
                    }

                    $this->cleanCart((int) $customer_rental_product->id_product, null);
                    //SpecificPrice::deleteByProductId((int) $customer_rental_product->id_product);
                    foreach (ProductRentalRentalModel::getModels($customer_rental_product->id_roja45_product_rental_product) as $model) {
                        if ($model) {
                            RojaFortyFiveProductRentalCore::deleteCustomerCartProductSpecificPrice(
                                (int)$this->context->customer->id,
                                (int)$this->context->cart->id,
                                $customer_rental_product->id_product,
                                $model['id_product_attribute']
                            );
                            $specific_price = new SpecificPrice();
                            $specific_price->id_shop = $this->context->shop->id;
                            $specific_price->id_shop_group = $this->context->shop->id_shop_group;
                            $specific_price->id_currency = 0;
                            $specific_price->id_country = 0;
                            $specific_price->id_group = 0;
                            $specific_price->id_cart = (int) $this->context->cart->id;
                            $specific_price->id_customer = (int)$this->context->customer->id;
                            $specific_price->id_product = $customer_rental_product->id_product;
                            $specific_price->id_product_attribute = $model['id_product_attribute'];
                            $specific_price->price =(float) ($model['total']*($paymentprofile->getNextDepositPercentage()/100)) / (int)$model['qty'];
                            $specific_price->from_quantity = 1;
                            $specific_price->reduction = 0;
                            $specific_price->reduction_type = 'amount';
                            $specific_price->reduction_tax = 0;
                            $specific_price->from = '0000-00-00 00:00:00';
                            $specific_price->to = '0000-00-00 00:00:00';
                            if ($specific_price->save()) {
                                $this->context->cart->updateQty(
                                    $model['qty'],
                                    $customer_rental_product->id_product,
                                    $model['id_product_attribute']
                                );
                            } else {
                                throw new Exception(
                                    $this->module->l(
                                        'Unable to create cart specific price:'
                                    ) . ' ['. Db::getInstance()->getMsgError() .']'
                                );
                            }
                        }
                    }
                }

                $customer_rental->setStatus(ProductRentalRentalStatus::$CHKT);
                Tools::redirect('index.php?controller=order');
            } else {
                $this->redirectAvailability($validationErrors);
            }
        } catch (Exception $e) {
            $validationErrors = array();
            $validationErrors[] = $this->module->l('An unexpected error has occurred.');
            $validationErrors[] = $this->module->l('EXCEPTION: ' . $e->getMessage());
            $this->redirectAvailability($validationErrors);
        }
    }

    public function displayAjaxValidateRental()
    {
        $validationErrors = array();
        try {
            if (!$rental_details = Tools::getValue('rental_details')) {
                $validationErrors[] = $this->module->l('No rental details provided');
            }
            if (!count($validationErrors)) {
                $rental_details = Tools::jsonDecode($rental_details);
                if ($rental_details = ProductRentalRental::validateRental($rental_details)) {
                    $current_product = null;
                    foreach ($rental_details->products as $product) {
                        if ($product->active_product) {
                            $current_product = $product;
                            break;
                        }
                    }
                    $display_tax = !(Group::getPriceDisplayMethod(Group::getCurrent()->id));
                    $tpl = RojaFortyFiveProductRentalCore::getIncludedTemplate(
                        $this,
                        'booking-page-totals.tpl'
                    );
                    $tpl->assign(
                        array(
                            'display_tax' => $display_tax,
                            'current_product_id' => Tools::getValue('current_product_id'),
                            'rental_details' => $rental_details,
                            'rental_valid' => $rental_details->rental_valid,
                            'has_vouchers' => ProductRentalVoucher::vouchersEnabled(),
                        )
                    );
                    $rental_details_html = $tpl->fetch();

                    $tpl = RojaFortyFiveProductRentalCore::getIncludedTemplate(
                        $this,
                        'booking-page-messages.tpl'
                    );
                    $tpl->assign(
                        array(
                            'rental_valid' => $rental_details->rental_valid,
                            'rental_details' => $rental_details,
                        )
                    );
                    $rental_messages_html = $tpl->fetch();

                    $json = Tools::jsonEncode(array(
                        'result' => 1,
                        'rental_details' => $rental_details,
                        'current_product' => $current_product,
                        'rental_details_html' => $rental_details_html,
                        'rental_messages_html' => $rental_messages_html,
                        'rental_valid' => $rental_details->rental_valid,
                    ));
                    die($json);
                } else {
                    $validationErrors[] = 'Error';
                    $json = Tools::jsonEncode(array(
                        'result' => 0,
                    ));
                    die($json);
                }
            } else {
                throw new Exception($this->module->l('Validation errors'));
            }
        } catch (Exception $e) {
            $validationErrors[] = $this->module->l('An unexpected error has occurred.');
            $validationErrors[] = $e->getMessage();
            $json = Tools::jsonEncode(array(
                'result' => 0,
                'errors' => $validationErrors,
                'exception' => $e,
            ));
            die($json);
        }
    }

    public function displayAjaxGetDailyRateDetails()
    {
        $validationErrors = array();
        try {
            if (!count($validationErrors)) {
                if ($periods = ProductRentalRental::getDailyRateDetails(
                    Tools::getValue('collection_date'),
                    Tools::getValue('collection_time'),
                    Tools::getValue('return_date'),
                    Tools::getValue('return_time'),
                    Tools::getValue('id_roja45_product'),
                    Tools::getValue('id_roja45_product_rate'),
                    Tools::getValue('selected_qty')
                )) {
                    $tpl = RojaFortyFiveProductRentalCore::getIncludedTemplate(
                        $this,
                        'booking-page-rate-details.tpl'
                    );
                    $tpl->assign(
                        array(
                            'periods' => $periods,
                        )
                    );
                    $html = $tpl->fetch();

                    $json = Tools::jsonEncode(array(
                        'result' => 1,
                        'html' => $html,
                    ));
                    die($json);
                } else {
                    $validationErrors[] = 'Error';
                    $json = Tools::jsonEncode(array(
                        'result' => 0,
                    ));
                    die($json);
                }
            } else {
                throw new Exception($this->module->l('Validation errors'));
            }
        } catch (Exception $e) {
            $validationErrors[] = $this->module->l('An unexpected error has occurred.');
            $validationErrors[] = $e->getMessage();
            $json = Tools::jsonEncode(array(
                'result' => 0,
                'errors' => $validationErrors,
                'exception' => $e,
            ));
            die($json);
        }
    }

    public function displayAjaxGetLivePrice()
    {
        $validationErrors = array();
        try {
            if (!$rental_details= Tools::getValue('rental_details')) {
                $validationErrors[] = $this->module->l('No rental details provided');
            }
            if (!count($validationErrors)) {
                $rental_details = Tools::jsonDecode($rental_details);
                if (empty($rental_details->products[0]->collection_time)) {
                    $rental_details->products[0]->collection_time = Configuration::get(
                        'ROJA45_PRODUCTRENTAL_COLLECTIONTIME'
                    );
                }
                if (empty($rental_details->products[0]->return_time)) {
                    $rental_details->products[0]->return_time  = Configuration::get('ROJA45_PRODUCTRENTAL_COLLECTIONTIME');
                }
                if ($rental_details->products[0]->collection_date && $rental_details->products[0]->return_date) {
                    $rental_product = new ProductRentalDetails(
                        ProductRentalDetails::isRentable($rental_details->products[0]->id_product)
                    );
                    $rental_product_model = ProductRentalModel::getProductModel(
                        $rental_product->id_roja45_product,
                        $rental_details->products[0]->id_product_attribute
                    );
                    $rental_details->products[0]->id_roja45_product = $rental_product->id_roja45_product;

                    $groups = null;
                    if (isset($this->context->customer)) {
                        $groups = Customer::getGroupsStatic((int)$this->context->customer->id);
                    }
                    $rates = ProductRentalRate::getRates(
                        $rental_product->id_roja45_product,
                        $rental_product_model,
                        (int)$this->context->language->id,
                        $groups,
                        $rental_details->id_roja45_product_rateduration
                    );

                    $selected_rate = array_values($rates)[0];

                    $extras = ProductRentalModelExtra::getExtrasForModel(
                        $rental_product_model,
                        $this->context->language->id
                    );

                    $rate_duration = new ProductRentalRateDuration($selected_rate['id_roja45_product_rateduration']);
                    $periods = $rate_duration->getPeriods(
                        $rental_details->products[0]->collection_date . ' ' . $rental_details->products[0]->collection_time.':00',
                        $rental_details->products[0]->return_date . ' ' . $rental_details->products[0]->return_time.':00',
                        $this->context->language->date_format_lite . ' H:s:i'
                    );

                    $periods = ProductRentalPriceRule::processPriceRules(
                        $rental_product->id_roja45_product,
                        $periods
                    );

                    $model = array(
                        'id_roja45_product_rental_model' => $rental_product_model,
                        'id_product_attribute' => $rental_details->products[0]->id_product_attribute,
                        'id_roja45_product_rateduration' => ProductRentalRateDuration::DAILY,
                        'collection_date' => $rental_details->products[0]->collection_date,
                        'collection_time' => $rental_details->products[0]->collection_time.':00',
                        'return_date' => $rental_details->products[0]->return_date,
                        'return_time' => $rental_details->products[0]->return_time.':00',
                        'number_of_periods' => count($periods),
                        'rates' => array(),
                    );


                    $rate = array(
                        'id_roja45_product_rate' => $selected_rate['id_roja45_product_rate'],
                        'qty' => $rental_details->products[0]->qty,
                        'periods' => (object) $periods
                    );
                    $model['rates'][] = (object) $rate;
                    $rental_details->products[0]->models[] = (object) $model;

                    if ($rental_details = ProductRentalRental::validateRental($rental_details)) {
                        $display_tax = !(Group::getPriceDisplayMethod(Group::getCurrent()->id));
                        $tpl = RojaFortyFiveProductRentalCore::getIncludedTemplate($this, 'live-price-block.tpl');
                        $tpl->assign(
                            array(
                                'display_tax' => $display_tax,
                                'number_rates' => count($rates),
                                'number_extras' => count($extras),
                                'rental_details' => $rental_details,
                                'currency' => $this->context->currency,
                            )
                        );
                        $rental_details_html = $tpl->fetch();

                        $json = Tools::jsonEncode(array(
                            'result' => 1,
                            'rental_details' => $rental_details,
                            'view' => $rental_details_html,
                        ));
                        die($json);
                    } else {
                        $validationErrors[] = 'Error';
                        $json = Tools::jsonEncode(array(
                            'result' => 0,
                        ));
                        die($json);
                    }
                }

                $json = Tools::jsonEncode(array(
                    'result' => 0,
                ));
                die($json);
            } else {
                throw new Exception($this->module->l('Validation errors'));
            }
        } catch (Exception $e) {
            $validationErrors[] = $this->module->l('An unexpected error has occurred.');
            $validationErrors[] = $e->getMessage();
            $json = Tools::jsonEncode(array(
                'result' => 0,
                'errors' => $validationErrors,
                'exception' => $e,
            ));
            die($json);
        }
    }

    public function displayAjaxGetCalendar()
    {
        $validationErrors = array();

        if (!$id_roja45_product = Tools::getValue('id_roja45_product')) {
            $validationErrors[] = $this->module->l('No rental product id provided');
        }
        if (!count($validationErrors)) {
            try {
                $rentals = ProductRentalRental::getRentalsForProduct($id_roja45_product);
                $unavailables = ProductUnavailable::getAllUnavailable($id_roja45_product);

                $rental = new ProductRentalDetails($id_roja45_product);
                $stock_on_hand = $rental->getCombinationStockOnHand();

                die(Tools::jsonEncode(array()));
            } catch (Exception $e) {
                $validationErrors = array();
                $validationErrors[] = $e->getMessage();
                $json = Tools::jsonEncode(array(
                    'result' => false,
                    'errors' => $validationErrors,
                    'exception' => $e,
                ));
                die($json);
            }
        } else {
            $validationErrors[] = $this->module->l(
                'Unable to get product rentals.  Function validation errors',
                'AdminProductRentals'
            );
            die(Tools::jsonEncode(array(
                'result' => 'error',
                'errors' => $validationErrors,
            )));
        }
    }

    public function displayAjaxLoadProductPageCalendar()
    {
        $validationErrors = array();

        if (!$id_roja45_product = Tools::getValue('id_roja45_product')) {
            $validationErrors[] = $this->module->l('No rental product id provided');
        }
        if (!count($validationErrors)) {
            try {
                $rental_product = new ProductRentalDetails($id_roja45_product);
                $product = new Product($rental_product->id_product, false, $this->context->language->id);
                $start_date = Tools::getValue('start_date');
                if (!$start_date) {
                    if ($start_date = Context::getContext()->cookie->__get('ROJA45_PRODUCTRENTAL_CALENDARSTARTDATE')) {
                        $start_date = new DateTime($start_date);
                    } else {
                        $start_date = new DateTime(date('Y-m-d'));
                    }
                } else {
                    $start_date = new DateTime(Tools::getValue('start_date'));
                }
                $offset = Tools::getValue('offset');
                switch ($offset) {
                    case -1:
                        $start_date->sub(new DateInterval('P1M'));
                        break;
                    case 0:
                        //$start_date->add(new DateInterval('P' . $offset . 'D'));
                        break;
                    case 1:
                        $start_date->add(new DateInterval('P1M'));
                        break;
                }
                Context::getContext()->cookie->__set(
                    'ROJA45_PRODUCTRENTAL_CALENDARSTARTDATE',
                    $start_date->format('Y-m-d')
                );

                $month_dates = RojaFortyFiveProductRentalCore::createDateRangeArray(
                    $start_date,
                    31
                );

                $models = ProductRentalModel::getModels($id_roja45_product);
                $rental_data = array();
                $models_data = array();
                foreach ($models as $model) {
                    $model = new ProductRentalModel(
                        $model['id_roja45_product_model'],
                        $this->context->language->id
                    );
                    $rates = ProductRentalRate::getRates(
                        $id_roja45_product,
                        $model->id_roja45_product_model,
                        (int) $this->context->language->id
                    );
                    $custom_rates = $model->getCustomRates($this->context->language->id);
                    $models_data[] = array(
                        'id_roja45_product_model' => $model->id_roja45_product_model,
                        'available' => ProductRentalDetails::getStockOnHand(
                            $id_roja45_product,
                            $model->id_roja45_product_model
                        ),
                        'name' => $model->getModelName($this->context->language->id),
                        'unavailable' => 0,
                        'total' => 0,
                        'rates' => $rates,
                        'custom_rates' => $custom_rates,
                    );
                }
                $rental_data['models'] = $models_data;

                $rentals = ProductRentalRental::getRentalsForDateRange(
                    $month_dates[0]['date'] . ' 00:00:00',
                    $month_dates[count($month_dates)-1]['date']  . ' 00:00:00',
                    $this->context->language->id,
                    null,
                    $id_roja45_product
                );
                $unavailables = ProductUnavailable::getUnavailable($id_roja45_product);
                $tpl = RojaFortyFiveProductRentalCore::getIncludedTemplate($this, 'product_page_availability.tpl');
                $tpl->assign(array(
                    'roja45_productrental_dateformat' => RojaFortyFiveProductRentalCore::convertDateFormat(
                        $this->context->language->date_format_lite
                    ),
                    'name' => $product->name,
                    'id_roja45_product' => $id_roja45_product,
                    'rental_data' => $rental_data,
                    'dates' => $month_dates,
                    'start_date' => $month_dates[0]['date'],
                    'period' => 31,
                    'end_date' => $month_dates[30]['date'],
                    'days' => 31,
                    'rentals' => $rentals,
                    'unavailables' => $unavailables,
                ));
                $content = $tpl->fetch();
                die(Tools::jsonEncode(array(
                    'result' => 1,
                    'view' => $content,
                )));
            } catch (Exception $e) {
                $validationErrors = array();
                $validationErrors[] = $e->getMessage();
                $json = Tools::jsonEncode(array(
                    'result' => false,
                    'errors' => $validationErrors,
                    'exception' => $e,
                ));
                die($json);
            }
        } else {
            $validationErrors[] = $this->module->l(
                'Unable to get product rentals.  Function validation errors',
                'AdminProductRentals'
            );
            die(Tools::jsonEncode(array(
                'result' => 'error',
                'errors' => $validationErrors,
            )));
        }
    }

    private function populateCart($rental)
    {
        $id_roja45_product_rental_payment = RojaFortyFiveProductRentalCore::getCustomerRequirement('ROJA45_PRODUCTRENTAL_ID_RENTAL_PAYMENT');
        $product_rental_payment = new ProductRentalRentalPayment($id_roja45_product_rental_payment);
        $product_rental_payment->id_roja45_product_rental = $rental->id;
        $product_rental_payment->id_roja45_product_payment_type = ProductRentalPaymentType::DEPOSIT;
        $product_rental_payment->payment_due = 0;
        $product_rental_payment->id_currency = $rental->id_currency;
        $product_rental_payment->requested = 1;
        $product_rental_payment->date_requested = date('Y-m-d H:i:s');
        $product_rental_payment->save();

        RojaFortyFiveProductRentalCore::saveCustomerRequirement('ROJA45_PRODUCTRENTAL_ID_RENTAL_PAYMENT', $product_rental_payment->id);

        $rental->cod = 0;
        if ((int) Tools::getValue('enable_cod')) {
            $rental->cod = 1;
            foreach ($rental->getProducts() as $rental_product) {
                $rental_product = new ProductRentalRentalProduct($rental_product['id_roja45_product_rental_product']);
                $rental_product->id_paymentprofile = (int) Configuration::get('ROJA45_PRODUCTRENTAL_COD_PAYMENT');
                $rental_product->save();
            }
            $rental->save();
        }

        $rental_object = Tools::jsonDecode($rental->toJSON($this->context->language->id));
        $rental_object = ProductRentalRental::validateRental($rental_object);
        foreach ($rental_object->products as $rental_product) {
            //SpecificPrice::deleteByProductId($rental_product->id_product);
            foreach ($rental_product->models as $model) {
                RojaFortyFiveProductRentalCore::deleteCustomerCartProductSpecificPrice(
                    (int)$this->context->customer->id,
                    (int)$this->context->cart->id,
                    $rental_product->id_product,
                    $model->id_product_attribute
                );
                $this->cleanCart($rental_product->id_product, $model->id_product_attribute);
                if ($model->total_to_pay_model > 0) {
                    $total_to_pay = (float) $model->total_to_pay_model / (int)$model->number_of_models;
                } else {
                    $total_to_pay = 0;
                }

                $specific_price = new SpecificPrice();
                $specific_price->id_shop = $this->context->shop->id;
                $specific_price->id_shop_group = $this->context->shop->id_shop_group;
                $specific_price->id_currency = 0;
                $specific_price->id_country = 0;
                $specific_price->id_group = 0;
                $specific_price->id_cart = (int) $this->context->cart->id;
                $specific_price->id_customer = (int)$this->context->customer->id;
                $specific_price->id_product = $rental_product->id_product;
                $specific_price->id_product_attribute = $model->id_product_attribute;
                $specific_price->price = $total_to_pay;
                $specific_price->from_quantity = 1;
                $specific_price->reduction = 0;
                $specific_price->reduction_type = 'amount';
                $specific_price->reduction_tax = 0;
                $specific_price->from = '0000-00-00 00:00:00';
                $specific_price->to = '0000-00-00 00:00:00';
                if ($specific_price->save()) {
                    $in_cart = $this->context->cart->updateQty(
                        $model->number_of_models,
                        $rental_product->id_product,
                        $model->id_product_attribute
                    );

                    if ($id_roja45_product_rental_payment_item = ProductRentalRentalPaymentItem::exists(
                        $product_rental_payment->id,
                        $rental_product->id_product,
                        $model->id_product_attribute
                    )) {
                        $product_rental_payment_item = new ProductRentalRentalPaymentItem($id_roja45_product_rental_payment_item);
                    } else {
                        $product_rental_payment_item = new ProductRentalRentalPaymentItem();
                    }

                    $product_rental_payment_item->id_roja45_product_rental_payment = $product_rental_payment->id;
                    $product_rental_payment_item->id_product = $rental_product->id_product;
                    $product_rental_payment_item->id_product_attribute = $model->id_product_attribute;
                    $product_rental_payment_item->total_paid = $model->total_to_pay_model;
                    $product_rental_payment_item->save();
                } else {
                    throw new Exception($this->module->l('Unable to create cart specific price:') . '['. Db::getInstance()->getMsgError() .']');
                }
            }
        }
        $id_product_deposit = Configuration::get('ROJA45_PRODUCTRENTAL_IDPRODUCTDEPOSIT');
        if ((int) Configuration::get('ROJA45_PRODUCTRENTAL_ENABLEPRODUCTDEPOSIT') &&
            $id_product_deposit &&
            ($rental_object->total_damage_deposit_exc > 0)
        ) {
            $this->context->cart->deleteProduct($id_product_deposit, 0);
            //SpecificPrice::deleteByProductId($id_product_deposit);
            if (!RojaFortyFiveProductRentalCore::deleteCustomerCartProductSpecificPrice(
                (int)$this->context->customer->id,
                (int)$this->context->cart->id,
                $id_product_deposit,
                null
            )) {
                throw new Exception($this->module->l('Unable to delete cart damage deposit price:') . '['. Db::getInstance()->getMsgError() .']');
            }
            $specific_price = new SpecificPrice();
            $specific_price->id_shop = $this->context->shop->id;
            $specific_price->id_shop_group = $this->context->shop->id_shop_group;
            $specific_price->id_currency = 0;
            $specific_price->id_country = 0;
            $specific_price->id_group = 0;
            $specific_price->id_cart = (int) $this->context->cart->id;
            $specific_price->id_customer = (int)$this->context->customer->id;
            $specific_price->id_product = $id_product_deposit;
            $specific_price->id_product_attribute = null;
            $specific_price->price = (float) $rental_object->total_damage_deposit_exc;
            $specific_price->from_quantity = 1;
            $specific_price->reduction = 0;
            $specific_price->reduction_type = 'amount';
            $specific_price->reduction_tax = 0;
            $specific_price->from = '0000-00-00 00:00:00';
            $specific_price->to = '0000-00-00 00:00:00';
            if ($specific_price->save()) {
                $this->context->cart->updateQty(
                    1,
                    $id_product_deposit,
                    null
                );
            } else {
                throw new Exception($this->module->l('Unable to create cart specific price:') . '['. Db::getInstance()->getMsgError() .']');
            }
        }
        return true;
    }

    private function sortByRateValue($x, $y)
    {
        return $x['rate'] - $y['rate'];
    }

    private function redirectAvailability($errors)
    {
        $this->errors = $errors;
        $this->processSubmitGetAvailability();
    }

    private function cleanCart($id_product, $id_product_attribute)
    {
        $this->context->cart->deleteProduct($id_product, $id_product_attribute, null, 0);
    }
}
