<?php
/**
 * roja45productrentalProductRentalSearchModuleFrontController.
 *
 * @author    Roja45
 * @copyright 2016 Roja45
 * @license   license.txt
 * @category  roja45productrentalProductRentalSearchModuleFrontController
 *
 * 2016 ROJA45 - All rights reserved.
 *
 * DISCLAIMER
 * Changing this file will render any support provided by us null and void.
 */

/**
 * roja45productrentalProductRentalSearchModuleFrontController.
 *
 * @author    Roja45
 * @copyright 2016 Roja45
 * @license   license.txt
 * @category  Class
 *
 * 2016 ROJA45 - All rights reserved.
 *
 * DISCLAIMER
 * Changing this file will render any support provided by us null and void.
 */

class roja45productrentalProductRentalSearchModuleFrontController extends ModuleFrontController
{
    public function postProcess()
    {
        if (Tools::getValue('search')) {
            $this->processSearch();
        } else {
            return parent::postProcess();
        }
    }

    public function initContent()
    {
        parent::initContent();
        if (count($this->errors)) {
            $this->processGetAvailability();
        }
    }

    public function processSearch()
    {
        $this->display_column_left = true;
        $id_category = Tools::getValue(
            'id_category',
            Configuration::get('ROJA45_PRODUCTRENTAL_SEARCHCATEGORY') ?
                Configuration::get('ROJA45_PRODUCTRENTAL_SEARCHCATEGORY') :
                Configuration::get('PS_HOME_CATEGORY')
        );
        $category = new Category($id_category, $this->context->language->id, $this->context->shop->id);

        $this->page_name = 'category';
        $product_per_page = isset($this->context->cookie->nb_item_per_page) ?
            (int)$this->context->cookie->nb_item_per_page :
            Configuration::get('PS_PRODUCTS_PER_PAGE');

        $requirements = array();
        $collection = null;
        if (!$collection_date = Tools::getValue('ROJA45_PRODUCTRENTAL_COLLECTION_DATE')) {
            $collection = RojaFortyFiveProductRentalCore::getCustomerRequirement('ROJA45_PRODUCTRENTAL_COLLECTION_DATE');
        }
        if (!$collection) {
            $collection = DateTime::createFromFormat(
                $this->context->language->date_format_lite,
                $collection_date
            );
            $collection = $collection->format('Y-m-d');
        }

        if (!$collection_time = Tools::getValue('ROJA45_PRODUCTRENTAL_COLLECTION_TIME')) {
            $collection_time = RojaFortyFiveProductRentalCore::getCustomerRequirement('ROJA45_PRODUCTRENTAL_COLLECTION_TIME');
        }

        $return = null;
        if (!$return_date = Tools::getValue('ROJA45_PRODUCTRENTAL_RETURN_DATE')) {
            $return = RojaFortyFiveProductRentalCore::getCustomerRequirement('ROJA45_PRODUCTRENTAL_RETURN_DATE');
        }
        if (!$return) {
            $return = DateTime::createFromFormat(
                $this->context->language->date_format_lite,
                $return_date
            );
            $return = $return->format('Y-m-d');
        }

        if (!$return_time = Tools::getValue('ROJA45_PRODUCTRENTAL_RETURN_TIME')) {
            $return_time = RojaFortyFiveProductRentalCore::getCustomerRequirement('ROJA45_PRODUCTRENTAL_RETURN_TIME');
        }

        $requirements['ROJA45_PRODUCTRENTAL_RATE_DURATION'] = Tools::getValue('ROJA45_PRODUCTRENTAL_RATE_DURATION');
        $requirements['ROJA45_PRODUCTRENTAL_COLLECTION_DATE'] = $collection;
        $requirements['ROJA45_PRODUCTRENTAL_COLLECTION_TIME'] = $collection_time;
        $requirements['ROJA45_PRODUCTRENTAL_RETURN_DATE'] = $return;
        $requirements['ROJA45_PRODUCTRENTAL_RETURN_TIME'] = $return_time;
        $requirements['ROJA45_PRODUCTRENTAL_REQUESTED_QTY'] = Tools::getValue(
            'ROJA45_PRODUCTRENTAL_REQUESTED_QTY'
        );
        $requirements['id_category'] = $id_category;

        RojaFortyFiveProductRentalCore::saveCustomerRequirements($requirements);

        $search_controller_url = $this->context->link->getModuleLink(
            'roja45productrental',
            'ProductRentalSearch',
            array(
                'token' => Tools::getToken(),
                'search' => 1,
                'ROJA45_PRODUCTRENTAL_RATE_DURATION' => Tools::getValue('ROJA45_PRODUCTRENTAL_RATE_DURATION'),
                'ROJA45_PRODUCTRENTAL_REQUESTED_QTY' => Tools::getValue(
                    'ROJA45_PRODUCTRENTAL_REQUESTED_QTY'
                ),
            ),
            true
        );

        $availability_controller_url = $this->context->link->getModuleLink(
            'roja45productrental',
            'ProductRentalFront',
            array(
                'getAvailability' => 1,
                'qty' => 1,
                'ROJA45_PRODUCTRENTAL_QTY' => 1,
                'ROJA45_PRODUCTRENTAL_RATE_DURATION' => Tools::getValue('ROJA45_PRODUCTRENTAL_RATE_DURATION'),
            )
        );

        $this->context->smarty->assign(array(
            'link' => $this->context->link,
            'token_cart' => Tools::getToken(false),
            'roja45_availability_controller_url' => $availability_controller_url,
            'roja45_search_controller_url' => $search_controller_url,
        ));

        $this->productSort();
        $this->n = abs((int)(Tools::getValue('n', $product_per_page)));
        $this->p = abs((int)(Tools::getValue('p', 1)));

        $search = ProductRentalDetails::search(
            $this->context->language->id,
            $requirements,
            $this->p,
            $this->n,
            $this->orderBy,
            $this->orderWay,
            false,
            true
        );
        $nbResults = $search['total'];
        $this->pagination($nbResults);

        $this->template = _PS_THEME_DIR_ . 'category.tpl';
        if (isset($this->context->cookie->id_compare)) {
            $this->context->smarty->assign(array(
                'compareProducts' => CompareProduct::getCompareProducts((int)$this->context->cookie->id_compare)
            ));
        }

        foreach ($search['result'] as &$product) {
            $controller_url = $this->context->link->getModuleLink(
                'roja45productrental',
                'ProductRentalFront',
                array(
                    'getAvailability' => 1,
                    'ROJA45_PRODUCTRENTAL_ID_PRODUCT' => $product['id_product'],
                    'ROJA45_PRODUCTRENTAL_ID_PRODUCT_ATTRIBUTE' => $product['id_product_attribute'],
                    'qty' => 1,
                    'ROJA45_PRODUCTRENTAL_QTY' => 1,
                    'ROJA45_PRODUCTRENTAL_RATE_DURATION' => Tools::getValue('ROJA45_PRODUCTRENTAL_RATE_DURATION'),
                )
            );
            $product['availability_url'] = $controller_url;
            if ((int) Configuration::get('ROJA45_PRODUCTRENTAL_RESULTTOAVAILABLE')) {
                $product['link'] = $controller_url;
            }
        }

        if (!(int) Configuration::get('ROJA45_PRODUCTRENTAL_SHOWWHENSINGLE')) {
            if (count($search['result']) == 1) {
                $controller_url = $this->context->link->getModuleLink(
                    'roja45productrental',
                    'ProductRentalFront',
                    array(
                        'getAvailability' => 1,
                        'ROJA45_PRODUCTRENTAL_ID_PRODUCT' => $search['result'][0]['id_product'],
                        'ROJA45_PRODUCTRENTAL_ID_PRODUCT_ATTRIBUTE' => $search['result'][0]['id_product_attribute'],
                        'qty' => 1,
                        'ROJA45_PRODUCTRENTAL_RATE_DURATION' => Tools::getValue('ROJA45_PRODUCTRENTAL_RATE_DURATION'),
                    )
                );
                Tools::redirect($controller_url);
            }
        }
        $this->assignScenes($category);
        $this->assignSubcategories($category);
        $this->context->smarty->assign(array(
            'request' => $search_controller_url,
            'nobots' => true,
            'nofollow' => true,
            'category' => $category,
            'description_short' => Tools::truncateString($category->description, 350),
            'products' => $search['result'],
            'page_name' => $this->page_name,
            'nbProducts' => $search['total'],
            'id_category' => (int)$category->id,
            'id_category_parent' => (int)$category->id_parent,
            'return_category_name' => Tools::safeOutput($category->name),
            'path' => Tools::getPath($category->id),
            'add_prod_display' => Configuration::get('PS_ATTRIBUTE_CATEGORY_DISPLAY'),
            'categorySize' => Image::getSize(ImageType::getFormatedName('category')),
            'mediumSize' => Image::getSize(ImageType::getFormatedName('medium')),
            'thumbSceneSize' => Image::getSize(ImageType::getFormatedName('m_scene')),
            'homeSize' => Image::getSize(ImageType::getFormatedName('home')),
            'allow_oosp' => (int)Configuration::get('PS_ORDER_OUT_OF_STOCK'),
            'comparator_max_item' => (int)Configuration::get('PS_COMPARATOR_MAX_ITEM'),
            'suppliers' => Supplier::getSuppliers(),
            'body_classes' => array(
                $this->php_self . '-' . $category->id,
                $this->php_self . '-' . $category->link_rewrite
            )
        ));
    }

    protected function assignSubcategories($category)
    {
        if ($sub_categories = $category->getSubCategories($this->context->language->id)) {
            $this->context->smarty->assign(array(
                'subcategories' => $sub_categories,
                'subcategories_nb_total' => count($sub_categories),
                'subcategories_nb_half' => ceil(count($sub_categories) / 2)
            ));
        }
    }

    protected function assignScenes($category)
    {
        // Scenes (could be externalised to another controller if you need them)
        $scenes = Scene::getScenes($category->id, $this->context->language->id, true, false);
        $this->context->smarty->assign('scenes', $scenes);

        // Scenes images formats
        if ($scenes && ($scene_image_types = ImageType::getImagesTypes('scenes'))) {
            foreach ($scene_image_types as $scene_image_type) {
                if ($scene_image_type['name'] == ImageType::getFormatedName('m_scene')) {
                    $thumb_scene_image_type = $scene_image_type;
                } elseif ($scene_image_type['name'] == ImageType::getFormatedName('scene')) {
                    $large_scene_image_type = $scene_image_type;
                }
            }

            $this->context->smarty->assign(array(
                'thumbSceneImageType' => isset($thumb_scene_image_type) ? $thumb_scene_image_type : null,
                'largeSceneImageType' => isset($large_scene_image_type) ? $large_scene_image_type : null,
            ));
        }
    }

    public function setMedia($isNewTheme = false)
    {
        parent::setMedia($isNewTheme);
        if (Tools::getValue('search')) {
            if (version_compare(_PS_VERSION_, '1.7', '<') == true) {
                if (!$this->useMobileTheme()) {
                    //TODO : check why cluetip css is include without js file
                    $this->addCSS(array(
                        _THEME_CSS_DIR_.'scenes.css'       => 'all',
                        _THEME_CSS_DIR_.'category.css'     => 'all',
                        _THEME_CSS_DIR_.'product_list.css' => 'all',
                    ));
                }
                $scenes = Scene::getScenes(
                    Tools::getValue('id_category'),
                    $this->context->language->id,
                    true,
                    false
                );
                if ($scenes && count($scenes)) {
                    $this->addJS(_THEME_JS_DIR_.'scenes.js');
                    $this->addJqueryPlugin(array('scrollTo', 'serialScroll'));
                }

                $this->addJS(_THEME_JS_DIR_.'category.js');
            }
        }
    }
}
